/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.views;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.tmf.ui.colors.ColorUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeLinkEvent;

class StubPresentationProvider
extends TimeGraphPresentationProvider {
    private static final @NonNull String MARKER_COLOR_HEX = ColorUtils.toHexColor((int)160, (int)170, (int)200);
    private static final float OPACITY = 0.3137255f;
    private static final List<StateItem> SYMBOLS = Arrays.asList(new StateItem((Map)ImmutableMap.of((Object)"symbol-type", (Object)"diamond", (Object)"color", (Object)MARKER_COLOR_HEX, (Object)"opacity", (Object)Float.valueOf(0.3137255f), (Object)"height", (Object)Float.valueOf(1.0f))), new StateItem((Map)ImmutableMap.of((Object)"symbol-type", (Object)"circle", (Object)"color", (Object)MARKER_COLOR_HEX, (Object)"opacity", (Object)Float.valueOf(0.3137255f), (Object)"height", (Object)Float.valueOf(1.0f))), new StateItem((Map)ImmutableMap.of((Object)"symbol-type", (Object)"square", (Object)"color", (Object)MARKER_COLOR_HEX, (Object)"opacity", (Object)Float.valueOf(0.3137255f), (Object)"height", (Object)Float.valueOf(1.0f))), new StateItem((Map)ImmutableMap.of((Object)"symbol-type", (Object)"triangle", (Object)"color", (Object)MARKER_COLOR_HEX, (Object)"opacity", (Object)Float.valueOf(0.3137255f), (Object)"height", (Object)Float.valueOf(1.0f))), new StateItem((Map)ImmutableMap.of((Object)"symbol-type", (Object)"inverted-triangle", (Object)"color", (Object)MARKER_COLOR_HEX, (Object)"opacity", (Object)Float.valueOf(0.3137255f), (Object)"height", (Object)Float.valueOf(1.0f))), new StateItem((Map)ImmutableMap.of((Object)"symbol-type", (Object)"cross", (Object)"color", (Object)MARKER_COLOR_HEX, (Object)"opacity", (Object)Float.valueOf(0.3137255f), (Object)"height", (Object)Float.valueOf(1.0f))), new StateItem((Map)ImmutableMap.of((Object)"symbol-type", (Object)"plus", (Object)"color", (Object)MARKER_COLOR_HEX, (Object)"opacity", (Object)Float.valueOf(0.3137255f), (Object)"height", (Object)Float.valueOf(1.0f))));
    private static final StateItem LASER = new StateItem((Map)ImmutableMap.of((Object)"style-name", (Object)"\"LASER\"", (Object)"height", (Object)Float.valueOf(0.1f), (Object)"background-color", (Object)"#ff0000", (Object)"color", (Object)"#ff0000"));
    private static final StateItem PULSE = new StateItem((Map)ImmutableMap.of((Object)"style-name", (Object)"PULSE"));
    public static final StateItem[] STATES = new StateItem[]{new StateItem(new RGB(0, 255, 0), "HAT"), new StateItem(new RGB(128, 192, 255), "SKIN"), new StateItem(new RGB(0, 64, 128), "HAIR"), new StateItem(new RGB(0, 0, 255), "EYE"), new StateItem(new RGB(255, 64, 128), "PUCK"), LASER, PULSE};

    StubPresentationProvider() {
    }

    public String getPreferenceKey() {
        return "Stub";
    }

    public StateItem[] getStateTable() {
        return STATES;
    }

    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof TimeLinkEvent) {
            return 5;
        }
        if (event.getEntry() != null && ITimeGraphEntry.DisplayStyle.LINE.equals((Object)event.getEntry().getStyle())) {
            return 6;
        }
        if (event instanceof TimeEvent) {
            return ((TimeEvent)event).getValue();
        }
        return -1;
    }

    public int getItemHeight(ITimeGraphEntry entry) {
        int itemHeight = super.getItemHeight(entry);
        return entry.getParent() == null ? itemHeight + 3 : itemHeight;
    }

    public Map<String, Object> getSpecificEventStyle(ITimeEvent event) {
        if (event instanceof MarkerEvent && event.getDuration() == 0L) {
            MarkerEvent markerEvent = (MarkerEvent)event;
            int value = markerEvent.getValue();
            return SYMBOLS.get(value).getStyleMap();
        }
        return super.getSpecificEventStyle(event);
    }
}

