/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace;

import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfTimestampLocation;
import org.junit.Assert;
import org.junit.Test;

public class TmfContextTest {
    private final Long aLong = 12345L;
    private final ITmfTimestamp aTimestamp = TmfTimestamp.fromSeconds((long)0L);
    private final TmfLongLocation fLocation1 = new TmfLongLocation(this.aLong);
    private final TmfTimestampLocation fLocation2 = new TmfTimestampLocation(this.aTimestamp);
    private final long fRank1 = 1L;
    private final long fRank2 = 2L;
    private final TmfContext fContext1 = new TmfContext((ITmfLocation)this.fLocation1, 1L);
    private final TmfContext fContext2 = new TmfContext((ITmfLocation)this.fLocation2, 2L);

    @Test
    public void testTmfContextDefault() {
        TmfContext context = new TmfContext();
        Assert.assertEquals((String)"getLocation", null, (Object)context.getLocation());
        Assert.assertEquals((String)"getRank", (long)-1L, (long)context.getRank());
    }

    @Test
    public void testTmfContextNoRank() {
        TmfContext context1 = new TmfContext((ITmfLocation)this.fLocation1);
        TmfContext context2 = new TmfContext((ITmfLocation)this.fLocation2);
        Assert.assertEquals((String)"getLocation", (Object)this.fLocation1, (Object)context1.getLocation());
        Assert.assertEquals((String)"getLocation", (Object)this.fLocation2, (Object)context2.getLocation());
        Assert.assertEquals((String)"getRank", (long)-1L, (long)context1.getRank());
        Assert.assertEquals((String)"getRank", (long)-1L, (long)context2.getRank());
    }

    @Test
    public void testTmfContext() {
        Assert.assertEquals((String)"getLocation", (Object)this.fLocation1, (Object)this.fContext1.getLocation());
        Assert.assertEquals((String)"getLocation", (Object)this.fLocation2, (Object)this.fContext2.getLocation());
        Assert.assertEquals((String)"getRank", (long)1L, (long)this.fContext1.getRank());
        Assert.assertEquals((String)"getRank", (long)2L, (long)this.fContext2.getRank());
    }

    @Test
    public void testTmfContextCopy() {
        TmfContext context1 = new TmfContext(this.fContext1);
        TmfContext context2 = new TmfContext(this.fContext2);
        Assert.assertEquals((String)"getLocation", (Object)this.fLocation1, (Object)context1.getLocation());
        Assert.assertEquals((String)"getLocation", (Object)this.fLocation2, (Object)context2.getLocation());
        Assert.assertEquals((String)"getRank", (long)1L, (long)context1.getRank());
        Assert.assertEquals((String)"getRank", (long)2L, (long)context2.getRank());
    }

    @Test
    public void testTmfContextCopy2() {
        try {
            new TmfContext(null);
            Assert.fail((String)"Copy constructor: no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            Assert.fail((String)"Copy constructor: wrong exception");
        }
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fContext1.equals((Object)this.fContext1));
        Assert.assertTrue((String)"equals", (boolean)this.fContext2.equals((Object)this.fContext2));
        Assert.assertFalse((String)"equals", (boolean)this.fContext1.equals((Object)this.fContext2));
        Assert.assertFalse((String)"equals", (boolean)this.fContext2.equals((Object)this.fContext1));
    }

    @Test
    public void testEqualsSymmetry() {
        TmfContext context1 = new TmfContext(this.fContext1);
        TmfContext context2 = new TmfContext(this.fContext2);
        Assert.assertTrue((String)"equals", (boolean)context1.equals((Object)this.fContext1));
        Assert.assertTrue((String)"equals", (boolean)this.fContext1.equals((Object)context1));
        Assert.assertTrue((String)"equals", (boolean)context2.equals((Object)this.fContext2));
        Assert.assertTrue((String)"equals", (boolean)this.fContext2.equals((Object)context2));
    }

    @Test
    public void testEqualsTransivity() {
        TmfContext context1 = new TmfContext(this.fContext1);
        TmfContext context2 = new TmfContext(context1);
        TmfContext context3 = new TmfContext(context2);
        Assert.assertTrue((String)"equals", (boolean)context1.equals((Object)context2));
        Assert.assertTrue((String)"equals", (boolean)context2.equals((Object)context3));
        Assert.assertTrue((String)"equals", (boolean)context1.equals((Object)context3));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertFalse((String)"equals", (boolean)this.fContext1.equals(null));
        Assert.assertFalse((String)"equals", (boolean)this.fContext2.equals(null));
    }

    @Test
    public void testNonEquals() {
        MyContext myContext = new MyContext();
        Assert.assertFalse((String)"equals", (boolean)this.fContext1.equals((Object)myContext));
        Assert.assertFalse((String)"equals", (boolean)myContext.equals(this.fContext1));
        TmfContext context1 = new TmfContext(this.fContext1);
        TmfContext context2 = new TmfContext(this.fContext1);
        context1.setLocation(null);
        context2.setLocation(null);
        Assert.assertFalse((String)"equals", (boolean)this.fContext1.equals((Object)context1));
        Assert.assertFalse((String)"equals", (boolean)context1.equals((Object)this.fContext1));
        Assert.assertTrue((String)"equals", (boolean)context1.equals((Object)context2));
        context1 = new TmfContext(this.fContext1);
        context2 = new TmfContext(this.fContext1);
        context1.setRank(this.fContext1.getRank() + 1L);
        context2.setRank(this.fContext1.getRank() + 2L);
        Assert.assertFalse((String)"equals", (boolean)this.fContext1.equals((Object)context1));
        Assert.assertFalse((String)"equals", (boolean)context1.equals((Object)this.fContext1));
        Assert.assertFalse((String)"equals", (boolean)context1.equals((Object)context2));
    }

    @Test
    public void testHashCode() {
        TmfContext context1 = new TmfContext(this.fContext1);
        TmfContext context2 = new TmfContext(this.fContext2);
        Assert.assertEquals((String)"hashCode", (long)this.fContext1.hashCode(), (long)context1.hashCode());
        Assert.assertEquals((String)"hashCode", (long)this.fContext2.hashCode(), (long)context2.hashCode());
        Assert.assertFalse((String)"hashCode", (this.fContext1.hashCode() == context2.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((String)"hashCode", (this.fContext2.hashCode() == context1.hashCode() ? 1 : 0) != 0);
        TmfContext nullContext1 = new TmfContext();
        TmfContext nullContext2 = new TmfContext(nullContext1);
        Assert.assertEquals((String)"hashCode", (long)nullContext1.hashCode(), (long)nullContext2.hashCode());
    }

    @Test
    public void testToString() {
        String expected1 = "TmfContext [fLocation=" + String.valueOf(this.fLocation1) + ", fRank=1]";
        String expected2 = "TmfContext [fLocation=" + String.valueOf(this.fLocation2) + ", fRank=2]";
        Assert.assertEquals((String)"toString", (Object)expected1, (Object)this.fContext1.toString());
        Assert.assertEquals((String)"toString", (Object)expected2, (Object)this.fContext2.toString());
    }

    @Test
    public void testSetLocation() {
        TmfContext context1 = new TmfContext(this.fContext1);
        context1.setLocation(this.fContext2.getLocation());
        Assert.assertEquals((String)"getLocation", (Object)this.fLocation2, (Object)context1.getLocation());
        Assert.assertEquals((String)"getRank", (long)1L, (long)context1.getRank());
    }

    @Test
    public void testSetRank() {
        TmfContext context1 = new TmfContext(this.fContext1);
        context1.setRank(this.fContext2.getRank());
        Assert.assertEquals((String)"getLocation", (Object)this.fLocation1, (Object)context1.getLocation());
        Assert.assertEquals((String)"getRank", (long)2L, (long)context1.getRank());
    }

    @Test
    public void testIncreaseRank() {
        TmfContext context1 = new TmfContext(this.fContext1);
        context1.increaseRank();
        Assert.assertEquals((String)"getRank", (long)2L, (long)context1.getRank());
        context1.increaseRank();
        Assert.assertEquals((String)"getRank", (long)3L, (long)context1.getRank());
        context1.setRank(-1L);
        context1.increaseRank();
        Assert.assertEquals((String)"getRank", (long)-1L, (long)context1.getRank());
        context1.increaseRank();
        Assert.assertEquals((String)"getRank", (long)-1L, (long)context1.getRank());
    }

    private static class MyContext
    extends TmfContext {
        private MyContext() {
        }
    }
}

