/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.tests.CallStackTestBase2;
import org.eclipse.tracecompass.analysis.profiling.core.tests.FlameDataProviderTestUtils;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs2.CallStackAnalysisStub;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.registry.LinuxStyle;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.FlameChartDataProvider;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.FlameChartDataProviderFactory;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.FlameChartEntryModel;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.annotations.Annotation;
import org.eclipse.tracecompass.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.junit.Assert;
import org.junit.Test;

public class FlameChartDataProviderTest
extends CallStackTestBase2 {
    private static final @Nullable IProgressMonitor MONITOR = new NullProgressMonitor();
    private static final String FOR_ENTRY = " for entry ";
    private static final String CALLSTACKIEVENTS_FILE = "testfiles/traces/callstackIevents.xml";

    public FlameChartDataProviderTest() {
        super(CALLSTACKIEVENTS_FILE);
    }

    private FlameChartDataProvider getDataProvider() {
        CallStackAnalysisStub module = this.getModule();
        Assert.assertNotNull((Object)((Object)module));
        FlameChartDataProviderFactory factory = new FlameChartDataProviderFactory();
        FlameChartDataProvider dataProvider = (FlameChartDataProvider)factory.createProvider(this.getTrace(), module.getId());
        Assert.assertNotNull((Object)dataProvider);
        return dataProvider;
    }

    @Test
    public void testGetDescriptors() {
        FlameChartDataProviderFactory dataProviderFactory = new FlameChartDataProviderFactory();
        Collection descriptors = dataProviderFactory.getDescriptors(this.getTrace());
        Assert.assertEquals((long)descriptors.size(), (long)1L);
        for (IDataProviderDescriptor descriptor : descriptors) {
            if (descriptor.getId().equals("org.eclipse.tracecompass.analysis.profiling.core.flamechart:org.eclipse.tracecompass.analysis.profiling.core.tests.stub")) {
                Assert.assertEquals((Object)"Test Callstack (new) - Flame Chart", (Object)descriptor.getName());
                Assert.assertEquals((Object)IDataProviderDescriptor.ProviderType.TIME_GRAPH, (Object)descriptor.getType());
                Assert.assertEquals((Object)"Show Flame Chart provided by Analysis module: Test Callstack (new)", (Object)descriptor.getDescription());
                continue;
            }
            Assert.fail((String)("Unknown Entry" + descriptor.getId()));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchTree() {
        FlameChartDataProvider dataProvider = this.getDataProvider();
        @NonNull @NonNull TmfModelResponse responseTree = dataProvider.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(0L, Long.MAX_VALUE, 2)), (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((responseTree.getStatus() == ITmfResponse.Status.COMPLETED ? 1 : 0) != 0);
        @NonNull TmfTreeModel model = (TmfTreeModel)responseTree.getModel();
        Assert.assertNotNull((Object)model);
        List modelEntries = model.getEntries();
        Assert.assertEquals((long)22L, (long)modelEntries.size());
        String traceName = this.getTrace().getName();
        for (FlameChartEntryModel entry : modelEntries) {
            FlameChartEntryModel parent = FlameDataProviderTestUtils.findEntryById(modelEntries, entry.getParentId());
            block0 : switch (entry.getEntryType()) {
                case LEVEL: {
                    Assert.assertNotNull((Object)parent);
                    switch (entry.getName()) {
                        case "1": {
                            Assert.assertEquals((Object)traceName, (Object)parent.getName());
                            break block0;
                        }
                        case "2": {
                            Assert.assertEquals((Object)"1", (Object)parent.getName());
                            break block0;
                        }
                        case "3": {
                            Assert.assertEquals((Object)"1", (Object)parent.getName());
                            break block0;
                        }
                        case "5": {
                            Assert.assertEquals((Object)traceName, (Object)parent.getName());
                            break block0;
                        }
                        case "6": {
                            Assert.assertEquals((Object)"5", (Object)parent.getName());
                            break block0;
                        }
                        case "7": {
                            Assert.assertEquals((Object)"5", (Object)parent.getName());
                            break block0;
                        }
                    }
                    Assert.fail((String)("Unknown entry " + entry.getName()));
                    break;
                }
                case FUNCTION: 
                case KERNEL: {
                    Assert.assertNotNull((Object)parent);
                    Assert.assertEquals((Object)FlameChartEntryModel.EntryType.LEVEL, (Object)parent.getEntryType());
                    break;
                }
                case TRACE: {
                    Assert.assertEquals((long)-1L, (long)entry.getParentId());
                    break;
                }
                default: {
                    Assert.fail((String)("Unknown entry " + String.valueOf(entry)));
                }
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchModel() {
        FlameChartDataProvider dataProvider = this.getDataProvider();
        @NonNull @NonNull TmfModelResponse responseTree = dataProvider.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(0L, Long.MAX_VALUE, 2)), (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((responseTree.getStatus() == ITmfResponse.Status.COMPLETED ? 1 : 0) != 0);
        @NonNull TmfTreeModel model = (TmfTreeModel)responseTree.getModel();
        Assert.assertNotNull((Object)model);
        List modelEntries = model.getEntries();
        HashSet<@NonNull Long> selectedIds = new HashSet<Long>();
        FlameChartEntryModel tid3 = FlameDataProviderTestUtils.findEntryByNameAndType(modelEntries, "3", FlameChartEntryModel.EntryType.LEVEL);
        Assert.assertNotNull((Object)tid3);
        selectedIds.add(tid3.getId());
        List<FlameChartEntryModel> tid3Children = FlameDataProviderTestUtils.findEntriesByParent(modelEntries, tid3.getId());
        Assert.assertEquals((long)3L, (long)tid3Children.size());
        tid3Children.forEach(child -> {
            boolean bl = selectedIds.add(child.getId());
        });
        FlameChartEntryModel pid5 = FlameDataProviderTestUtils.findEntryByNameAndType(modelEntries, "5", FlameChartEntryModel.EntryType.LEVEL);
        Assert.assertNotNull((Object)pid5);
        selectedIds.add(pid5.getId());
        FlameChartEntryModel tid6 = FlameDataProviderTestUtils.findEntryByNameAndType(modelEntries, "6", FlameChartEntryModel.EntryType.LEVEL);
        Assert.assertNotNull((Object)tid6);
        selectedIds.add(tid6.getId());
        List<FlameChartEntryModel> tid6Children = FlameDataProviderTestUtils.findEntriesByParent(modelEntries, tid6.getId());
        Assert.assertEquals((long)4L, (long)tid6Children.size());
        tid6Children.forEach(child -> {
            boolean bl = selectedIds.add(child.getId());
        });
        @NonNull TmfModelResponse rowResponse = dataProvider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(3L, 15L, 50, selectedIds)), (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)rowResponse.getStatus());
        TimeGraphModel rowModel = (TimeGraphModel)rowResponse.getModel();
        Assert.assertNotNull((Object)rowModel);
        @NonNull List rows = rowModel.getRows();
        Assert.assertEquals((long)10L, (long)rows.size());
        FlameChartDataProviderTest.verifyStates(rows, tid3, Collections.emptyList());
        FlameChartDataProviderTest.verifyStates(rows, pid5, Collections.emptyList());
        FlameChartDataProviderTest.verifyStates(rows, tid6, Collections.emptyList());
        FlameChartDataProviderTest.verifyStates(rows, FlameDataProviderTestUtils.findEntryByDepthAndType(tid3Children, 1, FlameChartEntryModel.EntryType.FUNCTION), (List<TimeGraphState>)ImmutableList.of((Object)new TimeGraphState(3L, 17L, Integer.MIN_VALUE, "op2")));
        FlameChartDataProviderTest.verifyStates(rows, FlameDataProviderTestUtils.findEntryByDepthAndType(tid3Children, 2, FlameChartEntryModel.EntryType.FUNCTION), (List<TimeGraphState>)ImmutableList.of((Object)new TimeGraphState(1L, 4L, Integer.MIN_VALUE), (Object)new TimeGraphState(5L, 1L, Integer.MIN_VALUE, "op3"), (Object)new TimeGraphState(6L, 1L, Integer.MIN_VALUE), (Object)new TimeGraphState(7L, 6L, Integer.MIN_VALUE, "op2"), (Object)new TimeGraphState(13L, 8L, Integer.MIN_VALUE)));
        FlameChartDataProviderTest.verifyStates(rows, FlameDataProviderTestUtils.findEntryByDepthAndType(tid3Children, -1, FlameChartEntryModel.EntryType.KERNEL), (List<TimeGraphState>)ImmutableList.of((Object)new TimeGraphState(3L, 3L, null, new OutputElementStyle(LinuxStyle.USERMODE.getLabel())), (Object)new TimeGraphState(6L, 1L, null, new OutputElementStyle(LinuxStyle.WAIT_FOR_CPU.getLabel())), (Object)new TimeGraphState(7L, 6L, null, new OutputElementStyle(LinuxStyle.USERMODE.getLabel())), (Object)new TimeGraphState(13L, 8L, null, new OutputElementStyle(LinuxStyle.WAIT_FOR_CPU.getLabel()))), true);
        FlameChartDataProviderTest.verifyStates(rows, FlameDataProviderTestUtils.findEntryByDepthAndType(tid6Children, 1, FlameChartEntryModel.EntryType.FUNCTION), (List<TimeGraphState>)ImmutableList.of((Object)new TimeGraphState(1L, 19L, Integer.MIN_VALUE, "op1")));
        FlameChartDataProviderTest.verifyStates(rows, FlameDataProviderTestUtils.findEntryByDepthAndType(tid6Children, 2, FlameChartEntryModel.EntryType.FUNCTION), (List<TimeGraphState>)ImmutableList.of((Object)new TimeGraphState(2L, 5L, Integer.MIN_VALUE, "op3"), (Object)new TimeGraphState(7L, 1L, Integer.MIN_VALUE), (Object)new TimeGraphState(8L, 3L, Integer.MIN_VALUE, "op2"), (Object)new TimeGraphState(11L, 1L, Integer.MIN_VALUE), (Object)new TimeGraphState(12L, 8L, Integer.MIN_VALUE, "op4")));
        FlameChartDataProviderTest.verifyStates(rows, FlameDataProviderTestUtils.findEntryByDepthAndType(tid6Children, 3, FlameChartEntryModel.EntryType.FUNCTION), (List<TimeGraphState>)ImmutableList.of((Object)new TimeGraphState(1L, 3L, Integer.MIN_VALUE), (Object)new TimeGraphState(4L, 2L, Integer.MIN_VALUE, "op1"), (Object)new TimeGraphState(6L, 3L, Integer.MIN_VALUE), (Object)new TimeGraphState(9L, 1L, Integer.MIN_VALUE, "op3"), (Object)new TimeGraphState(10L, 11L, Integer.MIN_VALUE)));
        FlameChartDataProviderTest.verifyStates(rows, FlameDataProviderTestUtils.findEntryByDepthAndType(tid6Children, -1, FlameChartEntryModel.EntryType.KERNEL), (List<TimeGraphState>)ImmutableList.of((Object)new TimeGraphState(1L, 5L, null, new OutputElementStyle(LinuxStyle.USERMODE.getLabel())), (Object)new TimeGraphState(6L, 2L, null, new OutputElementStyle(LinuxStyle.WAIT_FOR_CPU.getLabel())), (Object)new TimeGraphState(8L, 2L, null, new OutputElementStyle(LinuxStyle.USERMODE.getLabel())), (Object)new TimeGraphState(10L, 2L, null, new OutputElementStyle(LinuxStyle.WAIT_FOR_CPU.getLabel())), (Object)new TimeGraphState(12L, 8L, null, new OutputElementStyle(LinuxStyle.USERMODE.getLabel()))), true);
        rowResponse = dataProvider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(3L, 15L, 2, selectedIds)), (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)rowResponse.getStatus());
        rowModel = (TimeGraphModel)rowResponse.getModel();
        Assert.assertNotNull((Object)rowModel);
        rows = rowModel.getRows();
        Assert.assertEquals((long)10L, (long)rows.size());
        FlameChartDataProviderTest.verifyStates(rows, tid3, Collections.emptyList());
        FlameChartDataProviderTest.verifyStates(rows, pid5, Collections.emptyList());
        FlameChartDataProviderTest.verifyStates(rows, tid6, Collections.emptyList());
        FlameChartDataProviderTest.verifyStates(rows, FlameDataProviderTestUtils.findEntryByDepthAndType(tid3Children, 1, FlameChartEntryModel.EntryType.FUNCTION), (List<TimeGraphState>)ImmutableList.of((Object)new TimeGraphState(3L, 17L, Integer.MIN_VALUE, "op2")));
        FlameChartDataProviderTest.verifyStates(rows, FlameDataProviderTestUtils.findEntryByDepthAndType(tid3Children, 2, FlameChartEntryModel.EntryType.FUNCTION), (List<TimeGraphState>)ImmutableList.of((Object)new TimeGraphState(1L, 4L, Integer.MIN_VALUE), (Object)new TimeGraphState(13L, 8L, Integer.MIN_VALUE)));
        FlameChartDataProviderTest.verifyStates(rows, FlameDataProviderTestUtils.findEntryByDepthAndType(tid3Children, -1, FlameChartEntryModel.EntryType.KERNEL), (List<TimeGraphState>)ImmutableList.of((Object)new TimeGraphState(3L, 3L, null, new OutputElementStyle(LinuxStyle.USERMODE.getLabel())), (Object)new TimeGraphState(13L, 8L, null, new OutputElementStyle(LinuxStyle.WAIT_FOR_CPU.getLabel()))), true);
        FlameChartDataProviderTest.verifyStates(rows, FlameDataProviderTestUtils.findEntryByDepthAndType(tid6Children, 1, FlameChartEntryModel.EntryType.FUNCTION), (List<TimeGraphState>)ImmutableList.of((Object)new TimeGraphState(1L, 19L, Integer.MIN_VALUE, "op1")));
        FlameChartDataProviderTest.verifyStates(rows, FlameDataProviderTestUtils.findEntryByDepthAndType(tid6Children, 2, FlameChartEntryModel.EntryType.FUNCTION), (List<TimeGraphState>)ImmutableList.of((Object)new TimeGraphState(2L, 5L, Integer.MIN_VALUE, "op3"), (Object)new TimeGraphState(12L, 8L, Integer.MIN_VALUE, "op4")));
        FlameChartDataProviderTest.verifyStates(rows, FlameDataProviderTestUtils.findEntryByDepthAndType(tid6Children, 3, FlameChartEntryModel.EntryType.FUNCTION), (List<TimeGraphState>)ImmutableList.of((Object)new TimeGraphState(1L, 3L, Integer.MIN_VALUE), (Object)new TimeGraphState(10L, 11L, Integer.MIN_VALUE)));
        FlameChartDataProviderTest.verifyStates(rows, FlameDataProviderTestUtils.findEntryByDepthAndType(tid6Children, -1, FlameChartEntryModel.EntryType.KERNEL), (List<TimeGraphState>)ImmutableList.of((Object)new TimeGraphState(1L, 5L, null, new OutputElementStyle(LinuxStyle.USERMODE.getLabel())), (Object)new TimeGraphState(12L, 8L, null, new OutputElementStyle(LinuxStyle.USERMODE.getLabel()))), true);
        FlameChartEntryModel tid2 = FlameDataProviderTestUtils.findEntryByNameAndType(modelEntries, "2", FlameChartEntryModel.EntryType.LEVEL);
        Assert.assertNotNull((Object)tid2);
        List<FlameChartEntryModel> tid2Children = FlameDataProviderTestUtils.findEntriesByParent(modelEntries, tid2.getId());
        FlameChartEntryModel tid7 = FlameDataProviderTestUtils.findEntryByNameAndType(modelEntries, "7", FlameChartEntryModel.EntryType.LEVEL);
        Assert.assertNotNull((Object)tid7);
        List<FlameChartEntryModel> tid7Children = FlameDataProviderTestUtils.findEntriesByParent(modelEntries, tid7.getId());
        @NonNull @NonNull Map everythingQuery = FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(0L, Long.MAX_VALUE, 2));
        @NonNull @NonNull TmfModelResponse arrowResponse = dataProvider.fetchArrows(everythingQuery, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)arrowResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)arrowResponse.getStatus());
        @NonNull List arrowModel = (List)arrowResponse.getModel();
        Assert.assertNotNull((Object)arrowModel);
        Assert.assertFalse((boolean)arrowModel.isEmpty());
        FlameChartEntryModel tid2Child1 = FlameDataProviderTestUtils.findEntryByDepthAndType(tid2Children, 1, FlameChartEntryModel.EntryType.FUNCTION);
        Assert.assertNotNull((Object)tid2Child1);
        FlameChartEntryModel tid2Child2 = FlameDataProviderTestUtils.findEntryByDepthAndType(tid2Children, 2, FlameChartEntryModel.EntryType.FUNCTION);
        Assert.assertNotNull((Object)tid2Child2);
        FlameChartEntryModel tid2Child3 = FlameDataProviderTestUtils.findEntryByDepthAndType(tid2Children, 3, FlameChartEntryModel.EntryType.FUNCTION);
        Assert.assertNotNull((Object)tid2Child3);
        FlameChartEntryModel tid3Child2 = FlameDataProviderTestUtils.findEntryByDepthAndType(tid3Children, 2, FlameChartEntryModel.EntryType.FUNCTION);
        Assert.assertNotNull((Object)tid3Child2);
        FlameChartEntryModel tid6Child2 = FlameDataProviderTestUtils.findEntryByDepthAndType(tid6Children, 2, FlameChartEntryModel.EntryType.FUNCTION);
        Assert.assertNotNull((Object)tid6Child2);
        FlameChartEntryModel tid6Child3 = FlameDataProviderTestUtils.findEntryByDepthAndType(tid6Children, 3, FlameChartEntryModel.EntryType.FUNCTION);
        Assert.assertNotNull((Object)tid6Child3);
        FlameChartEntryModel tid7Child3 = FlameDataProviderTestUtils.findEntryByDepthAndType(tid7Children, 3, FlameChartEntryModel.EntryType.FUNCTION);
        Assert.assertNotNull((Object)tid7Child3);
        FlameChartDataProviderTest.verifyArrows(arrowModel, (List<ITimeGraphArrow>)ImmutableList.of((Object)new TimeGraphArrow(tid2Child1.getId(), tid2Child2.getId(), 1L, 2L, 1), (Object)new TimeGraphArrow(tid2Child3.getId(), tid3Child2.getId(), 4L, 3L, 2), (Object)new TimeGraphArrow(tid3Child2.getId(), tid6Child3.getId(), 5L, 4L, 3), (Object)new TimeGraphArrow(tid6Child3.getId(), tid7Child3.getId(), 5L, 5L, 4), (Object)new TimeGraphArrow(tid6Child3.getId(), tid6Child2.getId(), 9L, 3L, 5)));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFollowEvents() {
        FlameChartDataProvider dataProvider = this.getDataProvider();
        @NonNull @NonNull TmfModelResponse responseTree = dataProvider.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(0L, Long.MAX_VALUE, 2)), (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((responseTree.getStatus() == ITmfResponse.Status.COMPLETED ? 1 : 0) != 0);
        @NonNull TmfTreeModel model = (TmfTreeModel)responseTree.getModel();
        Assert.assertNotNull((Object)model);
        List modelEntries = model.getEntries();
        FlameChartEntryModel tid2 = FlameDataProviderTestUtils.findEntryByNameAndType(modelEntries, "2", FlameChartEntryModel.EntryType.LEVEL);
        Assert.assertNotNull((Object)tid2);
        List<FlameChartEntryModel> tid2Children = FlameDataProviderTestUtils.findEntriesByParent(modelEntries, tid2.getId());
        Assert.assertEquals((long)4L, (long)tid2Children.size());
        for (FlameChartEntryModel tid2Child : tid2Children) {
            @NonNull TmfModelResponse rowModel = dataProvider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(6L, Long.MAX_VALUE, 2, Collections.singleton(tid2Child.getId()))), MONITOR);
            if (tid2Child.getEntryType().equals((Object)FlameChartEntryModel.EntryType.KERNEL)) continue;
            FlameChartDataProviderTest.verifyFollowResponse((TmfModelResponse<TimeGraphModel>)rowModel, 1, 7);
        }
        Set<@NonNull Long> selectedEntry = Objects.requireNonNull(Collections.singleton(tid2Children.get(2).getId()));
        @NonNull TmfModelResponse rowModel = dataProvider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(7L, Long.MAX_VALUE, 2, selectedEntry)), MONITOR);
        FlameChartDataProviderTest.verifyFollowResponse((TmfModelResponse<TimeGraphModel>)rowModel, 0, 10);
        rowModel = dataProvider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(10L, Long.MAX_VALUE, 2, selectedEntry)), (IProgressMonitor)new NullProgressMonitor());
        FlameChartDataProviderTest.verifyFollowResponse((TmfModelResponse<TimeGraphModel>)rowModel, 1, 12);
        rowModel = dataProvider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(12L, Long.MAX_VALUE, 2, selectedEntry)), (IProgressMonitor)new NullProgressMonitor());
        FlameChartDataProviderTest.verifyFollowResponse((TmfModelResponse<TimeGraphModel>)rowModel, 0, 20);
        rowModel = dataProvider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(20L, Long.MAX_VALUE, 2, selectedEntry)), (IProgressMonitor)new NullProgressMonitor());
        FlameChartDataProviderTest.verifyFollowResponse((TmfModelResponse<TimeGraphModel>)rowModel, -1, -1);
        rowModel = dataProvider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter((List)ImmutableList.of((Object)Long.MIN_VALUE, (Object)20L), selectedEntry)), (IProgressMonitor)new NullProgressMonitor());
        FlameChartDataProviderTest.verifyFollowResponse((TmfModelResponse<TimeGraphModel>)rowModel, 1, 12);
        rowModel = dataProvider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter((List)ImmutableList.of((Object)Long.MIN_VALUE, (Object)7L), selectedEntry)), (IProgressMonitor)new NullProgressMonitor());
        FlameChartDataProviderTest.verifyFollowResponse((TmfModelResponse<TimeGraphModel>)rowModel, 2, 5);
        rowModel = dataProvider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter((List)ImmutableList.of((Object)Long.MIN_VALUE, (Object)5L), selectedEntry)), (IProgressMonitor)new NullProgressMonitor());
        FlameChartDataProviderTest.verifyFollowResponse((TmfModelResponse<TimeGraphModel>)rowModel, 3, 4);
        rowModel = dataProvider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter((List)ImmutableList.of((Object)Long.MIN_VALUE, (Object)4L), selectedEntry)), (IProgressMonitor)new NullProgressMonitor());
        FlameChartDataProviderTest.verifyFollowResponse((TmfModelResponse<TimeGraphModel>)rowModel, 2, 3);
        rowModel = dataProvider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter((List)ImmutableList.of((Object)Long.MIN_VALUE, (Object)3L), selectedEntry)), (IProgressMonitor)new NullProgressMonitor());
        FlameChartDataProviderTest.verifyFollowResponse((TmfModelResponse<TimeGraphModel>)rowModel, 1, 1);
        rowModel = dataProvider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter((List)ImmutableList.of((Object)Long.MIN_VALUE, (Object)1L), selectedEntry)), (IProgressMonitor)new NullProgressMonitor());
        FlameChartDataProviderTest.verifyFollowResponse((TmfModelResponse<TimeGraphModel>)rowModel, -1, -1);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void verifyFollowResponse(TmfModelResponse<@NonNull TimeGraphModel> rowModel, int expectedDepth, int expectedTime) {
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)rowModel.getStatus());
        TimeGraphModel model = (TimeGraphModel)rowModel.getModel();
        if (expectedDepth < 0) {
            Assert.assertNull((Object)model);
            return;
        }
        Assert.assertNotNull((Object)model);
        @NonNull List rows = model.getRows();
        Assert.assertEquals((long)1L, (long)rows.size());
        List row = ((ITimeGraphRowModel)rows.get(0)).getStates();
        Assert.assertEquals((long)1L, (long)row.size());
        ITimeGraphState stackInterval = (ITimeGraphState)row.get(0);
        long depth = stackInterval.getValue();
        Assert.assertEquals((long)expectedDepth, (long)depth);
        Assert.assertEquals((long)expectedTime, (long)stackInterval.getStartTime());
    }

    private static void verifyStates(List<ITimeGraphRowModel> rowModels, FlameChartEntryModel entry, List<TimeGraphState> expectedStates) {
        FlameChartDataProviderTest.verifyStates(rowModels, entry, expectedStates, false);
    }

    private static void verifyStates(List<ITimeGraphRowModel> rowModels, FlameChartEntryModel entry, List<TimeGraphState> expectedStates, boolean checkStyles) {
        Assert.assertNotNull((Object)entry);
        ITimeGraphRowModel rowModel = rowModels.stream().filter(model -> model.getEntryID() == entry.getId()).findFirst().orElse(null);
        Assert.assertNotNull((Object)rowModel);
        List states = rowModel.getStates();
        int i = 0;
        while (i < states.size()) {
            String entryName = entry.getName();
            if (i > expectedStates.size() - 1) {
                Assert.fail((String)("Unexpected state at position " + i + FOR_ENTRY + entryName + ": " + String.valueOf(states.get(i))));
            }
            ITimeGraphState actual = (ITimeGraphState)states.get(i);
            ITimeGraphState expected = (ITimeGraphState)expectedStates.get(i);
            Assert.assertEquals((String)("State start time at " + i + FOR_ENTRY + entryName), (long)expected.getStartTime(), (long)actual.getStartTime());
            Assert.assertEquals((String)("Duration at " + i + FOR_ENTRY + entryName), (long)expected.getDuration(), (long)actual.getDuration());
            Assert.assertEquals((String)("Label at " + i + FOR_ENTRY + entryName), (Object)expected.getLabel(), (Object)actual.getLabel());
            if (checkStyles) {
                Assert.assertEquals((String)("Style at " + i + FOR_ENTRY + entryName), (Object)expected.getStyle(), (Object)actual.getStyle());
            }
            ++i;
        }
    }

    @Test
    public void testFetchAnnotationCategories() {
        FlameChartDataProvider dataProvider = this.getDataProvider();
        TmfModelResponse response = dataProvider.fetchAnnotationCategories(Collections.emptyMap(), MONITOR);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)response.getStatus());
        Assert.assertEquals((Object)CommonStatusMessage.COMPLETED, (Object)response.getStatusMessage());
        AnnotationCategoriesModel model = (AnnotationCategoriesModel)response.getModel();
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)1L, (long)model.getAnnotationCategories().size());
        Assert.assertEquals((Object)"Markers", model.getAnnotationCategories().get(0));
    }

    @Test
    public void testFetchAnnotations() {
        FlameChartDataProvider dataProvider = this.getDataProvider();
        Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(0L, Long.MAX_VALUE, 2, Collections.emptySet()));
        TmfModelResponse response = dataProvider.fetchAnnotations(parameters, MONITOR);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)response.getStatus());
        Assert.assertEquals((Object)CommonStatusMessage.COMPLETED, (Object)response.getStatusMessage());
        AnnotationModel model = (AnnotationModel)response.getModel();
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((boolean)model.getAnnotations().containsKey("Markers"));
    }

    @Test
    public void testFetchAnnotationsNullFilter() {
        FlameChartDataProvider dataProvider = this.getDataProvider();
        Map parameters = Collections.emptyMap();
        TmfModelResponse response = dataProvider.fetchAnnotations(parameters, MONITOR);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)response.getStatus());
        Assert.assertEquals((Object)CommonStatusMessage.COMPLETED, (Object)response.getStatusMessage());
        Assert.assertNull((Object)response.getModel());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchAnnotationsOutputElementStyle() {
        FlameChartDataProvider dataProvider = this.getDataProvider();
        @NonNull @NonNull TmfModelResponse treeResponse = dataProvider.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(0L, Long.MAX_VALUE, 2)), null);
        @NonNull TmfTreeModel model = (TmfTreeModel)treeResponse.getModel();
        if (model != null) {
            List entries = model.getEntries();
            FlameChartEntryModel functionEntry = entries.stream().filter(e -> e.getEntryType() == FlameChartEntryModel.EntryType.FUNCTION).findFirst().orElse(null);
            Assert.assertNotNull((Object)functionEntry);
            Map fetchParams = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(15L, 20L, 3, Collections.singleton(functionEntry.getId())));
            TmfModelResponse response = dataProvider.fetchAnnotations(fetchParams, MONITOR);
            Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)response.getStatus());
            AnnotationModel m = (AnnotationModel)response.getModel();
            Assert.assertNotNull((Object)m);
            @NonNull Collection annotations = (Collection)m.getAnnotations().get("Markers");
            Assert.assertNotNull((Object)annotations);
            Assert.assertFalse((boolean)annotations.isEmpty());
            for (Annotation annotation : annotations) {
                OutputElementStyle style = annotation.getStyle();
                Assert.assertNotNull((Object)style);
                Map styleMap = style.getStyleValues();
                Assert.assertEquals((Object)"#7D3D31", styleMap.get("color"));
                Assert.assertEquals((Object)Float.valueOf(0.33f), styleMap.get("height"));
                Assert.assertEquals((Object)"diamond", styleMap.get("symbol-type"));
            }
        }
    }

    @Test
    public void testAnnotationModelStructure() {
        FlameChartDataProvider dataProvider = this.getDataProvider();
        Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(0L, Long.MAX_VALUE, 2, Collections.emptySet()));
        TmfModelResponse response = dataProvider.fetchAnnotations(parameters, MONITOR);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)response.getStatus());
        AnnotationModel model = (AnnotationModel)response.getModel();
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)1L, (long)model.getAnnotations().size());
        Assert.assertTrue((boolean)model.getAnnotations().containsKey("Markers"));
        Assert.assertNotNull(model.getAnnotations().get("Markers"));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchValidAnnotations() {
        FlameChartDataProvider dataProvider = this.getDataProvider();
        @NonNull @NonNull TmfModelResponse treeResponse = dataProvider.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(1L, Long.MAX_VALUE, 2)), MONITOR);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)treeResponse.getStatus());
        @NonNull TmfTreeModel m = (TmfTreeModel)treeResponse.getModel();
        if (m != null) {
            Set allEntryIds = m.getEntries().stream().map(TmfTreeDataModel::getId).collect(Collectors.toSet());
            Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(1L, Long.MAX_VALUE, 2, allEntryIds));
            TmfModelResponse response = dataProvider.fetchAnnotations(parameters, MONITOR);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)response.getStatus());
            AnnotationModel model = (AnnotationModel)response.getModel();
            Assert.assertNotNull((Object)model);
            Map annotations = model.getAnnotations();
            Assert.assertNotNull((Object)annotations);
        }
    }

    private static void verifyArrows(List<ITimeGraphArrow> arrows, List<ITimeGraphArrow> expectedArrows) {
        Assert.assertEquals((long)expectedArrows.size(), (long)arrows.size());
        for (ITimeGraphArrow expectedArrow : expectedArrows) {
            for (ITimeGraphArrow arrow : arrows) {
                if (arrow.getValue() != expectedArrow.getValue()) continue;
                Assert.assertEquals((String)("Duration for arrow " + arrow.getValue()), (long)expectedArrow.getDuration(), (long)arrow.getDuration());
                Assert.assertEquals((String)("Start time for arrow " + arrow.getValue()), (long)expectedArrow.getStartTime(), (long)arrow.getStartTime());
                Assert.assertEquals((String)("Source Id for arrow " + arrow.getValue()), (long)expectedArrow.getSourceId(), (long)arrow.getSourceId());
                Assert.assertEquals((String)("Destination Id for arrow " + arrow.getValue()), (long)expectedArrow.getDestinationId(), (long)arrow.getDestinationId());
            }
        }
    }
}

