/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.perf;

import java.io.File;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.CallGraph;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICallGraphProvider2;
import org.eclipse.tracecompass.analysis.profiling.core.instrumented.IFlameChartProvider;
import org.eclipse.tracecompass.analysis.profiling.core.instrumented.InstrumentedCallStackAnalysis;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeGroupDescriptor;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeSet;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTreeGroupBy;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTreeSet;
import org.eclipse.tracecompass.internal.analysis.profiling.core.tree.AllGroupDescriptor;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.Assert;
import org.junit.Test;

public abstract class CallStackAndGraphBenchmark {
    public static final String TEST_ID = "org.eclipse.tracecompass.analysis#CallStack#";
    private static final String TEST_CALLSTACK_BUILD = "Building Callstack (%s)";
    private static final String TEST_CALLSTACK_PARSESEGSTORE = "Callstack segment store (%s)";
    private static final String TEST_CALLGRAPH_BUILD = "Building CallGraph (%s)";
    private static final String TEST_CALLGRAPH_QUERY = "CallGraph Query (%s)";
    private static final String TEST_CALLGRAPH_GROUPBY = "CallGraph Group By (%s)";
    private static final byte[] SEED = new byte[]{69, 115, 116, 101, 108, 108, 101};
    private static final int LOOP_COUNT = 5;
    private final String fName;
    private final String fAnalysisId;

    public CallStackAndGraphBenchmark(String name, String analysisId) {
        this.fName = name;
        this.fAnalysisId = analysisId;
    }

    @Test
    public void runCpuBenchmark() throws TmfTraceException {
        Performance perf = Performance.getDefault();
        PerformanceMeter callStackBuildPm = Objects.requireNonNull(perf.createPerformanceMeter(TEST_ID + String.format(TEST_CALLSTACK_BUILD, this.fName)));
        perf.tagAsSummary(callStackBuildPm, String.format(TEST_CALLSTACK_BUILD, this.fName), Dimension.CPU_TIME);
        PerformanceMeter callStackSegStorePm = Objects.requireNonNull(perf.createPerformanceMeter(TEST_ID + String.format(TEST_CALLSTACK_PARSESEGSTORE, this.fName)));
        perf.tagAsSummary(callStackSegStorePm, String.format(TEST_CALLSTACK_PARSESEGSTORE, this.fName), Dimension.CPU_TIME);
        PerformanceMeter callgraphBuildPm = Objects.requireNonNull(perf.createPerformanceMeter(TEST_ID + String.format(TEST_CALLGRAPH_BUILD, this.fName)));
        perf.tagAsSummary(callgraphBuildPm, String.format(TEST_CALLGRAPH_BUILD, this.fName), Dimension.CPU_TIME);
        PerformanceMeter callgraphQueryPm = perf.createPerformanceMeter(TEST_ID + String.format(TEST_CALLGRAPH_QUERY, this.fName));
        perf.tagAsSummary(callgraphQueryPm, String.format(TEST_CALLGRAPH_QUERY, this.fName), Dimension.CPU_TIME);
        PerformanceMeter callgraphGroupByPm = perf.createPerformanceMeter(TEST_ID + String.format(TEST_CALLGRAPH_GROUPBY, this.fName));
        perf.tagAsSummary(callgraphGroupByPm, String.format(TEST_CALLGRAPH_GROUPBY, this.fName), Dimension.CPU_TIME);
        boolean isFlameChartProvider = false;
        int i = 0;
        while (i < 5) {
            TmfTrace trace = null;
            try {
                trace = this.getTrace();
                trace.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
                IAnalysisModule analysisModule = TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, IAnalysisModule.class, (String)this.fAnalysisId);
                Assert.assertTrue((boolean)(analysisModule instanceof ICallGraphProvider2));
                ICallGraphProvider2 callGraphModule = (ICallGraphProvider2)analysisModule;
                if (analysisModule instanceof IFlameChartProvider) {
                    isFlameChartProvider = true;
                    CallStackAndGraphBenchmark.benchmarkInstrumented((IFlameChartProvider)analysisModule, callStackBuildPm, callStackSegStorePm, callgraphBuildPm);
                } else {
                    CallStackAndGraphBenchmark.benchmarkCallGraphProvider(callGraphModule, callgraphBuildPm);
                }
                long startTime = trace.getStartTime().toNanos();
                long endTime = trace.getEndTime().toNanos();
                long delta = endTime - startTime;
                SecureRandom randomGenerator = new SecureRandom(SEED);
                callgraphQueryPm.start();
                int j = 0;
                while (j < 50) {
                    long time0 = Math.abs(randomGenerator.nextLong()) % delta;
                    long time1 = Math.abs(randomGenerator.nextLong()) % delta;
                    callGraphModule.getCallGraph(TmfTimestamp.fromNanos((long)(startTime + Math.min(time0, time1))), TmfTimestamp.fromNanos((long)(startTime + Math.max(time0, time1))));
                    ++j;
                }
                callgraphQueryPm.stop();
                ArrayList<IWeightedTreeGroupDescriptor> descriptors = new ArrayList<IWeightedTreeGroupDescriptor>();
                descriptors.add(AllGroupDescriptor.getInstance());
                descriptors.addAll(callGraphModule.getGroupDescriptors());
                CallGraph callGraphToGroup = callGraphModule.getCallGraph();
                callgraphGroupByPm.start();
                int j2 = 0;
                while (j2 < 10) {
                    descriptors.forEach(group -> {
                        WeightedTreeSet weightedTreeSet = WeightedTreeGroupBy.groupWeightedTreeBy((IWeightedTreeGroupDescriptor)group, (IWeightedTreeSet)callGraphToGroup, (IWeightedTreeProvider)callGraphModule);
                    });
                    Collections.reverse(descriptors);
                    descriptors.forEach(group -> {
                        WeightedTreeSet weightedTreeSet = WeightedTreeGroupBy.groupWeightedTreeBy((IWeightedTreeGroupDescriptor)group, (IWeightedTreeSet)callGraphToGroup, (IWeightedTreeProvider)callGraphModule);
                    });
                    ++j2;
                }
                callgraphGroupByPm.stop();
                File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
                File[] fileArray = suppDir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    file.delete();
                    ++n2;
                }
            }
            finally {
                if (trace != null) {
                    trace.dispose();
                }
            }
            ++i;
        }
        if (isFlameChartProvider) {
            callStackBuildPm.commit();
            callStackSegStorePm.commit();
        }
        callgraphBuildPm.commit();
        callgraphQueryPm.commit();
        callgraphGroupByPm.commit();
    }

    private static void benchmarkCallGraphProvider(ICallGraphProvider2 callGraphModule, PerformanceMeter callgraphBuildPm) {
        callgraphBuildPm.start();
        TmfTestHelper.executeAnalysis((IAnalysisModule)((IAnalysisModule)callGraphModule));
        callgraphBuildPm.stop();
        CallGraph callGraph = callGraphModule.getCallGraph();
        Assert.assertTrue((!callGraph.getElements().isEmpty() ? 1 : 0) != 0);
    }

    private static void benchmarkInstrumented(IFlameChartProvider analysisModule, PerformanceMeter callStackBuildPm, PerformanceMeter callStackSegStorePm, PerformanceMeter callgraphBuildPm) {
        if (analysisModule instanceof InstrumentedCallStackAnalysis) {
            ((InstrumentedCallStackAnalysis)analysisModule).triggerAutomatically(false);
        }
        callStackBuildPm.start();
        TmfTestHelper.executeAnalysis((IAnalysisModule)analysisModule);
        callStackBuildPm.stop();
        ISegmentStore segmentStore = analysisModule.getSegmentStore();
        Assert.assertNotNull((Object)segmentStore);
        callStackSegStorePm.start();
        Iterator iterator = segmentStore.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
        callStackSegStorePm.stop();
        callgraphBuildPm.start();
        CallGraph callGraph = ((ICallGraphProvider2)analysisModule).getCallGraph();
        callgraphBuildPm.stop();
        Assert.assertTrue((!callGraph.getElements().isEmpty() ? 1 : 0) != 0);
    }

    protected abstract TmfTrace getTrace() throws TmfTraceException;
}

