/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.ui.views.fileaccess;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfThreadSelectedSignal;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.incubator.internal.kernel.core.fileaccess.FileAccessDataProvider;
import org.eclipse.tracecompass.incubator.internal.kernel.core.fileaccess.FileEntryModel;
import org.eclipse.tracecompass.incubator.internal.kernel.core.fileaccess.ThreadEntryModel;
import org.eclipse.tracecompass.incubator.internal.kernel.ui.Activator;
import org.eclipse.tracecompass.incubator.internal.kernel.ui.views.fileaccess.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.actions.FollowThreadAction;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.widgets.timegraph.BaseDataProviderTimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NamedTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;

public class FileAccessByFileView
extends BaseDataProviderTimeGraphView {
    private static final String TITLE = Messages.FileAccessByFileView_title;
    private static final String ALL = Messages.FileAccessByFileView_all;
    private static final String ID = "org.eclipse.tracecompass.incubator.kernel.ui.filebyfile";
    private static final Image THREAD_IMAGE = Objects.requireNonNull(Activator.getDefault()).getImageFromPath("icons/obj16/thread_obj.gif");
    private static final Image FILE_IMAGE = Objects.requireNonNull(Activator.getDefault()).getImageFromPath("icons/obj16/file_obj.gif");
    private static final Image ADVANCED_IMAGE = Objects.requireNonNull(Activator.getDefault()).getImageFromPath("icons/obj16/advanced.png");
    private static final String RESOURCE_COLUMN = Messages.FileAccessByFileView_resource;
    private static final String TID_COLUMN = Messages.FileAccessByFileView_thread;
    private static final String READ_COLUMN = Messages.FileAccessByFileView_read;
    private static final String WRITE_COLUMN = Messages.FileAccessByFileView_write;
    private static final String[] COLUMN_NAMES = new String[]{RESOURCE_COLUMN, TID_COLUMN, READ_COLUMN, WRITE_COLUMN};
    private static final String ADVANCED_MODE_KEY = String.valueOf(FileAccessByFileView.class.getCanonicalName()) + File.separator + "ADVANCED";
    private static final String FOLLOW_A_THREAD = Messages.FileAccessByFileView_follow;
    private boolean fAdvancedMode = Activator.getDefault().getPreferenceStore().getBoolean(ADVANCED_MODE_KEY);

    protected void fillTimeGraphEntryContextMenu(@NonNull IMenuManager menuManager) {
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        Object first = null;
        Object second = null;
        if (selection instanceof StructuredSelection) {
            TimeGraphEntry entry;
            ITmfTreeDataModel model;
            StructuredSelection sSel = (StructuredSelection)selection;
            Iterator iter = sSel.iterator();
            if (iter.hasNext()) {
                first = iter.next();
            }
            if (iter.hasNext()) {
                second = iter.next();
            }
            if (second instanceof NamedTimeEvent) {
                NamedTimeEvent event = second;
                int tid = event.getValue();
                menuManager.add((IAction)new FollowThreadAction((TmfView)this, event.getLabel(), tid, FileAccessByFileView.getTrace((TimeGraphEntry)((TimeGraphEntry)event.getEntry()))));
            }
            if (first instanceof TimeGraphEntry && (model = (entry = (TimeGraphEntry)sSel.getFirstElement()).getEntryModel()) instanceof ThreadEntryModel) {
                menuManager.add((IAction)new FollowThreadAction((TmfView)this, entry.getName(), ((ThreadEntryModel)model).getTid(), FileAccessByFileView.getTrace((TimeGraphEntry)entry)));
            }
        }
    }

    public FileAccessByFileView() {
        super(ID, (TimeGraphPresentationProvider)new BaseDataProviderTimeGraphPresentationProvider(), "org.eclipse.tracecompass.incubator.kernel.core.file.access.dataprovider");
        this.setTreeColumns(COLUMN_NAMES);
        this.setTreeLabelProvider(new FileAccessTreeLabelProvider());
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.createTimeEventContextMenu();
        Action action = new Action(Messages.FileAccessByFileView_advanced, 2){

            public String getDescription() {
                return Messages.FileAccessByFileView_advancedDescription;
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ADVANCED_IMAGE);
            }

            public void run() {
                TmfTraceContext ctx;
                HostThread data;
                FileAccessByFileView.this.fAdvancedMode = !FileAccessByFileView.this.fAdvancedMode;
                this.setChecked(FileAccessByFileView.this.fAdvancedMode);
                Activator.getDefault().getPreferenceStore().setValue(ADVANCED_MODE_KEY, FileAccessByFileView.this.fAdvancedMode);
                ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
                if (activeTrace != null && ((data = (HostThread)(ctx = TmfTraceManager.getInstance().getTraceContext(activeTrace)).getData("model.selectedThread")) == null || data.getTid() < 0)) {
                    FileAccessByFileView.this.rebuild();
                }
            }
        };
        action.setChecked(this.fAdvancedMode);
        this.getViewSite().getActionBars().getMenuManager().add((IAction)action);
    }

    private void createTimeEventContextMenu() {
        MenuManager eventMenuManager = new MenuManager();
        eventMenuManager.setRemoveAllWhenShown(true);
        TimeGraphControl timeGraphControl = this.getTimeGraphViewer().getTimeGraphControl();
        Menu timeEventMenu = eventMenuManager.createContextMenu((Control)timeGraphControl);
        timeGraphControl.addTimeEventMenuListener(event -> {
            Menu menu2 = timeEventMenu;
            if (event.data instanceof TimeEvent) {
                timeGraphControl.setMenu(menu2);
                return;
            }
            timeGraphControl.setMenu(null);
            event.doit = false;
        });
        eventMenuManager.addMenuListener(manager -> {
            this.fillTimeEventContextMenu(eventMenuManager);
            eventMenuManager.add((IContributionItem)new GroupMarker("additions"));
        });
        this.getSite().registerContextMenu(eventMenuManager, this.getTimeGraphViewer().getSelectionProvider());
    }

    private void fillTimeEventContextMenu(MenuManager menuManager) {
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        Object first = null;
        Object second = null;
        if (selection instanceof StructuredSelection) {
            TimeGraphEntry entry;
            ITmfTreeDataModel model;
            StructuredSelection sSel = (StructuredSelection)selection;
            Iterator iter = sSel.iterator();
            if (iter.hasNext()) {
                first = iter.next();
            }
            if (iter.hasNext()) {
                second = iter.next();
            }
            if (second instanceof NamedTimeEvent) {
                NamedTimeEvent event = second;
                int tid = event.getValue();
                menuManager.add((IAction)new FollowThreadAction((TmfView)this, event.getLabel(), tid, FileAccessByFileView.getTrace((TimeGraphEntry)((TimeGraphEntry)event.getEntry()))));
            }
            if (first instanceof TimeGraphEntry && (model = (entry = (TimeGraphEntry)sSel.getFirstElement()).getEntryModel()) instanceof ThreadEntryModel) {
                menuManager.add((IAction)new FollowThreadAction((TmfView)this, entry.getName(), ((ThreadEntryModel)model).getTid(), FileAccessByFileView.getTrace((TimeGraphEntry)entry)));
            }
        }
    }

    @TmfSignalHandler
    public void handleThreadFollowed(TmfThreadSelectedSignal signal) {
        HostThread ht = signal.getThreadId() >= 0 ? signal.getHostThread() : null;
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        TmfTraceManager.getInstance().updateTraceContext(trace, builder -> builder.setData("model.selectedThread", (Object)ht));
        if (ht == null) {
            return;
        }
        String threadName = ht.getTid() < 0 ? (this.fAdvancedMode ? ALL : FOLLOW_A_THREAD) : Integer.toString(ht.getTid());
        this.setPartName(String.format(TITLE, threadName));
        this.rebuild();
    }

    protected @NonNull Map<@NonNull String, @NonNull Object> getFetchTreeParameters() {
        int tid;
        TmfTraceContext ctx = TmfTraceManager.getInstance().getTraceContext(this.getTrace());
        HostThread data = (HostThread)ctx.getData("model.selectedThread");
        int n = tid = data != null ? data.getTid() : -1;
        String threadName = tid < 0 ? (this.fAdvancedMode ? ALL : FOLLOW_A_THREAD) : Integer.toString(tid);
        this.setPartName(String.format(TITLE, threadName));
        if (!this.fAdvancedMode && tid == -1) {
            return Collections.emptyMap();
        }
        return ImmutableMap.of((Object)"tid", (Object)tid);
    }

    private class FileAccessTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private FileAccessTreeLabelProvider() {
        }

        public @Nullable Image getColumnImage(@Nullable Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof TimeGraphEntry) {
                TimeGraphEntry entry = (TimeGraphEntry)element;
                ITmfTreeDataModel entryModel = entry.getEntryModel();
                if (entryModel instanceof FileEntryModel) {
                    return FILE_IMAGE;
                }
                if (entryModel instanceof ThreadEntryModel) {
                    return THREAD_IMAGE;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ITmfTrace activeTrace;
            FileAccessDataProvider dp;
            if (!(element instanceof TimeGraphEntry)) {
                return super.getColumnText(element, columnIndex);
            }
            TimeGraphEntry entry = (TimeGraphEntry)element;
            if (columnIndex == 1) {
                ITmfTreeDataModel model = entry.getEntryModel();
                if (model instanceof ThreadEntryModel) {
                    return String.valueOf(((ThreadEntryModel)model).getTid());
                }
                return super.getColumnText(element, columnIndex);
            }
            if (columnIndex == 2) {
                dp = (FileAccessDataProvider)DataProviderManager.getInstance().getOrCreateDataProvider(FileAccessByFileView.this.getTrace(), FileAccessByFileView.this.getProviderId(), FileAccessDataProvider.class);
                activeTrace = TmfTraceManager.getInstance().getActiveTrace();
                if (activeTrace != null && dp != null) {
                    TmfTimeRange tr = activeTrace.getTimeRange();
                    return NonNullUtils.nullToEmptyString((Object)dp.getBytesRead(tr.getStartTime().toNanos(), tr.getEndTime().toNanos(), entry.getEntryModel().getId()));
                }
            }
            if (columnIndex == 3) {
                dp = (FileAccessDataProvider)DataProviderManager.getInstance().getOrCreateDataProvider(FileAccessByFileView.this.getTrace(), FileAccessByFileView.this.getProviderId(), FileAccessDataProvider.class);
                activeTrace = TmfTraceManager.getInstance().getActiveTrace();
                if (activeTrace != null && dp != null) {
                    TmfTimeRange tr = activeTrace.getTimeRange();
                    return NonNullUtils.nullToEmptyString((Object)dp.getBytesWrite(tr.getStartTime().toNanos(), tr.getEndTime().toNanos(), entry.getEntryModel().getId()));
                }
            }
            return super.getColumnText(element, columnIndex);
        }
    }
}

