/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.rulers;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public final class DAG<E> {
    private final MultiMap<E, E> fOut = new MultiMap();
    private final MultiMap<E, E> fIn = new MultiMap();

    public boolean addEdge(E origin, E target) {
        Assert.isLegal((origin != null ? 1 : 0) != 0);
        Assert.isLegal((target != null ? 1 : 0) != 0);
        if (this.hasPath(target, origin)) {
            return false;
        }
        this.fOut.put(origin, target);
        this.fOut.put(target, null);
        this.fIn.put(target, origin);
        this.fIn.put(origin, null);
        return true;
    }

    public void addVertex(E vertex) {
        Assert.isLegal((vertex != null ? 1 : 0) != 0);
        this.fOut.put(vertex, null);
        this.fIn.put(vertex, null);
    }

    public void removeVertex(E vertex) {
        Set<E> targets = this.fOut.removeAll(vertex);
        Iterator<E> it = targets.iterator();
        while (it.hasNext()) {
            this.fIn.remove(it.next(), vertex);
        }
        Set<E> origins = this.fIn.removeAll(vertex);
        Iterator<E> it2 = origins.iterator();
        while (it2.hasNext()) {
            this.fOut.remove(it2.next(), vertex);
        }
    }

    public Set<E> getSources() {
        return DAG.computeZeroEdgeVertices(this.fIn);
    }

    public Set<E> getSinks() {
        return DAG.computeZeroEdgeVertices(this.fOut);
    }

    private static <T> Set<T> computeZeroEdgeVertices(MultiMap<T, T> map) {
        Set<T> candidates = map.keySet();
        LinkedHashSet<T> roots = new LinkedHashSet<T>(candidates.size());
        for (T candidate : candidates) {
            if (!map.get(candidate).isEmpty()) continue;
            roots.add(candidate);
        }
        return roots;
    }

    public Set<E> getChildren(E vertex) {
        return Collections.unmodifiableSet(this.fOut.get(vertex));
    }

    private boolean hasPath(E start, E end) {
        if (start == end) {
            return true;
        }
        Set<E> children = this.fOut.get(start);
        Iterator<E> it = children.iterator();
        while (it.hasNext()) {
            if (!this.hasPath(it.next(), end)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Out: " + this.fOut.toString() + " In: " + this.fIn.toString();
    }

    private static final class MultiMap<K, V> {
        private final Map<K, Set<V>> fMap = new LinkedHashMap<K, Set<V>>();

        private MultiMap() {
        }

        public void put(K key, V val) {
            Set<V> values = this.fMap.get(key);
            if (values == null) {
                values = new LinkedHashSet<V>();
                this.fMap.put(key, values);
            }
            if (val != null) {
                values.add(val);
            }
        }

        public Set<V> get(K key) {
            Set<V> values = this.fMap.get(key);
            return values == null ? Collections.emptySet() : values;
        }

        public Set<K> keySet() {
            return this.fMap.keySet();
        }

        public Set<V> removeAll(K key) {
            Set<V> values = this.fMap.remove(key);
            return values == null ? Collections.emptySet() : values;
        }

        public void remove(K key, V val) {
            Set<V> values = this.fMap.get(key);
            if (values != null) {
                values.remove(val);
            }
        }

        public String toString() {
            return this.fMap.toString();
        }
    }
}

