/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfAnalysisElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOnDemandAnalysisElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenAnalysisHelpHandler
extends AbstractHandler {
    private TmfAnalysisElement fAnalysis;
    private TmfOnDemandAnalysisElement fOnDemandAnalysis;

    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return false;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        this.fAnalysis = null;
        this.fOnDemandAnalysis = null;
        if (selection instanceof TreeSelection) {
            TreeSelection sel = (TreeSelection)selection;
            Object element = sel.getFirstElement();
            if (element instanceof TmfAnalysisElement) {
                this.fAnalysis = (TmfAnalysisElement)element;
            } else if (element instanceof TmfOnDemandAnalysisElement) {
                this.fOnDemandAnalysis = (TmfOnDemandAnalysisElement)element;
            }
        }
        return this.fAnalysis != null || this.fOnDemandAnalysis != null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        if (this.fAnalysis == null && this.fOnDemandAnalysis == null) {
            return null;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (OpenAnalysisHelpHandler.this.fAnalysis != null) {
                    OpenAnalysisHelpHandler.displayHelpMsg(OpenAnalysisHelpHandler.this.fAnalysis.getHelpMessage());
                } else {
                    OpenAnalysisHelpHandler.displayHelpMsg(OpenAnalysisHelpHandler.this.fOnDemandAnalysis.getHelpMessage());
                }
            }
        };
        thread.start();
        return null;
    }

    private static void displayHelpMsg(String helpMsg) {
        Display display = Display.getDefault();
        display.asyncExec(() -> MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.AnalysisModule_Help, (String)helpMsg));
    }
}

