/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import java.text.MessageFormat;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.parser.ParserMessages;
import org.eclipse.core.runtime.PlatformObject;

public class ProblemBinding
extends PlatformObject
implements IProblemBinding,
IASTInternalScope {
    public static ProblemBinding NOT_INITIALIZED = new ProblemBinding(null, 0);
    protected final int id;
    protected char[] arg;
    protected IASTNode node;
    private IBinding[] candidateBindings;

    public ProblemBinding(IASTName name, int id) {
        this((IASTNode)name, id, null, null);
    }

    public ProblemBinding(IASTName name, int id, IBinding[] candidateBindings) {
        this((IASTNode)name, id, null, candidateBindings);
    }

    public ProblemBinding(IASTName name, IASTNode point, int id) {
        this(name, point, id, null);
    }

    public ProblemBinding(IASTName name, IASTNode point, int id, IBinding[] candidateBindings) {
        this.id = id;
        if (name != null && name.getTranslationUnit() != null) {
            this.node = name;
        } else {
            this.node = point;
            if (name != null) {
                this.arg = name.getSimpleID();
            } else if (candidateBindings != null && candidateBindings.length != 0) {
                this.arg = candidateBindings[0].getNameCharArray();
            }
        }
        this.candidateBindings = candidateBindings;
    }

    public ProblemBinding(IASTNode node, int id, char[] arg) {
        this(node, id, arg, null);
    }

    public ProblemBinding(IASTNode node, int id, char[] arg, IBinding[] candidateBindings) {
        this.id = id;
        this.arg = arg;
        this.node = node;
        this.candidateBindings = candidateBindings;
    }

    @Override
    public EScopeKind getKind() {
        return EScopeKind.eLocal;
    }

    @Override
    public IASTNode getASTNode() {
        return this.node;
    }

    @Override
    public IBinding[] getCandidateBindings() {
        return this.candidateBindings != null ? this.candidateBindings : IBinding.EMPTY_BINDING_ARRAY;
    }

    public void setCandidateBindings(IBinding[] foundBindings) {
        this.candidateBindings = foundBindings;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public String getMessage() {
        String msg = ParserMessages.getProblemPattern(this);
        if (msg == null) {
            return "";
        }
        if (this.arg == null) {
            if (this.node instanceof IASTName) {
                this.arg = ((IASTName)this.node).toCharArray();
            } else if (this.candidateBindings != null && this.candidateBindings.length != 0) {
                this.arg = this.candidateBindings[0].getNameCharArray();
            }
        }
        if (this.arg != null) {
            msg = MessageFormat.format(msg, new String(this.arg));
        }
        return msg;
    }

    @Override
    public String getName() {
        if (this.node instanceof IASTName) {
            return new String(((IASTName)this.node).getSimpleID());
        }
        return this.arg != null ? new String(this.arg) : "";
    }

    @Override
    public char[] getNameCharArray() {
        if (this.node instanceof IASTName) {
            return ((IASTName)this.node).getSimpleID();
        }
        return this.arg != null ? this.arg : CharArrayUtils.EMPTY;
    }

    @Override
    public IScope getScope() throws DOMException {
        throw new DOMException(this);
    }

    @Override
    public IASTNode getPhysicalNode() {
        return this.getASTNode();
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public IScope getParent() throws DOMException {
        throw new DOMException(this);
    }

    @Override
    public IBinding[] find(String name, IASTTranslationUnit tu) {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public IBinding[] find(String name) {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public IName getScopeName() {
        return null;
    }

    @Override
    public void addName(IASTName name, boolean adlOnly) {
    }

    @Override
    public IBinding getBinding(IASTName name, boolean resolve) {
        return null;
    }

    @Override
    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) {
        return null;
    }

    @Override
    @Deprecated
    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) {
        return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefixLookup));
    }

    @Override
    public IBinding[] getBindings(IScope.ScopeLookupData lookup) {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public boolean isSameType(IType type) {
        return type == this;
    }

    @Override
    public String getFileName() {
        if (this.node != null) {
            return this.node.getContainingFilename();
        }
        return "";
    }

    @Override
    public int getLineNumber() {
        IASTFileLocation fileLoc;
        if (this.node != null && (fileLoc = this.node.getFileLocation()) != null) {
            return fileLoc.getStartingLineNumber();
        }
        return -1;
    }

    @Override
    public void addBinding(IBinding binding) {
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.NO_LINKAGE;
    }

    public String toString() {
        return this.getMessage();
    }

    @Override
    public IBinding getOwner() {
        IASTTranslationUnit tu;
        if (this.node instanceof IASTName && (tu = this.node.getTranslationUnit()) instanceof ICPPASTTranslationUnit) {
            return CPPVisitor.findNameOwner((IASTName)this.node, true);
        }
        return null;
    }

    public void setASTNode(IASTName name) {
        if (name != null) {
            this.node = name;
            this.arg = null;
        }
    }

    @Override
    public void populateCache() {
    }

    @Override
    public void removeNestedFromCache(IASTNode container) {
    }

    public IType getType() {
        return new ProblemType(this.getID());
    }

    public boolean isStatic() {
        return false;
    }

    public String[] getQualifiedName() throws DOMException {
        throw new DOMException(this);
    }

    public char[][] getQualifiedNameCharArray() throws DOMException {
        throw new DOMException(this);
    }

    public boolean isGloballyQualified() throws DOMException {
        throw new DOMException(this);
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isConstexpr() {
        return false;
    }

    public boolean isExtern() {
        return false;
    }

    public boolean isExternC() {
        return false;
    }

    public boolean isAuto() {
        return false;
    }

    public boolean isRegister() {
        return false;
    }

    public IValue getInitialValue() {
        return null;
    }

    public ICPPEvaluation getInitializerEvaluation() {
        return EvalFixed.INCOMPLETE;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isDeleted() {
        return false;
    }

    public boolean isInline() {
        return false;
    }

    public boolean takesVarArgs() {
        return false;
    }

    public IType[] getExceptionSpecification() {
        return null;
    }

    public boolean hasParameterPack() {
        return false;
    }

    public boolean isVirtual() {
        return false;
    }

    public boolean isPureVirtual() {
        return false;
    }

    public boolean isImplicit() {
        return false;
    }

    public boolean isExplicit() {
        return false;
    }

    public boolean hasDefaultValue() {
        return false;
    }

    public IValue getDefaultValue() {
        return null;
    }

    public boolean isParameterPack() {
        return false;
    }
}

