/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.executioncomparison.core;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.base.IDataPalette;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTree;
import org.eclipse.tracecompass.tmf.core.dataprovider.X11ColorUtils;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.RotatingPaletteProvider;

public final class DifferentialFlamePalette
implements IDataPalette {
    private static final String NAN = Objects.requireNonNull(Objects.toString(Double.NaN));
    private static final String NO_DIFFERENCE = "NO-Difference";
    private static double fMinThreshold = 1.0;
    private static final int MIN_HUE = 0;
    private static final int MAX_HUE = 255;
    private static final int NUM_COLORS = 360;
    private static final String RED_COLOR = Objects.requireNonNull(X11ColorUtils.toHexColor((int)255, (int)0, (int)0));
    private static final String WHITE_COLOR = Objects.requireNonNull(X11ColorUtils.toHexColor((int)255, (int)255, (int)255));
    private static final Map<String, OutputElementStyle> STYLES;
    private static final Map<String, OutputElementStyle> STYLE_MAP;
    private static @Nullable DifferentialFlamePalette fInstance;

    static {
        STYLE_MAP = Collections.synchronizedMap(new HashMap());
        fInstance = null;
        RotatingPaletteProvider palette = new RotatingPaletteProvider.Builder().setNbColors(360).build();
        int i = 0;
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (RGBAColor color : palette.get()) {
            builder.put((Object)String.valueOf(i), (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(i), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()), (Object)"opacity", (Object)Float.valueOf((float)color.getAlpha() / 255.0f), (Object)"border-style", (Object)"solid")));
            ++i;
        }
        int j = 0;
        builder.put((Object)NAN, (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)NAN, (Object)"background-color", (Object)RED_COLOR, (Object)"opacity", (Object)1, (Object)"border-style", (Object)"solid")));
        String noDiff = NO_DIFFERENCE;
        builder.put((Object)noDiff, (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)noDiff, (Object)"background-color", (Object)WHITE_COLOR, (Object)"opacity", (Object)1, (Object)"border-style", (Object)"solid")));
        i = 0;
        while (i <= 255) {
            j = i - 50 > 0 ? i - 50 : 0;
            String blueKey = DifferentialFlamePalette.generateBlue(i);
            builder.put((Object)blueKey, (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)blueKey, (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)j, (int)i, (int)255), (Object)"opacity", (Object)1, (Object)"border-style", (Object)"solid")));
            ++i;
        }
        i = 0;
        while (i <= 255) {
            String redKey = DifferentialFlamePalette.generateRed(i);
            builder.put((Object)redKey, (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)redKey, (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)255, (int)i, (int)i), (Object)"opacity", (Object)1, (Object)"border-style", (Object)"solid")));
            ++i;
        }
        STYLES = builder.build();
        STYLE_MAP.putAll(STYLES);
    }

    private static String generateRed(int i) {
        return "RED" + i;
    }

    private static String generateBlue(int i) {
        return "BLUE" + i;
    }

    private DifferentialFlamePalette() {
    }

    public static DifferentialFlamePalette getInstance() {
        DifferentialFlamePalette instance = fInstance;
        if (instance == null) {
            fInstance = instance = new DifferentialFlamePalette();
        }
        return instance;
    }

    public Map<String, OutputElementStyle> getStyles() {
        return STYLES;
    }

    public OutputElementStyle getStyleFor(Object object) {
        if (object instanceof DifferentialWeightedTree) {
            DifferentialWeightedTree tree = (DifferentialWeightedTree)object;
            double difference = tree.getDifference();
            double step = 255.0;
            if (Double.isNaN(difference)) {
                return STYLE_MAP.computeIfAbsent(NAN, OutputElementStyle::new);
            }
            if (difference <= 0.05 && difference >= -0.05) {
                return STYLE_MAP.computeIfAbsent(NO_DIFFERENCE, OutputElementStyle::new);
            }
            if (difference < 0.0) {
                return STYLE_MAP.computeIfAbsent(DifferentialFlamePalette.generateBlue((int)(255.0 + Math.floor(difference * step))), OutputElementStyle::new);
            }
            if (Math.abs(difference) > fMinThreshold) {
                difference = fMinThreshold;
            }
            return STYLE_MAP.computeIfAbsent(DifferentialFlamePalette.generateRed(255 - (int)Math.floor(difference / fMinThreshold * step)), OutputElementStyle::new);
        }
        throw new IllegalStateException("Cannot find the value of " + String.valueOf(object));
    }

    public static void setMinThreshold(double min) {
        fMinThreshold = Math.round(min);
    }
}

