/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2MessagesUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects.Ros2ObjectsUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2CallbackPubMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowBuildInfo;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2TransportMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2WaitMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messagelinks.Ros2MessageCausalLink;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2CallbackPublicationInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2MessageTransportInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2PubInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2SubCallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2PublisherObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2SubscriptionObject;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class Ros2SubCallbackMessageFlowSegment
extends Ros2MessageFlowSegment {
    private final @NonNull Ros2SubCallbackInstance fCallbackInstance;
    private final @NonNull Ros2SubscriptionObject fSubscription;

    public Ros2SubCallbackMessageFlowSegment(long startTime, long endTime, @NonNull Ros2SubCallbackInstance callbackInstance, @NonNull Ros2SubscriptionObject subscription) {
        super(startTime, endTime, subscription.getNodeHandle());
        this.fCallbackInstance = callbackInstance;
        this.fSubscription = subscription;
    }

    public @NonNull Ros2SubCallbackInstance getCallbackInstance() {
        return this.fCallbackInstance;
    }

    public @NonNull Ros2SubscriptionObject getSubscription() {
        return this.fSubscription;
    }

    @Override
    public @NonNull Collection<@NonNull Ros2MessageFlowSegment> getDirectSuccessors(@NonNull Ros2MessageFlowBuildInfo info) {
        ArrayList<@NonNull Ros2MessageFlowSegment> next = new ArrayList<Ros2MessageFlowSegment>();
        Iterator<@NonNull T> callbackPublicationLinks = Ros2MessagesUtil.getOutgoingCallbackPublicationLinks(info.getMessagesSs(), (Ros2ObjectHandle)((Object)this.getSubscription().getHandle()), this.getStartTime(), this.getEndTime()).iterator();
        while (callbackPublicationLinks.hasNext()) {
            Ros2CallbackPublicationInstance callbackPublicationInstance = (Ros2CallbackPublicationInstance)((Object)callbackPublicationLinks.next());
            long time = callbackPublicationInstance.getPublicationTimestamp();
            Ros2PublisherObject pubObject = Ros2ObjectsUtil.getPublisherObjectFromHandle(info.getObjectsSs(), time, callbackPublicationInstance.getPublisherHandle());
            if (pubObject == null) continue;
            next.add(new Ros2CallbackPubMessageFlowSegment(time, time, callbackPublicationInstance, this.getSubscription(), pubObject));
        }
        ITmfStateInterval nextSubCallbackInstanceInterval = Ros2MessagesUtil.getNextSubCallbackInstanceInterval(info.getMessagesSs(), info.getObjectsSs(), this.getEndTime() + 1L, (Ros2ObjectHandle)((Object)this.getSubscription().getHandle()));
        if (nextSubCallbackInstanceInterval == null) {
            return next;
        }
        long nextSubCallbackInstanceStartTime = nextSubCallbackInstanceInterval.getStartTime();
        for (Ros2MessageCausalLink link : info.getMessageLinksModel().getLinksForSub((Ros2ObjectHandle)((Object)this.getSubscription().getHandle()))) {
            for (Ros2ObjectHandle pubHandle : link.getPubs()) {
                switch (link.getType()) {
                    case PERIODIC_ASYNC: {
                        this.getWaitPeriodicAsyncSegmentsAfterSubCallback(info, next, pubHandle, nextSubCallbackInstanceStartTime);
                        break;
                    }
                    case PARTIAL_SYNC: {
                        this.getWaitPartialSyncSegmentsAfterSubCallback(info, next, pubHandle);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }
        return next;
    }

    private void getWaitPeriodicAsyncSegmentsAfterSubCallback(@NonNull Ros2MessageFlowBuildInfo info, Collection<@NonNull Ros2MessageFlowSegment> next, @NonNull Ros2ObjectHandle pubHandle, long nextSubCallbackInstanceStartTime) {
        long currentSubCallbackInstanceEndTime = this.getCallbackInstance().getCallbackInstance().getEndTime();
        for (ITmfStateInterval nextPubInstanceInterval : Ros2MessagesUtil.getPubInstanceIntervalsBetween(info.getMessagesSs(), info.getObjectsSs(), currentSubCallbackInstanceEndTime, nextSubCallbackInstanceStartTime, pubHandle)) {
            Ros2PublisherObject pubObject;
            Ros2PubInstance nextPubInstance = (Ros2PubInstance)((Object)nextPubInstanceInterval.getValue());
            if (nextPubInstance == null || (pubObject = Ros2ObjectsUtil.getPublisherObjectFromHandle(info.getObjectsSs(), nextPubInstanceInterval.getStartTime(), pubHandle)) == null) continue;
            next.add(new Ros2WaitMessageFlowSegment(this.getEndTime(), nextPubInstanceInterval.getStartTime(), this.getCallbackInstance(), nextPubInstance, this.getSubscription(), pubObject));
        }
    }

    private void getWaitPartialSyncSegmentsAfterSubCallback(@NonNull Ros2MessageFlowBuildInfo info, Collection<@NonNull Ros2MessageFlowSegment> next, @NonNull Ros2ObjectHandle pubHandle) {
        Ros2PublisherObject pubObject;
        long currentSubCallbackInstanceEndTime = this.getCallbackInstance().getCallbackInstance().getEndTime();
        ITmfStateInterval nextPubInstanceInterval = Ros2MessagesUtil.getNextPubInstanceInterval(info.getMessagesSs(), info.getObjectsSs(), currentSubCallbackInstanceEndTime + 1L, pubHandle);
        if (nextPubInstanceInterval == null) {
            return;
        }
        Ros2PubInstance nextPubInstance = (Ros2PubInstance)((Object)nextPubInstanceInterval.getValue());
        if (nextPubInstance == null) {
            return;
        }
        ITmfStateInterval nextSubCallbackInstanceInterval = Ros2MessagesUtil.getNextSubCallbackInstanceInterval(info.getMessagesSs(), info.getObjectsSs(), currentSubCallbackInstanceEndTime + 1L, (Ros2ObjectHandle)((Object)this.getSubscription().getHandle()));
        if ((nextSubCallbackInstanceInterval == null || nextPubInstanceInterval.getStartTime() < nextSubCallbackInstanceInterval.getStartTime()) && (pubObject = Ros2ObjectsUtil.getPublisherObjectFromHandle(info.getObjectsSs(), nextPubInstanceInterval.getStartTime(), pubHandle)) != null) {
            next.add(new Ros2WaitMessageFlowSegment(this.getEndTime(), nextPubInstanceInterval.getStartTime(), this.getCallbackInstance(), nextPubInstance, this.getSubscription(), pubObject));
        }
    }

    @Override
    public @NonNull Collection<@NonNull Ros2MessageFlowSegment> getDirectPredecessors(@NonNull Ros2MessageFlowBuildInfo info) {
        ArrayList<@NonNull Ros2MessageFlowSegment> previous = new ArrayList<Ros2MessageFlowSegment>();
        Iterator<@NonNull T> transportLinks = Ros2MessagesUtil.getIncomingTransportLinks(info.getMessagesSs(), this.getCallbackInstance().getTakeInstance().getStartTime(), this.getCallbackInstance().getSubscriptionHandle()).iterator();
        while (transportLinks.hasNext()) {
            Ros2MessageTransportInstance transportInstance = (Ros2MessageTransportInstance)((Object)transportLinks.next());
            Long sourceTimestamp = transportInstance.getSourceTimestamp();
            Long destinationTimestamp = transportInstance.getDestinationTimestamp();
            Ros2PublisherObject pubObject = Ros2ObjectsUtil.getPublisherObjectFromHandle(info.getObjectsSs(), sourceTimestamp, transportInstance.getPublisherHandle());
            if (pubObject == null) continue;
            previous.add(new Ros2TransportMessageFlowSegment(sourceTimestamp, destinationTimestamp, transportInstance, pubObject, this.getSubscription()));
        }
        return previous;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.fCallbackInstance, this.fSubscription, super.hashCode()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Ros2SubCallbackMessageFlowSegment)) {
            return false;
        }
        Ros2SubCallbackMessageFlowSegment o = (Ros2SubCallbackMessageFlowSegment)obj;
        if (!this.fCallbackInstance.equals((Object)o.fCallbackInstance)) {
            return false;
        }
        return this.fSubscription.equals((Object)o.fSubscription);
    }

    @Override
    public String toString() {
        return String.format("Ros2SubCallbackMessageFlowSegment: %s, callbackInstance=[%s], sub=[%s]", super.toString(), this.fCallbackInstance.toString(), this.fSubscription.toString());
    }
}

