/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostProcess;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostProcessValue;

public class HostProcessPointer
extends HostProcessValue<Long> {
    public static final byte CUSTOM_TYPE_ID_HOST_PROCESS_POINTER = 73;
    public static final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CustomStateValue.CustomStateValueFactory HOST_PROCESS_POINTER_VALUE_FACTORY = b -> HostProcessPointer.read(b);
    private static final @NonNull String HEX_PREFIX = "0x";
    private final int fSerializedValueSize;

    public HostProcessPointer(@NonNull HostProcess hostProcess, @NonNull Long pointer) {
        super(hostProcess, pointer);
        int size = 0;
        size += super.getSerializedValueSize();
        this.fSerializedValueSize = size += 8;
    }

    public @NonNull Long getPointer() {
        return (Long)super.getValue();
    }

    public boolean isNullptr() {
        return 0L == this.getPointer();
    }

    @Override
    protected @NonNull String valueToString() {
        return HEX_PREFIX + Long.toHexString(this.getPointer());
    }

    @Override
    public @NonNull String toString() {
        return String.format("HostProcessPointer: pointer=%s", super.toString());
    }

    protected @NonNull Byte getCustomTypeId() {
        return (byte)73;
    }

    @Override
    public void serializeValue(@NonNull ISafeByteBufferWriter buffer) {
        super.serializeValue(buffer);
        buffer.putLong(this.getPointer().longValue());
    }

    @Override
    public int getSerializedValueSize() {
        return this.fSerializedValueSize;
    }

    public static @NonNull HostProcessPointer read(ISafeByteBufferReader buffer) {
        HostProcess hostProcess = HostProcess.read(buffer);
        Long pointer = buffer.getLong();
        return new HostProcessPointer(hostProcess, pointer);
    }
}

