/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rse.internal.importexport.files.RemoteFileExportActionDelegate;
import org.eclipse.rse.ui.SystemBasePlugin;

public class RemoteImportExportUtil {
    private static RemoteImportExportUtil instance;

    private RemoteImportExportUtil() {
    }

    public static RemoteImportExportUtil getInstance() {
        if (instance == null) {
            instance = new RemoteImportExportUtil();
        }
        return instance;
    }

    public void exportFromDescriptionFile(IFile descriptionFile) {
        Assert.isLegal((descriptionFile != null && descriptionFile.exists() ? 1 : 0) != 0);
        IFile file = descriptionFile;
        String extension = file.getFileExtension();
        if (extension == null || extension.equals("")) {
            return;
        }
        if (extension.equals("rexpfd")) {
            RemoteFileExportActionDelegate action = new RemoteFileExportActionDelegate();
            DummyAction dummy = new DummyAction();
            action.selectionChanged((IAction)dummy, (ISelection)new StructuredSelection((Object)file));
            action.run((IAction)dummy);
        } else {
            extension.equals("rmtjardesc");
        }
    }

    public IResource findExistingResourceVariant(IPath target) {
        IWorkspace workspace = SystemBasePlugin.getWorkspace();
        boolean isCaseInsensitive = Platform.getOS().equals("win32");
        if (!isCaseInsensitive) {
            return null;
        }
        IWorkspaceRoot root = workspace.getRoot();
        IPath result = root.getFullPath();
        IWorkspaceRoot container = root;
        int segmentCount = target.segmentCount();
        int i = 0;
        while (i < segmentCount) {
            IResource[] children = null;
            if (i != 0) {
                IResource resource = root.findMember(result);
                if (resource != null && resource instanceof IContainer) {
                    container = (IContainer)resource;
                } else {
                    return null;
                }
            }
            try {
                children = container.members();
            }
            catch (CoreException e) {
                SystemBasePlugin.logError((String)("Exception occured trying to get children of " + result), (Throwable)e);
            }
            String name = this.findVariant(target.segment(i), children);
            if (name == null) {
                return null;
            }
            result = result.append(name);
            ++i;
        }
        return root.findMember(result);
    }

    private String findVariant(String target, IResource[] list) {
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            String name = list[i].getName();
            if (target.equalsIgnoreCase(name)) {
                return name;
            }
            ++i;
        }
        return null;
    }

    private class DummyAction
    extends Action {
    }
}

