/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.wizards;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.messages.ISystemMessageLine;

public class RSEDialogPageMessageLine
implements ISystemMessageLine {
    private final DialogPage page;
    private SystemMessage errorSystemMessage;

    public RSEDialogPageMessageLine(DialogPage dialogPage) {
        assert (dialogPage != null);
        this.page = dialogPage;
    }

    public void clearErrorMessage() {
        assert (this.page != null);
        if (this.page.getErrorMessage() != null) {
            this.page.setErrorMessage(null);
        }
    }

    public void clearMessage() {
        assert (this.page != null);
        this.page.setMessage(null, 0);
    }

    public String getErrorMessage() {
        assert (this.page != null);
        return this.page.getErrorMessage();
    }

    public String getMessage() {
        assert (this.page != null);
        return this.page.getMessage();
    }

    public SystemMessage getSystemErrorMessage() {
        return this.errorSystemMessage;
    }

    public void setErrorMessage(String message) {
        assert (this.page != null);
        this.page.setErrorMessage(message);
    }

    public void setErrorMessage(SystemMessage message) {
        this.errorSystemMessage = message;
        if (this.errorSystemMessage != null) {
            this.setErrorMessage(this.errorSystemMessage.getLevelOneText());
        }
    }

    public void setErrorMessage(Throwable exception) {
        if (exception != null) {
            this.setErrorMessage(exception.getLocalizedMessage());
        }
    }

    public void setMessage(String message) {
        assert (this.page != null);
        this.page.setMessage(message, 1);
    }

    public void setMessage(SystemMessage message) {
        if (message != null) {
            this.setMessage(message.getLevelOneText());
        }
    }
}

