/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.compare.EditionSelectionDialog;
import org.eclipse.compare.HistoryItem;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFile;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class SystemEditionAction
extends SystemBaseAction {
    private List _selected;
    private boolean fReplaceMode;
    private String fBundleName;
    protected boolean fPrevious = false;
    protected String fHelpContextId;

    SystemEditionAction(Shell parent, String title, String tooltip, String bundleName, boolean replaceMode) {
        super(title, parent);
        this.setToolTipText(tooltip);
        this.fReplaceMode = replaceMode;
        this.fBundleName = bundleName;
        this._selected = new ArrayList();
    }

    public boolean updateSelection(IStructuredSelection selection) {
        ISystemEditableRemoteObject editable;
        ISystemRemoteElementAdapter adapter;
        RemoteFile file;
        Object selected;
        boolean enable = false;
        this._selected.clear();
        Iterator e = selection.iterator();
        if (e.hasNext() && (selected = e.next()) != null && selected instanceof IRemoteFile && (file = (RemoteFile)selected).isFile() && (adapter = (ISystemRemoteElementAdapter)file.getAdapter(ISystemRemoteElementAdapter.class)) != null && (editable = adapter.getEditableRemoteObject((Object)file)) != null && editable.getLocalResource().exists()) {
            this._selected.add(file);
            enable = true;
        }
        return enable;
    }

    public void run() {
        IFile[] files = this.getFiles(this._selected, this.fReplaceMode);
        int i = 0;
        while (i < files.length) {
            this.doFromHistory(files[i]);
            ++i;
        }
    }

    private void doFromHistory(IFile file) {
        block13: {
            ResourceBundle bundle = ResourceBundle.getBundle(this.fBundleName, Locale.getDefault(), CompareUIPlugin.class.getClassLoader());
            String title = Utilities.getString((ResourceBundle)bundle, (String)"title");
            Shell parentShell = CompareUIPlugin.getShell();
            IFileState[] states = null;
            try {
                states = file.getHistory(null);
            }
            catch (CoreException ex) {
                MessageDialog.openError((Shell)parentShell, (String)title, (String)ex.getMessage());
                return;
            }
            if (states == null || states.length <= 0) {
                String msg = Utilities.getString((ResourceBundle)bundle, (String)"noLocalHistoryError");
                MessageDialog.openInformation((Shell)parentShell, (String)title, (String)msg);
                return;
            }
            ResourceNode base = new ResourceNode((IResource)file);
            IDocument document = this.getDocument(file);
            Object target = base;
            if (document != null) {
                target = new DocumentBufferNode(document, file);
            }
            ITypedElement[] editions = new ITypedElement[states.length + 1];
            editions[0] = base;
            int i = 0;
            while (i < states.length) {
                editions[i + 1] = new HistoryItem((ITypedElement)base, states[i]);
                ++i;
            }
            EditionSelectionDialog d = new EditionSelectionDialog(parentShell, bundle);
            d.setEditionTitleArgument(file.getName());
            d.setEditionTitleImage(CompareUIPlugin.getImage((IAdaptable)file));
            if (this.fHelpContextId != null) {
                d.setHelpContextId(this.fHelpContextId);
            }
            if (this.fReplaceMode) {
                ITypedElement ti = null;
                ti = this.fPrevious ? d.selectPreviousEdition((ITypedElement)target, editions, null) : d.selectEdition((ITypedElement)target, editions, null);
                if (ti instanceof IStreamContentAccessor) {
                    IStreamContentAccessor sa = (IStreamContentAccessor)ti;
                    try {
                        if (document != null) {
                            this.updateDocument(document, sa);
                            break block13;
                        }
                        this.updateWorkspace(bundle, parentShell, sa, file);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException x) {
                        String reason = x.getTargetException().getMessage();
                        MessageDialog.openError((Shell)parentShell, (String)title, (String)Utilities.getFormattedString((ResourceBundle)bundle, (String)"replaceError", (String)reason));
                    }
                }
            } else {
                d.setCompareMode(true);
                d.selectEdition((ITypedElement)target, editions, null);
            }
        }
    }

    private void updateWorkspace(final ResourceBundle bundle, Shell shell, final IStreamContentAccessor sa, final IFile file) throws InvocationTargetException, InterruptedException {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    try {
                        String taskName = Utilities.getString((ResourceBundle)bundle, (String)"taskName");
                        pm.beginTask(taskName, -1);
                        file.setContents(sa.getContents(), false, true, pm);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    pm.done();
                }
            }
        };
        ProgressMonitorDialog pmdialog = new ProgressMonitorDialog(shell);
        pmdialog.run(false, true, (IRunnableWithProgress)operation);
    }

    private void updateDocument(IDocument document, IStreamContentAccessor sa) throws InvocationTargetException {
        try {
            InputStream is = sa.getContents();
            String encoding = ResourcesPlugin.getEncoding();
            String text = Utilities.readString((InputStream)is, (String)encoding);
            document.replace(0, document.getLength(), text);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        catch (BadLocationException e) {
            throw new InvocationTargetException(e);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    private IDocument getDocument(IFile file) {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            return null;
        }
        IWorkbenchWindow[] ws = wb.getWorkbenchWindows();
        if (ws == null) {
            return null;
        }
        FileEditorInput test = new FileEditorInput(file);
        int i = 0;
        while (i < ws.length) {
            IWorkbenchWindow w = ws[i];
            IWorkbenchPage[] wps = w.getPages();
            if (wps != null) {
                int j = 0;
                while (j < wps.length) {
                    IDocument doc;
                    ITextEditor te;
                    IDocumentProvider dp;
                    IWorkbenchPage wp = wps[j];
                    IEditorPart ep = wp.findEditor((IEditorInput)test);
                    if (ep instanceof ITextEditor && (dp = (te = (ITextEditor)ep).getDocumentProvider()) != null && (doc = dp.getDocument((Object)ep)) != null) {
                        return doc;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private IFile[] getFiles(List remoteFiles, boolean modifiable) {
        IFile[] result = new IFile[remoteFiles.size()];
        int i = 0;
        while (i < remoteFiles.size()) {
            IRemoteFile remotefile = (IRemoteFile)remoteFiles.get(i);
            SystemEditableRemoteFile eFile = new SystemEditableRemoteFile(remotefile);
            try {
                IFile localFile;
                eFile.download(this.getShell());
                eFile.addAsListener();
                eFile.setLocalResourceProperties();
                result[i] = localFile = eFile.getLocalResource();
            }
            catch (Exception exception) {}
            ++i;
        }
        return result;
    }

    class DocumentBufferNode
    implements ITypedElement,
    IStreamContentAccessor {
        private IDocument fDocument;
        private IFile fFile;

        DocumentBufferNode(IDocument document, IFile file) {
            this.fDocument = document;
            this.fFile = file;
        }

        public String getName() {
            return this.fFile.getName();
        }

        public String getType() {
            return this.fFile.getFileExtension();
        }

        public Image getImage() {
            return null;
        }

        public InputStream getContents() {
            return new ByteArrayInputStream(this.fDocument.get().getBytes());
        }
    }
}

