/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.terminals.ssh;

import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.connectorservice.ssh.SshConnectorService;
import org.eclipse.rse.internal.connectorservice.ssh.SshConnectorServiceManager;
import org.eclipse.rse.internal.services.ssh.ISshService;
import org.eclipse.rse.internal.services.ssh.ISshSessionProvider;
import org.eclipse.rse.internal.services.ssh.terminal.SshTerminalService;
import org.eclipse.rse.services.terminals.ITerminalService;
import org.eclipse.rse.subsystems.terminals.core.TerminalServiceSubSystem;
import org.eclipse.rse.subsystems.terminals.core.TerminalServiceSubSystemConfiguration;

public class SshTerminalSubSystemConfiguration
extends TerminalServiceSubSystemConfiguration {
    public boolean isFactoryFor(Class subSystemType) {
        boolean isFor = TerminalServiceSubSystem.class.equals((Object)subSystemType);
        return isFor;
    }

    public ISubSystem createSubSystemInternal(IHost host) {
        SshConnectorService connectorService = (SshConnectorService)this.getConnectorService(host);
        TerminalServiceSubSystem subsys = new TerminalServiceSubSystem(host, (IConnectorService)connectorService, this.createTerminalService(host));
        return subsys;
    }

    public ITerminalService createTerminalService(IHost host) {
        SshConnectorService cserv = (SshConnectorService)this.getConnectorService(host);
        return new SshTerminalService((ISshSessionProvider)cserv);
    }

    public IConnectorService getConnectorService(IHost host) {
        return SshConnectorServiceManager.getInstance().getConnectorService(host, ISshService.class);
    }

    public void setConnectorService(IHost host, IConnectorService connectorService) {
        SshConnectorServiceManager.getInstance().setConnectorService(host, ISshService.class, connectorService);
    }

    public Class getServiceImplType() {
        return ISshService.class;
    }
}

