/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.internal.testsubsystem;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.tests.testsubsystem.TestSubSystemContainerNode;
import org.eclipse.rse.tests.testsubsystem.TestSubSystemNode;
import org.eclipse.rse.tests.testsubsystem.interfaces.ITestSubSystem;
import org.eclipse.rse.tests.testsubsystem.interfaces.ITestSubSystemNode;
import org.eclipse.rse.tests.testsubsystem.interfaces.ITestSubSystemNodeContainer;

public class TestSubSystem
extends SubSystem
implements ITestSubSystem {
    private ArrayList fChildren = new ArrayList();

    public TestSubSystem(IHost host, IConnectorService connectorService) {
        super(host, connectorService);
    }

    public void initializeSubSystem(IProgressMonitor monitor) throws SystemMessageException {
        super.initializeSubSystem(monitor);
        TestSubSystemContainerNode parent0 = new TestSubSystemContainerNode("0");
        TestSubSystemContainerNode child0 = new TestSubSystemContainerNode("0:0");
        parent0.addChildNode(child0);
        parent0.addChildNode(new TestSubSystemContainerNode("0:1"));
        parent0.addChildNode(new TestSubSystemContainerNode("0:2"));
        parent0.addChildNode(new TestSubSystemNode("0:3;"));
        parent0.addChildNode(new TestSubSystemContainerNode("0:4"));
        child0.addChildNode(new TestSubSystemNode("0:0:0;"));
        this.addChildNode(parent0);
        this.addChildNode(new TestSubSystemContainerNode("1"));
    }

    public void uninitializeSubSystem(IProgressMonitor monitor) {
        this.fChildren.clear();
        super.uninitializeSubSystem(monitor);
    }

    public Object getObjectWithAbsoluteName(String key, IProgressMonitor monitor) throws Exception {
        ITestSubSystemNode[] childs = this.getChildNodes();
        int i = 0;
        while (i < childs.length) {
            if (childs[i].getName().equalsIgnoreCase(key)) {
                return childs[i];
            }
            ++i;
        }
        return super.getObjectWithAbsoluteName(key, monitor);
    }

    protected Object[] internalResolveFilterString(String filterString, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ArrayList<ITestSubSystemNode> filteredChilds = new ArrayList<ITestSubSystemNode>();
        ITestSubSystemNode[] childs = this.getChildNodes();
        int i = 0;
        while (i < childs.length) {
            if (childs[i].getName().matches(filterString)) {
                filteredChilds.add(childs[i]);
            }
            ++i;
        }
        return filteredChilds.toArray();
    }

    protected Object[] internalResolveFilterString(Object parent, String filterString, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ArrayList<ITestSubSystemNode> filteredChilds = new ArrayList<ITestSubSystemNode>();
        if (parent instanceof ITestSubSystemNodeContainer) {
            ITestSubSystemNodeContainer container = (ITestSubSystemNodeContainer)parent;
            ITestSubSystemNode[] childs = container.getChildNodes();
            int i = 0;
            while (i < childs.length) {
                if (childs[i].getName().matches(filterString)) {
                    filteredChilds.add(childs[i]);
                }
                ++i;
            }
        }
        return filteredChilds.toArray();
    }

    public boolean addChildNode(ITestSubSystemNode node) {
        if (node != null && !this.fChildren.contains(node)) {
            node.setSubSystem(this);
            this.fChildren.add(node);
            return true;
        }
        return false;
    }

    public boolean removeChildNode(ITestSubSystemNode node) {
        if (node != null && this.fChildren.contains(node)) {
            if (node instanceof ITestSubSystemNodeContainer) {
                ((ITestSubSystemNodeContainer)((Object)node)).removeAllChildNodes();
            }
            this.fChildren.remove(node);
            return true;
        }
        return false;
    }

    public boolean removeAllChildNodes() {
        if (!this.fChildren.isEmpty()) {
            ITestSubSystemNode[] childs = this.getChildNodes();
            int i = 0;
            while (i < childs.length) {
                if (childs[i] instanceof ITestSubSystemNodeContainer) {
                    ((ITestSubSystemNodeContainer)((Object)childs[i])).removeAllChildNodes();
                }
                ++i;
            }
            this.fChildren.clear();
            return true;
        }
        return false;
    }

    public boolean hasChildNodes() {
        return !this.fChildren.isEmpty();
    }

    public int getChildNodeCount() {
        return this.fChildren.size();
    }

    public ITestSubSystemNode[] getChildNodes() {
        return this.fChildren.toArray(new ITestSubSystemNode[this.fChildren.size()]);
    }
}

