/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.ArrayList;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;

public class SignatureUtils {
    public static String createSignature(Type type, SearchEngine searchEngine, IJavaSearchScope scope, IProgressMonitor monitor) {
        IType element;
        IType resolvedType;
        ITypeBinding binding = type.resolveBinding();
        if (binding != null && !binding.isRecovered()) {
            return SignatureUtils.getSignature(binding);
        }
        String simpleName = SignatureUtils.simpleName(type);
        IJavaElement iJavaElement = binding.getJavaElement();
        IType iType = resolvedType = iJavaElement instanceof IType ? (element = (IType)iJavaElement) : null;
        if (resolvedType == null || resolvedType.exists()) {
            final ArrayList types = new ArrayList();
            try {
                searchEngine.searchAllTypeNames(null, 1, simpleName.toCharArray(), 0, 0, scope, new TypeNameMatchRequestor(){

                    public void acceptTypeNameMatch(TypeNameMatch match) {
                        types.add(match.getType());
                    }
                }, 3, monitor);
            }
            catch (JavaModelException ex) {
                ILog.get().error(ex.getMessage(), (Throwable)ex);
            }
            if (types.size() == 1) {
                resolvedType = (IType)types.get(0);
            }
        }
        StringBuilder res = new StringBuilder();
        if (resolvedType != null && resolvedType.exists()) {
            res.append('L');
            res.append(resolvedType.getFullyQualifiedName());
        } else {
            res.append('Q');
            res.append(simpleName);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)type;
            res.append('<');
            parameterized.typeArguments().stream().map(param -> SignatureUtils.createSignature(param, searchEngine, scope, monitor)).forEach(res::append);
            res.append('>');
        }
        res.append(';');
        return res.toString();
    }

    private static String simpleName(Type type) {
        if (type instanceof SimpleType) {
            SimpleType simple = (SimpleType)type;
            return simple.getName().toString();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)type;
            return SignatureUtils.simpleName(parameterized.getType());
        }
        return type.toString();
    }

    public static String createSignature(IType type) {
        return SignatureUtils.getSignatureForTypeKey(type.getKey());
    }

    public static String getSignature(ITypeBinding typeBinding) {
        return SignatureUtils.getSignatureForTypeKey(typeBinding.getKey());
    }

    public static char[] getSignatureChar(ITypeBinding typeBinding) {
        return SignatureUtils.getSignatureForTypeKey(typeBinding.getKey()).toCharArray();
    }

    public static String getSignatureForTypeKey(String key) {
        return key.replace('/', '.').replaceFirst("(?<=\\.|L)[_$A-Za-z][_$A-Za-z0-9]*~", "");
    }

    public static char[] getSignatureChar(IMethodBinding methodBinding) {
        return SignatureUtils.getSignatureForMethodKey(methodBinding.getKey()).toCharArray();
    }

    public static String getSignatureForMethodKey(String key) {
        String fullKey = key.replace('/', '.').replace("<+Ljava.lang.Object;>", "<*>");
        String removeName = fullKey.substring(fullKey.indexOf(40));
        int firstException = removeName.indexOf(124);
        if (firstException > 0) {
            return removeName.substring(0, firstException);
        }
        return removeName;
    }

    public static boolean isNumeric(String sig) {
        return sig.equals("B") || sig.equals("C") || sig.equals("D") || sig.equals("F") || sig.equals("I") || sig.equals("J") || sig.equals("S");
    }
}

