/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.internal.DefaultGradleBuild;
import org.eclipse.buildship.core.internal.configuration.BuildConfiguration;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ls.core.internal.ActionableNotification;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.framework.android.AndroidSupport;
import org.eclipse.jdt.ls.core.internal.framework.protobuf.ProtobufSupport;
import org.eclipse.jdt.ls.core.internal.handlers.FormatterHandler;
import org.eclipse.jdt.ls.core.internal.managers.BuildSupportManager;
import org.eclipse.jdt.ls.core.internal.managers.FormatterManager;
import org.eclipse.jdt.ls.core.internal.managers.GradleBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.managers.UpdateClasspathJob;
import org.eclipse.jdt.ls.core.internal.preferences.IPreferencesChangeListener;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.DidChangeWatchedFilesRegistrationOptions;
import org.eclipse.lsp4j.FileSystemWatcher;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.xml.sax.InputSource;

public class StandardProjectsManager
extends ProjectsManager {
    private static final String FORMATTER_OPTION_PREFIX = "org.eclipse.jdt.core.formatter";
    protected static final String BUILD_SUPPORT_EXTENSION_POINT_ID = "buildSupport";
    private static final Set<String> watchers = new LinkedHashSet<String>();
    private PreferenceManager preferenceManager;
    private boolean buildFinished;
    private boolean shouldUpdateProjects;
    private static final List<String> basicWatchers = Arrays.asList("**/*.java", "**/.project", "**/.classpath", "**/.settings/*.prefs", "**/src/**");
    private Job registerWatcherJob = new Job("Register Watchers"){

        protected IStatus run(IProgressMonitor monitor) {
            JobHelpers.waitForJobsToComplete();
            StandardProjectsManager.this.registerWatchers();
            return Status.OK_STATUS;
        }
    };
    private IPreferencesChangeListener preferenceChangeListener = null;

    @Override
    public boolean shouldUpdateProjects() {
        return this.shouldUpdateProjects;
    }

    @Override
    public void setShouldUpdateProjects(boolean shouldUpdateProjects) {
        this.shouldUpdateProjects = shouldUpdateProjects;
    }

    public StandardProjectsManager(PreferenceManager preferenceManager) {
        super(preferenceManager);
        this.preferenceManager = preferenceManager;
    }

    @Override
    public void cleanInvalidProjects(Collection<IPath> rootPaths, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        this.deleteInvalidProjects(rootPaths, (IProgressMonitor)subMonitor.split(10));
        GradleBuildSupport.cleanGradleModels((IProgressMonitor)subMonitor.split(10));
    }

    private void deleteInvalidProjects(Collection<IPath> rootPaths, IProgressMonitor monitor) {
        List workspaceProjects = rootPaths.stream().map(rootPath -> ProjectUtils.getWorkspaceInvisibleProjectName(rootPath)).collect(Collectors.toList());
        ArrayList<IProject> deleteProjectCandates = new ArrayList<IProject>();
        IProject[] iProjectArray = ProjectUtils.getAllProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!project.equals((Object)StandardProjectsManager.getDefaultProject())) {
                boolean hasSpecificDeleteProjectLogic = false;
                Optional<IBuildSupport> buildSupportOpt = BuildSupportManager.find(project);
                if (buildSupportOpt.isPresent()) {
                    hasSpecificDeleteProjectLogic = buildSupportOpt.get().hasSpecificDeleteProjectLogic();
                }
                if (project.exists() && (ResourceUtils.isContainedIn(project.getLocation(), rootPaths) || workspaceProjects.contains(project.getName()) || hasSpecificDeleteProjectLogic)) {
                    try {
                        project.getDescription();
                        if (hasSpecificDeleteProjectLogic) {
                            deleteProjectCandates.add(project);
                        }
                    }
                    catch (CoreException e) {
                        try {
                            project.delete(true, monitor);
                        }
                        catch (CoreException e1) {
                            JavaLanguageServerPlugin.logException(e1.getMessage(), e1);
                        }
                    }
                } else {
                    try {
                        project.delete(false, true, monitor);
                    }
                    catch (CoreException e1) {
                        JavaLanguageServerPlugin.logException(e1.getMessage(), e1);
                    }
                }
            }
            ++n2;
        }
        BuildSupportManager.obtainBuildSupports().stream().filter(IBuildSupport::hasSpecificDeleteProjectLogic).forEach(buildSupport -> buildSupport.deleteInvalidProjects(rootPaths, deleteProjectCandates, monitor));
    }

    @Override
    public void fileChanged(String uriString, ProjectsManager.CHANGE_TYPE changeType) {
        IResource resource;
        String settingsUrl;
        if (uriString == null) {
            return;
        }
        boolean configureNeeded = false;
        String formatterUrl = this.preferenceManager.getPreferences().getFormatterUrl();
        if (formatterUrl != null && JavaLanguageServerPlugin.getInstance().getProtocol() != null) {
            URI uri = JDTUtils.toURI(uriString);
            List<URI> uris = this.getURIs(formatterUrl);
            boolean changed = false;
            for (URI formatterUri : uris) {
                if (!URIUtil.sameURI((URI)formatterUri, (URI)uri)) continue;
                changed = true;
                break;
            }
            if (changed) {
                if (changeType == ProjectsManager.CHANGE_TYPE.DELETED || changeType == ProjectsManager.CHANGE_TYPE.CREATED) {
                    this.registerWatchers();
                }
                configureNeeded = true;
            }
        }
        if ((settingsUrl = this.preferenceManager.getPreferences().getSettingsUrl()) != null && JavaLanguageServerPlugin.getInstance().getProtocol() != null) {
            URI uri = JDTUtils.toURI(uriString);
            List<URI> uris = this.getURIs(settingsUrl);
            boolean changed = false;
            for (URI settingsURI : uris) {
                if (!URIUtil.sameURI((URI)settingsURI, (URI)uri)) continue;
                changed = true;
                break;
            }
            if (changed) {
                if (changeType == ProjectsManager.CHANGE_TYPE.DELETED || changeType == ProjectsManager.CHANGE_TYPE.CREATED) {
                    this.registerWatchers();
                }
                configureNeeded = true;
            }
        }
        if (configureNeeded) {
            StandardProjectsManager.configureSettings(this.preferenceManager.getPreferences());
        }
        if ((resource = JDTUtils.getFileOrFolder(uriString)) == null) {
            return;
        }
        try {
            IProject project = resource.getProject();
            Optional<IBuildSupport> bs = this.getBuildSupport(project);
            if (bs.isPresent()) {
                boolean requireConfigurationUpdate;
                IBuildSupport buildSupport = bs.get();
                if (JDTUtils.isExcludedFile(buildSupport.getExcludedFilePatterns(), uriString)) {
                    return;
                }
                boolean bl = requireConfigurationUpdate = buildSupport.fileChanged(resource, changeType, (IProgressMonitor)new NullProgressMonitor()) && JavaLanguageServerPlugin.getDigestStore().updateDigest(resource.getLocation().toFile().toPath());
                if (requireConfigurationUpdate) {
                    Preferences.FeatureStatus status = this.preferenceManager.getPreferences().getUpdateBuildConfigurationStatus();
                    switch (status) {
                        case automatic: {
                            if (ProjectUtils.isGradleProject(project)) {
                                DefaultGradleBuild defaultGradleBuild;
                                BuildConfiguration gradleConfig;
                                GradleBuild gradleBuild;
                                Optional build = GradleCore.getWorkspace().getBuild(project);
                                boolean syncAnnotationProcessing = true;
                                if (build.isPresent() && (gradleBuild = (GradleBuild)build.get()) instanceof DefaultGradleBuild && !(gradleConfig = (defaultGradleBuild = (DefaultGradleBuild)gradleBuild).getBuildConfig()).isAutoSync()) {
                                    this.updateProject(project, true);
                                    syncAnnotationProcessing = false;
                                }
                                if (syncAnnotationProcessing) {
                                    GradleBuildSupport.syncAnnotationProcessingConfiguration(project, (IProgressMonitor)new NullProgressMonitor());
                                }
                                return;
                            }
                            this.updateProject(project, true);
                            break;
                        }
                        case disabled: {
                            this.appendBuildFileMarker(resource);
                            break;
                        }
                        default: {
                            if (this.client != null) {
                                String cmd = "java.projectConfiguration.status";
                                TextDocumentIdentifier uri = new TextDocumentIdentifier(uriString);
                                ActionableNotification updateProjectConfigurationNotification = new ActionableNotification().withSeverity(MessageType.Info).withMessage("A build file was modified. Do you want to synchronize the Java classpath/configuration?").withCommands(Arrays.asList(new Command("Yes", cmd, Arrays.asList(new Object[]{uri, Preferences.FeatureStatus.interactive})), new Command("Always", cmd, Arrays.asList(new Object[]{uri, Preferences.FeatureStatus.automatic})), new Command("Never", cmd, Arrays.asList(new Object[]{uri, Preferences.FeatureStatus.disabled}))));
                                this.client.sendActionableNotification(updateProjectConfigurationNotification);
                            }
                            this.appendBuildFileMarker(resource);
                            break;
                        }
                    }
                }
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problem refreshing workspace", e);
        }
    }

    private void appendBuildFileMarker(IResource resource) throws CoreException {
        IMarker[] markers = resource.findMarkers("org.eclipse.jdt.ls.buildFileMarker", false, 0);
        if (markers.length > 0) {
            return;
        }
        resource.createMarker("org.eclipse.jdt.ls.buildFileMarker", Map.ofEntries(Map.entry("message", "The build file has been changed and may need reload to make it effective."), Map.entry("severity", 0)));
    }

    public static void configureSettings(Preferences preferences) {
        StandardProjectsManager.configureSettings(preferences, true);
    }

    public static void configureSettings(Preferences preferences, boolean cleanWorkspace) {
        InputStream inputStream22;
        Throwable throwable;
        URI settingsUri = preferences.getSettingsAsURI();
        URI formatterUri = preferences.getFormatterAsURI();
        if (settingsUri == null && formatterUri == null && !cleanWorkspace) {
            return;
        }
        Properties properties = null;
        if (settingsUri != null) {
            try {
                Throwable throwable2 = null;
                throwable = null;
                try {
                    inputStream22 = settingsUri.toURL().openStream();
                    try {
                        properties = new Properties();
                        properties.load(inputStream22);
                    }
                    finally {
                        if (inputStream22 != null) {
                            inputStream22.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Exception e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
                return;
            }
        }
        StandardProjectsManager.initializeDefaultOptions(preferences);
        Map<String, String> formatterOptions = null;
        if (formatterUri != null) {
            try {
                throwable = null;
                inputStream22 = null;
                try (InputStream inputStream = formatterUri.toURL().openStream();){
                    InputSource inputSource = new InputSource(inputStream);
                    String profileName = preferences.getFormatterProfileName();
                    formatterOptions = FormatterManager.readSettingsFromStream(inputSource, profileName);
                }
                catch (Throwable inputStream22) {
                    if (throwable == null) {
                        throwable = inputStream22;
                    } else if (throwable != inputStream22) {
                        throwable.addSuppressed(inputStream22);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        Map<String, String> defaultOptions = FormatterHandler.getCombinedDefaultFormatterSettings();
        if (formatterOptions != null && !formatterOptions.isEmpty()) {
            defaultOptions.putAll(formatterOptions);
        }
        Hashtable javaOptions = JavaCore.getOptions();
        defaultOptions.entrySet().stream().filter(p -> ((String)p.getKey()).startsWith(FORMATTER_OPTION_PREFIX)).forEach(p -> javaOptions.put((String)p.getKey(), (String)p.getValue()));
        if (properties != null && !properties.isEmpty()) {
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                if (k instanceof String) {
                    String path = (String)k;
                    if (v instanceof String) {
                        String[] decoded;
                        String key;
                        String value = (String)v;
                        if (!"file_export_version".equals(path) && path.charAt(0) != '@' && path.charAt(0) != '!' && (key = (decoded = EclipsePreferences.decodePath((String)path))[1]) != null) {
                            javaOptions.put(key, value);
                        }
                    }
                }
            }));
        }
        if (!Objects.equals(javaOptions, JavaCore.getOptions())) {
            JavaCore.setOptions((Hashtable)javaOptions);
        }
        if (cleanWorkspace && preferences.isAutobuildEnabled()) {
            new WorkspaceJob("Clean workspace..."){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    ResourcesPlugin.getWorkspace().build(15, monitor);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private static void initializeDefaultOptions(Preferences preferences) {
        Hashtable defaultOptions = JavaCore.getDefaultOptions();
        IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
        if (defaultVM instanceof AbstractVMInstall) {
            AbstractVMInstall jvm = (AbstractVMInstall)defaultVM;
            long jdkLevel = CompilerOptions.versionToJdkLevel((String)jvm.getJavaVersion());
            String compliance = CompilerOptions.versionFromJdkLevel((long)jdkLevel);
            JavaCore.setComplianceOptions((String)compliance, (Map)defaultOptions);
        } else {
            JavaCore.setComplianceOptions((String)"11", (Map)defaultOptions);
        }
        JavaCore.setOptions((Hashtable)defaultOptions);
        PreferenceManager.initialize();
        preferences.updateTabSizeInsertSpaces(defaultOptions);
    }

    @Override
    public boolean isBuildFile(IResource resource) {
        return this.buildSupports().filter(bs -> bs.isBuildFile(resource)).findAny().isPresent();
    }

    @Override
    public Optional<IBuildSupport> getBuildSupport(IProject project) {
        return this.buildSupports().filter(bs -> bs.applies(project)).findFirst();
    }

    @Override
    protected Stream<IBuildSupport> buildSupports() {
        IConfigurationElement[] configs;
        TreeMap<Integer, IBuildSupport> supporters = new TreeMap<Integer, IBuildSupport>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.ls.core", BUILD_SUPPORT_EXTENSION_POINT_ID);
        IConfigurationElement[] iConfigurationElementArray = configs = extensionPoint.getConfigurationElements();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            try {
                Integer order = Integer.valueOf(config.getAttribute("order"));
                supporters.put(order, (IBuildSupport)config.createExecutableExtension("class"));
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logError(config.getAttribute("class") + " implementation was skipped \n" + String.valueOf(e.getStatus()));
            }
            ++n2;
        }
        return supporters.values().stream();
    }

    @Override
    public boolean isBuildLikeFileName(String fileName) {
        return this.buildSupports().filter(bs -> bs.isBuildLikeFileName(fileName)).findAny().isPresent();
    }

    @Override
    public void prepareToSave(ISaveContext context) throws CoreException {
        if (context.getKind() == 1) {
            GradleBuildSupport.saveModels();
        }
    }

    @Override
    public void registerWatchers(boolean runInJob) {
        if (runInJob) {
            this.registerWatcherJob.schedule();
        } else {
            this.registerWatchers();
        }
    }

    @Override
    public List<FileSystemWatcher> registerWatchers() {
        JavaLanguageServerPlugin.logInfo(">> registerWatchers'");
        if (this.preferenceManager.getClientPreferences().isWorkspaceChangeWatchedFilesDynamicRegistered()) {
            LinkedHashSet<String> patterns = new LinkedHashSet<String>(basicWatchers);
            this.buildSupports().forEach(e -> e.getWatchPatterns().forEach(patterns::add));
            HashSet<IPath> sources = new HashSet<IPath>();
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            try {
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object javaProject;
                    IProject project = iProjectArray[n2];
                    if (!"jdt.ls-java-project".equals(project.getName()) && (javaProject = JavaCore.create((IProject)project)) != null && javaProject.exists()) {
                        Object classpath;
                        Object object = classpath = javaProject.getRawClasspath();
                        int n3 = ((IClasspathEntry[])classpath).length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IPath path;
                            IClasspathEntry entry = object[n4];
                            if (entry.getEntryKind() == 3 && (path = entry.getPath()) != null && !path.toString().contains("/src/") && !path.toString().endsWith("/src")) {
                                IPath location = null;
                                if (Objects.equals(entry.getPath(), project.getFullPath())) {
                                    location = project.getLocation();
                                } else {
                                    try {
                                        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                                        if (folder.exists() && !folder.isDerived()) {
                                            location = folder.getLocation();
                                        }
                                    }
                                    catch (Exception e1) {
                                        JavaLanguageServerPlugin.logException(e1.getMessage(), e1);
                                    }
                                }
                                if (location != null && !ResourceUtils.isContainedIn(location, sources)) {
                                    sources.add(location);
                                }
                            }
                            if (entry.getEntryKind() == 1) {
                                path = entry.getPath();
                                try {
                                    IPath location;
                                    IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                                    if (resource != null && !resource.isDerived() && (location = resource.getLocation()) != null && !ResourceUtils.isContainedIn(location, sources)) {
                                        sources.add(location);
                                    }
                                }
                                catch (Exception e1) {
                                    JavaLanguageServerPlugin.logException(e1.getMessage(), e1);
                                }
                            }
                            ++n4;
                        }
                        if (!ProjectUtils.isVisibleProject(project)) {
                            IPath projectFolder = ProjectUtils.getProjectRealFolder(project);
                            Set<String> libraries = this.preferenceManager.getPreferences().getReferencedLibraries().getInclude();
                            for (String pattern : libraries) {
                                patterns.add(ProjectUtils.resolveGlobPath(projectFolder, pattern).toPortableString());
                            }
                            patterns.add("**/.settings");
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e2) {
                JavaLanguageServerPlugin.logException(e2.getMessage(), e2);
            }
            ArrayList<FileSystemWatcher> fileWatchers = new ArrayList<FileSystemWatcher>();
            patterns.addAll(sources.stream().map(ResourceUtils::toGlobPattern).collect(Collectors.toList()));
            sources.clear();
            URI formatter = this.preferenceManager.getPreferences().getFormatterAsURI();
            if (formatter == null && this.preferenceManager.getPreferences().getFormatterUrl() != null) {
                List<URI> uris = this.getURIs(this.preferenceManager.getPreferences().getFormatterUrl());
                for (URI uri : uris) {
                    this.addWatcher(uri, sources);
                }
            } else {
                this.addWatcher(formatter, sources);
            }
            URI settings = this.preferenceManager.getPreferences().getSettingsAsURI();
            if (settings == null && this.preferenceManager.getPreferences().getSettingsUrl() != null) {
                List<URI> uris = this.getURIs(this.preferenceManager.getPreferences().getSettingsUrl());
                for (URI uri : uris) {
                    this.addWatcher(uri, sources);
                }
            } else {
                this.addWatcher(settings, sources);
            }
            patterns.addAll(sources.stream().map(p -> ResourceUtils.toGlobPattern(p, false)).collect(Collectors.toList()));
            for (String pattern : patterns) {
                FileSystemWatcher watcher = new FileSystemWatcher(Either.forLeft((Object)pattern));
                fileWatchers.add(watcher);
            }
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n5 = 0;
            while (n5 < n) {
                IProject project = iProjectArray[n5];
                if (ProjectUtils.isVisibleProject(project) && project.exists()) {
                    FileSystemWatcher watcher = new FileSystemWatcher(Either.forLeft((Object)ResourceUtils.toGlobPattern(project.getLocation(), false)), Integer.valueOf(4));
                    fileWatchers.add(watcher);
                }
                ++n5;
            }
            if (!patterns.equals(watchers)) {
                JavaLanguageServerPlugin.logInfo(">> registerFeature 'workspace/didChangeWatchedFiles'");
                DidChangeWatchedFilesRegistrationOptions didChangeWatchedFilesRegistrationOptions = new DidChangeWatchedFilesRegistrationOptions(fileWatchers);
                JavaLanguageServerPlugin.getInstance().unregisterCapability(Preferences.WORKSPACE_WATCHED_FILES_ID, "workspace/didChangeWatchedFiles");
                JavaLanguageServerPlugin.getInstance().registerCapability(Preferences.WORKSPACE_WATCHED_FILES_ID, "workspace/didChangeWatchedFiles", didChangeWatchedFilesRegistrationOptions);
                watchers.clear();
                watchers.addAll(patterns);
            }
            return fileWatchers;
        }
        return Collections.emptyList();
    }

    private List<URI> getURIs(String url) {
        URI uri;
        ArrayList<URI> result;
        block8: {
            if (url == null) {
                return Collections.emptyList();
            }
            result = new ArrayList<URI>();
            try {
                uri = new URI(ResourceUtils.toClientUri(url));
                if (!uri.isAbsolute()) break block8;
                if ("file".equals(uri.getScheme())) {
                    url = Path.fromOSString((String)Paths.get(uri).toString()).toString();
                    break block8;
                }
                result.add(uri);
                return result;
            }
            catch (URISyntaxException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        if (url.startsWith("/") && new File(url).isFile()) {
            uri = new File(url).toURI();
            result.add(uri);
        } else {
            Collection<IPath> rootPaths = this.preferenceManager.getPreferences().getRootPaths();
            if (rootPaths != null) {
                for (IPath rootPath : rootPaths) {
                    File f = new File(rootPath.toOSString(), url);
                    result.add(f.toURI());
                }
            }
        }
        return result;
    }

    private void addWatcher(URI uri, Set<IPath> sources) {
        if (uri != null && "file".equals(uri.getScheme())) {
            try {
                Path path;
                File file = new File(uri);
                if (file != null && !ResourceUtils.isContainedIn((IPath)(path = new Path(file.getAbsolutePath())), sources)) {
                    sources.add((IPath)path);
                }
            }
            catch (Exception e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void registerListeners() {
        StandardProjectsManager.configureSettings(this.preferenceManager.getPreferences(), false);
        if (this.preferenceChangeListener == null) {
            this.preferenceChangeListener = new IPreferencesChangeListener(){

                @Override
                public void preferencesChange(Preferences oldPreferences, Preferences newPreferences) {
                    if (!oldPreferences.getReferencedLibraries().equals(newPreferences.getReferencedLibraries())) {
                        StandardProjectsManager.this.registerWatcherJob.schedule(100L);
                        UpdateClasspathJob.getInstance().updateClasspath();
                    }
                    if (!Objects.equals(oldPreferences.getFormatterUrl(), newPreferences.getFormatterUrl()) || !Objects.equals(oldPreferences.getSettingsUrl(), newPreferences.getSettingsUrl())) {
                        StandardProjectsManager.this.registerWatcherJob.schedule(100L);
                    }
                    if (!(Objects.equals(oldPreferences.getFormatterUrl(), newPreferences.getFormatterUrl()) && Objects.equals(oldPreferences.getFormatterProfileName(), newPreferences.getFormatterProfileName()) && Objects.equals(oldPreferences.getSettingsUrl(), newPreferences.getSettingsUrl()))) {
                        StandardProjectsManager.configureSettings(newPreferences);
                    }
                    if (!Objects.equals(oldPreferences.getResourceFilters(), newPreferences.getResourceFilters())) {
                        try {
                            StandardProjectsManager.this.configureFilters((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            JavaLanguageServerPlugin.logException(e.getMessage(), e);
                        }
                    }
                    if (!Objects.equals((Object)oldPreferences.getProjectEncoding(), (Object)newPreferences.getProjectEncoding())) {
                        IProject[] iProjectArray = ProjectUtils.getAllProjects();
                        int n = iProjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject project = iProjectArray[n2];
                            StandardProjectsManager.this.updateProject(project, true);
                            ++n2;
                        }
                    }
                }
            };
            this.preferenceManager.addPreferencesChangeListener(this.preferenceChangeListener);
        }
        this.buildSupports().forEach(p -> {
            try {
                p.registerPreferencesChangeListener(this.preferenceManager);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        });
    }

    @Override
    public void unregisterListeners() {
        if (this.preferenceChangeListener == null) {
            this.preferenceManager.removePreferencesChangeListener(this.preferenceChangeListener);
        }
        this.buildSupports().forEach(p -> {
            try {
                p.unregisterPreferencesChangeListener(this.preferenceManager);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        });
    }

    @Override
    public void projectsImported(IProgressMonitor monitor) {
        ProtobufSupport protobufSupport = new ProtobufSupport();
        protobufSupport.onDidProjectsImported(monitor);
        AndroidSupport androidSupport = new AndroidSupport();
        androidSupport.onDidProjectsImported(monitor);
        this.preferenceManager.getPreferences().updateAnnotationNullAnalysisOptions();
    }

    public static void cleanInvalidJavaProjects(IProgressMonitor monitor) {
        IJavaProject[] iJavaProjectArray = ProjectUtils.getJavaProjects();
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile classpathFile;
            IJavaProject javaProject = iJavaProjectArray[n2];
            IProject project = javaProject.getProject();
            if (!project.equals((Object)StandardProjectsManager.getDefaultProject()) && !(classpathFile = project.getFile(".classpath")).exists()) {
                try {
                    JavaLanguageServerPlugin.logInfo("The '" + project.getName() + "' project has no .classpath. Removing Java nature and builder.");
                    ProjectUtils.removeJavaNatureAndBuilder(project, monitor);
                }
                catch (CoreException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
            }
            ++n2;
        }
    }

    @Override
    public void projectsBuildFinished(IProgressMonitor monitor) {
        this.buildFinished = true;
        if (this.shouldUpdateProjects) {
            IProject[] iProjectArray = ProjectUtils.getAllProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (ProjectUtils.isMavenProject(project)) {
                    this.updateProject(project, true);
                }
                ++n2;
            }
            this.shouldUpdateProjects = false;
        }
    }

    @Override
    public boolean isBuildFinished() {
        return this.buildFinished;
    }

    @Override
    public void checkIndexes() {
        Job job = new Job("Check JDK Index"){

            protected IStatus run(IProgressMonitor monitor) {
                IJavaProject[] javaProjects = ProjectUtils.getJavaProjects();
                if (javaProjects.length <= 0) {
                    return Status.OK_STATUS;
                }
                SearchEngine engine = new SearchEngine();
                IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
                final boolean[] found = new boolean[1];
                try {
                    engine.searchAllTypeNames("java.lang".toCharArray(), 0, "String".toCharArray(), 10, 5, scope, new TypeNameRequestor(){

                        public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                            found[0] = true;
                        }
                    }, 3, monitor);
                }
                catch (JavaModelException javaModelException) {
                }
                catch (OperationCanceledException e) {
                    return Status.CANCEL_STATUS;
                }
                if (!found[0]) {
                    try {
                        JavaLanguageServerPlugin.logInfo("Unable to locate JDK types through index. Attempting to rebuild all indexes.");
                        JavaCore.rebuildIndex((IProgressMonitor)monitor);
                    }
                    catch (CoreException e) {
                        JavaLanguageServerPlugin.logException(e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

