/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;

class DOMCompletionEngineBuilder {
    private static final String EXTENDS = "extends";
    private static final String THROWS = "throws";
    private static final String SUPER = "super";

    DOMCompletionEngineBuilder() {
    }

    static void createMethod(IMethodBinding methodBinding, StringBuilder completion) {
        ITypeBinding[] typeVariableBindings;
        int insertedModifiers = methodBinding.getModifiers() & 0xFFFFFAFF;
        if (insertedModifiers != 0) {
            ASTNode.printModifiers((int)insertedModifiers, (StringBuilder)completion);
        }
        if ((typeVariableBindings = methodBinding.getTypeParameters()) != null && typeVariableBindings.length != 0) {
            completion.append('<');
            for (int i = 0; i < typeVariableBindings.length; ++i) {
                if (i != 0) {
                    completion.append(',');
                    completion.append(' ');
                }
                DOMCompletionEngineBuilder.createTypeVariable(typeVariableBindings[i], completion);
            }
            completion.append('>');
            completion.append(' ');
        }
        DOMCompletionEngineBuilder.createType(methodBinding.getReturnType(), completion);
        completion.append(' ');
        completion.append(methodBinding.getName());
        completion.append('(');
        ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
        String[] parameterNames = methodBinding.getParameterNames();
        int length = parameterTypes.length;
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                completion.append(',');
                completion.append(' ');
            }
            DOMCompletionEngineBuilder.createType(parameterTypes[i], completion);
            completion.append(' ');
            if (parameterNames != null) {
                completion.append(parameterNames[i]);
                continue;
            }
            completion.append('%');
        }
        completion.append(')');
        ITypeBinding[] exceptions = methodBinding.getExceptionTypes();
        if (exceptions != null && exceptions.length > 0) {
            completion.append(' ');
            completion.append(THROWS);
            completion.append(' ');
            for (int i = 0; i < exceptions.length; ++i) {
                if (i != 0) {
                    completion.append(' ');
                    completion.append(',');
                }
                DOMCompletionEngineBuilder.createType(exceptions[i], completion);
            }
        }
    }

    static void createType(ITypeBinding type, StringBuilder completion) {
        if (type.isWildcardType() || type.isIntersectionType()) {
            completion.append('?');
            if (type.isUpperbound() && type.getBound() != null) {
                completion.append(' ');
                completion.append(EXTENDS);
                completion.append(' ');
                DOMCompletionEngineBuilder.createType(type.getBound(), completion);
                if (type.getTypeBounds() != null) {
                    for (ITypeBinding bound : type.getTypeBounds()) {
                        completion.append(' ');
                        completion.append('&');
                        completion.append(' ');
                        DOMCompletionEngineBuilder.createType(bound, completion);
                    }
                }
            } else if (type.getBound() != null) {
                completion.append(' ');
                completion.append(SUPER);
                completion.append(' ');
                DOMCompletionEngineBuilder.createType(type.getBound(), completion);
            }
        } else if (type.isArray()) {
            DOMCompletionEngineBuilder.createType(type.getElementType(), completion);
            int dim = type.getDimensions();
            for (int i = 0; i < dim; ++i) {
                completion.append("[]");
            }
        } else if (type.isParameterizedType()) {
            if (type.isMember()) {
                DOMCompletionEngineBuilder.createType(type.getDeclaringClass(), completion);
                completion.append('.');
                completion.append(type.getName());
            } else {
                completion.append(type.getQualifiedName());
            }
            ITypeBinding[] typeArguments = type.getTypeArguments();
            if (typeArguments != null) {
                completion.append('<');
                int length = typeArguments.length;
                for (int i = 0; i < length; ++i) {
                    if (i != 0) {
                        completion.append(',');
                    }
                    DOMCompletionEngineBuilder.createType(typeArguments[i], completion);
                }
                completion.append('>');
            }
        } else {
            completion.append(type.getQualifiedName());
        }
    }

    static void createTypeVariable(ITypeBinding typeVariable, StringBuilder completion) {
        completion.append(typeVariable.getName());
        if (typeVariable.getSuperclass() != null && typeVariable.getTypeBounds()[0].getKey().equals(typeVariable.getSuperclass().getKey())) {
            completion.append(' ');
            completion.append(EXTENDS);
            completion.append(' ');
            DOMCompletionEngineBuilder.createType(typeVariable.getSuperclass(), completion);
        }
        if (typeVariable.getInterfaces() != null) {
            if (!typeVariable.getTypeBounds()[0].getKey().equals(typeVariable.getSuperclass().getKey())) {
                completion.append(' ');
                completion.append(EXTENDS);
                completion.append(' ');
            }
            int length = typeVariable.getInterfaces().length;
            for (int i = 0; i < length; ++i) {
                if (i > 0 || typeVariable.getTypeBounds()[0].getKey().equals(typeVariable.getSuperclass().getKey())) {
                    completion.append(' ');
                    completion.append(EXTENDS);
                    completion.append(' ');
                }
                DOMCompletionEngineBuilder.createType(typeVariable.getInterfaces()[i], completion);
            }
        }
    }

    static char[] getSignature(IMethodBinding methodBinding) {
        String fullKey = methodBinding.getKey().replace('/', '.');
        String removeName = fullKey.substring(fullKey.indexOf(40));
        int firstException = removeName.indexOf(124);
        if (firstException > 0) {
            return removeName.substring(0, firstException).toCharArray();
        }
        return removeName.toCharArray();
    }

    static char[] getSignature(ITypeBinding typeBinding) {
        return typeBinding.getKey().replace('/', '.').toCharArray();
    }
}

