/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeReferencePattern;

public class SuperTypeReferenceLocator
extends PatternLocator {
    protected SuperTypeReferencePattern pattern;

    public SuperTypeReferenceLocator(SuperTypeReferencePattern pattern) {
        super(pattern);
        this.pattern = pattern;
    }

    @Override
    public int match(org.eclipse.jdt.internal.compiler.ast.LambdaExpression node, MatchingNodeSet nodeSet) {
        if (this.pattern.superRefKind != 1) {
            return 0;
        }
        nodeSet.mustResolve = true;
        return nodeSet.addMatch((ASTNode)node, 2);
    }

    @Override
    public int match(LambdaExpression node, MatchingNodeSet nodeSet) {
        if (this.pattern.superRefKind != 1) {
            return 0;
        }
        nodeSet.mustResolve = true;
        return nodeSet.addMatch(node, 2);
    }

    @Override
    public int match(TypeReference node, MatchingNodeSet nodeSet) {
        if (this.flavors != 4096) {
            return 0;
        }
        if (this.pattern.superSimpleName == null) {
            return nodeSet.addMatch((ASTNode)node, this.pattern.mustResolve ? 2 : 3);
        }
        char[] typeRefSimpleName = null;
        if (node instanceof SingleTypeReference) {
            typeRefSimpleName = ((SingleTypeReference)node).token;
        } else {
            char[][] tokens = ((QualifiedTypeReference)node).tokens;
            typeRefSimpleName = tokens[tokens.length - 1];
        }
        if (this.matchesName(this.pattern.superSimpleName, typeRefSimpleName)) {
            return nodeSet.addMatch((ASTNode)node, this.pattern.mustResolve ? 2 : 3);
        }
        return 0;
    }

    @Override
    public int match(Type node, MatchingNodeSet nodeSet) {
        if (this.flavors != 4096) {
            return 0;
        }
        if (this.pattern.superSimpleName == null) {
            return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
        }
        char[] typeRefSimpleName = null;
        if (node instanceof SimpleType) {
            Name name;
            SimpleType simple = (SimpleType)node;
            Name name2 = simple.getName();
            if (name2 instanceof SimpleName) {
                SimpleName name3 = (SimpleName)name2;
                typeRefSimpleName = name3.getIdentifier().toCharArray();
            }
            if ((name = simple.getName()) instanceof QualifiedName) {
                QualifiedName name4 = (QualifiedName)name;
                typeRefSimpleName = name4.getName().getIdentifier().toCharArray();
            }
        } else if (node instanceof QualifiedType) {
            QualifiedType qualified = (QualifiedType)node;
            typeRefSimpleName = qualified.getName().getIdentifier().toCharArray();
        }
        if (this.matchesName(this.pattern.superSimpleName, typeRefSimpleName)) {
            return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
        }
        return 0;
    }

    @Override
    protected int matchContainer() {
        return 2;
    }

    @Override
    protected void matchReportReference(ASTNode reference, IJavaElement element, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        if (elementBinding instanceof ReferenceBinding) {
            ReferenceBinding referenceBinding = (ReferenceBinding)elementBinding;
            if (referenceBinding.isClass() && this.pattern.typeSuffix == 'I') {
                return;
            }
            if (referenceBinding.isInterface() && this.pattern.typeSuffix == 'C') {
                return;
            }
        }
        super.matchReportReference(reference, element, elementBinding, accuracy, locator);
    }

    @Override
    protected int referenceType() {
        return 7;
    }

    @Override
    public int resolveLevel(ASTNode node) {
        TypeBinding typeBinding = null;
        if (node instanceof org.eclipse.jdt.internal.compiler.ast.LambdaExpression) {
            org.eclipse.jdt.internal.compiler.ast.LambdaExpression lambda = (org.eclipse.jdt.internal.compiler.ast.LambdaExpression)node;
            typeBinding = lambda.resolvedType;
        } else {
            if (!(node instanceof TypeReference)) {
                return 0;
            }
            TypeReference typeRef = (TypeReference)node;
            typeBinding = typeRef.resolvedType;
        }
        if (typeBinding instanceof ArrayBinding) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        if (typeBinding instanceof ProblemReferenceBinding) {
            typeBinding = ((ProblemReferenceBinding)typeBinding).closestMatch();
        }
        if (typeBinding == null || !typeBinding.isValidBinding()) {
            return 1;
        }
        return this.resolveLevelForType(this.pattern.superSimpleName, this.pattern.superQualification, typeBinding);
    }

    @Override
    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof ReferenceBinding)) {
            return 0;
        }
        ReferenceBinding type = (ReferenceBinding)binding;
        int level = 0;
        if (this.pattern.superRefKind != 1 && (level = this.resolveLevelForType(this.pattern.superSimpleName, this.pattern.superQualification, (TypeBinding)type.superclass())) == 3) {
            return 3;
        }
        if (this.pattern.superRefKind != 2) {
            ReferenceBinding[] superInterfaces;
            ReferenceBinding[] referenceBindingArray = superInterfaces = type.superInterfaces();
            int n = superInterfaces.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceBinding superInterface = referenceBindingArray[n2];
                int newLevel = this.resolveLevelForType(this.pattern.superSimpleName, this.pattern.superQualification, (TypeBinding)superInterface);
                if (newLevel > level) {
                    if (newLevel == 3) {
                        return 3;
                    }
                    level = newLevel;
                }
                ++n2;
            }
        }
        return level;
    }

    @Override
    public int resolveLevel(IBinding binding) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof ITypeBinding)) {
            return 0;
        }
        ITypeBinding type = (ITypeBinding)binding;
        int level = 0;
        if (this.pattern.superRefKind != 1 && (level = this.resolveLevelForType(this.pattern.superSimpleName, this.pattern.superQualification, type.getSuperclass())) == 3) {
            return 3;
        }
        if (this.pattern.superRefKind != 2) {
            ITypeBinding[] iTypeBindingArray = type.getInterfaces();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding superInterface = iTypeBindingArray[n2];
                int newLevel = this.resolveLevelForType(this.pattern.superSimpleName, this.pattern.superQualification, superInterface);
                if (newLevel > level) {
                    if (newLevel == 3) {
                        return 3;
                    }
                    level = newLevel;
                }
                ++n2;
            }
        }
        return level;
    }

    @Override
    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

