/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.stream.Stream;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.IGenerateTypeCheck;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class InstanceOfExpression
extends OperatorExpression
implements IGenerateTypeCheck {
    public Expression expression;
    public TypeReference type;
    public Pattern pattern;
    private static final char[] SECRET_EXPRESSION_VALUE = " secretExpressionValue".toCharArray();
    private LocalVariableBinding secretExpressionValue = null;
    private Pattern.TestContextRecord testContextRecord;

    public InstanceOfExpression(Expression expression, TypeReference type) {
        this.expression = expression;
        this.type = type;
        type.bits |= 0x40000000;
        this.bits |= 0x1700;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = type.sourceEnd;
    }

    public InstanceOfExpression(Expression expression, Pattern pattern) {
        this.expression = expression;
        this.pattern = pattern;
        this.type = pattern.getType();
        this.type.bits |= 0x40000000;
        this.bits |= 0x1700;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = this.pattern.sourceEnd;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FieldBinding field;
        LocalVariableBinding local = this.expression.localVariableBinding();
        FlowInfo initsWhenTrue = null;
        if (local != null && (local.type.tagBits & 2L) == 0L) {
            flowInfo = this.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
            initsWhenTrue = flowInfo.copy();
            initsWhenTrue.markAsComparedEqualToNonNull(local);
            flowContext.recordUsingNullReference(currentScope, local, this.expression, 1025, flowInfo);
            flowInfo = FlowInfo.conditional(initsWhenTrue.copy(), flowInfo.copy());
        } else if (this.expression instanceof Reference && currentScope.compilerOptions().enableSyntacticNullAnalysisForFields && (field = ((Reference)this.expression).lastFieldBinding()) != null && (field.type.tagBits & 2L) == 0L) {
            flowContext.recordNullCheckedFieldReference((Reference)this.expression, 1);
        }
        if (initsWhenTrue == null) {
            flowInfo = this.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        }
        if (this.pattern != null) {
            FlowInfo patternFlow = this.pattern.analyseCode(currentScope, flowContext, initsWhenTrue == null ? flowInfo : initsWhenTrue);
            initsWhenTrue = initsWhenTrue == null ? patternFlow : initsWhenTrue.addInitializationsFrom(patternFlow);
        }
        return initsWhenTrue == null ? flowInfo : FlowInfo.conditional(initsWhenTrue, flowInfo.copy());
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        BranchLabel continueLabel;
        BranchLabel falseLabel;
        if (this.pattern != null) {
            falseLabel = new BranchLabel(codeStream);
            continueLabel = new BranchLabel(codeStream);
        } else {
            falseLabel = null;
            continueLabel = null;
        }
        this.generateOptimizedBoolean(currentScope, codeStream, null, falseLabel, true);
        if (this.pattern != null) {
            if (valueRequired) {
                codeStream.iconst_1();
                codeStream.goto_(continueLabel);
            }
            falseLabel.place();
            Stream.of(this.bindingsWhenTrue()).forEach(v -> v.recordInitializationEndPC(codeStream.position));
            if (valueRequired) {
                codeStream.iconst_0();
            }
            continueLabel.place();
        }
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else if (this.pattern == null) {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
    }

    @Override
    public void generateOptimizedBoolean(BlockScope currentScope, CodeStream codeStream, BranchLabel trueLabel, BranchLabel falseLabel, boolean valueRequired) {
        int pc = codeStream.position;
        this.expression.generateCode(currentScope, codeStream, true);
        if (this.secretExpressionValue != null) {
            codeStream.store(this.secretExpressionValue, true);
            codeStream.addVariable(this.secretExpressionValue);
        }
        BranchLabel internalFalseLabel = falseLabel != null ? falseLabel : (this.pattern != null ? new BranchLabel(codeStream) : null);
        Pattern.PrimitiveConversionRoute route = Pattern.PrimitiveConversionRoute.NO_CONVERSION_ROUTE;
        TypeBinding providedType = null;
        if (this.testContextRecord != null) {
            route = this.testContextRecord.route();
            providedType = this.testContextRecord.right();
        }
        this.generateTypeCheck(providedType, this.type, currentScope, codeStream, internalFalseLabel, route);
        if (this.pattern != null) {
            codeStream.ifeq(internalFalseLabel);
            if (this.secretExpressionValue != null) {
                codeStream.load(this.secretExpressionValue);
                codeStream.removeVariable(this.secretExpressionValue);
            } else {
                this.expression.generateCode(currentScope, codeStream, true);
            }
            this.pattern.generateCode(currentScope, codeStream, trueLabel, internalFalseLabel);
        } else if (!valueRequired) {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
        int position = codeStream.position;
        if (valueRequired) {
            if (falseLabel == null) {
                if (trueLabel != null) {
                    if (this.pattern != null) {
                        Stream.of(this.bindingsWhenTrue()).forEach(v -> v.recordInitializationEndPC(codeStream.position));
                        codeStream.goto_(trueLabel);
                    } else {
                        codeStream.ifne(trueLabel);
                    }
                }
            } else if (trueLabel == null && this.pattern == null) {
                codeStream.ifeq(falseLabel);
            }
        }
        codeStream.recordPositionsFrom(position, this.sourceEnd);
        if (internalFalseLabel != falseLabel) {
            internalFalseLabel.place();
        }
    }

    @Override
    public void setPatternIsTotalType() {
        if (this.pattern != null) {
            this.pattern.isTotalTypeNode = true;
        }
    }

    @Override
    public void consumeProvidedValue(TypeBinding provided, CodeStream codeStream) {
        LocalVariableBinding local = this.expression.localVariableBinding();
        LocalVariableBinding localVariableBinding = local = local != null ? local : this.secretExpressionValue;
        if (local != null) {
            codeStream.store(local, false);
        }
    }

    @Override
    public StringBuilder printExpressionNoParenthesis(int indent, StringBuilder output) {
        this.expression.printExpression(indent, output).append(" instanceof ");
        return this.pattern == null ? this.type.print(0, output) : this.pattern.printExpression(0, output);
    }

    @Override
    public LocalVariableBinding[] bindingsWhenTrue() {
        return this.pattern != null ? this.pattern.bindingsWhenTrue() : NO_VARIABLES;
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        TypeBinding checkedType = this.type.resolveType(scope, true);
        if (this.expression instanceof CastExpression) {
            ((CastExpression)this.expression).setInstanceofType(checkedType);
        }
        TypeBinding expressionType = this.expression.resolveType(scope);
        if (this.pattern != null) {
            this.expression.computeConversion(scope, expressionType, expressionType);
            this.pattern.setExpressionContext(ExpressionContext.TESTING_CONTEXT);
            this.pattern.setOuterExpressionType(this.expression.resolvedType);
            this.pattern.resolveType(scope);
            this.addSecretExpressionValue(scope, expressionType);
        }
        if (expressionType != null && checkedType != null && this.type.hasNullTypeAnnotation(TypeReference.AnnotationPosition.ANY) && (!expressionType.isCompatibleWith(checkedType) || NullAnnotationMatching.analyse(checkedType, expressionType, -1).isAnyMismatch())) {
            scope.problemReporter().nullAnnotationUnsupportedLocation(this.type);
        }
        if (expressionType == null || checkedType == null) {
            return null;
        }
        if (!checkedType.isReifiable()) {
            CompilerOptions options = scope.compilerOptions();
            if (options.complianceLevel < 0x3C0000L) {
                scope.problemReporter().illegalInstanceOfGenericType(checkedType, this);
            } else if (expressionType != TypeBinding.NULL) {
                boolean isLegal = this.checkCastTypesCompatibility(scope, checkedType, expressionType, this.expression, true);
                if (!isLegal || (this.bits & 0x80) != 0) {
                    scope.problemReporter().unsafeCastInInstanceof(this.expression, checkedType, expressionType);
                } else {
                    this.checkRefForPrimitivesAndAddSecretVariable(scope, checkedType, expressionType);
                }
            }
        } else if (checkedType.isValidBinding() && (expressionType != TypeBinding.NULL && expressionType.isBaseType() || checkedType.isBaseType() || !this.checkCastTypesCompatibility(scope, checkedType, expressionType, null, true))) {
            this.checkForPrimitives(scope, checkedType, expressionType);
        }
        this.resolvedType = TypeBinding.BOOLEAN;
        return this.resolvedType;
    }

    private void checkForPrimitives(BlockScope scope, TypeBinding checkedType, TypeBinding expressionType) {
        Pattern.PrimitiveConversionRoute route = Pattern.findPrimitiveConversionRoute(checkedType, expressionType, scope);
        this.testContextRecord = new Pattern.TestContextRecord(checkedType, expressionType, route);
        if (route != Pattern.PrimitiveConversionRoute.WIDENING_PRIMITIVE_CONVERSION && route != Pattern.PrimitiveConversionRoute.NARROWING_PRIMITVE_CONVERSION && route != Pattern.PrimitiveConversionRoute.WIDENING_AND_NARROWING_PRIMITIVE_CONVERSION) {
            if (route == Pattern.PrimitiveConversionRoute.BOXING_CONVERSION || route == Pattern.PrimitiveConversionRoute.BOXING_CONVERSION_AND_WIDENING_REFERENCE_CONVERSION) {
                this.addSecretExpressionValue(scope, expressionType);
            } else if (route == Pattern.PrimitiveConversionRoute.NO_CONVERSION_ROUTE) {
                scope.problemReporter().notCompatibleTypesError(this, expressionType, checkedType);
            }
        }
    }

    private void checkRefForPrimitivesAndAddSecretVariable(BlockScope scope, TypeBinding checkedType, TypeBinding expressionType) {
        if (!JavaFeature.PRIMITIVES_IN_PATTERNS.isSupported(scope.compilerOptions())) {
            return;
        }
        Pattern.PrimitiveConversionRoute route = Pattern.findPrimitiveConversionRoute(checkedType, expressionType, scope);
        this.testContextRecord = new Pattern.TestContextRecord(checkedType, expressionType, route);
    }

    private void addSecretExpressionValue(BlockScope scope, TypeBinding expressionType) {
        if ((this.expression.bits & 7) != 2) {
            TypeBinding type1 = this.expression.resolvedType != null && this.expression.resolvedType.isBaseType() ? this.expression.resolvedType : TypeBinding.wellKnownType(scope, 1);
            LocalVariableBinding local = new LocalVariableBinding(SECRET_EXPRESSION_VALUE, type1, 0, false);
            local.setConstant(Constant.NotAConstant);
            local.useFlag = 1;
            scope.addLocalVariable(local);
            this.secretExpressionValue = local;
            if (expressionType != TypeBinding.NULL) {
                this.secretExpressionValue.type = expressionType;
            }
        }
    }

    @Override
    public boolean checkUnsafeCast(Scope scope, TypeBinding castType, TypeBinding expressionType, TypeBinding match, boolean isNarrowing) {
        if (!castType.isReifiable()) {
            return CastExpression.checkUnsafeCast(this, scope, castType, expressionType, match, isNarrowing);
        }
        return super.checkUnsafeCast(scope, castType, expressionType, match, isNarrowing);
    }

    @Override
    public void tagAsUnnecessaryCast(Scope scope, TypeBinding castType) {
        if (this.pattern != null) {
            return;
        }
        if (this.expression.resolvedType != TypeBinding.NULL) {
            scope.problemReporter().unnecessaryInstanceof(this, castType);
        }
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
            if (this.pattern != null) {
                this.pattern.traverse(visitor, scope);
            } else {
                this.type.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }
}

