/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.plugin.internal.ResolveMainMethodHandler;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;

public class ResolveElementHandler {
    public static Object resolveElementAtSelection(List<Object> arguments, IProgressMonitor monitor) throws DebugException {
        if (arguments == null || arguments.size() < 3) {
            return Collections.emptyList();
        }
        String uri = (String)arguments.get(0);
        int line = (int)Math.round((Double)arguments.get(1));
        int column = (int)Math.round((Double)arguments.get(2));
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit((String)uri);
        try {
            IJavaElement element = JDTUtils.findElementAtSelection((ITypeRoot)unit, (int)line, (int)column, (PreferenceManager)JavaLanguageServerPlugin.getPreferencesManager(), (IProgressMonitor)monitor);
            if (element instanceof IMethod) {
                return new JavaElement(((IMethod)element).getDeclaringType().getFullyQualifiedName(), element.getJavaProject().getProject().getName(), ((IMethod)element).isMainMethod());
            }
            if (element instanceof IType) {
                return new JavaElement(((IType)element).getFullyQualifiedName(), element.getJavaProject().getProject().getName(), ResolveMainMethodHandler.getMainMethod((IType)element) != null);
            }
        }
        catch (JavaModelException e) {
            throw new DebugException("Failed to resolve the selected element information: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    static class JavaElement {
        private String declaringType;
        private String projectName;
        private boolean hasMainMethod;

        public JavaElement(String declaringType, String projectName, boolean hasMainMethod) {
            this.declaringType = declaringType;
            this.projectName = projectName;
            this.hasMainMethod = hasMainMethod;
        }
    }
}

