/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditUtil;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileVersionerCore;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.ClientPreferences;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class FormatterHandler {
    private static final char CLOSING_BRACE = '}';
    private static final char NEW_LINE = '\n';
    private static final char COMMA = ',';
    private static final String SPACE = " ";
    private static final String TAB = "\t";
    private PreferenceManager preferenceManager;

    public FormatterHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<? extends org.eclipse.lsp4j.TextEdit> formatting(DocumentFormattingParams params, IProgressMonitor monitor) {
        return this.format(params.getTextDocument().getUri(), params.getOptions(), null, monitor);
    }

    public List<? extends org.eclipse.lsp4j.TextEdit> rangeFormatting(DocumentRangeFormattingParams params, IProgressMonitor monitor) {
        return this.format(params.getTextDocument().getUri(), params.getOptions(), params.getRange(), monitor);
    }

    private List<org.eclipse.lsp4j.TextEdit> format(String uriString, FormattingOptions options, Range range, IProgressMonitor monitor) {
        if (!this.preferenceManager.getPreferences().isJavaFormatEnabled()) {
            return Collections.emptyList();
        }
        URI uri = JDTUtils.toURI(uriString);
        if (uri == null) {
            return Collections.emptyList();
        }
        ClientPreferences.NonStandardJavaFormatting nonStandardJavaFormatting = this.preferenceManager.getClientPreferences().getNonStandardJavaFormatting();
        if (nonStandardJavaFormatting != null && nonStandardJavaFormatting.isValid() && nonStandardJavaFormatting.getSchemes().contains(uri.getScheme())) {
            String text;
            Object[] params = new Object[]{uriString};
            Object o = JavaLanguageServerPlugin.getInstance().getClientConnection().executeClientCommand(nonStandardJavaFormatting.getGetContentCallback(), params);
            if (o instanceof String && !(text = (String)o).isBlank()) {
                return this.formatJavaCode(text, options, range, monitor);
            }
            return Collections.emptyList();
        }
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit(uri);
        if (cu == null) {
            return Collections.emptyList();
        }
        Region region = null;
        IDocument document = null;
        try {
            document = JsonRpcHelpers.toDocument(cu.getBuffer());
            if (document != null) {
                region = range == null ? new Region(0, document.getLength()) : this.getRegion(range, document);
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        if (region == null) {
            return Collections.emptyList();
        }
        return this.format(cu, document, (IRegion)region, options, this.preferenceManager.getPreferences().isJavaFormatComments(), monitor);
    }

    public List<org.eclipse.lsp4j.TextEdit> formatJavaCode(String text, FormattingOptions options, Range range, IProgressMonitor monitor) {
        Object formatted;
        String startText = "";
        String endText = "";
        String originalText = text;
        if (range != null) {
            Document document = new Document(text);
            IRegion region = this.getRegion(range, (IDocument)document);
            if (region == null) {
                return Collections.emptyList();
            }
            if (region.getOffset() > 0 || region.getLength() < document.getLength()) {
                if (region.getOffset() > 0) {
                    startText = text.substring(0, region.getOffset());
                }
                endText = text.substring(region.getOffset() + region.getLength() + 1, document.getLength());
                try {
                    text = document.get(region.getOffset(), region.getLength());
                }
                catch (BadLocationException e) {
                    return Collections.emptyList();
                }
            }
        }
        if ((formatted = this.formatString(text, options, monitor)) == null) {
            String remaining;
            Pattern importPattern = Pattern.compile("^(import\\s+.*?);", 8);
            Matcher importMatcher = importPattern.matcher(text);
            StringBuilder builder = new StringBuilder();
            int importEnd = 0;
            String lineDelimiter = TextUtilities.determineLineDelimiter((String)text, (String)"\n");
            while (importMatcher.find()) {
                builder.append(importMatcher.group()).append(lineDelimiter);
                importEnd = importMatcher.end();
            }
            String imports = builder.toString();
            builder = new StringBuilder();
            if (!imports.isBlank()) {
                String res = this.formatString(imports, options, monitor);
                if (res != null) {
                    builder.append(res);
                } else {
                    builder.append(imports);
                }
                builder.append(lineDelimiter);
            }
            if (!(remaining = text.substring(importEnd)).trim().isBlank()) {
                String res = this.formatString(remaining.trim(), options, monitor);
                if (res != null) {
                    builder.append(res);
                } else {
                    builder.append(remaining);
                }
            }
            formatted = builder.toString();
        }
        if (formatted != null) {
            text = originalText;
            formatted = startText + (String)formatted + endText;
            Document document = new Document(text);
            org.eclipse.lsp4j.TextEdit edit = new org.eclipse.lsp4j.TextEdit(new Range(FormatterHandler.createPosition((IDocument)document, 0), FormatterHandler.createPosition((IDocument)document, document.getLength())), (String)formatted);
            List<org.eclipse.lsp4j.TextEdit> list = Collections.singletonList(edit);
            return list;
        }
        return Collections.emptyList();
    }

    private String formatString(String text, FormattingOptions options, IProgressMonitor monitor) {
        String suffix;
        String prefix;
        String formatted = this.format(text, "", "", options, monitor);
        if (formatted == null && (formatted = this.format(text, prefix = "// PREFIX\npublic class Temporary { {\n", suffix = "// SUFFIX\n} }", options, monitor)) == null && (formatted = this.format(text, prefix = "// PREFIX\npublic class Temporary { public void run() {\n", suffix = "// SUFFIX\n} }", options, monitor)) == null) {
            prefix = "// PREFIX\npublic class Temporary {\n";
            suffix = "// SUFFIX\n}";
            formatted = this.format(text, prefix, suffix, options, monitor);
        }
        return formatted;
    }

    private String format(String text, String prefix, String suffix, FormattingOptions options, IProgressMonitor monitor) {
        TextEdit format;
        String content = prefix + text + suffix;
        Document document = new Document();
        document.set(content);
        CodeFormatter formatter = ToolFactory.createCodeFormatter((Map)options);
        int kind = 8;
        if (this.preferenceManager.getPreferences().isJavaFormatComments()) {
            kind |= 0x1000;
        }
        if ((format = formatter.format(kind, content, prefix.length(), text.length(), 0, TextUtilities.getDefaultLineDelimiter((IDocument)document))) == null || format.getChildren().length == 0 || monitor.isCanceled()) {
            return null;
        }
        try {
            format.apply((IDocument)document);
        }
        catch (BadLocationException | MalformedTreeException e) {
            JavaLanguageServerPlugin.logException(e);
            return null;
        }
        text = document.get();
        text = text.replace(suffix, "");
        text = text.replace(prefix, "");
        int indent = 0;
        while (indent < text.length() && (text.charAt(indent) == ' ' || text.charAt(indent) == '\t')) {
            ++indent;
        }
        String[] lines = text.split("\n");
        StringBuilder builder = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.length() > 0 && line.length() >= indent && (line.charAt(0) == ' ' || line.charAt(0) == '\t')) {
                builder.append(line.substring(indent)).append("\n");
            } else {
                builder.append(line).append("\n");
            }
            ++n2;
        }
        text = builder.toString();
        return text;
    }

    private List<org.eclipse.lsp4j.TextEdit> format(ICompilationUnit cu, IDocument document, IRegion region, FormattingOptions options, boolean includeComments, IProgressMonitor monitor) {
        if (cu == null || document == null || region == null || monitor.isCanceled()) {
            return Collections.emptyList();
        }
        CodeFormatter formatter = ToolFactory.createCodeFormatter(FormatterHandler.getOptions(options, cu));
        String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        String sourceToFormat = document.get();
        int kind = this.getFormattingKind(cu, includeComments);
        TextEdit format = formatter.format(kind, sourceToFormat, region.getOffset(), region.getLength(), 0, lineDelimiter);
        InsertEdit commaIndentationEdit = this.computeIndentationIfCommaPresent(cu, document, region, options);
        if (commaIndentationEdit != null) {
            format.addChild((TextEdit)commaIndentationEdit);
        }
        if (format == null || format.getChildren().length == 0 || monitor.isCanceled()) {
            return Collections.emptyList();
        }
        MultiTextEdit flatEdit = TextEditUtil.flatten((TextEdit)format);
        return FormatterHandler.convertEdits(flatEdit.getChildren(), document);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InsertEdit computeIndentationIfCommaPresent(ICompilationUnit cu, IDocument document, IRegion region, FormattingOptions options) {
        int length = region.getLength();
        try {
            char lastCharacter;
            if (document.getChar(region.getOffset() + length) != '\n') return null;
            int i = region.getOffset() + length - 1;
            while (true) {
                if (i < region.getOffset()) {
                    return null;
                }
                lastCharacter = document.getChar(i);
                if (!Character.isWhitespace(lastCharacter)) break;
                --i;
            }
            if (lastCharacter != ',') return null;
            String newText = "";
            int numTabs = Integer.valueOf(FormatterHandler.getOptions(options, cu).get("org.eclipse.jdt.core.formatter.continuation_indentation"));
            if (options.isInsertSpaces()) {
                newText = SPACE.repeat(options.getTabSize() * numTabs);
                return new InsertEdit(document.getLineOffset(document.getLineOfOffset(region.getOffset()) + 1), newText);
            }
            newText = TAB.repeat(numTabs);
            return new InsertEdit(document.getLineOffset(document.getLineOfOffset(region.getOffset()) + 1), newText);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private int getFormattingKind(ICompilationUnit cu, boolean includeComments) {
        int kind;
        int n = kind = includeComments ? 4096 : 0;
        kind = cu.getResource() != null && cu.getResource().getName().equals("module-info.java") ? (kind |= 0x80) : (kind |= 8);
        return kind;
    }

    private IRegion getRegion(Range range, IDocument document) {
        try {
            int offset = document.getLineOffset(range.getStart().getLine()) + range.getStart().getCharacter();
            int endOffset = document.getLineOffset(range.getEnd().getLine()) + range.getEnd().getCharacter();
            int length = endOffset - offset;
            return new Region(offset, length);
        }
        catch (BadLocationException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return null;
        }
    }

    public static Map<String, String> getOptions(FormattingOptions options, ICompilationUnit cu) {
        boolean insertSpaces;
        int tSize;
        Map eclipseOptions = cu.getOptions(true);
        Map<String, String> customOptions = options.entrySet().stream().filter(map -> FormatterHandler.chekIfValueIsNotNull((Either3<String, Number, Boolean>)((Either3)map.getValue()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> FormatterHandler.getOptionValue((Either3<String, Number, Boolean>)((Either3)e.getValue()))));
        eclipseOptions.putAll(customOptions);
        Integer tabSize = options.getTabSize();
        if (tabSize != null && (tSize = tabSize.intValue()) > 0) {
            eclipseOptions.put("org.eclipse.jdt.core.formatter.tabulation.size", Integer.toString(tSize));
        }
        eclipseOptions.put("org.eclipse.jdt.core.formatter.tabulation.char", (insertSpaces = options.isInsertSpaces()) ? "space" : "tab");
        return eclipseOptions;
    }

    private static boolean chekIfValueIsNotNull(Either3<String, Number, Boolean> value) {
        return value.getFirst() != null || value.getSecond() != null || value.getThird() != null;
    }

    private static String getOptionValue(Either3<String, Number, Boolean> option) {
        if (option.isFirst()) {
            return (String)option.getFirst();
        }
        if (option.isSecond()) {
            return ((Number)option.getSecond()).toString();
        }
        return ((Boolean)option.getThird()).toString();
    }

    private static List<org.eclipse.lsp4j.TextEdit> convertEdits(TextEdit[] edits, IDocument document) {
        return Arrays.stream(edits).map(t -> FormatterHandler.convertEdit(t, document)).collect(Collectors.toList());
    }

    private static org.eclipse.lsp4j.TextEdit convertEdit(TextEdit edit, IDocument document) {
        org.eclipse.lsp4j.TextEdit textEdit = new org.eclipse.lsp4j.TextEdit();
        if (edit instanceof ReplaceEdit) {
            ReplaceEdit replaceEdit = (ReplaceEdit)edit;
            textEdit.setNewText(replaceEdit.getText());
            int offset = edit.getOffset();
            textEdit.setRange(new Range(FormatterHandler.createPosition(document, offset), FormatterHandler.createPosition(document, offset + edit.getLength())));
        }
        if (edit instanceof InsertEdit) {
            InsertEdit insertEdit = (InsertEdit)edit;
            textEdit.setNewText(insertEdit.getText());
            int offset = edit.getOffset();
            textEdit.setRange(new Range(FormatterHandler.createPosition(document, offset), FormatterHandler.createPosition(document, offset)));
        }
        return textEdit;
    }

    private static Position createPosition(IDocument document, int offset) {
        Position start = new Position();
        try {
            int lineOfOffset = document.getLineOfOffset(offset);
            start.setLine(Integer.valueOf(lineOfOffset).intValue());
            start.setCharacter(Integer.valueOf(offset - document.getLineOffset(lineOfOffset)).intValue());
        }
        catch (BadLocationException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        return start;
    }

    public List<? extends org.eclipse.lsp4j.TextEdit> onTypeFormatting(DocumentOnTypeFormattingParams params, IProgressMonitor monitor) {
        return this.format(params.getTextDocument().getUri(), params.getOptions(), params.getPosition(), params.getCh(), monitor);
    }

    private List<? extends org.eclipse.lsp4j.TextEdit> format(String uri, FormattingOptions options, Position position, String triggerChar, IProgressMonitor monitor) {
        if (!this.preferenceManager.getPreferences().isJavaFormatOnTypeEnabled()) {
            return Collections.emptyList();
        }
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit(uri);
        if (cu == null) {
            return Collections.emptyList();
        }
        IRegion region = null;
        IDocument document = null;
        try {
            document = JsonRpcHelpers.toDocument(cu.getBuffer());
            if (document != null && position != null) {
                region = this.getRegion(cu, document, position, triggerChar);
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        if (region == null) {
            return Collections.emptyList();
        }
        return this.format(cu, document, region, options, false, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRegion getRegion(ICompilationUnit cu, IDocument document, Position position, String trigger) {
        try {
            int endLineLength;
            int lineOffset;
            int line = position.getLine();
            int offset = document.getLineOffset(line);
            int length = position.getCharacter();
            char triggerChar = '\u0000';
            if (trigger != null && !trigger.isEmpty()) {
                triggerChar = trigger.charAt(0);
                if ('\n' == triggerChar && (document.getChar(offset + length) != triggerChar || length == 0) && line > 0) {
                    int prevLine = line - 1;
                    offset = document.getLineOffset(prevLine);
                    length = document.getLineLength(prevLine);
                    line = prevLine;
                }
            } else {
                triggerChar = document.getChar(offset + length);
            }
            boolean emptyLine = false;
            if ('\n' == triggerChar) {
                int[] lines;
                int[] nArray;
                if (line > 0) {
                    int[] nArray2 = new int[2];
                    nArray2[0] = line;
                    nArray = nArray2;
                    nArray2[1] = line - 1;
                } else {
                    int[] nArray3 = new int[1];
                    nArray = nArray3;
                    nArray3[0] = line;
                }
                int[] nArray4 = lines = nArray;
                int n = lines.length;
                int n2 = 0;
                block2: while (n2 < n) {
                    char ch;
                    int l = nArray4[n2];
                    lineOffset = document.getLineOffset(l);
                    int maxPosition = document.getLineLength(l) - 1;
                    emptyLine = false;
                    int pos = maxPosition;
                    while (true) {
                        if (pos < 0) {
                            emptyLine = true;
                            ++n2;
                            continue block2;
                        }
                        ch = document.getChar(lineOffset + pos);
                        if (!Character.isWhitespace(ch)) break;
                        --pos;
                    }
                    length = ch == '}' ? pos + 1 : maxPosition;
                    offset = lineOffset;
                    triggerChar = ch;
                    break;
                }
            }
            if (triggerChar != '}') {
                if (emptyLine) return null;
                return new Region(offset, length);
            }
            CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)cu, CoreASTProvider.WAIT_YES, null);
            if (astRoot == null) {
                return null;
            }
            NodeFinder finder = new NodeFinder((ASTNode)astRoot, offset, length);
            ASTNode block = finder.getCoveredNode();
            if (block == null) {
                block = finder.getCoveringNode();
            }
            if (block == null) return null;
            int blockStartPosition = block.getStartPosition();
            int lineOfBlock = document.getLineOfOffset(blockStartPosition);
            lineOffset = document.getLineOffset(lineOfBlock);
            int blockLength = block.getLength();
            int endLine = document.getLineOfOffset(blockStartPosition + blockLength);
            int endLineOffset = document.getLineOffset(endLine);
            if (document.getChar(endLineOffset + (endLineLength = document.getLineLength(endLine)) - 1) == '\n') {
                --endLineLength;
            }
            int lastPosition = document.getLineOffset(endLine) + endLineLength;
            int totalLength = lastPosition - lineOffset;
            return new Region(lineOffset, totalLength);
        }
        catch (BadLocationException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        return null;
    }

    public String stringFormatting(String content, Map<String, String> options, int version, IProgressMonitor monitor) {
        TextEdit edit;
        Document document = new Document();
        document.set(content);
        Map formatOptions = options == null ? FormatterHandler.getCombinedDefaultFormatterSettings() : ProfileVersionerCore.updateAndComplete(options, (int)version);
        CodeFormatter formatter = ToolFactory.createCodeFormatter((Map)formatOptions);
        Region region = new Region(0, document.getLength());
        int kind = 8;
        if (this.preferenceManager.getPreferences().isJavaFormatComments()) {
            kind |= 0x1000;
        }
        if ((edit = formatter.format(kind, content, region.getOffset(), region.getLength(), 0, TextUtilities.getDefaultLineDelimiter((IDocument)document))) != null) {
            try {
                edit.apply((IDocument)document);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return document.get();
    }

    public static Map<String, String> getCombinedDefaultFormatterSettings() {
        Map options = DefaultCodeFormatterOptions.getEclipseDefaultSettings().getMap();
        options.putAll(FormatterHandler.getJavaLSDefaultFormatterSettings());
        return options;
    }

    public static Map<String, String> getJavaLSDefaultFormatterSettings() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.jdt.core.formatter.join_wrapped_lines", "false");
        options.put("org.eclipse.jdt.core.formatter.join_lines_in_comments", "false");
        options.put("org.eclipse.jdt.core.formatter.indent_switchstatements_compare_to_switch", "true");
        options.put("org.eclipse.jdt.core.formatter.use_on_off_tags", "true");
        return options;
    }
}

