/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.tools.javac.file.CacheFSInfo;
import java.io.IOException;
import java.lang.ref.Cleaner;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.internal.javac.CachingJarsJavaFileManager;

public class ZipFileSystemProviderWithCache
extends FileSystemProvider {
    private final Cleaner cleaner = Cleaner.create();
    private final Map<Path, FileSystem> cachedFilesystems = new HashMap<Path, FileSystem>();
    private final Map<FileSystem, FileTime> lastModificationOfCache = new HashMap<FileSystem, FileTime>();
    private final FileSystemProvider delegate = new CacheFSInfo().getJarFSProvider();
    private final Set<Integer> fileManagersIdentitieis = new HashSet<Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFileManager(int cachingJarsJavaFileManagerIdentityHashCode) {
        HashSet<FileSystem> toClear = new HashSet<FileSystem>();
        ZipFileSystemProviderWithCache zipFileSystemProviderWithCache = this;
        synchronized (zipFileSystemProviderWithCache) {
            this.fileManagersIdentitieis.remove(cachingJarsJavaFileManagerIdentityHashCode);
            if (this.fileManagersIdentitieis.isEmpty()) {
                toClear.addAll(this.lastModificationOfCache.keySet());
                toClear.addAll(this.cachedFilesystems.values());
                this.lastModificationOfCache.clear();
                this.cachedFilesystems.clear();
            }
        }
        CompletableFuture.runAsync(() -> toClear.forEach(fs -> {
            try {
                fs.close();
            }
            catch (IOException ex) {
                ILog.get().error(ex.getMessage(), (Throwable)ex);
            }
        }));
    }

    @Override
    public String getScheme() {
        return this.delegate.getScheme();
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        return this.newFileSystem(this.getPath(uri), env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IOException {
        ZipFileSystemProviderWithCache zipFileSystemProviderWithCache = this;
        synchronized (zipFileSystemProviderWithCache) {
            FileSystem cached = this.getCachedFileSystem(path);
            if (cached != null) {
                return cached;
            }
            FileTime lastMod = Files.getLastModifiedTime(path, new LinkOption[0]);
            FileSystem res = this.delegate.newFileSystem(path, env);
            this.cachedFilesystems.put(path, res);
            this.lastModificationOfCache.put(res, lastMod);
            return res;
        }
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        FileSystem res = this.getCachedFileSystem(this.getPath(uri));
        if (res == null) {
            res = this.delegate.getFileSystem(uri);
        }
        return res;
    }

    private FileSystem getCachedFileSystem(Path file) {
        FileTime lastMod;
        FileSystem cached = this.cachedFilesystems.get(file);
        if (cached == null) {
            return null;
        }
        FileTime cacheLastMod = this.lastModificationOfCache.get(cached);
        try {
            lastMod = Files.getLastModifiedTime(file, new LinkOption[0]);
        }
        catch (IOException e) {
            return null;
        }
        if (lastMod.compareTo(cacheLastMod) > 0) {
            return null;
        }
        return cached;
    }

    @Override
    public Path getPath(URI uri) {
        return this.delegate.getPath(uri);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.delegate.newByteChannel(path, options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.delegate.newDirectoryStream(dir, filter);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        this.delegate.createDirectory(dir, attrs);
    }

    @Override
    public void delete(Path path) throws IOException {
        this.delegate.delete(path);
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        this.delegate.copy(source, target, options);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        this.delegate.move(source, target, options);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return this.delegate.isSameFile(path, path2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return this.delegate.isHidden(path);
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return this.delegate.getFileStore(path);
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        this.delegate.checkAccess(path, modes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return this.delegate.getFileAttributeView(path, type, options);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        return this.delegate.readAttributes(path, type, options);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return this.delegate.readAttributes(path, attributes, options);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        this.delegate.setAttribute(path, attribute, value, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(CachingJarsJavaFileManager cachingJarsJavaFileManager) {
        int id = System.identityHashCode(cachingJarsJavaFileManager);
        this.cleaner.register(cachingJarsJavaFileManager, () -> this.closeFileManager(id));
        ZipFileSystemProviderWithCache zipFileSystemProviderWithCache = this;
        synchronized (zipFileSystemProviderWithCache) {
            this.fileManagersIdentitieis.add(id);
        }
    }
}

