/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ([
/* 0 */
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.activate = activate;
const extension_telemetry_1 = __importDefault(__webpack_require__(1));
const vscode = __importStar(__webpack_require__(2));
const api_1 = __webpack_require__(169);
const commandManager_1 = __webpack_require__(170);
const index_1 = __webpack_require__(171);
const configuration_browser_1 = __webpack_require__(232);
const experimentTelemetryReporter_1 = __webpack_require__(236);
const autoInstallerFs_1 = __webpack_require__(237);
const memFs_1 = __webpack_require__(238);
const lazyClientHost_1 = __webpack_require__(245);
const logger_1 = __webpack_require__(326);
const remoteRepositories_browser_1 = __importDefault(__webpack_require__(327));
const api_2 = __webpack_require__(175);
const cancellation_1 = __webpack_require__(328);
const logDirectoryProvider_1 = __webpack_require__(329);
const plugins_1 = __webpack_require__(330);
const serverProcess_browser_1 = __webpack_require__(331);
const versionProvider_1 = __webpack_require__(345);
const activeJsTsEditorTracker_1 = __webpack_require__(346);
const dispose_1 = __webpack_require__(248);
const packageInfo_1 = __webpack_require__(347);
const platform_1 = __webpack_require__(250);
class StaticVersionProvider {
    constructor(_version) {
        this._version = _version;
        this.globalVersion = undefined;
        this.localVersion = undefined;
        this.localVersions = [];
    }
    updateConfiguration(_configuration) {
        // noop
    }
    get defaultVersion() { return this._version; }
    get bundledVersion() { return this._version; }
}
async function activate(context) {
    const pluginManager = new plugins_1.PluginManager();
    context.subscriptions.push(pluginManager);
    const commandManager = new commandManager_1.CommandManager();
    context.subscriptions.push(commandManager);
    const onCompletionAccepted = new vscode.EventEmitter();
    context.subscriptions.push(onCompletionAccepted);
    const activeJsTsEditorTracker = new activeJsTsEditorTracker_1.ActiveJsTsEditorTracker();
    context.subscriptions.push(activeJsTsEditorTracker);
    const versionProvider = new StaticVersionProvider(new versionProvider_1.TypeScriptVersion("bundled" /* TypeScriptVersionSource.Bundled */, vscode.Uri.joinPath(context.extensionUri, 'dist/browser/typescript/tsserver.web.js').toString(), api_2.API.fromSimpleString('5.3.2')));
    let experimentTelemetryReporter;
    const packageInfo = (0, packageInfo_1.getPackageInfo)(context);
    if (packageInfo) {
        const { aiKey } = packageInfo;
        const vscTelemetryReporter = new extension_telemetry_1.default(aiKey);
        experimentTelemetryReporter = new experimentTelemetryReporter_1.ExperimentationTelemetryReporter(vscTelemetryReporter);
        context.subscriptions.push(experimentTelemetryReporter);
    }
    const logger = new logger_1.Logger();
    const lazyClientHost = (0, lazyClientHost_1.createLazyClientHost)(context, false, {
        pluginManager,
        commandManager,
        logDirectoryProvider: logDirectoryProvider_1.noopLogDirectoryProvider,
        cancellerFactory: cancellation_1.noopRequestCancellerFactory,
        versionProvider,
        processFactory: new serverProcess_browser_1.WorkerServerProcessFactory(context.extensionUri, logger),
        activeJsTsEditorTracker,
        serviceConfigurationProvider: new configuration_browser_1.BrowserServiceConfigurationProvider(),
        experimentTelemetryReporter,
        logger,
    }, item => {
        onCompletionAccepted.fire(item);
    });
    (0, index_1.registerBaseCommands)(commandManager, lazyClientHost, pluginManager, activeJsTsEditorTracker);
    // context.subscriptions.push(task.register(lazyClientHost.map(x => x.serviceClient)));
    Promise.resolve().then(() => __importStar(__webpack_require__(348))).then(module => {
        context.subscriptions.push(module.register());
    });
    context.subscriptions.push((0, lazyClientHost_1.lazilyActivateClient)(lazyClientHost, pluginManager, activeJsTsEditorTracker, async () => {
        await startPreloadWorkspaceContentsIfNeeded(context, logger);
    }));
    context.subscriptions.push(vscode.workspace.registerFileSystemProvider('vscode-global-typings', new memFs_1.MemFs(), {
        isCaseSensitive: true,
        isReadonly: false
    }));
    context.subscriptions.push(vscode.workspace.registerFileSystemProvider('vscode-node-modules', new autoInstallerFs_1.AutoInstallerFs(), {
        isCaseSensitive: true,
        isReadonly: false
    }));
    return (0, api_1.getExtensionApi)(onCompletionAccepted.event, pluginManager);
}
async function startPreloadWorkspaceContentsIfNeeded(context, logger) {
    if (!(0, platform_1.isWebAndHasSharedArrayBuffers)()) {
        return;
    }
    const workspaceUri = vscode.workspace.workspaceFolders?.[0].uri;
    if (!workspaceUri || workspaceUri.scheme !== 'vscode-vfs' || !workspaceUri.authority.startsWith('github')) {
        logger.info(`Skipped loading workspace contents for repository ${workspaceUri?.toString()}`);
        return;
    }
    const loader = new RemoteWorkspaceContentsPreloader(workspaceUri, logger);
    context.subscriptions.push(loader);
    return loader.triggerPreload();
}
class RemoteWorkspaceContentsPreloader extends dispose_1.Disposable {
    constructor(workspaceUri, logger) {
        super();
        this.workspaceUri = workspaceUri;
        this.logger = logger;
        const fsWatcher = this._register(vscode.workspace.createFileSystemWatcher(new vscode.RelativePattern(workspaceUri, '*')));
        this._register(fsWatcher.onDidChange(uri => {
            if (uri.toString() === workspaceUri.toString()) {
                this._preload = undefined;
                this.triggerPreload();
            }
        }));
    }
    async triggerPreload() {
        this._preload ?? (this._preload = this.doPreload());
        return this._preload;
    }
    async doPreload() {
        try {
            const remoteHubApi = await remoteRepositories_browser_1.default.getApi();
            if (await remoteHubApi.loadWorkspaceContents?.(this.workspaceUri)) {
                this.logger.info(`Successfully loaded workspace content for repository ${this.workspaceUri.toString()}`);
            }
            else {
                this.logger.info(`Failed to load workspace content for repository ${this.workspaceUri.toString()}`);
            }
        }
        catch (error) {
            this.logger.info(`Loading workspace content for repository ${this.workspaceUri.toString()} failed: ${error instanceof Error ? error.toString() : 'Unknown reason'}`);
            console.error(error);
        }
    }
}


/***/ }),
/* 1 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TelemetryReporter)
/* harmony export */ });
/* harmony import */ var vscode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* harmony import */ var vscode__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(vscode__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _common_1dsClientFactory__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(143);
/* harmony import */ var _common_baseTelemetrySender__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(168);
/* harmony import */ var _common_baseTelemetryReporter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3);
/* harmony import */ var _common_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(99);
/* harmony import */ var _common_appInsightsClientFactory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4);
/*---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/






function getBrowserRelease(navigator) {
    if (navigator.userAgentData) {
        const browser = navigator.userAgentData.brands[navigator.userAgentData.brands.length - 1];
        return `${navigator.userAgentData.platform} - ${browser?.brand} v${browser?.version}}`;
    }
    else {
        return navigator.appVersion;
    }
}
class TelemetryReporter extends _common_baseTelemetryReporter__WEBPACK_IMPORTED_MODULE_1__.BaseTelemetryReporter {
    constructor(key, replacementOptions) {
        let clientFactory = (key) => (0,_common_appInsightsClientFactory__WEBPACK_IMPORTED_MODULE_2__.appInsightsClientFactory)(key, undefined, replacementOptions);
        // If key is usable by 1DS use the 1DS SDk
        if (_common_util__WEBPACK_IMPORTED_MODULE_3__.TelemetryUtil.shouldUseOneDataSystemSDK(key)) {
            clientFactory = (key) => (0,_common_1dsClientFactory__WEBPACK_IMPORTED_MODULE_4__.oneDataSystemClientFactory)(key, vscode__WEBPACK_IMPORTED_MODULE_0__);
        }
        const osShim = {
            release: getBrowserRelease(navigator),
            platform: "web",
            architecture: "web",
        };
        const sender = new _common_baseTelemetrySender__WEBPACK_IMPORTED_MODULE_5__.BaseTelemetrySender(key, clientFactory);
        // AIF is no longer supported
        if (key && (key.indexOf("AIF") === 0)) {
            throw new Error("AIF keys are no longer supported. Please switch to 1DS keys for 1st party extensions");
        }
        super(sender, vscode__WEBPACK_IMPORTED_MODULE_0__, { additionalCommonProperties: _common_util__WEBPACK_IMPORTED_MODULE_3__.TelemetryUtil.getAdditionalCommonProperties(osShim) });
    }
}
//# sourceMappingURL=telemetryReporter.js.map

/***/ }),
/* 2 */
/***/ ((module) => {

"use strict";
module.exports = require("vscode");

/***/ }),
/* 3 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BaseTelemetryReporter": () => (/* binding */ BaseTelemetryReporter)
/* harmony export */ });
/*---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
class BaseTelemetryReporter {
    constructor(telemetrySender, vscodeAPI, initializationOptions) {
        this.telemetrySender = telemetrySender;
        this.vscodeAPI = vscodeAPI;
        this.userOptIn = false;
        this.errorOptIn = false;
        this.disposables = [];
        this._onDidChangeTelemetryLevel = new this.vscodeAPI.EventEmitter();
        this.onDidChangeTelemetryLevel = this._onDidChangeTelemetryLevel.event;
        this.telemetryLogger = this.vscodeAPI.env.createTelemetryLogger(this.telemetrySender, initializationOptions);
        // Keep track of the user's opt-in status
        this.updateUserOptIn();
        this.telemetryLogger.onDidChangeEnableStates(() => {
            this.updateUserOptIn();
        });
    }
    /**
     * Updates the user's telemetry opt-in status
     */
    updateUserOptIn() {
        this.errorOptIn = this.telemetryLogger.isErrorsEnabled;
        this.userOptIn = this.telemetryLogger.isUsageEnabled;
        // The sender is lazy loaded so if telemetry is off it's not loaded in
        if (this.telemetryLogger.isErrorsEnabled || this.telemetryLogger.isUsageEnabled) {
            this.telemetrySender.instantiateSender();
        }
        this._onDidChangeTelemetryLevel.fire(this.telemetryLevel);
    }
    get telemetryLevel() {
        if (this.errorOptIn && this.userOptIn) {
            return "all";
        }
        else if (this.errorOptIn) {
            return "error";
        }
        else {
            return "off";
        }
    }
    /**
     * Internal function which logs telemetry events and takes extra options.
     * @param eventName The name of the event
     * @param properties The properties of the event
     * @param measurements The measurements (numeric values) to send with the event
     * @param sanitize Whether or not to sanitize to the properties and measures
     * @param dangerous Whether or not to ignore telemetry level
     */
    internalSendTelemetryEvent(eventName, properties, measurements, dangerous) {
        // If it's dangerous we skip going through the logger as the logger checks opt-in status, etc.
        if (dangerous) {
            this.telemetrySender.sendEventData(eventName, { properties, measurements });
        }
        else {
            this.telemetryLogger.logUsage(eventName, { properties, measurements });
        }
    }
    /**
     * Given an event name, some properties, and measurements sends a telemetry event.
     * Properties are sanitized on best-effort basis to remove sensitive data prior to sending.
     * @param eventName The name of the event
     * @param properties The properties to send with the event
     * @param measurements The measurements (numeric values) to send with the event
     */
    sendTelemetryEvent(eventName, properties, measurements) {
        this.internalSendTelemetryEvent(eventName, properties, measurements, false);
    }
    /**
     * Sends a raw (unsanitized) telemetry event with the given properties and measurements.
     * NOTE: This will not be logged to the output channel due to API limitations.
     * @param eventName The name of the event
     * @param properties The set of properties to add to the event in the form of a string key value pair
     * @param measurements The set of measurements to add to the event in the form of a string key  number value pair
     */
    sendRawTelemetryEvent(eventName, properties, measurements) {
        const modifiedProperties = { ...properties };
        for (const propertyKey of Object.keys(modifiedProperties ?? {})) {
            const propertyValue = modifiedProperties[propertyKey];
            if (typeof propertyKey === "string" && propertyValue !== undefined) {
                // Trusted values are not sanitized, which is what we want for raw telemetry
                modifiedProperties[propertyKey] = new this.vscodeAPI.TelemetryTrustedValue(typeof propertyValue === "string" ? propertyValue : propertyValue.value);
            }
        }
        this.sendTelemetryEvent(eventName, modifiedProperties, measurements);
    }
    /**
     * **DANGEROUS** Given an event name, some properties, and measurements sends a telemetry event without checking telemetry setting
     * Do not use unless in a controlled environment i.e. sending telmetry from a CI pipeline or testing during development
     * @param eventName The name of the event
     * @param properties The properties to send with the event
     * @param measurements The measurements (numeric values) to send with the event
     * @param sanitize Whether or not to sanitize to the properties and measures, defaults to true
     */
    sendDangerousTelemetryEvent(eventName, properties, measurements) {
        // Since telemetry is probably off when sending dangerously, we must start the sender
        this.telemetrySender.instantiateSender();
        this.internalSendTelemetryEvent(eventName, properties, measurements, true);
    }
    /**
     * Internal function which logs telemetry error events and takes extra options.
     * @param eventName The name of the event
     * @param properties The properties of the event
     * @param measurements The measurements (numeric values) to send with the event
     * @param sanitize Whether or not to sanitize to the properties and measures
     * @param dangerous Whether or not to ignore telemetry level
     */
    internalSendTelemetryErrorEvent(eventName, properties, measurements, dangerous) {
        if (dangerous) {
            this.telemetrySender.sendEventData(eventName, { properties, measurements });
        }
        else {
            this.telemetryLogger.logError(eventName, { properties, measurements });
        }
    }
    /**
     * Given an event name, some properties, and measurements sends an error event
     * @param eventName The name of the event
     * @param properties The properties to send with the event
     * @param measurements The measurements (numeric values) to send with the event
     */
    sendTelemetryErrorEvent(eventName, properties, measurements) {
        this.internalSendTelemetryErrorEvent(eventName, properties, measurements, false);
    }
    /**
     * **DANGEROUS** Given an event name, some properties, and measurements sends a telemetry error event without checking telemetry setting
     * Do not use unless in a controlled environment i.e. sending telmetry from a CI pipeline or testing during development
     * @param eventName The name of the event
     * @param properties The properties to send with the event
     * @param measurements The measurements (numeric values) to send with the event
     * @param sanitize Whether or not to run the properties and measures through sanitiziation, defaults to true
     */
    sendDangerousTelemetryErrorEvent(eventName, properties, measurements) {
        // Since telemetry is probably off when sending dangerously, we must start the sender
        this.telemetrySender.instantiateSender();
        this.internalSendTelemetryErrorEvent(eventName, properties, measurements, true);
    }
    /**
     * Disposes of the telemetry reporter
     */
    async dispose() {
        await this.telemetrySender.dispose();
        this.telemetryLogger.dispose();
        return Promise.all(this.disposables.map(d => d.dispose()));
    }
}
//# sourceMappingURL=baseTelemetryReporter.js.map

/***/ }),
/* 4 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "appInsightsClientFactory": () => (/* binding */ appInsightsClientFactory)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(99);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/


const appInsightsClientFactory = async (key, xhrOverride, replacementOptions) => {
    let appInsightsClient;
    try {
        const basicAISDK = await Promise.resolve(/* import() eager */).then(__webpack_require__.bind(__webpack_require__, 100));
        appInsightsClient = new basicAISDK.ApplicationInsights({
            instrumentationKey: key,
            disableAjaxTracking: true,
            disableExceptionTracking: true,
            disableFetchTracking: true,
            disableCorrelationHeaders: true,
            disableCookiesUsage: true,
            autoTrackPageVisitTime: false,
            emitLineDelimitedJson: false,
            disableInstrumentationKeyValidation: true
        });
        if (xhrOverride) {
            appInsightsClient.config.extensionConfig = {};
            // Configure the channel to use a XHR Request override since it's not available in node
            const channelConfig = {
                alwaysUseXhrOverride: true,
                httpXHROverride: xhrOverride
            };
            appInsightsClient.config.extensionConfig[_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_0__.BreezeChannelIdentifier] = channelConfig;
        }
    }
    catch (e) {
        return Promise.reject(e);
    }
    // Sets the appinsights client into a standardized form
    const telemetryClient = {
        logEvent: (eventName, data) => {
            const properties = { ...data?.properties, ...data?.measurements };
            if (replacementOptions?.length) {
                _util__WEBPACK_IMPORTED_MODULE_1__.TelemetryUtil.applyReplacements(properties, replacementOptions);
            }
            appInsightsClient?.track({
                name: eventName,
                data: properties,
                baseType: "EventData",
                baseData: { name: eventName, properties: data?.properties, measurements: data?.measurements }
            });
        },
        flush: async () => {
            appInsightsClient?.flush(false);
        },
        dispose: async () => {
            const unloadPromise = new Promise((resolve) => {
                appInsightsClient?.unload(true, () => {
                    resolve();
                    appInsightsClient = undefined;
                }, 1000);
            });
            return unloadPromise;
        }
    };
    return telemetryClient;
};
//# sourceMappingURL=appInsightsClientFactory.js.map

/***/ }),
/* 5 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnalyticsPluginIdentifier": () => (/* binding */ AnalyticsPluginIdentifier),
/* harmony export */   "BreezeChannelIdentifier": () => (/* binding */ BreezeChannelIdentifier),
/* harmony export */   "ConfigurationManager": () => (/* reexport safe */ _Interfaces_IConfig__WEBPACK_IMPORTED_MODULE_15__.ConfigurationManager),
/* harmony export */   "ConnectionStringParser": () => (/* reexport safe */ _ConnectionStringParser__WEBPACK_IMPORTED_MODULE_2__.ConnectionStringParser),
/* harmony export */   "ContextTagKeys": () => (/* reexport safe */ _Interfaces_Contracts_ContextTagKeys__WEBPACK_IMPORTED_MODULE_16__.ContextTagKeys),
/* harmony export */   "CtxTagKeys": () => (/* reexport safe */ _Interfaces_PartAExtensions__WEBPACK_IMPORTED_MODULE_19__.CtxTagKeys),
/* harmony export */   "DEFAULT_BREEZE_ENDPOINT": () => (/* reexport safe */ _Constants__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_BREEZE_ENDPOINT),
/* harmony export */   "DEFAULT_BREEZE_PATH": () => (/* reexport safe */ _Constants__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_BREEZE_PATH),
/* harmony export */   "Data": () => (/* reexport safe */ _Telemetry_Common_Data__WEBPACK_IMPORTED_MODULE_13__.Data),
/* harmony export */   "DisabledPropertyName": () => (/* reexport safe */ _Constants__WEBPACK_IMPORTED_MODULE_4__.DisabledPropertyName),
/* harmony export */   "DistributedTracingModes": () => (/* reexport safe */ _Enums__WEBPACK_IMPORTED_MODULE_20__.DistributedTracingModes),
/* harmony export */   "Envelope": () => (/* reexport safe */ _Telemetry_Common_Envelope__WEBPACK_IMPORTED_MODULE_5__.Envelope),
/* harmony export */   "Event": () => (/* reexport safe */ _Telemetry_Event__WEBPACK_IMPORTED_MODULE_6__.Event),
/* harmony export */   "Exception": () => (/* reexport safe */ _Telemetry_Exception__WEBPACK_IMPORTED_MODULE_7__.Exception),
/* harmony export */   "Extensions": () => (/* reexport safe */ _Interfaces_PartAExtensions__WEBPACK_IMPORTED_MODULE_19__.Extensions),
/* harmony export */   "HttpMethod": () => (/* reexport safe */ _Constants__WEBPACK_IMPORTED_MODULE_4__.HttpMethod),
/* harmony export */   "Metric": () => (/* reexport safe */ _Telemetry_Metric__WEBPACK_IMPORTED_MODULE_8__.Metric),
/* harmony export */   "PageView": () => (/* reexport safe */ _Telemetry_PageView__WEBPACK_IMPORTED_MODULE_9__.PageView),
/* harmony export */   "PageViewPerformance": () => (/* reexport safe */ _Telemetry_PageViewPerformance__WEBPACK_IMPORTED_MODULE_12__.PageViewPerformance),
/* harmony export */   "ProcessLegacy": () => (/* reexport safe */ _Constants__WEBPACK_IMPORTED_MODULE_4__.ProcessLegacy),
/* harmony export */   "PropertiesPluginIdentifier": () => (/* binding */ PropertiesPluginIdentifier),
/* harmony export */   "RemoteDependencyData": () => (/* reexport safe */ _Telemetry_RemoteDependencyData__WEBPACK_IMPORTED_MODULE_10__.RemoteDependencyData),
/* harmony export */   "RequestHeaders": () => (/* reexport safe */ _RequestResponseHeaders__WEBPACK_IMPORTED_MODULE_3__.RequestHeaders),
/* harmony export */   "SampleRate": () => (/* reexport safe */ _Constants__WEBPACK_IMPORTED_MODULE_4__.SampleRate),
/* harmony export */   "SeverityLevel": () => (/* reexport safe */ _Interfaces_Contracts_SeverityLevel__WEBPACK_IMPORTED_MODULE_14__.SeverityLevel),
/* harmony export */   "TelemetryItemCreator": () => (/* reexport safe */ _TelemetryItemCreator__WEBPACK_IMPORTED_MODULE_18__.TelemetryItemCreator),
/* harmony export */   "ThrottleMgr": () => (/* reexport safe */ _ThrottleMgr__WEBPACK_IMPORTED_MODULE_1__.ThrottleMgr),
/* harmony export */   "Trace": () => (/* reexport safe */ _Telemetry_Trace__WEBPACK_IMPORTED_MODULE_11__.Trace),
/* harmony export */   "correlationIdCanIncludeCorrelationHeader": () => (/* reexport safe */ _Util__WEBPACK_IMPORTED_MODULE_0__.correlationIdCanIncludeCorrelationHeader),
/* harmony export */   "correlationIdGetCorrelationContext": () => (/* reexport safe */ _Util__WEBPACK_IMPORTED_MODULE_0__.correlationIdGetCorrelationContext),
/* harmony export */   "correlationIdGetCorrelationContextValue": () => (/* reexport safe */ _Util__WEBPACK_IMPORTED_MODULE_0__.correlationIdGetCorrelationContextValue),
/* harmony export */   "correlationIdGetPrefix": () => (/* reexport safe */ _Util__WEBPACK_IMPORTED_MODULE_0__.correlationIdGetPrefix),
/* harmony export */   "correlationIdSetPrefix": () => (/* reexport safe */ _Util__WEBPACK_IMPORTED_MODULE_0__.correlationIdSetPrefix),
/* harmony export */   "createDistributedTraceContextFromTrace": () => (/* reexport safe */ _Util__WEBPACK_IMPORTED_MODULE_0__.createDistributedTraceContextFromTrace),
/* harmony export */   "createDomEvent": () => (/* reexport safe */ _DomHelperFuncs__WEBPACK_IMPORTED_MODULE_24__.createDomEvent),
/* harmony export */   "createTelemetryItem": () => (/* reexport safe */ _TelemetryItemCreator__WEBPACK_IMPORTED_MODULE_18__.createTelemetryItem),
/* harmony export */   "createTraceParent": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__.createTraceParent),
/* harmony export */   "dataSanitizeException": () => (/* reexport safe */ _Telemetry_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_17__.dataSanitizeException),
/* harmony export */   "dataSanitizeId": () => (/* reexport safe */ _Telemetry_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_17__.dataSanitizeId),
/* harmony export */   "dataSanitizeInput": () => (/* reexport safe */ _Telemetry_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_17__.dataSanitizeInput),
/* harmony export */   "dataSanitizeKey": () => (/* reexport safe */ _Telemetry_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_17__.dataSanitizeKey),
/* harmony export */   "dataSanitizeKeyAndAddUniqueness": () => (/* reexport safe */ _Telemetry_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_17__.dataSanitizeKeyAndAddUniqueness),
/* harmony export */   "dataSanitizeMeasurements": () => (/* reexport safe */ _Telemetry_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_17__.dataSanitizeMeasurements),
/* harmony export */   "dataSanitizeMessage": () => (/* reexport safe */ _Telemetry_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_17__.dataSanitizeMessage),
/* harmony export */   "dataSanitizeProperties": () => (/* reexport safe */ _Telemetry_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_17__.dataSanitizeProperties),
/* harmony export */   "dataSanitizeString": () => (/* reexport safe */ _Telemetry_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_17__.dataSanitizeString),
/* harmony export */   "dataSanitizeUrl": () => (/* reexport safe */ _Telemetry_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_17__.dataSanitizeUrl),
/* harmony export */   "dateTimeUtilsDuration": () => (/* reexport safe */ _Util__WEBPACK_IMPORTED_MODULE_0__.dateTimeUtilsDuration),
/* harmony export */   "dateTimeUtilsNow": () => (/* reexport safe */ _Util__WEBPACK_IMPORTED_MODULE_0__.dateTimeUtilsNow),
/* harmony export */   "dsPadNumber": () => (/* reexport safe */ _Telemetry_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_17__.dsPadNumber),
/* harmony export */   "findW3cTraceParent": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__.findW3cTraceParent),
/* harmony export */   "formatTraceParent": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__.formatTraceParent),
/* harmony export */   "getExtensionByName": () => (/* reexport safe */ _HelperFuncs__WEBPACK_IMPORTED_MODULE_21__.getExtensionByName),
/* harmony export */   "isBeaconApiSupported": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.isBeaconsSupported),
/* harmony export */   "isCrossOriginError": () => (/* reexport safe */ _HelperFuncs__WEBPACK_IMPORTED_MODULE_21__.isCrossOriginError),
/* harmony export */   "isInternalApplicationInsightsEndpoint": () => (/* reexport safe */ _Util__WEBPACK_IMPORTED_MODULE_0__.isInternalApplicationInsightsEndpoint),
/* harmony export */   "isSampledFlag": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__.isSampledFlag),
/* harmony export */   "isValidSpanId": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__.isValidSpanId),
/* harmony export */   "isValidTraceId": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__.isValidTraceId),
/* harmony export */   "isValidTraceParent": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__.isValidTraceParent),
/* harmony export */   "msToTimeSpan": () => (/* reexport safe */ _HelperFuncs__WEBPACK_IMPORTED_MODULE_21__.msToTimeSpan),
/* harmony export */   "parseConnectionString": () => (/* reexport safe */ _ConnectionStringParser__WEBPACK_IMPORTED_MODULE_2__.parseConnectionString),
/* harmony export */   "parseTraceParent": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__.parseTraceParent),
/* harmony export */   "strNotSpecified": () => (/* reexport safe */ _Constants__WEBPACK_IMPORTED_MODULE_4__.strNotSpecified),
/* harmony export */   "stringToBoolOrDefault": () => (/* reexport safe */ _HelperFuncs__WEBPACK_IMPORTED_MODULE_21__.stringToBoolOrDefault),
/* harmony export */   "urlGetAbsoluteUrl": () => (/* reexport safe */ _UrlHelperFuncs__WEBPACK_IMPORTED_MODULE_26__.urlGetAbsoluteUrl),
/* harmony export */   "urlGetCompleteUrl": () => (/* reexport safe */ _UrlHelperFuncs__WEBPACK_IMPORTED_MODULE_26__.urlGetCompleteUrl),
/* harmony export */   "urlGetPathName": () => (/* reexport safe */ _UrlHelperFuncs__WEBPACK_IMPORTED_MODULE_26__.urlGetPathName),
/* harmony export */   "urlParseFullHost": () => (/* reexport safe */ _UrlHelperFuncs__WEBPACK_IMPORTED_MODULE_26__.urlParseFullHost),
/* harmony export */   "urlParseHost": () => (/* reexport safe */ _UrlHelperFuncs__WEBPACK_IMPORTED_MODULE_26__.urlParseHost),
/* harmony export */   "urlParseUrl": () => (/* reexport safe */ _UrlHelperFuncs__WEBPACK_IMPORTED_MODULE_26__.urlParseUrl),
/* harmony export */   "utlCanUseLocalStorage": () => (/* reexport safe */ _StorageHelperFuncs__WEBPACK_IMPORTED_MODULE_25__.utlCanUseLocalStorage),
/* harmony export */   "utlCanUseSessionStorage": () => (/* reexport safe */ _StorageHelperFuncs__WEBPACK_IMPORTED_MODULE_25__.utlCanUseSessionStorage),
/* harmony export */   "utlDisableStorage": () => (/* reexport safe */ _StorageHelperFuncs__WEBPACK_IMPORTED_MODULE_25__.utlDisableStorage),
/* harmony export */   "utlEnableStorage": () => (/* reexport safe */ _StorageHelperFuncs__WEBPACK_IMPORTED_MODULE_25__.utlEnableStorage),
/* harmony export */   "utlGetLocalStorage": () => (/* reexport safe */ _StorageHelperFuncs__WEBPACK_IMPORTED_MODULE_25__.utlGetLocalStorage),
/* harmony export */   "utlGetSessionStorage": () => (/* reexport safe */ _StorageHelperFuncs__WEBPACK_IMPORTED_MODULE_25__.utlGetSessionStorage),
/* harmony export */   "utlGetSessionStorageKeys": () => (/* reexport safe */ _StorageHelperFuncs__WEBPACK_IMPORTED_MODULE_25__.utlGetSessionStorageKeys),
/* harmony export */   "utlRemoveSessionStorage": () => (/* reexport safe */ _StorageHelperFuncs__WEBPACK_IMPORTED_MODULE_25__.utlRemoveSessionStorage),
/* harmony export */   "utlRemoveStorage": () => (/* reexport safe */ _StorageHelperFuncs__WEBPACK_IMPORTED_MODULE_25__.utlRemoveStorage),
/* harmony export */   "utlSetLocalStorage": () => (/* reexport safe */ _StorageHelperFuncs__WEBPACK_IMPORTED_MODULE_25__.utlSetLocalStorage),
/* harmony export */   "utlSetSessionStorage": () => (/* reexport safe */ _StorageHelperFuncs__WEBPACK_IMPORTED_MODULE_25__.utlSetSessionStorage),
/* harmony export */   "utlSetStoragePrefix": () => (/* reexport safe */ _StorageHelperFuncs__WEBPACK_IMPORTED_MODULE_25__.utlSetStoragePrefix)
/* harmony export */ });
/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6);
/* harmony import */ var _ThrottleMgr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(74);
/* harmony import */ var _ConnectionStringParser__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(77);
/* harmony import */ var _RequestResponseHeaders__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(29);
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(7);
/* harmony import */ var _Telemetry_Common_Envelope__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(80);
/* harmony import */ var _Telemetry_Event__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(81);
/* harmony import */ var _Telemetry_Exception__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(82);
/* harmony import */ var _Telemetry_Metric__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(85);
/* harmony import */ var _Telemetry_PageView__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(87);
/* harmony import */ var _Telemetry_RemoteDependencyData__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(89);
/* harmony import */ var _Telemetry_Trace__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(90);
/* harmony import */ var _Telemetry_PageViewPerformance__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(91);
/* harmony import */ var _Telemetry_Common_Data__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(92);
/* harmony import */ var _Interfaces_Contracts_SeverityLevel__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(93);
/* harmony import */ var _Interfaces_IConfig__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(94);
/* harmony import */ var _Interfaces_Contracts_ContextTagKeys__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(95);
/* harmony import */ var _Telemetry_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(35);
/* harmony import */ var _TelemetryItemCreator__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(96);
/* harmony import */ var _Interfaces_PartAExtensions__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(97);
/* harmony import */ var _Enums__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(76);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(88);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(44);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(72);
/* harmony import */ var _DomHelperFuncs__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(98);
/* harmony import */ var _StorageHelperFuncs__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(75);
/* harmony import */ var _UrlHelperFuncs__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(17);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */

// Licensed under the


























var PropertiesPluginIdentifier = "AppInsightsPropertiesPlugin";
var BreezeChannelIdentifier = "AppInsightsChannelPlugin";
var AnalyticsPluginIdentifier = "ApplicationInsightsAnalytics";
//# sourceMappingURL=applicationinsights-common.js.map

/***/ }),
/* 6 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AjaxHelperParseDependencyPath": () => (/* binding */ AjaxHelperParseDependencyPath),
/* harmony export */   "correlationIdCanIncludeCorrelationHeader": () => (/* binding */ correlationIdCanIncludeCorrelationHeader),
/* harmony export */   "correlationIdGetCorrelationContext": () => (/* binding */ correlationIdGetCorrelationContext),
/* harmony export */   "correlationIdGetCorrelationContextValue": () => (/* binding */ correlationIdGetCorrelationContextValue),
/* harmony export */   "correlationIdGetPrefix": () => (/* binding */ correlationIdGetPrefix),
/* harmony export */   "correlationIdSetPrefix": () => (/* binding */ correlationIdSetPrefix),
/* harmony export */   "createDistributedTraceContextFromTrace": () => (/* binding */ createDistributedTraceContextFromTrace),
/* harmony export */   "dateTimeUtilsDuration": () => (/* binding */ dateTimeUtilsDuration),
/* harmony export */   "dateTimeUtilsNow": () => (/* binding */ dateTimeUtilsNow),
/* harmony export */   "isInternalApplicationInsightsEndpoint": () => (/* binding */ isInternalApplicationInsightsEndpoint)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(28);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(49);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(50);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(14);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(72);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(27);
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7);
/* harmony import */ var _RequestResponseHeaders__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(29);
/* harmony import */ var _Telemetry_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(35);
/* harmony import */ var _UrlHelperFuncs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(17);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */









// listing only non-geo specific locations
var _internalEndpoints = [
    _Constants__WEBPACK_IMPORTED_MODULE_0__.DEFAULT_BREEZE_ENDPOINT + _Constants__WEBPACK_IMPORTED_MODULE_0__.DEFAULT_BREEZE_PATH,
    "https://breeze.aimon.applicationinsights.io" + _Constants__WEBPACK_IMPORTED_MODULE_0__.DEFAULT_BREEZE_PATH,
    "https://dc-int.services.visualstudio.com" + _Constants__WEBPACK_IMPORTED_MODULE_0__.DEFAULT_BREEZE_PATH
];
var _correlationIdPrefix = "cid-v1:";
function isInternalApplicationInsightsEndpoint(endpointUrl) {
    return (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.arrIndexOf)(_internalEndpoints, endpointUrl[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]()) !== -1;
}
function correlationIdSetPrefix(prefix) {
    _correlationIdPrefix = prefix;
}
function correlationIdGetPrefix() {
    return _correlationIdPrefix;
}
/**
 * Checks if a request url is not on a excluded domain list and if it is safe to add correlation headers.
 * Headers are always included if the current domain matches the request domain. If they do not match (CORS),
 * they are regex-ed across correlationHeaderDomains and correlationHeaderExcludedDomains to determine if headers are included.
 * Some environments don't give information on currentHost via window.location.host (e.g. Cordova). In these cases, the user must
 * manually supply domains to include correlation headers on. Else, no headers will be included at all.
 */
function correlationIdCanIncludeCorrelationHeader(config, requestUrl, currentHost) {
    if (!requestUrl || (config && config.disableCorrelationHeaders)) {
        return false;
    }
    if (config && config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_CORRELATION_HEADER_E0 /* @min:%2ecorrelationHeaderExcludePatterns */]) {
        for (var i = 0; i < config.correlationHeaderExcludePatterns[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */]; i++) {
            if (config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_CORRELATION_HEADER_E0 /* @min:%2ecorrelationHeaderExcludePatterns */][i].test(requestUrl)) {
                return false;
            }
        }
    }
    var requestHost = (0,_UrlHelperFuncs__WEBPACK_IMPORTED_MODULE_3__.urlParseUrl)(requestUrl).host[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]();
    if (requestHost && ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.strIndexOf)(requestHost, ":443") !== -1 || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.strIndexOf)(requestHost, ":80") !== -1)) {
        // [Bug #1260] IE can include the port even for http and https URLs so if present
        // try and parse it to remove if it matches the default protocol port
        requestHost = ((0,_UrlHelperFuncs__WEBPACK_IMPORTED_MODULE_3__.urlParseFullHost)(requestUrl, true) || "")[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]();
    }
    if ((!config || !config.enableCorsCorrelation) && (requestHost && requestHost !== currentHost)) {
        return false;
    }
    var includedDomains = config && config.correlationHeaderDomains;
    if (includedDomains) {
        var matchExists_1;
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.arrForEach)(includedDomains, function (domain) {
            var regex = new RegExp(domain.toLowerCase().replace(/\\/g, "\\\\").replace(/\./g, "\\.").replace(/\*/g, ".*"));
            matchExists_1 = matchExists_1 || regex.test(requestHost);
        });
        if (!matchExists_1) {
            return false;
        }
    }
    var excludedDomains = config && config.correlationHeaderExcludedDomains;
    if (!excludedDomains || excludedDomains[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] === 0) {
        return true;
    }
    for (var i = 0; i < excludedDomains[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */]; i++) {
        var regex = new RegExp(excludedDomains[i].toLowerCase().replace(/\\/g, "\\\\").replace(/\./g, "\\.").replace(/\*/g, ".*"));
        if (regex.test(requestHost)) {
            return false;
        }
    }
    // if we don't know anything about the requestHost, require the user to use included/excludedDomains.
    // Previously we always returned false for a falsy requestHost
    return requestHost && requestHost[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] > 0;
}
/**
 * Combines target appId and target role name from response header.
 */
function correlationIdGetCorrelationContext(responseHeader) {
    if (responseHeader) {
        var correlationId = correlationIdGetCorrelationContextValue(responseHeader, _RequestResponseHeaders__WEBPACK_IMPORTED_MODULE_6__.RequestHeaders[1]);
        if (correlationId && correlationId !== _correlationIdPrefix) {
            return correlationId;
        }
    }
}
/**
 * Gets key from correlation response header
 */
function correlationIdGetCorrelationContextValue(responseHeader, key) {
    if (responseHeader) {
        var keyValues = responseHeader[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_SPLIT /* @min:%2esplit */](",");
        for (var i = 0; i < keyValues[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */]; ++i) {
            var keyValue = keyValues[i][_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_SPLIT /* @min:%2esplit */]("=");
            if (keyValue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] === 2 && keyValue[0] === key) {
                return keyValue[1];
            }
        }
    }
}
function AjaxHelperParseDependencyPath(logger, absoluteUrl, method, commandName) {
    var target, name = commandName, data = commandName;
    if (absoluteUrl && absoluteUrl[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] > 0) {
        var parsedUrl = (0,_UrlHelperFuncs__WEBPACK_IMPORTED_MODULE_3__.urlParseUrl)(absoluteUrl);
        target = parsedUrl.host;
        if (!name) {
            if (parsedUrl[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PATHNAME /* @min:%2epathname */] != null) {
                var pathName = (parsedUrl.pathname[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] === 0) ? "/" : parsedUrl[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PATHNAME /* @min:%2epathname */];
                if (pathName.charAt(0) !== "/") {
                    pathName = "/" + pathName;
                }
                data = parsedUrl[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PATHNAME /* @min:%2epathname */];
                name = (0,_Telemetry_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_7__.dataSanitizeString)(logger, method ? method + " " + pathName : pathName);
            }
            else {
                name = (0,_Telemetry_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_7__.dataSanitizeString)(logger, absoluteUrl);
            }
        }
    }
    else {
        target = commandName;
        name = commandName;
    }
    return {
        target: target,
        name: name,
        data: data
    };
}
function dateTimeUtilsNow() {
    // returns the window or webworker performance object
    var perf = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.getPerformance)();
    if (perf && perf.now && perf.timing) {
        var now = perf.now() + perf.timing.navigationStart;
        // Known issue with IE where this calculation can be negative, so if it is then ignore and fallback
        if (now > 0) {
            return now;
        }
    }
    return (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_9__.utcNow)();
}
function dateTimeUtilsDuration(start, end) {
    var result = null;
    if (start !== 0 && end !== 0 && !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_10__.isNullOrUndefined)(start) && !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_10__.isNullOrUndefined)(end)) {
        result = end - start;
    }
    return result;
}
/**
 * Creates a IDistributedTraceContext from an optional telemetryTrace
 * @param telemetryTrace - The telemetryTrace instance that is being wrapped
 * @param parentCtx - An optional parent distributed trace instance, almost always undefined as this scenario is only used in the case of multiple property handlers.
 * @returns A new IDistributedTraceContext instance that is backed by the telemetryTrace or temporary object
 */
function createDistributedTraceContextFromTrace(telemetryTrace, parentCtx) {
    var trace = telemetryTrace || {};
    return {
        getName: function () {
            return trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NAME /* @min:%2ename */];
        },
        setName: function (newValue) {
            parentCtx && parentCtx.setName(newValue);
            trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NAME /* @min:%2ename */] = newValue;
        },
        getTraceId: function () {
            return trace.traceID;
        },
        setTraceId: function (newValue) {
            parentCtx && parentCtx.setTraceId(newValue);
            if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_11__.isValidTraceId)(newValue)) {
                trace.traceID = newValue;
            }
        },
        getSpanId: function () {
            return trace.parentID;
        },
        setSpanId: function (newValue) {
            parentCtx && parentCtx.setSpanId(newValue);
            if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_11__.isValidSpanId)(newValue)) {
                trace.parentID = newValue;
            }
        },
        getTraceFlags: function () {
            return trace.traceFlags;
        },
        setTraceFlags: function (newTraceFlags) {
            parentCtx && parentCtx.setTraceFlags(newTraceFlags);
            trace.traceFlags = newTraceFlags;
        }
    };
}
//# sourceMappingURL=Util.js.map

/***/ }),
/* 7 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DEFAULT_BREEZE_ENDPOINT": () => (/* binding */ DEFAULT_BREEZE_ENDPOINT),
/* harmony export */   "DEFAULT_BREEZE_PATH": () => (/* binding */ DEFAULT_BREEZE_PATH),
/* harmony export */   "DisabledPropertyName": () => (/* binding */ DisabledPropertyName),
/* harmony export */   "HttpMethod": () => (/* binding */ HttpMethod),
/* harmony export */   "ProcessLegacy": () => (/* binding */ ProcessLegacy),
/* harmony export */   "SampleRate": () => (/* binding */ SampleRate),
/* harmony export */   "strIkey": () => (/* binding */ strIkey),
/* harmony export */   "strNotSpecified": () => (/* binding */ strNotSpecified)
/* harmony export */ });
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


/**
 * This is an internal property used to cause internal (reporting) requests to be ignored from reporting
 * additional telemetry, to handle polyfil implementations ALL urls used with a disabled request will
 * also be ignored for future requests even when this property is not provided.
 * Tagging as Ignore as this is an internal value and is not expected to be used outside of the SDK
 * @ignore
 */
var DisabledPropertyName = "Microsoft_ApplicationInsights_BypassAjaxInstrumentation";
var SampleRate = "sampleRate";
var ProcessLegacy = "ProcessLegacy";
var HttpMethod = "http.method";
var DEFAULT_BREEZE_ENDPOINT = "https://dc.services.visualstudio.com";
var DEFAULT_BREEZE_PATH = "/v2/track";
var strNotSpecified = "not_specified";
var strIkey = "iKey";
//# sourceMappingURL=Constants.js.map

/***/ }),
/* 8 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "arrIndexOf": () => (/* binding */ arrIndexOf),
/* harmony export */   "arrLastIndexOf": () => (/* binding */ arrLastIndexOf)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * The arrIndexOf() method returns the first index at which a given element can be found in the array,
 * or -1 if it is not present.
 * `arrIndexOf()` compares searchElement to elements of the Array using strict equality (the same
 * method used by the === or triple-equals operator).
 * @group Array
 * @group ArrayLike
 * @typeParam T - Identifies the type of array elements
 * @param theArray - The array or array like object of elements to be searched.
 * @param searchElement - The element to locate in the array.
 * @param fromIndex - The index to start the search at. If the index is greater than or equal to
 * the array's length, -1 is returned, which means the array will not be searched. If the provided
 * index value is a negative number, it is taken as the offset from the end of the array.
 * Note: if the provided index is negative, the array is still searched from front to back. If the
 * provided index is 0, then the whole array will be searched. Default: 0 (entire array is searched).
 * @return The first index of the element in the array; -1 if not found.
 * @example
 * ```ts
 * const array = [2, 9, 9];
 * arrIndexOf(array, 2);     // 0
 * arrIndexOf(array, 7);     // -1
 * arrIndexOf(array, 9, 2);  // 2
 * arrIndexOf(array, 2, -1); // -1
 * arrIndexOf(array, 2, -3); // 0
 *
 * let indices: number[] = [];
 * const array = ['a', 'b', 'a', 'c', 'a', 'd'];
 * const element = 'a';
 * let idx = arrIndexOf(array, element);
 * while (idx !== -1) {
 *   indices.push(idx);
 *   idx = arrIndexOf(array, element, idx + 1);
 * }
 * console.log(indices);
 * // [0, 2, 4]
 *
 * function updateVegetablesCollection (veggies, veggie) {
 *     if (arrIndexOf(veggies, veggie) === -1) {
 *         veggies.push(veggie);
 *         console.log('New veggies collection is : ' + veggies);
 *     } else {
 *         console.log(veggie + ' already exists in the veggies collection.');
 *     }
 * }
 *
 * let veggies = ['potato', 'tomato', 'chillies', 'green-pepper'];
 *
 * updateVegetablesCollection(veggies, 'spinach');
 * // New veggies collection is : potato,tomato,chillies,green-pepper,spinach
 * updateVegetablesCollection(veggies, 'spinach');
 * // spinach already exists in the veggies collection.
 *
 * // Array Like
 * let arrayLike = {
 *   length: 3,
 *   0: "potato",
 *   1: "tomato",
 *   2: "chillies",
 *   3: "green-pepper"  // Not checked as index is > length
 * };
 *
 * arrIndexOf(arrayLike, "potato"); // 0
 * arrIndexOf(arrayLike, "tomato"); // 1
 * arrIndexOf(arrayLike, "chillies"); 2
 * arrIndexOf(arrayLike, "green-pepper"); // -1
 * ```
 */
var arrIndexOf = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunction)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.INDEX_OF, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.ArrProto);
/**
 * The arrLastIndexOf() method returns the last index at which a given element can be found in the array,
 * or -1 if it is not present.
 * `arrLastIndexOf()` compares searchElement to elements of the Array using strict equality (the same
 * method used by the === or triple-equals operator). [NaN](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NaN)
 * values are never compared as equal, so arrLastIndexOf() always returns -1 when searchElement is NaN.
 *
 * The arrLastIndexOf() method skips empty slots in sparse arrays.
 *
 * The arrLastIndexOf() method is generic. It only expects the this value to have a length property and integer-keyed properties.
 *
 * @since 0.8.0
 * @group Array
 * @group ArrayLike
 * @typeParam T - Identifies the type of array elements
 * @param theArray - The array or array like object of elements to be searched.
 * @param searchElement - The element to locate in the array.
 * @param fromIndex - Zero-based index at which to start searching backwards, converted to an integer.
 * - Negative index counts back from the end of the array — if fromIndex < 0, fromIndex + array.length is used.
 * - If fromIndex < -array.length, the array is not searched and -1 is returned. You can think of it conceptually
 * as starting at a nonexistent position before the beginning of the array and going backwards from there. There
 * are no array elements on the way, so searchElement is never found.
 * - If fromIndex >= array.length or fromIndex is omitted, array.length - 1 is used, causing the entire array to
 * be searched. You can think of it conceptually as starting at a nonexistent position beyond the end of the array and going backwards from there. It eventually reaches the real end position of the array, at which point it starts searching backwards through the actual array elements.
 * @return The first index of the element in the array; -1 if not found.
 * @example
 * ```ts
 * const numbers = [2, 5, 9, 2];
 * arrLastIndexOf(numbers, 2); // 3
 * arrLastIndexOf(numbers, 7); // -1
 * arrLastIndexOf(numbers, 2, 3); // 3
 * arrLastIndexOf(numbers, 2, 2); // 0
 * arrLastIndexOf(numbers, 2, -2); // 0
 * arrLastIndexOf(numbers, 2, -1); // 3
 *
 * let indices: number[] = [];
 * const array = ["a", "b", "a", "c", "a", "d"];
 * const element = "a";
 * let idx = arrLastIndexOf(array, element);
 * while (idx !== -1) {
 *   indices.push(idx);
 *   idx = arrLastIndexOf(array, element, idx ? idx - 1 : -(array.length + 1));
 * }
 * console.log(indices);
 * // [4, 2, 0]
 *
 * function updateVegetablesCollection (veggies, veggie) {
 *     if (arrLastIndexOf(veggies, veggie) === -1) {
 *         veggies.push(veggie);
 *         console.log('New veggies collection is : ' + veggies);
 *     } else {
 *         console.log(veggie + ' already exists in the veggies collection.');
 *     }
 * }
 *
 * let veggies = ['potato', 'tomato', 'chillies', 'green-pepper'];
 *
 * updateVegetablesCollection(veggies, 'spinach');
 * // New veggies collection is : potato,tomato,chillies,green-pepper,spinach
 * updateVegetablesCollection(veggies, 'spinach');
 * // spinach already exists in the veggies collection.
 *
 * // Array Like
 * let arrayLike = {
 *   length: 3,
 *   0: "potato",
 *   1: "tomato",
 *   2: "chillies",
 *   3: "green-pepper"  // Not checked as index is > length
 * };
 *
 * arrLastIndexOf(arrayLike, "potato"); // 0
 * arrLastIndexOf(arrayLike, "tomato"); // 1
 * arrLastIndexOf(arrayLike, "chillies"); 2
 * arrLastIndexOf(arrayLike, "green-pepper"); // -1
 * ```
 */
var arrLastIndexOf = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunction)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.LAST_INDEX_OF, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.ArrProto);
//# sourceMappingURL=indexOf.js.map

/***/ }),
/* 9 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_unwrapFunction": () => (/* binding */ _unwrapFunction),
/* harmony export */   "_unwrapFunctionWithPoly": () => (/* binding */ _unwrapFunctionWithPoly),
/* harmony export */   "_unwrapInstFunction": () => (/* binding */ _unwrapInstFunction),
/* harmony export */   "_unwrapProp": () => (/* binding */ _unwrapProp)
/* harmony export */ });
/* harmony import */ var _helpers_diagnostics__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13);
/* harmony import */ var _helpers_throw__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11);
/* harmony import */ var _string_as_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */




var _arrSlice = _constants__WEBPACK_IMPORTED_MODULE_0__.ArrProto[_constants__WEBPACK_IMPORTED_MODULE_0__.SLICE];
var _throwMissingFunction = function (funcName, thisArg) {
    (0,_helpers_throw__WEBPACK_IMPORTED_MODULE_1__.throwTypeError)("'" + (0,_string_as_string__WEBPACK_IMPORTED_MODULE_2__.asString)(funcName) + "' not defined for " + (0,_helpers_diagnostics__WEBPACK_IMPORTED_MODULE_3__.dumpObj)(thisArg));
};
/**
 * @internal
 * @ignore
 * Internal helper to run the named function on the passed first argument, this does not support polyfill
 * or prototype fallback, so the function must exist on the provided first argument.
 * If the first argument is null, undefined or the function does not exist an exception will be thrown
 * by the runtime
 * @param funcName - The function name to call on the first argument passed to the wrapped function
 * @returns A function which will call the funcName against the first passed argument and pass on the remaining arguments
 */
var _unwrapInstFunction = function (funcName) {
    return function (thisArg) {
        return thisArg[funcName].apply(thisArg, _arrSlice.call(arguments, 1));
    };
};
/**
 * @internal
 * @ignore
 * Internal helper to convert an expanded function back into an instance `this` function call
 * @param funcName - The function name to call on the first argument passed to the wrapped function
 * @param clsProto - The Class or class prototype to fallback to if the instance doesn't have the function.
 * @returns A function which will call the funcName against the first passed argument and pass on the remaining arguments
 */
var _unwrapFunction = function (funcName, clsProto) {
    var clsFn = clsProto && clsProto[funcName];
    return function (thisArg) {
        var theFunc = (thisArg && thisArg[funcName]) || clsFn;
        if (theFunc) {
            return theFunc.apply(thisArg, _arrSlice.call(arguments, 1));
        }
        _throwMissingFunction(funcName, thisArg);
    };
};
/**
 * @internal
 * @ignore
 * Internal helper to convert an expanded function back into an instance `this` function call
 * @param funcName - The function name to call on the first argument passed to the wrapped function
 * @param clsProto - The Class or class prototype to fallback to if the instance doesn't have the function.
 * @param polyFunc - The function to call if not available on the thisArg, act like the polyfill
 * @returns A function which will call the funcName against the first passed argument and pass on the remaining arguments
 */
var _unwrapFunctionWithPoly = function (funcName, clsProto, polyFunc) {
    var clsFn = clsProto && clsProto[funcName];
    return function (thisArg) {
        var theFunc = (thisArg && thisArg[funcName]) || clsFn;
        if (theFunc || polyFunc) {
            var theArgs = arguments;
            return (theFunc || polyFunc).apply(thisArg, theFunc ? _arrSlice.call(theArgs, 1) : theArgs);
        }
        _throwMissingFunction(funcName, thisArg);
    };
};
/**
 * @internal
 * @ignore
 * Internal helper to lookup and return the named property from the first argument (which becomes the this)
 *
 * @since 0.4.2
 * @typeParam T - The type of the object which contains the propName
 * @param propName - The property name
 * @returns The value of the property
 */
function _unwrapProp(propName) {
    return function (thisArg) {
        return thisArg[propName];
    };
}
//# sourceMappingURL=unwrapFunction.js.map

/***/ }),
/* 10 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ArrCls": () => (/* binding */ ArrCls),
/* harmony export */   "ArrProto": () => (/* binding */ ArrProto),
/* harmony export */   "BOOLEAN": () => (/* binding */ BOOLEAN),
/* harmony export */   "CONSTRUCTOR": () => (/* binding */ CONSTRUCTOR),
/* harmony export */   "DONE": () => (/* binding */ DONE),
/* harmony export */   "EMPTY": () => (/* binding */ EMPTY),
/* harmony export */   "FUNCTION": () => (/* binding */ FUNCTION),
/* harmony export */   "INDEX_OF": () => (/* binding */ INDEX_OF),
/* harmony export */   "LAST_INDEX_OF": () => (/* binding */ LAST_INDEX_OF),
/* harmony export */   "LENGTH": () => (/* binding */ LENGTH),
/* harmony export */   "MathCls": () => (/* binding */ MathCls),
/* harmony export */   "NAME": () => (/* binding */ NAME),
/* harmony export */   "NULL_VALUE": () => (/* binding */ NULL_VALUE),
/* harmony export */   "NUMBER": () => (/* binding */ NUMBER),
/* harmony export */   "OBJECT": () => (/* binding */ OBJECT),
/* harmony export */   "ObjClass": () => (/* binding */ ObjClass),
/* harmony export */   "ObjProto": () => (/* binding */ ObjProto),
/* harmony export */   "POLYFILL_TAG": () => (/* binding */ POLYFILL_TAG),
/* harmony export */   "PROTOTYPE": () => (/* binding */ PROTOTYPE),
/* harmony export */   "SLICE": () => (/* binding */ SLICE),
/* harmony export */   "STRING": () => (/* binding */ STRING),
/* harmony export */   "SYMBOL": () => (/* binding */ SYMBOL),
/* harmony export */   "StrCls": () => (/* binding */ StrCls),
/* harmony export */   "StrProto": () => (/* binding */ StrProto),
/* harmony export */   "UNDEFINED": () => (/* binding */ UNDEFINED),
/* harmony export */   "UNDEF_VALUE": () => (/* binding */ UNDEF_VALUE),
/* harmony export */   "VALUE": () => (/* binding */ VALUE),
/* harmony export */   "__PROTO__": () => (/* binding */ __PROTO__)
/* harmony export */ });
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
// These constants are currently NOT exported directly, we may export them later associated with a frozen namespace (maybe)
// For now do NOT expect that we will export these values.
var UNDEF_VALUE = undefined;
var NULL_VALUE = null;
var EMPTY = "";
var BOOLEAN = "boolean";
var FUNCTION = "function";
var NUMBER = "number";
var OBJECT = "object";
var PROTOTYPE = "prototype";
var __PROTO__ = "__proto__";
var STRING = "string";
var UNDEFINED = "undefined";
var CONSTRUCTOR = "constructor";
var SYMBOL = "Symbol";
var POLYFILL_TAG = "_polyfill";
var INDEX_OF = "indexOf";
var LAST_INDEX_OF = "lastIndexOf";
var LENGTH = "length";
var DONE = "done";
var VALUE = "value";
var NAME = "name";
var SLICE = "slice";
/**
 * @ignore
 */
var ObjClass = Object;
/**
 * @ignore
 */
var ObjProto = ObjClass[PROTOTYPE];
/**
 * @ignore
 */
var StrCls = String;
/**
 * @ignore
 */
var StrProto = StrCls[PROTOTYPE];
/**
 * @ignore
 */
var MathCls = Math;
/**
 * @ignore
 */
var ArrCls = Array;
/**
 * @ignore
 */
var ArrProto = ArrCls[PROTOTYPE];
//# sourceMappingURL=constants.js.map

/***/ }),
/* 11 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "throwError": () => (/* binding */ throwError),
/* harmony export */   "throwRangeError": () => (/* binding */ throwRangeError),
/* harmony export */   "throwTypeError": () => (/* binding */ throwTypeError)
/* harmony export */ });
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
/**
 * Throw an error exception with the specified optional message
 * @group Error
 * @param message
 */
function throwError(message) {
    throw new Error(message);
}
/**
 * Throw a type error with the specified optional message
 * @group Error
 * @param message
 */
function throwTypeError(message) {
    throw new TypeError(message);
}
/**
 * Throw a RangeError with the specified optional message
 * @group Error
 * @param message
 */
function throwRangeError(message) {
    throw new RangeError(message);
}
//# sourceMappingURL=throw.js.map

/***/ }),
/* 12 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "asString": () => (/* binding */ asString)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

/**
 * The asString() method returns a string representing the value by
 * explicitly using `String(`value`)`.
 *
 * @since 0.4.3
 * @group String
 * @group Conversion
 * @group Value
 * @param value - The value to get a string representation of
 * @example
 * ```ts
 * const arr = [ 1, 2, 3];
 * asString(arr);       // "1,2,3"
 * asString(null);      // "null"
 * asString(undefined); // "undefined"
 * asString(42);        // "42"
 * asString(Symbol.for("Hello"));   // "Symbol(Hello)"
 * ```
 */
var asString = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.StrCls;
//# sourceMappingURL=as_string.js.map

/***/ }),
/* 13 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "dumpObj": () => (/* binding */ dumpObj)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * Returns string representation of an object suitable for diagnostics logging.
 * @group Error
 * @group Diagnostic
 * @param object - The object to be converted to a diagnostic string value
 * @param format - Identifies whether the JSON value should be formated
 * - `true` - Format with 4 spaces
 * - 'number' - The number of spaces to format with
 * - `false` (or not Truthy) - Do not format
 */
function dumpObj(object, format) {
    var propertyValueDump = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.EMPTY;
    if ((0,_base__WEBPACK_IMPORTED_MODULE_1__.isError)(object)) {
        propertyValueDump = "{ stack: '" + object.stack + "', message: '" + object.message + "', name: '" + object.name + "'";
    }
    else {
        try {
            propertyValueDump = JSON.stringify(object, _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE, format ? ((0,_base__WEBPACK_IMPORTED_MODULE_1__.isNumber)(format) ? format : 4) : _internal_constants__WEBPACK_IMPORTED_MODULE_0__.UNDEF_VALUE);
        }
        catch (e) {
            // Unable to convert object (probably circular)
            propertyValueDump = " - " + dumpObj(e, format);
        }
    }
    return (0,_base__WEBPACK_IMPORTED_MODULE_1__.objToString)(object) + ": " + propertyValueDump;
}
//# sourceMappingURL=diagnostics.js.map

/***/ }),
/* 14 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_createIs": () => (/* binding */ _createIs),
/* harmony export */   "_createObjIs": () => (/* binding */ _createObjIs),
/* harmony export */   "isArray": () => (/* binding */ isArray),
/* harmony export */   "isArrayBuffer": () => (/* binding */ isArrayBuffer),
/* harmony export */   "isBlob": () => (/* binding */ isBlob),
/* harmony export */   "isBoolean": () => (/* binding */ isBoolean),
/* harmony export */   "isDate": () => (/* binding */ isDate),
/* harmony export */   "isDefined": () => (/* binding */ isDefined),
/* harmony export */   "isError": () => (/* binding */ isError),
/* harmony export */   "isFile": () => (/* binding */ isFile),
/* harmony export */   "isFormData": () => (/* binding */ isFormData),
/* harmony export */   "isFunction": () => (/* binding */ isFunction),
/* harmony export */   "isNotTruthy": () => (/* binding */ isNotTruthy),
/* harmony export */   "isNullOrUndefined": () => (/* binding */ isNullOrUndefined),
/* harmony export */   "isNumber": () => (/* binding */ isNumber),
/* harmony export */   "isObject": () => (/* binding */ isObject),
/* harmony export */   "isPrimitive": () => (/* binding */ isPrimitive),
/* harmony export */   "isPrimitiveType": () => (/* binding */ isPrimitiveType),
/* harmony export */   "isPromise": () => (/* binding */ isPromise),
/* harmony export */   "isPromiseLike": () => (/* binding */ isPromiseLike),
/* harmony export */   "isRegExp": () => (/* binding */ isRegExp),
/* harmony export */   "isStrictNullOrUndefined": () => (/* binding */ isStrictNullOrUndefined),
/* harmony export */   "isStrictUndefined": () => (/* binding */ isStrictUndefined),
/* harmony export */   "isString": () => (/* binding */ isString),
/* harmony export */   "isThenable": () => (/* binding */ isThenable),
/* harmony export */   "isTruthy": () => (/* binding */ isTruthy),
/* harmony export */   "isTypeof": () => (/* binding */ isTypeof),
/* harmony export */   "isUndefined": () => (/* binding */ isUndefined),
/* harmony export */   "objToString": () => (/* binding */ objToString)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/* harmony import */ var _safe_get__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(15);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


var PRIMITIVE_TYPES = [_internal_constants__WEBPACK_IMPORTED_MODULE_0__.STRING, _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NUMBER, _internal_constants__WEBPACK_IMPORTED_MODULE_0__.BOOLEAN, _internal_constants__WEBPACK_IMPORTED_MODULE_0__.UNDEFINED, "symbol", "bigint"];
/**
 * @ignore
 * @internal
 * Create and returns a function that will return `true` if the argument passed
 * to it matches the provided type.
 * @param theType - The type to match against the `typeof value`
 * @returns A function which takes a single argument and returns a boolean
 */
function _createIs(theType) {
    return function (value) {
        return typeof value === theType;
    };
}
/**
 * @ignore
 * @internal
 * Create and returns a function that will return `true` if the argument passed
 * to it matches the object type specified based on {@link objToString}.
 * @param - The object name to match for the `objToString(value)`
 * @returns A function which takes a single argument and returns a boolean
 */
function _createObjIs(theName) {
    var theType = "[object " + theName + "]";
    return function (value) {
        return !!(value && objToString(value) === theType);
    };
}
/**
 * The `objToString()` method returns a string representing the object. This explicitly
 * always calls the `Object.prototype.toString()` method.
 *
 * An object's toString() method is most commonly invoked when that object undergoes:
 * - explicit type conversion to a string (for example, String(myObject))
 * - implicit type coercion into a string (for example, myObject + "hello world")
 *
 * @group Object
 * @param value - The object to be converted into a string
 * @returns A string representation of the object
 * @example
 * ```ts
 * objToString(new Date()); // [object Date]
 * objToString(new String()); // [object String]
 *
 * // Math has its Symbol.toStringTag
 * objToString(Math); // [object Math]
 *
 * objToString(undefined); // [object Undefined]
 * objToString(null); // [object Null]
 * ```
 */
function objToString(value) {
    return _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjProto.toString.call(value);
}
/**
 * Validate if the provided value object is of the expected type
 * @group Type Identity
 * @param value - The value to check
 * @param theType - The expected type name as a string
 * @returns `true` if the value matches the provided type
 */
function isTypeof(value, theType) {
    return typeof value === theType;
}
/**
 * Checks if the provided value is undefined or contains the string value "undefined",
 * if you want to consider the string value as undefined see {@link isStrictUndefined}
 * @group Type Identity
 * @group Value Check
 * @param value - The value to check
 * @returns true if the value is undefined or "undefined", otherwise false
 * @example
 * ```ts
 * isUndefined(undefined);              // true
 * isUndefined("undefined");            // true
 *
 * isUndefined(null);                   // false
 * isUndefined("null");                 // false
 * isUndefined("1");                    // false
 * isUndefined("aa");                   // false
 * isUndefined(new Date());             // false
 * isUndefined(1);                      // false
 * isUndefined("");                     // false
 * isUndefined(_dummyFunction);         // false
 * isUndefined([]);                     // false
 * isUndefined(new Array(1));           // false
 * isUndefined(true);                   // false
 * isUndefined(false);                  // false
 * isUndefined("true");                 // false
 * isUndefined("false");                // false
 * isUndefined(new Boolean(true));      // false
 * isUndefined(new Boolean(false));     // false
 * isUndefined(new Boolean("true"));    // false
 * isUndefined(new Boolean("false"));   // false
 * isUndefined(Boolean(true));          // false
 * isUndefined(Boolean(false));         // false
 * isUndefined(Boolean("true"));        // false
 * isUndefined(Boolean("false"));       // false
 * isUndefined(new RegExp(""));         // false
 * isUndefined(new ArrayBuffer(0));     // false
 * isUndefined(new Error("Test Error"));// false
 * isUndefined(new TypeError("Test TypeError"));    // false
 * isUndefined(new TestError("Test TestError"));    // false
 * isUndefined(_dummyError());          // false
 * isUndefined(Promise.reject());       // false
 * isUndefined(Promise.resolve());      // false
 * isUndefined(new Promise(() => {}));  // false
 * isUndefined(_simplePromise());       // false
 * isUndefined(_simplePromiseLike());   // false
 * isUndefined(Object.create(null));    // false
 * isUndefined(polyObjCreate(null));    // false
 * ```
 */
function isUndefined(value) {
    return typeof value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.UNDEFINED || value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.UNDEFINED;
}
/**
 * Checks if the provided value is undefined, a string value of "undefined" is NOT considered
 * to be undefined.
 * @group Type Identity
 * @group Value Check
 * @param value - The value to check
 * @returns true if the typeof value === UNDEFINED
 * @example
 * ```ts
 * isStrictUndefined(undefined);    // true
 *
 * isStrictUndefined(null);         // false
 * isStrictUndefined("null");       // false
 * isStrictUndefined("undefined");  // false
 * isStrictUndefined("1");          // false
 * isStrictUndefined("aa");         // false
 * isStrictUndefined(new Date());   // false
 * isStrictUndefined(0);            // false
 * isStrictUndefined(1);            // false
 * isStrictUndefined("");           // false
 * ```
 */
function isStrictUndefined(arg) {
    return !isDefined(arg);
}
/**
 * Checks if the provided value is null, undefined or contains the string value of "undefined".
 * @group Type Identity
 * @group Value Check
 * @param value - The value to check
 * @returns `true` if the value is `null` or `undefined`
 * @example
 * ```ts
 * isNullOrUndefined(null);         // true
 * isNullOrUndefined(undefined);    // true
 * isNullOrUndefined("undefined");  // true
 *
 * let value = null;
 * isNullOrUndefined(value);        // true
 * let value = undefined;
 * isNullOrUndefined(value);        // true
 *
 * isNullOrUndefined("");           // false
 * isNullOrUndefined(0);            // false
 * isNullOrUndefined(new Date());   // false
 * isNullOrUndefined(true);         // false
 * isNullOrUndefined(false);        // false
 * ```
 */
function isNullOrUndefined(value) {
    return value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE || isUndefined(value);
}
/**
 * Checks if the provided value is null, undefined only, a string value of "undefined" is NOT considered
 * to be undefined.
 * @group Type Identity
 * @group Value Check
 * @param value - The value to check
 * @returns
 * @example
 * ```ts
 * isStrictNullOrUndefined(null);         // true
 * isStrictNullOrUndefined(undefined);    // true
 * isStrictNullOrUndefined("undefined");  // false
 *
 * let value = null;
 * isStrictNullOrUndefined(value);        // true
 * let value = undefined;
 * isStrictNullOrUndefined(value);        // true
 *
 * isStrictNullOrUndefined("");           // false
 * isStrictNullOrUndefined(0);            // false
 * isStrictNullOrUndefined(new Date());   // false
 * isStrictNullOrUndefined(true);         // false
 * isStrictNullOrUndefined(false);        // false
 * ```
 */
function isStrictNullOrUndefined(value) {
    return value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE || !isDefined(value);
}
/**
 * Checks if the passed value is defined, which means it has any value and is not undefined.
 * A string value of "undefined" is considered to be defined.
 * @group Value Check
 * @param arg - The value to check
 * @returns true if arg has a value (is not === undefined)
 * @example
 * ```ts
 * isDefined(null);         // false
 * isDefined(undefined);    // false
 * isDefined("undefined");  // true
 *
 * let value = null;
 * isDefined(value);        // false
 * let value = undefined;
 * isDefined(value);        // false
 *
 * isDefined("");           // true
 * isDefined(0);            // true
 * isDefined(new Date());   // true
 * isDefined(true);         // true
 * isDefined(false);        // true
 * ```
 */
function isDefined(arg) {
    return !!arg || arg !== _internal_constants__WEBPACK_IMPORTED_MODULE_0__.UNDEF_VALUE;
}
/**
 * Identifies whether the provided value is a JavaScript [primitive](https://developer.mozilla.org/en-US/docs/Glossary/Primitive)
 * which is when is it not an object and has no methods or properties. There are 7 primitive data types:
 * - string
 * - number
 * - bigint
 * - boolean
 * - undefined
 * - null
 * - symbol
 *
 * Most of the time, a primitive value is represented directly at the lowest level of the language implementation.
 *
 * All primitives are immutable; that is, they cannot be altered. It is important not to confuse a primitive itself
 * with a variable assigned a primitive value. The variable may be reassigned to a new value, but the existing value
 * can not be changed in the ways that objects, arrays, and functions can be altered. The language does not offer
 * utilities to mutate primitive values.
 * @since 0.4.4
 * @group Type Identity
 * @param value - The value to check whether it's a primitive value
 * @example
 * ```ts
 * isPrimitive(null);                   // true
 * isPrimitive(undefined);              // true
 * isPrimitive("null");                 // true
 * isPrimitive("undefined");            // true
 * isPrimitive("1");                    // true
 * isPrimitive("aa");                   // true
 * isPrimitive(1);                      // true
 * isPrimitive(Number(2));              // true
 * isPrimitive("");                     // true
 * isPrimitive(String(""));             // true
 * isPrimitive(true);                   // true
 * isPrimitive(false);                  // true
 * isPrimitive("true");                 // true
 * isPrimitive("false");                // true
 * isPrimitive(BigInt(42));             // true
 * isPrimitive(Symbol.for("Hello"));    // true
 *
 * isPrimitive(new String("aa"));       // false
 * isPrimitive(new Date());             // false
 * isPrimitive(_dummyFunction);         // false
 * isPrimitive([]);                     // false
 * isPrimitive(new Array(1));           // false
 * isPrimitive(new Boolean(true));      // false
 * isPrimitive(new Boolean(false));     // false
 * isPrimitive(new Boolean("true"));    // false
 * isPrimitive(new Boolean("false"));   // false
 * ```
 */
var isPrimitive = function (value) {
    return value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE || isPrimitiveType(typeof value);
};
/**
 * Identifies whether the provided value is a JavaScript [primitive](https://developer.mozilla.org/en-US/docs/Glossary/Primitive)
 * which is when is it not an object and has no methods or properties. There are 6 primitive data types:
 * - string
 * - number
 * - bigint
 * - boolean
 * - undefined
 * - symbol
 *
 * Most of the time, a primitive value is represented directly at the lowest level of the language implementation.
 *
 * All primitives are immutable; that is, they cannot be altered. It is important not to confuse a primitive itself
 * with a variable assigned a primitive value. The variable may be reassigned to a new value, but the existing value
 * can not be changed in the ways that objects, arrays, and functions can be altered. The language does not offer
 * utilities to mutate primitive values.
 * @since 0.9.6
 * @group Type Identity
 * @param theType - The type as a string value to be checked whther it's a primitive type, this should be the value
 * returned from `typeof value`.
 * @example
 * ```ts
 * isPrimitiveType(null);                   // false
 * isPrimitiveType(undefined);              // false
 * isPrimitiveType("null");                 // false
 * isPrimitiveType("undefined");            // false
 * isPrimitiveType("1");                    // false
 * isPrimitiveType("aa");                   // false
 * isPrimitiveType(1);                      // false
 * isPrimitiveType(Number(2));              // false
 * isPrimitiveType("");                     // false
 * isPrimitiveType(String(""));             // false
 * isPrimitiveType(true);                   // false
 * isPrimitiveType(false);                  // false
 * isPrimitiveType("true");                 // false
 * isPrimitiveType("false");                // false
 * isPrimitiveType(BigInt(42));             // false
 * isPrimitiveType(Symbol.for("Hello"));    // false
 *
 * isPrimitiveType("string");               // true
 * isPrimitiveType("number");               // true
 * isPrimitiveType("boolean");              // true
 * isPrimitiveType("undefined");            // true
 * isPrimitiveType("symbol");               // true
 * isPrimitiveType("bigint");               // true
 * ```
 */
var isPrimitiveType = function (theType) {
    return theType !== _internal_constants__WEBPACK_IMPORTED_MODULE_0__.OBJECT && PRIMITIVE_TYPES.indexOf(theType) !== -1;
};
/**
 * Checks to see if the past value is a string value
 * @group Type Identity
 * @group String
 * @param value - The value to check
 * @returns
 * @example
 * ```ts
 * isString("");            // true
 * isString("null");        // true
 * isString("undefined");   // true
 * isString(String(""));    // true
 *
 * isString(null);          // false
 * isString(undefined);     // false
 * isString(0);             // false
 * ```
 */
var isString = _createIs(_internal_constants__WEBPACK_IMPORTED_MODULE_0__.STRING);
/**
 * Checks to see if the past value is a function value
 * @group Type Identity
 * @param value - The value to check
 * @returns
 * @example
 * ```ts
 * function myFunction() { }
 * isFunction(null);            // false
 * isFunction(undefined);       // false
 * isFunction("null");          // false
 * isFunction("undefined");     // false
 * isFunction("1");             // false
 * isFunction("aa");            // false
 * isFunction(new Date());      // false
 * isFunction(1);               // false
 * isFunction("");              // false
 * isFunction(myFunction);      // true
 * isFunction([]);              // false
 * isFunction(new Array(1));    // false
 * ```
 */
var isFunction = _createIs(_internal_constants__WEBPACK_IMPORTED_MODULE_0__.FUNCTION);
/**
 * Checks to see if the past value is an object value
 * @group Type Identity
 * @group Object
 * @typeParam T - The object type, defaults to any
 * @param value - The value to check
 * @returns
 */
function isObject(value) {
    if (!value && isNullOrUndefined(value)) {
        return false;
    }
    return !!value && typeof value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.OBJECT;
}
/**
 * Checks if the type of value is an Array.
 *
 * @group Type Identity
 * @group Array
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a Array, false otherwise.
 * @example
 * ```ts
 * import { isArray, isObject } from "@nevware21/ts-utils";
 *
 * function performAction(value: any) {
 *     if (isArray(value) || isObject(value)) {
 *         // Do something
 *     } else {
 *         // Do something else
 *     }
 * }
 * ```
 */
var isArray = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ArrCls.isArray;
/**
 * Check if an object is of type Date
 * @group Type Identity
 * @example
 * ```ts
 * import { isDate } from "@nevware21/ts-utils";
 *
 * let _theDate = null;
 *
 * function getSetDate(newDate?: any) {
 *     _theDate = isDate(newDate) ? newDate : new Date();
 *
 *     return _theDate;
 * }
 * ```
 */
var isDate = _createObjIs("Date");
/**
 * Checks if the type of value is a number.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a number, false otherwise.
 */
var isNumber = _createIs(_internal_constants__WEBPACK_IMPORTED_MODULE_0__.NUMBER);
/**
 * Checks if the type of value is a boolean.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a boolean, false otherwise.
 */
var isBoolean = _createIs(_internal_constants__WEBPACK_IMPORTED_MODULE_0__.BOOLEAN);
/**
 * Determines if a value is a regular expression object.
 * @group Type Identity
 * @param {*} value Reference to check.
 * @returns {boolean} True if `value` is a `RegExp`.
 */
var isRegExp = _createObjIs("RegExp");
/**
 * Checks if the type of value is a File object.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a File, false otherwise.
 */
var isFile = _createObjIs("File");
/**
 * Checks if the type of value is a FormData object.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a FormData, false otherwise.
 */
var isFormData = _createObjIs("FormData");
/**
 * Checks if the type of value is a Blob object.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a Blob, false otherwise.
 */
var isBlob = _createObjIs("Blob");
/**
 * Checks if the type of value is a ArrayBuffer object.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a ArrayBuffer, false otherwise.
 */
var isArrayBuffer = _createObjIs("ArrayBuffer");
/**
 * Checks if the type of value is a Error object.
 * @group Type Identity
 * @group Error
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a Error, false otherwise.
 */
var isError = _createObjIs("Error");
/**
 * Checks if the type of value is a PromiseLike instance (contains a then function).
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a PromiseLike, false otherwise.
 */
function isPromiseLike(value) {
    return !!value && isFunction(value.then);
}
/**
 * Checks if the type of value is a PromiseLike instance (contains a then function).
 * This is an alias for {@link isPromiseLike}.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a PromiseLike, false otherwise.
 */
var isThenable = isPromiseLike;
/**
 * Checks if the type of value is a Promise instance (contains then and catch functions).
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a Promise, false otherwise.
 */
function isPromise(value) {
    return isPromiseLike(value) && isFunction(value.catch);
}
/**
 * Checks if the type of value does not evaluate to true value, handling some special
 * case usages of Boolean(true/false) and new Boolean(true/false).
 * @group Value Check
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is not truthy, false otherwise.
 */
function isNotTruthy(value) {
    return !value || !(0,_safe_get__WEBPACK_IMPORTED_MODULE_1__.safeGet)(function () { return (value && (0 + value)); }, value);
}
/**
 * Checks if the type of value evaluates to true value, handling some special
 * case usages of Boolean(true/false) and new Boolean(true/false).
 * @group Value Check
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is not truthy, false otherwise.
 */
function isTruthy(value) {
    // Objects created with no prototype (Object.create(null)) cannot be converted to primitives
    // Which causes this code to throw, additionally just using !! also fails for Boolean objects
    // !!(new Boolean(false)) evaluates to true
    return !(!value || (0,_safe_get__WEBPACK_IMPORTED_MODULE_1__.safeGet)(function () { return !(value && (0 + value)); }, !value));
    //return !(!value || !(value && (0 + value)));
}
//# sourceMappingURL=base.js.map

/***/ }),
/* 15 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "safeGet": () => (/* binding */ safeGet)
/* harmony export */ });
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
/**
 * Function to safely execute a callback function, if the function throws the provided default
 * value will be returned.
 * @since 0.9.5
 * @group Safe
 * @param cb - Callback function be wrapped with an exception
 * @param defValue - The default value to return when an exception is thrown
 * @returns The result of the callback function or the default if an exception occurred calling the callback
 * function.
 * @example
 * ```ts
 * let theExpression = "{ invalid: json value";
 *
 * let result = safeGet(() => {
 *     return JSON.parse(theExpression);
 * }, {});
 *
 * // result === {};
 * ```
 */
function safeGet(cb, defValue) {
    var result = defValue;
    try {
        result = cb();
    }
    catch (e) {
        // Do nothing
    }
    return result;
}
//# sourceMappingURL=safe_get.js.map

/***/ }),
/* 16 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_DYN_ASSEMBLY": () => (/* binding */ _DYN_ASSEMBLY),
/* harmony export */   "_DYN_CORRELATION_HEADER_E0": () => (/* binding */ _DYN_CORRELATION_HEADER_E0),
/* harmony export */   "_DYN_COUNT": () => (/* binding */ _DYN_COUNT),
/* harmony export */   "_DYN_DATE": () => (/* binding */ _DYN_DATE),
/* harmony export */   "_DYN_DAYS_OF_MONTH": () => (/* binding */ _DYN_DAYS_OF_MONTH),
/* harmony export */   "_DYN_DISABLED": () => (/* binding */ _DYN_DISABLED),
/* harmony export */   "_DYN_DURATION": () => (/* binding */ _DYN_DURATION),
/* harmony export */   "_DYN_EXCEPTIONS": () => (/* binding */ _DYN_EXCEPTIONS),
/* harmony export */   "_DYN_EXTENSION_CONFIG": () => (/* binding */ _DYN_EXTENSION_CONFIG),
/* harmony export */   "_DYN_FILE_NAME": () => (/* binding */ _DYN_FILE_NAME),
/* harmony export */   "_DYN_GET_UTCDATE": () => (/* binding */ _DYN_GET_UTCDATE),
/* harmony export */   "_DYN_HAS_FULL_STACK": () => (/* binding */ _DYN_HAS_FULL_STACK),
/* harmony export */   "_DYN_INGESTIONENDPOINT": () => (/* binding */ _DYN_INGESTIONENDPOINT),
/* harmony export */   "_DYN_INTERVAL": () => (/* binding */ _DYN_INTERVAL),
/* harmony export */   "_DYN_IS_MANUAL": () => (/* binding */ _DYN_IS_MANUAL),
/* harmony export */   "_DYN_LENGTH": () => (/* binding */ _DYN_LENGTH),
/* harmony export */   "_DYN_LEVEL": () => (/* binding */ _DYN_LEVEL),
/* harmony export */   "_DYN_LINE": () => (/* binding */ _DYN_LINE),
/* harmony export */   "_DYN_MEASUREMENTS": () => (/* binding */ _DYN_MEASUREMENTS),
/* harmony export */   "_DYN_MESSAGE": () => (/* binding */ _DYN_MESSAGE),
/* harmony export */   "_DYN_METHOD": () => (/* binding */ _DYN_METHOD),
/* harmony export */   "_DYN_NAME": () => (/* binding */ _DYN_NAME),
/* harmony export */   "_DYN_PARSED_STACK": () => (/* binding */ _DYN_PARSED_STACK),
/* harmony export */   "_DYN_PATHNAME": () => (/* binding */ _DYN_PATHNAME),
/* harmony export */   "_DYN_PRE_TRIGGER_DATE": () => (/* binding */ _DYN_PRE_TRIGGER_DATE),
/* harmony export */   "_DYN_PROBLEM_GROUP": () => (/* binding */ _DYN_PROBLEM_GROUP),
/* harmony export */   "_DYN_PROPERTIES": () => (/* binding */ _DYN_PROPERTIES),
/* harmony export */   "_DYN_RECEIVED_RESPONSE": () => (/* binding */ _DYN_RECEIVED_RESPONSE),
/* harmony export */   "_DYN_REMOVE_ITEM": () => (/* binding */ _DYN_REMOVE_ITEM),
/* harmony export */   "_DYN_SEVERITY_LEVEL": () => (/* binding */ _DYN_SEVERITY_LEVEL),
/* harmony export */   "_DYN_SIZE_IN_BYTES": () => (/* binding */ _DYN_SIZE_IN_BYTES),
/* harmony export */   "_DYN_SPLIT": () => (/* binding */ _DYN_SPLIT),
/* harmony export */   "_DYN_STRINGIFY": () => (/* binding */ _DYN_STRINGIFY),
/* harmony export */   "_DYN_TO_LOWER_CASE": () => (/* binding */ _DYN_TO_LOWER_CASE),
/* harmony export */   "_DYN_TO_STRING": () => (/* binding */ _DYN_TO_STRING),
/* harmony export */   "_DYN_TYPE_NAME": () => (/* binding */ _DYN_TYPE_NAME),
/* harmony export */   "_DYN__CREATE_FROM_INTERFA1": () => (/* binding */ _DYN__CREATE_FROM_INTERFA1)
/* harmony export */ });
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


// @skip-file-minify
// ##############################################################
// AUTO GENERATED FILE: This file is Auto Generated during build.
// ##############################################################
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Note: DON'T Export these const from the package as we are still targeting ES3 this will export a mutable variables that someone could change!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
var _DYN_SPLIT = "split"; // Count: 6
var _DYN_LENGTH = "length"; // Count: 41
var _DYN_TO_LOWER_CASE = "toLowerCase"; // Count: 6
var _DYN_INGESTIONENDPOINT = "ingestionendpoint"; // Count: 6
var _DYN_TO_STRING = "toString"; // Count: 9
var _DYN_REMOVE_ITEM = "removeItem"; // Count: 3
var _DYN_NAME = "name"; // Count: 11
var _DYN_MESSAGE = "message"; // Count: 10
var _DYN_COUNT = "count"; // Count: 8
var _DYN_PRE_TRIGGER_DATE = "preTriggerDate"; // Count: 4
var _DYN_DISABLED = "disabled"; // Count: 3
var _DYN_INTERVAL = "interval"; // Count: 3
var _DYN_DAYS_OF_MONTH = "daysOfMonth"; // Count: 3
var _DYN_DATE = "date"; // Count: 5
var _DYN_GET_UTCDATE = "getUTCDate"; // Count: 3
var _DYN_STRINGIFY = "stringify"; // Count: 4
var _DYN_PATHNAME = "pathname"; // Count: 4
var _DYN_CORRELATION_HEADER_E0 = "correlationHeaderExcludePatterns"; // Count: 2
var _DYN_EXTENSION_CONFIG = "extensionConfig"; // Count: 4
var _DYN_EXCEPTIONS = "exceptions"; // Count: 6
var _DYN_PARSED_STACK = "parsedStack"; // Count: 13
var _DYN_PROPERTIES = "properties"; // Count: 9
var _DYN_MEASUREMENTS = "measurements"; // Count: 9
var _DYN_SIZE_IN_BYTES = "sizeInBytes"; // Count: 11
var _DYN_TYPE_NAME = "typeName"; // Count: 11
var _DYN_SEVERITY_LEVEL = "severityLevel"; // Count: 5
var _DYN_PROBLEM_GROUP = "problemGroup"; // Count: 3
var _DYN_IS_MANUAL = "isManual"; // Count: 3
var _DYN__CREATE_FROM_INTERFA1 = "CreateFromInterface"; // Count: 2
var _DYN_ASSEMBLY = "assembly"; // Count: 7
var _DYN_FILE_NAME = "fileName"; // Count: 8
var _DYN_HAS_FULL_STACK = "hasFullStack"; // Count: 6
var _DYN_LEVEL = "level"; // Count: 5
var _DYN_METHOD = "method"; // Count: 7
var _DYN_LINE = "line"; // Count: 6
var _DYN_DURATION = "duration"; // Count: 4
var _DYN_RECEIVED_RESPONSE = "receivedResponse"; // Count: 2
//# sourceMappingURL=__DynamicConstants.js.map

/***/ }),
/* 17 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "urlGetAbsoluteUrl": () => (/* binding */ urlGetAbsoluteUrl),
/* harmony export */   "urlGetCompleteUrl": () => (/* binding */ urlGetCompleteUrl),
/* harmony export */   "urlGetPathName": () => (/* binding */ urlGetPathName),
/* harmony export */   "urlParseFullHost": () => (/* binding */ urlParseFullHost),
/* harmony export */   "urlParseHost": () => (/* binding */ urlParseHost),
/* harmony export */   "urlParseUrl": () => (/* binding */ urlParseUrl)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(14);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */




var _document = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.getDocument)() || {};
var _htmlAnchorIdx = 0;
// Use an array of temporary values as it's possible for multiple calls to parseUrl() will be called with different URLs
// Using a cache size of 5 for now as it current depth usage is at least 2, so adding a minor buffer to handle future updates
var _htmlAnchorElement = [null, null, null, null, null];
function urlParseUrl(url) {
    var anchorIdx = _htmlAnchorIdx;
    var anchorCache = _htmlAnchorElement;
    var tempAnchor = anchorCache[anchorIdx];
    if (!_document.createElement) {
        // Always create the temp instance if createElement is not available
        tempAnchor = { host: urlParseHost(url, true) };
    }
    else if (!anchorCache[anchorIdx]) {
        // Create and cache the unattached anchor instance
        tempAnchor = anchorCache[anchorIdx] = _document.createElement("a");
    }
    tempAnchor.href = url;
    // Move the cache index forward
    anchorIdx++;
    if (anchorIdx >= anchorCache[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]) {
        anchorIdx = 0;
    }
    _htmlAnchorIdx = anchorIdx;
    return tempAnchor;
}
function urlGetAbsoluteUrl(url) {
    var result;
    var a = urlParseUrl(url);
    if (a) {
        result = a.href;
    }
    return result;
}
function urlGetPathName(url) {
    var result;
    var a = urlParseUrl(url);
    if (a) {
        result = a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PATHNAME /* @min:%2epathname */];
    }
    return result;
}
function urlGetCompleteUrl(method, absoluteUrl) {
    if (method) {
        return method.toUpperCase() + " " + absoluteUrl;
    }
    return absoluteUrl;
}
// Fallback method to grab host from url if document.createElement method is not available
function urlParseHost(url, inclPort) {
    var fullHost = urlParseFullHost(url, inclPort) || "";
    if (fullHost) {
        var match = fullHost.match(/(www\d{0,5}\.)?([^\/:]{1,256})(:\d{1,20})?/i);
        if (match != null && match[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 3 && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isString)(match[2]) && match[2][_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
            return match[2] + (match[3] || "");
        }
    }
    return fullHost;
}
function urlParseFullHost(url, inclPort) {
    var result = null;
    if (url) {
        var match = url.match(/(\w{1,150}):\/\/([^\/:]{1,256})(:\d{1,20})?/i);
        if (match != null && match[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 2 && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isString)(match[2]) && match[2][_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
            result = match[2] || "";
            if (inclPort && match[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 2) {
                var protocol = (match[1] || "")[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]();
                var port = match[3] || "";
                // IE includes the standard port so pass it off if it's the same as the protocol
                if (protocol === "http" && port === ":80") {
                    port = "";
                }
                else if (protocol === "https" && port === ":443") {
                    port = "";
                }
                result += port;
            }
        }
    }
    return result;
}
//# sourceMappingURL=UrlHelperFuncs.js.map

/***/ }),
/* 18 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getDocument": () => (/* binding */ getDocument),
/* harmony export */   "getGlobal": () => (/* binding */ getGlobal),
/* harmony export */   "getHistory": () => (/* binding */ getHistory),
/* harmony export */   "getInst": () => (/* binding */ getInst),
/* harmony export */   "getNavigator": () => (/* binding */ getNavigator),
/* harmony export */   "getWindow": () => (/* binding */ getWindow),
/* harmony export */   "hasDocument": () => (/* binding */ hasDocument),
/* harmony export */   "hasHistory": () => (/* binding */ hasHistory),
/* harmony export */   "hasNavigator": () => (/* binding */ hasNavigator),
/* harmony export */   "hasWindow": () => (/* binding */ hasWindow),
/* harmony export */   "isNode": () => (/* binding */ isNode),
/* harmony export */   "isWebWorker": () => (/* binding */ isWebWorker),
/* harmony export */   "lazySafeGetInst": () => (/* binding */ lazySafeGetInst)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _internal_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(21);
/* harmony import */ var _safe_lazy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19);
/* harmony import */ var _lazy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */




var WINDOW = "window";
var _cachedGlobal;
var _cachedWindow;
var _cachedDocument;
var _cachedNavigator;
var _cachedHistory;
var _isWebWorker;
var _isNode;
/**
 * Create and return an readonly {@link ILazyValue} instance which will cache and return the named global
 * value if available, will return `null` if the named global object is not available or if the runtime
 * throws an exception when attempting to access the global object.
 * Unlike {@link getInst} the value is cached after the first access, so if the global value changes after
 * the initial fetch the original cached value is still returned.
 * @since 0.9.5
 * @group Environment
 * @group Lazy
 * @group Safe
 * @param name The name of the global object to get.
 * @returns A new readonly {@link ILazyValue} instance which will lazily attempt to return the globally
 * available named instance.
 * @example
 * ```ts
 * // This does not cause the evaluation to occur
 * window.myGlobal = "Hello";
 * let cachedValue = lazySafeGetInst("myGlobal");
 * // cachedValue.v === "Hello"
 *
 * window.myGlobal = "Darkness";
 * // cachedValue.v === "Hello"
 *
 * let promiseCls = lazySafeGetInst("Promise");
 * // null if Promise is not supported in the runtime
 * // otherwise the Promise class.
 * ```
 */
var lazySafeGetInst = function (name) { return (0,_safe_lazy__WEBPACK_IMPORTED_MODULE_0__.safeGetLazy)(function () { return getInst(name) || _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE; }, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE); };
/**
 * Returns the current global scope object, for a normal web page this will be the current
 * window, for a Web Worker this will be current worker global scope via "self". The internal
 * implementation returns the first available instance object in the following order
 * - globalThis (New standard)
 * - self (Will return the current window instance for supported browsers)
 * - window (fallback for older browser implementations)
 * - global (NodeJS standard)
 * - <null> (When all else fails)
 * While the return type is a Window for the normal case, not all environments will support all
 * of the properties or functions. And this caches the lookup of the global as in some environments
 * this can be an expensive operation.
 * @group Environment
 * @param useCached - [Optional] used for testing to bypass the cached lookup, when `true` this will
 * cause the cached global to be reset.
 */
var getGlobal = function (useCached) {
    (!_cachedGlobal || useCached === false || (_lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks && _lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks.lzy && !_cachedGlobal.b)) && (_cachedGlobal = (0,_safe_lazy__WEBPACK_IMPORTED_MODULE_0__.safeGetLazy)(_internal_global__WEBPACK_IMPORTED_MODULE_3__._getGlobalValue, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE));
    return _cachedGlobal.v;
};
/**
 * Return the named global object if available, will return null if the object is not available.
 * @group Environment
 * @param name The globally named object
 * @param useCached - [Optional] used for testing to bypass the cached lookup, when `true` this will
 * cause the cached global to be reset.
 * @example
 * ```ts
 * // This does not cause the evaluation to occur
 * window.myGlobal = "Hello";
 * let cachedValue = getInst("myGlobal");
 * // cachedValue === "Hello"
 *
 * window.myGlobal = "Darkness";
 * // getInst("myGlobal") === "Darkness"
 *
 * let promiseCls = getInst("Promise");
 * // May throw if the global is not supported by the runtime
 * // otherwise the Promise class.
 * ```
 */
var getInst = function (name, useCached) {
    var gbl = (!_cachedGlobal || useCached === false) ? getGlobal(useCached) : _cachedGlobal.v;
    if (gbl && gbl[name]) {
        return gbl[name];
    }
    // Test workaround, for environments where <global>.window (when global == window) doesn't return the base window
    if (name === WINDOW && _cachedWindow) {
        // tslint:disable-next-line: no-angle-bracket-type-assertion
        return _cachedWindow.v;
    }
    return _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE;
};
/**
 * Identify whether the runtime contains a `document` object
 * @group Environment
 * @returns - True if a `document` exists
 */
var hasDocument = function () { return !!getDocument(); };
/**
 * Return the global `document` instance.
 * @group Environment
 * @returns
 */
var getDocument = function () {
    (!_cachedDocument || (_lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks && _lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks.lzy && !_cachedDocument.b)) && (_cachedDocument = lazySafeGetInst("document"));
    return _cachedDocument.v;
};
/**
 * Identify whether the runtime contains a `window` object
 * @group Environment
 * @returns
 */
var hasWindow = function () { return !!getWindow(); };
/**
 * Return the global `window` instance.
 * @group Environment
 * @returns
 */
var getWindow = function () {
    (!_cachedWindow || (_lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks && _lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks.lzy && !_cachedWindow.b)) && (_cachedWindow = lazySafeGetInst(WINDOW));
    return _cachedWindow.v;
};
/**
 * Identify whether the runtimne contains a `navigator` object
 * @group Environment
 * @returns
 */
var hasNavigator = function () { return !!getNavigator(); };
/**
 * Returns the global `navigator` instance
 * @group Environment
 * @returns
 */
var getNavigator = function () {
    (!_cachedNavigator || (_lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks && _lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks.lzy && !_cachedNavigator.b)) && (_cachedNavigator = lazySafeGetInst("navigator"));
    return _cachedNavigator.v;
};
/**
 * Identifies whether the runtime contains a `history` object
 * @group Environment
 * @returns
 */
var hasHistory = function () { return !!getHistory(); };
/**
 * Returns the global `history` instance
 * @group Environment
 * @returns
 */
var getHistory = function () {
    (!_cachedHistory || (_lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks && _lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks.lzy && !_cachedHistory.b)) && (_cachedHistory = lazySafeGetInst("history"));
    return _cachedHistory.v;
};
/**
 * Simple method to determine if we are running in a node environment
 * @group Environment
 * @returns True if you are
 */
var isNode = function () {
    !_isNode && (_isNode = (0,_safe_lazy__WEBPACK_IMPORTED_MODULE_0__.safeGetLazy)(function () { return !!(process && (process.versions || {}).node); }, false));
    return _isNode.v;
};
/**
 * Helper to identify if you are running as a Dedicated, Shared or Service worker
 * @group Environment
 * @returns True if the environment you are in looks like a Web Worker
 */
var isWebWorker = function () {
    !_isWebWorker && (_isWebWorker = (0,_safe_lazy__WEBPACK_IMPORTED_MODULE_0__.safeGetLazy)(function () { return !!(self && self instanceof WorkerGlobalScope); }, false));
    return _isWebWorker.v;
};
//# sourceMappingURL=environment.js.map

/***/ }),
/* 19 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "safeGetLazy": () => (/* binding */ safeGetLazy)
/* harmony export */ });
/* harmony import */ var _lazy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20);
/* harmony import */ var _safe_get__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(15);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * Create and return an readonly {@link ILazyValue} instance which will cache and return the value returned
 * by the callback function. The callback function will only be called once, multiple access of the value
 * does not cause re-execution of the callback as the result from the first call is cached internally.
 * If the callback throws the default value will be returned.
 * @since 0.9.5
 * @group Lazy
 * @group Safe
 * @param cb - The callback function to fetch the value to be lazily evaluated and cached
 * @param defValue - The default value to return when an exception is thrown
 * @returns A new readonly {@link ILazyValue} instance which wraps the callback and will be used to cache
 * the result of the callback
 * @example
 * ```ts
 * // This does not cause the evaluation to occur
 * let cachedValue = safeGetLazy(() => callSomeExpensiveFunctionWhichMightThrow(), "someDefaultValue");
 * let theValue;
 *
 * // Just checking if there is an object still does not cause the evaluation
 * if (cachedValue) {
 *     // This will cause the evaluation to occur and the result will be cached
 *     theValue = cachedValue.v;
 * }
 *
 * // Accessing the value again will not cause the re-evaluation to occur, it will just return the same
 * // result value again.
 * theValue === cachedValue.v;  // true
 *
 * ```
 */
function safeGetLazy(cb, defValue) {
    return (0,_lazy__WEBPACK_IMPORTED_MODULE_0__.getLazy)(function () { return (0,_safe_get__WEBPACK_IMPORTED_MODULE_1__.safeGet)(cb, defValue); });
}
//# sourceMappingURL=safe_lazy.js.map

/***/ }),
/* 20 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_globalLazyTestHooks": () => (/* binding */ _globalLazyTestHooks),
/* harmony export */   "getLazy": () => (/* binding */ getLazy),
/* harmony export */   "getWritableLazy": () => (/* binding */ getWritableLazy),
/* harmony export */   "setBypassLazyCache": () => (/* binding */ setBypassLazyCache)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _internal_global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(21);
/* harmony import */ var _object_define__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */



/**
 * @internal
 * Internal flag which is set by the public {@link setBypassLazyCache}, should not be externally exported
 */
var _globalLazyTestHooks;
var _fetchLazyTestHooks = function () {
    _globalLazyTestHooks = (0,_internal_global__WEBPACK_IMPORTED_MODULE_0__._getGlobalConfig)();
    _fetchLazyTestHooks = _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE;
};
/**
 * Create and return an readonly {@link ILazyValue} instance which will cache and return the value returned
 * by the callback function. The callback function will only be called once, multiple access of the value
 * does not cause re-execution of the callback as the result from the first call is cached internally.
 * @since 0.4.5
 * @group Lazy
 * @param cb - The callback function to fetch the value to be lazily evaluated and cached
 * @returns A new readonly {@link ILazyValue} instance which wraps the callback and will be used to cache
 * the result of the callback
 * @example
 * ```ts
 * // This does not cause the evaluation to occur
 * let cachedValue = getLazy(() => callSomeExpensiveFunction());
 * let theValue;
 *
 * // Just checking if there is an object still does not cause the evaluation
 * if (cachedValue) {
 *     // This will cause the evaluation to occur and the result will be cached
 *     theValue = cachedValue.v;
 * }
 *
 * // Accessing the value again will not cause the re-evaluation to occur, it will just return the same
 * // result value again.
 * theValue === cachedValue.v;  // true
 *
 * ```
 */
function getLazy(cb) {
    var lazyValue = {};
    _fetchLazyTestHooks && _fetchLazyTestHooks();
    lazyValue.b = _globalLazyTestHooks.lzy;
    (0,_object_define__WEBPACK_IMPORTED_MODULE_2__.objDefineProp)(lazyValue, "v", {
        configurable: true,
        get: function () {
            var result = cb();
            if (!_globalLazyTestHooks.lzy) {
                // Just replace the value
                (0,_object_define__WEBPACK_IMPORTED_MODULE_2__.objDefineProp)(lazyValue, "v", {
                    value: result
                });
                if (lazyValue.b) {
                    delete lazyValue.b;
                }
            }
            if (_globalLazyTestHooks.lzy && lazyValue.b !== _globalLazyTestHooks.lzy) {
                lazyValue.b = _globalLazyTestHooks.lzy;
            }
            return result;
        }
    });
    return lazyValue;
}
/**
 * Test Hook function used to cause the internal caching of objects to be bypassed, this should never
 * be enabled for production as it has additional performance impact caused by the repetitive creation
 * of the lazy wrappers.
 * @group Lazy
 * @since 0.5.0
 * @param newValue - When `true` will cause all new lazy implementations to bypass the cached lookup.
 */
function setBypassLazyCache(newValue) {
    _fetchLazyTestHooks && _fetchLazyTestHooks();
    _globalLazyTestHooks.lzy = newValue;
}
/**
 * Create and return a writable {@link ILazyValue} instance which will cache and return the value returned
 * by the callback function. The callback function will only be called once, multiple access of the value
 * does not cause re-execution of the callback as the result from the first call is cached internally. The
 * value may be set as many times as required, if the callback has not been called when you set the value
 * it will never get called.
 * @since 0.9.4
 * @group Lazy
 * @param cb - The callback function to fetch the value to be lazily evaluated and cached
 * @returns A new writable {@link ILazyValue} instance which wraps the callback and will be used to cache
 * the result of the callback
 * @example
 * ```ts
 * // This does not cause the evaluation to occur
 * let cachedValue = getWritableLazy(() => callSomeExpensiveFunction());
 * let theValue;
 *
 * // Just checking if there is an object still does not cause the evaluation
 * if (cachedValue) {
 *     // This will cause the evaluation to occur and the result will be cached
 *     theValue = cachedValue.v;
 * }
 *
 * // Accessing the value again will not cause the re-evaluation to occur, it will just return the same
 * // result value again.
 * theValue === cachedValue.v;  // true
 *
 * // Setting the value
 * let cachedValue = getWritableLazy(() => callSomeExpensiveFunction());
 * let theValue = "new Value";
 *
 * // Just checking if there is an object still does not cause the evaluation
 * if (cachedValue) {
 *     // This will set the value to be set explicitly and the callback
 *     // will now never occur and the result will be cached
 *     cachedValue.v = theValue;
 * }
 *
 * // Accessing the value again will cause the previously set value to be returned.
 * theValue === cachedValue.v;  // true
 * ```
 */
function getWritableLazy(cb) {
    var lazyValue = {};
    _fetchLazyTestHooks && _fetchLazyTestHooks();
    lazyValue.b = _globalLazyTestHooks.lzy;
    var _setValue = function (newValue) {
        // Just replace the value
        (0,_object_define__WEBPACK_IMPORTED_MODULE_2__.objDefineProp)(lazyValue, "v", {
            value: newValue,
            writable: true
        });
        if (lazyValue.b) {
            delete lazyValue.b;
        }
    };
    (0,_object_define__WEBPACK_IMPORTED_MODULE_2__.objDefineProp)(lazyValue, "v", {
        configurable: true,
        get: function () {
            var result = cb();
            if (!_globalLazyTestHooks.lzy) {
                // Just replace the value
                _setValue(result);
            }
            if (_globalLazyTestHooks.lzy && lazyValue.b !== _globalLazyTestHooks.lzy) {
                lazyValue.b = _globalLazyTestHooks.lzy;
            }
            return result;
        },
        set: _setValue
    });
    return lazyValue;
}
//# sourceMappingURL=lazy.js.map

/***/ }),
/* 21 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_getGlobalConfig": () => (/* binding */ _getGlobalConfig),
/* harmony export */   "_getGlobalValue": () => (/* binding */ _getGlobalValue)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

var GLOBAL_CONFIG_KEY = "__tsUtils$gblCfg";
var _globalCfg;
/**
 * @internal
 * @ignore
 * Helper to get the current global value
 * @returns
 */
function _getGlobalValue() {
    var result;
    if (typeof globalThis !== _constants__WEBPACK_IMPORTED_MODULE_0__.UNDEFINED) {
        result = globalThis;
    }
    if (!result && typeof self !== _constants__WEBPACK_IMPORTED_MODULE_0__.UNDEFINED) {
        result = self;
    }
    if (!result && typeof window !== _constants__WEBPACK_IMPORTED_MODULE_0__.UNDEFINED) {
        result = window;
    }
    if (!result && typeof __webpack_require__.g !== _constants__WEBPACK_IMPORTED_MODULE_0__.UNDEFINED) {
        result = __webpack_require__.g;
    }
    return result;
}
/**
 * @internal
 * @ignore
 * Gets/Sets the named value from the global config store, this is used to share configuration across
 * multiple modules. Primarily used for poly symbol and test hooks.
 * @returns The globally registered value.
 */
function _getGlobalConfig() {
    if (!_globalCfg) {
        var gbl = _getGlobalValue() || {};
        _globalCfg = gbl[GLOBAL_CONFIG_KEY] = gbl[GLOBAL_CONFIG_KEY] || {};
    }
    return _globalCfg;
}
//# sourceMappingURL=global.js.map

/***/ }),
/* 22 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "objDefine": () => (/* binding */ objDefine),
/* harmony export */   "objDefineAccessors": () => (/* binding */ objDefineAccessors),
/* harmony export */   "objDefineGet": () => (/* binding */ objDefineGet),
/* harmony export */   "objDefineProp": () => (/* binding */ objDefineProp),
/* harmony export */   "objDefineProperties": () => (/* binding */ objDefineProperties),
/* harmony export */   "objDefineProps": () => (/* binding */ objDefineProps)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14);
/* harmony import */ var _for_each_key__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24);
/* harmony import */ var _get_own_prop_desc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */




/**
 * @internal
 * @ignore
 * Mapping from ObjDefinePropDescriptor key to PropertyDescriptor key
 */
var propMap = {
    e: "enumerable",
    c: "configurable",
    v: _internal_constants__WEBPACK_IMPORTED_MODULE_0__.VALUE,
    w: "writable",
    g: "get",
    s: "set"
};
/**
 * @internal
 * @ignore
 * Helper to convert ObjDefinePropDescriptor into PropertyDescriptor
 * @param value - The prop descriptor to convert
 * @returns
 */
function _createProp(value) {
    var prop = {};
    prop[propMap["c"]] = true;
    prop[propMap["e"]] = true;
    if (value.l) {
        // Asign a getter function to return the value when requested
        prop.get = function () { return value.l.v; };
        // If it has a setter then expose it as well
        var desc = (0,_get_own_prop_desc__WEBPACK_IMPORTED_MODULE_1__.objGetOwnPropertyDescriptor)(value.l, "v");
        if (desc && desc.set) {
            prop.set = function (newValue) {
                value.l.v = newValue;
            };
        }
    }
    (0,_for_each_key__WEBPACK_IMPORTED_MODULE_2__.objForEachKey)(value, function (key, value) {
        prop[propMap[key]] = (0,_helpers_base__WEBPACK_IMPORTED_MODULE_3__.isUndefined)(value) ? prop[propMap[key]] : value;
    });
    return prop;
}
/**
 * Defines a new property directly on an object, or modifies an existing property on an object, and returns the object.
 * This is a wrapper for [Object.defineProperty](https://developer.mozilla.org/en-US/docs/web/javascript/reference/global_objects/object/defineproperty)
 *
 * This method allows a precise addition to or modification of a property on an object. Normal property addition through
 * assignment creates properties which show up during property enumeration (for...in loop or objKeys method), whose
 * values may be changed, and which may be deleted. This method allows these extra details to be changed from their
 * defaults. By default, properties added using objDefineProp() are not writable, not enumerable, and not configurable.
 *
 * Property descriptors present in objects come in two main flavors: data descriptors and accessor descriptors. A data
 * descriptor is a property that has a value, which may or may not be writable. An accessor descriptor is a property
 * described by a getter-setter pair of functions. A descriptor must be one of these two flavors; it cannot be both.
 *
 * This is an alias for Object.defineProperty
 * @group Object
 * @param target - The object on which to define the property.
 * @param key - The name or Symbol of the property to be defined or modified.
 * @param descriptor - The descriptor for the property being defined or modified.
 */
var objDefineProp = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.defineProperty;
/**
 * The objDefineProperties() method defines new or modifies existing properties directly on an object, returning the object.
 * This is a wrapper for [Object.defineProperties](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/defineProperties)
 * @since 0.6.0
 * @group Object
 * @param target - The object on which to define or modify properties.
 * @param props - An object whose keys represent the names of properties to be defined or modified and whose values are
 * objects describing those properties. Each value in props must be either a data descriptor or an accessor descriptor;
 * it cannot be both (see {@link ObjDefinePropDescriptorMap} for more details).
 * @returns
 */
var objDefineProperties = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.defineProperties;
/**
 * Try to define a get object property accessor for the target object, if a function is past as the value this will
 * be assumed to be a getter function and NOT the value.
 * @deprecated It is recommended that you use {@link objDefine} instead {@link objDefineGet} or {@link objDefineAccessors}
 * as it provides a deterministic way for identifying whether the value is a value or a function rather than wrapping any
 * function value in another function.
 * @group Object
 * @param target - The object on which to define the property.
 * @param key - The name of the property to be defined or modified
 * @param value - The value or a function that returns the value
 * @param configurable - Can the value be changed, defaults to true.
 * @param enumerable - Should this get property be enumerable, defaults to true.
 * @returns The object that was passed to the function
 */
function objDefineGet(target, key, value, configurable, enumerable) {
    var _a;
    return objDefineProp(target, key, _createProp((_a = {
            e: enumerable,
            c: configurable
        },
        _a[(0,_helpers_base__WEBPACK_IMPORTED_MODULE_3__.isFunction)(value) ? "g" : "v"] = value,
        _a)));
}
/**
 * Try to define get/set object property accessors for the target object/prototype, this will provide compatibility with
 * existing API definition when run within an ES5+ container that supports accessors but still enable the code to be loaded
 * and executed in an ES3 container, providing basic IE8 compatibility.
 * @deprecated It is recommended that you use {@link objDefine} instead {@link objDefineAccessors} as this internally creates
 * the {@link ObjDefinePropDescriptor} definition based on your provided arguments. And only using a minimum set of functions
 * reduces your overall bundle size.
 * @group Object
 * @param target - The object on which to define the property.
 * @param prop - The name of the property to be defined or modified.
 * @param getProp - The getter function to wire against the getter.
 * @param setProp - The setter function to wire against the setter.
 * @param configurable - Can the value be changed, defaults to true
 * @param enumerable - Should this get property be enumerable, defaults to true.
 * @returns The object that was passed to the function
 */
function objDefineAccessors(target, prop, getProp, setProp, configurable, enumerable) {
    var desc = {
        e: enumerable,
        c: configurable
    };
    if (getProp) {
        desc.g = getProp;
    }
    if (setProp) {
        desc.s = setProp;
    }
    return objDefineProp(target, prop, _createProp(desc));
}
/**
 * The objDefine() method defines a new or modifies an existing single property accessors for the target object based
 * on the configuration defined for the propDesc argument of type {@link ObjDefinePropDescriptor}. This will call
 * {@link objDefineProp} after creating the required PropertyDescriptor populating defaults for the propDesc values.
 * Note, the default values (true) for `configurable` and `enumerable` are different from the defaults provided by objDefineProp.
 * @since 0.6.0
 * @group Object
 * @param target - The object on which to define the property.
 * @param key - The name of the property to be defined or modified
 * @param propDesc - An object which defines the Property Descriptor mappings for the mapping.
 * @returns The target object.
 */
function objDefine(target, key, propDesc) {
    return objDefineProp(target, key, _createProp(propDesc));
}
/**
 * The objDefineProps() method defines new or modifies existing properties directly for the target object using the keys
 * and configuration from the propDescMap argument. This will call {@link objDefineProperties} after creating the required
 * PropertyDescriptorMap from the propDescMap values.
 * Note, the default values (true) for `configurable` and `enumerable` are different from the defaults provided by objDefineProperties.
 * @since 0.6.0
 * @group Object
 * @param target - The object on which to define or modify properties.
 * @param propDescMap - An object whose keys represent the names of properties to be defined or modified and whose values are
 * objects describing those properties. Each value in props must be either a data descriptor or an accessor descriptor;
 * it cannot be both (see {@link ObjDefinePropDescriptorMap} for more details).
 * @returns The target object.
 */
function objDefineProps(target, propDescMap) {
    var props = {};
    (0,_for_each_key__WEBPACK_IMPORTED_MODULE_2__.objForEachKey)(propDescMap, function (key, value) {
        props[key] = _createProp(value);
    });
    return objDefineProperties(target, props);
}
//# sourceMappingURL=define.js.map

/***/ }),
/* 23 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "objGetOwnPropertyDescriptor": () => (/* binding */ objGetOwnPropertyDescriptor)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

/**
 * The objGetOwnPropertyDescriptor() method returns an object describing the configuration of a specific property on
 * a given object (that is, one directly present on an object and not in the object's prototype chain). The object
 * returned is mutable but mutating it has no effect on the original property's configuration.
 * @since 0.4.3
 * @group Object
 * @param target - Object that contains the property.
 * @param prop - Name of the property.
 * @returns A property descriptor of the given property if it exists on the object, otherwise undefined.
 *
 * @example
 * ```ts
 * o = {};
 * objDefineProp(o, 'qux', {
 *   value: 8675309,
 *   writable: false,
 *   enumerable: false
 * });
 * d = objGetOwnPropertyDescriptor(o, 'qux');
 * // d is {
 * //   value: 8675309,
 * //   writable: false,
 * //   enumerable: false,
 * //   configurable: false
 * // }
 *
 * objGetOwnPropertyDescriptor('foo', 0);
 * // TypeError: "foo" is not an object  // ES5 code
 *
 * objGetOwnPropertyDescriptor('foo', 0);
 * // Object returned by ES2015 code: {
 * //   configurable: false,
 * //   enumerable: true,
 * //   value: "f",
 * //   writable: false
 * // }
 * ```
 * Note: In ES5, if the first argument to this method is not an object (a primitive), then it will cause a TypeError. In ES2015, a non-object first argument will be coerced to an object at first.
 */
var objGetOwnPropertyDescriptor = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.getOwnPropertyDescriptor;
//# sourceMappingURL=get_own_prop_desc.js.map

/***/ }),
/* 24 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "objForEachKey": () => (/* binding */ objForEachKey)
/* harmony export */ });
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14);
/* harmony import */ var _has_own__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * Calls the provided `callbackFn` function once for each key in an object. This is equivelent to `arrForEach(Object.keys(theObject), callbackFn)` or
 * if not using the array helper `Object.keys(theObject).forEach(callbackFn)` except that this helper avoid creating a temporary of the object
 * keys before iterating over them and like the `arrForEach` helper you CAN stop or break the iteration by returning -1 from the `callbackFn` function.
 * @group Object
 * @typeParam T - The object type
 * @param callbackfn  A function that accepts up to two arguments, the key name and the current value of the property represented by the key.
 * @param thisArg  [Optional] An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, null or undefined
 * the object will be used as the this value.
 * @example
 * ```ts
 * function performAction<T>(target: T, source: any) {
 *    if (!isNullOrUndefined(source)) {
 *        objForEachKey(source, (key, value) => {
 *            // Set the target with a reference to the same value with the same name
 *            target[key] = value;
 *        });
 *    }
 *
 *    return target;
 * }
 * ```
 */
function objForEachKey(theObject, callbackfn, thisArg) {
    if (theObject && (0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isObject)(theObject)) {
        for (var prop in theObject) {
            if ((0,_has_own__WEBPACK_IMPORTED_MODULE_1__.objHasOwn)(theObject, prop)) {
                if (callbackfn.call(thisArg || theObject, prop, theObject[prop]) === -1) {
                    break;
                }
            }
        }
    }
}
//# sourceMappingURL=for_each_key.js.map

/***/ }),
/* 25 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "objHasOwn": () => (/* binding */ objHasOwn),
/* harmony export */   "polyObjHasOwn": () => (/* binding */ polyObjHasOwn)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/* harmony import */ var _get_own_prop_desc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(23);
/* harmony import */ var _has_own_prop__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */



/**
 * The objHasOwn() method returns a boolean indicating whether the object
 * has the specified property as its own property (as opposed to inheriting it).
 * If the property is inherited, or does not exist, the method returns false.
 *
 * The objHasOwn() method returns true if the specified property is a direct property
 * of the object — even if the property value is null or undefined. The method returns
 * false if the property is inherited, or has not been declared at all. Unlike the in operator,
 * this method does not check for the specified property in the object's prototype chain.
 *
 * It is recommended over {@link objHasOwnProperty} () because it works for objects created using
 * objCreate(null) and with objects that have overridden the inherited hasOwnProperty() method.
 * While it is possible to workaround these problems by calling Object.prototype.hasOwnProperty()
 * on an external object, Object.hasOwn() is more intuitive.
 *
 * @since 0.4.3
 * @group Object
 * @param obj - The object being evaluated
 * @param prop - The String or Symbol of the property to test
 * @returns `true` if the object has the specified property as own property; otherwise `false`
 * @example
 * ```ts
 * let example = {};
 * objHasOwn(example, 'prop');   // false
 *
 * example.prop = 'exists';
 * objHasOwn(example, 'prop');   // true - 'prop' has been defined
 *
 * example.prop = null;
 * objHasOwn(example, 'prop');   // true - own property exists with value of null
 *
 * example.prop = undefined;
 * objHasOwn(example, 'prop');   // true - own property exists with value of undefined
 * ```
 */
var objHasOwn = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.hasOwn || polyObjHasOwn;
/**
 * The polyObjHasOwn() method is a polyfill for {@link objHasOwn} when the native
 * [Object.hasOwnreturns](https://caniuse.com/?search=hasOwn) is not supported, it returns a
 * boolean indicating whether the object has the specified property as its own property (as
 * opposed to inheriting it). If the property is inherited, or does not exist, the method
 * returns false.
 *
 * The objHasOwn() method returns true if the specified property is a direct property
 * of the object — even if the property value is null or undefined. The method returns
 * false if the property is inherited, or has not been declared at all. Unlike the in operator,
 * this method does not check for the specified property in the object's prototype chain.
 *
 * It is recommended over objHasOwnProperty() because it works for objects created using
 * objCreate(null) and with objects that have overridden the inherited hasOwnProperty() method.
 * While it is possible to workaround these problems by calling Object.prototype.hasOwnProperty()
 * on an external object, Object.hasOwn() is more intuitive.
 *
 * @since 0.4.3
 * @group Object
 * @group Polyfill
 * @param obj - The object being evaluated
 * @param prop - The String or Symbol of the property to test
 * @returns `true` if the object has the specified property as own property; otherwise `false`
 * @example
 * ```ts
 * let example = {};
 * polyObjHasOwn(example, 'prop');   // false
 *
 * example.prop = 'exists';
 * polyObjHasOwn(example, 'prop');   // true - 'prop' has been defined
 *
 * example.prop = null;
 * polyObjHasOwn(example, 'prop');   // true - own property exists with value of null
 *
 * example.prop = undefined;
 * polyObjHasOwn(example, 'prop');   // true - own property exists with value of undefined
 * ```
 */
function polyObjHasOwn(obj, prop) {
    return (0,_has_own_prop__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(obj, prop) || !!(0,_get_own_prop_desc__WEBPACK_IMPORTED_MODULE_2__.objGetOwnPropertyDescriptor)(obj, prop);
}
//# sourceMappingURL=has_own.js.map

/***/ }),
/* 26 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "objHasOwnProperty": () => (/* binding */ objHasOwnProperty)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

/**
 * The objHasOwnProperty() method returns a boolean indicating whether the object
 * has the specified property as its own property (as opposed to inheriting it).
 *
 * The objHasOwnProperty() method returns true if the specified property is a direct
 * property of the object — even if the value is null or undefined. The method returns
 * false if the property is inherited, or has not been declared at all. Unlike the in
 * operator, this method does not check for the specified property in the object's
 * prototype chain.
 *
 * The method can be called on most JavaScript objects, because most objects descend
 * from Object, and hence inherit its methods. For example Array is an Object, so you
 * can use objHasOwnProperty() method to check whether an index exists:
 * @group Object
 * @param obj - The object being evaluated
 * @param prop - The String or Symbol of the property to test
 * @returns `true` if the object has the specified property as own property; otherwise `false`
 * @example
 * ```ts
 * let example = {};
 * objHasOwnProperty(example, 'prop');   // false
 *
 * example.prop = 'exists';
 * objHasOwnProperty(example, 'prop');   // true - 'prop' has been defined
 *
 * example.prop = null;
 * objHasOwnProperty(example, 'prop');   // true - own property exists with value of null
 *
 * example.prop = undefined;
 * objHasOwnProperty(example, 'prop');   // true - own property exists with value of undefined
 * ```
 */
function objHasOwnProperty(obj, prop) {
    return obj && _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjProto.hasOwnProperty.call(obj, prop);
}
//# sourceMappingURL=has_own_prop.js.map

/***/ }),
/* 27 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "strIndexOf": () => (/* binding */ strIndexOf),
/* harmony export */   "strLastIndexOf": () => (/* binding */ strLastIndexOf)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * The `strIndexOf()` method, given two arguments: the string and a substring to search for, searches
 * the entire calling string, and returns the index of the first occurrence of the specified substring.
 * Given a thrid argument: a number, the method returns the first occurrence of the specified substring
 * at an index greater than or equal to the specified number.
 * @group String
 * @param value - The value to be checked for the seeach string
 * @param searchString - The substring to search for in the value
 * @param position - The starting position to search from
 * @example
 * ```ts
 * strIndexOf('hello world', '') // returns 0
 * strIndexOf('hello world', '', 0) // returns 0
 * strIndexOf('hello world', '', 3) // returns 3
 * strIndexOf('hello world', '', 8) // returns 8
 *
 * // However, if the thrid argument is greater than the length of the string
 * strIndexOf('hello world', '', 11) // returns 11
 * strIndexOf('hello world', '', 13) // returns 11
 * strIndexOf('hello world', '', 22) // returns 11
 *
 * strIndexOf('Blue Whale', 'Blue')      // returns  0
 * strIndexOf('Blue Whale', 'Blute')     // returns -1
 * strIndexOf('Blue Whale', 'Whale', 0)  // returns  5
 * strIndexOf('Blue Whale', 'Whale', 5)  // returns  5
 * strIndexOf('Blue Whale', 'Whale', 7)  // returns -1
 * strIndexOf('Blue Whale', '')          // returns  0
 * strIndexOf('Blue Whale', '', 9)       // returns  9
 * strIndexOf('Blue Whale', '', 10)      // returns 10
 * strIndexOf('Blue Whale', '', 11)      // returns 10
 * ```
 */
var strIndexOf = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunction)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.INDEX_OF, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto);
/**
 * The `strLastIndexOf()` method, given two arguments: the string and a substring to search for, searches
 * the entire calling string, and returns the index of the last occurrence of the specified substring.
 * Given a third argument: a number, the method returns the last occurrence of the specified substring
 * at an index less than or equal to the specified number.
 * @group String
 * @param value - The value to be checked for the seeach string
 * @param searchString - The substring to search for in the value
 * @param position - The starting position to search from
 * @example
 * ```ts
 * strLastIndexOf('canal', 'a');     // returns 3
 * strLastIndexOf('canal', 'a', 2);  // returns 1
 * strLastIndexOf('canal', 'a', 0);  // returns -1
 * strLastIndexOf('canal', 'x');     // returns -1
 * strLastIndexOf('canal', 'c', -5); // returns 0
 * strLastIndexOf('canal', 'c', 0);  // returns 0
 * strLastIndexOf('canal', '');      // returns 5
 * strLastIndexOf('canal', '', 2);   // returns 2
 * ```
 */
var strLastIndexOf = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunction)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.LAST_INDEX_OF, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto);
//# sourceMappingURL=index_of.js.map

/***/ }),
/* 28 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "arrForEach": () => (/* binding */ arrForEach)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

/**
 * Calls the provided `callbackFn` function once for each element in an array in ascending index order. It is not invoked for index properties
 * that have been deleted or are uninitialized. And unlike the ES6 forEach() you CAN stop or break the iteration by returning -1 from the
 * `callbackFn` function.
 *
 * The range (number of elements) processed by arrForEach() is set before the first call to the `callbackFn`. Any elements added beyond the range
 * or elements which as assigned to indexes already processed will not be visited by the `callbackFn`.
 * @group Array
 * @group ArrayLike
 * @typeParam T - Identifies the element type of the array
 * @param theArray - The array or array like object of elements to be searched.
 * @param callbackfn A `synchronous` function that accepts up to three arguments. arrForEach calls the callbackfn function one time for each element in the array.
 * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, null or undefined
 * the array will be used as the this value.
 * @remarks
 * arrForEach expects a `synchronous` function.
 * arrForEach does not wait for promises. Make sure you are aware of the implications while using promises (or async functions) as forEach callback.
 * @example
 * ```ts
 * const items = ['item1', 'item2', 'item3'];
 * const copyItems = [];
 *
 * // before using for loop
 * for (let i = 0; i < items.length; i++) {
 *   copyItems.push(items[i]);
 * }
 *
 * // before using forEach()
 * items.forEach((item) => {
 *   copyItems.push(item);
 * });
 *
 * // after
 * arrForEach(items, (item) => {
 *   copyItems.push(item);
 *   // May return -1 to abort the iteration
 * });
 *
 * // Also supports input as an array like object
 * const items = { length: 3, 0: 'item1', 1: 'item2', 2: 'item3' };
 * ```
 */
function arrForEach(theArray, callbackfn, thisArg) {
    if (theArray) {
        var len = theArray[_internal_constants__WEBPACK_IMPORTED_MODULE_0__.LENGTH] >>> 0;
        for (var idx = 0; idx < len; idx++) {
            if (idx in theArray) {
                if (callbackfn.call(thisArg || theArray, theArray[idx], idx, theArray) === -1) {
                    break;
                }
            }
        }
    }
}
//# sourceMappingURL=forEach.js.map

/***/ }),
/* 29 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RequestHeaders": () => (/* binding */ RequestHeaders)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(30);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */



var RequestHeaders = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.createValueMap)({
    requestContextHeader: [0 /* eRequestHeaders.requestContextHeader */, "Request-Context"],
    requestContextTargetKey: [1 /* eRequestHeaders.requestContextTargetKey */, "appId"],
    requestContextAppIdFormat: [2 /* eRequestHeaders.requestContextAppIdFormat */, "appId=cid-v1:"],
    requestIdHeader: [3 /* eRequestHeaders.requestIdHeader */, "Request-Id"],
    traceParentHeader: [4 /* eRequestHeaders.traceParentHeader */, "traceparent"],
    traceStateHeader: [5 /* eRequestHeaders.traceStateHeader */, "tracestate"],
    sdkContextHeader: [6 /* eRequestHeaders.sdkContextHeader */, "Sdk-Context"],
    sdkContextHeaderAppIdRequest: [7 /* eRequestHeaders.sdkContextHeaderAppIdRequest */, "appId"],
    requestContextHeaderLowerCase: [8 /* eRequestHeaders.requestContextHeaderLowerCase */, "request-context"]
});
//# sourceMappingURL=RequestResponseHeaders.js.map

/***/ }),
/* 30 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createEnumStyle": () => (/* binding */ createEnumStyle),
/* harmony export */   "createValueMap": () => (/* binding */ createValueMap)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */



/**
 * Create an enum style object which has both the key => value and value => key mappings
 * @param values - The values to populate on the new object
 * @returns
 */
var createEnumStyle = _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.createEnum;
/**
 * Create a 2 index map that maps an enum's key and value to the defined map value, X["key"] => mapValue and X[0] => mapValue.
 * Generic values
 * - E = the const enum type (typeof eRequestHeaders);
 * - V = Identifies the valid values for the keys, this should include both the enum numeric and string key of the type. The
 * resulting "Value" of each entry identifies the valid values withing the assignments.
 * @param values - The values to populate on the new object
 * @returns
 */
var createValueMap = _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.createTypeMap;
//# sourceMappingURL=EnumHelperFuncs.js.map

/***/ }),
/* 31 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createEnum": () => (/* binding */ createEnum),
/* harmony export */   "createEnumKeyMap": () => (/* binding */ createEnumKeyMap),
/* harmony export */   "createEnumValueMap": () => (/* binding */ createEnumValueMap),
/* harmony export */   "createSimpleMap": () => (/* binding */ createSimpleMap),
/* harmony export */   "createTypeMap": () => (/* binding */ createTypeMap)
/* harmony export */ });
/* harmony import */ var _internal_map__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(32);
/* harmony import */ var _object_for_each_key__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24);
/* harmony import */ var _object_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */



/**
 * Create a TypeScript style enum class which is a mapping that maps from the key -> value and the value -> key.
 * This is effectively the same as defining a non-constant enum, but this only repeats the "Name" of the enum value once.
 * @group Enum
 * @example
 * ```ts
 * const enum Animal {
 *    Dog = 0,
 *    Cat = 1,
 *    Butterfly = 2,
 *    Bear = 3
 * }
 * const Animals = createEnum<typeof Animal>({
 *    Dog: Animal.Dog,
 *    Cat: Animal.Cat,
 *    Butterfly: Animal.Butterfly,
 *    Bear: Animal.Bear
 * });
 * // You end up with an object that maps everything to the name
 * Animals.Dog === 0;           // true
 * Animals[0] === "Dog";        // true
 * Animals["Dog"] === 0;        // true
 * Animals.Cat === 1;           // true
 * Animals[1] === "Cat";        // true
 * Animals["Cat"] === 1;        // true
 * ```

 * @param values - The values to populate on the new object
 * @typeParam E - Identifies the const enum type being mapped
 * @returns A new frozen (immutable) object which looks and acts like a TypeScript Enum class.
 */
function createEnum(values) {
    return (0,_internal_map__WEBPACK_IMPORTED_MODULE_0__._createKeyValueMap)(values, 1 /* eMapValues.Value */, 0 /* eMapValues.Key */, _object_object__WEBPACK_IMPORTED_MODULE_1__.objDeepFreeze);
}
/**
 * Create a map object which contains both the property key and value which both map to the key,
 * E[key] => key and E[value] => key.
 * @group Enum
 * @example
 * ```ts
 * const enum Animal {
 *    Dog = 0,
 *    Cat = 1,
 *    Butterfly = 2,
 *    Bear = 3
 * }
 * const animalMap = createEnumKeyMap<typeof Animal>({
 *    Dog: Animal.Dog,
 *    Cat: Animal.Cat,
 *    Butterfly: Animal.Butterfly,
 *    Bear: Animal.Bear
 * });
 * // You end up with an object that maps everything to the name
 * animalMap.Dog === "Dog";         // true
 * animalMap[0] === "Dog";          // true
 * animalMap["Dog"] === "Dog";      // true
 * animalMap.Cat === "Cat";         // true
 * animalMap[1] === "Cat";          // true
 * animalMap["Cat"] === "Cat";      // true
 * // Helper function to always return the "Name" of the type of animal
 * function getAnimalType(type: string | number | Animal) {
 *     return animalMap[type];
 * }
 * ```
 * @param values - The values to populate on the new object
 * @typeParam E - Identifies the const enum type being mapped
 * @returns A new frozen (immutable) object which contains a property for each key and value that returns the value.
 */
function createEnumKeyMap(values) {
    return (0,_internal_map__WEBPACK_IMPORTED_MODULE_0__._createKeyValueMap)(values, 0 /* eMapValues.Key */, 0 /* eMapValues.Key */, _object_object__WEBPACK_IMPORTED_MODULE_1__.objDeepFreeze);
}
/**
 * Create a map object which contains both the perperty key and value which both map to the resulting value,
 * E[key] => value and E[value] => value.
 * @group Enum
 * @example
 * ```ts
 * const enum Animal {
 *    Dog = 0,
 *    Cat = 1,
 *    Butterfly = 2,
 *    Bear = 3
 * }
 * const animalMap = createEnumValueMap<typeof Animal>({
 *    Dog: Animal.Dog,
 *    Cat: Animal.Cat,
 *    Butterfly: Animal.Butterfly,
 *    Bear: Animal.Bear
 * });
 * // You end up with an object that maps everything to the name
 * animalMap.Dog === 0;     // true
 * animalMap[0] === 0;      // true
 * animalMap["Dog"] === 0;  // true
 * animalMap.Cat === 1;     // true
 * animalMap[1] === 1;      // true
 * animalMap["Cat"] === 1;  // true
 *
 * // Helper function to always return the "Name" of the type of animal
 * function getAnimalValue(type: string | number | Animal) {
 *     return animalMap[type];
 * }
 * ```

 * @param values - The values to populate on the new object
 * @typeParam E - Identifies the const enum type being mapped
 * @returns A new frozen (immutable) object which contains a property for each key and value that returns the value.
 */
function createEnumValueMap(values) {
    return (0,_internal_map__WEBPACK_IMPORTED_MODULE_0__._createKeyValueMap)(values, 1 /* eMapValues.Value */, 1 /* eMapValues.Value */, _object_object__WEBPACK_IMPORTED_MODULE_1__.objDeepFreeze);
}
/**
 * Create a map object which contains both the perperty key and value which both map to the requested
 * generic mapValue with a type of V, E[key] => mapValue and E[value] => mapValue.
 * @group Enum
 * @example
 * ```ts
 * const enum Animal {
 *    Dog = 0,
 *    Cat = 1,
 *    Butterfly = 2,
 *    Bear = 3
 * };
 * // Creates a simple mapping to a string value
 * const animalFamilyMap = createValueMap<typeof Animal, string>({
 *    Dog: [ Animal.Dog, "Canidae"],
 *    Cat: [ Animal.Cat, "Felidae"],
 *    Butterfly: [ Animal.Butterfly, "Papilionidae"],
 *    Bear: [ Animal.Bear, "Ursidae"]
 * });
 * // You end up with an object that maps everything to the name
 * animalMap.Dog === "Canidae";     // true with typeof animalMap.Dog is "string"
 * animalMap[0] === "Canidae";      // true with typeof animalMap[0] is "string"
 * animalMap["Dog"] === "Canidae";  // true with typeof animalMap["Dog"] is "string"
 * animalMap.Cat === "Felidae";     // true with typeof animalMap.Cat is "string"
 * animalMap[1] === "Felidae";      // true with typeof animalMap[1] is "string"
 * animalMap["Cat"] === "Felidae";  // true with typeof animalMap["Cat"] is "string"
 * ```
 * @param values - The values to populate on the new object
 * @typeParam E - Identifies the const enum type (eg. typeof Animal);
 * @typeParam V - Identifies the type of the mapping `string`; `number`; etc is not restructed to primitive types.
 * @returns A new frozen (immutable) object which contains a property for each key and value that returns the defiend mapped value.
 */
function createSimpleMap(values) {
    var mapClass = {};
    (0,_object_for_each_key__WEBPACK_IMPORTED_MODULE_2__.objForEachKey)(values, function (key, value) {
        mapClass[key] = value[1];
        mapClass[value[0]] = value[1];
    });
    return (0,_object_object__WEBPACK_IMPORTED_MODULE_1__.objDeepFreeze)(mapClass);
}
/**
 * Create a strongly types map object which contains both the perperty key and value which both map
 * to the requested mapValue,
 * E[key] => mapValue and E[value] => mapValue.
 * - E = the const enum type (typeof Animal);
 * - V = Identifies the valid values for the keys, this should include both the enum numeric and string key of the type. The
 * resulting "Value" of each entry identifies the valid values withing the assignments.
 * @group Enum
 * @example
 * ```ts
 * // Create a strongly types map
 * const animalFamilyMap = createTypeMap<typeof Animal, {
 *     // Defined the enum lookups
 *     [Animal.Dog]: "Canidae",
 *     [Animal.Cat]: "Felidae",
 *     [Animal.Butterfly]: "Papilionidae",
 *     [Animal.Bear]: "Ursidae",
 *     // Defined Named reference
 *     Dog: "Canidae",
 *     Cat: "Felidae",
 *     Butterfly: "Papilionidae",
 *     Bear: "Ursidae",
 * }>({
 *     Dog: [ Animal.Dog, "Canidae"],
 *     Cat: [ Animal.Cat, "Felidae"],
 *     Butterfly: [ Animal.Butterfly, "Papilionidae"],
 *     Bear: [ Animal.Bear, "Ursidae"]
 * });
 * // You end up with a strongly types result for each value
 * animalMap.Dog === "Canidae";     // true with typeof animalMap.Dog is (const) "Canidae"
 * animalMap[0] === "Canidae";      // true with typeof animalMap[0] is "Canidae"
 * animalMap["Dog"] === "Canidae";  // true with typeof animalMap["Dog"] is "Canidae"
 * animalMap.Cat === "Felidae";     // true with typeof animalMap.Cat is "Felidae"
 * animalMap[1] === "Felidae";      // true with typeof animalMap[1] is "Felidae"
 * animalMap["Cat"] === "Felidae";  // true with typeof animalMap["Cat"] is "Felidae"
 *
 * or using an interface to define the direct string mappings
 *
 * interface IAnimalFamilyMap {
 *     Dog: "Canidae",
 *     Cat: "Felidae",
 *     Butterfly: "Papilionidae",
 *     Bear: "Ursidae"
 * }
 *
 * // Create a strongly types map
 * const animalFamilyMap = createTypeMap<typeof Animal, IAnimalFamilyMap & {
 *     // Defined the enum lookups
 *     [Animal.Dog]: "Canidae",
 *     [Animal.Cat]: "Felidae",
 *     [Animal.Butterfly]: "Papilionidae",
 *     [Animal.Bear]: "Ursidae"
 * }>({
 *     Dog: [ Animal.Dog, "Canidae"],
 *     Cat: [ Animal.Cat, "Felidae"],
 *     Butterfly: [ Animal.Butterfly, "Papilionidae"],
 *     Bear: [ Animal.Bear, "Ursidae"]
 * });
 *
 * // You also end up with a strongly types result for each value
 * animalMap.Dog === "Canidae";     // true with typeof animalMap.Dog is (const) "Canidae"
 * animalMap[0] === "Canidae";      // true with typeof animalMap[0] is "Canidae"
 * animalMap["Dog"] === "Canidae";  // true with typeof animalMap["Dog"] is "Canidae"
 * animalMap.Cat === "Felidae";     // true with typeof animalMap.Cat is "Felidae"
 * animalMap[1] === "Felidae";      // true with typeof animalMap[1] is "Felidae"
 * animalMap["Cat"] === "Felidae";  // true with typeof animalMap["Cat"] is "Felidae"
 * ```
 * @param values - The values to populate on the new object
 * @typeParam E - Identifies the enum type
 * @typeParam T - Identifies the return type that is being created via the mapping.
 * @returns A new frozen (immutable) object which contains a property for each key and value that returns the defined mapped value.
 */
function createTypeMap(values) {
    return createSimpleMap(values);
}
//# sourceMappingURL=enum.js.map

/***/ }),
/* 32 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_createKeyValueMap": () => (/* binding */ _createKeyValueMap)
/* harmony export */ });
/* harmony import */ var _object_for_each_key__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(24);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

/**
 * @internal
 * @ignore
 * Internal Helper function to create a key and value mapped representation of the values
 * @param values - The source values
 * @param keyType - Identifies the value to populate against the key
 * @param valueType - Identifies the value to populate against the value
 * @param completeFn - The function to call to complete the map (used to freeze the instance)
 * @returns
 */
function _createKeyValueMap(values, keyType, valueType, completeFn) {
    var theMap = {};
    (0,_object_for_each_key__WEBPACK_IMPORTED_MODULE_0__.objForEachKey)(values, function (key, value) {
        theMap[key] = keyType ? value : key;
        theMap[value] = valueType ? value : key;
    });
    return completeFn(theMap);
}
//# sourceMappingURL=map.js.map

/***/ }),
/* 33 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "objAssign": () => (/* binding */ objAssign),
/* harmony export */   "objDeepFreeze": () => (/* binding */ objDeepFreeze),
/* harmony export */   "objEntries": () => (/* binding */ objEntries),
/* harmony export */   "objFreeze": () => (/* binding */ objFreeze),
/* harmony export */   "objGetPrototypeOf": () => (/* binding */ objGetPrototypeOf),
/* harmony export */   "objKeys": () => (/* binding */ objKeys),
/* harmony export */   "objSeal": () => (/* binding */ objSeal),
/* harmony export */   "objValues": () => (/* binding */ objValues)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14);
/* harmony import */ var _helpers_throw__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11);
/* harmony import */ var _for_each_key__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24);
/* harmony import */ var _polyfills_object__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(34);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */





var _objFreeze = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.freeze;
var _doNothing = function (value) { return value; };
var _getProto = function (value) { return value[_internal_constants__WEBPACK_IMPORTED_MODULE_0__.__PROTO__] || _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE; };
/**
 * The `objAssign()` method copies all enumerable own properties from one or more source objects
 * to a target object. It returns the modified target object.
 *
 * Properties in the target object are overwritten by properties in the sources if they have the
 * same key. Later sources' properties overwrite earlier ones.
 *
 * The objAssign() method only copies enumerable and own properties from a source object to a
 * target object. It uses `Get` on the source and `Set` on the target, so it will invoke
 * [getters](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/get) and
 * [setters](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/set).
 * Therefore it assigns properties, versus copying or defining new properties. This may make it
 * unsuitable for merging new properties into a prototype if the merge sources contain getters.
 *
 * For copying property definitions (including their enumerability) into prototypes, use
 * {@link objGetOwnPropertyDescriptor} and {@link objDefineProp} instead.
 *
 * Both String and Symbol properties are copied.
 *
 * In case of an error, for example if a property is non-writable, a TypeError is raised, and
 * the target object is changed if any properties are added before the error is raised.
 * @group Object
 * @example
 * ```ts
 * const obj = { a: 1 };
 * const copy = objAssign({}, obj);
 * console.log(copy); // { a: 1 }
 *
 * const o1 = { a: 1 };
 * const o2 = { b: 2 };
 * const o3 = { c: 3 };
 *
 * const obj = objAssign(o1, o2, o3);
 * console.log(obj); // { a: 1, b: 2, c: 3 }
 * console.log(o1);  // { a: 1, b: 2, c: 3 }, target object itself is changed.
 * ```
 */
var objAssign = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.assign;
/**
 * The `objKeys()` method returns an array of a given object's own enumerable property names, iterated in
 * the same order that a normal loop would.
 *
 * objKeys() returns an array whose elements are strings corresponding to the enumerable properties found
 * directly upon object. The ordering of the properties is the same as that given by looping over the
 * properties of the object manually.
 * @group Object
 * @param value - The object to obtain a copy of the keys from
 * @returns An array of the properties names for the value object.
 * @example
 * ```ts
 * // simple array
 * const arr = ['a', 'b', 'c'];
 * console.log(objKeys(arr)); // console: ['0', '1', '2']
 *
 * // array-like object
 * const obj = { 0: 'a', 1: 'b', 2: 'c' };
 * console.log(objKeys(obj)); // console: ['0', '1', '2']
 *
 * // array-like object with random key ordering
 * const anObj = { 100: 'a', 2: 'b', 7: 'c' };
 * console.log(objKeys(anObj)); // console: ['2', '7', '100']
 *
 * // getFoo is a property which isn't enumerable
 * const myObj = objCreate({}, {
 *   getFoo: {
 *     value() { return this.foo; }
 *   }
 * });
 * myObj.foo = 1;
 * console.log(objKeys(myObj)); // console: ['foo']
 * ```
 */
function objKeys(value) {
    if (!(0,_helpers_base__WEBPACK_IMPORTED_MODULE_1__.isObject)(value) || value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE) {
        (0,_helpers_throw__WEBPACK_IMPORTED_MODULE_2__.throwTypeError)("objKeys called on non-object");
    }
    return _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.keys(value);
}
/**
 * Perform a deep freeze on the object and all of it's contained values / properties by recursively calling
 * `objFreeze()` on all enumerable properties of the object and on each property returned.
 * @group Object
 * @param value - the object to be completly frozen.
 * @returns The originally passed in object.
 */
function objDeepFreeze(value) {
    if (_objFreeze) {
        (0,_for_each_key__WEBPACK_IMPORTED_MODULE_3__.objForEachKey)(value, function (key, value) {
            if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_1__.isArray)(value) || (0,_helpers_base__WEBPACK_IMPORTED_MODULE_1__.isObject)(value)) {
                _objFreeze(value);
            }
        });
    }
    return objFreeze(value);
}
/**
 * The `objFreeze()` method freezes an object. A frozen object can no longer be changed; freezing an object
 * prevents new properties from being added to it, existing properties from being removed, prevents changing the
 * enumerability, configurability, or writability of existing properties, and prevents the values of existing
 * properties from being changed. In addition, freezing an object also prevents its prototype from being changed.
 * `objFreeze()` returns the same object that was passed in.
 *
 * Nothing can be added to or removed from the properties set of a frozen object. Any attempt to do so will fail,
 * either silently or by throwing a TypeError exception (most commonly, but not exclusively, when in strict mode).
 *
 * For data properties of a frozen object, values cannot be changed, the writable and configurable attributes are
 * set to false. Accessor properties (getters and setters) work the same (and still give the illusion that you are
 * changing the value). Note that values that are objects can still be modified, unless they are also frozen. As
 * an object, an array can be frozen; after doing so, its elements cannot be altered and no elements can be added
 * to or removed from the array.
 *
 * `objFreeze()` returns the same object that was passed into the function. It does not create a frozen copy.
 * @group Object
 * @param value - The object to freeze.
 * @returns The object that was passed to the function.
 */
var objFreeze = _objFreeze || _doNothing;
/**
 * The `objSeal()` method seals an object, preventing new properties from being added to it and marking all
 * existing properties as non-configurable. Values of present properties can still be changed as long as they
 * are writable.
 * @group Object
 * @param value - The object which should be sealed.
 * @returns The object being sealed.
 */
var objSeal = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.seal || _doNothing;
/**
 * The objGetPrototypeOf() method returns the prototype (i.e. the value of the internal `Prototype` property)
 * of the specified value.
 * @since 0.4.4
 * @group Object
 * @param value - The object whose prototype is to be returned, which may be null.
 */
var objGetPrototypeOf = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.getPrototypeOf || _getProto;
/**
 * Returns an array of key/values of the enumerable properties of an object
 * @since 0.9.7
 * @group Object
 * @group ArrayLike
 * @param value Object that contains the properties and methods.
 * @example
 * ```ts
 * objEntries({ Hello: "Darkness", my: "old", friend: "." });
 * // [ [ "Hello", "Darkness" ], [ "my", "old"], [ "friend", "." ] ]
 *
 * // Array-like object
 * objEntries({ 0: "a", 1: "b", 2: "c" }));
 * // [ ['0', 'a'], ['1', 'b'], ['2', 'c'] ]
 *
 * // Array-like object with random key ordering
 * objEntries({ 100: "a", 2: "b", 7: "c" });
 * // [ ['2', 'b'], ['7', 'c'], ['100', 'a'] ]*
 * ```
 */
var objEntries = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.entries || _polyfills_object__WEBPACK_IMPORTED_MODULE_4__.polyObjEntries;
/**
 * The objValues() returns an array whose elements are values of enumerable string-keyed properties found
 * directly upon object. This is the same as iterating with a for...in loop, except that a for...in loop
 * enumerates properties in the prototype chain as well. The order of the array returned by objValues()
 * is the same as that provided by a for...in loop.
 *
 * If you need the property keys, use objKeys() instead. If you need both the property keys and values, use objEntries() instead.
 * @since 0.9.7
 * @group Object
 * @group ArrayLike
 * @param value - The object that contains the properties and methods.
 * @returns An array containing the given object's own enumerable string-keyed property values.
 * @example
 * ```ts
 * objValues({ Hello: "Darkness", my: "old", friend: "." });
 * // [ "Darkness", "old", "." ]
 *
 * // Array-like object
 * objValues({ 0: "a", 1: "b", 2: "c" }));
 * // [ 'a', 'b', 'c']
 *
 * // Array-like object with random key ordering
 * objValues({ 100: "a", 2: "b", 7: "c" });
 * // [ 'b', 'c', 'a']
 * ```
 */
var objValues = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.values || _polyfills_object__WEBPACK_IMPORTED_MODULE_4__.polyObjValues;
//# sourceMappingURL=object.js.map

/***/ }),
/* 34 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "polyObjEntries": () => (/* binding */ polyObjEntries),
/* harmony export */   "polyObjKeys": () => (/* binding */ polyObjKeys),
/* harmony export */   "polyObjValues": () => (/* binding */ polyObjValues)
/* harmony export */ });
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _object_for_each_key__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24);
/* harmony import */ var _object_has_own__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(25);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */




/**
 * Returns the names of the enumerable string properties and methods of an object. This helper exists to avoid adding a polyfil for older browsers
 * that do not define Object.keys eg. ES3 only, IE8 just in case any page checks for presence/absence of the prototype implementation.
 * Note: For consistency this will not use the Object.keys implementation if it exists as this would cause a testing requirement to test with and without the implementations
 * @group Polyfill
 * @group Object
 * @param obj Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.
 */
function polyObjKeys(obj) {
    if (!(0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isObject)(obj) || obj === _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE) {
        throw new TypeError("polyObjKeys called on non-object");
    }
    var result = [];
    for (var prop in obj) {
        if ((0,_object_has_own__WEBPACK_IMPORTED_MODULE_2__.objHasOwn)(obj, prop)) {
            result.push(prop);
        }
    }
    return result;
}
/**
 * Returns an array of key/values of the enumerable properties of an object
 * @since 0.9.7
 * @group Polyfill
 * @group Object
 * @group ArrayLike
 * @param value Object that contains the properties and methods.
 * @example
 * ```ts
 * polyObjEntries({ Hello: "Darkness", my: "old", friend: "." });
 * // [ [ "Hello", "Darkness" ], [ "my", "old"], [ "friend", "." ] ]
 *
 * // Array-like object
 * polyObjEntries({ 0: "a", 1: "b", 2: "c" }));
 * // [ ['0', 'a'], ['1', 'b'], ['2', 'c'] ]
 *
 * // Array-like object with random key ordering
 * polyObjEntries({ 100: "a", 2: "b", 7: "c" });
 * // [ ['2', 'b'], ['7', 'c'], ['100', 'a'] ]*
 * ```
 */
function polyObjEntries(value) {
    var result = [];
    (0,_object_for_each_key__WEBPACK_IMPORTED_MODULE_3__.objForEachKey)(value, function (key, value) {
        result.push([key, value]);
    });
    return result;
}
/**
 * Returns an array of key/values of the enumerable properties of an object
 * @since 0.9.7
 * @group Polyfill
 * @group Object
 * @group ArrayLike
 * @param value Object that contains the properties and methods.
 * @example
 * ```ts
 * polyObjValues({ Hello: "Darkness", my: "old", friend: "." });
 * // [ "Darkness", "old", "." ]
 *
 * // Array-like object
 * polyObjValues({ 0: "a", 1: "b", 2: "c" }));
 * // [ 'a', 'b', 'c']
 *
 * // Array-like object with random key ordering
 * polyObjValues({ 100: "a", 2: "b", 7: "c" });
 * // [ 'b', 'c', 'a']
 * ```
 */
function polyObjValues(value) {
    var result = [];
    (0,_object_for_each_key__WEBPACK_IMPORTED_MODULE_3__.objForEachKey)(value, function (key, value) {
        result.push(value);
    });
    return result;
}
//# sourceMappingURL=object.js.map

/***/ }),
/* 35 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "dataSanitizeException": () => (/* binding */ dataSanitizeException),
/* harmony export */   "dataSanitizeId": () => (/* binding */ dataSanitizeId),
/* harmony export */   "dataSanitizeInput": () => (/* binding */ dataSanitizeInput),
/* harmony export */   "dataSanitizeKey": () => (/* binding */ dataSanitizeKey),
/* harmony export */   "dataSanitizeKeyAndAddUniqueness": () => (/* binding */ dataSanitizeKeyAndAddUniqueness),
/* harmony export */   "dataSanitizeMeasurements": () => (/* binding */ dataSanitizeMeasurements),
/* harmony export */   "dataSanitizeMessage": () => (/* binding */ dataSanitizeMessage),
/* harmony export */   "dataSanitizeProperties": () => (/* binding */ dataSanitizeProperties),
/* harmony export */   "dataSanitizeString": () => (/* binding */ dataSanitizeString),
/* harmony export */   "dataSanitizeUrl": () => (/* binding */ dataSanitizeUrl),
/* harmony export */   "dsPadNumber": () => (/* binding */ dsPadNumber)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(39);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(41);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(24);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(14);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(44);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





function dataSanitizeKeyAndAddUniqueness(logger, key, map) {
    var origLength = key[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */];
    var field = dataSanitizeKey(logger, key);
    // validation truncated the length.  We need to add uniqueness
    if (field[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] !== origLength) {
        var i = 0;
        var uniqueField = field;
        while (map[uniqueField] !== undefined) {
            i++;
            uniqueField = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstring)(field, 0, 150 /* DataSanitizerValues.MAX_NAME_LENGTH */ - 3) + dsPadNumber(i);
        }
        field = uniqueField;
    }
    return field;
}
function dataSanitizeKey(logger, name) {
    var nameTrunc;
    if (name) {
        // Remove any leading or trailing whitespace
        name = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.strTrim)((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.asString)(name));
        // truncate the string to 150 chars
        if (name[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 150 /* DataSanitizerValues.MAX_NAME_LENGTH */) {
            nameTrunc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstring)(name, 0, 150 /* DataSanitizerValues.MAX_NAME_LENGTH */);
            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 57 /* _eInternalMessageId.NameTooLong */, "name is too long.  It has been truncated to " + 150 /* DataSanitizerValues.MAX_NAME_LENGTH */ + " characters.", { name: name }, true);
        }
    }
    return nameTrunc || name;
}
function dataSanitizeString(logger, value, maxLength) {
    if (maxLength === void 0) { maxLength = 1024 /* DataSanitizerValues.MAX_STRING_LENGTH */; }
    var valueTrunc;
    if (value) {
        maxLength = maxLength ? maxLength : 1024 /* DataSanitizerValues.MAX_STRING_LENGTH */; // in case default parameters dont work
        value = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.strTrim)((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.asString)(value));
        if (value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > maxLength) {
            valueTrunc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstring)(value, 0, maxLength);
            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 61 /* _eInternalMessageId.StringValueTooLong */, "string value is too long. It has been truncated to " + maxLength + " characters.", { value: value }, true);
        }
    }
    return valueTrunc || value;
}
function dataSanitizeUrl(logger, url) {
    return dataSanitizeInput(logger, url, 2048 /* DataSanitizerValues.MAX_URL_LENGTH */, 66 /* _eInternalMessageId.UrlTooLong */);
}
function dataSanitizeMessage(logger, message) {
    var messageTrunc;
    if (message) {
        if (message[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 32768 /* DataSanitizerValues.MAX_MESSAGE_LENGTH */) {
            messageTrunc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstring)(message, 0, 32768 /* DataSanitizerValues.MAX_MESSAGE_LENGTH */);
            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 56 /* _eInternalMessageId.MessageTruncated */, "message is too long, it has been truncated to " + 32768 /* DataSanitizerValues.MAX_MESSAGE_LENGTH */ + " characters.", { message: message }, true);
        }
    }
    return messageTrunc || message;
}
function dataSanitizeException(logger, exception) {
    var exceptionTrunc;
    if (exception) {
        // Make surte its a string
        var value = "" + exception;
        if (value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 32768 /* DataSanitizerValues.MAX_EXCEPTION_LENGTH */) {
            exceptionTrunc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstring)(value, 0, 32768 /* DataSanitizerValues.MAX_EXCEPTION_LENGTH */);
            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 52 /* _eInternalMessageId.ExceptionTruncated */, "exception is too long, it has been truncated to " + 32768 /* DataSanitizerValues.MAX_EXCEPTION_LENGTH */ + " characters.", { exception: exception }, true);
        }
    }
    return exceptionTrunc || exception;
}
function dataSanitizeProperties(logger, properties) {
    if (properties) {
        var tempProps_1 = {};
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(properties, function (prop, value) {
            if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.isObject)(value) && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__.hasJSON)()) {
                // Stringify any part C properties
                try {
                    value = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__.getJSON)()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_STRINGIFY /* @min:%2estringify */](value);
                }
                catch (e) {
                    (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 49 /* _eInternalMessageId.CannotSerializeObjectNonSerializable */, "custom property is not valid", { exception: e }, true);
                }
            }
            value = dataSanitizeString(logger, value, 8192 /* DataSanitizerValues.MAX_PROPERTY_LENGTH */);
            prop = dataSanitizeKeyAndAddUniqueness(logger, prop, tempProps_1);
            tempProps_1[prop] = value;
        });
        properties = tempProps_1;
    }
    return properties;
}
function dataSanitizeMeasurements(logger, measurements) {
    if (measurements) {
        var tempMeasurements_1 = {};
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(measurements, function (measure, value) {
            measure = dataSanitizeKeyAndAddUniqueness(logger, measure, tempMeasurements_1);
            tempMeasurements_1[measure] = value;
        });
        measurements = tempMeasurements_1;
    }
    return measurements;
}
function dataSanitizeId(logger, id) {
    return id ? dataSanitizeInput(logger, id, 128 /* DataSanitizerValues.MAX_ID_LENGTH */, 69 /* _eInternalMessageId.IdTooLong */)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TO_STRING /* @min:%2etoString */]() : id;
}
function dataSanitizeInput(logger, input, maxLength, _msgId) {
    var inputTrunc;
    if (input) {
        input = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.strTrim)((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.asString)(input));
        if (input[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > maxLength) {
            inputTrunc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstring)(input, 0, maxLength);
            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, _msgId, "input is too long, it has been truncated to " + maxLength + " characters.", { data: input }, true);
        }
    }
    return inputTrunc || input;
}
function dsPadNumber(num) {
    var s = "00" + num;
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstr)(s, s[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] - 3);
}
//# sourceMappingURL=DataSanitizer.js.map

/***/ }),
/* 36 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "polyStrSubstr": () => (/* binding */ polyStrSubstr),
/* harmony export */   "strLeft": () => (/* binding */ strLeft),
/* harmony export */   "strRight": () => (/* binding */ strRight),
/* harmony export */   "strSubstr": () => (/* binding */ strSubstr),
/* harmony export */   "strSubstring": () => (/* binding */ strSubstring)
/* harmony export */ });
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(14);
/* harmony import */ var _helpers_diagnostics__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(13);
/* harmony import */ var _helpers_throw__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
/* harmony import */ var _math_min_max__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(37);
/* harmony import */ var _slice__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(38);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */







/**
 * The `strSubstring()` method returns the part of the string between the start and end indexes, or to the end of the string.
 *
 * `strSubstring()` extracts characters from indexStart up to but not including indexEnd. In particular:
 * - If `indexEnd` is omitted, strSubstring() extracts characters to the end of the string.
 * - If `indexStart` is equal to indexEnd, strSubstring() returns an empty string.
 * - If `indexStart` is greater than indexEnd, then the effect of strSubstring() is as if the two arguments were swapped; see example below.
 *
 * Any argument value that is less than 0 or greater than `value.length` is treated as if it were 0 and `value.length`, respectively.
 *
 * Any argument value that is NaN is treated as if it were 0.
 * @group String
 * @param value - The string value to return the substring from.
 * @param indexStart - The index of the first character to include in the returned substring.
 * @param indexEnd - The index of the first character to exclude from the returned substring.
 * @return A new string containing the specified part of the given string
 * @example
 * ```ts
 * const anyString = 'Nevware21';
 * // Displays 'N'
 * console.log(strSubstring(anyString, 0, 1));
 * console.log(strSubstring(anyString, 1, 0));
 *
 * // Displays 'Nevwar'
 * console.log(strSubstring(anyString, 0, 6));
 *
 * // Displays 'are21'
 * console.log(strSubstring(anyString, 4));
 *
 * // Displays 'are'
 * console.log(strSubstring(anyString, 4, 7));
 *
 * // Displays '21'
 * console.log(strSubstring(anyString, 7, 4));
 *
 * // Displays 'Nevware'
 * console.log(strSubstring(anyString, 0, 7));
 *
 * // Displays 'Nevware21'
 * console.log(strSubstring(anyString, 0, 10));
 * ```
 */
var strSubstring = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunction)("substring", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto);
/**
 * The strSubstr() method returns a portion of the string, starting at the specified index and extending for a given
 * number of characters afterwards.
 *
 * @since 0.4.2
 * @group String
 * @param value - The string value to return the substring from.
 * @param start - The index of the first character to include in the returned substring.
 * @param length - The number of characters to extract.
 * @returns A new string containing the specified part of the given string.
 */
var strSubstr = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunctionWithPoly)("substr", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto, polyStrSubstr);
/**
 * The polyStrSubstr() method returns a portion of the string, starting at the specified index and extending for a given
 * number of characters afterwards.
 *
 * @since 0.4.2
 * @group String
 * @group Polyfill
 * @param value - The string value to return the substring from.
 * @param start - The index of the first character to include in the returned substring.
 * @param length - The number of characters to extract.
 * @returns A new string containing the specified part of the given string.
 */
function polyStrSubstr(value, start, length) {
    if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(value)) {
        (0,_helpers_throw__WEBPACK_IMPORTED_MODULE_3__.throwTypeError)("'polyStrSubstr called with invalid " + (0,_helpers_diagnostics__WEBPACK_IMPORTED_MODULE_4__.dumpObj)(value));
    }
    if (length < 0) {
        return _internal_constants__WEBPACK_IMPORTED_MODULE_1__.EMPTY;
    }
    // If start is omitted or undefined, its treated as zero
    start = start || 0;
    if (start < 0) {
        start = (0,_math_min_max__WEBPACK_IMPORTED_MODULE_5__.mathMax)(start + value[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.LENGTH], 0);
    }
    if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_2__.isUndefined)(length)) {
        return (0,_slice__WEBPACK_IMPORTED_MODULE_6__.strSlice)(value, start);
    }
    return (0,_slice__WEBPACK_IMPORTED_MODULE_6__.strSlice)(value, start, start + length);
}
/**
 * Returns a substring of the string starting from the left.
 *
 * `strLeft()` extracts the number of characters from left of the string up to the count. In particular:
 * - If `count` is less than zero, strLeft() returns an empty string.
 * - If `count` is less than `value.length', strLeft() returns a new string with the `count` number of characters from the left of the string.
 * - If `count` is greater than `value.length`, then the value original value is returned.
 *
 * Any argument value that is NaN is treated as if it were 0.
 *
 * @since 0.4.2
 * @group String
 * @param value - The string value to return the substring from.
 * @param count - The number of characters to extract
 * @returns The substring based on the count number of characters from the right
 * @example
 * ```ts
 * strLeft("Nevware21", -1); // ""
 * strLeft("Nevware21", 0); // ""
 * strLeft("Nevware21", 1); // "N"
 * strLeft("Nevware21", 3); // "Nev"
 * strLeft("Nevware21", 21); // "Nevware21"
 * ```
 */
function strLeft(value, count) {
    return strSubstring(value, 0, count);
}
/**
 * Returns a substring of the string starting from the right.
 *
 * `strRight()` extracts the number of characters from right of the string up to the count. In particular:
 * - If `count` is less than zero, strRight() returns an empty string.
 * - If `count` is less than `value.length', strRight() returns a new string with the `count` number of characters from the right of the string.
 * - If `count` is greater than `value.length`, then the value original value is returned.
 *
 * Any argument value that is NaN is treated as if it were 0.
 *
 * @since 0.4.2
 * @group String
 * @param value - The string value to return the substring from.
 * @param count - The number of characters to extract
 * @returns The substring based on the count number of characters from the right
 * @example
 * ```ts
 * strRight("Nevware21", -1); // ""
 * strRight("Nevware21", 0); // ""
 * strRight("Nevware21", 1); // "1"
 * strRight("Nevware21", 3); // "e21"
 * strRight("Nevware21", 21); // "Nevware21"
 * ```
 */
function strRight(value, count) {
    var len = value[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.LENGTH];
    if (count <= 0) {
        return _internal_constants__WEBPACK_IMPORTED_MODULE_1__.EMPTY;
    }
    return len > count ? strSubstring(value, len - count) : value;
}
//# sourceMappingURL=substring.js.map

/***/ }),
/* 37 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "mathMax": () => (/* binding */ mathMax),
/* harmony export */   "mathMin": () => (/* binding */ mathMin)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

/**
 * The mathMin() function returns the lowest-valued number passed into it, or NaN if any
 * parameter isn't a number and can't be converted into one.
 *
 * If no arguments are given, the result is Infinity.
 *
 * If at least one of arguments cannot be converted to a number, the result is NaN.
 *
 * @since 0.4.2
 * @group Math
 * @param values - Zero or more numbers among which the lowest value will be selected and returned.
 * @returns The smallest of the given numbers. If any one or more of the parameters cannot
 * be converted into a number, NaN is returned. The result is Infinity if no parameters are provided.
 * @example
 * ```ts
 * const x = 10, y = -20;
 * const z = Math.min(x, y); // -20
 * ```
 */
var mathMin = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.MathCls.min;
/**
 * The `mathMax()` function returns the largest of the zero or more numbers given as input
 * parameters, or NaN if any parameter isn't a number and can't be converted into one.
 *
 * If no arguments are given, the result is -Infinity.
 *
 * If at least one of arguments cannot be converted to a number, the result is NaN.
 *
 * @since 0.4.2
 * @group Math
 * @param values - Zero or more numbers among which the largest value will be selected and returned.
 * @returns The largest of the given numbers. If any one or more of the parameters cannot be
 * converted into a number, NaN is returned. The result is -Infinity if no parameters are provided.
 * @example
 * ```ts
 * mathMax(10, 20);   //  20
 * mathMax(-10, -20); // -10
 * mathMax(-10, 20);  //  20
 * ```
 */
var mathMax = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.MathCls.max;
//# sourceMappingURL=min_max.js.map

/***/ }),
/* 38 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "strSlice": () => (/* binding */ strSlice)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * The `strSlice()` method extracts a section of a string and returns it as a new string, without
 * modifying the original string.
 * `strSlice()` extracts the text from one string and returns a new string. Changes to the text in one
 * string do not affect the other string.
 * `strSlice()` extracts up to but not including endIndex. str.slice(1, 4) extracts the second character
 * through the fourth character (characters indexed 1, 2, and 3).
 * As an example, strSlice(2, -1) extracts the third character through the second to last character
 * in the string.
 * @group String
 * @param value - The value to haveextract a number
 * @param beginIndex - The zero-based index at which to begin extraction.
 * If `beginIndex` is negative, `strSlice()` begins extraction from `value.length + beginIndex`.
 * (E.g. `strSlice("test", -2)` returns "st")
 * If `beginIndex` is omitted, undefined, or cannot be converted to a number (using Number(`beginIndex`)),
 * strSlice() begins extraction from the beginning of the string. (E.g. `strSlice("test")` returns "test")
 * If `beginIndex` is greater than or equal to `value.length`, an empty string is returned.
 * (E.g. `strSlice("test", 4)` returns "")
 * @param endIndex - The index of the first character to exclude from the returned substring.
 * If `endIndex` is omitted, undefined, or cannot be converted to a number (using Number(`endIndex`))
 * strSlice() extracts to the end of the string. (E.g. `strSlice("test", 2)` returns "st")
 * If `endIndex` is greater than `value.length`, strSlice() also extracts to the end of the string.
 * (E.g. strSlice("test", 2, 10)` returns "st")
 * If `endIndex` is negative, `strSlice()` treats it as `value.length + endIndex`. (E.g, if `endIndex`
 * is -2, it is treated as `value.length - 2` and `strSlice("test", 1, -2)` returns "e") .
 * If `endIndex` represents a position that is before the one represented by startIndex, `strSlice()`
 * returns "". (E.g `strSlice("test", 2, -10)`, strSlice("test", -1, -2)` or `strSlice("test", 3, 2)`).
 * @returns A new string containing the extracted section of the string.
 */
var strSlice = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunction)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.SLICE, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto);
//# sourceMappingURL=slice.js.map

/***/ }),
/* 39 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "strTrim": () => (/* binding */ strTrim),
/* harmony export */   "strTrimEnd": () => (/* binding */ strTrimEnd),
/* harmony export */   "strTrimLeft": () => (/* binding */ strTrimLeft),
/* harmony export */   "strTrimRight": () => (/* binding */ strTrimRight),
/* harmony export */   "strTrimStart": () => (/* binding */ strTrimStart)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
/* harmony import */ var _polyfills_trim__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(40);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */



/**
 * The trim() method removes whitespace from both ends of a string and returns a new string,
 * without modifying the original string. Whitespace in this context is all the whitespace
 * characters (space, tab, no-break space, etc.) and all the line terminator characters
 * (LF, CR, etc.).
 * @group String
 * @param value - The string value to be trimmed.
 * @returns A new string representing str stripped of whitespace from both its beginning and end.
 * If neither the beginning or end of str has any whitespace, a new string is still returned (essentially
 * a copy of str), with no exception being thrown.
 * To return a new string with whitespace trimmed from just one end, use `strTrimStart()` or `strTrimEnd()`.
 */
var strTrim = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunctionWithPoly)("trim", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto, _polyfills_trim__WEBPACK_IMPORTED_MODULE_2__.polyStrTrim);
/**
 * The `strTrimStart()` method removes whitespace from the beginning of a string.
 * @group String
 * @param value - The value to be trimmed.
 * @returns A new string representing str stripped of whitespace from its beginning (left side).
 * If the beginning of str has no whitespace, a new string is still returned (essentially a copy of str),
 * with no exception being thrown.
 */
var strTrimStart = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunctionWithPoly)("trimStart", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto, _polyfills_trim__WEBPACK_IMPORTED_MODULE_2__.polyStrTrimStart);
/**
 * Alias for `strTrimStart()` method removes whitespace from the beginning of a string.
 * @group String
 * @param value - The value to be trimmed.
 * @returns A new string representing str stripped of whitespace from its beginning (left side).
 * If the beginning of str has no whitespace, a new string is still returned (essentially a copy of str),
 * with no exception being thrown.
 */
var strTrimLeft = strTrimStart;
/**
 * The `strTrimEnd()` method removes whitespace from the end of a string.
 * @group String
 * @param value - The value to be trimmed.
 * @returns A new string representing str stripped of whitespace from its end (right side).
 * If the end of str has no whitespace, a new string is still returned (essentially a copy of str),
 * with no exception being thrown.
 */
var strTrimEnd = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunctionWithPoly)("trimEnd", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto, _polyfills_trim__WEBPACK_IMPORTED_MODULE_2__.polyStrTrimEnd);
/**
 * Alias for `strTrimEnd()` method removes whitespace from the end of a string.
 * @group String
 * @param value - The value to be trimmed.
 * @returns A new string representing str stripped of whitespace from its end (right side).
 * If the end of str has no whitespace, a new string is still returned (essentially a copy of str),
 * with no exception being thrown.
 */
var strTrimRight = strTrimEnd;
//# sourceMappingURL=trim.js.map

/***/ }),
/* 40 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "polyStrTrim": () => (/* binding */ polyStrTrim),
/* harmony export */   "polyStrTrimEnd": () => (/* binding */ polyStrTrimEnd),
/* harmony export */   "polyStrTrimStart": () => (/* binding */ polyStrTrimStart)
/* harmony export */ });
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14);
/* harmony import */ var _helpers_diagnostics__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13);
/* harmony import */ var _helpers_throw__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(10);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */




function _createTrimFn(exp) {
    return function _doTrim(value) {
        if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(value)) {
            (0,_helpers_throw__WEBPACK_IMPORTED_MODULE_1__.throwTypeError)("strTrim called [" + (0,_helpers_diagnostics__WEBPACK_IMPORTED_MODULE_2__.dumpObj)(value) + "]");
        }
        if (value && value.replace) {
            value = value.replace(exp, _internal_constants__WEBPACK_IMPORTED_MODULE_3__.EMPTY);
        }
        return value;
    };
}
/**
 * The trim() method removes whitespace from both ends of a string and returns a new string,
 * without modifying the original string. Whitespace in this context is all the whitespace
 * characters (space, tab, no-break space, etc.) and all the line terminator characters
 * (LF, CR, etc.).
 * @group Polyfill
 * @group String
 * @param value - The string value to be trimmed.
 * @returns A new string representing str stripped of whitespace from both its beginning and end.
 * If neither the beginning or end of str has any whitespace, a new string is still returned (essentially
 * a copy of str), with no exception being thrown.
 * To return a new string with whitespace trimmed from just one end, use `strTrimStart()` or `strTrimEnd()`.
 */
var polyStrTrim = _createTrimFn(/^\s+|(?=\s)\s+$/g);
/**
 * The `polyStrTrimStart()` method removes whitespace from the beginning of a string.
 * @group Polyfill
 * @group String
 * @param value - The value to be trimmed.
 * @returns A new string representing str stripped of whitespace from its beginning (left side).
 * If the beginning of str has no whitespace, a new string is still returned (essentially a copy of str),
 * with no exception being thrown.
 */
var polyStrTrimStart = _createTrimFn(/^\s+/g);
/**
 * The `polyStrTrimEnd()` method removes whitespace from the end of a string.
 * @group Polyfill
 * @group String
 * @param value - The value to be trimmed.
 * @returns A new string representing str stripped of whitespace from its end (right side).
 * If the end of str has no whitespace, a new string is still returned (essentially a copy of str),
 * with no exception being thrown.
 */
var polyStrTrimEnd = _createTrimFn(/(?=\s)\s+$/g);
//# sourceMappingURL=trim.js.map

/***/ }),
/* 41 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DiagnosticLogger": () => (/* binding */ DiagnosticLogger),
/* harmony export */   "_InternalLogMessage": () => (/* binding */ _InternalLogMessage),
/* harmony export */   "_logInternalMessage": () => (/* binding */ _logInternalMessage),
/* harmony export */   "_throwInternal": () => (/* binding */ _throwInternal),
/* harmony export */   "_warnToConsole": () => (/* binding */ _warnToConsole),
/* harmony export */   "safeGetLogger": () => (/* binding */ safeGetLogger)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(51);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(13);
/* harmony import */ var _Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(52);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(42);
/* harmony import */ var _DbgExtensionUtils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(71);
/* harmony import */ var _EnvUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(44);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */



var _a;







var STR_WARN_TO_CONSOLE = "warnToConsole";
/**
 * For user non actionable traces use AI Internal prefix.
 */
var AiNonUserActionablePrefix = "AI (Internal): ";
/**
 * Prefix of the traces in portal.
 */
var AiUserActionablePrefix = "AI: ";
/**
 *  Session storage key for the prefix for the key indicating message type already logged
 */
var AIInternalMessagePrefix = "AITR_";
var defaultValues = {
    loggingLevelConsole: 0,
    loggingLevelTelemetry: 1,
    maxMessageLimit: 25,
    enableDebug: false
};
var _logFuncs = (_a = {},
    _a[0 /* eLoggingSeverity.DISABLED */] = null,
    _a[1 /* eLoggingSeverity.CRITICAL */] = "errorToConsole",
    _a[2 /* eLoggingSeverity.WARNING */] = STR_WARN_TO_CONSOLE,
    _a[3 /* eLoggingSeverity.DEBUG */] = "debugToConsole",
    _a);
function _sanitizeDiagnosticText(text) {
    if (text) {
        return "\"" + text[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_REPLACE /* @min:%2ereplace */](/\"/g, _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY) + "\"";
    }
    return _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
}
function _logToConsole(func, message) {
    var theConsole = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_2__.getConsole)();
    if (!!theConsole) {
        var logFunc = "log";
        if (theConsole[func]) {
            logFunc = func;
        }
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isFunction)(theConsole[logFunc])) {
            theConsole[logFunc](message);
        }
    }
}
var _InternalLogMessage = /** @class */ (function () {
    function _InternalLogMessage(msgId, msg, isUserAct, properties) {
        if (isUserAct === void 0) { isUserAct = false; }
        var _self = this;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE_ID /* @min:%2emessageId */] = msgId;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE /* @min:%2emessage */] =
            (isUserAct ? AiUserActionablePrefix : AiNonUserActionablePrefix) +
                msgId;
        var strProps = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
        if ((0,_EnvUtils__WEBPACK_IMPORTED_MODULE_2__.hasJSON)()) {
            strProps = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_2__.getJSON)().stringify(properties);
        }
        var diagnosticText = (msg ? " message:" + _sanitizeDiagnosticText(msg) : _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY) +
            (properties ? " props:" + _sanitizeDiagnosticText(strProps) : _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY);
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE /* @min:%2emessage */] += diagnosticText;
    }
    _InternalLogMessage.dataType = "MessageData";
    return _InternalLogMessage;
}());

function safeGetLogger(core, config) {
    return (core || {})[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOGGER /* @min:%2elogger */] || new DiagnosticLogger(config);
}
var DiagnosticLogger = /** @class */ (function () {
    function DiagnosticLogger(config) {
        this.identifier = "DiagnosticLogger";
        /**
         * The internal logging queue
         */
        this.queue = [];
        /**
         * Count of internal messages sent
         */
        var _messageCount = 0;
        /**
         * Holds information about what message types were already logged to console or sent to server.
         */
        var _messageLogged = {};
        var _loggingLevelConsole;
        var _loggingLevelTelemetry;
        var _maxInternalMessageLimit;
        var _enableDebug;
        var _unloadHandler;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__["default"])(DiagnosticLogger, this, function (_self) {
            _unloadHandler = _setDefaultsFromConfig(config || {});
            _self.consoleLoggingLevel = function () { return _loggingLevelConsole; };
            /**
             * This method will throw exceptions in debug mode or attempt to log the error as a console warning.
             * @param severity - {LoggingSeverity} - The severity of the log message
             * @param message - {_InternalLogMessage} - The log message.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_THROW_INTERNAL /* @min:%2ethrowInternal */] = function (severity, msgId, msg, properties, isUserAct) {
                if (isUserAct === void 0) { isUserAct = false; }
                var message = new _InternalLogMessage(msgId, msg, isUserAct, properties);
                if (_enableDebug) {
                    throw (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.dumpObj)(message);
                }
                else {
                    // Get the logging function and fallback to warnToConsole of for some reason errorToConsole doesn't exist
                    var logFunc = _logFuncs[severity] || STR_WARN_TO_CONSOLE;
                    if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isUndefined)(message[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE /* @min:%2emessage */])) {
                        if (isUserAct) {
                            // check if this message type was already logged to console for this page view and if so, don't log it again
                            var messageKey = +message[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE_ID /* @min:%2emessageId */];
                            if (!_messageLogged[messageKey] && _loggingLevelConsole >= severity) {
                                _self[logFunc](message[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE /* @min:%2emessage */]);
                                _messageLogged[messageKey] = true;
                            }
                        }
                        else {
                            // Only log traces if the console Logging Level is >= the throwInternal severity level
                            if (_loggingLevelConsole >= severity) {
                                _self[logFunc](message[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE /* @min:%2emessage */]);
                            }
                        }
                        _logInternalMessage(severity, message);
                    }
                    else {
                        _debugExtMsg("throw" + (severity === 1 /* eLoggingSeverity.CRITICAL */ ? "Critical" : "Warning"), message);
                    }
                }
            };
            _self.debugToConsole = function (message) {
                _logToConsole("debug", message);
                _debugExtMsg("warning", message);
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_WARN_TO_CONSOLE /* @min:%2ewarnToConsole */] = function (message) {
                _logToConsole("warn", message);
                _debugExtMsg("warning", message);
            };
            _self.errorToConsole = function (message) {
                _logToConsole("error", message);
                _debugExtMsg("error", message);
            };
            _self.resetInternalMessageCount = function () {
                _messageCount = 0;
                _messageLogged = {};
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOG_INTERNAL_MESSAGE /* @min:%2elogInternalMessage */] = _logInternalMessage;
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UNLOAD /* @min:%2eunload */] = function (isAsync) {
                _unloadHandler && _unloadHandler.rm();
                _unloadHandler = null;
            };
            function _logInternalMessage(severity, message) {
                if (_areInternalMessagesThrottled()) {
                    return;
                }
                // check if this message type was already logged for this session and if so, don't log it again
                var logMessage = true;
                var messageKey = AIInternalMessagePrefix + message[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE_ID /* @min:%2emessageId */];
                // if the session storage is not available, limit to only one message type per page view
                if (_messageLogged[messageKey]) {
                    logMessage = false;
                }
                else {
                    _messageLogged[messageKey] = true;
                }
                if (logMessage) {
                    // Push the event in the internal queue
                    if (severity <= _loggingLevelTelemetry) {
                        _self.queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PUSH /* @min:%2epush */](message);
                        _messageCount++;
                        _debugExtMsg((severity === 1 /* eLoggingSeverity.CRITICAL */ ? "error" : "warn"), message);
                    }
                    // When throttle limit reached, send a special event
                    if (_messageCount === _maxInternalMessageLimit) {
                        var throttleLimitMessage = "Internal events throttle limit per PageView reached for this app.";
                        var throttleMessage = new _InternalLogMessage(23 /* _eInternalMessageId.MessageLimitPerPVExceeded */, throttleLimitMessage, false);
                        _self.queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PUSH /* @min:%2epush */](throttleMessage);
                        if (severity === 1 /* eLoggingSeverity.CRITICAL */) {
                            _self.errorToConsole(throttleLimitMessage);
                        }
                        else {
                            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_WARN_TO_CONSOLE /* @min:%2ewarnToConsole */](throttleLimitMessage);
                        }
                    }
                }
            }
            function _setDefaultsFromConfig(config) {
                // make sure the config is dynamic
                return (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_6__.onConfigChange)((0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_6__.createDynamicConfig)(config, defaultValues, _self).cfg, function (details) {
                    var config = details.cfg;
                    _loggingLevelConsole = config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOGGING_LEVEL_CONSOL4 /* @min:%2eloggingLevelConsole */];
                    _loggingLevelTelemetry = config.loggingLevelTelemetry;
                    _maxInternalMessageLimit = config.maxMessageLimit;
                    _enableDebug = config.enableDebug;
                });
            }
            function _areInternalMessagesThrottled() {
                return _messageCount >= _maxInternalMessageLimit;
            }
            function _debugExtMsg(name, data) {
                var dbgExt = (0,_DbgExtensionUtils__WEBPACK_IMPORTED_MODULE_7__.getDebugExt)(config || {});
                if (dbgExt && dbgExt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */]) {
                    dbgExt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](name, data);
                }
            }
        });
    }
// Removed Stub for DiagnosticLogger.prototype.consoleLoggingLevel.
// Removed Stub for DiagnosticLogger.prototype.throwInternal.
// Removed Stub for DiagnosticLogger.prototype.debugToConsole.
// Removed Stub for DiagnosticLogger.prototype.warnToConsole.
// Removed Stub for DiagnosticLogger.prototype.errorToConsole.
// Removed Stub for DiagnosticLogger.prototype.resetInternalMessageCount.
// Removed Stub for DiagnosticLogger.prototype.logInternalMessage.
// Removed Stub for DiagnosticLogger.prototype.unload.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    DiagnosticLogger.__ieDyn=1;

    return DiagnosticLogger;
}());

function _getLogger(logger) {
    return (logger || new DiagnosticLogger());
}
/**
 * This is a helper method which will call throwInternal on the passed logger, will throw exceptions in
 * debug mode or attempt to log the error as a console warning. This helper is provided mostly to better
 * support minification as logger.throwInternal() will not compress the publish "throwInternal" used throughout
 * the code.
 * @param logger - The Diagnostic Logger instance to use.
 * @param severity - {LoggingSeverity} - The severity of the log message
 * @param message - {_InternalLogMessage} - The log message.
 */
function _throwInternal(logger, severity, msgId, msg, properties, isUserAct) {
    if (isUserAct === void 0) { isUserAct = false; }
    _getLogger(logger)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_THROW_INTERNAL /* @min:%2ethrowInternal */](severity, msgId, msg, properties, isUserAct);
}
/**
 * This is a helper method which will call warnToConsole on the passed logger with the provided message.
 * @param logger - The Diagnostic Logger instance to use.
 * @param message - {_InternalLogMessage} - The log message.
 */
function _warnToConsole(logger, message) {
    _getLogger(logger)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_WARN_TO_CONSOLE /* @min:%2ewarnToConsole */](message);
}
/**
 * Logs a message to the internal queue.
 * @param logger - The Diagnostic Logger instance to use.
 * @param severity - {LoggingSeverity} - The severity of the log message
 * @param message - {_InternalLogMessage} - The message to log.
 */
function _logInternalMessage(logger, severity, message) {
    _getLogger(logger)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOG_INTERNAL_MESSAGE /* @min:%2elogInternalMessage */](severity, message);
}
//# sourceMappingURL=DiagnosticLogger.js.map

/***/ }),
/* 42 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_DYN_ADD_NOTIFICATION_LIS1": () => (/* binding */ _DYN_ADD_NOTIFICATION_LIS1),
/* harmony export */   "_DYN_APPLY": () => (/* binding */ _DYN_APPLY),
/* harmony export */   "_DYN_BLK_VAL": () => (/* binding */ _DYN_BLK_VAL),
/* harmony export */   "_DYN_CANCEL": () => (/* binding */ _DYN_CANCEL),
/* harmony export */   "_DYN_COMPLETE": () => (/* binding */ _DYN_COMPLETE),
/* harmony export */   "_DYN_CREATE_NEW": () => (/* binding */ _DYN_CREATE_NEW),
/* harmony export */   "_DYN_DIAG_LOG": () => (/* binding */ _DYN_DIAG_LOG),
/* harmony export */   "_DYN_ENABLED": () => (/* binding */ _DYN_ENABLED),
/* harmony export */   "_DYN_GET_CTX": () => (/* binding */ _DYN_GET_CTX),
/* harmony export */   "_DYN_GET_NEXT": () => (/* binding */ _DYN_GET_NEXT),
/* harmony export */   "_DYN_GET_NOTIFY_MGR": () => (/* binding */ _DYN_GET_NOTIFY_MGR),
/* harmony export */   "_DYN_GET_PLUGIN": () => (/* binding */ _DYN_GET_PLUGIN),
/* harmony export */   "_DYN_GET_PROCESS_TEL_CONT0": () => (/* binding */ _DYN_GET_PROCESS_TEL_CONT0),
/* harmony export */   "_DYN_HANDLER": () => (/* binding */ _DYN_HANDLER),
/* harmony export */   "_DYN_HDLR": () => (/* binding */ _DYN_HDLR),
/* harmony export */   "_DYN_IDENTIFIER": () => (/* binding */ _DYN_IDENTIFIER),
/* harmony export */   "_DYN_INITIALIZE": () => (/* binding */ _DYN_INITIALIZE),
/* harmony export */   "_DYN_IS_ASYNC": () => (/* binding */ _DYN_IS_ASYNC),
/* harmony export */   "_DYN_IS_CHILD_EVT": () => (/* binding */ _DYN_IS_CHILD_EVT),
/* harmony export */   "_DYN_IS_INITIALIZED": () => (/* binding */ _DYN_IS_INITIALIZED),
/* harmony export */   "_DYN_LENGTH": () => (/* binding */ _DYN_LENGTH),
/* harmony export */   "_DYN_LOGGER": () => (/* binding */ _DYN_LOGGER),
/* harmony export */   "_DYN_LOGGING_LEVEL_CONSOL4": () => (/* binding */ _DYN_LOGGING_LEVEL_CONSOL4),
/* harmony export */   "_DYN_LOG_INTERNAL_MESSAGE": () => (/* binding */ _DYN_LOG_INTERNAL_MESSAGE),
/* harmony export */   "_DYN_MESSAGE": () => (/* binding */ _DYN_MESSAGE),
/* harmony export */   "_DYN_MESSAGE_ID": () => (/* binding */ _DYN_MESSAGE_ID),
/* harmony export */   "_DYN_NAME": () => (/* binding */ _DYN_NAME),
/* harmony export */   "_DYN_NODE_TYPE": () => (/* binding */ _DYN_NODE_TYPE),
/* harmony export */   "_DYN_NOTIFY": () => (/* binding */ _DYN_NOTIFY),
/* harmony export */   "_DYN_ON_COMPLETE": () => (/* binding */ _DYN_ON_COMPLETE),
/* harmony export */   "_DYN_POLL_INTERNAL_LOGS": () => (/* binding */ _DYN_POLL_INTERNAL_LOGS),
/* harmony export */   "_DYN_PROCESS_NEXT": () => (/* binding */ _DYN_PROCESS_NEXT),
/* harmony export */   "_DYN_PUSH": () => (/* binding */ _DYN_PUSH),
/* harmony export */   "_DYN_RD_ONLY": () => (/* binding */ _DYN_RD_ONLY),
/* harmony export */   "_DYN_REMOVE_NOTIFICATION_2": () => (/* binding */ _DYN_REMOVE_NOTIFICATION_2),
/* harmony export */   "_DYN_REPLACE": () => (/* binding */ _DYN_REPLACE),
/* harmony export */   "_DYN_SET_CTX": () => (/* binding */ _DYN_SET_CTX),
/* harmony export */   "_DYN_SET_DF": () => (/* binding */ _DYN_SET_DF),
/* harmony export */   "_DYN_SET_NEXT_PLUGIN": () => (/* binding */ _DYN_SET_NEXT_PLUGIN),
/* harmony export */   "_DYN_SPAN_ID": () => (/* binding */ _DYN_SPAN_ID),
/* harmony export */   "_DYN_SPLICE": () => (/* binding */ _DYN_SPLICE),
/* harmony export */   "_DYN_SPLIT": () => (/* binding */ _DYN_SPLIT),
/* harmony export */   "_DYN_STOP_POLLING_INTERNA3": () => (/* binding */ _DYN_STOP_POLLING_INTERNA3),
/* harmony export */   "_DYN_TEARDOWN": () => (/* binding */ _DYN_TEARDOWN),
/* harmony export */   "_DYN_THROW_INTERNAL": () => (/* binding */ _DYN_THROW_INTERNAL),
/* harmony export */   "_DYN_TIME": () => (/* binding */ _DYN_TIME),
/* harmony export */   "_DYN_TO_LOWER_CASE": () => (/* binding */ _DYN_TO_LOWER_CASE),
/* harmony export */   "_DYN_TRACE_FLAGS": () => (/* binding */ _DYN_TRACE_FLAGS),
/* harmony export */   "_DYN_TRACE_ID": () => (/* binding */ _DYN_TRACE_ID),
/* harmony export */   "_DYN_TYPE": () => (/* binding */ _DYN_TYPE),
/* harmony export */   "_DYN_UNLOAD": () => (/* binding */ _DYN_UNLOAD),
/* harmony export */   "_DYN_UPDATE": () => (/* binding */ _DYN_UPDATE),
/* harmony export */   "_DYN_USER_AGENT": () => (/* binding */ _DYN_USER_AGENT),
/* harmony export */   "_DYN_VERSION": () => (/* binding */ _DYN_VERSION),
/* harmony export */   "_DYN_WARN_TO_CONSOLE": () => (/* binding */ _DYN_WARN_TO_CONSOLE),
/* harmony export */   "_DYN_WATCH": () => (/* binding */ _DYN_WATCH),
/* harmony export */   "_DYN__DO_TEARDOWN": () => (/* binding */ _DYN__DO_TEARDOWN)
/* harmony export */ });
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


// @skip-file-minify
// ##############################################################
// AUTO GENERATED FILE: This file is Auto Generated during build.
// ##############################################################
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Note: DON'T Export these const from the package as we are still targeting ES3 this will export a mutable variables that someone could change!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
var _DYN_TO_LOWER_CASE = "toLowerCase"; // Count: 9
var _DYN_BLK_VAL = "blkVal"; // Count: 5
var _DYN_LENGTH = "length"; // Count: 43
var _DYN_RD_ONLY = "rdOnly"; // Count: 4
var _DYN_NOTIFY = "notify"; // Count: 4
var _DYN_WARN_TO_CONSOLE = "warnToConsole"; // Count: 4
var _DYN_THROW_INTERNAL = "throwInternal"; // Count: 5
var _DYN_SET_DF = "setDf"; // Count: 6
var _DYN_WATCH = "watch"; // Count: 9
var _DYN_LOGGER = "logger"; // Count: 21
var _DYN_APPLY = "apply"; // Count: 7
var _DYN_PUSH = "push"; // Count: 31
var _DYN_SPLICE = "splice"; // Count: 8
var _DYN_HDLR = "hdlr"; // Count: 6
var _DYN_CANCEL = "cancel"; // Count: 5
var _DYN_INITIALIZE = "initialize"; // Count: 4
var _DYN_IDENTIFIER = "identifier"; // Count: 8
var _DYN_IS_INITIALIZED = "isInitialized"; // Count: 10
var _DYN_GET_PLUGIN = "getPlugin"; // Count: 6
var _DYN_POLL_INTERNAL_LOGS = "pollInternalLogs"; // Count: 2
var _DYN_NAME = "name"; // Count: 11
var _DYN_TIME = "time"; // Count: 6
var _DYN_PROCESS_NEXT = "processNext"; // Count: 15
var _DYN_GET_PROCESS_TEL_CONT0 = "getProcessTelContext"; // Count: 2
var _DYN_GET_NOTIFY_MGR = "getNotifyMgr"; // Count: 5
var _DYN_ADD_NOTIFICATION_LIS1 = "addNotificationListener"; // Count: 4
var _DYN_REMOVE_NOTIFICATION_2 = "removeNotificationListener"; // Count: 4
var _DYN_ENABLED = "enabled"; // Count: 6
var _DYN_STOP_POLLING_INTERNA3 = "stopPollingInternalLogs"; // Count: 2
var _DYN_UNLOAD = "unload"; // Count: 9
var _DYN_ON_COMPLETE = "onComplete"; // Count: 5
var _DYN_VERSION = "version"; // Count: 6
var _DYN_LOGGING_LEVEL_CONSOL4 = "loggingLevelConsole"; // Count: 2
var _DYN_CREATE_NEW = "createNew"; // Count: 7
var _DYN_TEARDOWN = "teardown"; // Count: 9
var _DYN_MESSAGE_ID = "messageId"; // Count: 4
var _DYN_MESSAGE = "message"; // Count: 6
var _DYN_IS_ASYNC = "isAsync"; // Count: 6
var _DYN_DIAG_LOG = "diagLog"; // Count: 10
var _DYN__DO_TEARDOWN = "_doTeardown"; // Count: 4
var _DYN_UPDATE = "update"; // Count: 6
var _DYN_GET_NEXT = "getNext"; // Count: 12
var _DYN_SET_NEXT_PLUGIN = "setNextPlugin"; // Count: 5
var _DYN_USER_AGENT = "userAgent"; // Count: 5
var _DYN_SPLIT = "split"; // Count: 6
var _DYN_NODE_TYPE = "nodeType"; // Count: 3
var _DYN_REPLACE = "replace"; // Count: 8
var _DYN_LOG_INTERNAL_MESSAGE = "logInternalMessage"; // Count: 2
var _DYN_TYPE = "type"; // Count: 14
var _DYN_HANDLER = "handler"; // Count: 5
var _DYN_IS_CHILD_EVT = "isChildEvt"; // Count: 3
var _DYN_GET_CTX = "getCtx"; // Count: 6
var _DYN_SET_CTX = "setCtx"; // Count: 10
var _DYN_COMPLETE = "complete"; // Count: 3
var _DYN_TRACE_ID = "traceId"; // Count: 5
var _DYN_SPAN_ID = "spanId"; // Count: 5
var _DYN_TRACE_FLAGS = "traceFlags"; // Count: 6
//# sourceMappingURL=__DynamicConstants.js.map

/***/ }),
/* 43 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "STR_CHANNELS": () => (/* binding */ STR_CHANNELS),
/* harmony export */   "STR_CORE": () => (/* binding */ STR_CORE),
/* harmony export */   "STR_CREATE_PERF_MGR": () => (/* binding */ STR_CREATE_PERF_MGR),
/* harmony export */   "STR_DISABLED": () => (/* binding */ STR_DISABLED),
/* harmony export */   "STR_DOMAIN": () => (/* binding */ STR_DOMAIN),
/* harmony export */   "STR_EMPTY": () => (/* binding */ STR_EMPTY),
/* harmony export */   "STR_EVENTS_DISCARDED": () => (/* binding */ STR_EVENTS_DISCARDED),
/* harmony export */   "STR_EVENTS_SEND_REQUEST": () => (/* binding */ STR_EVENTS_SEND_REQUEST),
/* harmony export */   "STR_EVENTS_SENT": () => (/* binding */ STR_EVENTS_SENT),
/* harmony export */   "STR_EXTENSIONS": () => (/* binding */ STR_EXTENSIONS),
/* harmony export */   "STR_EXTENSION_CONFIG": () => (/* binding */ STR_EXTENSION_CONFIG),
/* harmony export */   "STR_GET_PERF_MGR": () => (/* binding */ STR_GET_PERF_MGR),
/* harmony export */   "STR_NOT_DYNAMIC_ERROR": () => (/* binding */ STR_NOT_DYNAMIC_ERROR),
/* harmony export */   "STR_PATH": () => (/* binding */ STR_PATH),
/* harmony export */   "STR_PERF_EVENT": () => (/* binding */ STR_PERF_EVENT),
/* harmony export */   "STR_PRIORITY": () => (/* binding */ STR_PRIORITY),
/* harmony export */   "STR_PROCESS_TELEMETRY": () => (/* binding */ STR_PROCESS_TELEMETRY),
/* harmony export */   "UNDEFINED_VALUE": () => (/* binding */ UNDEFINED_VALUE)
/* harmony export */ });
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


// ###################################################################################################################################################
// Note: DON'T Export these const from the package as we are still targeting IE/ES5 this will export a mutable variables that someone could change ###
// ###################################################################################################################################################
var UNDEFINED_VALUE = undefined;
var STR_EMPTY = "";
var STR_CHANNELS = "channels";
var STR_CORE = "core";
var STR_CREATE_PERF_MGR = "createPerfMgr";
var STR_DISABLED = "disabled";
var STR_EXTENSION_CONFIG = "extensionConfig";
var STR_EXTENSIONS = "extensions";
var STR_PROCESS_TELEMETRY = "processTelemetry";
var STR_PRIORITY = "priority";
var STR_EVENTS_SENT = "eventsSent";
var STR_EVENTS_DISCARDED = "eventsDiscarded";
var STR_EVENTS_SEND_REQUEST = "eventsSendRequest";
var STR_PERF_EVENT = "perfEvent";
var STR_GET_PERF_MGR = "getPerfMgr";
var STR_DOMAIN = "domain";
var STR_PATH = "path";
var STR_NOT_DYNAMIC_ERROR = "Not dynamic - ";
//# sourceMappingURL=InternalConstants.js.map

/***/ }),
/* 44 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createCustomDomEvent": () => (/* binding */ createCustomDomEvent),
/* harmony export */   "dispatchEvent": () => (/* binding */ dispatchEvent),
/* harmony export */   "findMetaTag": () => (/* binding */ findMetaTag),
/* harmony export */   "findNamedServerTiming": () => (/* binding */ findNamedServerTiming),
/* harmony export */   "getConsole": () => (/* binding */ getConsole),
/* harmony export */   "getCrypto": () => (/* binding */ getCrypto),
/* harmony export */   "getIEVersion": () => (/* binding */ getIEVersion),
/* harmony export */   "getJSON": () => (/* binding */ getJSON),
/* harmony export */   "getLocation": () => (/* binding */ getLocation),
/* harmony export */   "getMsCrypto": () => (/* binding */ getMsCrypto),
/* harmony export */   "hasJSON": () => (/* binding */ hasJSON),
/* harmony export */   "isBeaconsSupported": () => (/* binding */ isBeaconsSupported),
/* harmony export */   "isFetchSupported": () => (/* binding */ isFetchSupported),
/* harmony export */   "isIE": () => (/* binding */ isIE),
/* harmony export */   "isReactNative": () => (/* binding */ isReactNative),
/* harmony export */   "isSafari": () => (/* binding */ isSafari),
/* harmony export */   "isXhrSupported": () => (/* binding */ isXhrSupported),
/* harmony export */   "sendCustomEvent": () => (/* binding */ sendCustomEvent),
/* harmony export */   "setEnableEnvMocks": () => (/* binding */ setEnableEnvMocks),
/* harmony export */   "useXDomainRequest": () => (/* binding */ useXDomainRequest)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(45);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(18);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(27);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(49);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(42);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(46);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(43);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */








/**
 * This file exists to hold environment utilities that are required to check and
 * validate the current operating environment. Unless otherwise required, please
 * only use defined methods (functions) in this class so that users of these
 * functions/properties only need to include those that are used within their own modules.
 */
var strDocumentMode = "documentMode";
var strLocation = "location";
var strConsole = "console";
var strJSON = "JSON";
var strCrypto = "crypto";
var strMsCrypto = "msCrypto";
var strReactNative = "ReactNative";
var strMsie = "msie";
var strTrident = "trident/";
var strXMLHttpRequest = "XMLHttpRequest";
var _isTrident = null;
var _navUserAgentCheck = null;
var _enableMocks = false;
var _useXDomainRequest = null;
var _beaconsSupported = null;
function _hasProperty(theClass, property) {
    var supported = false;
    if (theClass) {
        try {
            supported = property in theClass;
            if (!supported) {
                var proto = theClass[_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimPrototype];
                if (proto) {
                    supported = property in proto;
                }
            }
        }
        catch (e) {
            // Do Nothing
        }
        if (!supported) {
            try {
                var tmp = new theClass();
                supported = !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.isUndefined)(tmp[property]);
            }
            catch (e) {
                // Do Nothing
            }
        }
    }
    return supported;
}
/**
 * Enable the lookup of test mock objects if requested
 * @param enabled
 */
function setEnableEnvMocks(enabled) {
    _enableMocks = enabled;
}
/**
 * Returns the global location object if it is present otherwise null.
 * This helper is used to access the location object without causing an exception
 * "Uncaught ReferenceError: location is not defined"
 */
function getLocation(checkForMock) {
    if (checkForMock && _enableMocks) {
        var mockLocation = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)("__mockLocation");
        if (mockLocation) {
            return mockLocation;
        }
    }
    if (typeof location === _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimObject && location) {
        return location;
    }
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)(strLocation);
}
/**
 * Returns the global console object
 */
function getConsole() {
    if (typeof console !== _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimUndefined) {
        return console;
    }
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)(strConsole);
}
/**
 * Checks if JSON object is available, this is required as we support the API running without a
 * window /document (eg. Node server, electron webworkers) and if we attempt to assign a history
 * object to a local variable or pass as an argument an "Uncaught ReferenceError: JSON is not defined"
 * exception will be thrown.
 * Defined as a function to support lazy / late binding environments.
 */
function hasJSON() {
    return Boolean((typeof JSON === _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimObject && JSON) || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)(strJSON) !== null);
}
/**
 * Returns the global JSON object if it is present otherwise null.
 * This helper is used to access the JSON object without causing an exception
 * "Uncaught ReferenceError: JSON is not defined"
 */
function getJSON() {
    if (hasJSON()) {
        return JSON || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)(strJSON);
    }
    return null;
}
/**
 * Returns the crypto object if it is present otherwise null.
 * This helper is used to access the crypto object from the current
 * global instance which could be window or globalThis for a web worker
 */
function getCrypto() {
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)(strCrypto);
}
/**
 * Returns the crypto object if it is present otherwise null.
 * This helper is used to access the crypto object from the current
 * global instance which could be window or globalThis for a web worker
 */
function getMsCrypto() {
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)(strMsCrypto);
}
/**
 * Returns whether the environment is reporting that we are running in a React Native Environment
 */
function isReactNative() {
    // If running in React Native, navigator.product will be populated
    var nav = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getNavigator)();
    if (nav && nav.product) {
        return nav.product === strReactNative;
    }
    return false;
}
/**
 * Identifies whether the current environment appears to be IE
 */
function isIE() {
    var nav = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getNavigator)();
    if (nav && (nav[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_USER_AGENT /* @min:%2euserAgent */] !== _navUserAgentCheck || _isTrident === null)) {
        // Added to support test mocking of the user agent
        _navUserAgentCheck = nav[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_USER_AGENT /* @min:%2euserAgent */];
        var userAgent = (_navUserAgentCheck || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]();
        _isTrident = ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_5__.strContains)(userAgent, strMsie) || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_5__.strContains)(userAgent, strTrident));
    }
    return _isTrident;
}
/**
 * Gets IE version returning the document emulation mode if we are running on IE, or null otherwise
 */
function getIEVersion(userAgentStr) {
    if (userAgentStr === void 0) { userAgentStr = null; }
    if (!userAgentStr) {
        var navigator_1 = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getNavigator)() || {};
        userAgentStr = navigator_1 ? (navigator_1.userAgent || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]() : _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY;
    }
    var ua = (userAgentStr || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]();
    // Also check for documentMode in case X-UA-Compatible meta tag was included in HTML.
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_5__.strContains)(ua, strMsie)) {
        var doc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getDocument)() || {};
        return Math.max(parseInt(ua[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SPLIT /* @min:%2esplit */](strMsie)[1]), (doc[strDocumentMode] || 0));
    }
    else if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_5__.strContains)(ua, strTrident)) {
        var tridentVer = parseInt(ua[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SPLIT /* @min:%2esplit */](strTrident)[1]);
        if (tridentVer) {
            return tridentVer + 4;
        }
    }
    return null;
}
function isSafari(userAgentStr) {
    if (!userAgentStr || !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.isString)(userAgentStr)) {
        var navigator_2 = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getNavigator)() || {};
        userAgentStr = navigator_2 ? (navigator_2.userAgent || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]() : _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY;
    }
    var ua = (userAgentStr || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]();
    return ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.strIndexOf)(ua, "safari") >= 0);
}
/**
 * Checks if HTML5 Beacons are supported in the current environment.
 * @param useCached - [Optional] used for testing to bypass the cached lookup, when `true` this will
 * cause the cached global to be reset.
 * @returns True if supported, false otherwise.
 */
function isBeaconsSupported(useCached) {
    if (_beaconsSupported === null || useCached === false) {
        _beaconsSupported = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.hasNavigator)() && Boolean((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getNavigator)().sendBeacon);
    }
    return _beaconsSupported;
}
/**
 * Checks if the Fetch API is supported in the current environment.
 * @param withKeepAlive - [Optional] If True, check if fetch is available and it supports the keepalive feature, otherwise only check if fetch is supported
 * @returns True if supported, otherwise false
 */
function isFetchSupported(withKeepAlive) {
    var isSupported = false;
    try {
        isSupported = !!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)("fetch");
        var request = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)("Request");
        if (isSupported && withKeepAlive && request) {
            isSupported = _hasProperty(request, "keepalive");
        }
    }
    catch (e) {
        // Just Swallow any failure during availability checks
    }
    return isSupported;
}
function useXDomainRequest() {
    if (_useXDomainRequest === null) {
        _useXDomainRequest = (typeof XDomainRequest !== _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimUndefined);
        if (_useXDomainRequest && isXhrSupported()) {
            _useXDomainRequest = _useXDomainRequest && !_hasProperty((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)(strXMLHttpRequest), "withCredentials");
        }
    }
    return _useXDomainRequest;
}
/**
 * Checks if XMLHttpRequest is supported
 * @returns True if supported, otherwise false
 */
function isXhrSupported() {
    var isSupported = false;
    try {
        var xmlHttpRequest = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)(strXMLHttpRequest);
        isSupported = !!xmlHttpRequest;
    }
    catch (e) {
        // Just Swallow any failure during availability checks
    }
    return isSupported;
}
function _getNamedValue(values, name) {
    if (values) {
        for (var i = 0; i < values[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LENGTH /* @min:%2elength */]; i++) {
            var value = values[i];
            if (value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_NAME /* @min:%2ename */]) {
                if (value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_NAME /* @min:%2ename */] === name) {
                    return value;
                }
            }
        }
    }
    return {};
}
/**
 * Helper function to fetch the named meta-tag from the page.
 * @param name
 */
function findMetaTag(name) {
    var doc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getDocument)();
    if (doc && name) {
        // Look for a meta-tag
        return _getNamedValue(doc.querySelectorAll("meta"), name).content;
    }
    return null;
}
/**
 * Helper function to fetch the named server timing value from the page response (first navigation event).
 * @param name
 */
function findNamedServerTiming(name) {
    var value;
    var perf = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.getPerformance)();
    if (perf) {
        // Try looking for a server-timing header
        var navPerf = perf.getEntriesByType("navigation") || [];
        value = _getNamedValue((navPerf[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LENGTH /* @min:%2elength */] > 0 ? navPerf[0] : {}).serverTiming, name).description;
    }
    return value;
}
// TODO: should reuse this method for analytics plugin
function dispatchEvent(target, evnt) {
    if (target && target.dispatchEvent && evnt) {
        target.dispatchEvent(evnt);
        return true;
    }
    return false;
}
function createCustomDomEvent(eventName, details) {
    var event = null;
    var detail = { detail: details || null };
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.isFunction)(CustomEvent)) { // Use CustomEvent constructor when available
        event = new CustomEvent(eventName, detail);
    }
    else { // CustomEvent has no constructor in IE
        var doc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getDocument)();
        if (doc && doc.createEvent) {
            event = doc.createEvent("CustomEvent");
            event.initCustomEvent(eventName, true, true, detail);
        }
    }
    return event;
}
function sendCustomEvent(evtName, cfg, customDetails) {
    var global = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getGlobal)();
    if (global && global.CustomEvent) {
        try {
            var details = { cfg: cfg || null, customDetails: customDetails || null };
            return dispatchEvent(global, createCustomDomEvent(evtName, details));
        }
        catch (e) {
            // eslint-disable-next-line no-empty
        }
    }
    return false;
}
//# sourceMappingURL=EnvUtils.js.map

/***/ }),
/* 45 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ObjClass": () => (/* binding */ ObjClass),
/* harmony export */   "ObjProto": () => (/* binding */ ObjProto),
/* harmony export */   "strDefault": () => (/* binding */ strDefault),
/* harmony export */   "strShimFunction": () => (/* binding */ strShimFunction),
/* harmony export */   "strShimObject": () => (/* binding */ strShimObject),
/* harmony export */   "strShimPrototype": () => (/* binding */ strShimPrototype),
/* harmony export */   "strShimUndefined": () => (/* binding */ strShimUndefined)
/* harmony export */ });
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var strShimFunction = "function";
var strShimObject = "object";
var strShimUndefined = "undefined";
var strShimPrototype = "prototype";
var strDefault = "default";
var ObjClass = Object;
var ObjProto = ObjClass[strShimPrototype];
//# sourceMappingURL=Constants.js.map

/***/ }),
/* 46 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_getObjProto": () => (/* binding */ _getObjProto),
/* harmony export */   "asString": () => (/* binding */ asString),
/* harmony export */   "createClassFromInterface": () => (/* binding */ createClassFromInterface),
/* harmony export */   "deepFreeze": () => (/* binding */ deepFreeze),
/* harmony export */   "getExceptionName": () => (/* binding */ getExceptionName),
/* harmony export */   "getSetValue": () => (/* binding */ getSetValue),
/* harmony export */   "isFeatureEnabled": () => (/* binding */ isFeatureEnabled),
/* harmony export */   "isNotNullOrUndefined": () => (/* binding */ isNotNullOrUndefined),
/* harmony export */   "isNotUndefined": () => (/* binding */ isNotUndefined),
/* harmony export */   "normalizeJsName": () => (/* binding */ normalizeJsName),
/* harmony export */   "objExtend": () => (/* binding */ objExtend),
/* harmony export */   "optimizeObject": () => (/* binding */ optimizeObject),
/* harmony export */   "proxyAssign": () => (/* binding */ proxyAssign),
/* harmony export */   "proxyFunctionAs": () => (/* binding */ proxyFunctionAs),
/* harmony export */   "proxyFunctions": () => (/* binding */ proxyFunctions),
/* harmony export */   "setValue": () => (/* binding */ setValue),
/* harmony export */   "strContains": () => (/* binding */ strContains),
/* harmony export */   "toISOString": () => (/* binding */ toISOString)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(33);
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(45);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(25);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(22);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(28);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(24);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(47);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(12);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(43);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






// RESTRICT and AVOID circular dependencies you should not import other contained modules or export the contents of this file directly
// Added to help with minification
var strGetPrototypeOf = "getPrototypeOf";
var rCamelCase = /-([a-z])/g;
var rNormalizeInvalid = /([^\w\d_$])/g;
var rLeadingNumeric = /^(\d+[\w\d_$])/;
var _getObjProto = Object[strGetPrototypeOf];
function isNotUndefined(value) {
    return !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isUndefined)(value);
}
function isNotNullOrUndefined(value) {
    return !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(value);
}
/**
 * Validates that the string name conforms to the JS IdentifierName specification and if not
 * normalizes the name so that it would. This method does not identify or change any keywords
 * meaning that if you pass in a known keyword the same value will be returned.
 * This is a simplified version
 * @param name - The name to validate
 */
function normalizeJsName(name) {
    var value = name;
    if (value && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isString)(value)) {
        // CamelCase everything after the "-" and remove the dash
        value = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_REPLACE /* @min:%2ereplace */](rCamelCase, function (_all, letter) {
            return letter.toUpperCase();
        });
        value = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_REPLACE /* @min:%2ereplace */](rNormalizeInvalid, "_");
        value = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_REPLACE /* @min:%2ereplace */](rLeadingNumeric, function (_all, match) {
            return "_" + match;
        });
    }
    return value;
}
/**
 * A simple wrapper (for minification support) to check if the value contains the search string.
 * @param value - The string value to check for the existence of the search value
 * @param search - The value search within the value
 */
function strContains(value, search) {
    if (value && search) {
        return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.strIndexOf)(value, search) !== -1;
    }
    return false;
}
/**
 * Convert a date to I.S.O. format in IE8
 */
function toISOString(date) {
    return date && date.toISOString() || "";
}
var deepFreeze = _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.objDeepFreeze;
/**
 * Returns the name of object if it's an Error. Otherwise, returns empty string.
 */
function getExceptionName(object) {
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isError)(object)) {
        return object[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:%2ename */];
    }
    return _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY;
}
/**
 * Sets the provided value on the target instance using the field name when the provided chk function returns true, the chk
 * function will only be called if the new value is no equal to the original value.
 * @param target - The target object
 * @param field - The key of the target
 * @param value - The value to set
 * @param valChk - [Optional] Callback to check the value that if supplied will be called check if the new value can be set
 * @param srcChk - [Optional] Callback to check to original value that if supplied will be called if the new value should be set (if allowed)
 * @returns The existing or new value, depending what was set
 */
function setValue(target, field, value, valChk, srcChk) {
    var theValue = value;
    if (target) {
        theValue = target[field];
        if (theValue !== value && (!srcChk || srcChk(theValue)) && (!valChk || valChk(value))) {
            theValue = value;
            target[field] = theValue;
        }
    }
    return theValue;
}
/**
 * Returns the current value from the target object if not null or undefined otherwise sets the new value and returns it
 * @param target - The target object to return or set the default value
 * @param field - The key for the field to set on the target
 * @param defValue - [Optional] The value to set if not already present, when not provided a empty object will be added
 */
function getSetValue(target, field, defValue) {
    var theValue;
    if (target) {
        theValue = target[field];
        if (!theValue && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(theValue)) {
            // Supports having the default as null
            theValue = !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isUndefined)(defValue) ? defValue : {};
            target[field] = theValue;
        }
    }
    else {
        // Expanded for performance so we only check defValue if required
        theValue = !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isUndefined)(defValue) ? defValue : {};
    }
    return theValue;
}
function _createProxyFunction(source, funcName) {
    var srcFunc = null;
    var src = null;
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isFunction)(source)) {
        srcFunc = source;
    }
    else {
        src = source;
    }
    return function () {
        // Capture the original arguments passed to the method
        var originalArguments = arguments;
        if (srcFunc) {
            src = srcFunc();
        }
        if (src) {
            return src[funcName][_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_APPLY /* @min:%2eapply */](src, originalArguments);
        }
    };
}
/**
 * Effectively assigns all enumerable properties (not just own properties) and functions (including inherited prototype) from
 * the source object to the target, it attempts to use proxy getters / setters (if possible) and proxy functions to avoid potential
 * implementation issues by assigning prototype functions as instance ones
 *
 * This method is the primary method used to "update" the snippet proxy with the ultimate implementations.
 *
 * Special ES3 Notes:
 * Updates (setting) of direct property values on the target or indirectly on the source object WILL NOT WORK PROPERLY, updates to the
 * properties of "referenced" object will work (target.context.newValue = 10 => will be reflected in the source.context as it's the
 * same object). ES3 Failures: assigning target.myProp = 3 -> Won't change source.myProp = 3, likewise the reverse would also fail.
 * @param target - The target object to be assigned with the source properties and functions
 * @param source - The source object which will be assigned / called by setting / calling the targets proxies
 * @param chkSet - An optional callback to determine whether a specific property/function should be proxied
 */
function proxyAssign(target, source, chkSet) {
    if (target && source && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isObject)(target) && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isObject)(source)) {
        var _loop_1 = function (field) {
            if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isString)(field)) {
                var value = source[field];
                if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isFunction)(value)) {
                    if (!chkSet || chkSet(field, true, source, target)) {
                        // Create a proxy function rather than just copying the (possible) prototype to the new object as an instance function
                        target[field] = _createProxyFunction(source, field);
                    }
                }
                else if (!chkSet || chkSet(field, false, source, target)) {
                    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objHasOwn)(target, field)) {
                        // Remove any previous instance property
                        delete target[field];
                    }
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objDefine)(target, field, {
                        g: function () {
                            return source[field];
                        },
                        s: function (theValue) {
                            source[field] = theValue;
                        }
                    });
                }
            }
        };
        // effectively apply/proxy full source to the target instance
        for (var field in source) {
            _loop_1(field);
        }
    }
    return target;
}
/**
 * Creates a proxy function on the target which internally will call the source version with all arguments passed to the target method.
 *
 * @param target - The target object to be assigned with the source properties and functions
 * @param name - The function name that will be added on the target
 * @param source - The source object which will be assigned / called by setting / calling the targets proxies
 * @param theFunc - The function name on the source that will be proxied on the target
 * @param overwriteTarget - If `false` this will not replace any pre-existing name otherwise (the default) it will overwrite any existing name
 */
function proxyFunctionAs(target, name, source, theFunc, overwriteTarget) {
    if (target && name && source) {
        if (overwriteTarget !== false || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isUndefined)(target[name])) {
            target[name] = _createProxyFunction(source, theFunc);
        }
    }
}
/**
 * Creates proxy functions on the target which internally will call the source version with all arguments passed to the target method.
 *
 * @param target - The target object to be assigned with the source properties and functions
 * @param source - The source object which will be assigned / called by setting / calling the targets proxies
 * @param functionsToProxy - An array of function names that will be proxied on the target
 * @param overwriteTarget - If false this will not replace any pre-existing name otherwise (the default) it will overwrite any existing name
 */
function proxyFunctions(target, source, functionsToProxy, overwriteTarget) {
    if (target && source && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isObject)(target) && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isArray)(functionsToProxy)) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.arrForEach)(functionsToProxy, function (theFuncName) {
            if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isString)(theFuncName)) {
                proxyFunctionAs(target, theFuncName, source, theFuncName, overwriteTarget);
            }
        });
    }
    return target;
}
/**
 * Simpler helper to create a dynamic class that implements the interface and populates the values with the defaults.
 * Only instance properties (hasOwnProperty) values are copied from the defaults to the new instance
 * @param defaults - Simple helper
 */
function createClassFromInterface(defaults) {
    return /** @class */ (function () {
        function class_1() {
            var _this = this;
            if (defaults) {
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__.objForEachKey)(defaults, function (field, value) {
                    _this[field] = value;
                });
            }
        }
        return class_1;
    }());
}
/**
 * A helper function to assist with JIT performance for objects that have properties added / removed dynamically
 * this is primarily for chromium based browsers and has limited effects on Firefox and none of IE. Only call this
 * function after you have finished "updating" the object, calling this within loops reduces or defeats the benefits.
 * This helps when iterating using for..in, objKeys() and objForEach()
 * @param theObject - The object to be optimized if possible
 */
function optimizeObject(theObject) {
    // V8 Optimization to cause the JIT compiler to create a new optimized object for looking up the own properties
    // primarily for object with <= 19 properties for >= 20 the effect is reduced or non-existent
    if (theObject && _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.objAssign) {
        theObject = (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_9__.ObjClass)((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.objAssign)({}, theObject));
    }
    return theObject;
}
function objExtend(obj1, obj2, obj3, obj4, obj5, obj6) {
    // Variables
    var theArgs = arguments;
    var extended = theArgs[0] || {};
    var argLen = theArgs[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */];
    var deep = false;
    var idx = 1;
    // Check for "Deep" flag
    if (argLen > 0 && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isBoolean)(extended)) {
        deep = extended;
        extended = theArgs[idx] || {};
        idx++;
    }
    // Handle case when target is a string or something (possible in deep copy)
    if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isObject)(extended)) {
        extended = {};
    }
    // Loop through each remaining object and conduct a merge
    for (; idx < argLen; idx++) {
        var arg = theArgs[idx];
        var isArgArray = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isArray)(arg);
        var isArgObj = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isObject)(arg);
        for (var prop in arg) {
            var propOk = (isArgArray && (prop in arg)) || (isArgObj && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objHasOwn)(arg, prop));
            if (!propOk) {
                continue;
            }
            var newValue = arg[prop];
            var isNewArray = void 0;
            // If deep merge and property is an object, merge properties
            if (deep && newValue && ((isNewArray = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isArray)(newValue)) || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__.isPlainObject)(newValue))) {
                // Grab the current value of the extended object
                var clone = extended[prop];
                if (isNewArray) {
                    if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isArray)(clone)) {
                        // We can't "merge" an array with a non-array so overwrite the original
                        clone = [];
                    }
                }
                else if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__.isPlainObject)(clone)) {
                    // We can't "merge" an object with a non-object
                    clone = {};
                }
                // Never move the original objects always clone them
                newValue = objExtend(deep, clone, newValue);
            }
            // Assign the new (or previous) value (unless undefined)
            if (newValue !== undefined) {
                extended[prop] = newValue;
            }
        }
    }
    return extended;
}
var asString = _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__.asString;
function isFeatureEnabled(feature, cfg) {
    var rlt = false;
    var ft = cfg && cfg.featureOptIn && cfg.featureOptIn[feature];
    if (feature && ft) {
        var mode = ft.mode;
        // NOTE: None will be considered as true
        rlt = (mode == 3 /* FeatureOptInMode.enable */) || (mode == 1 /* FeatureOptInMode.none */);
    }
    return rlt;
}
//# sourceMappingURL=HelperFuncs.js.map

/***/ }),
/* 47 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isPlainObject": () => (/* binding */ isPlainObject)
/* harmony export */ });
/* harmony import */ var _funcs_fnCall__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(48);
/* harmony import */ var _helpers_environment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/* harmony import */ var _has_own_prop__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26);
/* harmony import */ var _object__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(33);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */





// Use to cache the result of Object.cont
var _fnToString;
var _objCtrFnString;
var _gblWindow;
/**
 * Checks to see if the past value is a plain object (not a class/array) value.
 * Object are considered to be "plain" if they are created with no prototype `Object.create(null)`
 * or by using the Object global (native) function, all other "objects" ar
 * @since 0.4.4
 * @group Type Identity
 * @group Object
 * @param value - The value to check
 * @returns true if `value` is a normal plain object
 * @example
 * ```ts
 * console.log(isPlainObject({ 0: 'a', 1: 'b', 2: 'c' }));      // true
 * console.log(isPlainObject({ 100: 'a', 2: 'b', 7: 'c' }));    // true
 * console.log(isPlainObject(objCreate(null)));                 // true
 *
 * const myObj = objCreate({}, {
 *   getFoo: {
 *     value() { return this.foo; }
 *   }
 * });
 * myObj.foo = 1;
 * console.log(isPlainObject(myObj));                   // true
 *
 * console.log(isPlainObject(['a', 'b', 'c']));         // false
 * console.log(isPlainObject(new Date()));              // false
 * console.log(isPlainObject(new Error("An Error")));   // false
 * console.log(isPlainObject(null));                    // false
 * console.log(isPlainObject(undefined));               // false
 * console.log(isPlainObject("null"));                  // false
 * console.log(isPlainObject("undefined"));             // false
 * console.log(isPlainObject("1"));                     // false
 * console.log(isPlainObject("aa"));                    // false
 * ```
 */
function isPlainObject(value) {
    if (!value || typeof value !== _internal_constants__WEBPACK_IMPORTED_MODULE_0__.OBJECT) {
        return false;
    }
    if (!_gblWindow) {
        // Lazily cache the current global window value and default it to "true" (so we bypass this check in the future)
        _gblWindow = (0,_helpers_environment__WEBPACK_IMPORTED_MODULE_1__.hasWindow)() ? (0,_helpers_environment__WEBPACK_IMPORTED_MODULE_1__.getWindow)() : true;
    }
    var result = false;
    if (value !== _gblWindow) {
        if (!_objCtrFnString) {
            // Lazily caching what the runtime reports as the object function constructor (as a string)
            // Using an current function lookup to find what this runtime calls a "native" function
            _fnToString = Function[_internal_constants__WEBPACK_IMPORTED_MODULE_0__.PROTOTYPE].toString;
            _objCtrFnString = (0,_funcs_fnCall__WEBPACK_IMPORTED_MODULE_2__.fnCall)(_fnToString, _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass);
        }
        try {
            var proto = (0,_object__WEBPACK_IMPORTED_MODULE_3__.objGetPrototypeOf)(value);
            // No prototype so looks like an object created with Object.create(null)
            result = !proto;
            if (!result) {
                if ((0,_has_own_prop__WEBPACK_IMPORTED_MODULE_4__.objHasOwnProperty)(proto, _internal_constants__WEBPACK_IMPORTED_MODULE_0__.CONSTRUCTOR)) {
                    proto = proto[_internal_constants__WEBPACK_IMPORTED_MODULE_0__.CONSTRUCTOR];
                }
                result = proto && typeof proto === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.FUNCTION && _fnToString.call(proto) === _objCtrFnString;
            }
        }
        catch (ex) {
            // Something went wrong, so it's not an object we are playing with
        }
    }
    return result;
}
//# sourceMappingURL=is_plain_object.js.map

/***/ }),
/* 48 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "fnCall": () => (/* binding */ fnCall)
/* harmony export */ });
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2023 Nevware21
 * Licensed under the MIT license.
 */

/**
 * The `fnCall` function calls the function with the given `thisArg` as the `this` value and with
 * al of the `_args` provided as it's `arguments.
 *
 * > This is almost identical to `fnApply`, except that the function arguments are passed to `fnCall`
 * individually as a list, while with `fnApply` that are combined into a single array argument.
 *
 * Normally, when calling a function, the value of `this` inside the function is the object that the
 * function was accessed on. With `fnCall()`, you can pass an arbitrary value as the `this` when calling an
 * existing function, without first attaching the function to the object as a property. This allows you
 * to use methods of one object as generic utility functions.
 *
 * @since 0.9.8
 * @group Function
 *
 * @param fn - The function to be called
 * @param thisArg - The value of `this` provided for the call to `fn`. If the function is not in strict mode,
 * `null` and `undefined` will be replaced with the global object, and primitive values will be converted to objects.
 * @param _args - The zero or more arguments to be passed to the `fn` function.
 * @returns The result of calling the function with the specified `this` value and arguments.
 * @example
 * ```ts
 * // min / max number in an array
 * let max = fnCall(Math.max, null, 21, 42, 84, 168, 7, 3);
 * // 168
 *
 * let min = fnCall(Math.min, null, 21, 42, 84, 168, 7, 3);
 * // 3
 *
 * const module1 = {
 *     prefix: "Hello",
 *     x: 21,
 *     getX() {
 *         return this.x;
 *     },
 *     log(value: string) {
 *         return this.prefix + " " + value + " : " + this.x
 *     }
 * };
 *
 * // The 'this' parameter of 'getX' is bound to 'module'.
 * module1.getX(); // 21
 * module1.log("Darkness"); // Hello Darkness : 21
 *
 * // Create a new function 'boundGetX' with the 'this' parameter bound to 'module'.
 * let module2 = {
 *     prefix: "my",
 *     x: 42
 * };
 *
 * // Call the function of module1 with module2 as it's this
 * fnCall(module1.getX, module2); // 42
 * fnCall(module1.log, module2, "friend"); // my friend : 42
 * ```
 */
var fnCall = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapInstFunction)("call");
//# sourceMappingURL=fnCall.js.map

/***/ }),
/* 49 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "elapsedTime": () => (/* binding */ elapsedTime),
/* harmony export */   "getPerformance": () => (/* binding */ getPerformance),
/* harmony export */   "hasPerformance": () => (/* binding */ hasPerformance),
/* harmony export */   "perfNow": () => (/* binding */ perfNow)
/* harmony export */ });
/* harmony import */ var _date__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(50);
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18);
/* harmony import */ var _lazy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */



var _perf;
/**
 * Identify whether the runtimne contains a `performance` object
 *
 * @since 0.4.4
 * @group Environment
 * @returns
 */
function hasPerformance() {
    return !!getPerformance();
}
/**
 * Returns the global `performance` Object if available, which can be used to
 * gather performance information about the current document. It serves as the
 * point of exposure for the Performance Timeline API, the High Resolution Time
 * API, the Navigation Timing API, the User Timing API, and the Resource Timing API.
 *
 * @since 0.4.4
 * @group Environment
 * @returns The global performance object if available.
 */
function getPerformance() {
    (!_perf || (!_perf.b && _lazy__WEBPACK_IMPORTED_MODULE_0__._globalLazyTestHooks && _lazy__WEBPACK_IMPORTED_MODULE_0__._globalLazyTestHooks.lzy)) && (_perf = (0,_environment__WEBPACK_IMPORTED_MODULE_1__.lazySafeGetInst)("performance"));
    return _perf.v;
}
/**
 * Returns the number of milliseconds that has elapsed since the time origin, if
 * the runtime does not support the `performance` API it will fallback to return
 * the number of milliseconds since the unix epoch.
 *
 * @since 0.4.4
 * @group Timer
 *
 * @returns The number of milliseconds as a `DOMHighResTimeStamp` double value or
 * an integer depending on the runtime.
 * @example
 * ```ts
 * let now = perfNow();
 * ```
 */
function perfNow() {
    var perf = getPerformance();
    if (perf && perf.now) {
        return perf.now();
    }
    return (0,_date__WEBPACK_IMPORTED_MODULE_2__.utcNow)();
}
/**
 * Return the number of milliseconds that have elapsed since the provided `startTime`
 * the `startTime` MUST be obtained from {@link perfNow} to ensure the correct elapsed
 * value is returned.
 *
 * @since 0.4.4
 * @group Timer
 *
 * @param startTime - The startTime obtained from `perfNow`
 * @returns The number of milliseconds that have elapsed since the startTime.
 * @example
 * ```ts
 * let start = perfNow();
 * // Do some work
 * let totalTime = elapsedTime(start);
 * ```
 */
function elapsedTime(startTime) {
    return perfNow() - startTime;
}
//# sourceMappingURL=perf.js.map

/***/ }),
/* 50 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "polyUtcNow": () => (/* binding */ polyUtcNow),
/* harmony export */   "utcNow": () => (/* binding */ utcNow)
/* harmony export */ });
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
/**
 * Return the number of milliseconds that have elapsed since January 1, 1970 00:00:00 UTC.
 *
 * To offer protection against timing attacks and fingerprinting, the precision of dateNow()
 * might get rounded depending on browser settings. In Firefox, the privacy.reduceTimerPrecision
 * preference is enabled by default and defaults to 20µs in Firefox 59; in 60 it will be 2ms.
 *
 * @since 0.4.4
 * @group Timer
 *
 * @returns A Number representing the milliseconds elapsed since the UNIX epoch.
 * @example
 * ```ts
 * let now = utcNow();
 * ```
 */
function utcNow() {
    return (Date.now || polyUtcNow)();
}
/**
 * Polyfill fallback to return the number of milliseconds that have elapsed since January 1, 1970 00:00:00 UTC.
 *
 * To offer protection against timing attacks and fingerprinting, the precision of dateNow()
 * might get rounded depending on browser settings. In Firefox, the privacy.reduceTimerPrecision
 * preference is enabled by default and defaults to 20µs in Firefox 59; in 60 it will be 2ms.
 *
 * @since 0.4.4
 * @group Timer
 * @group Polyfill
 *
 * @returns A Number representing the milliseconds elapsed since the UNIX epoch.
  * @example
 * ```ts
 * let now = polyUtcNow();
 * ```
*/
function polyUtcNow() {
    return new Date().getTime();
}
//# sourceMappingURL=date.js.map

/***/ }),
/* 51 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ dynamicProto)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11);
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var _a;

;
var UNDEFINED = "undefined";
/**
 * Constant string defined to support minimization
 * @ignore
 */
var Constructor = 'constructor';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var Prototype = 'prototype';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var strFunction = 'function';
/**
 * Used to define the name of the instance function lookup table
 * @ignore
 */
var DynInstFuncTable = '_dynInstFuncs';
/**
 * Name used to tag the dynamic prototype function
 * @ignore
 */
var DynProxyTag = '_isDynProxy';
/**
 * Name added to a prototype to define the dynamic prototype "class" name used to lookup the function table
 * @ignore
 */
var DynClassName = '_dynClass';
/**
 * Prefix added to the classname to avoid any name clashes with other instance level properties
 * @ignore
 */
var DynClassNamePrefix = '_dynCls$';
/**
 * A tag which is used to check if we have already to attempted to set the instance function if one is not present
 * @ignore
 */
var DynInstChkTag = '_dynInstChk';
/**
 * A tag which is used to check if we are allows to try and set an instance function is one is not present. Using the same
 * tag name as the function level but a different const name for readability only.
 */
var DynAllowInstChkTag = DynInstChkTag;
/**
 * The global (imported) instances where the global performance options are stored
 */
var DynProtoDefaultOptions = '_dfOpts';
/**
 * Value used as the name of a class when it cannot be determined
 * @ignore
 */
var UnknownValue = '_unknown_';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var str__Proto = "__proto__";
/**
 * The polyfill version of __proto__ so that it doesn't cause issues for anyone not expecting it to exist
 */
var DynProtoBaseProto = "_dyn" + str__Proto;
/**
 * Runtime Global holder for dynamicProto settings
 */
var DynProtoGlobalSettings = "__dynProto$Gbl";
/**
 * Track the current prototype for IE8 as you can't look back to get the prototype
 */
var DynProtoCurrent = "_dynInstProto";
/**
 * Constant string defined to support minimization
 * @ignore
 */
var strUseBaseInst = 'useBaseInst';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var strSetInstFuncs = 'setInstFuncs';
var Obj = Object;
/**
 * Pre-lookup to check if we are running on a modern browser (i.e. not IE8)
 * @ignore
 */
var _objGetPrototypeOf = Obj["getPrototypeOf"];
/**
 * Pre-lookup to check for the existence of this function
 */
var _objGetOwnProps = Obj["getOwnPropertyNames"];
// Since 1.1.7 moving these to the runtime global to work around mixed version and module issues
// See Issue https://github.com/microsoft/DynamicProto-JS/issues/57 for details
var _gbl = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.getGlobal)();
var _gblInst = _gbl[DynProtoGlobalSettings] || (_gbl[DynProtoGlobalSettings] = {
    o: (_a = {},
        _a[strSetInstFuncs] = true,
        _a[strUseBaseInst] = true,
        _a),
    n: 1000 // Start new global index @ 1000 so we "fix" some cases when mixed with 1.1.6 or earlier
});
/**
 * Helper used to check whether the target is an Object prototype or Array prototype
 * @ignore
 */
function _isObjectOrArrayPrototype(target) {
    return target && (target === Obj[Prototype] || target === Array[Prototype]);
}
/**
 * Helper used to check whether the target is an Object prototype, Array prototype or Function prototype
 * @ignore
 */
function _isObjectArrayOrFunctionPrototype(target) {
    return _isObjectOrArrayPrototype(target) || target === Function[Prototype];
}
/**
 * Helper used to get the prototype of the target object as getPrototypeOf is not available in an ES3 environment.
 * @ignore
 */
function _getObjProto(target) {
    var newProto;
    if (target) {
        // This method doesn't exist in older browsers (e.g. IE8)
        if (_objGetPrototypeOf) {
            return _objGetPrototypeOf(target);
        }
        var curProto = target[str__Proto] || target[Prototype] || (target[Constructor] ? target[Constructor][Prototype] : null);
        // Using the pre-calculated value as IE8 doesn't support looking up the prototype of a prototype and thus fails for more than 1 base class
        newProto = target[DynProtoBaseProto] || curProto;
        if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(target, DynProtoBaseProto)) {
            // As this prototype doesn't have this property then this is from an inherited class so newProto is the base to return so save it
            // so we can look it up value (which for a multiple hierarchy dynamicProto will be the base class)
            delete target[DynProtoCurrent]; // Delete any current value allocated to this instance so we pick up the value from prototype hierarchy
            newProto = target[DynProtoBaseProto] = target[DynProtoCurrent] || target[DynProtoBaseProto];
            target[DynProtoCurrent] = curProto;
        }
    }
    return newProto;
}
/**
 * Helper to get the properties of an object, including none enumerable ones as functions on a prototype in ES6
 * are not enumerable.
 * @param target
 */
function _forEachProp(target, func) {
    var props = [];
    if (_objGetOwnProps) {
        props = _objGetOwnProps(target);
    }
    else {
        for (var name_1 in target) {
            if (typeof name_1 === "string" && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(target, name_1)) {
                props.push(name_1);
            }
        }
    }
    if (props && props.length > 0) {
        for (var lp = 0; lp < props.length; lp++) {
            func(props[lp]);
        }
    }
}
/**
 * Helper function to check whether the provided function name is a potential candidate for dynamic
 * callback and prototype generation.
 * @param target The target object, may be a prototype or class object
 * @param funcName The function name
 * @param skipOwn Skips the check for own property
 * @ignore
 */
function _isDynamicCandidate(target, funcName, skipOwn) {
    return (funcName !== Constructor && typeof target[funcName] === strFunction && (skipOwn || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(target, funcName)));
}
/**
 * Helper to throw a TypeError exception
 * @param message the message
 * @ignore
 */
function _throwTypeError(message) {
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.throwTypeError)("DynamicProto: " + message);
}
/**
 * Returns a collection of the instance functions that are defined directly on the thisTarget object, it does
 * not return any inherited functions
 * @param thisTarget The object to get the instance functions from
 * @ignore
 */
function _getInstanceFuncs(thisTarget) {
    // Get the base proto
    var instFuncs = {};
    // Save any existing instance functions
    _forEachProp(thisTarget, function (name) {
        // Don't include any dynamic prototype instances - as we only want the real functions
        if (!instFuncs[name] && _isDynamicCandidate(thisTarget, name, false)) {
            // Create an instance callback for passing the base function to the caller
            instFuncs[name] = thisTarget[name];
        }
    });
    return instFuncs;
}
/**
 * Returns whether the value is included in the array
 * @param values The array of values
 * @param value  The value
 */
function _hasVisited(values, value) {
    for (var lp = values.length - 1; lp >= 0; lp--) {
        if (values[lp] === value) {
            return true;
        }
    }
    return false;
}
/**
 * Returns an object that contains callback functions for all "base/super" functions, this is used to "save"
 * enabling calling super.xxx() functions without requiring that the base "class" has defined a prototype references
 * @param target The current instance
 * @ignore
 */
function _getBaseFuncs(classProto, thisTarget, instFuncs, useBaseInst) {
    function _instFuncProxy(target, funcHost, funcName) {
        var theFunc = funcHost[funcName];
        if (theFunc[DynProxyTag] && useBaseInst) {
            // grab and reuse the hosted looking function (if available) otherwise the original passed function
            var instFuncTable = target[DynInstFuncTable] || {};
            if (instFuncTable[DynAllowInstChkTag] !== false) {
                theFunc = (instFuncTable[funcHost[DynClassName]] || {})[funcName] || theFunc;
            }
        }
        return function () {
            // eslint-disable-next-line prefer-rest-params
            return theFunc.apply(target, arguments);
        };
    }
    // Start creating a new baseFuncs by creating proxies for the instance functions (as they may get replaced)
    var baseFuncs = {};
    _forEachProp(instFuncs, function (name) {
        // Create an instance callback for passing the base function to the caller
        baseFuncs[name] = _instFuncProxy(thisTarget, instFuncs, name);
    });
    // Get the base prototype functions
    var baseProto = _getObjProto(classProto);
    var visited = [];
    // Don't include base object functions for Object, Array or Function
    while (baseProto && !_isObjectArrayOrFunctionPrototype(baseProto) && !_hasVisited(visited, baseProto)) {
        // look for prototype functions
        _forEachProp(baseProto, function (name) {
            // Don't include any dynamic prototype instances - as we only want the real functions
            // For IE 7/8 the prototype lookup doesn't provide the full chain so we need to bypass the 
            // hasOwnProperty check we get all of the methods, main difference is that IE7/8 doesn't return
            // the Object prototype methods while bypassing the check
            if (!baseFuncs[name] && _isDynamicCandidate(baseProto, name, !_objGetPrototypeOf)) {
                // Create an instance callback for passing the base function to the caller
                baseFuncs[name] = _instFuncProxy(thisTarget, baseProto, name);
            }
        });
        // We need to find all possible functions that might be overloaded by walking the entire prototype chain
        // This avoids the caller from needing to check whether it's direct base class implements the function or not
        // by walking the entire chain it simplifies the usage and issues from upgrading any of the base classes.
        visited.push(baseProto);
        baseProto = _getObjProto(baseProto);
    }
    return baseFuncs;
}
function _getInstFunc(target, funcName, proto, currentDynProtoProxy) {
    var instFunc = null;
    // We need to check whether the class name is defined directly on this prototype otherwise
    // it will walk the proto chain and return any parent proto classname.
    if (target && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(proto, DynClassName)) {
        var instFuncTable = target[DynInstFuncTable] || {};
        instFunc = (instFuncTable[proto[DynClassName]] || {})[funcName];
        if (!instFunc) {
            // Avoid stack overflow from recursive calling the same function
            _throwTypeError("Missing [" + funcName + "] " + strFunction);
        }
        // We have the instance function, lets check it we can speed up further calls
        // by adding the instance function back directly on the instance (avoiding the dynamic func lookup)
        if (!instFunc[DynInstChkTag] && instFuncTable[DynAllowInstChkTag] !== false) {
            // If the instance already has an instance function we can't replace it
            var canAddInst = !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(target, funcName);
            // Get current prototype
            var objProto = _getObjProto(target);
            var visited = [];
            // Lookup the function starting at the top (instance level prototype) and traverse down, if the first matching function
            // if nothing is found or if the first hit is a dynamic proto instance then we can safely add an instance shortcut
            while (canAddInst && objProto && !_isObjectArrayOrFunctionPrototype(objProto) && !_hasVisited(visited, objProto)) {
                var protoFunc = objProto[funcName];
                if (protoFunc) {
                    canAddInst = (protoFunc === currentDynProtoProxy);
                    break;
                }
                // We need to find all possible initial functions to ensure that we don't bypass a valid override function
                visited.push(objProto);
                objProto = _getObjProto(objProto);
            }
            try {
                if (canAddInst) {
                    // This instance doesn't have an instance func and the class hierarchy does have a higher level prototype version
                    // so it's safe to directly assign for any subsequent calls (for better performance)
                    target[funcName] = instFunc;
                }
                // Block further attempts to set the instance function for any
                instFunc[DynInstChkTag] = 1;
            }
            catch (e) {
                // Don't crash if the object is readonly or the runtime doesn't allow changing this
                // And set a flag so we don't try again for any function
                instFuncTable[DynAllowInstChkTag] = false;
            }
        }
    }
    return instFunc;
}
function _getProtoFunc(funcName, proto, currentDynProtoProxy) {
    var protoFunc = proto[funcName];
    // Check that the prototype function is not a self reference -- try to avoid stack overflow!
    if (protoFunc === currentDynProtoProxy) {
        // It is so lookup the base prototype
        protoFunc = _getObjProto(proto)[funcName];
    }
    if (typeof protoFunc !== strFunction) {
        _throwTypeError("[" + funcName + "] is not a " + strFunction);
    }
    return protoFunc;
}
/**
 * Add the required dynamic prototype methods to the the class prototype
 * @param proto - The class prototype
 * @param className - The instance classname
 * @param target - The target instance
 * @param baseInstFuncs - The base instance functions
 * @param setInstanceFunc - Flag to allow prototype function to reset the instance function if one does not exist
 * @ignore
 */
function _populatePrototype(proto, className, target, baseInstFuncs, setInstanceFunc) {
    function _createDynamicPrototype(proto, funcName) {
        var dynProtoProxy = function () {
            // Use the instance or prototype function
            var instFunc = _getInstFunc(this, funcName, proto, dynProtoProxy) || _getProtoFunc(funcName, proto, dynProtoProxy);
            // eslint-disable-next-line prefer-rest-params
            return instFunc.apply(this, arguments);
        };
        // Tag this function as a proxy to support replacing dynamic proxy elements (primary use case is for unit testing
        // via which can dynamically replace the prototype function reference)
        dynProtoProxy[DynProxyTag] = 1;
        return dynProtoProxy;
    }
    if (!_isObjectOrArrayPrototype(proto)) {
        var instFuncTable = target[DynInstFuncTable] = target[DynInstFuncTable] || {};
        var instFuncs_1 = instFuncTable[className] = (instFuncTable[className] || {}); // fetch and assign if as it may not exist yet
        // Set whether we are allow to lookup instances, if someone has set to false then do not re-enable
        if (instFuncTable[DynAllowInstChkTag] !== false) {
            instFuncTable[DynAllowInstChkTag] = !!setInstanceFunc;
        }
        _forEachProp(target, function (name) {
            // Only add overridden functions
            if (_isDynamicCandidate(target, name, false) && target[name] !== baseInstFuncs[name]) {
                // Save the instance Function to the lookup table and remove it from the instance as it's not a dynamic proto function
                instFuncs_1[name] = target[name];
                delete target[name];
                // Add a dynamic proto if one doesn't exist or if a prototype function exists and it's not a dynamic one
                if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(proto, name) || (proto[name] && !proto[name][DynProxyTag])) {
                    proto[name] = _createDynamicPrototype(proto, name);
                }
            }
        });
    }
}
/**
 * Checks whether the passed prototype object appears to be correct by walking the prototype hierarchy of the instance
 * @param classProto The class prototype instance
 * @param thisTarget The current instance that will be checked whether the passed prototype instance is in the hierarchy
 * @ignore
 */
function _checkPrototype(classProto, thisTarget) {
    // This method doesn't existing in older browsers (e.g. IE8)
    if (_objGetPrototypeOf) {
        // As this is primarily a coding time check, don't bother checking if running in IE8 or lower
        var visited = [];
        var thisProto = _getObjProto(thisTarget);
        while (thisProto && !_isObjectArrayOrFunctionPrototype(thisProto) && !_hasVisited(visited, thisProto)) {
            if (thisProto === classProto) {
                return true;
            }
            // This avoids the caller from needing to check whether it's direct base class implements the function or not
            // by walking the entire chain it simplifies the usage and issues from upgrading any of the base classes.
            visited.push(thisProto);
            thisProto = _getObjProto(thisProto);
        }
        return false;
    }
    // If objGetPrototypeOf doesn't exist then just assume everything is ok.
    return true;
}
/**
 * Gets the current prototype name using the ES6 name if available otherwise falling back to a use unknown as the name.
 * It's not critical for this to return a name, it's used to decorate the generated unique name for easier debugging only.
 * @param target
 * @param unknownValue
 * @ignore
 */
function _getObjName(target, unknownValue) {
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(target, Prototype)) {
        // Look like a prototype
        return target.name || unknownValue || UnknownValue;
    }
    return (((target || {})[Constructor]) || {}).name || unknownValue || UnknownValue;
}
/**
 * Helper function when creating dynamic (inline) functions for classes, this helper performs the following tasks :-
 * - Saves references to all defined base class functions
 * - Calls the delegateFunc with the current target (this) and a base object reference that can be used to call all "super" functions.
 * - Will populate the class prototype for all overridden functions to support class extension that call the prototype instance.
 * Callers should use this helper when declaring all function within the constructor of a class, as mentioned above the delegateFunc is
 * passed both the target "this" and an object that can be used to call any base (super) functions, using this based object in place of
 * super.XXX() (which gets expanded to _super.prototype.XXX()) provides a better minification outcome and also ensures the correct "this"
 * context is maintained as TypeScript creates incorrect references using super.XXXX() for dynamically defined functions i.e. Functions
 * defined in the constructor or some other function (rather than declared as complete typescript functions).
 * ### Usage
 * ```typescript
 * import dynamicProto from "@microsoft/dynamicproto-js";
 * class ExampleClass extends BaseClass {
 *     constructor() {
 *         dynamicProto(ExampleClass, this, (_self, base) => {
 *             // This will define a function that will be converted to a prototype function
 *             _self.newFunc = () => {
 *                 // Access any "this" instance property
 *                 if (_self.someProperty) {
 *                     ...
 *                 }
 *             }
 *             // This will define a function that will be converted to a prototype function
 *             _self.myFunction = () => {
 *                 // Access any "this" instance property
 *                 if (_self.someProperty) {
 *                     // Call the base version of the function that we are overriding
 *                     base.myFunction();
 *                 }
 *                 ...
 *             }
 *             _self.initialize = () => {
 *                 ...
 *             }
 *             // Warnings: While the following will work as _self is simply a reference to
 *             // this, if anyone overrides myFunction() the overridden will be called first
 *             // as the normal JavaScript method resolution will occur and the defined
 *             // _self.initialize() function is actually gets removed from the instance and
 *             // a proxy prototype version is created to reference the created method.
 *             _self.initialize();
 *         });
 *     }
 * }
 * ```
 * @typeparam DPType This is the generic type of the class, used to keep intellisense valid
 * @typeparam DPCls The type that contains the prototype of the current class
 * @param theClass - This is the current class instance which contains the prototype for the current class
 * @param target - The current "this" (target) reference, when the class has been extended this.prototype will not be the 'theClass' value.
 * @param delegateFunc - The callback function (closure) that will create the dynamic function
 * @param options - Additional options to configure how the dynamic prototype operates
 */
function dynamicProto(theClass, target, delegateFunc, options) {
    // Make sure that the passed theClass argument looks correct
    if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(theClass, Prototype)) {
        _throwTypeError("theClass is an invalid class definition.");
    }
    // Quick check to make sure that the passed theClass argument looks correct (this is a common copy/paste error)
    var classProto = theClass[Prototype];
    if (!_checkPrototype(classProto, target)) {
        _throwTypeError("[" + _getObjName(theClass) + "] not in hierarchy of [" + _getObjName(target) + "]");
    }
    var className = null;
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(classProto, DynClassName)) {
        // Only grab the class name if it's defined on this prototype (i.e. don't walk the prototype chain)
        className = classProto[DynClassName];
    }
    else {
        // As not all browser support name on the prototype creating a unique dynamic one if we have not already
        // assigned one, so we can use a simple string as the lookup rather than an object for the dynamic instance
        // function table lookup.
        className = DynClassNamePrefix + _getObjName(theClass, "_") + "$" + _gblInst.n;
        _gblInst.n++;
        classProto[DynClassName] = className;
    }
    var perfOptions = dynamicProto[DynProtoDefaultOptions];
    var useBaseInst = !!perfOptions[strUseBaseInst];
    if (useBaseInst && options && options[strUseBaseInst] !== undefined) {
        useBaseInst = !!options[strUseBaseInst];
    }
    // Get the current instance functions
    var instFuncs = _getInstanceFuncs(target);
    // Get all of the functions for any base instance (before they are potentially overridden)
    var baseFuncs = _getBaseFuncs(classProto, target, instFuncs, useBaseInst);
    // Execute the delegate passing in both the current target "this" and "base" function references
    // Note casting the same type as we don't actually have the base class here and this will provide some intellisense support
    delegateFunc(target, baseFuncs);
    // Don't allow setting instance functions for older IE instances
    var setInstanceFunc = !!_objGetPrototypeOf && !!perfOptions[strSetInstFuncs];
    if (setInstanceFunc && options) {
        setInstanceFunc = !!options[strSetInstFuncs];
    }
    // Populate the Prototype for any overridden instance functions
    _populatePrototype(classProto, className, target, instFuncs, setInstanceFunc !== false);
}
/**
 * Exposes the default global options to allow global configuration, if the global values are disabled these will override
 * any passed values. This is primarily exposed to support unit-testing without the need for individual classes to expose
 * their internal usage of dynamic proto.
 */
dynamicProto[DynProtoDefaultOptions] = _gblInst.o;
//# sourceMappingURL=DynamicProto.js.map

/***/ }),
/* 52 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createDynamicConfig": () => (/* binding */ createDynamicConfig),
/* harmony export */   "onConfigChange": () => (/* binding */ onConfigChange)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(14);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(24);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(22);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(13);
/* harmony import */ var _JavaScriptSDK_DataCacheHelper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(58);
/* harmony import */ var _JavaScriptSDK_InternalConstants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(43);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(42);
/* harmony import */ var _ConfigDefaults__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(61);
/* harmony import */ var _DynamicProperty__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(60);
/* harmony import */ var _DynamicState__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(62);
/* harmony import */ var _DynamicSupport__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(53);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */










/**
 * Identifies a function which will be re-called whenever any of it's accessed configuration values
 * change.
 * @param configHandler - The callback that will be called for the initial request and then whenever any
 * accessed configuration changes are identified.
 */
function _createAndUseHandler(state, configHandler) {
    var handler = {
        fn: configHandler,
        rm: function () {
            // Clear all references to the handler so it can be garbage collected
            // This will also cause this handler to never get called and eventually removed
            handler.fn = null;
            state = null;
            configHandler = null;
        }
    };
    state.use(handler, configHandler);
    return handler;
}
/**
 * Creates the dynamic config handler and associates with the target config as the root object
 * @param target - The config that you want to be root of the dynamic config
 * @param inPlace - Should the passed config be converted in-place or a new proxy returned
 * @returns The existing dynamic handler or a new instance with the provided config values
 */
function _createDynamicHandler(logger, target, inPlace) {
    var _a;
    var dynamicHandler = (0,_DynamicSupport__WEBPACK_IMPORTED_MODULE_0__.getDynamicConfigHandler)(target);
    if (dynamicHandler) {
        // The passed config is already dynamic so return it's tracker
        return dynamicHandler;
    }
    var uid = (0,_JavaScriptSDK_DataCacheHelper__WEBPACK_IMPORTED_MODULE_1__.createUniqueNamespace)("dyncfg", true);
    var newTarget = (target && inPlace !== false) ? target : (0,_DynamicSupport__WEBPACK_IMPORTED_MODULE_0__._cfgDeepCopy)(target);
    var theState;
    function _notifyWatchers() {
        theState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NOTIFY /* @min:%2enotify */]();
    }
    function _setValue(target, name, value) {
        try {
            target = (0,_DynamicProperty__WEBPACK_IMPORTED_MODULE_3__._setDynamicProperty)(theState, target, name, value);
        }
        catch (e) {
            // Unable to convert to dynamic property so just leave as non-dynamic
            (0,_DynamicProperty__WEBPACK_IMPORTED_MODULE_3__._throwDynamicError)(logger, name, "Setting value", e);
        }
        return target[name];
    }
    function _watch(configHandler) {
        return _createAndUseHandler(theState, configHandler);
    }
    function _block(configHandler, allowUpdate) {
        theState.use(null, function (details) {
            var prevUpd = theState.upd;
            try {
                if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isUndefined)(allowUpdate)) {
                    theState.upd = allowUpdate;
                }
                configHandler(details);
            }
            finally {
                theState.upd = prevUpd;
            }
        });
    }
    function _ref(target, name) {
        var _a;
        // Make sure it's dynamic and mark as referenced with it's current value
        return (0,_DynamicProperty__WEBPACK_IMPORTED_MODULE_3__._setDynamicPropertyState)(theState, target, name, (_a = {}, _a[0 /* _eSetDynamicPropertyFlags.inPlace */] = true, _a))[name];
    }
    function _rdOnly(target, name) {
        var _a;
        // Make sure it's dynamic and mark as readonly with it's current value
        return (0,_DynamicProperty__WEBPACK_IMPORTED_MODULE_3__._setDynamicPropertyState)(theState, target, name, (_a = {}, _a[1 /* _eSetDynamicPropertyFlags.readOnly */] = true, _a))[name];
    }
    function _blkPropValue(target, name) {
        var _a;
        // Make sure it's dynamic and mark as readonly with it's current value
        return (0,_DynamicProperty__WEBPACK_IMPORTED_MODULE_3__._setDynamicPropertyState)(theState, target, name, (_a = {}, _a[2 /* _eSetDynamicPropertyFlags.blockDynamicProperty */] = true, _a))[name];
    }
    function _applyDefaults(theConfig, defaultValues) {
        if (defaultValues) {
            // Resolve/apply the defaults
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(defaultValues, function (name, value) {
                // Sets the value and makes it dynamic (if it doesn't already exist)
                (0,_ConfigDefaults__WEBPACK_IMPORTED_MODULE_6__._applyDefaultValue)(cfgHandler, theConfig, name, value);
            });
        }
        return theConfig;
    }
    var cfgHandler = (_a = {
            uid: null,
            cfg: newTarget
        },
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LOGGER /* @min:logger */] = logger,
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NOTIFY /* @min:notify */] = _notifyWatchers,
        _a.set = _setValue,
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_SET_DF /* @min:setDf */] = _applyDefaults,
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_WATCH /* @min:watch */] = _watch,
        _a.ref = _ref,
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_RD_ONLY /* @min:rdOnly */] = _rdOnly,
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_BLK_VAL /* @min:blkVal */] = _blkPropValue,
        _a._block = _block,
        _a);
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.objDefine)(cfgHandler, "uid", {
        c: false,
        e: false,
        w: false,
        v: uid
    });
    theState = (0,_DynamicState__WEBPACK_IMPORTED_MODULE_8__._createState)(cfgHandler);
    // Setup tracking for all defined default keys
    (0,_DynamicProperty__WEBPACK_IMPORTED_MODULE_3__._makeDynamicObject)(theState, newTarget, "config", "Creating");
    return cfgHandler;
}
/**
 * Log an invalid access message to the console
 * @param message
 */
function _logInvalidAccess(logger, message) {
    if (logger) {
        logger[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_WARN_TO_CONSOLE /* @min:%2ewarnToConsole */](message);
        logger[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_THROW_INTERNAL /* @min:%2ethrowInternal */](2 /* eLoggingSeverity.WARNING */, 108 /* _eInternalMessageId.DynamicConfigException */, message);
    }
    else {
        // We don't have a logger so just throw an exception
        (0,_DynamicSupport__WEBPACK_IMPORTED_MODULE_0__.throwInvalidAccess)(message);
    }
}
/**
 * Create or return a dynamic version of the passed config, if it is not already dynamic
 * @param config - The config to be converted into a dynamic config
 * @param defaultConfig - The default values to apply on the config if the properties don't already exist
 * @param inPlace - Should the config be converted in-place into a dynamic config or a new instance returned, defaults to true
 * @returns The dynamic config handler for the config (whether new or existing)
 */
function createDynamicConfig(config, defaultConfig, logger, inPlace) {
    var dynamicHandler = _createDynamicHandler(logger, config || {}, inPlace);
    if (defaultConfig) {
        dynamicHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_SET_DF /* @min:%2esetDf */](dynamicHandler.cfg, defaultConfig);
    }
    return dynamicHandler;
}
/**
 * Watch and track changes for accesses to the current config, the provided config MUST already be
 * a dynamic config or a child accessed via the dynamic config
 * @param config
 * @param configHandler
 * @param logger - The logger instance to use if there is no existing handler
 * @returns A watcher handler instance that can be used to remove itself when being unloaded
 * @throws TypeError if the provided config is not a dynamic config instance
 */
function onConfigChange(config, configHandler, logger) {
    var handler = config[_DynamicSupport__WEBPACK_IMPORTED_MODULE_0__.CFG_HANDLER_LINK] || config;
    if (handler.cfg && (handler.cfg === config || handler.cfg[_DynamicSupport__WEBPACK_IMPORTED_MODULE_0__.CFG_HANDLER_LINK] === handler)) {
        return handler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_WATCH /* @min:%2ewatch */](configHandler);
    }
    _logInvalidAccess(logger, _JavaScriptSDK_InternalConstants__WEBPACK_IMPORTED_MODULE_9__.STR_NOT_DYNAMIC_ERROR + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__.dumpObj)(config));
    return createDynamicConfig(config, null, logger)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_WATCH /* @min:%2ewatch */](configHandler);
}
//# sourceMappingURL=DynamicConfig.js.map

/***/ }),
/* 53 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CFG_HANDLER_LINK": () => (/* binding */ CFG_HANDLER_LINK),
/* harmony export */   "_canMakeDynamic": () => (/* binding */ _canMakeDynamic),
/* harmony export */   "_cfgDeepCopy": () => (/* binding */ _cfgDeepCopy),
/* harmony export */   "blockDynamicConversion": () => (/* binding */ blockDynamicConversion),
/* harmony export */   "forceDynamicConversion": () => (/* binding */ forceDynamicConversion),
/* harmony export */   "getDynamicConfigHandler": () => (/* binding */ getDynamicConfigHandler),
/* harmony export */   "throwInvalidAccess": () => (/* binding */ throwInvalidAccess)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(54);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(47);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(24);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(42);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */




// Using Symbol.for so that if the same symbol was already created it would be returned
// To handle multiple instances using potentially different versions we are not using
// createUniqueNamespace()
var CFG_HANDLER_LINK = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.symbolFor)("[[ai_dynCfg_1]]");
/**
 * @internal
 * @ignore
 * The symbol to tag objects / arrays with if they should not be converted
 */
var BLOCK_DYNAMIC = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.symbolFor)("[[ai_blkDynCfg_1]]");
/**
 * @internal
 * @ignore
 * The symbol to tag objects to indicate that when included into the configuration that
 * they should be converted into a trackable dynamic object.
 */
var FORCE_DYNAMIC = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.symbolFor)("[[ai_frcDynCfg_1]]");
function _cfgDeepCopy(source) {
    if (source) {
        var target_1;
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.isArray)(source)) {
            target_1 = [];
            target_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] = source[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */];
        }
        else if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isPlainObject)(source)) {
            target_1 = {};
        }
        if (target_1) {
            // Copying index values by property name as the extensionConfig can be an array or object
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.objForEachKey)(source, function (key, value) {
                // Perform a deep copy of the object
                target_1[key] = _cfgDeepCopy(value);
            });
            return target_1;
        }
    }
    return source;
}
/**
 * @internal
 * Get the dynamic config handler if the value is already dynamic
 * @param value
 * @returns
 */
function getDynamicConfigHandler(value) {
    if (value) {
        var handler = value[CFG_HANDLER_LINK] || value;
        if (handler.cfg && (handler.cfg === value || handler.cfg[CFG_HANDLER_LINK] === handler)) {
            return handler;
        }
    }
    return null;
}
/**
 * Mark the provided value so that if it's included into the configuration it will NOT have
 * its properties converted into a dynamic (reactive) object. If the object is not a plain object
 * or an array (ie. a class) this function has not affect as only Objects and Arrays are converted
 * into dynamic objects in the dynamic configuration.
 *
 * When you have tagged a value as both {@link forceDynamicConversion} and blocked force will take precedence.
 *
 * You should only need to use this function, if you are creating dynamic "classes" from objects
 * which confirm to the require interface. A common case for this is during unit testing where it's
 * easier to create mock extensions.
 *
 * If `value` is falsy (null / undefined / 0 / empty string etc) it will not be tagged and
 * if there is an exception adding the property to the value (because its frozen etc) the
 * exception will be swallowed
 *
 * @example
 * ```ts
 * // This is a valid "extension", but it is technically an object
 * // So when included in the config.extensions it WILL be cloned and then
 * // converted into a dynamic object, where all of its properties will become
 * // get/set object properties and will be tracked. While this WILL still
 * // function, when attempt to use a mocking framework on top of this the
 * // functions are now technically get accessors which return a function
 * // and this can cause some mocking frameworks to fail.
 * let mockChannel = {
 *      pause: () => { },
*      resume: () => { },
*      teardown: () => { },
*      flush: (async: any, callBack: any) => { },
*      processTelemetry: (env: any) => { },
*      setNextPlugin: (next: any) => { },
*      initialize: (config: any, core: any, extensions: any) => { },
*      identifier: "testChannel",
*      priority: 1003
* };
 * ```
 * @param value - The object that you want to block from being converted into a
 * trackable dynamic object
 * @returns The original value
 */
function blockDynamicConversion(value) {
    if (value && ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isPlainObject)(value) || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.isArray)(value))) {
        try {
            value[BLOCK_DYNAMIC] = true;
        }
        catch (e) {
            // Don't throw for this case as it's an ask only
        }
    }
    return value;
}
/**
 * This is the reverse case of {@link blockDynamicConversion} in that this will tag an
 * object to indicate that it should always be converted into a dynamic trackable object
 * even when not an object or array. So all properties of this object will become
 * get / set accessor functions.
 *
 * When you have tagged a value as both {@link forceDynamicConversion} and blocked force will take precedence.
 *
 * If `value` is falsy (null / undefined / 0 / empty string etc) it will not be tagged and
 * if there is an exception adding the property to the value (because its frozen etc) the
 * exception will be swallowed.
 * @param value - The object that should be tagged and converted if included into a dynamic
 * configuration.
 * @returns The original value
 */
function forceDynamicConversion(value) {
    if (value) {
        try {
            value[FORCE_DYNAMIC] = true;
        }
        catch (e) {
            // Don't throw for this case as it's an ask only
        }
    }
    return value;
}
/**
 * @internal
 * @ignore
 * Helper function to check whether an object can or should be converted into a dynamic
 * object.
 * @param value - The object to check whether it should be converted
 * @returns `true` if the value should be converted otherwise `false`.
 */
function _canMakeDynamic(getFunc, state, value) {
    var result = false;
    // Object must exist and be truthy
    if (value && !getFunc[state.blkVal]) {
        // Tagged as always convert
        result = value[FORCE_DYNAMIC];
        // Check that it's not explicitly tagged as blocked
        if (!result && !value[BLOCK_DYNAMIC]) {
            // Only convert plain objects or arrays by default
            result = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isPlainObject)(value) || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.isArray)(value);
        }
    }
    return result;
}
/**
 * Throws an invalid access exception
 * @param message - The message to include in the exception
 */
function throwInvalidAccess(message) {
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.throwTypeError)("InvalidAccess:" + message);
}
//# sourceMappingURL=DynamicSupport.js.map

/***/ }),
/* 54 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getKnownSymbol": () => (/* binding */ getKnownSymbol),
/* harmony export */   "getSymbol": () => (/* binding */ getSymbol),
/* harmony export */   "hasSymbol": () => (/* binding */ hasSymbol),
/* harmony export */   "isSymbol": () => (/* binding */ isSymbol),
/* harmony export */   "newSymbol": () => (/* binding */ newSymbol),
/* harmony export */   "symbolFor": () => (/* binding */ symbolFor),
/* harmony export */   "symbolKeyFor": () => (/* binding */ symbolKeyFor)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _polyfills_symbol__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(56);
/* harmony import */ var _well_known__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(55);
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(14);
/* harmony import */ var _helpers_lazy__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20);
/* harmony import */ var _helpers_safe_lazy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19);
/* harmony import */ var _helpers_environment__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(18);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */







var _symbol;
var _symbolFor;
var _symbolKeyFor;
function _getSymbolValue(name) {
    return (0,_helpers_safe_lazy__WEBPACK_IMPORTED_MODULE_0__.safeGetLazy)(function () {
        return (_symbol.v ? _symbol.v[name] : _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE);
    }, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE);
}
/**
 * Checks if the type of value is a symbol.
 * @group Symbol
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a symbol, false otherwise.
 */
var isSymbol = (0,_helpers_base__WEBPACK_IMPORTED_MODULE_2__._createIs)("symbol");
/**
 * Helper to identify whether the runtime support the Symbols either via native or an installed polyfill
 * @group Symbol
 * @returns true if Symbol's are support otherwise false
 */
function hasSymbol() {
    return !!getSymbol();
}
/**
 * If Symbols are supported then attempt to return the named Symbol
 * @group Symbol
 * @returns The value of the named Symbol (if available)
 */
function getSymbol() {
    var resetCache = !_symbol || (_helpers_lazy__WEBPACK_IMPORTED_MODULE_3__._globalLazyTestHooks && _helpers_lazy__WEBPACK_IMPORTED_MODULE_3__._globalLazyTestHooks.lzy && !_symbol.b);
    resetCache && (_symbol = (0,_helpers_environment__WEBPACK_IMPORTED_MODULE_4__.lazySafeGetInst)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.SYMBOL));
    (!_symbolFor || resetCache) && (_symbolFor = _getSymbolValue("for"));
    (!_symbolKeyFor || resetCache) && (_symbolKeyFor = _getSymbolValue("keyFor"));
    return _symbol.v;
}
/**
 * If Symbols are supported then get the property of the global Symbol, if Symbol's are
 * not supported and noPoly is true it returns null. Used to access the well known symbols.
 * @group Symbol
 * @param name - The property name to return (if it exists) for Symbol
 * @param noPoly - Flag indicating whether to return a polyfill if symbols are not supported.
 * @returns The value of the property if present
 * @example
 * ```ts
 * // If Symbol is supported in the runtime
 * getKnownSymbol("toStringTag") === Symbol.toStringTag;                // true
 * getKnownSymbol(WellKnownSymbols.toStringTag) === Symbol.toStringTag; // true
 * ```
 */
function getKnownSymbol(name, noPoly) {
    var knownName = _well_known__WEBPACK_IMPORTED_MODULE_5__._wellKnownSymbolMap[name];
    // Cause lazy symbol to get initialized
    (!_symbol || (_helpers_lazy__WEBPACK_IMPORTED_MODULE_3__._globalLazyTestHooks.lzy && !_symbol.b)) && getSymbol();
    return _symbol.v ? _symbol.v[knownName || name] : (!noPoly ? (0,_polyfills_symbol__WEBPACK_IMPORTED_MODULE_6__.polyGetKnownSymbol)(name) : _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE);
}
/**
 * Returns a new unique Symbol value. If noPoly is true and symbols are not supported
 * then this will return null.
 * @group Symbol
 * @param description Description of the new Symbol object.
 * @param noPoly - Flag indicating whether to return a polyfil if symbols are not supported.
 * @returns The new symbol
 */
function newSymbol(description, noPoly) {
    // Cause lazy _symbol to get initialized
    (!_symbol || (_helpers_lazy__WEBPACK_IMPORTED_MODULE_3__._globalLazyTestHooks.lzy && !_symbol.b)) && getSymbol();
    return _symbol.v ? _symbol.v(description) : (!noPoly ? (0,_polyfills_symbol__WEBPACK_IMPORTED_MODULE_6__.polyNewSymbol)(description) : _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE);
}
/**
 * Returns a Symbol object from the global symbol registry matching the given key if found.
 * Otherwise, returns a new symbol with this key. This will always return a polyfill if symbols
 * are not supported.
 * @group Symbol
 * @param key key to search for.
 */
function symbolFor(key) {
    // Cause lazy symbol to get initialized
    (!_symbolFor || (_helpers_lazy__WEBPACK_IMPORTED_MODULE_3__._globalLazyTestHooks.lzy && !_symbol.b)) && getSymbol();
    return (_symbolFor.v || _polyfills_symbol__WEBPACK_IMPORTED_MODULE_6__.polySymbolFor)(key);
}
/**
 * Returns a key from the global symbol registry matching the given Symbol if found.
 * Otherwise, returns a undefined. This will always attempt to lookup the polyfill
 * implementation if symbols are not supported
 * @group Symbol
 * @param sym Symbol to find the key for.
 */
function symbolKeyFor(sym) {
    // Cause lazy symbol to get initialized
    (!_symbolKeyFor || (_helpers_lazy__WEBPACK_IMPORTED_MODULE_3__._globalLazyTestHooks.lzy && !_symbol.b)) && getSymbol();
    return (_symbolKeyFor.v || _polyfills_symbol__WEBPACK_IMPORTED_MODULE_6__.polySymbolKeyFor)(sym);
}
//# sourceMappingURL=symbol.js.map

/***/ }),
/* 55 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_wellKnownSymbolMap": () => (/* binding */ _wellKnownSymbolMap)
/* harmony export */ });
/* harmony import */ var _helpers_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

/**
 * @ignore
 * @internal
 */
var _wellKnownSymbolMap = (0,_helpers_enum__WEBPACK_IMPORTED_MODULE_0__.createEnumKeyMap)({
    asyncIterator: 0 /* WellKnownSymbols.asyncIterator */,
    hasInstance: 1 /* WellKnownSymbols.hasInstance */,
    isConcatSpreadable: 2 /* WellKnownSymbols.isConcatSpreadable */,
    iterator: 3 /* WellKnownSymbols.iterator */,
    match: 4 /* WellKnownSymbols.match */,
    matchAll: 5 /* WellKnownSymbols.matchAll */,
    replace: 6 /* WellKnownSymbols.replace */,
    search: 7 /* WellKnownSymbols.search */,
    species: 8 /* WellKnownSymbols.species */,
    split: 9 /* WellKnownSymbols.split */,
    toPrimitive: 10 /* WellKnownSymbols.toPrimitive */,
    toStringTag: 11 /* WellKnownSymbols.toStringTag */,
    unscopables: 12 /* WellKnownSymbols.unscopables */
});
//# sourceMappingURL=well_known.js.map

/***/ }),
/* 56 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "polyGetKnownSymbol": () => (/* binding */ polyGetKnownSymbol),
/* harmony export */   "polyNewSymbol": () => (/* binding */ polyNewSymbol),
/* harmony export */   "polySymbolFor": () => (/* binding */ polySymbolFor),
/* harmony export */   "polySymbolKeyFor": () => (/* binding */ polySymbolKeyFor)
/* harmony export */ });
/* harmony import */ var _symbol_well_known__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(55);
/* harmony import */ var _helpers_throw__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(10);
/* harmony import */ var _object_has_own__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(25);
/* harmony import */ var _string_as_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(12);
/* harmony import */ var _internal_global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(21);
/* harmony import */ var _string_starts_with__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(57);
/* harmony import */ var _object_object__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(33);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */








var UNIQUE_REGISTRY_ID = "_urid";
var _polySymbols;
function _globalSymbolRegistry() {
    if (!_polySymbols) {
        var gblCfg = (0,_internal_global__WEBPACK_IMPORTED_MODULE_0__._getGlobalConfig)();
        _polySymbols = gblCfg.gblSym = gblCfg.gblSym || { k: {}, s: {} };
    }
    return _polySymbols;
}
var _wellKnownSymbolCache = {};
/**
 * Returns a new (polyfill) Symbol object for the provided description that's guaranteed to be unique.
 * Symbols are often used to add unique property keys to an object that won't collide with keys any
 * other code might add to the object, and which are hidden from any mechanisms other code will
 * typically use to access the object. That enables a form of weak encapsulation, or a weak form of
 * information hiding.
 * @group Polyfill
 * @group Symbol
 * @param description - The description of the symbol
 * @returns A new polyfill version of a Symbol object
 */
function polyNewSymbol(description) {
    var theSymbol = {
        description: (0,_string_as_string__WEBPACK_IMPORTED_MODULE_1__.asString)(description),
        toString: function () { return _internal_constants__WEBPACK_IMPORTED_MODULE_2__.SYMBOL + "(" + description + ")"; }
    };
    // Tag the symbol so we know it a polyfill
    theSymbol[_internal_constants__WEBPACK_IMPORTED_MODULE_2__.POLYFILL_TAG] = true;
    return theSymbol;
}
/**
 * Returns a Symbol object from the global symbol registry matching the given key if found.
 * Otherwise, returns a new symbol with this key.
 * @group Polyfill
 * @group Symbol
 * @param key key to search for.
 */
function polySymbolFor(key) {
    var registry = _globalSymbolRegistry();
    if (!(0,_object_has_own__WEBPACK_IMPORTED_MODULE_3__.objHasOwn)(registry.k, key)) {
        var newSymbol_1 = polyNewSymbol(key);
        var regId_1 = (0,_object_object__WEBPACK_IMPORTED_MODULE_4__.objKeys)(registry.s).length;
        newSymbol_1[UNIQUE_REGISTRY_ID] = function () { return regId_1 + "_" + newSymbol_1.toString(); };
        registry.k[key] = newSymbol_1;
        registry.s[newSymbol_1[UNIQUE_REGISTRY_ID]()] = (0,_string_as_string__WEBPACK_IMPORTED_MODULE_1__.asString)(key);
    }
    return registry.k[key];
}
/**
 * Returns a key from the global symbol registry matching the given Symbol if found.
 * Otherwise, returns a undefined.
 * @group Polyfill
 * @group Symbol
 * @param sym Symbol to find the key for.
 */
function polySymbolKeyFor(sym) {
    if (!sym || !sym.toString || !(0,_string_starts_with__WEBPACK_IMPORTED_MODULE_5__.strStartsWith)(sym.toString(), _internal_constants__WEBPACK_IMPORTED_MODULE_2__.SYMBOL)) {
        (0,_helpers_throw__WEBPACK_IMPORTED_MODULE_6__.throwTypeError)(sym + " is not a symbol");
    }
    var regId = sym[_internal_constants__WEBPACK_IMPORTED_MODULE_2__.POLYFILL_TAG] && sym[UNIQUE_REGISTRY_ID] && sym[UNIQUE_REGISTRY_ID]();
    return regId ? _globalSymbolRegistry().s[regId] : undefined;
}
/**
 * Returns the polyfill version of a well-known global symbol, this will only return
 * known values.
 * @example
 * ```ts
 * // Always returns the polyfill version, even if Symbols are supported in the runtime
 * polyGetKnownSymbol("toStringTag") === polyGetKnownSymbol("toStringTag");                // true
 * polyGetKnownSymbol(WellKnownSymbols.toStringTag) === polyGetKnownSymbol("toStringTag"); // true
 * polyGetKnownSymbol("toStringTag") !== Symbol.toStringTag;                // true
 * polyGetKnownSymbol(WellKnownSymbols.toStringTag) !== Symbol.toStringTag; // true
 * polyGetKnownSymbol("toStringTag") !== polySymbolFor("toStringTag");      // true
 * polyGetKnownSymbol(WellKnownSymbols.toStringTag) !== polySymbolFor("toStringTag"); // true
 * polyGetKnownSymbol("toStringTag") !== polyNewSymbol("toStringTag");      // true
 * polyGetKnownSymbol(WellKnownSymbols.toStringTag) !== polyNewSymbol("toStringTag"); // true
 * ```
 * @group Polyfill
 * @group Symbol
 * @param name - The property name to return (if it exists) for Symbol
 * @returns The value of the property if present
 */
function polyGetKnownSymbol(name) {
    var result;
    var knownName = _symbol_well_known__WEBPACK_IMPORTED_MODULE_7__._wellKnownSymbolMap[name];
    if (knownName) {
        result = _wellKnownSymbolCache[knownName] = _wellKnownSymbolCache[knownName] || polyNewSymbol(_internal_constants__WEBPACK_IMPORTED_MODULE_2__.SYMBOL + "." + knownName);
    }
    return result;
}
//# sourceMappingURL=symbol.js.map

/***/ }),
/* 57 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "polyStrStartsWith": () => (/* binding */ polyStrStartsWith),
/* harmony export */   "strStartsWith": () => (/* binding */ strStartsWith)
/* harmony export */ });
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(14);
/* harmony import */ var _helpers_diagnostics__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(13);
/* harmony import */ var _helpers_throw__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
/* harmony import */ var _as_string__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(12);
/* harmony import */ var _substring__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(36);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */







/**
 * This method lets you determine whether or not a string begins with another string. This method is case-sensitive.
 * @group String
 * @param value - The value to be checked
 * @param searchString - The characters to be searched for at the start of the string
 * @param position - [Optional] The position in this string at which to begin searching for `searchString`.
 * Defaults to 0
 * @returns `true` if the given characters are found at the beginning of the string; otherwise, `false`.
 */
var strStartsWith = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunctionWithPoly)("startsWith", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto, polyStrStartsWith);
/**
 * This method lets you determine whether or not a string begins with another string. This method is case-sensitive.
 * @group Polyfill
 * @group String
 * @param value - The value to be checked
 * @param searchString - The characters to be searched for at the start of the string
 * @param position - [Optional] The position in this string at which to begin searching for `searchString`.
 * Defaults to 0
 * @returns `true` if the given characters are found at the beginning of the string; otherwise, `false`.
 */
function polyStrStartsWith(value, searchString, position) {
    if (!(0,_helpers_base__WEBPACK_IMPORTED_MODULE_2__.isString)(value)) {
        (0,_helpers_throw__WEBPACK_IMPORTED_MODULE_3__.throwTypeError)("'" + (0,_helpers_diagnostics__WEBPACK_IMPORTED_MODULE_4__.dumpObj)(value) + "' is not a string");
    }
    var searchValue = (0,_helpers_base__WEBPACK_IMPORTED_MODULE_2__.isString)(searchString) ? searchString : (0,_as_string__WEBPACK_IMPORTED_MODULE_5__.asString)(searchString);
    var chkLen = searchValue[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.LENGTH];
    var pos = position > 0 ? position : 0;
    return (0,_substring__WEBPACK_IMPORTED_MODULE_6__.strSubstring)(value, pos, pos + chkLen) === searchValue;
}
//# sourceMappingURL=starts_with.js.map

/***/ }),
/* 58 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createElmNodeData": () => (/* binding */ createElmNodeData),
/* harmony export */   "createUniqueNamespace": () => (/* binding */ createUniqueNamespace)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(43);
/* harmony import */ var _RandomHelper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */







var version = '3.0.4';
var instanceName = "." + (0,_RandomHelper__WEBPACK_IMPORTED_MODULE_0__.newId)(6);
var _dataUid = 0;
// Accepts only:
//  - Node
//    - Node.ELEMENT_NODE
//    - Node.DOCUMENT_NODE
//  - Object
//    - Any
function _canAcceptData(target) {
    return target[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NODE_TYPE /* @min:%2enodeType */] === 1 || target[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NODE_TYPE /* @min:%2enodeType */] === 9 || !(+target[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NODE_TYPE /* @min:%2enodeType */]);
}
function _getCache(data, target) {
    var theCache = target[data.id];
    if (!theCache) {
        theCache = {};
        try {
            if (_canAcceptData(target)) {
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.objDefine)(target, data.id, {
                    e: false,
                    v: theCache
                });
            }
        }
        catch (e) {
            // Not all environments allow extending all objects, so just ignore the cache in those cases
        }
    }
    return theCache;
}
function createUniqueNamespace(name, includeVersion) {
    if (includeVersion === void 0) { includeVersion = false; }
    return (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.normalizeJsName)(name + (_dataUid++) + (includeVersion ? "." + version : _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY) + instanceName);
}
function createElmNodeData(name) {
    var data = {
        id: createUniqueNamespace("_aiData-" + (name || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY) + "." + version),
        accept: function (target) {
            return _canAcceptData(target);
        },
        get: function (target, name, defValue, addDefault) {
            var theCache = target[data.id];
            if (!theCache) {
                if (addDefault) {
                    // Side effect is adds the cache
                    theCache = _getCache(data, target);
                    theCache[(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.normalizeJsName)(name)] = defValue;
                }
                return defValue;
            }
            return theCache[(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.normalizeJsName)(name)];
        },
        kill: function (target, name) {
            if (target && target[name]) {
                try {
                    delete target[name];
                }
                catch (e) {
                    // Just cleaning up, so if this fails -- ignore
                }
            }
        }
    };
    return data;
}
//# sourceMappingURL=DataCacheHelper.js.map

/***/ }),
/* 59 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "mwcRandom32": () => (/* binding */ mwcRandom32),
/* harmony export */   "mwcRandomSeed": () => (/* binding */ mwcRandomSeed),
/* harmony export */   "newId": () => (/* binding */ newId),
/* harmony export */   "random32": () => (/* binding */ random32),
/* harmony export */   "randomValue": () => (/* binding */ randomValue)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(50);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(42);
/* harmony import */ var _EnvUtils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(43);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






var UInt32Mask = 0x100000000;
var MaxUInt32 = 0xffffffff;
var SEED1 = 123456789;
var SEED2 = 987654321;
// MWC based Random generator (for IE)
var _mwcSeeded = false;
var _mwcW = SEED1;
var _mwcZ = SEED2;
// Takes any integer
function _mwcSeed(seedValue) {
    if (seedValue < 0) {
        // Make sure we end up with a positive number and not -ve one.
        seedValue >>>= 0;
    }
    _mwcW = (SEED1 + seedValue) & MaxUInt32;
    _mwcZ = (SEED2 - seedValue) & MaxUInt32;
    _mwcSeeded = true;
}
function _autoSeedMwc() {
    // Simple initialization using default Math.random() - So we inherit any entropy from the browser
    // and bitwise XOR with the current milliseconds
    try {
        var now = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.utcNow)() & 0x7fffffff;
        _mwcSeed(((Math.random() * UInt32Mask) ^ now) + now);
    }
    catch (e) {
        // Don't crash if something goes wrong
    }
}
/**
 * Generate a random value between 0 and maxValue, max value should be limited to a 32-bit maximum.
 * So maxValue(16) will produce a number from 0..16 (range of 17)
 * @param maxValue
 */
function randomValue(maxValue) {
    if (maxValue > 0) {
        return Math.floor((random32() / MaxUInt32) * (maxValue + 1)) >>> 0;
    }
    return 0;
}
/**
 * generate a random 32-bit number (0x000000..0xFFFFFFFF) or (-0x80000000..0x7FFFFFFF), defaults un-unsigned.
 * @param signed - True to return a signed 32-bit number (-0x80000000..0x7FFFFFFF) otherwise an unsigned one (0x000000..0xFFFFFFFF)
 */
function random32(signed) {
    var value = 0;
    var c = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_1__.getCrypto)() || (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_1__.getMsCrypto)();
    if (c && c.getRandomValues) {
        // Make sure the number is converted into the specified range (-0x80000000..0x7FFFFFFF)
        value = c.getRandomValues(new Uint32Array(1))[0] & MaxUInt32;
    }
    if (value === 0 && (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_1__.isIE)()) {
        // For IE 6, 7, 8 (especially on XP) Math.random is not very random
        if (!_mwcSeeded) {
            // Set the seed for the Mwc algorithm
            _autoSeedMwc();
        }
        // Don't use Math.random for IE
        // Make sure the number is converted into the specified range (-0x80000000..0x7FFFFFFF)
        value = mwcRandom32() & MaxUInt32;
    }
    if (value === 0) {
        // Make sure the number is converted into the specified range (-0x80000000..0x7FFFFFFF)
        value = Math.floor((UInt32Mask * Math.random()) | 0);
    }
    if (!signed) {
        // Make sure we end up with a positive number and not -ve one.
        value >>>= 0;
    }
    return value;
}
/**
 * Seed the MWC random number generator with the specified seed or a random value
 * @param value - optional the number to used as the seed, if undefined, null or zero a random value will be chosen
 */
function mwcRandomSeed(value) {
    if (!value) {
        _autoSeedMwc();
    }
    else {
        _mwcSeed(value);
    }
}
/**
 * Generate a random 32-bit number between (0x000000..0xFFFFFFFF) or (-0x80000000..0x7FFFFFFF), using MWC (Multiply with carry)
 * instead of Math.random() defaults to un-signed.
 * Used as a replacement random generator for IE to avoid issues with older IE instances.
 * @param signed - True to return a signed 32-bit number (-0x80000000..0x7FFFFFFF) otherwise an unsigned one (0x000000..0xFFFFFFFF)
 */
function mwcRandom32(signed) {
    _mwcZ = (36969 * (_mwcZ & 0xFFFF) + (_mwcZ >> 16)) & MaxUInt32;
    _mwcW = (18000 * (_mwcW & 0xFFFF) + (_mwcW >> 16)) & MaxUInt32;
    var value = (((_mwcZ << 16) + (_mwcW & 0xFFFF)) >>> 0) & MaxUInt32 | 0;
    if (!signed) {
        // Make sure we end up with a positive number and not -ve one.
        value >>>= 0;
    }
    return value;
}
/**
 * Generate random base64 id string.
 * The default length is 22 which is 132-bits so almost the same as a GUID but as base64 (the previous default was 5)
 * @param maxLength - Optional value to specify the length of the id to be generated, defaults to 22
 */
function newId(maxLength) {
    if (maxLength === void 0) { maxLength = 22; }
    var base64chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    // Start with an initial random number, consuming the value in reverse byte order
    var number = random32() >>> 0; // Make sure it's a +ve number
    var chars = 0;
    var result = _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY;
    while (result[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LENGTH /* @min:%2elength */] < maxLength) {
        chars++;
        result += base64chars.charAt(number & 0x3F);
        number >>>= 6; // Zero fill with right shift
        if (chars === 5) {
            // 5 base64 characters === 30 bits so we don't have enough bits for another base64 char
            // So add on another 30 bits and make sure it's +ve
            number = (((random32() << 2) & 0xFFFFFFFF) | (number & 0x03)) >>> 0;
            chars = 0; // We need to reset the number every 5 chars (30 bits)
        }
    }
    return result;
}
//# sourceMappingURL=RandomHelper.js.map

/***/ }),
/* 60 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_makeDynamicObject": () => (/* binding */ _makeDynamicObject),
/* harmony export */   "_setDynamicProperty": () => (/* binding */ _setDynamicProperty),
/* harmony export */   "_setDynamicPropertyState": () => (/* binding */ _setDynamicPropertyState),
/* harmony export */   "_throwDynamicError": () => (/* binding */ _throwDynamicError)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(14);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(28);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(23);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(24);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(22);
/* harmony import */ var _JavaScriptSDK_InternalConstants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(43);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(42);
/* harmony import */ var _DynamicSupport__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(53);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






var arrayMethodsToPatch = [
    "push",
    "pop",
    "shift",
    "unshift",
    "splice"
];
var _throwDynamicError = function (logger, name, desc, e) {
    logger && logger[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_THROW_INTERNAL /* @min:%2ethrowInternal */](3 /* eLoggingSeverity.DEBUG */, 108 /* _eInternalMessageId.DynamicConfigException */, "".concat(desc, " [").concat(name, "] failed - ") + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.dumpObj)(e));
};
function _patchArray(state, target, name) {
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isArray)(target)) {
        // Monkey Patch the methods that might change the array
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(arrayMethodsToPatch, function (method) {
            var orgMethod = target[method];
            target[method] = function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var result = orgMethod[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_APPLY /* @min:%2eapply */](this, args);
                // items may be added, removed or moved so need to make some new dynamic properties
                _makeDynamicObject(state, target, name, "Patching");
                return result;
            };
        });
    }
}
function _getOwnPropGetter(target, name) {
    var propDesc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.objGetOwnPropertyDescriptor)(target, name);
    return propDesc && propDesc.get;
}
function _createDynamicProperty(state, theConfig, name, value) {
    // Does not appear to be dynamic so lets make it so
    var detail = {
        n: name,
        h: [],
        trk: function (handler) {
            if (handler && handler.fn) {
                if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.arrIndexOf)(detail.h, handler) === -1) {
                    // Add this handler to the collection that should be notified when the value changes
                    detail.h[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PUSH /* @min:%2epush */](handler);
                }
                state.trk(handler, detail);
            }
        },
        clr: function (handler) {
            var idx = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.arrIndexOf)(detail.h, handler);
            if (idx !== -1) {
                detail.h[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SPLICE /* @min:%2esplice */](idx, 1);
            }
        }
    };
    // Flag to optimize lookup response time by avoiding additional function calls
    var checkDynamic = true;
    var isObjectOrArray = false;
    function _getProperty() {
        if (checkDynamic) {
            isObjectOrArray = isObjectOrArray || (0,_DynamicSupport__WEBPACK_IMPORTED_MODULE_6__._canMakeDynamic)(_getProperty, state, value);
            // Make sure that if it's an object that we make it dynamic
            if (value && !value[_DynamicSupport__WEBPACK_IMPORTED_MODULE_6__.CFG_HANDLER_LINK] && isObjectOrArray) {
                // It doesn't look like it's already dynamic so lets make sure it's converted the object into a dynamic Config as well
                value = _makeDynamicObject(state, value, name, "Converting");
            }
            // If it needed to be converted it now has been
            checkDynamic = false;
        }
        // If there is an active handler then add it to the tracking set of handlers
        var activeHandler = state.act;
        if (activeHandler) {
            detail.trk(activeHandler);
        }
        return value;
    }
    // Tag this getter as our dynamic property and provide shortcut for notifying a change
    _getProperty[state.prop] = {
        chng: function () {
            state.add(detail);
        }
    };
    function _setProperty(newValue) {
        if (value !== newValue) {
            if (!!_getProperty[state.ro] && !state.upd) {
                // field is marked as readonly so return false
                (0,_DynamicSupport__WEBPACK_IMPORTED_MODULE_6__.throwInvalidAccess)("[" + name + "] is read-only:" + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.dumpObj)(theConfig));
            }
            if (checkDynamic) {
                isObjectOrArray = isObjectOrArray || (0,_DynamicSupport__WEBPACK_IMPORTED_MODULE_6__._canMakeDynamic)(_getProperty, state, value);
                checkDynamic = false;
            }
            // The value must be a plain object or an array to enforce the reference (in-place updates)
            var isReferenced = isObjectOrArray && _getProperty[state.rf];
            if (isObjectOrArray) {
                // We are about to replace a plain object or an array
                if (isReferenced) {
                    // Reassign the properties from the current value to the same properties from the newValue
                    // This will set properties not in the newValue to undefined
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.objForEachKey)(value, function (key) {
                        value[key] = newValue ? newValue[key] : _JavaScriptSDK_InternalConstants__WEBPACK_IMPORTED_MODULE_8__.UNDEFINED_VALUE;
                    });
                    // Now assign / re-assign value with all of the keys from newValue
                    try {
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.objForEachKey)(newValue, function (key, theValue) {
                            _setDynamicProperty(state, value, key, theValue);
                        });
                        // Now drop newValue so when we assign value later it keeps the existing reference
                        newValue = value;
                    }
                    catch (e) {
                        // Unable to convert to dynamic property so just leave as non-dynamic
                        _throwDynamicError((state.hdlr || {})[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOGGER /* @min:%2elogger */], name, "Assigning", e);
                        // Mark as not an object or array so we don't try and do this again
                        isObjectOrArray = false;
                    }
                }
                else if (value && value[_DynamicSupport__WEBPACK_IMPORTED_MODULE_6__.CFG_HANDLER_LINK]) {
                    // As we are replacing the value, if it's already dynamic then we need to notify the listeners
                    // for every property it has already
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.objForEachKey)(value, function (key) {
                        // Check if the value is dynamic
                        var getter = _getOwnPropGetter(value, key);
                        if (getter) {
                            // And if it is tell it's listeners that the value has changed
                            var valueState = getter[state.prop];
                            valueState && valueState.chng();
                        }
                    });
                }
            }
            if (newValue !== value) {
                var newIsObjectOrArray = newValue && (0,_DynamicSupport__WEBPACK_IMPORTED_MODULE_6__._canMakeDynamic)(_getProperty, state, newValue);
                if (!isReferenced && newIsObjectOrArray) {
                    // As the newValue is an object/array lets preemptively make it dynamic
                    newValue = _makeDynamicObject(state, newValue, name, "Converting");
                }
                // Now assign the internal "value" to the newValue
                value = newValue;
                isObjectOrArray = newIsObjectOrArray;
            }
            // Cause any listeners to be scheduled for notification
            state.add(detail);
        }
    }
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.objDefine)(theConfig, detail.n, { g: _getProperty, s: _setProperty });
}
function _setDynamicProperty(state, target, name, value) {
    if (target) {
        // To be a dynamic property it needs to have a get function
        var getter = _getOwnPropGetter(target, name);
        var isDynamic = getter && !!getter[state.prop];
        if (!isDynamic) {
            _createDynamicProperty(state, target, name, value);
        }
        else {
            // Looks like it's already dynamic just assign the new value
            target[name] = value;
        }
    }
    return target;
}
function _setDynamicPropertyState(state, target, name, flags) {
    if (target) {
        // To be a dynamic property it needs to have a get function
        var getter = _getOwnPropGetter(target, name);
        var isDynamic = getter && !!getter[state.prop];
        var inPlace = flags && flags[0 /* _eSetDynamicPropertyFlags.inPlace */];
        var rdOnly = flags && flags[1 /* _eSetDynamicPropertyFlags.readOnly */];
        var blkProp = flags && flags[2 /* _eSetDynamicPropertyFlags.blockDynamicProperty */];
        if (!isDynamic) {
            if (blkProp) {
                try {
                    // Attempt to mark the target as blocked from conversion
                    (0,_DynamicSupport__WEBPACK_IMPORTED_MODULE_6__.blockDynamicConversion)(target);
                }
                catch (e) {
                    _throwDynamicError((state.hdlr || {})[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOGGER /* @min:%2elogger */], name, "Blocking", e);
                }
            }
            try {
                // Make sure it's dynamic so that we can tag the property as per the state
                _setDynamicProperty(state, target, name, target[name]);
                getter = _getOwnPropGetter(target, name);
            }
            catch (e) {
                // Unable to convert to dynamic property so just leave as non-dynamic
                _throwDynamicError((state.hdlr || {})[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOGGER /* @min:%2elogger */], name, "State", e);
            }
        }
        // Assign the optional flags if true
        if (inPlace) {
            getter[state.rf] = inPlace;
        }
        if (rdOnly) {
            getter[state.ro] = rdOnly;
        }
        if (blkProp) {
            getter[state.blkVal] = true;
        }
    }
    return target;
}
function _makeDynamicObject(state, target, name, desc) {
    try {
        // Assign target with new value properties (converting into dynamic properties in the process)
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.objForEachKey)(target, function (key, value) {
            // Assign and/or make the property dynamic
            _setDynamicProperty(state, target, key, value);
        });
        if (!target[_DynamicSupport__WEBPACK_IMPORTED_MODULE_6__.CFG_HANDLER_LINK]) {
            // Link the config back to the dynamic config details
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.objDefineProp)(target, _DynamicSupport__WEBPACK_IMPORTED_MODULE_6__.CFG_HANDLER_LINK, {
                get: function () {
                    return state[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_HDLR /* @min:%2ehdlr */];
                }
            });
            _patchArray(state, target, name);
        }
    }
    catch (e) {
        // Unable to convert to dynamic property so just leave as non-dynamic
        _throwDynamicError((state.hdlr || {})[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOGGER /* @min:%2elogger */], name, desc, e);
    }
    return target;
}
//# sourceMappingURL=DynamicProperty.js.map

/***/ }),
/* 61 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_applyDefaultValue": () => (/* binding */ _applyDefaultValue)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(47);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(24);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(42);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */




function _isConfigDefaults(value) {
    return (value && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isObject)(value) && (value.isVal || value.fb || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwn)(value, "v") || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwn)(value, "mrg") || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwn)(value, "ref") || value.set));
}
function _getDefault(dynamicHandler, theConfig, cfgDefaults) {
    var defValue;
    var isDefaultValid = cfgDefaults.dfVal || _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isDefined;
    // There is a fallback config key so try and grab that first
    if (theConfig && cfgDefaults.fb) {
        var fallbacks = cfgDefaults.fb;
        if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isArray)(fallbacks)) {
            fallbacks = [fallbacks];
        }
        for (var lp = 0; lp < fallbacks[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */]; lp++) {
            var fallback = fallbacks[lp];
            var fbValue = theConfig[fallback];
            if (isDefaultValid(fbValue)) {
                defValue = fbValue;
            }
            else if (dynamicHandler) {
                // Needed to ensure that the fallback value (and potentially) new field is also dynamic even if null/undefined
                fbValue = dynamicHandler.cfg[fallback];
                if (isDefaultValid(fbValue)) {
                    defValue = fbValue;
                }
                // Needed to ensure that the fallback value (and potentially) new field is also dynamic even if null/undefined
                dynamicHandler.set(dynamicHandler.cfg, (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.asString)(fallback), fbValue);
            }
            if (isDefaultValid(defValue)) {
                // We have a valid default so break out of the look
                break;
            }
        }
    }
    // If the value is still not defined and we have a default value then use that
    if (!isDefaultValid(defValue) && isDefaultValid(cfgDefaults.v)) {
        defValue = cfgDefaults.v;
    }
    return defValue;
}
/**
 * Recursively resolve the default value
 * @param dynamicHandler
 * @param theConfig
 * @param cfgDefaults
 * @returns
 */
function _resolveDefaultValue(dynamicHandler, theConfig, cfgDefaults) {
    var theValue = cfgDefaults;
    if (cfgDefaults && _isConfigDefaults(cfgDefaults)) {
        theValue = _getDefault(dynamicHandler, theConfig, cfgDefaults);
    }
    if (theValue) {
        if (_isConfigDefaults(theValue)) {
            theValue = _resolveDefaultValue(dynamicHandler, theConfig, theValue);
        }
        var newValue_1;
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isArray)(theValue)) {
            newValue_1 = [];
            newValue_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] = theValue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */];
        }
        else if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isPlainObject)(theValue)) {
            newValue_1 = {};
        }
        if (newValue_1) {
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(theValue, function (key, value) {
                if (value && _isConfigDefaults(value)) {
                    value = _resolveDefaultValue(dynamicHandler, theConfig, value);
                }
                newValue_1[key] = value;
            });
            theValue = newValue_1;
        }
    }
    return theValue;
}
/**
 * Applies the default value on the config property and makes sure that it's dynamic
 * @param theConfig
 * @param name
 * @param defaultValue
 */
function _applyDefaultValue(dynamicHandler, theConfig, name, defaultValue) {
    // Resolve the initial config value from the provided value or use the defined default
    var isValid;
    var setFn;
    var defValue;
    var cfgDefaults = defaultValue;
    var mergeDf;
    var reference;
    var readOnly;
    var blkDynamicValue;
    if (_isConfigDefaults(cfgDefaults)) {
        // looks like a IConfigDefault
        isValid = cfgDefaults.isVal;
        setFn = cfgDefaults.set;
        readOnly = cfgDefaults[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_RD_ONLY /* @min:%2erdOnly */];
        blkDynamicValue = cfgDefaults[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_BLK_VAL /* @min:%2eblkVal */];
        mergeDf = cfgDefaults.mrg;
        reference = cfgDefaults.ref;
        if (!reference && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isUndefined)(reference)) {
            reference = !!mergeDf;
        }
        defValue = _getDefault(dynamicHandler, theConfig, cfgDefaults);
    }
    else {
        defValue = defaultValue;
    }
    if (blkDynamicValue) {
        // Mark the property so that any value assigned will be blocked from conversion, we need to do this
        // before assigning or fetching the value to ensure it's not converted
        dynamicHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_BLK_VAL /* @min:%2eblkVal */](theConfig, name);
    }
    // Set the value to the default value;
    var theValue;
    var usingDefault = true;
    var cfgValue = theConfig[name];
    // try and get and user provided values
    if (cfgValue || !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(cfgValue)) {
        // Use the defined theConfig[name] value
        theValue = cfgValue;
        usingDefault = false;
        // The values are different and we have a special default value check, which is used to
        // override config values like empty strings to continue using the default
        if (isValid && theValue !== defValue && !isValid(theValue)) {
            theValue = defValue;
            usingDefault = true;
        }
        if (setFn) {
            theValue = setFn(theValue, defValue, theConfig);
            usingDefault = theValue === defValue;
        }
    }
    if (!usingDefault) {
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isPlainObject)(theValue) || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isArray)(defValue)) {
            // we are using the user supplied value and it's an object
            if (mergeDf && defValue && ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isPlainObject)(defValue) || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isArray)(defValue))) {
                // Resolve/apply the defaults
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(defValue, function (dfName, dfValue) {
                    // Sets the value and makes it dynamic (if it doesn't already exist)
                    _applyDefaultValue(dynamicHandler, theValue, dfName, dfValue);
                });
            }
        }
    }
    else if (defValue) {
        // Just resolve the default
        theValue = _resolveDefaultValue(dynamicHandler, theConfig, defValue);
    }
    else {
        theValue = defValue;
    }
    // if (theValue && usingDefault && (isPlainObject(theValue) || isArray(theValue))) {
    //     theValue = _cfgDeepCopy(theValue);
    // }
    // Needed to ensure that the (potentially) new field is dynamic even if null/undefined
    dynamicHandler.set(theConfig, name, theValue);
    if (reference) {
        dynamicHandler.ref(theConfig, name);
    }
    if (readOnly) {
        dynamicHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_RD_ONLY /* @min:%2erdOnly */](theConfig, name);
    }
}
//# sourceMappingURL=ConfigDefaults.js.map

/***/ }),
/* 62 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_createState": () => (/* binding */ _createState)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(54);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(69);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8);
/* harmony import */ var _JavaScriptSDK_AggregationError__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(63);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(42);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





var symPrefix = "[[ai_";
var symPostfix = "]]";
function _createState(cfgHandler) {
    var _a;
    var dynamicPropertySymbol = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.newSymbol)(symPrefix + "get" + cfgHandler.uid + symPostfix);
    var dynamicPropertyReadOnly = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.newSymbol)(symPrefix + "ro" + cfgHandler.uid + symPostfix);
    var dynamicPropertyReferenced = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.newSymbol)(symPrefix + "rf" + cfgHandler.uid + symPostfix);
    var dynamicPropertyBlockValue = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.newSymbol)(symPrefix + "blkVal" + cfgHandler.uid + symPostfix);
    var dynamicPropertyDetail = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.newSymbol)(symPrefix + "dtl" + cfgHandler.uid + symPostfix);
    var _waitingHandlers = null;
    var _watcherTimer = null;
    var theState;
    function _useHandler(activeHandler, callback) {
        var prevWatcher = theState.act;
        try {
            theState.act = activeHandler;
            if (activeHandler && activeHandler[dynamicPropertyDetail]) {
                // Clear out the previously tracked details for this handler, so that access are re-evaluated
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(activeHandler[dynamicPropertyDetail], function (detail) {
                    detail.clr(activeHandler);
                });
                activeHandler[dynamicPropertyDetail] = [];
            }
            callback({
                cfg: cfgHandler.cfg,
                set: cfgHandler.set.bind(cfgHandler),
                setDf: cfgHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_SET_DF /* @min:%2esetDf */].bind(cfgHandler),
                ref: cfgHandler.ref.bind(cfgHandler),
                rdOnly: cfgHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_RD_ONLY /* @min:%2erdOnly */].bind(cfgHandler)
            });
        }
        catch (e) {
            var logger = cfgHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LOGGER /* @min:%2elogger */];
            if (logger) {
                // Don't let one individual failure break everyone
                logger[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_THROW_INTERNAL /* @min:%2ethrowInternal */](1 /* eLoggingSeverity.CRITICAL */, 107 /* _eInternalMessageId.ConfigWatcherException */, (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.dumpObj)(e));
            }
            // Re-throw the exception so that any true "error" is reported back to the called
            throw e;
        }
        finally {
            theState.act = prevWatcher || null;
        }
    }
    function _notifyWatchers() {
        if (_waitingHandlers) {
            var notifyHandlers = _waitingHandlers;
            _waitingHandlers = null;
            // Stop any timer as we are running them now anyway
            _watcherTimer && _watcherTimer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_CANCEL /* @min:%2ecancel */]();
            _watcherTimer = null;
            var watcherFailures_1 = [];
            // Now run the handlers
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(notifyHandlers, function (handler) {
                if (handler) {
                    if (handler[dynamicPropertyDetail]) {
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(handler[dynamicPropertyDetail], function (detail) {
                            // Clear out this handler from  previously tracked details, so that access are re-evaluated
                            detail.clr(handler);
                        });
                        handler[dynamicPropertyDetail] = null;
                    }
                    // The handler may have self removed as part of another handler so re-check
                    if (handler.fn) {
                        try {
                            _useHandler(handler, handler.fn);
                        }
                        catch (e) {
                            // Don't let a single failing watcher cause other watches to fail
                            watcherFailures_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](e);
                        }
                    }
                }
            });
            // During notification we may have had additional updates -- so notify those updates as well
            if (_waitingHandlers) {
                try {
                    _notifyWatchers();
                }
                catch (e) {
                    watcherFailures_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](e);
                }
            }
            if (watcherFailures_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] > 0) {
                (0,_JavaScriptSDK_AggregationError__WEBPACK_IMPORTED_MODULE_4__.throwAggregationError)("Watcher error(s): ", watcherFailures_1);
            }
        }
    }
    function _addWatcher(detail) {
        if (detail && detail.h[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] > 0) {
            if (!_waitingHandlers) {
                _waitingHandlers = [];
            }
            if (!_watcherTimer) {
                _watcherTimer = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.scheduleTimeout)(function () {
                    _watcherTimer = null;
                    _notifyWatchers();
                }, 0);
            }
            // Add all of the handlers for this detail (if not already present) - using normal for-loop for performance
            for (var idx = 0; idx < detail.h[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */]; idx++) {
                var handler = detail.h[idx];
                // Add this handler to the collection of handlers to re-execute
                if (handler && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.arrIndexOf)(_waitingHandlers, handler) === -1) {
                    _waitingHandlers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](handler);
                }
            }
        }
    }
    function _trackHandler(handler, detail) {
        if (handler) {
            var details = handler[dynamicPropertyDetail] = handler[dynamicPropertyDetail] || [];
            if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.arrIndexOf)(details, detail) === -1) {
                // If this detail is not already listed as tracked then add it so that we re-evaluate it's usage
                details[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](detail);
            }
        }
    }
    theState = (_a = {
            prop: dynamicPropertySymbol,
            ro: dynamicPropertyReadOnly,
            rf: dynamicPropertyReferenced
        },
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_BLK_VAL /* @min:blkVal */] = dynamicPropertyBlockValue,
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_HDLR /* @min:hdlr */] = cfgHandler,
        _a.add = _addWatcher,
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NOTIFY /* @min:notify */] = _notifyWatchers,
        _a.use = _useHandler,
        _a.trk = _trackHandler,
        _a);
    return theState;
}
//# sourceMappingURL=DynamicState.js.map

/***/ }),
/* 63 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "throwAggregationError": () => (/* binding */ throwAggregationError)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */




var aggregationErrorType;
/**
 * Throws an Aggregation Error which includes all of the errors that led to this error occurring
 * @param message - The message describing the aggregation error (the sourceError details are added to this)
 * @param sourceErrors - An array of the errors that caused this situation
 */
function throwAggregationError(message, sourceErrors) {
    if (!aggregationErrorType) {
        aggregationErrorType = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.createCustomError)("AggregationError", function (self, args) {
            if (args[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 1) {
                // Save the provided errors
                self.errors = args[1];
            }
        });
    }
    var theMessage = message || "One or more errors occurred.";
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.arrForEach)(sourceErrors, function (srcError, idx) {
        theMessage += "\n".concat(idx, " > ").concat((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.dumpObj)(srcError));
    });
    throw new aggregationErrorType(theMessage, sourceErrors || []);
}
//# sourceMappingURL=AggregationError.js.map

/***/ }),
/* 64 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createCustomError": () => (/* binding */ createCustomError),
/* harmony export */   "throwUnsupported": () => (/* binding */ throwUnsupported)
/* harmony export */ });
/* harmony import */ var _array_slice__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(68);
/* harmony import */ var _funcs_fnApply__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(67);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _object_create__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(66);
/* harmony import */ var _object_define__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(22);
/* harmony import */ var _object_object__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(33);
/* harmony import */ var _object_set_proto__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */







/**
 * @internal
 * @ignore
 */
var _createCustomError = function (name, d, b) {
    _safeDefineName(d, name);
    d = (0,_object_set_proto__WEBPACK_IMPORTED_MODULE_0__.objSetPrototypeOf)(d, b);
    function __() {
        this.constructor = d;
        _safeDefineName(this, name);
    }
    d[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.PROTOTYPE] = b === _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE ? (0,_object_create__WEBPACK_IMPORTED_MODULE_2__.objCreate)(b) : (__[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.PROTOTYPE] = b[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.PROTOTYPE], new __());
    return d;
};
var _safeSetName = function (baseClass, name) {
    try {
        name && (baseClass[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.NAME] = name);
        //name && (baseClass[PROTOTYPE][NAME] = name);
    }
    catch (e) {
        // Do nothing
    }
};
var _safeDefineName = function (target, name) {
    try {
        (0,_object_define__WEBPACK_IMPORTED_MODULE_3__.objDefine)(target, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NAME, { v: name, c: true, e: false });
    }
    catch (e) {
        // Do nothing
    }
};
/**
 * Create a Custom Error class which may be used to throw custom errors.
 * @group Error
 * @param name - The name of the Custom Error
 * @param constructCb - [Optional] An optional callback function to call when a
 * new Customer Error instance is being created.
 * @param errorBase - [Optional] (since v0.9.6) The error class to extend for this class, defaults to Error.
 * @returns A new Error `class`
 * @example
 * ```ts
 * import { createCustomError, isError } from "@nevware21/ts-utils";
 *
 * // For an error that just contains a message
 * let myCustomErrorError = createCustomError("MessageError");
 *
 * try {
 *     throw new myCustomErrorError("Error Message!");
 * } catch(e) {
 *      // e.name === MessageError
 *      // isError(e) === true;
 *      // Object.prototype.toString.call(e) === "[object Error]";
 * }
 *
 * // Or a more complex error object
 * interface MyCriticalErrorConstructor extends CustomErrorConstructor {
 *     new(message: string, file: string, line: number, col: number): MyCriticalError;
 *     (message: string, file: string, line: number, col: number): MyCriticalError;
 * }
 *
 * interface MyCriticalError extends Error {
 *     readonly errorId: number;
 *     readonly args: any[];        // Holds all of the arguments passed during construction
 * }
 *
 * let _totalErrors = 0;
 * let myCustomError = createCustomError<MyCriticalErrorConstructor>("CriticalError", (self, args) => {
 *     _totalErrors++;
 *     self.errorId = _totalErrors;
 *     self.args = args;
 * });
 *
 * try {
 *     throw new myCustomError("Not Again!");
 * } catch(e) {
 *      // e.name === CriticalError
 *      // isError(e) === true;
 *      // Object.prototype.toString.call(e) === "[object Error]";
 * }
 *
 * // ----------------------------------------------------------
 * // Extending another custom error class
 * // ----------------------------------------------------------
 *
 * let AppError = createCustomError("ApplicationError");
 * let theAppError = new appError();
 *
 * isError(theAppError);                    // true
 * theAppError instanceof Error;            // true
 * theAppError instanceof AppError;         // true
 *
 * let StartupError = createCustomError("StartupError", null, AppError);
 * let theStartupError = new StartupError();
 *
 * isError(theStartupError);                // true
 * theStartupError instanceof Error;        // true
 * theStartupError instanceof AppError;     // true
 * theStartupError instanceof StartupError; // true
 * ```
 */
function createCustomError(name, constructCb, errorBase) {
    var theBaseClass = errorBase || Error;
    var orgName = theBaseClass[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.PROTOTYPE][_internal_constants__WEBPACK_IMPORTED_MODULE_1__.NAME];
    var captureFn = Error.captureStackTrace;
    return _createCustomError(name, function () {
        var _this = this;
        try {
            _safeSetName(theBaseClass, name);
            var _self = (0,_funcs_fnApply__WEBPACK_IMPORTED_MODULE_4__.fnApply)(theBaseClass, _this, (0,_array_slice__WEBPACK_IMPORTED_MODULE_5__.arrSlice)(arguments)) || _this;
            if (_self !== _this) {
                // Looks like runtime error constructor reset the prototype chain, so restore it
                var orgProto = (0,_object_object__WEBPACK_IMPORTED_MODULE_6__.objGetPrototypeOf)(_this);
                if (orgProto !== (0,_object_object__WEBPACK_IMPORTED_MODULE_6__.objGetPrototypeOf)(_self)) {
                    (0,_object_set_proto__WEBPACK_IMPORTED_MODULE_0__.objSetPrototypeOf)(_self, orgProto);
                }
            }
            // Make sure we only capture our stack details
            captureFn && captureFn(_self, _this[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.CONSTRUCTOR]);
            // Run the provided construction function
            constructCb && constructCb(_self, arguments);
            return _self;
        }
        finally {
            _safeSetName(theBaseClass, orgName);
        }
    }, theBaseClass);
}
/**
 * @internal
 * @ignore
 */
var _unsupportedError;
/**
 * Throw a custom `UnsupportedError` Error instance with the given message.
 * @group Error
 * @param message - The message to include in the exception
 * @example
 * ```ts
 * import { throwUnsupported } from "@nevware21/ts-utils";
 *
 * if (!window) {
 *     throwUnsupported("A window is needed for this operation");
 * }
 * ```
 */
function throwUnsupported(message) {
    if (!_unsupportedError) {
        // Lazily create the class
        _unsupportedError = createCustomError("UnsupportedError");
    }
    throw new _unsupportedError(message);
}
//# sourceMappingURL=customError.js.map

/***/ }),
/* 65 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "objSetPrototypeOf": () => (/* binding */ objSetPrototypeOf)
/* harmony export */ });
/* harmony import */ var _helpers_lazy__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/* harmony import */ var _for_each_key__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */



var _isProtoArray;
/**
 * The objSetPrototypeOf() method sets the prototype (i.e., the internal [Prototype] property) of a specified
 * object to another object or null.
 * @group Object
 * @param obj - The object which is to have it's prototype set.
 * @param proto - The object's new prototype (an object or null)
 * @returns The specified object.
 */
function objSetPrototypeOf(obj, proto) {
    var fn = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.setPrototypeOf ||
        // tslint:disable-next-line: only-arrow-functions
        function (d, b) {
            !_isProtoArray && (_isProtoArray = (0,_helpers_lazy__WEBPACK_IMPORTED_MODULE_1__.getLazy)(function () {
                var _a;
                return ((_a = {}, _a[_internal_constants__WEBPACK_IMPORTED_MODULE_0__.__PROTO__] = [], _a) instanceof Array);
            }));
            _isProtoArray.v ? d[_internal_constants__WEBPACK_IMPORTED_MODULE_0__.__PROTO__] = b : (0,_for_each_key__WEBPACK_IMPORTED_MODULE_2__.objForEachKey)(b, function (key, value) { return d[key] = value; });
        };
    return fn(obj, proto);
}
//# sourceMappingURL=set_proto.js.map

/***/ }),
/* 66 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "objCreate": () => (/* binding */ objCreate),
/* harmony export */   "polyObjCreate": () => (/* binding */ polyObjCreate)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/* harmony import */ var _helpers_diagnostics__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(13);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


var _objCreate = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.create;
/**
 * Creates an object that has the specified prototype, and that optionally contains specified properties. This helper exists to avoid adding a polyfil
 * for older browsers that do not define Object.create eg. ES3 only, IE8 just in case any page checks for presence/absence of the prototype implementation.
 * Note: For consistency this will not use the Object.create implementation if it exists as this would cause a testing requirement to test with and without the implementations
 * @group Object
 * @param obj Object to use as a prototype. May be null
 */
var objCreate = _objCreate || polyObjCreate;
/**
 * Creates an object that has the specified prototype, and that optionally contains specified properties. This helper exists to avoid adding a polyfil
 * for older browsers that do not define Object.create eg. ES3 only, IE8 just in case any page checks for presence/absence of the prototype implementation.
 * Note: For consistency this will not use the Object.create implementation if it exists as this would cause a testing requirement to test with and without the implementations
 * @group Polyfill
 * @group Object
 * @param obj Object to use as a prototype. May be null
 */
function polyObjCreate(obj) {
    if (!obj) {
        return {};
    }
    var type = typeof obj;
    if (type !== _internal_constants__WEBPACK_IMPORTED_MODULE_0__.OBJECT && type !== _internal_constants__WEBPACK_IMPORTED_MODULE_0__.FUNCTION) {
        throw new TypeError("Prototype must be an Object or function: " + (0,_helpers_diagnostics__WEBPACK_IMPORTED_MODULE_1__.dumpObj)(obj));
    }
    function tempFunc() { }
    tempFunc[_internal_constants__WEBPACK_IMPORTED_MODULE_0__.PROTOTYPE] = obj;
    return new tempFunc();
}
//# sourceMappingURL=create.js.map

/***/ }),
/* 67 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "fnApply": () => (/* binding */ fnApply)
/* harmony export */ });
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2023 Nevware21
 * Licensed under the MIT license.
 */

/**
 * The `fnApply` function calls the specified `fn` function with the given `thisArg` as the `this` value,
 * and the optional `argArray` arguments provided as an array (or an Array-Like Object).
 *
 * Normally, when calling a function, the value of `this` inside the function is the object that the
 * function was accessed on. With `fnApply()`, you can assign an arbitrary value as this when calling an
 * existing function, without first attaching the function to the object as a property. This allows you
 * to use methods of one object as generic utility functions.
 *
 * You can also use any kind of object which is ArrayLike as the second parameter. In practice, this means
 * that it needs to have a length property, and integer ("index") properties in the range (0..length - 1).
 * For example, you could use a NodeList, or a custom object like `{ 'length': 2, '0': 'eat', '1': 'bananas' }`.
 * You can also use `arguments`.
 *
 * @since 0.9.8
 * @group Function
 *
 * @param fn - The function to be called
 * @param thisArg - The value of `this` provided for the call to `fn`. If the function is not in strict mode,
 * `null` and `undefined` will be replaced with the global object, and primitive values will be converted to objects.
 * @param argArray - An array-like object, specifying the arguments with which `fn` should be called, or `null` or
 * `undefined` if no arguments should be provided to the function.
 * @returns The result of calling the function with the specified `this` value and arguments.
 * @example
 * ```ts
 * // min / max number in an array
 * let max = fnApply(Math.max, null, [ 21, 42, 84, 168, 7, 3 ]);
 * // 168
 *
 * let min = fnApply(Math.min, null, [ 21, 42, 84, 168, 7, 3 ]);
 * // 3
 *
 * const module1 = {
 *     prefix: "Hello",
 *     x: 21,
 *     getX() {
 *         return this.x;
 *     },
 *     log(value: string) {
 *         return this.prefix + " " + value + " : " + this.x
 *     }
 * };
 *
 * // The 'this' parameter of 'getX' is bound to 'module'.
 * module1.getX(); // 21
 * module1.log("Darkness"); // Hello Darkness : 21
 *
 * // Create a new function 'boundGetX' with the 'this' parameter bound to 'module'.
 * let module2 = {
 *     prefix: "my",
 *     x: 42
 * };
 *
 * // Call the function of module1 with module2 as it's this
 * fnApply(module1.getX, module2); // 42
 * fnApply(module1.log, module2, [ "friend" ]); // my friend : 42
 * ```
 */
var fnApply = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapInstFunction)("apply");
//# sourceMappingURL=fnApply.js.map

/***/ }),
/* 68 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "arrSlice": () => (/* binding */ arrSlice)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * The arrSlice() method returns a shallow copy of a portion of an array into a new array object
 * selected from start to end (end not included) where start and end represent the index of items
 * in that array. The original array will not be modified.
 *
 * The `arrSlice()` method is a copying method. It does not alter this but instead returns a shallow
 * copy that contains some of the same elements as the ones from the original array.
 *
 * The `arrSlice()` method preserves empty slots. If the sliced portion is sparse, the returned arra
 * is sparse as well.
 *
 * The `arrSlice()` method is generic. It only expects the this value to have a length property and
 * integer-keyed properties.
 *
 * For both start and end, a negative index can be used to indicate an offset from the end of the array.
 * For example, -2 refers to the second to last element of the array.
 * @since 0.9.3
 * @group Array
 * @group ArrayLike
 * @param start Zero-based index at which to start extraction, converted to an integer.
 * - Negative index counts back from the end of the array — if start < 0, start + array.length is used.
 * - If start < -array.length or start is omitted, 0 is used.
 * - If start >= array.length, nothing is extracted.
 * @param end Zero-based index at which to end extraction, converted to an integer. slice() extracts
 * up to but not including end.
 * - Negative index counts back from the end of the array — if end < 0, end + array.length is used.
 * - If end < -array.length, 0 is used.
 * - If end >= array.length or end is omitted, array.length is used, causing all elements until the
 * end to be extracted.
 * - If end is positioned before or at start after normalization, nothing is extracted.
 * @example
 * ```ts
 * const lyrics = ["Hello", "Darkness", "my", "old", "friend.", "I've", "come", "to", "talk" ];
 *
 * arrSlice(lyrics);        // [ "Hello", "Darkness", "my", "old", "friend.", "I've", "come", "to", "talk" ]
 * arrSlice(lyrics, 1, 3);  // [ "Darkness", "my" ]
 * arrSlicw(lyrics, 2);     // [ "my", "old", "friend.", "I've", "come", "to", "talk" ]
 * arrSlice(lyrics, 2, 4);  // [ "my", "old" ]
 * arrSlice(lyrics, 1, 5);  // [ "Darkness", "my", "old", "friend." ]
 * arrSlice(lyrics, -2);    // [ "to", "talk" ]
 * arrSlice(lyrics, 2, -1); // [ "my", "old", "friend.", "I've", "come", "to" ]
 * ```
 */
var arrSlice = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunction)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.SLICE, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.ArrProto);
//# sourceMappingURL=slice.js.map

/***/ }),
/* 69 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createTimeout": () => (/* binding */ createTimeout),
/* harmony export */   "createTimeoutWith": () => (/* binding */ createTimeoutWith),
/* harmony export */   "scheduleTimeout": () => (/* binding */ scheduleTimeout),
/* harmony export */   "scheduleTimeoutWith": () => (/* binding */ scheduleTimeoutWith)
/* harmony export */ });
/* harmony import */ var _array_slice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(68);
/* harmony import */ var _funcs_fnApply__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67);
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(70);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */





function _createTimeoutWith(self, startTimer, overrideFn, theArgs) {
    var isArr = (0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isArray)(overrideFn);
    var len = isArr ? overrideFn.length : 0;
    var setFn = (len > 0 ? overrideFn[0] : (!isArr ? overrideFn : _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE)) || setTimeout;
    var clearFn = (len > 1 ? overrideFn[1] : _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE) || clearTimeout;
    var timerFn = theArgs[0];
    theArgs[0] = function () {
        handler.dn();
        (0,_funcs_fnApply__WEBPACK_IMPORTED_MODULE_2__.fnApply)(timerFn, self, (0,_array_slice__WEBPACK_IMPORTED_MODULE_3__.arrSlice)(arguments));
    };
    var handler = (0,_handler__WEBPACK_IMPORTED_MODULE_4__._createTimerHandler)(startTimer, function (timerId) {
        if (timerId) {
            if (timerId.refresh) {
                timerId.refresh();
                return timerId;
            }
            (0,_funcs_fnApply__WEBPACK_IMPORTED_MODULE_2__.fnApply)(clearFn, self, [timerId]);
        }
        return (0,_funcs_fnApply__WEBPACK_IMPORTED_MODULE_2__.fnApply)(setFn, self, theArgs);
    }, function (timerId) {
        (0,_funcs_fnApply__WEBPACK_IMPORTED_MODULE_2__.fnApply)(clearFn, self, [timerId]);
    });
    return handler.h;
}
function scheduleTimeout(callback, timeout) {
    return _createTimeoutWith(this, true, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE, (0,_array_slice__WEBPACK_IMPORTED_MODULE_3__.arrSlice)(arguments));
}
function scheduleTimeoutWith(overrideFn, callback, timeout) {
    return _createTimeoutWith(this, true, overrideFn, (0,_array_slice__WEBPACK_IMPORTED_MODULE_3__.arrSlice)(arguments, 1));
}
function createTimeout(callback, timeout) {
    return _createTimeoutWith(this, false, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE, (0,_array_slice__WEBPACK_IMPORTED_MODULE_3__.arrSlice)(arguments));
}
function createTimeoutWith(overrideFn, callback, timeout) {
    return _createTimeoutWith(this, false, overrideFn, (0,_array_slice__WEBPACK_IMPORTED_MODULE_3__.arrSlice)(arguments, 1));
}
//# sourceMappingURL=timeout.js.map

/***/ }),
/* 70 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_createTimerHandler": () => (/* binding */ _createTimerHandler)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/* harmony import */ var _object_define__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


var REF = "ref";
var UNREF = "un" + REF;
var HAS_REF = "hasRef";
var ENABLED = "enabled";
/**
 * @ignore
 * @internal
 * Internal function to create and manage an ITimerHandler implementation, the object returned from this function
 * it directly used / returned by the pulic functions used to create timers (idle, interval and timeout)
 * @param startTimer - Should the timer be started as part of creating the handler
 * @param refreshFn - The function used to create/start or refresh the timer
 * @param cancelFn - The function used to cancel the timer.
 * @returns The new ITimerHandler instance
 */
function _createTimerHandler(startTimer, refreshFn, cancelFn) {
    var _a;
    var ref = true;
    var timerId = startTimer ? refreshFn(_internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE) : _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE;
    var theTimerHandler;
    var _unref = function () {
        ref = false;
        timerId && timerId[UNREF] && timerId[UNREF]();
        return theTimerHandler;
    };
    var _ref = function () {
        ref = true;
        timerId && timerId[REF] && timerId[REF]();
        return theTimerHandler;
    };
    var _hasRef = function () {
        if (timerId && timerId[HAS_REF]) {
            return timerId[HAS_REF]();
        }
        return ref;
    };
    var _refresh = function () {
        timerId = refreshFn(timerId);
        if (!ref) {
            _unref();
        }
        return theTimerHandler;
    };
    var _cancel = function () {
        timerId && cancelFn(timerId);
        timerId = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE;
    };
    var _setEnabled = function (value) {
        !value && timerId && _cancel();
        value && !timerId && _refresh();
    };
    theTimerHandler = (_a = {
            cancel: _cancel,
            refresh: _refresh
        },
        _a[HAS_REF] = _hasRef,
        _a[REF] = _ref,
        _a[UNREF] = _unref,
        _a[ENABLED] = false,
        _a);
    (0,_object_define__WEBPACK_IMPORTED_MODULE_1__.objDefineProp)(theTimerHandler, ENABLED, {
        get: function () { return !!timerId; },
        set: _setEnabled
    });
    return {
        h: theTimerHandler,
        dn: function () {
            timerId = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE;
        }
    };
}
//# sourceMappingURL=handler.js.map

/***/ }),
/* 71 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getDebugExt": () => (/* binding */ getDebugExt),
/* harmony export */   "getDebugListener": () => (/* binding */ getDebugListener)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(18);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





var listenerFuncs = [_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EVENTS_SENT, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EVENTS_DISCARDED, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EVENTS_SEND_REQUEST, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_PERF_EVENT];
var _aiNamespace = null;
var _debugListener;
function _listenerProxyFunc(name, config) {
    return function () {
        var args = arguments;
        var dbgExt = getDebugExt(config);
        if (dbgExt) {
            var listener = dbgExt.listener;
            if (listener && listener[name]) {
                listener[name][_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_APPLY /* @min:%2eapply */](listener, args);
            }
        }
    };
}
function _getExtensionNamespace() {
    // Cache the lookup of the global namespace object
    var target = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)("Microsoft");
    if (target) {
        _aiNamespace = target["ApplicationInsights"];
    }
    return _aiNamespace;
}
function getDebugExt(config) {
    var ns = _aiNamespace;
    if (!ns && config.disableDbgExt !== true) {
        ns = _aiNamespace || _getExtensionNamespace();
    }
    return ns ? ns["ChromeDbgExt"] : null;
}
function getDebugListener(config) {
    if (!_debugListener) {
        _debugListener = {};
        for (var lp = 0; lp < listenerFuncs[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; lp++) {
            _debugListener[listenerFuncs[lp]] = _listenerProxyFunc(listenerFuncs[lp], config);
        }
    }
    return _debugListener;
}
//# sourceMappingURL=DbgExtensionUtils.js.map

/***/ }),
/* 72 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createTraceParent": () => (/* binding */ createTraceParent),
/* harmony export */   "findW3cTraceParent": () => (/* binding */ findW3cTraceParent),
/* harmony export */   "formatTraceParent": () => (/* binding */ formatTraceParent),
/* harmony export */   "isSampledFlag": () => (/* binding */ isSampledFlag),
/* harmony export */   "isValidSpanId": () => (/* binding */ isValidSpanId),
/* harmony export */   "isValidTraceId": () => (/* binding */ isValidTraceId),
/* harmony export */   "isValidTraceParent": () => (/* binding */ isValidTraceParent),
/* harmony export */   "parseTraceParent": () => (/* binding */ parseTraceParent)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(36);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(39);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(42);
/* harmony import */ var _CoreUtils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(73);
/* harmony import */ var _EnvUtils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(44);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(43);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





// using {0,16} for leading and trailing whitespace just to constrain the possible runtime of a random string
var TRACE_PARENT_REGEX = /^([\da-f]{2})-([\da-f]{32})-([\da-f]{16})-([\da-f]{2})(-[^\s]{1,64})?$/i;
var DEFAULT_VERSION = "00";
var INVALID_VERSION = "ff";
var INVALID_TRACE_ID = "00000000000000000000000000000000";
var INVALID_SPAN_ID = "0000000000000000";
var SAMPLED_FLAG = 0x01;
function _isValid(value, len, invalidValue) {
    if (value && value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] === len && value !== invalidValue) {
        return !!value.match(/^[\da-f]*$/i);
    }
    return false;
}
function _formatValue(value, len, defValue) {
    if (_isValid(value, len)) {
        return value;
    }
    return defValue;
}
function _formatFlags(value) {
    if (isNaN(value) || value < 0 || value > 255) {
        value = 0x01;
    }
    var result = value.toString(16);
    while (result[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] < 2) {
        result = "0" + result;
    }
    return result;
}
/**
 * Create a new ITraceParent instance using the provided values.
 * @param traceId - The traceId to use, when invalid a new random W3C id will be generated.
 * @param spanId - The parent/span id to use, a new random value will be generated if it is invalid.
 * @param flags - The traceFlags to use, defaults to zero (0) if not supplied or invalid
 * @param version - The version to used, defaults to version "01" if not supplied or invalid.
 * @returns
 */
function createTraceParent(traceId, spanId, flags, version) {
    var _a;
    return _a = {},
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_VERSION /* @min:version */] = _isValid(version, 2, INVALID_VERSION) ? version : DEFAULT_VERSION,
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_ID /* @min:traceId */] = isValidTraceId(traceId) ? traceId : (0,_CoreUtils__WEBPACK_IMPORTED_MODULE_1__.generateW3CId)(),
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SPAN_ID /* @min:spanId */] = isValidSpanId(spanId) ? spanId : (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.strLeft)((0,_CoreUtils__WEBPACK_IMPORTED_MODULE_1__.generateW3CId)(), 16),
        _a.traceFlags = flags >= 0 && flags <= 0xFF ? flags : 1,
        _a;
}
/**
 * Attempt to parse the provided string as a W3C TraceParent header value (https://www.w3.org/TR/trace-context/#traceparent-header)
 *
 * @param value - The value to be parsed
 * @param selectIdx - If the found value is comma separated which is the preferred entry to select, defaults to the first
 * @returns
 */
function parseTraceParent(value, selectIdx) {
    var _a;
    if (!value) {
        // Don't pass a null/undefined or empty string
        return null;
    }
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isArray)(value)) {
        // The value may have been encoded on the page into an array so handle this automatically
        value = value[0] || "";
    }
    if (!value || !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isString)(value) || value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 8192) {
        // limit potential processing based on total length
        return null;
    }
    if (value.indexOf(",") !== -1) {
        var values = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SPLIT /* @min:%2esplit */](",");
        value = values[selectIdx > 0 && values[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > selectIdx ? selectIdx : 0];
    }
    // See https://www.w3.org/TR/trace-context/#versioning-of-traceparent
    var match = TRACE_PARENT_REGEX.exec((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.strTrim)(value));
    if (!match || // No match
        match[1] === INVALID_VERSION || // version ff is forbidden
        match[2] === INVALID_TRACE_ID || // All zeros is considered to be invalid
        match[3] === INVALID_SPAN_ID) { // All zeros is considered to be invalid
        return null;
    }
    return _a = {
            version: (match[1] || _InternalConstants__WEBPACK_IMPORTED_MODULE_5__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */](),
            traceId: (match[2] || _InternalConstants__WEBPACK_IMPORTED_MODULE_5__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */](),
            spanId: (match[3] || _InternalConstants__WEBPACK_IMPORTED_MODULE_5__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]()
        },
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_FLAGS /* @min:traceFlags */] = parseInt(match[4], 16),
        _a;
}
/**
 * Is the provided W3c Trace Id a valid string representation, it must be a 32-character string
 * of lowercase hexadecimal characters for example, 4bf92f3577b34da6a3ce929d0e0e4736.
 * If all characters as zero (00000000000000000000000000000000) it will be considered an invalid value.
 * @param value - The W3c trace Id to be validated
 * @returns true if valid otherwise false
 */
function isValidTraceId(value) {
    return _isValid(value, 32, INVALID_TRACE_ID);
}
/**
 * Is the provided W3c span id (aka. parent id) a valid string representation, it must be a 16-character
 * string of lowercase hexadecimal characters, for example, 00f067aa0ba902b7.
 * If all characters are zero (0000000000000000) this is considered an invalid value.
 * @param value - The W3c span id to be validated
 * @returns true if valid otherwise false
 */
function isValidSpanId(value) {
    return _isValid(value, 16, INVALID_SPAN_ID);
}
/**
 * Validates that the provided ITraceParent instance conforms to the currently supported specifications
 * @param value
 * @returns
 */
function isValidTraceParent(value) {
    if (!value ||
        !_isValid(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_VERSION /* @min:%2eversion */], 2, INVALID_VERSION) ||
        !_isValid(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_ID /* @min:%2etraceId */], 32, INVALID_TRACE_ID) ||
        !_isValid(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SPAN_ID /* @min:%2espanId */], 16, INVALID_SPAN_ID) ||
        !_isValid(_formatFlags(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_FLAGS /* @min:%2etraceFlags */]), 2)) {
        // Each known field must contain a valid value
        return false;
    }
    return true;
}
/**
 * Is the parsed traceParent indicating that the trace is currently sampled.
 * @param value - The parsed traceParent value
 * @returns
 */
function isSampledFlag(value) {
    if (isValidTraceParent(value)) {
        return (value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_FLAGS /* @min:%2etraceFlags */] & SAMPLED_FLAG) === SAMPLED_FLAG;
    }
    return false;
}
/**
 * Format the ITraceParent value as a string using the supported and know version formats.
 * So even if the passed traceParent is a later version the string value returned from this
 * function will convert it to only the known version formats.
 * This currently only supports version "00" and invalid "ff"
 * @param value - The parsed traceParent value
 * @returns
 */
function formatTraceParent(value) {
    if (value) {
        // Special Note: This only supports formatting as version 00, future versions should encode any known supported version
        // So parsing a future version will populate the correct version value but reformatting will reduce it to version 00.
        var flags = _formatFlags(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_FLAGS /* @min:%2etraceFlags */]);
        if (!_isValid(flags, 2)) {
            flags = "01";
        }
        var version = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_VERSION /* @min:%2eversion */] || DEFAULT_VERSION;
        if (version !== "00" && version !== "ff") {
            // Reduce version to "00"
            version = DEFAULT_VERSION;
        }
        // Format as version 00
        return "".concat(version.toLowerCase(), "-").concat(_formatValue(value.traceId, 32, INVALID_TRACE_ID).toLowerCase(), "-").concat(_formatValue(value.spanId, 16, INVALID_SPAN_ID).toLowerCase(), "-").concat(flags.toLowerCase());
    }
    return "";
}
/**
 * Helper function to fetch the passed traceparent from the page, looking for it as a meta-tag or a Server-Timing header.
 * @param selectIdx - If the found value is comma separated which is the preferred entry to select, defaults to the first
 * @returns
 */
function findW3cTraceParent(selectIdx) {
    var name = "traceparent";
    var traceParent = parseTraceParent((0,_EnvUtils__WEBPACK_IMPORTED_MODULE_6__.findMetaTag)(name), selectIdx);
    if (!traceParent) {
        traceParent = parseTraceParent((0,_EnvUtils__WEBPACK_IMPORTED_MODULE_6__.findNamedServerTiming)(name), selectIdx);
    }
    return traceParent;
}
//# sourceMappingURL=W3cTraceParent.js.map

/***/ }),
/* 73 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Undefined": () => (/* binding */ Undefined),
/* harmony export */   "generateW3CId": () => (/* binding */ generateW3CId),
/* harmony export */   "newGuid": () => (/* binding */ newGuid),
/* harmony export */   "strEndsWith": () => (/* binding */ strEndsWith)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(45);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(42);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(43);
/* harmony import */ var _RandomHelper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(59);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */








// Added to help with minfication
var Undefined = _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimUndefined;
function newGuid() {
    var uuid = generateW3CId();
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstring)(uuid, 0, 8) + "-" + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstring)(uuid, 8, 12) + "-" + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstring)(uuid, 12, 16) + "-" + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstring)(uuid, 16, 20) + "-" + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstring)(uuid, 20);
}
/**
 * The strEndsWith() method determines whether a string ends with the characters of a specified string, returning true or false as appropriate.
 * @param value - The value to check whether it ends with the search value.
 * @param search - The characters to be searched for at the end of the value.
 * @returns true if the given search value is found at the end of the string, otherwise false.
 */
function strEndsWith(value, search) {
    if (value && search) {
        var len = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */];
        var start = len - search[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */];
        return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstring)(value, start >= 0 ? start : 0, len) === search;
    }
    return false;
}
/**
 * generate W3C trace id
 */
function generateW3CId() {
    var hexValues = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"];
    // rfc4122 version 4 UUID without dashes and with lowercase letters
    var oct = _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EMPTY, tmp;
    for (var a = 0; a < 4; a++) {
        tmp = (0,_RandomHelper__WEBPACK_IMPORTED_MODULE_4__.random32)();
        oct +=
            hexValues[tmp & 0xF] +
                hexValues[tmp >> 4 & 0xF] +
                hexValues[tmp >> 8 & 0xF] +
                hexValues[tmp >> 12 & 0xF] +
                hexValues[tmp >> 16 & 0xF] +
                hexValues[tmp >> 20 & 0xF] +
                hexValues[tmp >> 24 & 0xF] +
                hexValues[tmp >> 28 & 0xF];
    }
    // "Set the two most significant bits (bits 6 and 7) of the clock_seq_hi_and_reserved to zero and one, respectively"
    var clockSequenceHi = hexValues[8 + ((0,_RandomHelper__WEBPACK_IMPORTED_MODULE_4__.random32)() & 0x03) | 0];
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstr)(oct, 0, 8) + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstr)(oct, 9, 4) + "4" + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstr)(oct, 13, 3) + clockSequenceHi + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstr)(oct, 16, 3) + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstr)(oct, 19, 12);
}
//# sourceMappingURL=CoreUtils.js.map

/***/ }),
/* 74 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ThrottleMgr": () => (/* binding */ ThrottleMgr)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(41);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(46);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(52);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(8);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(39);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(59);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24);
/* harmony import */ var _StorageHelperFuncs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(75);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */




var THROTTLE_STORAGE_PREFIX = "appInsightsThrottle";
var ThrottleMgr = /** @class */ (function () {
    function ThrottleMgr(core, namePrefix) {
        var _self = this;
        var _canUseLocalStorage;
        var _logger;
        var _config;
        var _localStorageObj;
        var _isTriggered; //_isTriggered is to make sure that we only trigger throttle once a day
        var _namePrefix;
        var _queue;
        var _isReady = false;
        var _isSpecificDaysGiven = false;
        _initConfig();
        // Special internal method to allow the unit tests and DebugPlugin to hook embedded objects
        _self["_getDbgPlgTargets"] = function () {
            return [_queue];
        };
        _self.getConfig = function () {
            return _config;
        };
        /**
         * Check if it is the correct day to send message.
         * If _isTriggered is true, even if canThrottle returns true, message will not be sent,
         * because we only allow triggering sendMessage() once a day.
         * @returns if the current date is the valid date to send message
         */
        _self.canThrottle = function (msgId) {
            var localObj = _getLocalStorageObjByKey(msgId);
            var cfg = _getCfgByKey(msgId);
            return _canThrottle(cfg, _canUseLocalStorage, localObj);
        };
        /**
         * Check if throttle is triggered on current day(UTC)
         * if canThrottle returns false, isTriggered will return false
         * @returns if throttle is triggered on current day(UTC)
         */
        _self.isTriggered = function (msgId) {
            return _isTrigger(msgId);
        };
        /**
         * Before isReady set to true, all message will be stored in queue.
         * Message will only be sent out after isReady set to true.
         * Initial and default value: false
         * @returns isReady state
         */
        _self.isReady = function () {
            return _isReady;
        };
        /**
         * Flush all message with given message key in queue with isReady state set to true.
         * @returns if message queue is flushed
         */
        _self.flush = function (msgId) {
            try {
                var queue = _getQueueByKey(msgId);
                if (queue && queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    var items = queue.slice(0);
                    _queue[msgId] = [];
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(items, function (item) {
                        _flushMessage(item.msgID, item[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE /* @min:%2emessage */], item.severity, false);
                    });
                    return true;
                }
            }
            catch (err) {
                // eslint-disable-next-line no-empty
            }
            return false;
        };
        /**
         * Flush all message in queue with isReady state set to true.
         * @returns if message queue is flushed
         */
        _self.flushAll = function () {
            try {
                if (_queue) {
                    var result_1 = true;
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.objForEachKey)(_queue, function (key) {
                        var isFlushed = _self.flush(parseInt(key));
                        result_1 = result_1 && isFlushed;
                    });
                    return result_1;
                }
            }
            catch (err) {
                // eslint-disable-next-line no-empty
            }
            return false;
        };
        /**
         * Set isReady State
         * if isReady set to true, message queue will be flushed automatically.
         * @param isReady isReady State
         * @pa
         * @returns if message queue is flushed
         */
        _self.onReadyState = function (isReady, flushAll) {
            if (flushAll === void 0) { flushAll = true; }
            _isReady = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(isReady) ? true : isReady;
            if (_isReady && flushAll) {
                return _self.flushAll();
            }
            return null;
        };
        _self.sendMessage = function (msgID, message, severity) {
            return _flushMessage(msgID, message, severity, true);
        };
        function _flushMessage(msgID, message, severity, saveUnsentMsg) {
            if (_isReady) {
                var isSampledIn = _canSampledIn(msgID);
                if (!isSampledIn) {
                    return;
                }
                var cfg = _getCfgByKey(msgID);
                var localStorageObj = _getLocalStorageObjByKey(msgID);
                var canThrottle = _canThrottle(cfg, _canUseLocalStorage, localStorageObj);
                var throttled = false;
                var number = 0;
                var isTriggered = _isTrigger(msgID);
                try {
                    if (canThrottle && !isTriggered) {
                        number = Math.min(cfg.limit.maxSendNumber, localStorageObj[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_COUNT /* @min:%2ecount */] + 1);
                        localStorageObj[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_COUNT /* @min:%2ecount */] = 0;
                        throttled = true;
                        _isTriggered[msgID] = true;
                        localStorageObj[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PRE_TRIGGER_DATE /* @min:%2epreTriggerDate */] = new Date();
                    }
                    else {
                        _isTriggered[msgID] = canThrottle;
                        localStorageObj[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_COUNT /* @min:%2ecount */] += 1;
                    }
                    var localStorageName = _getLocalStorageName(msgID);
                    _resetLocalStorage(_logger, localStorageName, localStorageObj);
                    for (var i = 0; i < number; i++) {
                        _sendMessage(msgID, _logger, message, severity);
                    }
                }
                catch (e) {
                    // eslint-disable-next-line no-empty
                }
                return {
                    isThrottled: throttled,
                    throttleNum: number
                };
            }
            else {
                if (!!saveUnsentMsg) {
                    var queue = _getQueueByKey(msgID);
                    queue.push({
                        msgID: msgID,
                        message: message,
                        severity: severity
                    });
                }
            }
            return null;
        }
        function _initConfig() {
            _logger = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.safeGetLogger)(core);
            _isTriggered = {};
            _localStorageObj = {};
            _queue = {};
            _config = {};
            _setCfgByKey(109 /* _eInternalMessageId.DefaultThrottleMsgKey */);
            _namePrefix = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.isNotNullOrUndefined)(namePrefix) ? namePrefix : "";
            core.addUnloadHook((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.onConfigChange)(core.config, function (details) {
                var coreConfig = details.cfg;
                _canUseLocalStorage = (0,_StorageHelperFuncs__WEBPACK_IMPORTED_MODULE_7__.utlCanUseLocalStorage)();
                var configMgr = coreConfig.throttleMgrCfg || {};
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.objForEachKey)(configMgr, function (key, cfg) {
                    _setCfgByKey(parseInt(key), cfg);
                });
            }));
        }
        function _getCfgByKey(msgID) {
            return _config[msgID] || _config[109 /* _eInternalMessageId.DefaultThrottleMsgKey */];
        }
        function _setCfgByKey(msgID, config) {
            var _a, _b;
            try {
                var cfg = config || {};
                var curCfg = {};
                curCfg[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DISABLED /* @min:%2edisabled */] = !!cfg[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DISABLED /* @min:%2edisabled */];
                var configInterval = cfg[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_INTERVAL /* @min:%2einterval */] || {};
                _isSpecificDaysGiven = (configInterval === null || configInterval === void 0 ? void 0 : configInterval.daysOfMonth) && (configInterval === null || configInterval === void 0 ? void 0 : configInterval.daysOfMonth[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */]) > 0;
                curCfg[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_INTERVAL /* @min:%2einterval */] = _getIntervalConfig(configInterval);
                var limit = {
                    samplingRate: ((_a = cfg.limit) === null || _a === void 0 ? void 0 : _a.samplingRate) || 100,
                    // dafault: every time sent only 1 event
                    maxSendNumber: ((_b = cfg.limit) === null || _b === void 0 ? void 0 : _b.maxSendNumber) || 1
                };
                curCfg.limit = limit;
                _config[msgID] = curCfg;
            }
            catch (e) {
                // eslint-disable-next-line no-empty
            }
        }
        function _getIntervalConfig(interval) {
            interval = interval || {};
            var monthInterval = interval === null || interval === void 0 ? void 0 : interval.monthInterval;
            var dayInterval = interval === null || interval === void 0 ? void 0 : interval.dayInterval;
            // default: send data every 3 month each year
            if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(monthInterval) && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(dayInterval)) {
                interval.monthInterval = 3;
                if (!_isSpecificDaysGiven) {
                    // default: send data on 28th
                    interval[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DAYS_OF_MONTH /* @min:%2edaysOfMonth */] = [28];
                    _isSpecificDaysGiven = true;
                }
            }
            interval = {
                // dafault: sent every three months
                monthInterval: interval === null || interval === void 0 ? void 0 : interval.monthInterval,
                dayInterval: interval === null || interval === void 0 ? void 0 : interval.dayInterval,
                daysOfMonth: interval === null || interval === void 0 ? void 0 : interval.daysOfMonth
            };
            return interval;
        }
        function _canThrottle(config, canUseLocalStorage, localStorageObj) {
            if (config && !config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DISABLED /* @min:%2edisabled */] && canUseLocalStorage && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.isNotNullOrUndefined)(localStorageObj)) {
                var curDate = _getThrottleDate();
                var date = localStorageObj[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DATE /* @min:%2edate */];
                var interval = config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_INTERVAL /* @min:%2einterval */];
                var monthCheck = 1;
                if (interval === null || interval === void 0 ? void 0 : interval.monthInterval) {
                    var monthExpand = (curDate.getUTCFullYear() - date.getUTCFullYear()) * 12 + curDate.getUTCMonth() - date.getUTCMonth();
                    monthCheck = _checkInterval(interval.monthInterval, 0, monthExpand);
                }
                var dayCheck = 1;
                if (_isSpecificDaysGiven) {
                    dayCheck = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.arrIndexOf)(interval[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DAYS_OF_MONTH /* @min:%2edaysOfMonth */], curDate[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_UTCDATE /* @min:%2egetUTCDate */]());
                }
                else if (interval === null || interval === void 0 ? void 0 : interval.dayInterval) {
                    var daySpan = Math.floor((curDate.getTime() - date.getTime()) / 86400000);
                    dayCheck = _checkInterval(interval.dayInterval, 0, daySpan);
                }
                return monthCheck >= 0 && dayCheck >= 0;
            }
            return false;
        }
        function _getLocalStorageName(msgKey, prefix) {
            var fix = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.isNotNullOrUndefined)(prefix) ? prefix : "";
            if (msgKey) {
                return THROTTLE_STORAGE_PREFIX + fix + "-" + msgKey;
            }
            return null;
        }
        // returns if throttle is triggered on current Date
        function _isTriggeredOnCurDate(preTriggerDate) {
            try {
                if (preTriggerDate) {
                    var curDate = new Date();
                    return preTriggerDate.getUTCFullYear() === curDate.getUTCFullYear() &&
                        preTriggerDate.getUTCMonth() === curDate.getUTCMonth() &&
                        preTriggerDate[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_UTCDATE /* @min:%2egetUTCDate */]() === curDate[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_UTCDATE /* @min:%2egetUTCDate */]();
                }
            }
            catch (e) {
                // eslint-disable-next-line no-empty
            }
            return false;
        }
        // transfer local storage string value to object that identifies start date, current count and preTriggerDate
        function _getLocalStorageObj(value, logger, storageName) {
            try {
                var storageObj = {
                    date: _getThrottleDate(),
                    count: 0
                };
                if (value) {
                    var obj = JSON.parse(value);
                    var curObj = {
                        date: _getThrottleDate(obj[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DATE /* @min:%2edate */]) || storageObj[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DATE /* @min:%2edate */],
                        count: obj[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_COUNT /* @min:%2ecount */] || storageObj[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_COUNT /* @min:%2ecount */],
                        preTriggerDate: obj.preTriggerDate ? _getThrottleDate(obj[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PRE_TRIGGER_DATE /* @min:%2epreTriggerDate */]) : undefined
                    };
                    return curObj;
                }
                else {
                    _resetLocalStorage(logger, storageName, storageObj);
                    return storageObj;
                }
            }
            catch (e) {
                // eslint-disable-next-line no-empty
            }
            return null;
        }
        // if datestr is not defined, current date will be returned
        function _getThrottleDate(dateStr) {
            // if new Date() can't be created through the provided dateStr, null will be returned.
            try {
                if (dateStr) {
                    var date = new Date(dateStr);
                    //make sure it is a valid Date Object
                    if (!isNaN(date.getDate())) {
                        return date;
                    }
                }
                else {
                    return new Date();
                }
            }
            catch (e) {
                // eslint-disable-next-line no-empty
            }
            return null;
        }
        function _resetLocalStorage(logger, storageName, obj) {
            try {
                return (0,_StorageHelperFuncs__WEBPACK_IMPORTED_MODULE_7__.utlSetLocalStorage)(logger, storageName, (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_9__.strTrim)(JSON[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_STRINGIFY /* @min:%2estringify */](obj)));
            }
            catch (e) {
                // eslint-disable-next-line no-empty
            }
            return false;
        }
        function _checkInterval(interval, start, current) {
            if (interval <= 0) {
                return 1;
            }
            // count from start year
            return (current >= start) && (current - start) % interval == 0 ? Math.floor((current - start) / interval) + 1 : -1;
        }
        function _sendMessage(msgID, logger, message, severity) {
            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__._throwInternal)(logger, severity || 1 /* eLoggingSeverity.CRITICAL */, msgID, message);
        }
        // NOTE: config.limit.samplingRate is set to 4 decimal places,
        // so config.limit.samplingRate = 1 means 0.0001%
        function _canSampledIn(msgID) {
            try {
                var cfg = _getCfgByKey(msgID);
                return (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_10__.randomValue)(1000000) <= cfg.limit.samplingRate;
            }
            catch (e) {
                // eslint-disable-next-line no-empty
            }
            return false;
        }
        function _getLocalStorageObjByKey(key) {
            try {
                var curObj = _localStorageObj[key];
                if (!curObj) {
                    var localStorageName = _getLocalStorageName(key, _namePrefix);
                    curObj = _getLocalStorageObj((0,_StorageHelperFuncs__WEBPACK_IMPORTED_MODULE_7__.utlGetLocalStorage)(_logger, localStorageName), _logger, localStorageName);
                    _localStorageObj[key] = curObj;
                }
                return _localStorageObj[key];
            }
            catch (e) {
                // eslint-disable-next-line no-empty
            }
            return null;
        }
        function _isTrigger(key) {
            var isTrigger = _isTriggered[key];
            if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(isTrigger)) {
                isTrigger = false;
                var localStorageObj = _getLocalStorageObjByKey(key);
                if (localStorageObj) {
                    isTrigger = _isTriggeredOnCurDate(localStorageObj[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PRE_TRIGGER_DATE /* @min:%2epreTriggerDate */]);
                }
                _isTriggered[key] = isTrigger;
            }
            return _isTriggered[key];
        }
        function _getQueueByKey(key) {
            _queue = _queue || {};
            if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(_queue[key])) {
                _queue[key] = [];
            }
            return _queue[key];
        }
    }
    return ThrottleMgr;
}());

//# sourceMappingURL=ThrottleMgr.js.map

/***/ }),
/* 75 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "utlCanUseLocalStorage": () => (/* binding */ utlCanUseLocalStorage),
/* harmony export */   "utlCanUseSessionStorage": () => (/* binding */ utlCanUseSessionStorage),
/* harmony export */   "utlDisableStorage": () => (/* binding */ utlDisableStorage),
/* harmony export */   "utlEnableStorage": () => (/* binding */ utlEnableStorage),
/* harmony export */   "utlGetLocalStorage": () => (/* binding */ utlGetLocalStorage),
/* harmony export */   "utlGetSessionStorage": () => (/* binding */ utlGetSessionStorage),
/* harmony export */   "utlGetSessionStorageKeys": () => (/* binding */ utlGetSessionStorageKeys),
/* harmony export */   "utlRemoveSessionStorage": () => (/* binding */ utlRemoveSessionStorage),
/* harmony export */   "utlRemoveStorage": () => (/* binding */ utlRemoveStorage),
/* harmony export */   "utlSetLocalStorage": () => (/* binding */ utlSetLocalStorage),
/* harmony export */   "utlSetSessionStorage": () => (/* binding */ utlSetSessionStorage),
/* harmony export */   "utlSetStoragePrefix": () => (/* binding */ utlSetStoragePrefix)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(18);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(41);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(46);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(13);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(24);
/* harmony import */ var _Enums__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(76);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





var _canUseLocalStorage = undefined;
var _canUseSessionStorage = undefined;
var _storagePrefix = "";
/**
 * Gets the localStorage object if available
 * @return {Storage} - Returns the storage object if available else returns null
 */
function _getLocalStorageObject() {
    if (utlCanUseLocalStorage()) {
        return _getVerifiedStorageObject(_Enums__WEBPACK_IMPORTED_MODULE_0__.StorageType.LocalStorage);
    }
    return null;
}
/**
 * Tests storage object (localStorage or sessionStorage) to verify that it is usable
 * More details here: https://mathiasbynens.be/notes/localstorage-pattern
 * @param storageType - Type of storage
 * @return {Storage} Returns storage object verified that it is usable
 */
function _getVerifiedStorageObject(storageType) {
    try {
        if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.getGlobal)())) {
            return null;
        }
        var uid = (new Date)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_TO_STRING /* @min:%2etoString */]();
        var storage = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.getInst)(storageType === _Enums__WEBPACK_IMPORTED_MODULE_0__.StorageType.LocalStorage ? "localStorage" : "sessionStorage");
        var name_1 = _storagePrefix + uid;
        storage.setItem(name_1, uid);
        var fail = storage.getItem(name_1) !== uid;
        storage[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_REMOVE_ITEM /* @min:%2eremoveItem */](name_1);
        if (!fail) {
            return storage;
        }
    }
    catch (exception) {
        // eslint-disable-next-line no-empty
    }
    return null;
}
/**
 * Gets the sessionStorage object if available
 * @return {Storage} - Returns the storage object if available else returns null
 */
function _getSessionStorageObject() {
    if (utlCanUseSessionStorage()) {
        return _getVerifiedStorageObject(_Enums__WEBPACK_IMPORTED_MODULE_0__.StorageType.SessionStorage);
    }
    return null;
}
/**
 * Disables the global SDK usage of local or session storage if available
 */
function utlDisableStorage() {
    _canUseLocalStorage = false;
    _canUseSessionStorage = false;
}
function utlSetStoragePrefix(storagePrefix) {
    _storagePrefix = storagePrefix || "";
}
/**
 * Re-enables the global SDK usage of local or session storage if available
 */
function utlEnableStorage() {
    _canUseLocalStorage = utlCanUseLocalStorage(true);
    _canUseSessionStorage = utlCanUseSessionStorage(true);
}
/**
 * Returns whether LocalStorage can be used, if the reset parameter is passed a true this will override
 * any previous disable calls.
 * @param reset - Should the usage be reset and determined only based on whether LocalStorage is available
 */
function utlCanUseLocalStorage(reset) {
    if (reset || _canUseLocalStorage === undefined) {
        _canUseLocalStorage = !!_getVerifiedStorageObject(_Enums__WEBPACK_IMPORTED_MODULE_0__.StorageType.LocalStorage);
    }
    return _canUseLocalStorage;
}
function utlGetLocalStorage(logger, name) {
    var storage = _getLocalStorageObject();
    if (storage !== null) {
        try {
            return storage.getItem(name);
        }
        catch (e) {
            _canUseLocalStorage = false;
            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 1 /* _eInternalMessageId.BrowserCannotReadLocalStorage */, "Browser failed read of local storage. " + (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.getExceptionName)(e), { exception: (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.dumpObj)(e) });
        }
    }
    return null;
}
function utlSetLocalStorage(logger, name, data) {
    var storage = _getLocalStorageObject();
    if (storage !== null) {
        try {
            storage.setItem(name, data);
            return true;
        }
        catch (e) {
            _canUseLocalStorage = false;
            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 3 /* _eInternalMessageId.BrowserCannotWriteLocalStorage */, "Browser failed write to local storage. " + (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.getExceptionName)(e), { exception: (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.dumpObj)(e) });
        }
    }
    return false;
}
function utlRemoveStorage(logger, name) {
    var storage = _getLocalStorageObject();
    if (storage !== null) {
        try {
            storage[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_REMOVE_ITEM /* @min:%2eremoveItem */](name);
            return true;
        }
        catch (e) {
            _canUseLocalStorage = false;
            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 5 /* _eInternalMessageId.BrowserFailedRemovalFromLocalStorage */, "Browser failed removal of local storage item. " + (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.getExceptionName)(e), { exception: (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.dumpObj)(e) });
        }
    }
    return false;
}
function utlCanUseSessionStorage(reset) {
    if (reset || _canUseSessionStorage === undefined) {
        _canUseSessionStorage = !!_getVerifiedStorageObject(_Enums__WEBPACK_IMPORTED_MODULE_0__.StorageType.SessionStorage);
    }
    return _canUseSessionStorage;
}
function utlGetSessionStorageKeys() {
    var keys = [];
    if (utlCanUseSessionStorage()) {
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__.objForEachKey)((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.getInst)("sessionStorage"), function (key) {
            keys.push(key);
        });
    }
    return keys;
}
function utlGetSessionStorage(logger, name) {
    var storage = _getSessionStorageObject();
    if (storage !== null) {
        try {
            return storage.getItem(name);
        }
        catch (e) {
            _canUseSessionStorage = false;
            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 2 /* _eInternalMessageId.BrowserCannotReadSessionStorage */, "Browser failed read of session storage. " + (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.getExceptionName)(e), { exception: (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.dumpObj)(e) });
        }
    }
    return null;
}
function utlSetSessionStorage(logger, name, data) {
    var storage = _getSessionStorageObject();
    if (storage !== null) {
        try {
            storage.setItem(name, data);
            return true;
        }
        catch (e) {
            _canUseSessionStorage = false;
            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 4 /* _eInternalMessageId.BrowserCannotWriteSessionStorage */, "Browser failed write to session storage. " + (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.getExceptionName)(e), { exception: (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.dumpObj)(e) });
        }
    }
    return false;
}
function utlRemoveSessionStorage(logger, name) {
    var storage = _getSessionStorageObject();
    if (storage !== null) {
        try {
            storage[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_REMOVE_ITEM /* @min:%2eremoveItem */](name);
            return true;
        }
        catch (e) {
            _canUseSessionStorage = false;
            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 6 /* _eInternalMessageId.BrowserFailedRemovalFromSessionStorage */, "Browser failed removal of session storage item. " + (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.getExceptionName)(e), { exception: (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.dumpObj)(e) });
        }
    }
    return false;
}
//# sourceMappingURL=StorageHelperFuncs.js.map

/***/ }),
/* 76 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DistributedTracingModes": () => (/* binding */ DistributedTracingModes),
/* harmony export */   "StorageType": () => (/* binding */ StorageType)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(30);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */



var StorageType = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)({
    LocalStorage: 0 /* eStorageType.LocalStorage */,
    SessionStorage: 1 /* eStorageType.SessionStorage */
});
var DistributedTracingModes = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)({
    AI: 0 /* eDistributedTracingModes.AI */,
    AI_AND_W3C: 1 /* eDistributedTracingModes.AI_AND_W3C */,
    W3C: 2 /* eDistributedTracingModes.W3C */
});
//# sourceMappingURL=Enums.js.map

/***/ }),
/* 77 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ConnectionStringParser": () => (/* binding */ ConnectionStringParser),
/* harmony export */   "parseConnectionString": () => (/* binding */ parseConnectionString)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(78);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(33);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(79);
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





var _FIELDS_SEPARATOR = ";";
var _FIELD_KEY_VALUE_SEPARATOR = "=";
function parseConnectionString(connectionString) {
    if (!connectionString) {
        return {};
    }
    var kvPairs = connectionString[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SPLIT /* @min:%2esplit */](_FIELDS_SEPARATOR);
    var result = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.arrReduce)(kvPairs, function (fields, kv) {
        var kvParts = kv[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SPLIT /* @min:%2esplit */](_FIELD_KEY_VALUE_SEPARATOR);
        if (kvParts[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] === 2) { // only save fields with valid formats
            var key = kvParts[0][_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]();
            var value = kvParts[1];
            fields[key] = value;
        }
        return fields;
    }, {});
    if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.objKeys)(result)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 0) {
        // this is a valid connection string, so parse the results
        if (result.endpointsuffix) {
            // use endpoint suffix where overrides are not provided
            var locationPrefix = result.location ? result.location + "." : "";
            result[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_INGESTIONENDPOINT /* @min:%2eingestionendpoint */] = result[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_INGESTIONENDPOINT /* @min:%2eingestionendpoint */] || ("https://" + locationPrefix + "dc." + result.endpointsuffix);
        }
        // apply the default endpoints
        result[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_INGESTIONENDPOINT /* @min:%2eingestionendpoint */] = result[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_INGESTIONENDPOINT /* @min:%2eingestionendpoint */] || _Constants__WEBPACK_IMPORTED_MODULE_3__.DEFAULT_BREEZE_ENDPOINT;
        if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.strEndsWith)(result[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_INGESTIONENDPOINT /* @min:%2eingestionendpoint */], "/")) {
            result[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_INGESTIONENDPOINT /* @min:%2eingestionendpoint */] = result[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_INGESTIONENDPOINT /* @min:%2eingestionendpoint */].slice(0, -1);
        }
    }
    return result;
}
var ConnectionStringParser = {
    parse: parseConnectionString
};
//# sourceMappingURL=ConnectionStringParser.js.map

/***/ }),
/* 78 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "arrReduce": () => (/* binding */ arrReduce)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * The arrReduce() method executes a user-supplied "reducer" callback function on each element of the array,
 * in order, passing in the return value from the calculation on the preceding element. The final result of
 * running the reducer across all elements of the array is a single value.
 *
 * The first time that the callback is run there is no "return value of the previous calculation". If supplied,
 * an initial value may be used in its place. Otherwise the array element at index 0 is used as the initial
 * value and iteration starts from the next element (index 1 instead of index 0).
 * @group Array
 * @group ArrayLike
 * @typeParam T - Identifies the type of array elements
 * @param theArray - The array or array like object of elements to be searched.
 * @param callbackfn A function that accepts up to four arguments. The reduce method calls the callbackfn function one time for each element in the array.
 * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.
 * @returns The value that results from running the "reducer" callback function to completion over the entire array.
 * @example
 * ```ts
 * const getMax = (a: number, b: number) => Math.max(a, b);
 *
 * // callback is invoked for each element in the array starting at index 0
 * arrReduce([1, 100], getMax, 50); // 100
 * arrReduce([    50], getMax, 10); // 50
 *
 * // callback is invoked once for element at index 1
 * arrReduce([1, 100], getMax);     // 100
 *
 * // callback is not invoked
 * arrReduce([    50], getMax);     // 50
 * arrReduce([      ], getMax, 1);  // 1
 *
 * arrReduce([      ], getMax);     // throws TypeError
 *
 * // Also supports Array like objects
 * arrReduce({ length: 2, 0: 1, 1: 100 }, getMax, 50); // 100
 * arrReduce({ length: 1, 0: 50 }, getMax, 10); // 50
 *
 * // callback is invoked once for element at index 1
 * arrReduce({ length: 2, 0: 1, 1: 100 }, getMax);     // 100
 *
 * // callback is not invoked
 * arrReduce({ length: 1, 0: 50 }, getMax);     // 50
 * arrReduce({ length: 0 }, getMax, 1);  // 1
  * ```
 */
var arrReduce = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunction)("reduce", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.ArrProto);
//# sourceMappingURL=reduce.js.map

/***/ }),
/* 79 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "polyStrEndsWith": () => (/* binding */ polyStrEndsWith),
/* harmony export */   "strEndsWith": () => (/* binding */ strEndsWith)
/* harmony export */ });
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(14);
/* harmony import */ var _helpers_diagnostics__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(13);
/* harmony import */ var _helpers_throw__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
/* harmony import */ var _as_string__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(12);
/* harmony import */ var _substring__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(36);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */







/**
 * This method lets you determine whether or not a string ends with another string. This method is case-sensitive.
 * @group String
 * @param value - The value to be checked
 * @param searchString - The characters to be searched for at the end of `value` string.
 * @param length - If provided, it is used as the length of `value`. Defaults to value.length.
 */
var strEndsWith = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunctionWithPoly)("endsWith", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto, polyStrEndsWith);
/**
 * This method lets you determine whether or not a string ends with another string. This method is case-sensitive.
 * @group Polyfill
 * @group String
 * @param value - The value to be checked
 * @param searchString - The characters to be searched for at the end of `value` string.
 * @param length - If provided, it is used as the length of `value`. Defaults to value.length.
 */
function polyStrEndsWith(value, searchString, length) {
    if (!(0,_helpers_base__WEBPACK_IMPORTED_MODULE_2__.isString)(value)) {
        (0,_helpers_throw__WEBPACK_IMPORTED_MODULE_3__.throwTypeError)("'" + (0,_helpers_diagnostics__WEBPACK_IMPORTED_MODULE_4__.dumpObj)(value) + "' is not a string");
    }
    var searchValue = (0,_helpers_base__WEBPACK_IMPORTED_MODULE_2__.isString)(searchString) ? searchString : (0,_as_string__WEBPACK_IMPORTED_MODULE_5__.asString)(searchString);
    var chkLen = searchValue[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.LENGTH];
    var len = value[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.LENGTH];
    var end = !(0,_helpers_base__WEBPACK_IMPORTED_MODULE_2__.isUndefined)(length) && length < len ? length : len;
    return (0,_substring__WEBPACK_IMPORTED_MODULE_6__.strSubstring)(value, end - chkLen, end) === searchValue;
}
//# sourceMappingURL=ends_with.js.map

/***/ }),
/* 80 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Envelope": () => (/* binding */ Envelope)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46);
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);
/* harmony import */ var _DataSanitizer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(35);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






var Envelope = /** @class */ (function () {
    /**
     * Constructs a new instance of telemetry data.
     */
    function Envelope(logger, data, name) {
        var _this = this;
        var _self = this;
        _self.ver = 1;
        _self.sampleRate = 100.0;
        _self.tags = {};
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_NAME /* @min:%2ename */] = (0,_DataSanitizer__WEBPACK_IMPORTED_MODULE_1__.dataSanitizeString)(logger, name) || _Constants__WEBPACK_IMPORTED_MODULE_2__.strNotSpecified;
        _self.data = data;
        _self.time = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.toISOString)(new Date());
        _self.aiDataContract = {
            time: 1 /* FieldType.Required */,
            iKey: 1 /* FieldType.Required */,
            name: 1 /* FieldType.Required */,
            sampleRate: function () {
                return (_this.sampleRate === 100) ? 4 /* FieldType.Hidden */ : 1 /* FieldType.Required */;
            },
            tags: 1 /* FieldType.Required */,
            data: 1 /* FieldType.Required */
        };
    }
    return Envelope;
}());

//# sourceMappingURL=Envelope.js.map

/***/ }),
/* 81 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Event": () => (/* binding */ Event)
/* harmony export */ });
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);
/* harmony import */ var _Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(35);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





var Event = /** @class */ (function () {
    /**
     * Constructs a new instance of the EventTelemetry object
     */
    function Event(logger, name, properties, measurements) {
        this.aiDataContract = {
            ver: 1 /* FieldType.Required */,
            name: 1 /* FieldType.Required */,
            properties: 0 /* FieldType.Default */,
            measurements: 0 /* FieldType.Default */
        };
        var _self = this;
        _self.ver = 2;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_NAME /* @min:%2ename */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_1__.dataSanitizeString)(logger, name) || _Constants__WEBPACK_IMPORTED_MODULE_2__.strNotSpecified;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROPERTIES /* @min:%2eproperties */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_1__.dataSanitizeProperties)(logger, properties);
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MEASUREMENTS /* @min:%2emeasurements */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_1__.dataSanitizeMeasurements)(logger, measurements);
    }
    Event.envelopeType = "Microsoft.ApplicationInsights.{0}.Event";
    Event.dataType = "EventData";
    return Event;
}());

//# sourceMappingURL=Event.js.map

/***/ }),
/* 82 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Exception": () => (/* binding */ Exception),
/* harmony export */   "_ExceptionDetails": () => (/* binding */ _ExceptionDetails),
/* harmony export */   "_StackFrame": () => (/* binding */ _StackFrame),
/* harmony export */   "_formatErrorCode": () => (/* binding */ _formatErrorCode)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(84);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(83);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(39);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(18);
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(7);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16);
/* harmony import */ var _Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(35);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */








var NoMethod = "<no_method>";
var strError = "error";
var strStack = "stack";
var strStackDetails = "stackDetails";
var strErrorSrc = "errorSrc";
var strMessage = "message";
var strDescription = "description";
function _stringify(value, convertToString) {
    var result = value;
    if (result && !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isString)(result)) {
        if (JSON && JSON[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_STRINGIFY /* @min:%2estringify */]) {
            result = JSON[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_STRINGIFY /* @min:%2estringify */](value);
            if (convertToString && (!result || result === "{}")) {
                if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isFunction)(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TO_STRING /* @min:%2etoString */])) {
                    result = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TO_STRING /* @min:%2etoString */]();
                }
                else {
                    result = "" + value;
                }
            }
        }
        else {
            result = "" + value + " - (Missing JSON.stringify)";
        }
    }
    return result || "";
}
function _formatMessage(theEvent, errorType) {
    var evtMessage = theEvent;
    if (theEvent) {
        if (evtMessage && !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isString)(evtMessage)) {
            evtMessage = theEvent[strMessage] || theEvent[strDescription] || evtMessage;
        }
        // Make sure the message is a string
        if (evtMessage && !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isString)(evtMessage)) {
            // tslint:disable-next-line: prefer-conditional-expression
            evtMessage = _stringify(evtMessage, true);
        }
        if (theEvent["filename"]) {
            // Looks like an event object with filename
            evtMessage = evtMessage + " @" + (theEvent["filename"] || "") + ":" + (theEvent["lineno"] || "?") + ":" + (theEvent["colno"] || "?");
        }
    }
    // Automatically add the error type to the message if it does already appear to be present
    if (errorType && errorType !== "String" && errorType !== "Object" && errorType !== "Error" && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.strIndexOf)(evtMessage || "", errorType) === -1) {
        evtMessage = errorType + ": " + evtMessage;
    }
    return evtMessage || "";
}
function _isExceptionDetailsInternal(value) {
    try {
        if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isObject)(value)) {
            return "hasFullStack" in value && "typeName" in value;
        }
    }
    catch (e) {
        // This can happen with some native browser objects, but should not happen for the type we are checking for
    }
    return false;
}
function _isExceptionInternal(value) {
    try {
        if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isObject)(value)) {
            return ("ver" in value && "exceptions" in value && "properties" in value);
        }
    }
    catch (e) {
        // This can happen with some native browser objects, but should not happen for the type we are checking for
    }
    return false;
}
function _isStackDetails(details) {
    return details && details.src && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isString)(details.src) && details.obj && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isArray)(details.obj);
}
function _convertStackObj(errorStack) {
    var src = errorStack || "";
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isString)(src)) {
        if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isString)(src[strStack])) {
            src = src[strStack];
        }
        else {
            src = "" + src;
        }
    }
    var items = src[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLIT /* @min:%2esplit */]("\n");
    return {
        src: src,
        obj: items
    };
}
function _getOperaStack(errorMessage) {
    var stack = [];
    var lines = errorMessage[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLIT /* @min:%2esplit */]("\n");
    for (var lp = 0; lp < lines[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; lp++) {
        var entry = lines[lp];
        if (lines[lp + 1]) {
            entry += "@" + lines[lp + 1];
            lp++;
        }
        stack.push(entry);
    }
    return {
        src: errorMessage,
        obj: stack
    };
}
function _getStackFromErrorObj(errorObj) {
    var details = null;
    if (errorObj) {
        try {
            /* Using bracket notation is support older browsers (IE 7/8 -- dont remember the version) that throw when using dot
            notation for undefined objects and we don't want to loose the error from being reported */
            if (errorObj[strStack]) {
                // Chrome/Firefox
                details = _convertStackObj(errorObj[strStack]);
            }
            else if (errorObj[strError] && errorObj[strError][strStack]) {
                // Edge error event provides the stack and error object
                details = _convertStackObj(errorObj[strError][strStack]);
            }
            else if (errorObj["exception"] && errorObj.exception[strStack]) {
                details = _convertStackObj(errorObj.exception[strStack]);
            }
            else if (_isStackDetails(errorObj)) {
                details = errorObj;
            }
            else if (_isStackDetails(errorObj[strStackDetails])) {
                details = errorObj[strStackDetails];
            }
            else if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.getWindow)() && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.getWindow)()["opera"] && errorObj[strMessage]) {
                // Opera
                details = _getOperaStack(errorObj[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_MESSAGE /* @min:%2emessage */]);
            }
            else if (errorObj["reason"] && errorObj.reason[strStack]) {
                // UnhandledPromiseRejection
                details = _convertStackObj(errorObj.reason[strStack]);
            }
            else if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isString)(errorObj)) {
                details = _convertStackObj(errorObj);
            }
            else {
                var evtMessage = errorObj[strMessage] || errorObj[strDescription] || "";
                if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isString)(errorObj[strErrorSrc])) {
                    if (evtMessage) {
                        evtMessage += "\n";
                    }
                    evtMessage += " from " + errorObj[strErrorSrc];
                }
                if (evtMessage) {
                    details = _convertStackObj(evtMessage);
                }
            }
        }
        catch (e) {
            // something unexpected happened so to avoid failing to report any error lets swallow the exception
            // and fallback to the callee/caller method
            details = _convertStackObj(e);
        }
    }
    return details || {
        src: "",
        obj: null
    };
}
function _formatStackTrace(stackDetails) {
    var stack = "";
    if (stackDetails) {
        if (stackDetails.obj) {
            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.arrForEach)(stackDetails.obj, function (entry) {
                stack += entry + "\n";
            });
        }
        else {
            stack = stackDetails.src || "";
        }
    }
    return stack;
}
function _parseStack(stack) {
    var parsedStack;
    var frames = stack.obj;
    if (frames && frames[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
        parsedStack = [];
        var level_1 = 0;
        var totalSizeInBytes_1 = 0;
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.arrForEach)(frames, function (frame) {
            var theFrame = frame[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TO_STRING /* @min:%2etoString */]();
            if (_StackFrame.regex.test(theFrame)) {
                var parsedFrame = new _StackFrame(theFrame, level_1++);
                totalSizeInBytes_1 += parsedFrame[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SIZE_IN_BYTES /* @min:%2esizeInBytes */];
                parsedStack.push(parsedFrame);
            }
        });
        // DP Constraint - exception parsed stack must be < 32KB
        // remove frames from the middle to meet the threshold
        var exceptionParsedStackThreshold = 32 * 1024;
        if (totalSizeInBytes_1 > exceptionParsedStackThreshold) {
            var left = 0;
            var right = parsedStack[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] - 1;
            var size = 0;
            var acceptedLeft = left;
            var acceptedRight = right;
            while (left < right) {
                // check size
                var lSize = parsedStack[left][_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SIZE_IN_BYTES /* @min:%2esizeInBytes */];
                var rSize = parsedStack[right][_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SIZE_IN_BYTES /* @min:%2esizeInBytes */];
                size += lSize + rSize;
                if (size > exceptionParsedStackThreshold) {
                    // remove extra frames from the middle
                    var howMany = acceptedRight - acceptedLeft + 1;
                    parsedStack.splice(acceptedLeft, howMany);
                    break;
                }
                // update pointers
                acceptedLeft = left;
                acceptedRight = right;
                left++;
                right--;
            }
        }
    }
    return parsedStack;
}
function _getErrorType(errorType) {
    // Gets the Error Type by passing the constructor (used to get the true type of native error object).
    var typeName = "";
    if (errorType) {
        typeName = errorType.typeName || errorType[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:%2ename */] || "";
        if (!typeName) {
            try {
                var funcNameRegex = /function (.{1,200})\(/;
                var results = (funcNameRegex).exec((errorType).constructor[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TO_STRING /* @min:%2etoString */]());
                typeName = (results && results[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 1) ? results[1] : "";
            }
            catch (e) {
                // eslint-disable-next-line no-empty -- Ignoring any failures as nothing we can do
            }
        }
    }
    return typeName;
}
/**
 * Formats the provided errorObj for display and reporting, it may be a String, Object, integer or undefined depending on the browser.
 * @param errorObj - The supplied errorObj
 */
function _formatErrorCode(errorObj) {
    if (errorObj) {
        try {
            if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isString)(errorObj)) {
                var errorType = _getErrorType(errorObj);
                var result = _stringify(errorObj, false);
                if (!result || result === "{}") {
                    if (errorObj[strError]) {
                        // Looks like an MS Error Event
                        errorObj = errorObj[strError];
                        errorType = _getErrorType(errorObj);
                    }
                    result = _stringify(errorObj, true);
                }
                if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.strIndexOf)(result, errorType) !== 0 && errorType !== "String") {
                    return errorType + ":" + result;
                }
                return result;
            }
        }
        catch (e) {
            // eslint-disable-next-line no-empty -- Ignoring any failures as nothing we can do
        }
    }
    // Fallback to just letting the object format itself into a string
    return "" + (errorObj || "");
}
var Exception = /** @class */ (function () {
    /**
     * Constructs a new instance of the ExceptionTelemetry object
     */
    function Exception(logger, exception, properties, measurements, severityLevel, id) {
        this.aiDataContract = {
            ver: 1 /* FieldType.Required */,
            exceptions: 1 /* FieldType.Required */,
            severityLevel: 0 /* FieldType.Default */,
            properties: 0 /* FieldType.Default */,
            measurements: 0 /* FieldType.Default */
        };
        var _self = this;
        _self.ver = 2; // TODO: handle the CS"4.0" ==> breeze 2 conversion in a better way
        if (!_isExceptionInternal(exception)) {
            if (!properties) {
                properties = {};
            }
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_EXCEPTIONS /* @min:%2eexceptions */] = [new _ExceptionDetails(logger, exception, properties)];
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROPERTIES /* @min:%2eproperties */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_5__.dataSanitizeProperties)(logger, properties);
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_MEASUREMENTS /* @min:%2emeasurements */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_5__.dataSanitizeMeasurements)(logger, measurements);
            if (severityLevel) {
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEVERITY_LEVEL /* @min:%2eseverityLevel */] = severityLevel;
            }
            if (id) {
                _self.id = id;
            }
        }
        else {
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_EXCEPTIONS /* @min:%2eexceptions */] = exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_EXCEPTIONS /* @min:%2eexceptions */] || [];
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROPERTIES /* @min:%2eproperties */] = exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROPERTIES /* @min:%2eproperties */];
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_MEASUREMENTS /* @min:%2emeasurements */] = exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_MEASUREMENTS /* @min:%2emeasurements */];
            if (exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEVERITY_LEVEL /* @min:%2eseverityLevel */]) {
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEVERITY_LEVEL /* @min:%2eseverityLevel */] = exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEVERITY_LEVEL /* @min:%2eseverityLevel */];
            }
            if (exception.id) {
                _self.id = exception.id;
            }
            if (exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROBLEM_GROUP /* @min:%2eproblemGroup */]) {
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROBLEM_GROUP /* @min:%2eproblemGroup */] = exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROBLEM_GROUP /* @min:%2eproblemGroup */];
            }
            // bool/int types, use isNullOrUndefined
            if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_MANUAL /* @min:%2eisManual */])) {
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_MANUAL /* @min:%2eisManual */] = exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_MANUAL /* @min:%2eisManual */];
            }
        }
    }
    Exception.CreateAutoException = function (message, url, lineNumber, columnNumber, error, evt, stack, errorSrc) {
        var _a;
        var errorType = _getErrorType(error || evt || message);
        return _a = {},
            _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_MESSAGE /* @min:message */] = _formatMessage(message, errorType),
            _a.url = url,
            _a.lineNumber = lineNumber,
            _a.columnNumber = columnNumber,
            _a.error = _formatErrorCode(error || evt || message),
            _a.evt = _formatErrorCode(evt || message),
            _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE_NAME /* @min:typeName */] = errorType,
            _a.stackDetails = _getStackFromErrorObj(stack || error || evt),
            _a.errorSrc = errorSrc,
            _a;
    };
    Exception.CreateFromInterface = function (logger, exception, properties, measurements) {
        var exceptions = exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_EXCEPTIONS /* @min:%2eexceptions */]
            && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.arrMap)(exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_EXCEPTIONS /* @min:%2eexceptions */], function (ex) { return _ExceptionDetails[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__CREATE_FROM_INTERFA1 /* @min:%2eCreateFromInterface */](logger, ex); });
        var exceptionData = new Exception(logger, (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_7__.__assignFn)((0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_7__.__assignFn)({}, exception), { exceptions: exceptions }), properties, measurements);
        return exceptionData;
    };
    Exception.prototype.toInterface = function () {
        var _a;
        var _b = this, exceptions = _b.exceptions, properties = _b.properties, measurements = _b.measurements, severityLevel = _b.severityLevel, problemGroup = _b.problemGroup, id = _b.id, isManual = _b.isManual;
        var exceptionDetailsInterface = exceptions instanceof Array
            && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.arrMap)(exceptions, function (exception) { return exception.toInterface(); })
            || undefined;
        return _a = {
                ver: "4.0"
            },
            _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_EXCEPTIONS /* @min:exceptions */] = exceptionDetailsInterface,
            _a.severityLevel = severityLevel,
            _a.properties = properties,
            _a.measurements = measurements,
            _a.problemGroup = problemGroup,
            _a.id = id,
            _a.isManual = isManual,
            _a;
    };
    /**
     * Creates a simple exception with 1 stack frame. Useful for manual constracting of exception.
     */
    Exception.CreateSimpleException = function (message, typeName, assembly, fileName, details, line) {
        var _a;
        return {
            exceptions: [
                (_a = {},
                    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HAS_FULL_STACK /* @min:hasFullStack */] = true,
                    _a.message = message,
                    _a.stack = details,
                    _a.typeName = typeName,
                    _a)
            ]
        };
    };
    Exception.envelopeType = "Microsoft.ApplicationInsights.{0}.Exception";
    Exception.dataType = "ExceptionData";
    Exception.formatError = _formatErrorCode;
    return Exception;
}());

var _ExceptionDetails = /** @class */ (function () {
    function _ExceptionDetails(logger, exception, properties) {
        this.aiDataContract = {
            id: 0 /* FieldType.Default */,
            outerId: 0 /* FieldType.Default */,
            typeName: 1 /* FieldType.Required */,
            message: 1 /* FieldType.Required */,
            hasFullStack: 0 /* FieldType.Default */,
            stack: 0 /* FieldType.Default */,
            parsedStack: 2 /* FieldType.Array */
        };
        var _self = this;
        if (!_isExceptionDetailsInternal(exception)) {
            var error = exception;
            var evt = error && error.evt;
            if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isError)(error)) {
                error = error[strError] || evt || error;
            }
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE_NAME /* @min:%2etypeName */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_5__.dataSanitizeString)(logger, _getErrorType(error)) || _Constants__WEBPACK_IMPORTED_MODULE_8__.strNotSpecified;
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_MESSAGE /* @min:%2emessage */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_5__.dataSanitizeMessage)(logger, _formatMessage(exception || error, _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE_NAME /* @min:%2etypeName */])) || _Constants__WEBPACK_IMPORTED_MODULE_8__.strNotSpecified;
            var stack = exception[strStackDetails] || _getStackFromErrorObj(exception);
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PARSED_STACK /* @min:%2eparsedStack */] = _parseStack(stack);
            // after parsedStack is inited, iterate over each frame object, sanitize its assembly field
            if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isArray)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PARSED_STACK /* @min:%2eparsedStack */])) {
                (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.arrMap)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PARSED_STACK /* @min:%2eparsedStack */], function (frame) {
                    frame[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_ASSEMBLY /* @min:%2eassembly */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_5__.dataSanitizeString)(logger, frame[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_ASSEMBLY /* @min:%2eassembly */]);
                    frame[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_FILE_NAME /* @min:%2efileName */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_5__.dataSanitizeString)(logger, frame[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_FILE_NAME /* @min:%2efileName */]);
                });
            }
            _self[strStack] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_5__.dataSanitizeException)(logger, _formatStackTrace(stack));
            _self.hasFullStack = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isArray)(_self.parsedStack) && _self.parsedStack[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0;
            if (properties) {
                properties[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE_NAME /* @min:%2etypeName */] = properties[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE_NAME /* @min:%2etypeName */] || _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE_NAME /* @min:%2etypeName */];
            }
        }
        else {
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE_NAME /* @min:%2etypeName */] = exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE_NAME /* @min:%2etypeName */];
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_MESSAGE /* @min:%2emessage */] = exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_MESSAGE /* @min:%2emessage */];
            _self[strStack] = exception[strStack];
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PARSED_STACK /* @min:%2eparsedStack */] = exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PARSED_STACK /* @min:%2eparsedStack */] || [];
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HAS_FULL_STACK /* @min:%2ehasFullStack */] = exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HAS_FULL_STACK /* @min:%2ehasFullStack */];
        }
    }
    _ExceptionDetails.prototype.toInterface = function () {
        var _a;
        var _self = this;
        var parsedStack = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PARSED_STACK /* @min:%2eparsedStack */] instanceof Array
            && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.arrMap)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PARSED_STACK /* @min:%2eparsedStack */], function (frame) { return frame.toInterface(); });
        var exceptionDetailsInterface = (_a = {
                id: _self.id,
                outerId: _self.outerId,
                typeName: _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE_NAME /* @min:%2etypeName */],
                message: _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_MESSAGE /* @min:%2emessage */],
                hasFullStack: _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HAS_FULL_STACK /* @min:%2ehasFullStack */],
                stack: _self[strStack]
            },
            _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PARSED_STACK /* @min:parsedStack */] = parsedStack || undefined,
            _a);
        return exceptionDetailsInterface;
    };
    _ExceptionDetails.CreateFromInterface = function (logger, exception) {
        var parsedStack = (exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PARSED_STACK /* @min:%2eparsedStack */] instanceof Array
            && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.arrMap)(exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PARSED_STACK /* @min:%2eparsedStack */], function (frame) { return _StackFrame[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__CREATE_FROM_INTERFA1 /* @min:%2eCreateFromInterface */](frame); }))
            || exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PARSED_STACK /* @min:%2eparsedStack */];
        var exceptionDetails = new _ExceptionDetails(logger, (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_7__.__assignFn)((0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_7__.__assignFn)({}, exception), { parsedStack: parsedStack }));
        return exceptionDetails;
    };
    return _ExceptionDetails;
}());

var _StackFrame = /** @class */ (function () {
    function _StackFrame(sourceFrame, level) {
        this.aiDataContract = {
            level: 1 /* FieldType.Required */,
            method: 1 /* FieldType.Required */,
            assembly: 0 /* FieldType.Default */,
            fileName: 0 /* FieldType.Default */,
            line: 0 /* FieldType.Default */
        };
        var _self = this;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SIZE_IN_BYTES /* @min:%2esizeInBytes */] = 0;
        // Not converting this to isString() as typescript uses this logic to "understand" the different
        // types for the 2 different code paths
        if (typeof sourceFrame === "string") {
            var frame = sourceFrame;
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LEVEL /* @min:%2elevel */] = level;
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_METHOD /* @min:%2emethod */] = NoMethod;
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_ASSEMBLY /* @min:%2eassembly */] = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_9__.strTrim)(frame);
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_FILE_NAME /* @min:%2efileName */] = "";
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LINE /* @min:%2eline */] = 0;
            var matches = frame.match(_StackFrame.regex);
            if (matches && matches[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] >= 5) {
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_METHOD /* @min:%2emethod */] = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_9__.strTrim)(matches[2]) || _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_METHOD /* @min:%2emethod */];
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_FILE_NAME /* @min:%2efileName */] = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_9__.strTrim)(matches[4]);
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LINE /* @min:%2eline */] = parseInt(matches[5]) || 0;
            }
        }
        else {
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LEVEL /* @min:%2elevel */] = sourceFrame[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LEVEL /* @min:%2elevel */];
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_METHOD /* @min:%2emethod */] = sourceFrame[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_METHOD /* @min:%2emethod */];
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_ASSEMBLY /* @min:%2eassembly */] = sourceFrame[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_ASSEMBLY /* @min:%2eassembly */];
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_FILE_NAME /* @min:%2efileName */] = sourceFrame[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_FILE_NAME /* @min:%2efileName */];
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LINE /* @min:%2eline */] = sourceFrame[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LINE /* @min:%2eline */];
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SIZE_IN_BYTES /* @min:%2esizeInBytes */] = 0;
        }
        _self.sizeInBytes += _self.method[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */];
        _self.sizeInBytes += _self.fileName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */];
        _self.sizeInBytes += _self.assembly[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */];
        // todo: these might need to be removed depending on how the back-end settles on their size calculation
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SIZE_IN_BYTES /* @min:%2esizeInBytes */] += _StackFrame.baseSize;
        _self.sizeInBytes += _self.level.toString()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */];
        _self.sizeInBytes += _self.line.toString()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */];
    }
    _StackFrame.CreateFromInterface = function (frame) {
        return new _StackFrame(frame, null /* level is available in frame interface */);
    };
    _StackFrame.prototype.toInterface = function () {
        var _self = this;
        return {
            level: _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LEVEL /* @min:%2elevel */],
            method: _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_METHOD /* @min:%2emethod */],
            assembly: _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_ASSEMBLY /* @min:%2eassembly */],
            fileName: _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_FILE_NAME /* @min:%2efileName */],
            line: _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LINE /* @min:%2eline */]
        };
    };
    // regex to match stack frames from ie/chrome/ff
    // methodName=$2, fileName=$4, lineNo=$5, column=$6
    _StackFrame.regex = /^([\s]+at)?[\s]{0,50}([^\@\()]+?)[\s]{0,50}(\@|\()([^\(\n]+):([0-9]+):([0-9]+)(\)?)$/;
    _StackFrame.baseSize = 58; // '{"method":"","level":,"assembly":"","fileName":"","line":}'.length
    return _StackFrame;
}());

//# sourceMappingURL=Exception.js.map

/***/ }),
/* 83 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "arrMap": () => (/* binding */ arrMap)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * The arrMap() method creates a new array populated with the results of calling a provided function on every
 * element in the calling array.
 *
 * `arrMap` calls a provided callbackFn function once for each element in an array, in order, and constructs
 * a new array from the results. callbackFn is invoked only for indexes of the array which have assigned
 * values (including undefined).
 *
 * It is not called for missing elements of the array; that is:
 * - indexes that have never been set;
 * - indexes which have been deleted.
 *
 * @since 0.3.3
 * @group Array
 * @group ArrayLike
 * @typeParam T - Identifies the type of the array elements
 * @typeParam R - Identifies the type of the elements returned by the callback function, defaults to T.
 * @param theArray - The array or array like object of elements to be searched.
 * @param callbackFn - The function that is called for evetn element of `theArray`.
 * @param thisArg - The value to use as the `this` when executing the `callbackFn`.
 * @example
 * ```ts
 * const numbers = [1, 4, 9];
 * const roots = arrMap(numbers, (num) => Math.sqrt(num));
 *
 * // roots is now     [1, 2, 3]
 * // numbers is still [1, 4, 9]
 *
 * const kvArray = [{ key: 1, value: 10 },
 *                  { key: 2, value: 20 },
 *                  { key: 3, value: 30 }];
 *
 * const reformattedArray = arrMap(kvArray, ({ key, value}) => ({ [key]: value }));
 *
 * // reformattedArray is now [{1: 10}, {2: 20}, {3: 30}],
 *
 * // kvArray is still:
 * // [{key: 1, value: 10},
 * //  {key: 2, value: 20},
 * //  {key: 3, value: 30}]
 *
 * // Also supports Array Like objects with same output
 * const kvArray = {
 *   length: 3,
 *   0: { key: 1, value: 10 },
 *   1: { key: 2, value: 20 },
 *   2: { key: 3, value: 30 }
 * };
 * ```
 */
var arrMap = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunction)("map", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.ArrProto);
//# sourceMappingURL=map.js.map

/***/ }),
/* 84 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ReflectObj": () => (/* binding */ ReflectObj),
/* harmony export */   "SymbolObj": () => (/* binding */ SymbolObj),
/* harmony export */   "__assignFn": () => (/* binding */ __assignFn),
/* harmony export */   "__createBindingFn": () => (/* binding */ __createBindingFn),
/* harmony export */   "__decorateFn": () => (/* binding */ __decorateFn),
/* harmony export */   "__exportStarFn": () => (/* binding */ __exportStarFn),
/* harmony export */   "__extendsFn": () => (/* binding */ __extendsFn),
/* harmony export */   "__hasReflect": () => (/* binding */ __hasReflect),
/* harmony export */   "__importDefaultFn": () => (/* binding */ __importDefaultFn),
/* harmony export */   "__importStarFn": () => (/* binding */ __importStarFn),
/* harmony export */   "__makeTemplateObjectFn": () => (/* binding */ __makeTemplateObjectFn),
/* harmony export */   "__metadataFn": () => (/* binding */ __metadataFn),
/* harmony export */   "__objAssignFnImpl": () => (/* binding */ __objAssignFnImpl),
/* harmony export */   "__paramFn": () => (/* binding */ __paramFn),
/* harmony export */   "__readFn": () => (/* binding */ __readFn),
/* harmony export */   "__restFn": () => (/* binding */ __restFn),
/* harmony export */   "__spreadArrayFn": () => (/* binding */ __spreadArrayFn),
/* harmony export */   "__spreadArraysFn": () => (/* binding */ __spreadArraysFn),
/* harmony export */   "__valuesFn": () => (/* binding */ __valuesFn)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(33);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(66);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(26);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(22);
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(45);
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.


// Most of these functions have been directly shamelessly "lifted" from the https://github.com/@microsoft/tslib and
// modified to be ES5 compatible and applying several minification and tree-shaking techniques so that Application Insights
// can successfully use TypeScript "importHelpers" which imports tslib during compilation but it will use these at runtime
// Which is also why all of the functions have not been included as Application Insights currently doesn't use or require
// them.
var SymbolObj = ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.getGlobal)() || {})["Symbol"];
var ReflectObj = ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.getGlobal)() || {})["Reflect"];
var __hasReflect = !!ReflectObj;
var strDecorate = "decorate";
var strMetadata = "metadata";
var strGetOwnPropertySymbols = "getOwnPropertySymbols";
var strIterator = "iterator";
var strHasOwnProperty = "hasOwnProperty";
var __objAssignFnImpl = function (t) {
    // tslint:disable-next-line: ban-comma-operator
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) {
            if (_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjProto[strHasOwnProperty].call(s, p)) {
                t[p] = s[p];
            }
        }
    }
    return t;
};
var __assignFn = _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.objAssign || __objAssignFnImpl;
// tslint:disable-next-line: only-arrow-functions
var extendStaticsFn = function (d, b) {
    extendStaticsFn = _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjClass.setPrototypeOf ||
        // tslint:disable-next-line: only-arrow-functions
        ({ __proto__: [] } instanceof Array && function (d, b) {
            d.__proto__ = b;
        }) ||
        // tslint:disable-next-line: only-arrow-functions
        function (d, b) {
            for (var p in b) {
                if (b[strHasOwnProperty](p)) {
                    d[p] = b[p];
                }
            }
        };
    return extendStaticsFn(d, b);
};
function __extendsFn(d, b) {
    if (typeof b !== _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction && b !== null) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.throwTypeError)("Class extends value " + String(b) + " is not a constructor or null");
    }
    extendStaticsFn(d, b);
    function __() {
        this.constructor = d;
    }
    // tslint:disable-next-line: ban-comma-operator
    d[_Constants__WEBPACK_IMPORTED_MODULE_1__.strShimPrototype] = b === null ? (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.objCreate)(b) : (__[_Constants__WEBPACK_IMPORTED_MODULE_1__.strShimPrototype] = b[_Constants__WEBPACK_IMPORTED_MODULE_1__.strShimPrototype], new __());
}
function __restFn(s, e) {
    var t = {};
    for (var k in s) {
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objHasOwnProperty)(s, k) && e.indexOf(k) < 0) {
            t[k] = s[k];
        }
    }
    if (s != null && typeof _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjClass[strGetOwnPropertySymbols] === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction) {
        for (var i = 0, p = _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjClass[strGetOwnPropertySymbols](s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjProto.propertyIsEnumerable.call(s, p[i])) {
                t[p[i]] = s[p[i]];
            }
        }
    }
    return t;
}
function __decorateFn(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjClass.getOwnPropertyDescriptor(target, key) : desc, d;
    if (__hasReflect && typeof ReflectObj[strDecorate] === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction) {
        r = ReflectObj[strDecorate](decorators, target, key, desc);
    }
    else {
        for (var i = decorators.length - 1; i >= 0; i--) {
            // eslint-disable-next-line no-cond-assign
            if (d = decorators[i]) {
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
            }
        }
    }
    // tslint:disable-next-line:ban-comma-operator
    return c > 3 && r && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objDefineProp)(target, key, r), r;
}
function __paramFn(paramIndex, decorator) {
    return function (target, key) {
        decorator(target, key, paramIndex);
    };
}
function __metadataFn(metadataKey, metadataValue) {
    if (__hasReflect && ReflectObj[strMetadata] === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction) {
        return ReflectObj[strMetadata](metadataKey, metadataValue);
    }
}
function __exportStarFn(m, o) {
    for (var p in m) {
        if (p !== _Constants__WEBPACK_IMPORTED_MODULE_1__.strDefault && !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objHasOwnProperty)(o, p)) {
            __createBindingFn(o, m, p);
        }
    }
}
function __createBindingFn(o, m, k, k2) {
    if (k2 === undefined) {
        k2 = k;
    }
    if (!!_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objDefineProp) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objDefineProp)(o, k2, {
            enumerable: true,
            get: function () {
                return m[k];
            }
        });
    }
    else {
        o[k2] = m[k];
    }
}
function __valuesFn(o) {
    var s = typeof SymbolObj === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction && SymbolObj[strIterator], m = s && o[s], i = 0;
    if (m) {
        return m.call(o);
    }
    if (o && typeof o.length === "number") {
        return {
            next: function () {
                if (o && i >= o.length) {
                    o = void 0;
                }
                return { value: o && o[i++], done: !o };
            }
        };
    }
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.throwTypeError)(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}
function __readFn(o, n) {
    var m = typeof SymbolObj === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction && o[SymbolObj[strIterator]];
    if (!m) {
        return o;
    }
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) {
            ar.push(r.value);
        }
    }
    catch (error) {
        e = {
            error: error
        };
    }
    finally {
        try {
            // tslint:disable-next-line:no-conditional-assignment
            if (r && !r.done && (m = i["return"])) {
                m.call(i);
            }
        }
        finally {
            if (e) {
                // eslint-disable-next-line no-unsafe-finally
                throw e.error;
            }
        }
    }
    return ar;
}
/** @deprecated */
function __spreadArraysFn() {
    var theArgs = arguments;
    // Calculate new total size
    for (var s = 0, i = 0, il = theArgs.length; i < il; i++) {
        s += theArgs[i].length;
    }
    // Create new full array
    for (var r = Array(s), k = 0, i = 0; i < il; i++) {
        for (var a = theArgs[i], j = 0, jl = a.length; j < jl; j++, k++) {
            r[k] = a[j];
        }
    }
    return r;
}
function __spreadArrayFn(to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++) {
        to[j] = from[i];
    }
    return to;
}
function __makeTemplateObjectFn(cooked, raw) {
    if (_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objDefineProp) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objDefineProp)(cooked, "raw", { value: raw });
    }
    else {
        cooked.raw = raw;
    }
    return cooked;
}
function __importStarFn(mod) {
    if (mod && mod.__esModule) {
        return mod;
    }
    var result = {};
    if (mod != null) {
        for (var k in mod) {
            if (k !== _Constants__WEBPACK_IMPORTED_MODULE_1__.strDefault && Object.prototype.hasOwnProperty.call(mod, k)) {
                __createBindingFn(result, mod, k);
            }
        }
    }
    // Set default module
    if (!!_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objDefineProp) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objDefineProp)(result, _Constants__WEBPACK_IMPORTED_MODULE_1__.strDefault, { enumerable: true, value: mod });
    }
    else {
        result[_Constants__WEBPACK_IMPORTED_MODULE_1__.strDefault] = mod;
    }
    return result;
}
function __importDefaultFn(mod) {
    return (mod && mod.__esModule) ? mod : { strDefault: mod };
}
//# sourceMappingURL=TsLibShims.js.map

/***/ }),
/* 85 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Metric": () => (/* binding */ Metric)
/* harmony export */ });
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16);
/* harmony import */ var _Common_DataPoint__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(86);
/* harmony import */ var _Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(35);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






var Metric = /** @class */ (function () {
    /**
     * Constructs a new instance of the MetricTelemetry object
     */
    function Metric(logger, name, value, count, min, max, stdDev, properties, measurements) {
        this.aiDataContract = {
            ver: 1 /* FieldType.Required */,
            metrics: 1 /* FieldType.Required */,
            properties: 0 /* FieldType.Default */
        };
        var _self = this;
        _self.ver = 2;
        var dataPoint = new _Common_DataPoint__WEBPACK_IMPORTED_MODULE_0__.DataPoint();
        dataPoint[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COUNT /* @min:%2ecount */] = count > 0 ? count : undefined;
        dataPoint.max = isNaN(max) || max === null ? undefined : max;
        dataPoint.min = isNaN(min) || min === null ? undefined : min;
        dataPoint[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:%2ename */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_2__.dataSanitizeString)(logger, name) || _Constants__WEBPACK_IMPORTED_MODULE_3__.strNotSpecified;
        dataPoint.value = value;
        dataPoint.stdDev = isNaN(stdDev) || stdDev === null ? undefined : stdDev;
        _self.metrics = [dataPoint];
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROPERTIES /* @min:%2eproperties */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_2__.dataSanitizeProperties)(logger, properties);
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_MEASUREMENTS /* @min:%2emeasurements */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_2__.dataSanitizeMeasurements)(logger, measurements);
    }
    Metric.envelopeType = "Microsoft.ApplicationInsights.{0}.Metric";
    Metric.dataType = "MetricData";
    return Metric;
}());

//# sourceMappingURL=Metric.js.map

/***/ }),
/* 86 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DataPoint": () => (/* binding */ DataPoint)
/* harmony export */ });
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


var DataPoint = /** @class */ (function () {
    function DataPoint() {
        /**
         * The data contract for serializing this object.
         */
        this.aiDataContract = {
            name: 1 /* FieldType.Required */,
            kind: 0 /* FieldType.Default */,
            value: 1 /* FieldType.Required */,
            count: 0 /* FieldType.Default */,
            min: 0 /* FieldType.Default */,
            max: 0 /* FieldType.Default */,
            stdDev: 0 /* FieldType.Default */
        };
        /**
         * Metric type. Single measurement or the aggregated value.
         */
        this.kind = 0 /* DataPointType.Measurement */;
    }
    return DataPoint;
}());

//# sourceMappingURL=DataPoint.js.map

/***/ }),
/* 87 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PageView": () => (/* binding */ PageView)
/* harmony export */ });
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(88);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16);
/* harmony import */ var _Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(35);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






var PageView = /** @class */ (function () {
    /**
     * Constructs a new instance of the PageEventTelemetry object
     */
    function PageView(logger, name, url, durationMs, properties, measurements, id) {
        this.aiDataContract = {
            ver: 1 /* FieldType.Required */,
            name: 0 /* FieldType.Default */,
            url: 0 /* FieldType.Default */,
            duration: 0 /* FieldType.Default */,
            properties: 0 /* FieldType.Default */,
            measurements: 0 /* FieldType.Default */,
            id: 0 /* FieldType.Default */
        };
        var _self = this;
        _self.ver = 2;
        _self.id = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_0__.dataSanitizeId)(logger, id);
        _self.url = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_0__.dataSanitizeUrl)(logger, url);
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:%2ename */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_0__.dataSanitizeString)(logger, name) || _Constants__WEBPACK_IMPORTED_MODULE_2__.strNotSpecified;
        if (!isNaN(durationMs)) {
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_DURATION /* @min:%2eduration */] = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.msToTimeSpan)(durationMs);
        }
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROPERTIES /* @min:%2eproperties */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_0__.dataSanitizeProperties)(logger, properties);
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_MEASUREMENTS /* @min:%2emeasurements */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_0__.dataSanitizeMeasurements)(logger, measurements);
    }
    PageView.envelopeType = "Microsoft.ApplicationInsights.{0}.Pageview";
    PageView.dataType = "PageviewData";
    return PageView;
}());

//# sourceMappingURL=PageView.js.map

/***/ }),
/* 88 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getExtensionByName": () => (/* binding */ getExtensionByName),
/* harmony export */   "isCrossOriginError": () => (/* binding */ isCrossOriginError),
/* harmony export */   "msToTimeSpan": () => (/* binding */ msToTimeSpan),
/* harmony export */   "stringToBoolOrDefault": () => (/* binding */ stringToBoolOrDefault)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(14);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */




var strEmpty = "";
function stringToBoolOrDefault(str, defaultValue) {
    if (defaultValue === void 0) { defaultValue = false; }
    if (str === undefined || str === null) {
        return defaultValue;
    }
    return str.toString()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]() === "true";
}
/**
 * Convert ms to c# time span format
 */
function msToTimeSpan(totalms) {
    if (isNaN(totalms) || totalms < 0) {
        totalms = 0;
    }
    totalms = Math.round(totalms);
    var ms = strEmpty + totalms % 1000;
    var sec = strEmpty + Math.floor(totalms / 1000) % 60;
    var min = strEmpty + Math.floor(totalms / (1000 * 60)) % 60;
    var hour = strEmpty + Math.floor(totalms / (1000 * 60 * 60)) % 24;
    var days = Math.floor(totalms / (1000 * 60 * 60 * 24));
    ms = ms[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] === 1 ? "00" + ms : ms[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] === 2 ? "0" + ms : ms;
    sec = sec[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] < 2 ? "0" + sec : sec;
    min = min[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] < 2 ? "0" + min : min;
    hour = hour[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] < 2 ? "0" + hour : hour;
    return (days > 0 ? days + "." : strEmpty) + hour + ":" + min + ":" + sec + "." + ms;
}
function getExtensionByName(extensions, identifier) {
    var extension = null;
    (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(extensions, function (value) {
        if (value.identifier === identifier) {
            extension = value;
            return -1;
        }
    });
    return extension;
}
function isCrossOriginError(message, url, lineNumber, columnNumber, error) {
    return !error && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isString)(message) && (message === "Script error." || message === "Script error");
}
//# sourceMappingURL=HelperFuncs.js.map

/***/ }),
/* 89 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RemoteDependencyData": () => (/* binding */ RemoteDependencyData)
/* harmony export */ });
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(88);
/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);
/* harmony import */ var _Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(35);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






var RemoteDependencyData = /** @class */ (function () {
    /**
     * Constructs a new instance of the RemoteDependencyData object
     */
    function RemoteDependencyData(logger, id, absoluteUrl, commandName, value, success, resultCode, method, requestAPI, correlationContext, properties, measurements) {
        if (requestAPI === void 0) { requestAPI = "Ajax"; }
        this.aiDataContract = {
            id: 1 /* FieldType.Required */,
            ver: 1 /* FieldType.Required */,
            name: 0 /* FieldType.Default */,
            resultCode: 0 /* FieldType.Default */,
            duration: 0 /* FieldType.Default */,
            success: 0 /* FieldType.Default */,
            data: 0 /* FieldType.Default */,
            target: 0 /* FieldType.Default */,
            type: 0 /* FieldType.Default */,
            properties: 0 /* FieldType.Default */,
            measurements: 0 /* FieldType.Default */,
            kind: 0 /* FieldType.Default */,
            value: 0 /* FieldType.Default */,
            count: 0 /* FieldType.Default */,
            min: 0 /* FieldType.Default */,
            max: 0 /* FieldType.Default */,
            stdDev: 0 /* FieldType.Default */,
            dependencyKind: 0 /* FieldType.Default */,
            dependencySource: 0 /* FieldType.Default */,
            commandName: 0 /* FieldType.Default */,
            dependencyTypeName: 0 /* FieldType.Default */
        };
        var _self = this;
        _self.ver = 2;
        _self.id = id;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DURATION /* @min:%2eduration */] = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.msToTimeSpan)(value);
        _self.success = success;
        _self.resultCode = resultCode + "";
        _self.type = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_2__.dataSanitizeString)(logger, requestAPI);
        var dependencyFields = (0,_Util__WEBPACK_IMPORTED_MODULE_3__.AjaxHelperParseDependencyPath)(logger, absoluteUrl, method, commandName);
        _self.data = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_2__.dataSanitizeUrl)(logger, commandName) || dependencyFields.data; // get a value from hosturl if commandName not available
        _self.target = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_2__.dataSanitizeString)(logger, dependencyFields.target);
        if (correlationContext) {
            _self.target = "".concat(_self.target, " | ").concat(correlationContext);
        }
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_NAME /* @min:%2ename */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_2__.dataSanitizeString)(logger, dependencyFields[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_NAME /* @min:%2ename */]);
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROPERTIES /* @min:%2eproperties */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_2__.dataSanitizeProperties)(logger, properties);
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MEASUREMENTS /* @min:%2emeasurements */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_2__.dataSanitizeMeasurements)(logger, measurements);
    }
    RemoteDependencyData.envelopeType = "Microsoft.ApplicationInsights.{0}.RemoteDependency";
    RemoteDependencyData.dataType = "RemoteDependencyData";
    return RemoteDependencyData;
}());

//# sourceMappingURL=RemoteDependencyData.js.map

/***/ }),
/* 90 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Trace": () => (/* binding */ Trace)
/* harmony export */ });
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16);
/* harmony import */ var _Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(35);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





var Trace = /** @class */ (function () {
    /**
     * Constructs a new instance of the TraceTelemetry object
     */
    function Trace(logger, message, severityLevel, properties, measurements) {
        this.aiDataContract = {
            ver: 1 /* FieldType.Required */,
            message: 1 /* FieldType.Required */,
            severityLevel: 0 /* FieldType.Default */,
            properties: 0 /* FieldType.Default */
        };
        var _self = this;
        _self.ver = 2;
        message = message || _Constants__WEBPACK_IMPORTED_MODULE_0__.strNotSpecified;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_MESSAGE /* @min:%2emessage */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_2__.dataSanitizeMessage)(logger, message);
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROPERTIES /* @min:%2eproperties */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_2__.dataSanitizeProperties)(logger, properties);
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_MEASUREMENTS /* @min:%2emeasurements */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_2__.dataSanitizeMeasurements)(logger, measurements);
        if (severityLevel) {
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEVERITY_LEVEL /* @min:%2eseverityLevel */] = severityLevel;
        }
    }
    Trace.envelopeType = "Microsoft.ApplicationInsights.{0}.Message";
    Trace.dataType = "MessageData";
    return Trace;
}());

//# sourceMappingURL=Trace.js.map

/***/ }),
/* 91 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PageViewPerformance": () => (/* binding */ PageViewPerformance)
/* harmony export */ });
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16);
/* harmony import */ var _Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(35);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





var PageViewPerformance = /** @class */ (function () {
    /**
     * Constructs a new instance of the PageEventTelemetry object
     */
    function PageViewPerformance(logger, name, url, unused, properties, measurements, cs4BaseData) {
        this.aiDataContract = {
            ver: 1 /* FieldType.Required */,
            name: 0 /* FieldType.Default */,
            url: 0 /* FieldType.Default */,
            duration: 0 /* FieldType.Default */,
            perfTotal: 0 /* FieldType.Default */,
            networkConnect: 0 /* FieldType.Default */,
            sentRequest: 0 /* FieldType.Default */,
            receivedResponse: 0 /* FieldType.Default */,
            domProcessing: 0 /* FieldType.Default */,
            properties: 0 /* FieldType.Default */,
            measurements: 0 /* FieldType.Default */
        };
        var _self = this;
        _self.ver = 2;
        _self.url = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_0__.dataSanitizeUrl)(logger, url);
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:%2ename */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_0__.dataSanitizeString)(logger, name) || _Constants__WEBPACK_IMPORTED_MODULE_2__.strNotSpecified;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROPERTIES /* @min:%2eproperties */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_0__.dataSanitizeProperties)(logger, properties);
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_MEASUREMENTS /* @min:%2emeasurements */] = (0,_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_0__.dataSanitizeMeasurements)(logger, measurements);
        if (cs4BaseData) {
            _self.domProcessing = cs4BaseData.domProcessing;
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_DURATION /* @min:%2eduration */] = cs4BaseData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_DURATION /* @min:%2eduration */];
            _self.networkConnect = cs4BaseData.networkConnect;
            _self.perfTotal = cs4BaseData.perfTotal;
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_RECEIVED_RESPONSE /* @min:%2ereceivedResponse */] = cs4BaseData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_RECEIVED_RESPONSE /* @min:%2ereceivedResponse */];
            _self.sentRequest = cs4BaseData.sentRequest;
        }
    }
    PageViewPerformance.envelopeType = "Microsoft.ApplicationInsights.{0}.PageviewPerformance";
    PageViewPerformance.dataType = "PageviewPerformanceData";
    return PageViewPerformance;
}());

//# sourceMappingURL=PageViewPerformance.js.map

/***/ }),
/* 92 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Data": () => (/* binding */ Data)
/* harmony export */ });
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


var Data = /** @class */ (function () {
    /**
     * Constructs a new instance of telemetry data.
     */
    function Data(baseType, data) {
        /**
         * The data contract for serializing this object.
         */
        this.aiDataContract = {
            baseType: 1 /* FieldType.Required */,
            baseData: 1 /* FieldType.Required */
        };
        this.baseType = baseType;
        this.baseData = data;
    }
    return Data;
}());

//# sourceMappingURL=Data.js.map

/***/ }),
/* 93 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SeverityLevel": () => (/* binding */ SeverityLevel)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(30);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */



/**
 * Defines the level of severity for the event.
 */
var SeverityLevel = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)({
    Verbose: 0 /* eSeverityLevel.Verbose */,
    Information: 1 /* eSeverityLevel.Information */,
    Warning: 2 /* eSeverityLevel.Warning */,
    Error: 3 /* eSeverityLevel.Error */,
    Critical: 4 /* eSeverityLevel.Critical */
});
//# sourceMappingURL=SeverityLevel.js.map

/***/ }),
/* 94 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ConfigurationManager": () => (/* binding */ ConfigurationManager)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */




var ConfigurationManager = /** @class */ (function () {
    function ConfigurationManager() {
    }
    ConfigurationManager.getConfig = function (config, field, identifier, defaultValue) {
        if (defaultValue === void 0) { defaultValue = false; }
        var configValue;
        if (identifier && config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_EXTENSION_CONFIG /* @min:%2eextensionConfig */] && config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_EXTENSION_CONFIG /* @min:%2eextensionConfig */][identifier] && !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_EXTENSION_CONFIG /* @min:%2eextensionConfig */][identifier][field])) {
            configValue = config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_EXTENSION_CONFIG /* @min:%2eextensionConfig */][identifier][field];
        }
        else {
            configValue = config[field];
        }
        return !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(configValue) ? configValue : defaultValue;
    };
    return ConfigurationManager;
}());

//# sourceMappingURL=IConfig.js.map

/***/ }),
/* 95 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ContextTagKeys": () => (/* binding */ ContextTagKeys)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(84);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(46);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */




function _aiNameFunc(baseName) {
    var aiName = "ai." + baseName + ".";
    return function (name) {
        return aiName + name;
    };
}
var _aiApplication = _aiNameFunc("application");
var _aiDevice = _aiNameFunc("device");
var _aiLocation = _aiNameFunc("location");
var _aiOperation = _aiNameFunc("operation");
var _aiSession = _aiNameFunc("session");
var _aiUser = _aiNameFunc("user");
var _aiCloud = _aiNameFunc("cloud");
var _aiInternal = _aiNameFunc("internal");
var ContextTagKeys = /** @class */ (function (_super) {
    (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.__extendsFn)(ContextTagKeys, _super);
    function ContextTagKeys() {
        return _super.call(this) || this;
    }
    return ContextTagKeys;
}((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.createClassFromInterface)({
    applicationVersion: _aiApplication("ver"),
    applicationBuild: _aiApplication("build"),
    applicationTypeId: _aiApplication("typeId"),
    applicationId: _aiApplication("applicationId"),
    applicationLayer: _aiApplication("layer"),
    deviceId: _aiDevice("id"),
    deviceIp: _aiDevice("ip"),
    deviceLanguage: _aiDevice("language"),
    deviceLocale: _aiDevice("locale"),
    deviceModel: _aiDevice("model"),
    deviceFriendlyName: _aiDevice("friendlyName"),
    deviceNetwork: _aiDevice("network"),
    deviceNetworkName: _aiDevice("networkName"),
    deviceOEMName: _aiDevice("oemName"),
    deviceOS: _aiDevice("os"),
    deviceOSVersion: _aiDevice("osVersion"),
    deviceRoleInstance: _aiDevice("roleInstance"),
    deviceRoleName: _aiDevice("roleName"),
    deviceScreenResolution: _aiDevice("screenResolution"),
    deviceType: _aiDevice("type"),
    deviceMachineName: _aiDevice("machineName"),
    deviceVMName: _aiDevice("vmName"),
    deviceBrowser: _aiDevice("browser"),
    deviceBrowserVersion: _aiDevice("browserVersion"),
    locationIp: _aiLocation("ip"),
    locationCountry: _aiLocation("country"),
    locationProvince: _aiLocation("province"),
    locationCity: _aiLocation("city"),
    operationId: _aiOperation("id"),
    operationName: _aiOperation("name"),
    operationParentId: _aiOperation("parentId"),
    operationRootId: _aiOperation("rootId"),
    operationSyntheticSource: _aiOperation("syntheticSource"),
    operationCorrelationVector: _aiOperation("correlationVector"),
    sessionId: _aiSession("id"),
    sessionIsFirst: _aiSession("isFirst"),
    sessionIsNew: _aiSession("isNew"),
    userAccountAcquisitionDate: _aiUser("accountAcquisitionDate"),
    userAccountId: _aiUser("accountId"),
    userAgent: _aiUser("userAgent"),
    userId: _aiUser("id"),
    userStoreRegion: _aiUser("storeRegion"),
    userAuthUserId: _aiUser("authUserId"),
    userAnonymousUserAcquisitionDate: _aiUser("anonUserAcquisitionDate"),
    userAuthenticatedUserAcquisitionDate: _aiUser("authUserAcquisitionDate"),
    cloudName: _aiCloud("name"),
    cloudRole: _aiCloud("role"),
    cloudRoleVer: _aiCloud("roleVer"),
    cloudRoleInstance: _aiCloud("roleInstance"),
    cloudEnvironment: _aiCloud("environment"),
    cloudLocation: _aiCloud("location"),
    cloudDeploymentUnit: _aiCloud("deploymentUnit"),
    internalNodeName: _aiInternal("nodeName"),
    internalSdkVersion: _aiInternal("sdkVersion"),
    internalAgentVersion: _aiInternal("agentVersion"),
    internalSnippet: _aiInternal("snippet"),
    internalSdkSrc: _aiInternal("sdkSrc")
})));

//# sourceMappingURL=ContextTagKeys.js.map

/***/ }),
/* 96 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TelemetryItemCreator": () => (/* binding */ TelemetryItemCreator),
/* harmony export */   "createTelemetryItem": () => (/* binding */ createTelemetryItem)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(14);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(46);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(24);
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7);
/* harmony import */ var _Telemetry_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(35);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






/**
 * Create a telemetry item that the 1DS channel understands
 * @param item - domain specific properties; part B
 * @param baseType - telemetry item type. ie PageViewData
 * @param envelopeName - name of the envelope. ie Microsoft.ApplicationInsights.<instrumentation key>.PageView
 * @param customProperties - user defined custom properties; part C
 * @param systemProperties - system properties that are added to the context; part A
 * @returns ITelemetryItem that is sent to channel
 */
function createTelemetryItem(item, baseType, envelopeName, logger, customProperties, systemProperties) {
    var _a;
    envelopeName = (0,_Telemetry_Common_DataSanitizer__WEBPACK_IMPORTED_MODULE_0__.dataSanitizeString)(logger, envelopeName) || _Constants__WEBPACK_IMPORTED_MODULE_1__.strNotSpecified;
    if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(item) ||
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(baseType) ||
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(envelopeName)) {
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.throwError)("Input doesn't contain all required fields");
    }
    var iKey = "";
    if (item[_Constants__WEBPACK_IMPORTED_MODULE_1__.strIkey]) {
        iKey = item[_Constants__WEBPACK_IMPORTED_MODULE_1__.strIkey];
        delete item[_Constants__WEBPACK_IMPORTED_MODULE_1__.strIkey];
    }
    var telemetryItem = (_a = {},
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_4__._DYN_NAME /* @min:name */] = envelopeName,
        _a.time = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.toISOString)(new Date()),
        _a.iKey = iKey,
        _a.ext = systemProperties ? systemProperties : {},
        _a.tags = [],
        _a.data = {},
        _a.baseType = baseType,
        _a.baseData = item // Part B
    ,
        _a);
    // Part C
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(customProperties)) {
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.objForEachKey)(customProperties, function (prop, value) {
            telemetryItem.data[prop] = value;
        });
    }
    return telemetryItem;
}
var TelemetryItemCreator = /** @class */ (function () {
    function TelemetryItemCreator() {
    }
    /**
     * Create a telemetry item that the 1DS channel understands
     * @param item - domain specific properties; part B
     * @param baseType - telemetry item type. ie PageViewData
     * @param envelopeName - name of the envelope. ie Microsoft.ApplicationInsights.<instrumentation key>.PageView
     * @param customProperties - user defined custom properties; part C
     * @param systemProperties - system properties that are added to the context; part A
     * @returns ITelemetryItem that is sent to channel
     */
    TelemetryItemCreator.create = createTelemetryItem;
    return TelemetryItemCreator;
}());

//# sourceMappingURL=TelemetryItemCreator.js.map

/***/ }),
/* 97 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CtxTagKeys": () => (/* binding */ CtxTagKeys),
/* harmony export */   "Extensions": () => (/* binding */ Extensions)
/* harmony export */ });
/* harmony import */ var _Contracts_ContextTagKeys__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(95);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */

var Extensions = {
    UserExt: "user",
    DeviceExt: "device",
    TraceExt: "trace",
    WebExt: "web",
    AppExt: "app",
    OSExt: "os",
    SessionExt: "ses",
    SDKExt: "sdk"
};
var CtxTagKeys = new _Contracts_ContextTagKeys__WEBPACK_IMPORTED_MODULE_0__.ContextTagKeys();
//# sourceMappingURL=PartAExtensions.js.map

/***/ }),
/* 98 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createDomEvent": () => (/* binding */ createDomEvent)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18);
/*
 * Application Insights JavaScript SDK - Common, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */



function createDomEvent(eventName) {
    var event = null;
    if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isFunction)(Event)) { // Use Event constructor when available
        event = new Event(eventName);
    }
    else { // Event has no constructor in IE
        var doc = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.getDocument)();
        if (doc && doc.createEvent) {
            event = doc.createEvent("Event");
            event.initEvent(eventName, true, true);
        }
    }
    return event;
}
//# sourceMappingURL=DomHelperFuncs.js.map

/***/ }),
/* 99 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TelemetryUtil": () => (/* binding */ TelemetryUtil)
/* harmony export */ });
/*---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
class TelemetryUtil {
    static applyReplacements(data, replacementOptions) {
        for (const key of Object.keys(data)) {
            for (const option of replacementOptions) {
                if (option.lookup.test(key)) {
                    if (option.replacementString !== undefined) {
                        data[key] = option.replacementString;
                    }
                    else {
                        delete data[key];
                    }
                }
            }
        }
    }
    /**
     * Given a key checks if it is a valid 1DS key
     * @param key The key to check if it's a valid 1DS key
     */
    static shouldUseOneDataSystemSDK(key) {
        // Simple to check to ensure the key is the right length and the dashes are in the right spot
        return (key.length === 74 &&
            key[32] === "-" &&
            key[41] === "-" &&
            key[46] === "-" &&
            key[51] === "-" &&
            key[56] === "-" &&
            key[69] === "-");
    }
    // This also includes the common properties which core mixes in
    // __GDPR__COMMON__ "common.os" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.nodeArch" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.platformversion" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.extname" : { "classification": "PublicNonPersonalData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.extversion" : { "classification": "PublicNonPersonalData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.vscodemachineid" : { "endPoint": "MacAddressHash", "classification": "EndUserPseudonymizedInformation", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.vscodesessionid" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.vscodeversion" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.uikind" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.remotename" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.isnewappinstall" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.product" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.telemetryclientversion" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    static getAdditionalCommonProperties(osShim) {
        return {
            "common.os": osShim.platform,
            "common.nodeArch": osShim.architecture,
            "common.platformversion": (osShim.release || "").replace(/^(\d+)(\.\d+)?(\.\d+)?(.*)/, "$1$2$3"),
            // Do not change this string as it gets found and replaced upon packaging
            "common.telemetryclientversion": "0.9.0"
        };
    }
    // Get singleton instance of TelemetryUtil
    static getInstance() {
        if (!TelemetryUtil._instance) {
            TelemetryUtil._instance = new TelemetryUtil();
        }
        return TelemetryUtil._instance;
    }
}
//# sourceMappingURL=util.js.map

/***/ }),
/* 100 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppInsightsCore": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.AppInsightsCore),
/* harmony export */   "ApplicationInsights": () => (/* binding */ ApplicationInsights),
/* harmony export */   "Sender": () => (/* reexport safe */ _microsoft_applicationinsights_channel_js__WEBPACK_IMPORTED_MODULE_11__.Sender),
/* harmony export */   "SeverityLevel": () => (/* reexport safe */ _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_13__.SeverityLevel),
/* harmony export */   "arrForEach": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_12__.arrForEach),
/* harmony export */   "isNullOrUndefined": () => (/* reexport safe */ _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined),
/* harmony export */   "proxyFunctions": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__.proxyFunctions),
/* harmony export */   "throwError": () => (/* reexport safe */ _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.throwError)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(51);
/* harmony import */ var _microsoft_applicationinsights_channel_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(132);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(77);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(7);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(101);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(102);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(46);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(52);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(14);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(22);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(131);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(28);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(93);
/*
 * Application Insights JavaScript Web SDK - Basic, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */








var defaultConfigValues = {
    diagnosticLogInterval: (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.cfgDfValidate)(_chkDiagLevel, 10000)
};
function _chkDiagLevel(value) {
    // Make sure we have a value > 0
    return value && value > 0;
}
/**
 * @export
 * @class ApplicationInsights
 */
var ApplicationInsights = /** @class */ (function () {
    /**
     * Creates an instance of ApplicationInsights.
     * @param config
     * @memberof ApplicationInsights
     */
    function ApplicationInsights(config) {
        var core = new _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.AppInsightsCore();
        var _config;
        // initialize the queue and config in case they are undefined
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(config) ||
            ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_INSTRUMENTATION_KEY /* @min:%2einstrumentationKey */]) && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_CONNECTION_STRING /* @min:%2econnectionString */]))) {
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.throwError)("Invalid input configuration");
        }
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_5__["default"])(ApplicationInsights, this, function (_self) {
            // Define _self.config
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objDefine)(_self, "config", {
                g: function () { return _config; }
            });
            _initialize();
            _self.initialize = _initialize;
            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__.proxyFunctions)(_self, core, [
                "track",
                "flush",
                "pollInternalLogs",
                "stopPollingInternalLogs",
                "unload",
                "getPlugin",
                "addPlugin",
                "evtNamespace",
                "addUnloadCb",
                "onCfgChange"
            ]);
            function _initialize() {
                var cfgHandler = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.createDynamicConfig)(config || {}, defaultConfigValues);
                _config = cfgHandler.cfg;
                core.addUnloadHook((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.onConfigChange)(cfgHandler, function () {
                    if (_config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_CONNECTION_STRING /* @min:%2econnectionString */]) {
                        var cs = (0,_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_9__.parseConnectionString)(_config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_CONNECTION_STRING /* @min:%2econnectionString */]);
                        var ingest = cs.ingestionendpoint;
                        _config.endpointUrl = ingest ? (ingest + _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_10__.DEFAULT_BREEZE_PATH) : _config.endpointUrl; // only add /v2/track when from connectionstring
                        _config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_INSTRUMENTATION_KEY /* @min:%2einstrumentationKey */] = cs.instrumentationkey || _config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_INSTRUMENTATION_KEY /* @min:%2einstrumentationKey */];
                    }
                }));
                // initialize core
                core.initialize(_config, [new _microsoft_applicationinsights_channel_js__WEBPACK_IMPORTED_MODULE_11__.Sender()]);
            }
        });
    }
// Removed Stub for ApplicationInsights.prototype.initialize.
// Removed Stub for ApplicationInsights.prototype.track.
// Removed Stub for ApplicationInsights.prototype.flush.
// Removed Stub for ApplicationInsights.prototype.pollInternalLogs.
// Removed Stub for ApplicationInsights.prototype.stopPollingInternalLogs.
// Removed Stub for ApplicationInsights.prototype.unload.
// Removed Stub for ApplicationInsights.prototype.getPlugin.
// Removed Stub for ApplicationInsights.prototype.addPlugin.
// Removed Stub for ApplicationInsights.prototype.evtNamespace.
// Removed Stub for ApplicationInsights.prototype.addUnloadCb.
// Removed Stub for ApplicationInsights.prototype.onCfgChange.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    ApplicationInsights.__ieDyn=1;

    return ApplicationInsights;
}());




//# sourceMappingURL=index.js.map

/***/ }),
/* 101 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "cfgDfBlockPropValue": () => (/* binding */ cfgDfBlockPropValue),
/* harmony export */   "cfgDfBoolean": () => (/* binding */ cfgDfBoolean),
/* harmony export */   "cfgDfFunc": () => (/* binding */ cfgDfFunc),
/* harmony export */   "cfgDfMerge": () => (/* binding */ cfgDfMerge),
/* harmony export */   "cfgDfSet": () => (/* binding */ cfgDfSet),
/* harmony export */   "cfgDfString": () => (/* binding */ cfgDfString),
/* harmony export */   "cfgDfValidate": () => (/* binding */ cfgDfValidate)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(12);
/* harmony import */ var _JavaScriptSDK_InternalConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(43);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(42);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





/**
 * @internal
 * @ignore
 * @param str
 * @param defaultValue
 * @returns
 */
function _stringToBoolOrDefault(theValue, defaultValue, theConfig) {
    if (!theValue && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(theValue)) {
        return defaultValue;
    }
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isBoolean)(theValue)) {
        return theValue;
    }
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.asString)(theValue)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]() === "true";
}
/**
 * Helper which returns an IConfigDefaultCheck instance with the field defined as an object
 * that should be merged
 * @param defaultValue - The default value to apply it not provided or it's not valid
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfMerge(defaultValue) {
    return {
        mrg: true,
        v: defaultValue
    };
}
/**
 * Helper which returns an IConfigDefaultCheck instance with the provided field set function
 * @param setter - The IConfigCheckFn function to validate the user provided value
 * @param defaultValue - The default value to apply it not provided or it's not valid
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfSet(setter, defaultValue) {
    return {
        set: setter,
        v: defaultValue
    };
}
/**
 * Helper which returns an IConfigDefaultCheck instance with the provided field validator
 * @param validator - The IConfigCheckFn function to validate the user provided value
 * @param defaultValue - The default value to apply it not provided or it's not valid
 * @param fallBackName - The fallback configuration name if the current value is not available
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfValidate(validator, defaultValue, fallBackName) {
    return {
        fb: fallBackName,
        isVal: validator,
        v: defaultValue
    };
}
/**
 * Helper which returns an IConfigDefaultCheck instance that will validate and convert the user
 * provided value to a boolean from a string or boolean value
 * @param defaultValue - The default value to apply it not provided or it's not valid
 * @param fallBackName - The fallback configuration name if the current value is not available
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfBoolean(defaultValue, fallBackName) {
    return {
        fb: fallBackName,
        set: _stringToBoolOrDefault,
        v: !!defaultValue
    };
}
/**
 * Helper which returns an IConfigDefaultCheck instance that will validate that the user
 * provided value is a function.
 * @param defaultValue - The default value to apply it not provided or it's not valid
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfFunc(defaultValue) {
    return {
        isVal: _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isFunction,
        v: defaultValue || null
    };
}
/**
 * Helper which returns an IConfigDefaultCheck instance that will validate that the user
 * provided value is a function.
 * @param defaultValue - The default string value to apply it not provided or it's not valid, defaults to an empty string
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfString(defaultValue) {
    return {
        isVal: _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isString,
        v: (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.asString)(defaultValue || _JavaScriptSDK_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EMPTY)
    };
}
/**
 * Helper which returns an IConfigDefaultCheck instance identifying that value associated with this property
 * should not have it's properties converted into a dynamic config properties.
 * @param defaultValue - The default value to apply it not provided or it's not valid
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfBlockPropValue(defaultValue) {
    var _a;
    return _a = {},
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_BLK_VAL /* @min:blkVal */] = true,
        _a.v = defaultValue,
        _a;
}
//# sourceMappingURL=ConfigDefaultHelpers.js.map

/***/ }),
/* 102 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppInsightsCore": () => (/* binding */ AppInsightsCore)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(84);
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(51);
/* harmony import */ var _nevware21_ts_async__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(105);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(28);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(14);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(24);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(47);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(69);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(121);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(25);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(18);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(22);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(123);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(8);
/* harmony import */ var _Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(52);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(42);
/* harmony import */ var _AsyncUtils__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(117);
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(130);
/* harmony import */ var _CookieMgr__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(116);
/* harmony import */ var _DataCacheHelper__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(58);
/* harmony import */ var _DbgExtensionUtils__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(71);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(41);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(46);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43);
/* harmony import */ var _NotificationManager__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(104);
/* harmony import */ var _PerfManager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(103);
/* harmony import */ var _ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(119);
/* harmony import */ var _TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(120);
/* harmony import */ var _TelemetryInitializerPlugin__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(126);
/* harmony import */ var _UnloadHandlerContainer__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(129);
/* harmony import */ var _UnloadHookContainer__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(128);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */



var _a;





















var strValidationError = "Plugins must provide initialize method";
var strNotificationManager = "_notificationManager";
var strSdkUnloadingError = "SDK is still unloading...";
var strSdkNotInitialized = "SDK is not initialized";
// const strPluginUnloadFailed = "Failed to unload plugin";
/**
 * The default settings for the config.
 * WE MUST include all defaults here to ensure that the config is created with all of the properties
 * defined as dynamic.
 */
var defaultConfig = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objDeepFreeze)((_a = {
        cookieCfg: {}
    },
    _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSIONS] = { rdOnly: true, ref: true, v: [] },
    _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS] = { rdOnly: true, ref: true, v: [] },
    _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSION_CONFIG] = { ref: true, v: {} },
    _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CREATE_PERF_MGR] = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE,
    _a.loggingLevelConsole = 0 /* eLoggingSeverity.DISABLED */,
    _a.diagnosticLogInterval = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE,
    _a));
/**
 * Helper to create the default performance manager
 * @param core
 * @param notificationMgr
 */
function _createPerfManager(core, notificationMgr) {
    return new _PerfManager__WEBPACK_IMPORTED_MODULE_2__.PerfManager(notificationMgr);
}
function _validateExtensions(logger, channelPriority, allExtensions) {
    var _a;
    // Concat all available extensions
    var coreExtensions = [];
    var channels = [];
    // Check if any two extensions have the same priority, then warn to console
    // And extract the local extensions from the
    var extPriorities = {};
    // Extension validation
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(allExtensions, function (ext) {
        // Check for ext.initialize
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isNullOrUndefined)(ext) || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isNullOrUndefined)(ext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_INITIALIZE /* @min:%2einitialize */])) {
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)(strValidationError);
        }
        var extPriority = ext[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_PRIORITY /* @min:%2epriority */];
        var identifier = ext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IDENTIFIER /* @min:%2eidentifier */];
        if (ext && extPriority) {
            if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isNullOrUndefined)(extPriorities[extPriority])) {
                (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__._warnToConsole)(logger, "Two extensions have same priority #" + extPriority + " - " + extPriorities[extPriority] + ", " + identifier);
            }
            else {
                // set a value
                extPriorities[extPriority] = identifier;
            }
        }
        // Split extensions to core and channels
        if (!extPriority || extPriority < channelPriority) {
            // Add to core extension that will be managed by AppInsightsCore
            coreExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](ext);
        }
        else {
            channels[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](ext);
        }
    });
    return _a = {},
        _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CORE /* @min:core */] = coreExtensions,
        _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS /* @min:channels */] = channels,
        _a;
}
function _isPluginPresent(thePlugin, plugins) {
    var exists = false;
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(plugins, function (plugin) {
        if (plugin === thePlugin) {
            exists = true;
            return -1;
        }
    });
    return exists;
}
function _deepMergeConfig(details, target, newValues, merge) {
    // Lets assign the new values to the existing config
    if (newValues) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__.objForEachKey)(newValues, function (key, value) {
            if (merge) {
                if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.isPlainObject)(value) && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.isPlainObject)(target[key])) {
                    // The target is an object and it has a value
                    _deepMergeConfig(details, target[key], value, merge);
                }
            }
            if (merge && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.isPlainObject)(value) && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.isPlainObject)(target[key])) {
                // The target is an object and it has a value
                _deepMergeConfig(details, target[key], value, merge);
            }
            else {
                // Just Assign (replace) and/or make the property dynamic
                details.set(target, key, value);
            }
        });
    }
}
function _findWatcher(listeners, newWatcher) {
    var theListener = null;
    var idx = -1;
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(listeners, function (listener, lp) {
        if (listener.w === newWatcher) {
            theListener = listener;
            idx = lp;
            return -1;
        }
    });
    return { i: idx, l: theListener };
}
function _addDelayedCfgListener(listeners, newWatcher) {
    var theListener = _findWatcher(listeners, newWatcher).l;
    if (!theListener) {
        theListener = {
            w: newWatcher,
            rm: function () {
                var fnd = _findWatcher(listeners, newWatcher);
                if (fnd.i !== -1) {
                    listeners[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_SPLICE /* @min:%2esplice */](fnd.i, 1);
                }
            }
        };
        listeners[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](theListener);
    }
    return theListener;
}
function _registerDelayedCfgListener(config, listeners, logger) {
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(listeners, function (listener) {
        var unloadHdl = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_10__.onConfigChange)(config, listener.w, logger);
        delete listener.w; // Clear the listener reference so it will get garbage collected.
        // replace the remove function
        listener.rm = function () {
            unloadHdl.rm();
        };
    });
}
/**
 * @group Classes
 * @group Entrypoint
 */
var AppInsightsCore = /** @class */ (function () {
    function AppInsightsCore() {
        // NOTE!: DON'T set default values here, instead set them in the _initDefaults() function as it is also called during teardown()
        var _configHandler;
        var _isInitialized;
        var _logger;
        var _eventQueue;
        var _notificationManager;
        var _perfManager;
        var _cfgPerfManager;
        var _cookieManager;
        var _pluginChain;
        var _configExtensions;
        var _channelConfig;
        var _channels;
        var _isUnloading;
        var _telemetryInitializerPlugin;
        var _internalLogsEventName;
        var _evtNamespace;
        var _unloadHandlers;
        var _hookContainer;
        var _debugListener;
        var _traceCtx;
        var _instrumentationKey;
        var _cfgListeners;
        var _extensions;
        var _pluginVersionStringArr;
        var _pluginVersionString;
        /**
         * Internal log poller
         */
        var _internalLogPoller;
        var _internalLogPollerListening;
        var _forceStopInternalLogPoller;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_11__["default"])(AppInsightsCore, this, function (_self) {
            // Set the default values (also called during teardown)
            _initDefaults();
            // Special internal method to allow the unit tests and DebugPlugin to hook embedded objects
            _self["_getDbgPlgTargets"] = function () {
                return [_extensions];
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */] = function () { return _isInitialized; };
            // Creating the self.initialize = ()
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_INITIALIZE /* @min:%2einitialize */] = function (config, extensions, logger, notificationManager) {
                if (_isUnloading) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)(strSdkUnloadingError);
                }
                // Make sure core is only initialized once
                if (_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */]()) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)("Core cannot be initialized more than once");
                }
                _configHandler = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_10__.createDynamicConfig)(config, defaultConfig, logger || _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */], false);
                // Re-assigning the local config property so we don't have any references to the passed value and it can be garbage collected
                config = _configHandler.cfg;
                // This will be "re-run" if the referenced config properties are changed
                _addUnloadHook(_configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_WATCH /* @min:%2ewatch */](function (details) {
                    _instrumentationKey = details.cfg.instrumentationKey;
                    // Mark the extensionConfig and all first level keys as referenced
                    // This is so that calls to getExtCfg() will always return the same object
                    // Even when a user may "re-assign" the plugin properties (or it's unloaded/reloaded)
                    var extCfg = details.ref(details.cfg, _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSION_CONFIG);
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__.objForEachKey)(extCfg, function (key) {
                        details.ref(extCfg, key);
                    });
                    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isNullOrUndefined)(_instrumentationKey)) {
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)("Please provide instrumentation key");
                    }
                }));
                _notificationManager = notificationManager;
                _initDebugListener();
                _initPerfManager();
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */] = logger;
                var cfgExtensions = config[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSIONS /* @min:%2eextensions */];
                // Extension validation
                _configExtensions = [];
                _configExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */].apply(_configExtensions, (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_12__.__spreadArrayFn)((0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_12__.__spreadArrayFn)([], extensions, false), cfgExtensions, false));
                _channelConfig = config[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS /* @min:%2echannels */];
                _initPluginChain(null);
                if (!_channels || _channels[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] === 0) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)("No " + _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS + " available");
                }
                if (_channelConfig && _channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 1) {
                    var teeController = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_PLUGIN /* @min:%2egetPlugin */]("TeeChannelController");
                    if (!teeController || !teeController.plugin) {
                        (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__._throwInternal)(_logger, 1 /* eLoggingSeverity.CRITICAL */, 28 /* _eInternalMessageId.SenderNotInitialized */, "TeeChannel required");
                    }
                }
                _registerDelayedCfgListener(config, _cfgListeners, _logger);
                _cfgListeners = null;
                _isInitialized = true;
                _self.releaseQueue();
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_POLL_INTERNAL_LOGS /* @min:%2epollInternalLogs */]();
            };
            _self.getChannels = function () {
                var controls = [];
                if (_channels) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(_channels, function (channel) {
                        controls[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](channel);
                    });
                }
                return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objFreeze)(controls);
            };
            _self.track = function (telemetryItem) {
                (0,_PerfManager__WEBPACK_IMPORTED_MODULE_2__.doPerf)(_self[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_GET_PERF_MGR /* @min:%2egetPerfMgr */](), function () { return "AppInsightsCore:track"; }, function () {
                    if (telemetryItem === null) {
                        _notifyInvalidEvent(telemetryItem);
                        // throw error
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)("Invalid telemetry item");
                    }
                    // do basic validation before sending it through the pipeline
                    if (!telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_NAME /* @min:%2ename */] && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isNullOrUndefined)(telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_NAME /* @min:%2ename */])) {
                        _notifyInvalidEvent(telemetryItem);
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)("telemetry name required");
                    }
                    // setup default iKey if not passed in
                    telemetryItem.iKey = telemetryItem.iKey || _instrumentationKey;
                    // add default timestamp if not passed in
                    telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_TIME /* @min:%2etime */] = telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_TIME /* @min:%2etime */] || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_13__.toISOString)(new Date());
                    // Common Schema 4.0
                    telemetryItem.ver = telemetryItem.ver || "4.0";
                    if (!_isUnloading && _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */]()) {
                        // Process the telemetry plugin chain
                        _createTelCtx()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](telemetryItem);
                    }
                    else {
                        // Queue events until all extensions are initialized
                        _eventQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](telemetryItem);
                    }
                }, function () { return ({ item: telemetryItem }); }, !(telemetryItem.sync));
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_PROCESS_TEL_CONT0 /* @min:%2egetProcessTelContext */] = _createTelCtx;
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_NOTIFY_MGR /* @min:%2egetNotifyMgr */] = function () {
                if (!_notificationManager) {
                    _notificationManager = new _NotificationManager__WEBPACK_IMPORTED_MODULE_14__.NotificationManager(_configHandler.cfg);
                    // For backward compatibility only
                    _self[strNotificationManager] = _notificationManager;
                }
                return _notificationManager;
            };
            /**
             * Adds a notification listener. The SDK calls methods on the listener when an appropriate notification is raised.
             * The added plugins must raise notifications. If the plugins do not implement the notifications, then no methods will be
             * called.
             * @param listener - An INotificationListener object.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ADD_NOTIFICATION_LIS1 /* @min:%2eaddNotificationListener */] = function (listener) {
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_NOTIFY_MGR /* @min:%2egetNotifyMgr */]()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ADD_NOTIFICATION_LIS1 /* @min:%2eaddNotificationListener */](listener);
            };
            /**
             * Removes all instances of the listener.
             * @param listener - INotificationListener to remove.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_REMOVE_NOTIFICATION_2 /* @min:%2eremoveNotificationListener */] = function (listener) {
                if (_notificationManager) {
                    _notificationManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_REMOVE_NOTIFICATION_2 /* @min:%2eremoveNotificationListener */](listener);
                }
            };
            _self.getCookieMgr = function () {
                if (!_cookieManager) {
                    _cookieManager = (0,_CookieMgr__WEBPACK_IMPORTED_MODULE_15__.createCookieMgr)(_configHandler.cfg, _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */]);
                }
                return _cookieManager;
            };
            _self.setCookieMgr = function (cookieMgr) {
                if (_cookieManager !== cookieMgr) {
                    (0,_AsyncUtils__WEBPACK_IMPORTED_MODULE_16__.runTargetUnload)(_cookieManager, false);
                    _cookieManager = cookieMgr;
                }
            };
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_GET_PERF_MGR /* @min:%2egetPerfMgr */] = function () {
                if (!_perfManager && !_cfgPerfManager) {
                    _addUnloadHook(_configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_WATCH /* @min:%2ewatch */](function (details) {
                        if (details.cfg.enablePerfMgr) {
                            var createPerfMgr = details.cfg[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CREATE_PERF_MGR /* @min:%2ecreatePerfMgr */];
                            if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isFunction)(createPerfMgr)) {
                                _cfgPerfManager = createPerfMgr(_self, _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_NOTIFY_MGR /* @min:%2egetNotifyMgr */]());
                            }
                        }
                    }));
                }
                return _perfManager || _cfgPerfManager || (0,_PerfManager__WEBPACK_IMPORTED_MODULE_2__.getGblPerfMgr)();
            };
            _self.setPerfMgr = function (perfMgr) {
                _perfManager = perfMgr;
            };
            _self.eventCnt = function () {
                return _eventQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */];
            };
            _self.releaseQueue = function () {
                if (_isInitialized && _eventQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    var eventQueue = _eventQueue;
                    _eventQueue = [];
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(eventQueue, function (event) {
                        _createTelCtx()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](event);
                    });
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_POLL_INTERNAL_LOGS /* @min:%2epollInternalLogs */] = function (eventName) {
                _internalLogsEventName = eventName || null;
                _forceStopInternalLogPoller = false;
                _internalLogPoller && _internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_CANCEL /* @min:%2ecancel */]();
                return _startLogPoller(true);
            };
            function _startLogPoller(alwaysStart) {
                if ((!_internalLogPoller || !_internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ENABLED /* @min:%2eenabled */]) && !_forceStopInternalLogPoller) {
                    var shouldStart = alwaysStart || (_logger && _logger.queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 0);
                    if (shouldStart) {
                        if (!_internalLogPollerListening) {
                            _internalLogPollerListening = true;
                            // listen for any configuration changes so that changes to the
                            // interval will cause the timer to be re-initialized
                            _addUnloadHook(_configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_WATCH /* @min:%2ewatch */](function (details) {
                                var interval = details.cfg.diagnosticLogInterval;
                                if (!interval || !(interval > 0)) {
                                    interval = 10000;
                                }
                                var isRunning = false;
                                if (_internalLogPoller) {
                                    // It was already created so remember it's running and cancel
                                    isRunning = _internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ENABLED /* @min:%2eenabled */];
                                    _internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_CANCEL /* @min:%2ecancel */]();
                                }
                                // Create / reconfigure
                                _internalLogPoller = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_17__.createTimeout)(_flushInternalLogs, interval);
                                _internalLogPoller.unref();
                                // Restart if previously running
                                _internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ENABLED /* @min:%2eenabled */] = isRunning;
                            }));
                        }
                        _internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ENABLED /* @min:%2eenabled */] = true;
                    }
                }
                return _internalLogPoller;
            }
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_STOP_POLLING_INTERNA3 /* @min:%2estopPollingInternalLogs */] = function () {
                _forceStopInternalLogPoller = true;
                _internalLogPoller && _internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_CANCEL /* @min:%2ecancel */]();
                _flushInternalLogs();
            };
            // Add addTelemetryInitializer
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_13__.proxyFunctions)(_self, function () { return _telemetryInitializerPlugin; }, ["addTelemetryInitializer"]);
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_UNLOAD /* @min:%2eunload */] = function (isAsync, unloadComplete, cbTimeout) {
                var _a;
                if (isAsync === void 0) { isAsync = true; }
                if (!_isInitialized) {
                    // The SDK is not initialized
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)(strSdkNotInitialized);
                }
                // Check if the SDK still unloading so throw
                if (_isUnloading) {
                    // The SDK is already unloading
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)(strSdkUnloadingError);
                }
                var unloadState = (_a = {
                        reason: 50 /* TelemetryUnloadReason.SdkUnload */
                    },
                    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IS_ASYNC /* @min:isAsync */] = isAsync,
                    _a.flushComplete = false,
                    _a);
                var result;
                if (isAsync && !unloadComplete) {
                    result = (0,_nevware21_ts_async__WEBPACK_IMPORTED_MODULE_18__.createPromise)(function (resolve) {
                        // Set the callback to the promise resolve callback
                        unloadComplete = resolve;
                    });
                }
                var processUnloadCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__.createProcessTelemetryUnloadContext)(_getPluginChain(), _self);
                processUnloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ON_COMPLETE /* @min:%2eonComplete */](function () {
                    _hookContainer.run(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */]);
                    // Run any "unload" functions for the _cookieManager, _notificationManager and _logger
                    (0,_AsyncUtils__WEBPACK_IMPORTED_MODULE_16__.doUnloadAll)([_cookieManager, _notificationManager, _logger], isAsync, function () {
                        _initDefaults();
                        unloadComplete && unloadComplete(unloadState);
                    });
                }, _self);
                function _doUnload(flushComplete) {
                    unloadState.flushComplete = flushComplete;
                    _isUnloading = true;
                    // Run all of the unload handlers first (before unloading the plugins)
                    _unloadHandlers.run(processUnloadCtx, unloadState);
                    // Stop polling the internal logs
                    _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_STOP_POLLING_INTERNA3 /* @min:%2estopPollingInternalLogs */]();
                    // Start unloading the components, from this point onwards the SDK should be considered to be in an unstable state
                    processUnloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](unloadState);
                }
                _flushInternalLogs();
                if (!_flushChannels(isAsync, _doUnload, 6 /* SendRequestReason.SdkUnload */, cbTimeout)) {
                    _doUnload(false);
                }
                return result;
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_PLUGIN /* @min:%2egetPlugin */] = _getPlugin;
            _self.addPlugin = function (plugin, replaceExisting, isAsync, addCb) {
                if (!plugin) {
                    addCb && addCb(false);
                    _logOrThrowError(strValidationError);
                    return;
                }
                var existingPlugin = _getPlugin(plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IDENTIFIER /* @min:%2eidentifier */]);
                if (existingPlugin && !replaceExisting) {
                    addCb && addCb(false);
                    _logOrThrowError("Plugin [" + plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IDENTIFIER /* @min:%2eidentifier */] + "] is already loaded!");
                    return;
                }
                var updateState = {
                    reason: 16 /* TelemetryUpdateReason.PluginAdded */
                };
                function _addPlugin(removed) {
                    _configExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](plugin);
                    updateState.added = [plugin];
                    // Re-Initialize the plugin chain
                    _initPluginChain(updateState);
                    addCb && addCb(true);
                }
                if (existingPlugin) {
                    var removedPlugins_1 = [existingPlugin.plugin];
                    var unloadState = {
                        reason: 2 /* TelemetryUnloadReason.PluginReplace */,
                        isAsync: !!isAsync
                    };
                    _removePlugins(removedPlugins_1, unloadState, function (removed) {
                        if (!removed) {
                            // Previous plugin was successfully removed or was not installed
                            addCb && addCb(false);
                        }
                        else {
                            updateState.removed = removedPlugins_1;
                            updateState.reason |= 32 /* TelemetryUpdateReason.PluginRemoved */;
                            _addPlugin(true);
                        }
                    });
                }
                else {
                    _addPlugin(false);
                }
            };
            _self.updateCfg = function (newConfig, mergeExisting) {
                if (mergeExisting === void 0) { mergeExisting = true; }
                var updateState;
                if (_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */]()) {
                    updateState = {
                        reason: 1 /* TelemetryUpdateReason.ConfigurationChanged */,
                        cfg: _configHandler.cfg,
                        oldCfg: (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_20__.deepExtend)({}, _configHandler.cfg),
                        newConfig: (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_20__.deepExtend)({}, newConfig),
                        merge: mergeExisting
                    };
                    newConfig = updateState.newConfig;
                    var cfg = _configHandler.cfg;
                    // replace the immutable (if initialized) values
                    // We don't currently allow updating the extensions and channels via the update config
                    // So overwriting any user provided values to reuse the existing values
                    newConfig[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSIONS /* @min:%2eextensions */] = cfg[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSIONS /* @min:%2eextensions */];
                    newConfig[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS /* @min:%2echannels */] = cfg[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS /* @min:%2echannels */];
                }
                // Explicitly blocking any previous config watchers so that they don't get called because
                // of this bulk update (Probably not necessary)
                _configHandler._block(function (details) {
                    // Lets assign the new values to the existing config either overwriting or re-assigning
                    var theConfig = details.cfg;
                    _deepMergeConfig(details, theConfig, newConfig, mergeExisting);
                    if (!mergeExisting) {
                        // Remove (unassign) the values "missing" from the newConfig and also not in the default config
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__.objForEachKey)(theConfig, function (key) {
                            if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_21__.objHasOwn)(newConfig, key)) {
                                // Set the value to undefined
                                details.set(theConfig, key, _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE);
                            }
                        });
                    }
                    // Apply defaults to the new config
                    details[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_SET_DF /* @min:%2esetDf */](theConfig, defaultConfig);
                }, true);
                // Now execute all of the listeners (synchronously) so they update their values immediately
                _configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_NOTIFY /* @min:%2enotify */]();
                if (updateState) {
                    _doUpdate(updateState);
                }
            };
            _self.evtNamespace = function () {
                return _evtNamespace;
            };
            _self.flush = _flushChannels;
            _self.getTraceCtx = function (createNew) {
                if (!_traceCtx) {
                    _traceCtx = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__.createDistributedTraceContext)();
                }
                return _traceCtx;
            };
            _self.setTraceCtx = function (traceCtx) {
                _traceCtx = traceCtx || null;
            };
            _self.addUnloadHook = _addUnloadHook;
            // Create the addUnloadCb
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_13__.proxyFunctionAs)(_self, "addUnloadCb", function () { return _unloadHandlers; }, "add");
            _self.onCfgChange = function (handler) {
                var unloadHook;
                if (!_isInitialized) {
                    unloadHook = _addDelayedCfgListener(_cfgListeners, handler);
                }
                else {
                    unloadHook = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_10__.onConfigChange)(_configHandler.cfg, handler, _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */]);
                }
                return {
                    rm: function () {
                        unloadHook.rm();
                    }
                };
            };
            _self.getWParam = function () {
                return ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_23__.hasDocument)() || !!_configHandler.cfg.enableWParam) ? 0 : -1;
            };
            function _setPluginVersions() {
                var thePlugins = {};
                _pluginVersionStringArr = [];
                var _addPluginVersions = function (plugins) {
                    if (plugins) {
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(plugins, function (plugin) {
                            if (plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IDENTIFIER /* @min:%2eidentifier */] && plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_VERSION /* @min:%2eversion */] && !thePlugins[plugin.identifier]) {
                                var ver = plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IDENTIFIER /* @min:%2eidentifier */] + "=" + plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_VERSION /* @min:%2eversion */];
                                _pluginVersionStringArr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](ver);
                                thePlugins[plugin.identifier] = plugin;
                            }
                        });
                    }
                };
                _addPluginVersions(_channels);
                if (_channelConfig) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(_channelConfig, function (channels) {
                        _addPluginVersions(channels);
                    });
                }
                _addPluginVersions(_configExtensions);
            }
            function _initDefaults() {
                _isInitialized = false;
                // Use a default logger so initialization errors are not dropped on the floor with full logging
                _configHandler = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_10__.createDynamicConfig)({}, defaultConfig, _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */]);
                // Set the logging level to critical so that any critical initialization failures are displayed on the console
                _configHandler.cfg[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGING_LEVEL_CONSOL4 /* @min:%2eloggingLevelConsole */] = 1 /* eLoggingSeverity.CRITICAL */;
                // Define _self.config
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_24__.objDefine)(_self, "config", {
                    g: function () { return _configHandler.cfg; },
                    s: function (newValue) {
                        _self.updateCfg(newValue, false);
                    }
                });
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_24__.objDefine)(_self, "pluginVersionStringArr", {
                    g: function () {
                        if (!_pluginVersionStringArr) {
                            _setPluginVersions();
                        }
                        return _pluginVersionStringArr;
                    }
                });
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_24__.objDefine)(_self, "pluginVersionString", {
                    g: function () {
                        if (!_pluginVersionString) {
                            if (!_pluginVersionStringArr) {
                                _setPluginVersions();
                            }
                            _pluginVersionString = _pluginVersionStringArr.join(";");
                        }
                        return _pluginVersionString || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
                    }
                });
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_24__.objDefine)(_self, "logger", {
                    g: function () {
                        if (!_logger) {
                            _logger = new _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__.DiagnosticLogger(_configHandler.cfg);
                            _configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */] = _logger;
                        }
                        return _logger;
                    },
                    s: function (newLogger) {
                        _configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */] = newLogger;
                        if (_logger !== newLogger) {
                            (0,_AsyncUtils__WEBPACK_IMPORTED_MODULE_16__.runTargetUnload)(_logger, false);
                            _logger = newLogger;
                        }
                    }
                });
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */] = new _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__.DiagnosticLogger(_configHandler.cfg);
                _extensions = [];
                var cfgExtensions = _self.config[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSIONS /* @min:%2eextensions */] || [];
                cfgExtensions.splice(0, cfgExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */]);
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_25__.arrAppend)(cfgExtensions, _extensions);
                _telemetryInitializerPlugin = new _TelemetryInitializerPlugin__WEBPACK_IMPORTED_MODULE_26__.TelemetryInitializerPlugin();
                _eventQueue = [];
                (0,_AsyncUtils__WEBPACK_IMPORTED_MODULE_16__.runTargetUnload)(_notificationManager, false);
                _notificationManager = null;
                _perfManager = null;
                _cfgPerfManager = null;
                (0,_AsyncUtils__WEBPACK_IMPORTED_MODULE_16__.runTargetUnload)(_cookieManager, false);
                _cookieManager = null;
                _pluginChain = null;
                _configExtensions = [];
                _channelConfig = null;
                _channels = null;
                _isUnloading = false;
                _internalLogsEventName = null;
                _evtNamespace = (0,_DataCacheHelper__WEBPACK_IMPORTED_MODULE_27__.createUniqueNamespace)("AIBaseCore", true);
                _unloadHandlers = (0,_UnloadHandlerContainer__WEBPACK_IMPORTED_MODULE_28__.createUnloadHandlerContainer)();
                _traceCtx = null;
                _instrumentationKey = null;
                _hookContainer = (0,_UnloadHookContainer__WEBPACK_IMPORTED_MODULE_29__.createUnloadHookContainer)();
                _cfgListeners = [];
                _pluginVersionString = null;
                _pluginVersionStringArr = null;
                _forceStopInternalLogPoller = false;
            }
            function _createTelCtx() {
                var theCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__.createProcessTelemetryContext)(_getPluginChain(), _configHandler.cfg, _self);
                theCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ON_COMPLETE /* @min:%2eonComplete */](_startLogPoller);
                return theCtx;
            }
            // Initialize or Re-initialize the plugins
            function _initPluginChain(updateState) {
                // Extension validation
                var theExtensions = _validateExtensions(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */], _Constants__WEBPACK_IMPORTED_MODULE_30__.ChannelControllerPriority, _configExtensions);
                _pluginChain = null;
                _pluginVersionString = null;
                _pluginVersionStringArr = null;
                // Get the primary channel queue and include as part of the normal extensions
                _channels = (_channelConfig || [])[0] || [];
                // Add any channels provided in the extensions and sort them
                _channels = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__.sortPlugins)((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_25__.arrAppend)(_channels, theExtensions[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS /* @min:%2echannels */]));
                // Create an array of all extensions, including the _channels
                var allExtensions = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_25__.arrAppend)((0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__.sortPlugins)(theExtensions[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CORE /* @min:%2ecore */]), _channels);
                // Required to allow plugins to call core.getPlugin() during their own initialization
                _extensions = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objFreeze)(allExtensions);
                // This has a side effect of adding the extensions passed during initialization
                // into the config.extensions, so you can see all of the extensions loaded.
                // This will also get updated by the addPlugin() and remove plugin code.
                var cfgExtensions = _self.config[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSIONS /* @min:%2eextensions */] || [];
                cfgExtensions.splice(0, cfgExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */]);
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_25__.arrAppend)(cfgExtensions, _extensions);
                var rootCtx = _createTelCtx();
                // Initializing the channels first
                if (_channels && _channels[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__.initializePlugins)(rootCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_CREATE_NEW /* @min:%2ecreateNew */](_channels), allExtensions);
                }
                // Now initialize the normal extensions (explicitly not including the _channels as this can cause duplicate initialization)
                (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__.initializePlugins)(rootCtx, allExtensions);
                if (updateState) {
                    _doUpdate(updateState);
                }
            }
            function _getPlugin(pluginIdentifier) {
                var theExt = null;
                var thePlugin = null;
                var channelHosts = [];
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(_extensions, function (ext) {
                    if (ext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IDENTIFIER /* @min:%2eidentifier */] === pluginIdentifier && ext !== _telemetryInitializerPlugin) {
                        thePlugin = ext;
                        return -1;
                    }
                    if (ext.getChannel) {
                        channelHosts[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](ext);
                    }
                });
                if (!thePlugin && channelHosts[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(channelHosts, function (host) {
                        thePlugin = host.getChannel(pluginIdentifier);
                        if (!thePlugin) {
                            return -1;
                        }
                    });
                }
                if (thePlugin) {
                    theExt = {
                        plugin: thePlugin,
                        setEnabled: function (enabled) {
                            (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__._getPluginState)(thePlugin)[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_DISABLED] = !enabled;
                        },
                        isEnabled: function () {
                            var pluginState = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__._getPluginState)(thePlugin);
                            return !pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_TEARDOWN /* @min:%2eteardown */] && !pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_DISABLED];
                        },
                        remove: function (isAsync, removeCb) {
                            var _a;
                            if (isAsync === void 0) { isAsync = true; }
                            var pluginsToRemove = [thePlugin];
                            var unloadState = (_a = {
                                    reason: 1 /* TelemetryUnloadReason.PluginUnload */
                                },
                                _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IS_ASYNC /* @min:isAsync */] = isAsync,
                                _a);
                            _removePlugins(pluginsToRemove, unloadState, function (removed) {
                                if (removed) {
                                    // Re-Initialize the plugin chain
                                    _initPluginChain({
                                        reason: 32 /* TelemetryUpdateReason.PluginRemoved */,
                                        removed: pluginsToRemove
                                    });
                                }
                                removeCb && removeCb(removed);
                            });
                        }
                    };
                }
                return theExt;
            }
            function _getPluginChain() {
                if (!_pluginChain) {
                    // copy the collection of extensions
                    var extensions = (_extensions || []).slice();
                    // During add / remove this may get called again, so don't read if already present
                    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_31__.arrIndexOf)(extensions, _telemetryInitializerPlugin) === -1) {
                        extensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](_telemetryInitializerPlugin);
                    }
                    _pluginChain = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__.createTelemetryProxyChain)((0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__.sortPlugins)(extensions), _configHandler.cfg, _self);
                }
                return _pluginChain;
            }
            function _removePlugins(thePlugins, unloadState, removeComplete) {
                if (thePlugins && thePlugins[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    var unloadChain = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__.createTelemetryProxyChain)(thePlugins, _configHandler.cfg, _self);
                    var unloadCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__.createProcessTelemetryUnloadContext)(unloadChain, _self);
                    unloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ON_COMPLETE /* @min:%2eonComplete */](function () {
                        var removed = false;
                        // Remove the listed config extensions
                        var newConfigExtensions = [];
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(_configExtensions, function (plugin, idx) {
                            if (!_isPluginPresent(plugin, thePlugins)) {
                                newConfigExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](plugin);
                            }
                            else {
                                removed = true;
                            }
                        });
                        _configExtensions = newConfigExtensions;
                        _pluginVersionString = null;
                        _pluginVersionStringArr = null;
                        // Re-Create the channel config
                        var newChannelConfig = [];
                        if (_channelConfig) {
                            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(_channelConfig, function (queue, idx) {
                                var newQueue = [];
                                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(queue, function (channel) {
                                    if (!_isPluginPresent(channel, thePlugins)) {
                                        newQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](channel);
                                    }
                                    else {
                                        removed = true;
                                    }
                                });
                                newChannelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](newQueue);
                            });
                            _channelConfig = newChannelConfig;
                        }
                        removeComplete && removeComplete(removed);
                        _startLogPoller();
                    });
                    unloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](unloadState);
                }
                else {
                    removeComplete(false);
                }
            }
            function _flushInternalLogs() {
                if (_logger && _logger.queue) {
                    var queue = _logger.queue.slice(0);
                    _logger.queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] = 0;
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(queue, function (logMessage) {
                        var _a;
                        var item = (_a = {},
                            _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_NAME /* @min:name */] = _internalLogsEventName ? _internalLogsEventName : "InternalMessageId: " + logMessage[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_MESSAGE_ID /* @min:%2emessageId */],
                            _a.iKey = _instrumentationKey,
                            _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_TIME /* @min:time */] = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_13__.toISOString)(new Date()),
                            _a.baseType = _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__._InternalLogMessage.dataType,
                            _a.baseData = { message: logMessage[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_MESSAGE /* @min:%2emessage */] },
                            _a);
                        _self.track(item);
                    });
                }
            }
            function _flushChannels(isAsync, callBack, sendReason, cbTimeout) {
                // Setting waiting to one so that we don't call the callBack until we finish iterating
                var waiting = 1;
                var doneIterating = false;
                var cbTimer = null;
                cbTimeout = cbTimeout || 5000;
                function doCallback() {
                    waiting--;
                    if (doneIterating && waiting === 0) {
                        cbTimer && cbTimer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_CANCEL /* @min:%2ecancel */]();
                        cbTimer = null;
                        callBack && callBack(doneIterating);
                        callBack = null;
                    }
                }
                if (_channels && _channels[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    var flushCtx = _createTelCtx()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_CREATE_NEW /* @min:%2ecreateNew */](_channels);
                    flushCtx.iterate(function (plugin) {
                        if (plugin.flush) {
                            waiting++;
                            var handled_1 = false;
                            // Not all channels will call this callback for every scenario
                            if (!plugin.flush(isAsync, function () {
                                handled_1 = true;
                                doCallback();
                            }, sendReason)) {
                                if (!handled_1) {
                                    // If any channel doesn't return true and it didn't call the callback, then we should assume that the callback
                                    // will never be called, so use a timeout to allow the channel(s) some time to "finish" before triggering any
                                    // followup function (such as unloading)
                                    if (isAsync && cbTimer == null) {
                                        cbTimer = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_17__.scheduleTimeout)(function () {
                                            cbTimer = null;
                                            doCallback();
                                        }, cbTimeout);
                                    }
                                    else {
                                        doCallback();
                                    }
                                }
                            }
                        }
                    });
                }
                doneIterating = true;
                doCallback();
                return true;
            }
            function _initDebugListener() {
                // Lazily ensure that the notification manager is created
                !_notificationManager && _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_NOTIFY_MGR /* @min:%2egetNotifyMgr */]();
                // Will get recalled if any referenced config values are changed
                _addUnloadHook(_configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_WATCH /* @min:%2ewatch */](function (details) {
                    var disableDbgExt = details.cfg.disableDbgExt;
                    if (disableDbgExt === true && _debugListener) {
                        // Remove any previously loaded debug listener
                        _notificationManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_REMOVE_NOTIFICATION_2 /* @min:%2eremoveNotificationListener */](_debugListener);
                        _debugListener = null;
                    }
                    if (_notificationManager && !_debugListener && disableDbgExt !== true) {
                        _debugListener = (0,_DbgExtensionUtils__WEBPACK_IMPORTED_MODULE_32__.getDebugListener)(details.cfg);
                        _notificationManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ADD_NOTIFICATION_LIS1 /* @min:%2eaddNotificationListener */](_debugListener);
                    }
                }));
            }
            function _initPerfManager() {
                // Will get recalled if any referenced config values are changed
                _addUnloadHook(_configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_WATCH /* @min:%2ewatch */](function (details) {
                    var enablePerfMgr = details.cfg.enablePerfMgr;
                    if (!enablePerfMgr && _cfgPerfManager) {
                        // Remove any existing config based performance manager
                        _cfgPerfManager = null;
                    }
                    if (enablePerfMgr) {
                        // Set the performance manager creation function if not defined
                        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_13__.getSetValue)(details.cfg, _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CREATE_PERF_MGR, _createPerfManager);
                    }
                }));
            }
            function _doUpdate(updateState) {
                var updateCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__.createProcessTelemetryUpdateContext)(_getPluginChain(), _self);
                updateCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ON_COMPLETE /* @min:%2eonComplete */](_startLogPoller);
                if (!_self._updateHook || _self._updateHook(updateCtx, updateState) !== true) {
                    updateCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](updateState);
                }
            }
            function _logOrThrowError(message) {
                var logger = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */];
                if (logger) {
                    // there should always be a logger
                    (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 73 /* _eInternalMessageId.PluginException */, message);
                    _startLogPoller();
                }
                else {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)(message);
                }
            }
            function _notifyInvalidEvent(telemetryItem) {
                var manager = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_NOTIFY_MGR /* @min:%2egetNotifyMgr */]();
                if (manager) {
                    manager[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EVENTS_DISCARDED /* @min:%2eeventsDiscarded */]([telemetryItem], 2 /* eEventsDiscardedReason.InvalidEvent */);
                }
            }
            function _addUnloadHook(hooks) {
                _hookContainer.add(hooks);
            }
        });
    }
// Removed Stub for AppInsightsCore.prototype.initialize.
// Removed Stub for AppInsightsCore.prototype.getChannels.
// Removed Stub for AppInsightsCore.prototype.track.
// Removed Stub for AppInsightsCore.prototype.getProcessTelContext.
// Removed Stub for AppInsightsCore.prototype.getNotifyMgr.
// Removed Stub for AppInsightsCore.prototype.addNotificationListener.
// Removed Stub for AppInsightsCore.prototype.removeNotificationListener.
// Removed Stub for AppInsightsCore.prototype.getCookieMgr.
// Removed Stub for AppInsightsCore.prototype.setCookieMgr.
// Removed Stub for AppInsightsCore.prototype.getPerfMgr.
// Removed Stub for AppInsightsCore.prototype.setPerfMgr.
// Removed Stub for AppInsightsCore.prototype.eventCnt.
// Removed Stub for AppInsightsCore.prototype.pollInternalLogs.
// Removed Stub for AppInsightsCore.prototype.stopPollingInternalLogs.
// Removed Stub for AppInsightsCore.prototype.addTelemetryInitializer.
// Removed Stub for AppInsightsCore.prototype.unload.
// Removed Stub for AppInsightsCore.prototype.getPlugin.
// Removed Stub for AppInsightsCore.prototype.addPlugin.
// Removed Stub for AppInsightsCore.prototype.updateCfg.
// Removed Stub for AppInsightsCore.prototype.evtNamespace.
// Removed Stub for AppInsightsCore.prototype.addUnloadCb.
// Removed Stub for AppInsightsCore.prototype.flush.
// Removed Stub for AppInsightsCore.prototype.getTraceCtx.
// Removed Stub for AppInsightsCore.prototype.setTraceCtx.
// Removed Stub for AppInsightsCore.prototype.addUnloadHook.
// Removed Stub for AppInsightsCore.prototype.onCfgChange.
// Removed Stub for AppInsightsCore.prototype.releaseQueue.
// Removed Stub for AppInsightsCore.prototype._updateHook.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    AppInsightsCore.__ieDyn=1;

    return AppInsightsCore;
}());

//# sourceMappingURL=AppInsightsCore.js.map

/***/ }),
/* 103 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PerfEvent": () => (/* binding */ PerfEvent),
/* harmony export */   "PerfManager": () => (/* binding */ PerfManager),
/* harmony export */   "doPerf": () => (/* binding */ doPerf),
/* harmony export */   "getGblPerfMgr": () => (/* binding */ getGblPerfMgr),
/* harmony export */   "setGblPerfMgr": () => (/* binding */ setGblPerfMgr)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(51);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(50);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(14);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(22);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(43);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






var strExecutionContextKey = "ctx";
var strParentContextKey = "ParentContextKey";
var strChildrenContextKey = "ChildrenContextKey";
var _defaultPerfManager = null;
var PerfEvent = /** @class */ (function () {
    function PerfEvent(name, payloadDetails, isAsync) {
        var _self = this;
        _self.start = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.utcNow)();
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:%2ename */] = name;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_ASYNC /* @min:%2eisAsync */] = isAsync;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_CHILD_EVT /* @min:%2eisChildEvt */] = function () { return false; };
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isFunction)(payloadDetails)) {
            // Create an accessor to minimize the potential performance impact of executing the payloadDetails callback
            var theDetails_1;
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.objDefine)(_self, "payload", {
                g: function () {
                    // Delay the execution of the payloadDetails until needed
                    if (!theDetails_1 && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isFunction)(payloadDetails)) {
                        theDetails_1 = payloadDetails();
                        // clear it out now so the referenced objects can be garbage collected
                        payloadDetails = null;
                    }
                    return theDetails_1;
                }
            });
        }
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */] = function (key) {
            if (key) {
                // The parent and child links are located directly on the object (for better viewing in the DebugPlugin)
                if (key === PerfEvent[strParentContextKey] || key === PerfEvent[strChildrenContextKey]) {
                    return _self[key];
                }
                return (_self[strExecutionContextKey] || {})[key];
            }
            return null;
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */] = function (key, value) {
            if (key) {
                // Put the parent and child links directly on the object (for better viewing in the DebugPlugin)
                if (key === PerfEvent[strParentContextKey]) {
                    // Simple assumption, if we are setting a parent then we must be a child
                    if (!_self[key]) {
                        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_CHILD_EVT /* @min:%2eisChildEvt */] = function () { return true; };
                    }
                    _self[key] = value;
                }
                else if (key === PerfEvent[strChildrenContextKey]) {
                    _self[key] = value;
                }
                else {
                    var ctx = _self[strExecutionContextKey] = _self[strExecutionContextKey] || {};
                    ctx[key] = value;
                }
            }
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COMPLETE /* @min:%2ecomplete */] = function () {
            var childTime = 0;
            var childEvts = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */](PerfEvent[strChildrenContextKey]);
            if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isArray)(childEvts)) {
                for (var lp = 0; lp < childEvts[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; lp++) {
                    var childEvt = childEvts[lp];
                    if (childEvt) {
                        childTime += childEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIME /* @min:%2etime */];
                    }
                }
            }
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIME /* @min:%2etime */] = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.utcNow)() - _self.start;
            _self.exTime = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIME /* @min:%2etime */] - childTime;
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COMPLETE /* @min:%2ecomplete */] = function () { };
        };
    }
    PerfEvent.ParentContextKey = "parent";
    PerfEvent.ChildrenContextKey = "childEvts";
    return PerfEvent;
}());

var PerfManager = /** @class */ (function () {
    function PerfManager(manager) {
        /**
         * General bucket used for execution context set and retrieved via setCtx() and getCtx.
         * Defined as private so it can be visualized via the DebugPlugin
         */
        this.ctx = {};
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__["default"])(PerfManager, this, function (_self) {
            _self.create = function (src, payloadDetails, isAsync) {
                // TODO (@MSNev): at some point we will want to add additional configuration to "select" which events to instrument
                // for now this is just a simple do everything.
                return new PerfEvent(src, payloadDetails, isAsync);
            };
            _self.fire = function (perfEvent) {
                if (perfEvent) {
                    perfEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COMPLETE /* @min:%2ecomplete */]();
                    if (manager && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isFunction)(manager[_InternalConstants__WEBPACK_IMPORTED_MODULE_5__.STR_PERF_EVENT /* @min:%2eperfEvent */])) {
                        manager[_InternalConstants__WEBPACK_IMPORTED_MODULE_5__.STR_PERF_EVENT /* @min:%2eperfEvent */](perfEvent);
                    }
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */] = function (key, value) {
                if (key) {
                    var ctx = _self[strExecutionContextKey] = _self[strExecutionContextKey] || {};
                    ctx[key] = value;
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */] = function (key) {
                return (_self[strExecutionContextKey] || {})[key];
            };
        });
    }
// Removed Stub for PerfManager.prototype.create.
// Removed Stub for PerfManager.prototype.fire.
// Removed Stub for PerfManager.prototype.setCtx.
// Removed Stub for PerfManager.prototype.getCtx.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    PerfManager.__ieDyn=1;

    return PerfManager;
}());

var doPerfActiveKey = "CoreUtils.doPerf";
/**
 * Helper function to wrap a function with a perf event
 * @param mgrSource - The Performance Manager or a Performance provider source (may be null)
 * @param getSource - The callback to create the source name for the event (if perf monitoring is enabled)
 * @param func - The function to call and measure
 * @param details - A function to return the payload details
 * @param isAsync - Is the event / function being call asynchronously or synchronously
 */
function doPerf(mgrSource, getSource, func, details, isAsync) {
    if (mgrSource) {
        var perfMgr = mgrSource;
        if (perfMgr[_InternalConstants__WEBPACK_IMPORTED_MODULE_5__.STR_GET_PERF_MGR]) {
            // Looks like a perf manager provider object
            perfMgr = perfMgr[_InternalConstants__WEBPACK_IMPORTED_MODULE_5__.STR_GET_PERF_MGR]();
        }
        if (perfMgr) {
            var perfEvt = void 0;
            var currentActive = perfMgr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */](doPerfActiveKey);
            try {
                perfEvt = perfMgr.create(getSource(), details, isAsync);
                if (perfEvt) {
                    if (currentActive && perfEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */]) {
                        perfEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */](PerfEvent[strParentContextKey], currentActive);
                        if (currentActive[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */] && currentActive[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */]) {
                            var children = currentActive[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */](PerfEvent[strChildrenContextKey]);
                            if (!children) {
                                children = [];
                                currentActive[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */](PerfEvent[strChildrenContextKey], children);
                            }
                            children[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](perfEvt);
                        }
                    }
                    // Set this event as the active event now
                    perfMgr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */](doPerfActiveKey, perfEvt);
                    return func(perfEvt);
                }
            }
            catch (ex) {
                if (perfEvt && perfEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */]) {
                    perfEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */]("exception", ex);
                }
            }
            finally {
                // fire the perf event
                if (perfEvt) {
                    perfMgr.fire(perfEvt);
                }
                // Reset the active event to the previous value
                perfMgr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */](doPerfActiveKey, currentActive);
            }
        }
    }
    return func();
}
/**
 * Set the global performance manager to use when there is no core instance or it has not been initialized yet.
 * @param perfManager - The IPerfManager instance to use when no performance manager is supplied.
 */
function setGblPerfMgr(perfManager) {
    _defaultPerfManager = perfManager;
}
/**
 * Get the current global performance manager that will be used with no performance manager is supplied.
 * @returns - The current default manager
 */
function getGblPerfMgr() {
    return _defaultPerfManager;
}
//# sourceMappingURL=PerfManager.js.map

/***/ }),
/* 104 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "NotificationManager": () => (/* binding */ NotificationManager)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(51);
/* harmony import */ var _nevware21_ts_async__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(105);
/* harmony import */ var _nevware21_ts_async__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(113);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(22);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8);
/* harmony import */ var _Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(52);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(42);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(43);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */








var defaultValues = {
    perfEvtsSendAll: false
};
function _runListeners(listeners, name, isAsync, callback) {
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(listeners, function (listener) {
        if (listener && listener[name]) {
            if (isAsync) {
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.scheduleTimeout)(function () { return callback(listener); }, 0);
            }
            else {
                try {
                    callback(listener);
                }
                catch (e) {
                    // Catch errors to ensure we don't block sending the requests
                }
            }
        }
    });
}
/**
 * Class to manage sending notifications to all the listeners.
 */
var NotificationManager = /** @class */ (function () {
    function NotificationManager(config) {
        this.listeners = [];
        var perfEvtsSendAll;
        var unloadHandler;
        var _listeners = [];
        var cfgHandler = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_2__.createDynamicConfig)(config, defaultValues);
        unloadHandler = cfgHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_WATCH /* @min:%2ewatch */](function (details) {
            perfEvtsSendAll = !!details.cfg.perfEvtsSendAll;
        });
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__["default"])(NotificationManager, this, function (_self) {
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objDefine)(_self, "listeners", {
                g: function () { return _listeners; }
            });
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_ADD_NOTIFICATION_LIS1 /* @min:%2eaddNotificationListener */] = function (listener) {
                _listeners[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_PUSH /* @min:%2epush */](listener);
            };
            /**
             * Removes all instances of the listener.
             * @param listener - AWTNotificationListener to remove.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_REMOVE_NOTIFICATION_2 /* @min:%2eremoveNotificationListener */] = function (listener) {
                var index = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.arrIndexOf)(_listeners, listener);
                while (index > -1) {
                    _listeners[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SPLICE /* @min:%2esplice */](index, 1);
                    index = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.arrIndexOf)(_listeners, listener);
                }
            };
            /**
             * Notification for events sent.
             * @param events - The array of events that have been sent.
             */
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_EVENTS_SENT /* @min:%2eeventsSent */] = function (events) {
                _runListeners(_listeners, _InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_EVENTS_SENT, true, function (listener) {
                    listener[_InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_EVENTS_SENT /* @min:%2eeventsSent */](events);
                });
            };
            /**
             * Notification for events being discarded.
             * @param events - The array of events that have been discarded by the SDK.
             * @param reason - The reason for which the SDK discarded the events. The EventsDiscardedReason
             * constant should be used to check the different values.
             */
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_EVENTS_DISCARDED /* @min:%2eeventsDiscarded */] = function (events, reason) {
                _runListeners(_listeners, _InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_EVENTS_DISCARDED, true, function (listener) {
                    listener[_InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_EVENTS_DISCARDED /* @min:%2eeventsDiscarded */](events, reason);
                });
            };
            /**
             * [Optional] A function called when the events have been requested to be sent to the sever.
             * @param sendReason - The reason why the event batch is being sent.
             * @param isAsync - A flag which identifies whether the requests are being sent in an async or sync manner.
             */
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_EVENTS_SEND_REQUEST /* @min:%2eeventsSendRequest */] = function (sendReason, isAsync) {
                _runListeners(_listeners, _InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_EVENTS_SEND_REQUEST, isAsync, function (listener) {
                    listener[_InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_EVENTS_SEND_REQUEST /* @min:%2eeventsSendRequest */](sendReason, isAsync);
                });
            };
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_PERF_EVENT /* @min:%2eperfEvent */] = function (perfEvent) {
                if (perfEvent) {
                    // Send all events or only parent events
                    if (perfEvtsSendAll || !perfEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_IS_CHILD_EVT /* @min:%2eisChildEvt */]()) {
                        _runListeners(_listeners, _InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_PERF_EVENT, false, function (listener) {
                            if (perfEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_IS_ASYNC /* @min:%2eisAsync */]) {
                                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.scheduleTimeout)(function () { return listener[_InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_PERF_EVENT /* @min:%2eperfEvent */](perfEvent); }, 0);
                            }
                            else {
                                listener[_InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_PERF_EVENT /* @min:%2eperfEvent */](perfEvent);
                            }
                        });
                    }
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_UNLOAD /* @min:%2eunload */] = function (isAsync) {
                var _finishUnload = function () {
                    unloadHandler && unloadHandler.rm();
                    unloadHandler = null;
                    _listeners = [];
                };
                var waiting;
                _runListeners(_listeners, "unload", false, function (listener) {
                    var asyncUnload = listener[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_UNLOAD /* @min:%2eunload */](isAsync);
                    if (asyncUnload) {
                        if (!waiting) {
                            waiting = [];
                        }
                        waiting[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_PUSH /* @min:%2epush */](asyncUnload);
                    }
                });
                if (waiting) {
                    return (0,_nevware21_ts_async__WEBPACK_IMPORTED_MODULE_8__.createPromise)(function (resolve) {
                        return (0,_nevware21_ts_async__WEBPACK_IMPORTED_MODULE_9__.doAwaitResponse)((0,_nevware21_ts_async__WEBPACK_IMPORTED_MODULE_8__.createAllPromise)(waiting), function () {
                            _finishUnload();
                            resolve();
                        });
                    });
                }
                else {
                    _finishUnload();
                }
            };
        });
    }
// Removed Stub for NotificationManager.prototype.addNotificationListener.
// Removed Stub for NotificationManager.prototype.removeNotificationListener.
// Removed Stub for NotificationManager.prototype.eventsSent.
// Removed Stub for NotificationManager.prototype.eventsDiscarded.
// Removed Stub for NotificationManager.prototype.eventsSendRequest.
// Removed Stub for NotificationManager.prototype.perfEvent.
// Removed Stub for NotificationManager.prototype.unload.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    NotificationManager.__ieDyn=1;

    return NotificationManager;
}());

//# sourceMappingURL=NotificationManager.js.map

/***/ }),
/* 105 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createAllPromise": () => (/* binding */ createAllPromise),
/* harmony export */   "createPromise": () => (/* binding */ createPromise),
/* harmony export */   "createRejectedPromise": () => (/* binding */ createRejectedPromise),
/* harmony export */   "createResolvedPromise": () => (/* binding */ createResolvedPromise),
/* harmony export */   "setCreatePromiseImpl": () => (/* binding */ setCreatePromiseImpl)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20);
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(109);
/* harmony import */ var _nativePromise__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(106);
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */



var _promiseCreator;
/**
 * Set the default promise implementation to use when calling `createPromise`; `createAllPromise`; `createResolvedPromise`
 * and `createRejectedPromise`. This is effective a global value and changing this will affect ALL callers of these
 * functions, as such these functions should only be used when switching implementations would have not unexpected
 * consequences like switching from a `createSyncPromise` to `createIdlePromise` where idle promises have a possibility
 * of never getting called during application shutdown or during an expected timeframe.
 * @group Alias
 * @group Promise
 * @param creator - The creator function to call when a new promise is required.
 */
function setCreatePromiseImpl(creator) {
    _promiseCreator = creator ? (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.getLazy)(function () { return creator; }) : null;
}
/**
 * Creates a Promise instance using the current default promise creator that when resolved or rejected will execute
 * it's pending chained operations.
 * @group Alias
 * @group Promise
 * @param executor - The function to be executed during the creation of the promise. Any errors thrown in the executor will
 * cause the promise to be rejected. The return value of the executor is always ignored
 * @param timeout - [Optional] timeout to wait before processing the items, defaults to zero.
 */
function createPromise(executor, timeout) {
    !_promiseCreator && (_promiseCreator = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.getLazy)(function () { return _nativePromise__WEBPACK_IMPORTED_MODULE_1__.createNativePromise; }));
    return _promiseCreator.v.call(this, executor, timeout);
}
/**
 * Returns a single asynchronous Promise instance that resolves to an array of the results from the input promises.
 * This returned promise will resolve and execute it's pending chained operations __asynchronously__ using the optional
 * provided timeout value to schedule when the chained items will be executed, or if the input contains no promises.
 * It rejects immediately upon any of the input promises rejected or non-promises throwing an error,
 * and will reject with this first rejection message / error.
 * If the runtime doesn't support the Promise.all it will fallback back to an asynchronous Promise implementation.
 * @group Alias
 * @group All
 * @param input - The array of promises to wait to be resolved / rejected before resolving or rejecting the new promise
 * @param timeout
 * @returns
 * <ul>
 * <li> An already resolved `Promise`, if the input passed is empty.
 * <li> A pending `Promise` in all other cases. This returned promise is then resolved/rejected __synchronously__
 * (as soon as the pending items is empty) when all the promises in the given input have resolved, or if any of the
 * promises reject.
 * </ul>
 */
var createAllPromise = (0,_base__WEBPACK_IMPORTED_MODULE_2__._createAllPromise)(createPromise);
/**
 * Returns a single asynchronous Promise instance that is already resolved with the given value. If the value passed is
 * a promise then that promise is returned instead of creating a new asynchronous promise instance.
 * If a new instance is returned then any chained operations will execute __asynchronously__ using the optional
 * timeout value to schedule when the chained items will be executed.(eg. `then()`; `finally()`).
 * @group Alias
 * @group Resolved
 * @param value - The value to be used by this `Promise`. Can also be a `Promise` or a thenable to resolve.
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 */
var createResolvedPromise = (0,_base__WEBPACK_IMPORTED_MODULE_2__._createResolvedPromise)(createPromise);
/**
 * Returns a single asynchronous Promise instance that is already rejected with the given reason.
 * Any chained operations will execute __asynchronously__ using the optional timeout value to schedule
 * when then chained items will be executed. (eg. `catch()`; `finally()`).
 * @group Alias
 * @group Rejected
 * @param reason - The rejection reason
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 */
var createRejectedPromise = (0,_base__WEBPACK_IMPORTED_MODULE_2__._createRejectedPromise)(createPromise);
//# sourceMappingURL=promise.js.map

/***/ }),
/* 106 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createNativeAllPromise": () => (/* binding */ createNativeAllPromise),
/* harmony export */   "createNativePromise": () => (/* binding */ createNativePromise),
/* harmony export */   "createNativeRejectedPromise": () => (/* binding */ createNativeRejectedPromise),
/* harmony export */   "createNativeResolvedPromise": () => (/* binding */ createNativeResolvedPromise)
/* harmony export */ });
/* harmony import */ var _asyncPromise__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(108);
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(109);
/* harmony import */ var _internal_state__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(110);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(22);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(107);
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */





var _isPromiseSupported;
/**
 * Creates a Promise instance that when resolved or rejected will execute it's pending chained operations using the
 * available native Promise implementation.
 * If runtime does not support native `Promise` class (or no polyfill is available) this function will fallback to using
 * `createAsyncPromise` which will resolve them __asynchronously__ using the optional provided timeout value to
 * schedule when the chained items will be executed.
 * @group Alias
 * @group Promise
 * @group Native
 * @param executor - The function to be executed during the creation of the promise. Any errors thrown in the executor will
 * cause the promise to be rejected. The return value of the executor is always ignored
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 */
function createNativePromise(executor, timeout) {
    !_isPromiseSupported && (_isPromiseSupported = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.lazySafeGetInst)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.STR_PROMISE));
    var PrmCls = _isPromiseSupported.v;
    if (!PrmCls) {
        return (0,_asyncPromise__WEBPACK_IMPORTED_MODULE_2__.createAsyncPromise)(executor);
    }
    if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isFunction)(executor)) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.throwTypeError)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.STR_PROMISE + ": executor is not a function - " + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.dumpObj)(executor));
    }
    var _state = 0 /* ePromiseState.Pending */;
    function _strState() {
        return _internal_state__WEBPACK_IMPORTED_MODULE_6__.STRING_STATES[_state];
    }
    var thePromise = new PrmCls(function (resolve, reject) {
        function _resolve(value) {
            _state = 2 /* ePromiseState.Resolved */;
            resolve(value);
        }
        function _reject(reason) {
            _state = 3 /* ePromiseState.Rejected */;
            reject(reason);
        }
        executor(_resolve, _reject);
    });
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.objDefineProp)(thePromise, "state", {
        get: _strState
    });
    return thePromise;
}
/**
 * Returns a single asynchronous Promise instance that resolves to an array of the results from the input promises.
 * This returned promise will resolve and execute it's pending chained operations __asynchronously__ using the optional
 * provided timeout value to schedule when the chained items will be executed, or if the input contains no promises.
 * It rejects immediately upon any of the input promises rejected or non-promises throwing an error,
 * and will reject with this first rejection message / error.
 * If the runtime doesn't support the Promise.all it will fallback back to an asynchronous Promise implementation.
 * @group Alias
 * @group All
 * @group Native
 * @param input - The array of promises to wait to be resolved / rejected before resolving or rejecting the new promise
 * @param timeout
 * @returns
 * <ul>
 * <li> An already resolved `Promise`, if the input passed is empty.
 * <li> A pending `Promise` in all other cases. This returned promise is then resolved/rejected __synchronously__
 * (as soon as the pending items is empty) when all the promises in the given input have resolved, or if any of the
 * promises reject.
 * </ul>
 */
var createNativeAllPromise = (0,_base__WEBPACK_IMPORTED_MODULE_8__._createAllPromise)(createNativePromise);
/**
 * Returns a single asynchronous Promise instance that is already resolved with the given value. If the value passed is
 * a promise then that promise is returned instead of creating a new asynchronous promise instance.
 * If a new instance is returned then any chained operations will execute __asynchronously__ using the optional
 * timeout value to schedule when the chained items will be executed.(eg. `then()`; `finally()`).
 * @group Alias
 * @group Resolved
 * @group Native
 * @param value - The value to be used by this `Promise`. Can also be a `Promise` or a thenable to resolve.
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 */
var createNativeResolvedPromise = (0,_base__WEBPACK_IMPORTED_MODULE_8__._createResolvedPromise)(createNativePromise);
/**
 * Returns a single asynchronous Promise instance that is already rejected with the given reason.
 * Any chained operations will execute __asynchronously__ using the optional timeout value to schedule
 * when then chained items will be executed. (eg. `catch()`; `finally()`).
 * @group Alias
 * @group Rejected
 * @group Native
 * @param reason - The rejection reason
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 */
var createNativeRejectedPromise = (0,_base__WEBPACK_IMPORTED_MODULE_8__._createRejectedPromise)(createNativePromise);
//# sourceMappingURL=nativePromise.js.map

/***/ }),
/* 107 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "STR_PROMISE": () => (/* binding */ STR_PROMISE)
/* harmony export */ });
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2023 Nevware21
 * Licensed under the MIT license.
 */
var STR_PROMISE = "Promise";
//# sourceMappingURL=constants.js.map

/***/ }),
/* 108 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createAsyncAllPromise": () => (/* binding */ createAsyncAllPromise),
/* harmony export */   "createAsyncPromise": () => (/* binding */ createAsyncPromise),
/* harmony export */   "createAsyncRejectedPromise": () => (/* binding */ createAsyncRejectedPromise),
/* harmony export */   "createAsyncResolvedPromise": () => (/* binding */ createAsyncResolvedPromise)
/* harmony export */ });
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(109);
/* harmony import */ var _itemProcessor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(114);
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * Creates an asynchronous Promise instance that when resolved or rejected will execute it's pending chained operations
 * __asynchronously__ using the optional provided timeout value to schedule when the chained items will be ececuted.
 * @group Async
 * @group Promise
 * @param executor - The function to be executed during the creation of the promise. Any errors thrown in the executor will
 * cause the promise to be rejected. The return value of the executor is always ignored
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 */
function createAsyncPromise(executor, timeout) {
    return (0,_base__WEBPACK_IMPORTED_MODULE_0__._createPromise)(createAsyncPromise, (0,_itemProcessor__WEBPACK_IMPORTED_MODULE_1__.timeoutItemProcessor)(timeout), executor, timeout);
}
/**
 * Returns a single asynchronous Promise instance that resolves to an array of the results from the input promises.
 * This returned promise will resolve and execute it's pending chained operations __asynchronously__ using the optional
 * provided timeout value to schedule when the chained items will be executed, or if the input contains no promises.
 * It rejects immediately upon any of the input promises rejected or non-promises throwing an error,
 * and will reject with this first rejection message / error.
 * When resolved or rejected any additional chained operations will execute __asynchronously__ using the optional
 * timeout value to schedul when the chained item will be executed (eg. `then()`; `catch()`; `finally()`).
 * @group Async
 * @group All
 * @param input - The array of promises to wait to be resolved / rejected before resolving or rejecting the new promise
 * @param timeout
 * @returns
 * <ul>
 * <li> An already resolved `Promise`, if the input passed is empty.
 * <li> A pending `Promise` in all other cases. This returned promise is then resolved/rejected __synchronously__
 * (as soon as the pending items is empty) when all the promises in the given input have resolved, or if any of the
 * promises reject.
 * </ul>
 */
var createAsyncAllPromise = (0,_base__WEBPACK_IMPORTED_MODULE_0__._createAllPromise)(createAsyncPromise);
// /**
//  * Creates a Promise that is resolved or rejected when any of the provided Promises are resolved
//  * or rejected.
//  * @param values An array of Promises.
//  * @returns A new Promise.
//  */
//     race<T extends readonly unknown[] | []>(values: T): Promise<Awaited<T[number]>>;
//export const createAsyncRacePromise: <T extends readonly unknown[] | []>(values: T): IPromise<T[number]>;
/**
 * Returns a single asynchronous Promise instance that is already resolved with the given value. If the value passed is
 * a promise then that promise is returned instead of creating a new asynchronous promise instance.
 * If a new instance is returned then any chained operations will execute __asynchronously__ using the optional
 * timeout value to schedule when the chained items will be executed.(eg. `then()`; `finally()`).
 * @group Async
 * @group Resolved
 * @param value - The value to be used by this `Promise`. Can also be a `Promise` or a thenable to resolve.
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 */
var createAsyncResolvedPromise = (0,_base__WEBPACK_IMPORTED_MODULE_0__._createResolvedPromise)(createAsyncPromise);
/**
 * Returns a single asynchronous Promise instance that is already rejected with the given reason.
 * Any chained operations will execute __asynchronously__ using the optional timeout value to schedule
 * when then chained items will be executed. (eg. `catch()`; `finally()`).
 * @group Async
 * @group Rejected
 * @param reason - The rejection reason
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 */
var createAsyncRejectedPromise = (0,_base__WEBPACK_IMPORTED_MODULE_0__._createRejectedPromise)(createAsyncPromise);
//# sourceMappingURL=asyncPromise.js.map

/***/ }),
/* 109 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_createAllPromise": () => (/* binding */ _createAllPromise),
/* harmony export */   "_createPromise": () => (/* binding */ _createPromise),
/* harmony export */   "_createRejectedPromise": () => (/* binding */ _createRejectedPromise),
/* harmony export */   "_createResolvedPromise": () => (/* binding */ _createResolvedPromise)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(68);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(18);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(69);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(22);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(54);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(11);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(28);
/* harmony import */ var _await__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(113);
/* harmony import */ var _debug__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(112);
/* harmony import */ var _internal_state__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(110);
/* harmony import */ var _event__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(111);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(107);
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */






var NODE_UNHANDLED_REJECTION = "unhandledRejection";
var UNHANDLED_REJECTION = NODE_UNHANDLED_REJECTION.toLowerCase();
var _currentPromiseId = [];
var _uniquePromiseId = 0;
var _unhandledRejectionTimeout = 10;
var _hasPromiseRejectionEvent;
function dumpFnObj(value) {
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isFunction)(value)) {
        return value.toString();
    }
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.dumpObj)(value);
}
function _createPromise(newPromise, processor, executor) {
    var additionalArgs = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.arrSlice)(arguments, 3);
    var _state = 0 /* ePromiseState.Pending */;
    var _hasResolved = false;
    var _settledValue;
    var _queue = [];
    var _id = _uniquePromiseId++;
    var _parentId = _currentPromiseId.length > 0 ? _currentPromiseId[_currentPromiseId.length - 1] : undefined;
    var _handled = false;
    var _unHandledRejectionHandler = null;
    var _thePromise;
    !_hasPromiseRejectionEvent && (_hasPromiseRejectionEvent = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.lazySafeGetInst)(_internal_constants__WEBPACK_IMPORTED_MODULE_4__.STR_PROMISE + "RejectionEvent"));
    // https://tc39.es/ecma262/#sec-promise.prototype.then
    var _then = function (onResolved, onRejected) {
        try {
            _currentPromiseId.push(_id);
            _handled = true;
            _unHandledRejectionHandler && _unHandledRejectionHandler.cancel();
            _unHandledRejectionHandler = null;
            //#ifdef DEBUG
            //#:(!DEBUG) _debugLog(_toString(), "then(" + dumpFnObj(onResolved)+ ", " + dumpFnObj(onResolved) +  ")");
            //#endif
            var thenPromise = newPromise(function (resolve, reject) {
                // Queue the new promise returned to be resolved or rejected
                // when this promise settles.
                _queue.push(function () {
                    // https://tc39.es/ecma262/#sec-newpromisereactionjob
                    //let value: any;
                    try {
                        // First call the onFulfilled or onRejected handler, on the settled value
                        // of this promise. If the corresponding `handler` does not exist, simply
                        // pass through the settled value.
                        //#ifdef DEBUG
                        //#:(!DEBUG) _debugLog(_toString(), "Handling settled value " + dumpFnObj(_settledValue));
                        //#endif
                        var handler = _state === 2 /* ePromiseState.Resolved */ ? onResolved : onRejected;
                        var value = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isUndefined)(handler) ? _settledValue : ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isFunction)(handler) ? handler(_settledValue) : handler);
                        //#ifdef DEBUG
                        //#:(!DEBUG) _debugLog(_toString(), "Handling Result " + dumpFnObj(value));
                        //#endif
                        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isPromiseLike)(value)) {
                            // The called handlers returned a new promise, so the chained promise
                            // will follow the state of this promise.
                            value.then(resolve, reject);
                        }
                        else if (handler) {
                            // If we have a handler then chained promises are always "resolved" with the result returned
                            resolve(value);
                        }
                        else if (_state === 3 /* ePromiseState.Rejected */) {
                            // If this promise is rejected then the chained promise should be rejected
                            // with either the settled value of this promise or the return value of the handler.
                            reject(value);
                        }
                        else {
                            // If this promise is fulfilled, then the chained promise is also fulfilled
                            // with either the settled value of this promise or the return value of the handler.
                            resolve(value);
                        }
                    }
                    catch (e) {
                        reject(e);
                    }
                });
                //#ifdef DEBUG
                //#:(!DEBUG) _debugLog(_toString(), "Added to Queue " + _queue.length);
                //#endif
                // If this promise is already settled, then immediately process the callback we
                // just added to the queue.
                if (_hasResolved) {
                    _processQueue();
                }
            }, additionalArgs);
            //#ifdef DEBUG
            //#:(!DEBUG) _debugLog(_toString(), "Created -> " + thenPromise.toString());
            //#endif
            return thenPromise;
        }
        finally {
            _currentPromiseId.pop();
        }
    };
    // https://tc39.es/ecma262/#sec-promise.prototype.catch
    var _catch = function (onRejected) {
        // Reuse then onRejected to support rejection
        return _then(undefined, onRejected);
    };
    // https://tc39.es/ecma262/#sec-promise.prototype.finally
    var _finally = function (onFinally) {
        var thenFinally = onFinally;
        var catchFinally = onFinally;
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isFunction)(onFinally)) {
            thenFinally = function (value) {
                onFinally && onFinally();
                return value;
            };
            catchFinally = function (reason) {
                onFinally && onFinally();
                throw reason;
            };
        }
        return _then(thenFinally, catchFinally);
    };
    var _strState = function () {
        return _internal_state__WEBPACK_IMPORTED_MODULE_5__.STRING_STATES[_state];
    };
    var _processQueue = function () {
        if (_queue.length > 0) {
            // The onFulfilled and onRejected handlers must be called asynchronously. Thus,
            // we make a copy of the queue and work on it once the current call stack unwinds.
            var pending = _queue.slice();
            _queue = [];
            //#ifdef DEBUG
            //#:(!DEBUG) _debugLog(_toString(), "Processing queue " + pending.length);
            //#endif
            _handled = true;
            processor(pending);
            //#ifdef DEBUG
            //#:(!DEBUG) _debugLog(_toString(), "Processing done");
            //#endif
            _unHandledRejectionHandler && _unHandledRejectionHandler.cancel();
            _unHandledRejectionHandler = null;
        }
        else {
            //#ifdef DEBUG
            //#:(!DEBUG) _debugLog(_toString(), "Empty Processing queue ");
            //#endif
        }
    };
    var _createSettleIfFn = function (newState, allowState) {
        return function (theValue) {
            if (_state === allowState) {
                if (newState === 2 /* ePromiseState.Resolved */ && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isPromiseLike)(theValue)) {
                    _state = 1 /* ePromiseState.Resolving */;
                    //#ifdef DEBUG
                    //#:(!DEBUG) _debugLog(_toString(), "Resolving");
                    //#endif
                    theValue.then(_createSettleIfFn(2 /* ePromiseState.Resolved */, 1 /* ePromiseState.Resolving */), _createSettleIfFn(3 /* ePromiseState.Rejected */, 1 /* ePromiseState.Resolving */));
                    return;
                }
                _state = newState;
                _hasResolved = true;
                _settledValue = theValue;
                //#ifdef DEBUG
                //#:(!DEBUG) _debugLog(_toString(), _strState());
                //#endif
                _processQueue();
                if (!_handled && newState === 3 /* ePromiseState.Rejected */ && !_unHandledRejectionHandler) {
                    _unHandledRejectionHandler = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.scheduleTimeout)(_notifyUnhandledRejection, _unhandledRejectionTimeout);
                }
            }
            else {
                //#ifdef DEBUG
                //#:(!DEBUG) _debugLog(_toString(), "Already " + _strState());
                //#endif
            }
        };
    };
    var _notifyUnhandledRejection = function () {
        if (!_handled) {
            if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isNode)()) {
                //#ifdef DEBUG
                //#:(!DEBUG) _debugLog(_toString(), "Emitting " + NODE_UNHANDLED_REJECTION);
                //#endif
                process.emit(NODE_UNHANDLED_REJECTION, _settledValue, _thePromise);
            }
            else {
                var gbl = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.getWindow)() || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.getGlobal)();
                //#ifdef DEBUG
                //#:(!DEBUG) _debugLog(_toString(), "Emitting " + UNHANDLED_REJECTION);
                //#endif
                (0,_event__WEBPACK_IMPORTED_MODULE_7__.emitEvent)(gbl, UNHANDLED_REJECTION, function (theEvt) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__.objDefine)(theEvt, "promise", { g: function () { return _thePromise; } });
                    theEvt.reason = _settledValue;
                    return theEvt;
                }, !!_hasPromiseRejectionEvent.v);
            }
        }
    };
    _thePromise = {
        then: _then,
        "catch": _catch,
        finally: _finally
    };
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__.objDefineProp)(_thePromise, "state", {
        get: _strState
    });
    if (_debug__WEBPACK_IMPORTED_MODULE_9__._promiseDebugEnabled) {
        // eslint-disable-next-line brace-style
        (0,_debug__WEBPACK_IMPORTED_MODULE_9__._addDebugState)(_thePromise, _strState, function () { return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objToString)(_settledValue); }, function () { return _handled; });
    }
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__.hasSymbol)()) {
        _thePromise[(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__.getKnownSymbol)(11 /* WellKnownSymbols.toStringTag */)] = "IPromise";
    }
    var _toString = function () {
        return "IPromise" + (_debug__WEBPACK_IMPORTED_MODULE_9__._promiseDebugEnabled ? "[" + _id + (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isUndefined)(_parentId) ? (":" + _parentId) : "") + "]" : "") + " " + _strState() + (_hasResolved ? (" - " + dumpFnObj(_settledValue)) : "");
    };
    _thePromise.toString = _toString;
    (function _initialize() {
        if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isFunction)(executor)) {
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__.throwTypeError)(_internal_constants__WEBPACK_IMPORTED_MODULE_4__.STR_PROMISE + ": executor is not a function - " + dumpFnObj(executor));
        }
        var _rejectFn = _createSettleIfFn(3 /* ePromiseState.Rejected */, 0 /* ePromiseState.Pending */);
        try {
            //#ifdef DEBUG
            //#:(!DEBUG) _debugLog(_toString(), "Executing");
            //#endif
            executor.call(_thePromise, _createSettleIfFn(2 /* ePromiseState.Resolved */, 0 /* ePromiseState.Pending */), _rejectFn);
        }
        catch (e) {
            _rejectFn(e);
        }
    })();
    //#ifdef DEBUG
    //#:(!DEBUG) _debugLog(_toString(), "Returning");
    //#endif
    return _thePromise;
}
/**
 * @ignore
 * @internal
 * Returns a function which when called will return a new Promise object that resolves to an array of the
 * results from the input promises. The returned promise will resolve when all of the inputs' promises have
 * resolved, or if the input contains no promises. It rejects immediately upon any of the input promises
 * rejected or non-promises throwing an error, and will reject with this first rejection message / error.
 * @param newPromise - The delegate function used to create a new promise object the new promise instance.
 * @returns A function to create a promise that will be resolved when all arguments are resolved.
 */
function _createAllPromise(newPromise) {
    return function (input) {
        var additionalArgs = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.arrSlice)(arguments, 1);
        return newPromise(function (resolve, reject) {
            try {
                var values_1 = [];
                var pending_1 = 1; // Prefix to 1 so we finish iterating over all of the input promises first
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_12__.arrForEach)(input, function (item, idx) {
                    if (item) {
                        pending_1++;
                        (0,_await__WEBPACK_IMPORTED_MODULE_13__.doAwait)(item, function (value) {
                            // Set the result values
                            values_1[idx] = value;
                            if (--pending_1 === 0) {
                                resolve(values_1);
                            }
                        }, reject);
                    }
                });
                // Now decrement the pending so that we finish correctly
                pending_1--;
                if (pending_1 === 0) {
                    // All promises were either resolved or where not a promise
                    resolve(values_1);
                }
            }
            catch (e) {
                reject(e);
            }
        }, additionalArgs);
    };
}
/**
 * @ignore
 * @internal
 * The createResolvedPromise returns a PromiseLike object that is resolved with a given value. If the value is
 * PromiseLike (i.e. has a "then" method), the returned promise will "follow" that thenable, adopting its eventual
 * state; otherwise the returned promise will be fulfilled with the value. This function flattens nested layers
 * of promise-like objects (e.g. a promise that resolves to a promise that resolves to something) into a single layer.
 * @param newPromise - The delegate function used to create a new promise object
 * @param value Argument to be resolved by this Promise. Can also be a Promise or a thenable to resolve.
 * @param additionalArgs - Any additional arguments that should be passed to the delegate to assist with the creation of
 * the new promise instance.
 */
function _createResolvedPromise(newPromise) {
    return function (value) {
        var additionalArgs = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.arrSlice)(arguments, 1);
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isPromiseLike)(value)) {
            return value;
        }
        return newPromise(function (resolve) {
            resolve(value);
        }, additionalArgs);
    };
}
/**
 * @ignore
 * @internal
 * Return a promise like object that is rejected with the given reason.
 * @param newPromise - The delegate function used to create a new promise object
 * @param reason - The rejection reason
 * @param additionalArgs - Any additional arguments that should be passed to the delegate to assist with the creation of
 * the new promise instance.
 */
function _createRejectedPromise(newPromise) {
    return function (reason) {
        var additionalArgs = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.arrSlice)(arguments, 1);
        return newPromise(function (_resolve, reject) {
            reject(reason);
        }, additionalArgs);
    };
}
//# sourceMappingURL=base.js.map

/***/ }),
/* 110 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "STRING_STATES": () => (/* binding */ STRING_STATES)
/* harmony export */ });
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
/**
 * @ignore -- Don't include in the generated documentation
 * @internal
 */
var STRING_STATES = [
    "pending", "resolving", "resolved", "rejected"
];
//# sourceMappingURL=state.js.map

/***/ }),
/* 111 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "emitEvent": () => (/* binding */ emitEvent)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13);
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

var DISPATCH_EVENT = "dispatchEvent";
var _hasInitEvent;
/**
 * @internal
 * @ignore
 * @param target
 * @param evtName
 * @param populateEvent
 * @param useNewEvent
 */
function emitEvent(target, evtName, populateEvent, useNewEvent) {
    var doc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.getDocument)();
    !_hasInitEvent && (_hasInitEvent = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.safeGetLazy)(function () {
        var evt;
        if (doc && doc.createEvent) {
            evt = doc.createEvent("Event");
        }
        return (!!evt && evt.initEvent);
    }, null));
    var theEvt = _hasInitEvent.v ? doc.createEvent("Event") : (useNewEvent ? new Event(evtName) : {});
    populateEvent && populateEvent(theEvt);
    if (_hasInitEvent.v) {
        theEvt.initEvent(evtName, false, true);
    }
    if (theEvt && target[DISPATCH_EVENT]) {
        target[DISPATCH_EVENT](theEvt);
    }
    else {
        var handler = target["on" + evtName];
        if (handler) {
            handler(theEvt);
        }
        else {
            var theConsole = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.getInst)("console");
            theConsole && (theConsole["error"] || theConsole["log"])(evtName, (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.dumpObj)(theEvt));
        }
    }
}
//# sourceMappingURL=event.js.map

/***/ }),
/* 112 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_addDebugState": () => (/* binding */ _addDebugState),
/* harmony export */   "_debugLog": () => (/* binding */ _debugLog),
/* harmony export */   "_promiseDebugEnabled": () => (/* binding */ _promiseDebugEnabled),
/* harmony export */   "setPromiseDebugState": () => (/* binding */ setPromiseDebugState)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

var _debugState;
var _debugResult;
var _debugHandled;
/**
 * @internal
 * @ignore
 */
var _promiseDebugEnabled = false;
var _theLogger = null;
/**
 * @internal
 * @ignore Internal function enable logging the internal state of the promise during execution, this code and references are
 * removed from the production artifacts
 */
function _debugLog(id, message) {
    //#ifdef DEBUG
    //#:(!DEBUG) if (_theLogger) {
    //#:(!DEBUG)     _theLogger(id, message);
    //#:(!DEBUG) }
    //#endif
}
/**
 * @internal
 * @ignore
 * Internal function to add the debug state to the promise so that it provides simular visibility as you would
 * see from native promises
 * @param thePromise - The Promise implementation
 * @param stateFn - The function to return the state of the promise
 * @param resultFn - The function to return the result (settled value) of the promise
 * @param handledFn - The function to return whether the promise has been handled (used for throwing
 * unhandled rejection events)
 */
function _addDebugState(thePromise, stateFn, resultFn, handledFn) {
    // While the IPromise implementations provide a `state` property, keeping the `[[PromiseState]]`
    // as native promises also have a non-enumerable property of the same name
    _debugState = _debugState || { toString: function () { return "[[PromiseState]]"; } };
    _debugResult = _debugResult || { toString: function () { return "[[PromiseResult]]"; } };
    _debugHandled = _debugHandled || { toString: function () { return "[[PromiseIsHandled]]"; } };
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objDefineProp)(thePromise, _debugState, { get: stateFn });
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objDefineProp)(thePromise, _debugResult, { get: resultFn });
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objDefineProp)(thePromise, _debugHandled, { get: handledFn });
}
/**
 * Debug helper to enable internal debugging of the promise implementations. Disabled by default.
 * For the generated packages included in the npm package the `logger` will not be called as the
 * `_debugLog` function that uses this logger is removed during packaging.
 *
 * It is available directly from the repository for unit testing.
 *
 * @group Debug
 * @param enabled - Should debugging be enabled (defaults `false`, when `true` promises will have
 * additional debug properties and the `toString` will include extra details.
 * @param logger - Optional logger that will log internal state changes, only called in debug
 * builds as the calling function is removed is the production artifacts.
 * @example
 * ```ts
 * // The Id is the id of the promise
 * // The message is the internal debug message
 * function promiseDebugLogger(id: string, message: string) {
 *     if (console && console.log) {
 *         console.log(id, message);
 *     }
 * }
 *
 * setPromiseDebugState(true, promiseDebugLogger);
 *
 * // While the logger will not be called for the production packages
 * // Setting the `enabled` flag to tru will cause each promise to have
 * // the following additional properties added
 * // [[PromiseState]]; => Same as the `state` property
 * // [[PromiseResult]]; => The settled value
 * // [[PromiseIsHandled]] => Identifies if the promise has been handled
 * // It will also cause the `toString` for the promise to include additional
 * // debugging information
 * ```
 */
function setPromiseDebugState(enabled, logger) {
    _promiseDebugEnabled = enabled;
    _theLogger = logger;
}
//# sourceMappingURL=debug.js.map

/***/ }),
/* 113 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "doAwait": () => (/* binding */ doAwait),
/* harmony export */   "doAwaitResponse": () => (/* binding */ doAwaitResponse),
/* harmony export */   "doFinally": () => (/* binding */ doFinally)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14);
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

function doAwaitResponse(value, cb) {
    return doAwait(value, function (value) {
        cb && cb({
            value: value,
            rejected: false
        });
    }, function (reason) {
        cb && cb({
            rejected: true,
            reason: reason
        });
    });
}
/**
 * Wait for the promise to resolve or reject, if resolved the callback function will be called with it's value and if
 * rejected the rejectFn will be called with the reason. If the passed promise argument is not a promise the callback
 * will be called synchronously with the value.
 * @group Await Helper
 * @param value - The value or promise like value to wait for
 * @param resolveFn - The callback to call on the promise successful resolving.
 * @param rejectFn - The callback to call when the promise rejects
 * @returns The passed value, if it is a promise and there is either a resolve or reject handler
 * then it will return a chained promise with the value from the resolve or reject handler (depending
 * whether it resolve or rejects)
 * @example
 * ```ts
 * let promise = createPromise<number>((resolve, reject) => {
 *     resolve(42);
 * });
 *
 * // Handle via a chained promise
 * let chainedPromise = promise.then((value) => {
 *     // Do something with the value
 * });
 *
 * // Handle via doAwait
 * doAwait(promise, (value) => {
 *     // Do something with the value
 * });
 *
 * // It can also handle the raw value, so you could process the result of either a
 * // synchrounous return of the value or a Promise
 * doAwait(42, (value) => {
 *     // Do something with the value
 * });
 * ```
 */
function doAwait(value, resolveFn, rejectFn, finallyFn) {
    var result = value;
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isPromiseLike)(value)) {
        if (resolveFn || rejectFn) {
            result = value.then(resolveFn, rejectFn);
        }
    }
    else {
        resolveFn && resolveFn(value);
    }
    if (finallyFn) {
        result = doFinally(result, finallyFn);
    }
    return result;
}
/**
 * Wait for the promise to resolve or reject and then call the finallyFn. If the passed promise argument is not a promise the callback
 * will be called synchronously with the value. If the passed promise doesn't implement finally then a finally implementation will be
 * simulated using then(..., ...).
 * @group Await Helper
 * @param value - The value or promise like value to wait for
 * @param finallyFn - The finally function to call once the promise has resolved or rejected
 */
function doFinally(value, finallyFn) {
    var result = value;
    if (finallyFn) {
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isPromiseLike)(value)) {
            if (value.finally) {
                result = value.finally(finallyFn);
            }
            else {
                // Simulate finally if not available
                result = value.then(function (value) {
                    finallyFn();
                    return value;
                }, function (reason) {
                    finallyFn();
                    throw reason;
                });
            }
        }
        else {
            finallyFn();
        }
    }
    return result;
}
//# sourceMappingURL=await.js.map

/***/ }),
/* 114 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "idleItemProcessor": () => (/* binding */ idleItemProcessor),
/* harmony export */   "syncItemProcessor": () => (/* binding */ syncItemProcessor),
/* harmony export */   "timeoutItemProcessor": () => (/* binding */ timeoutItemProcessor)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(115);
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

var _processPendingItems = function (pending) {
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(pending, function (fn) {
        try {
            fn();
        }
        catch (e) {
            // Don't let 1 failing handler break all others
            // TODO: Add some form of error reporting (i.e. Call any registered JS error handler so the error is reported)
        }
    });
};
/**
 * @internal
 * @ignore
 * Return an item processor that processes all of the pending items synchronously
 * @return An item processor
 */
function syncItemProcessor() {
    return _processPendingItems;
}
/**
 * @internal
 * @ignore
 * Return an item processor that processes all of the pending items asynchronously using the optional timeout.
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 * @return An item processor
 */
function timeoutItemProcessor(timeout) {
    var callbackTimeout = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.isNumber)(timeout) ? timeout : 0;
    return function (pending) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.scheduleTimeout)(function () {
            _processPendingItems(pending);
        }, callbackTimeout);
    };
}
/**
 * @internal
 * @ignore
 * Return an item processor that processes all of the pending items using an idle callback (if available) or based on
 * a timeout (when `requestIdenCallback` is not supported) using the optional timeout.
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 * @return An item processor
 */
function idleItemProcessor(timeout) {
    var options;
    if (timeout >= 0) {
        options = {
            timeout: +timeout
        };
    }
    return function (pending) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.scheduleIdleCallback)(function (deadline) {
            _processPendingItems(pending);
        }, options);
    };
}
//# sourceMappingURL=itemProcessor.js.map

/***/ }),
/* 115 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "hasIdleCallback": () => (/* binding */ hasIdleCallback),
/* harmony export */   "scheduleIdleCallback": () => (/* binding */ scheduleIdleCallback),
/* harmony export */   "setDefaultIdleTimeout": () => (/* binding */ setDefaultIdleTimeout),
/* harmony export */   "setDefaultMaxExecutionTime": () => (/* binding */ setDefaultMaxExecutionTime)
/* harmony export */ });
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14);
/* harmony import */ var _helpers_perf__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(49);
/* harmony import */ var _helpers_safe_lazy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19);
/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(70);
/* harmony import */ var _timeout__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(69);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */





var _hasIdleCallback;
var _defaultIdleTimeout = 100;
var _maxExecutionTime = 50;
/**
 * Identifies if the runtime supports the `requestIdleCallback` API.
 *
 * @since 0.4.4
 * @group Timer
 * @group Environment
 *
 * @returns True if the runtime supports `requestIdleCallback` otherwise false.
 * @example
 * ```ts
 * let nativeIdleTimeouts = hasIdleCallback();
 * // true === idle timeouts are supported by the runtime otherwise false and the {@linke scheduleIdleCallback}
 * will use `setTimeout` instead.
 * ```
 */
function hasIdleCallback() {
    !_hasIdleCallback && (_hasIdleCallback = (0,_helpers_safe_lazy__WEBPACK_IMPORTED_MODULE_0__.safeGetLazy)(function () { return (0,_helpers_base__WEBPACK_IMPORTED_MODULE_1__.isDefined)(requestIdleCallback); }, false));
    return !!(_hasIdleCallback.v ? requestIdleCallback : false);
}
/**
 * Set the idle timeout fallback timeout which is used when the runtime does not support `requestIdleCallback`
 * the default idle timeout will be used for the scheduled timer. Defaults to 100ms
 *
 * @since 0.4.4
 * @group Timer
 *
 * @param timeout - The time in milliseconds that the timer should wait before calling the idle function.
 */
function setDefaultIdleTimeout(timeout) {
    _defaultIdleTimeout = timeout;
}
/**
 * Set the idle timeout fallback simulated maximum execution time, used when the runtime doesn't
 * support `requestIdleTimeout` to simulate the [IdleDeadline](https://w3c.github.io/requestidlecallback/#dom-idledeadline)
 * `timeRemaining` value.
 * This value is used as the base time of the [IdleDeadline.timeRemaining](https://developer.mozilla.org/en-US/docs/Web/API/IdleDeadline/timeRemaining)
 * less the start time the callback was called. Defaults to 50ms.
 *
 * @since 0.4.4
 * @group Timer
 *
 * @param maxTime - The maximum execution time in milliseconds.
 */
function setDefaultMaxExecutionTime(maxTime) {
    _maxExecutionTime = maxTime;
}
/**
 * Queues a function to be called during a browser's idle periods. This enables developers to
 * perform background and low priority work on the main event loop, without impacting latency-critical
 * events such as animation and input response. Functions are generally called in first-in-first-out
 * order; however, callbacks which have a timeout specified may be called out-of-order if necessary
 * in order to run them before the timeout elapses.
 *
 * You can call scheduledleCallback() within an idle callback function to schedule another callback to
 * take place no sooner than the next pass through the event loop.
 *
 * If the runtime does not support the [requestIdleCallback](https://developer.mozilla.org/en-US/docs/Web/API/Window/requestIdleCallback)
 * it will fallback to use `setTimeout` with either the provided timeout or the current default idle
 * timeout, which can be set via {@link setDefaultIdleTimeout}. It will always supply a deadline which
 * indicates that the request timed out.
 *
 * @since 0.4.4
 * @group Timer
 *
 * @param callback - A reference to a function that should be called in the near future, when the
 * event loop is idle. The callback function is passed an [IdleDeadline](https://w3c.github.io/requestidlecallback/#dom-idledeadline)
 * object describing the amount of time available and whether or not the callback has been run because
 * the timeout period expired.
 * @param options - Contains optional configuration parameters. Currently only one property is defined:
 * `timeout` If the number of milliseconds represented by this parameter has elapsed and the callback
 * has not already been called, then a task to execute the callback is queued in the event loop (even
 * if doing so risks causing a negative performance impact). timeout must be a positive value or it
 * is ignored.
 * @returns A handle which can be used to cancel the callback by passing it into the `cancelIdleCallback()`
 * method.
 * @example
 * ```ts
 * let idleCalled = false;
 * let idleTimedOut = false;
 * let theIdleTimer = scheduleIdleCallback((idleDeadline: IdleDeadline) => {
 *     // This callback will be called when the system is idle (via requestIdleCallback) or after the provided timeout 100ms
 *     idleCalled = true;
 *     idleTimedOut = idleDeadline?.didTimeout;
 *     while ((idleDeadline.timeRemaining() > 0 || deadline.didTimeout)) {
 *         // Do some background operations while there is time remaining or we timed out
 *         // Unlike interval timers this callback will NOT be called again unless you call "refresh"
 *         // to restart it or create a new idle timer
 *     }
 * }, 100);
 *
 * // Instead of calling cancelIdleCallback() with the returned value from requestIdleCallback() the returned
 * // handler instance can be used instead to cancel the idle timer
 * theIdleTimer.cancel();
 * theIdleTimer.enabled;    // false
 *
 * // You can start the timer via enabled
 * theIdleTimer.enabled = true;
 *
 * // You can also "restart" the timer, whether it has previously triggered not not via the `refresh()`
 * theIdleTimer.refresh();
 * ```
 */
function scheduleIdleCallback(callback, options) {
    function _createDeadline(timedOut) {
        var startTime = (0,_helpers_perf__WEBPACK_IMPORTED_MODULE_2__.perfNow)();
        return {
            didTimeout: timedOut,
            timeRemaining: function () {
                return _maxExecutionTime - (0,_helpers_perf__WEBPACK_IMPORTED_MODULE_2__.elapsedTime)(startTime);
            }
        };
    }
    if (hasIdleCallback()) {
        var handler_1 = (0,_handler__WEBPACK_IMPORTED_MODULE_3__._createTimerHandler)(true, function (idleId) {
            idleId && cancelIdleCallback(idleId);
            return requestIdleCallback(function (deadline) {
                handler_1.dn();
                callback(deadline || _createDeadline(false));
            }, options);
        }, function (idleId) {
            cancelIdleCallback(idleId);
        });
        return handler_1.h;
    }
    var timeout = (options || {}).timeout;
    if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_1__.isUndefined)(timeout)) {
        timeout = _defaultIdleTimeout;
    }
    return (0,_timeout__WEBPACK_IMPORTED_MODULE_4__.scheduleTimeout)(function () {
        callback(_createDeadline(true));
    }, timeout);
}
//# sourceMappingURL=idle.js.map

/***/ }),
/* 116 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "areCookiesSupported": () => (/* binding */ areCookiesSupported),
/* harmony export */   "createCookieMgr": () => (/* binding */ createCookieMgr),
/* harmony export */   "safeGetCookieMgr": () => (/* binding */ safeGetCookieMgr),
/* harmony export */   "uaDisallowsSameSiteNone": () => (/* binding */ uaDisallowsSameSiteNone)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(18);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(14);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(39);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(27);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(36);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(50);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(28);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(24);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(79);
/* harmony import */ var _Config_ConfigDefaultHelpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(101);
/* harmony import */ var _Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(52);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(42);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(41);
/* harmony import */ var _EnvUtils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(44);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(46);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */
var _a, _b;








var strToGMTString = "toGMTString";
var strToUTCString = "toUTCString";
var strCookie = "cookie";
var strExpires = "expires";
var strIsCookieUseDisabled = "isCookieUseDisabled";
var strDisableCookiesUsage = "disableCookiesUsage";
var strConfigCookieMgr = "_ckMgr";
var _supportsCookies = null;
var _allowUaSameSite = null;
var _parsedCookieValue = null;
var _doc;
var _cookieCache = {};
var _globalCookieConfig = {};
// // `isCookieUseDisabled` is deprecated, so explicitly casting as a key of IConfiguration to avoid typing error
// // when both isCookieUseDisabled and disableCookiesUsage are used disableCookiesUsage will take precedent, which is
// // why its listed first
/**
 * Set the supported dynamic config values as undefined (or an empty object) so that
 * any listeners will be informed of any changes.
 * Explicitly NOT including the deprecated `isCookieUseDisabled` as we don't want to support
 * the v1 deprecated field as dynamic for updates
 */
var rootDefaultConfig = (_a = {
        cookieCfg: (0,_Config_ConfigDefaultHelpers__WEBPACK_IMPORTED_MODULE_0__.cfgDfMerge)((_b = {},
            _b[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_DOMAIN] = { fb: "cookieDomain", dfVal: _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isNotNullOrUndefined },
            _b.path = { fb: "cookiePath", dfVal: _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isNotNullOrUndefined },
            _b.enabled = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE,
            _b.ignoreCookies = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE,
            _b.blockedCookies = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE,
            _b)),
        cookieDomain: _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE,
        cookiePath: _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE
    },
    _a[strDisableCookiesUsage] = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE,
    _a);
function _getDoc() {
    !_doc && (_doc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.getLazy)(function () { return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.getDocument)(); }));
}
/**
 * @ignore
 * DO NOT USE or export from the module, this is exposed as public to support backward compatibility of previous static utility methods only.
 * If you want to manager cookies either use the ICookieMgr available from the core instance via getCookieMgr() or create
 * your own instance of the CookieMgr and use that.
 * Using this directly for enabling / disabling cookie handling will not only affect your usage but EVERY user of cookies.
 * Example, if you are using a shared component that is also using Application Insights you will affect their cookie handling.
 * @param logger - The DiagnosticLogger to use for reporting errors.
 */
function _gblCookieMgr(config, logger) {
    // Stash the global instance against the BaseCookieMgr class
    var inst = createCookieMgr[strConfigCookieMgr] || _globalCookieConfig[strConfigCookieMgr];
    if (!inst) {
        // Note: not using the getSetValue() helper as that would require always creating a temporary cookieMgr
        // that ultimately is never used
        inst = createCookieMgr[strConfigCookieMgr] = createCookieMgr(config, logger);
        _globalCookieConfig[strConfigCookieMgr] = inst;
    }
    return inst;
}
function _isMgrEnabled(cookieMgr) {
    if (cookieMgr) {
        return cookieMgr.isEnabled();
    }
    return true;
}
function _isIgnoredCookie(cookieMgrCfg, name) {
    if (name && cookieMgrCfg && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isArray)(cookieMgrCfg.ignoreCookies)) {
        return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.arrIndexOf)(cookieMgrCfg.ignoreCookies, name) !== -1;
    }
    return false;
}
function _isBlockedCookie(cookieMgrCfg, name) {
    if (name && cookieMgrCfg && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isArray)(cookieMgrCfg.blockedCookies)) {
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.arrIndexOf)(cookieMgrCfg.blockedCookies, name) !== -1) {
            return true;
        }
    }
    return _isIgnoredCookie(cookieMgrCfg, name);
}
function _isCfgEnabled(rootConfig, cookieMgrConfig) {
    var isCfgEnabled = cookieMgrConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_ENABLED /* @min:%2eenabled */];
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isNullOrUndefined)(isCfgEnabled)) {
        // Set the enabled from the provided setting or the legacy root values
        var cookieEnabled = void 0;
        // This field is deprecated and dynamic updates will not be fully supported
        if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isUndefined)(rootConfig[strIsCookieUseDisabled])) {
            cookieEnabled = !rootConfig[strIsCookieUseDisabled];
        }
        // If this value is defined it takes precedent over the above
        if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isUndefined)(rootConfig[strDisableCookiesUsage])) {
            cookieEnabled = !rootConfig[strDisableCookiesUsage];
        }
        // Not setting the cookieMgrConfig.enabled as that will update (set) the global dynamic config
        // So future "updates" then may not be as expected
        isCfgEnabled = cookieEnabled;
    }
    return isCfgEnabled;
}
/**
 * Helper to return the ICookieMgr from the core (if not null/undefined) or a default implementation
 * associated with the configuration or a legacy default.
 * @param core
 * @param config
 * @returns
 */
function safeGetCookieMgr(core, config) {
    var cookieMgr;
    if (core) {
        // Always returns an instance
        cookieMgr = core.getCookieMgr();
    }
    else if (config) {
        var cookieCfg = config.cookieCfg;
        if (cookieCfg && cookieCfg[strConfigCookieMgr]) {
            cookieMgr = cookieCfg[strConfigCookieMgr];
        }
        else {
            cookieMgr = createCookieMgr(config);
        }
    }
    if (!cookieMgr) {
        // Get or initialize the default global (legacy) cookie manager if we couldn't find one
        cookieMgr = _gblCookieMgr(config, (core || {})[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_LOGGER /* @min:%2elogger */]);
    }
    return cookieMgr;
}
function createCookieMgr(rootConfig, logger) {
    var _a;
    var cookieMgrConfig;
    var _path;
    var _domain;
    var unloadHandler;
    // Explicitly checking against false, so that setting to undefined will === true
    var _enabled;
    var _getCookieFn;
    var _setCookieFn;
    var _delCookieFn;
    // Make sure the root config is dynamic as it may be the global config
    rootConfig = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_8__.createDynamicConfig)(rootConfig || _globalCookieConfig, null, logger).cfg;
    // Will get recalled if the referenced configuration is changed
    unloadHandler = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_8__.onConfigChange)(rootConfig, function (details) {
        // Make sure the root config has all of the the defaults to the root config to ensure they are dynamic
        details[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_SET_DF /* @min:%2esetDf */](details.cfg, rootDefaultConfig);
        // Create and apply the defaults to the cookieCfg element
        cookieMgrConfig = details.ref(details.cfg, "cookieCfg"); // details.setDf(details.cfg.cookieCfg, defaultConfig);
        _path = cookieMgrConfig[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_PATH /* @min:%2epath */] || "/";
        _domain = cookieMgrConfig[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_DOMAIN /* @min:%2edomain */];
        // Explicitly checking against false, so that setting to undefined will === true
        _enabled = _isCfgEnabled(rootConfig, cookieMgrConfig) !== false;
        _getCookieFn = cookieMgrConfig.getCookie || _getCookieValue;
        _setCookieFn = cookieMgrConfig.setCookie || _setCookieValue;
        _delCookieFn = cookieMgrConfig.delCookie || _setCookieValue;
    }, logger);
    var cookieMgr = (_a = {
            isEnabled: function () {
                var enabled = _isCfgEnabled(rootConfig, cookieMgrConfig) !== false && _enabled && areCookiesSupported(logger);
                // Using an indirect lookup for any global cookie manager to support tree shaking for SDK's
                // that don't use the "applicationinsights-core" version of the default cookie function
                var gblManager = _globalCookieConfig[strConfigCookieMgr];
                if (enabled && gblManager && cookieMgr !== gblManager) {
                    // Make sure the GlobalCookie Manager instance (if not this instance) is also enabled.
                    // As the global (deprecated) functions may have been called (for backward compatibility)
                    enabled = _isMgrEnabled(gblManager);
                }
                return enabled;
            },
            setEnabled: function (value) {
                // Explicitly checking against false, so that setting to undefined will === true
                _enabled = value !== false;
                cookieMgrConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_ENABLED /* @min:%2eenabled */] = value;
            },
            set: function (name, value, maxAgeSec, domain, path) {
                var result = false;
                if (_isMgrEnabled(cookieMgr) && !_isBlockedCookie(cookieMgrConfig, name)) {
                    var values = {};
                    var theValue = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.strTrim)(value || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY);
                    var idx = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__.strIndexOf)(theValue, ";");
                    if (idx !== -1) {
                        theValue = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.strTrim)((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__.strLeft)(value, idx));
                        values = _extractParts((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__.strSubstring)(value, idx + 1));
                    }
                    // Only update domain if not already present (isUndefined) and the value is truthy (not null, undefined or empty string)
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(values, _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_DOMAIN, domain || _domain, _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isTruthy, _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isUndefined);
                    if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isNullOrUndefined)(maxAgeSec)) {
                        var _isIE = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_12__.isIE)();
                        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isUndefined)(values[strExpires])) {
                            var nowMs = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_13__.utcNow)();
                            // Only add expires if not already present
                            var expireMs = nowMs + (maxAgeSec * 1000);
                            // Sanity check, if zero or -ve then ignore
                            if (expireMs > 0) {
                                var expiry = new Date();
                                expiry.setTime(expireMs);
                                (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(values, strExpires, _formatDate(expiry, !_isIE ? strToUTCString : strToGMTString) || _formatDate(expiry, _isIE ? strToGMTString : strToUTCString) || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY, _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isTruthy);
                            }
                        }
                        if (!_isIE) {
                            // Only replace if not already present
                            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(values, "max-age", _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY + maxAgeSec, null, _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isUndefined);
                        }
                    }
                    var location_1 = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_12__.getLocation)();
                    if (location_1 && location_1.protocol === "https:") {
                        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(values, "secure", null, null, _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isUndefined);
                        // Only set same site if not also secure
                        if (_allowUaSameSite === null) {
                            _allowUaSameSite = !uaDisallowsSameSiteNone(((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.getNavigator)() || {})[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_USER_AGENT /* @min:%2euserAgent */]);
                        }
                        if (_allowUaSameSite) {
                            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(values, "SameSite", "None", null, _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isUndefined);
                        }
                    }
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(values, _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_PATH, path || _path, null, _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isUndefined);
                    //let setCookieFn = cookieMgrConfig.setCookie || _setCookieValue;
                    _setCookieFn(name, _formatCookieValue(theValue, values));
                    result = true;
                }
                return result;
            },
            get: function (name) {
                var value = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
                if (_isMgrEnabled(cookieMgr) && !_isIgnoredCookie(cookieMgrConfig, name)) {
                    value = _getCookieFn(name);
                }
                return value;
            },
            del: function (name, path) {
                var result = false;
                if (_isMgrEnabled(cookieMgr)) {
                    // Only remove the cookie if the manager and cookie support has not been disabled
                    result = cookieMgr.purge(name, path);
                }
                return result;
            },
            purge: function (name, path) {
                var _a;
                var result = false;
                if (areCookiesSupported(logger)) {
                    // Setting the expiration date in the past immediately removes the cookie
                    var values = (_a = {},
                        _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_PATH] = path ? path : "/",
                        _a[strExpires] = "Thu, 01 Jan 1970 00:00:01 GMT",
                        _a);
                    if (!(0,_EnvUtils__WEBPACK_IMPORTED_MODULE_12__.isIE)()) {
                        // Set max age to expire now
                        values["max-age"] = "0";
                    }
                    // let delCookie = cookieMgrConfig.delCookie || _setCookieValue;
                    _delCookieFn(name, _formatCookieValue(_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY, values));
                    result = true;
                }
                return result;
            }
        },
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_UNLOAD /* @min:unload */] = function (isAsync) {
            unloadHandler && unloadHandler.rm();
            unloadHandler = null;
        },
        _a);
    // Associated this cookie manager with the config
    cookieMgr[strConfigCookieMgr] = cookieMgr;
    return cookieMgr;
}
/*
* Helper method to tell if document.cookie object is supported by the runtime
*/
function areCookiesSupported(logger) {
    if (_supportsCookies === null) {
        _supportsCookies = false;
        !_doc && _getDoc();
        try {
            var doc = _doc.v || {};
            _supportsCookies = doc[strCookie] !== undefined;
        }
        catch (e) {
            (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_14__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 68 /* _eInternalMessageId.CannotAccessCookie */, "Cannot access document.cookie - " + (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.getExceptionName)(e), { exception: (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_15__.dumpObj)(e) });
        }
    }
    return _supportsCookies;
}
function _extractParts(theValue) {
    var values = {};
    if (theValue && theValue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_LENGTH /* @min:%2elength */]) {
        var parts = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.strTrim)(theValue)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_SPLIT /* @min:%2esplit */](";");
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_16__.arrForEach)(parts, function (thePart) {
            thePart = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.strTrim)(thePart || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY);
            if (thePart) {
                var idx = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__.strIndexOf)(thePart, "=");
                if (idx === -1) {
                    values[thePart] = null;
                }
                else {
                    values[(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.strTrim)((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__.strLeft)(thePart, idx))] = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.strTrim)((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__.strSubstring)(thePart, idx + 1));
                }
            }
        });
    }
    return values;
}
function _formatDate(theDate, func) {
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isFunction)(theDate[func])) {
        return theDate[func]();
    }
    return null;
}
function _formatCookieValue(value, values) {
    var cookieValue = value || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_17__.objForEachKey)(values, function (name, theValue) {
        cookieValue += "; " + name + (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isNullOrUndefined)(theValue) ? "=" + theValue : _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY);
    });
    return cookieValue;
}
function _getCookieValue(name) {
    var cookieValue = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
    !_doc && _getDoc();
    if (_doc.v) {
        var theCookie = _doc.v[strCookie] || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
        if (_parsedCookieValue !== theCookie) {
            _cookieCache = _extractParts(theCookie);
            _parsedCookieValue = theCookie;
        }
        cookieValue = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.strTrim)(_cookieCache[name] || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY);
    }
    return cookieValue;
}
function _setCookieValue(name, cookieValue) {
    !_doc && _getDoc();
    if (_doc.v) {
        _doc.v[strCookie] = name + "=" + cookieValue;
    }
}
function uaDisallowsSameSiteNone(userAgent) {
    if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isString)(userAgent)) {
        return false;
    }
    // Cover all iOS based browsers here. This includes:
    // - Safari on iOS 12 for iPhone, iPod Touch, iPad
    // - WkWebview on iOS 12 for iPhone, iPod Touch, iPad
    // - Chrome on iOS 12 for iPhone, iPod Touch, iPad
    // All of which are broken by SameSite=None, because they use the iOS networking stack
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "CPU iPhone OS 12") || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "iPad; CPU OS 12")) {
        return true;
    }
    // Cover Mac OS X based browsers that use the Mac OS networking stack. This includes:
    // - Safari on Mac OS X
    // This does not include:
    // - Internal browser on Mac OS X
    // - Chrome on Mac OS X
    // - Chromium on Mac OS X
    // Because they do not use the Mac OS networking stack.
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Macintosh; Intel Mac OS X 10_14") && (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Version/") && (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Safari")) {
        return true;
    }
    // Cover Mac OS X internal browsers that use the Mac OS networking stack. This includes:
    // - Internal browser on Mac OS X
    // This does not include:
    // - Safari on Mac OS X
    // - Chrome on Mac OS X
    // - Chromium on Mac OS X
    // Because they do not use the Mac OS networking stack.
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Macintosh; Intel Mac OS X 10_14") && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_18__.strEndsWith)(userAgent, "AppleWebKit/605.1.15 (KHTML, like Gecko)")) {
        return true;
    }
    // Cover Chrome 50-69, because some versions are broken by SameSite=None, and none in this range require it.
    // Note: this covers some pre-Chromium Edge versions, but pre-Chromim Edge does not require SameSite=None, so this is fine.
    // Note: this regex applies to Windows, Mac OS X, and Linux, deliberately.
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Chrome/5") || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Chrome/6")) {
        return true;
    }
    // Unreal Engine runs Chromium 59, but does not advertise as Chrome until 4.23. Treat versions of Unreal
    // that don't specify their Chrome version as lacking support for SameSite=None.
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "UnrealEngine") && !(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Chrome")) {
        return true;
    }
    // UCBrowser < 12.13.2 ignores Set-Cookie headers with SameSite=None
    // NB: this rule isn't complete - you need regex to make a complete rule.
    // See: https://www.chromium.org/updates/same-site/incompatible-clients
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "UCBrowser/12") || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "UCBrowser/11")) {
        return true;
    }
    return false;
}
//# sourceMappingURL=CookieMgr.js.map

/***/ }),
/* 117 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "doUnloadAll": () => (/* binding */ doUnloadAll),
/* harmony export */   "runTargetUnload": () => (/* binding */ runTargetUnload)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_async__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(105);
/* harmony import */ var _nevware21_ts_async__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(113);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(118);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(68);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(42);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





/**
 * Run the unload function of the target object if it exists
 * @param target - The target object that contains the unload function
 * @param isAsync - The caller identifies whether it is expecting the operation to complete synchronously or asynchronously. Even
 * if the caller is not waiting the operation may still be performed asynchronously depending on the component and the reverse is
 * also true.
 * @returns The result of the target function
 */
function runTargetUnload(target, isAsync) {
    if (target && target[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UNLOAD /* @min:%2eunload */]) {
        return target[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UNLOAD /* @min:%2eunload */](isAsync);
    }
}
/**
 * Call the unload function on all targets handling any returned [IPromise](https://nevware21.github.io/ts-async/typedoc/interfaces/IPromise.html)
 * / Promise before calling the next targets unload
 * @param targets - An array of the targets to unload
 * @param isAsync - The caller identifies whether it is expecting the operations to complete synchronously or asynchronously.  Even
 * if the caller is not waiting the operation may still be performed asynchronously depending on the component and the reverse is
 * also true.
 * @param done - Optional callback function to call once all of the unload functions have been called.
 */
function doUnloadAll(targets, isAsync, done) {
    var result;
    if (!done) {
        result = (0,_nevware21_ts_async__WEBPACK_IMPORTED_MODULE_1__.createPromise)(function (resolved) {
            done = resolved;
        });
    }
    if (targets && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getLength)(targets) > 0) {
        (0,_nevware21_ts_async__WEBPACK_IMPORTED_MODULE_3__.doAwaitResponse)(runTargetUnload(targets[0], isAsync), function () {
            doUnloadAll((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.arrSlice)(targets, 1), isAsync, done);
        });
    }
    else {
        done();
    }
    return result;
}
//# sourceMappingURL=AsyncUtils.js.map

/***/ }),
/* 118 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getLength": () => (/* binding */ getLength)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * Helper to return the length value of an object, this will return the value
 * of the "length" property. Generally used to return the length of a string or array.
 *
 * @since 0.4.2
 * @group Array
 * @group String
 * @group String
 * @group Array
 * @group Object
 * @param value - The value to return the length property from, must contain a `length` property
 * @example
 * ```ts
 * getLength("");               // returns 0
 * getLength("Hello World");    // returns 11
 * getLength([]);               // returns 0;
 * getLength([0, 1, 2, 3]);     // returns 4;
 * getLength({ length: 42});    // returns 42
 * getLength({ length: () => 53; }); // returns the function that if called would return 53
 * ```
 */
var getLength = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapProp)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.LENGTH);
//# sourceMappingURL=length.js.map

/***/ }),
/* 119 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ProcessTelemetryContext": () => (/* binding */ ProcessTelemetryContext),
/* harmony export */   "createProcessTelemetryContext": () => (/* binding */ createProcessTelemetryContext),
/* harmony export */   "createProcessTelemetryUnloadContext": () => (/* binding */ createProcessTelemetryUnloadContext),
/* harmony export */   "createProcessTelemetryUpdateContext": () => (/* binding */ createProcessTelemetryUpdateContext),
/* harmony export */   "createTelemetryPluginProxy": () => (/* binding */ createTelemetryPluginProxy),
/* harmony export */   "createTelemetryProxyChain": () => (/* binding */ createTelemetryProxyChain)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(24);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(33);
/* harmony import */ var _Config_ConfigDefaults__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(61);
/* harmony import */ var _Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(52);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(42);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(41);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(46);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(43);
/* harmony import */ var _PerfManager__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(103);
/* harmony import */ var _TelemetryHelpers__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(120);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */












var strTelemetryPluginChain = "TelemetryPluginChain";
var strHasRunFlags = "_hasRun";
var strGetTelCtx = "_getTelCtx";
var _chainId = 0;
function _getNextProxyStart(proxy, core, startAt) {
    while (proxy) {
        if (proxy[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_PLUGIN /* @min:%2egetPlugin */]() === startAt) {
            return proxy;
        }
        proxy = proxy[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_NEXT /* @min:%2egetNext */]();
    }
    // This wasn't found in the existing chain so create an isolated one with just this plugin
    return createTelemetryProxyChain([startAt], core.config || {}, core);
}
/**
 * @ignore
 * @param telemetryChain
 * @param dynamicHandler
 * @param core
 * @param startAt - Identifies the next plugin to execute, if null there is no "next" plugin and if undefined it should assume the start of the chain
 * @returns
 */
function _createInternalContext(telemetryChain, dynamicHandler, core, startAt) {
    // We have a special case where we want to start execution from this specific plugin
    // or we simply reuse the existing telemetry plugin chain (normal execution case)
    var _nextProxy = null; // By Default set as no next plugin
    var _onComplete = [];
    if (!dynamicHandler) {
        dynamicHandler = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_1__.createDynamicConfig)({}, null, core[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOGGER /* @min:%2elogger */]);
    }
    if (startAt !== null) {
        // There is no next element (null) vs not defined (undefined) so use the full chain
        _nextProxy = startAt ? _getNextProxyStart(telemetryChain, core, startAt) : telemetryChain;
    }
    var context = {
        _next: _moveNext,
        ctx: {
            core: function () {
                return core;
            },
            diagLog: function () {
                return (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_2__.safeGetLogger)(core, dynamicHandler.cfg);
            },
            getCfg: function () {
                return dynamicHandler.cfg;
            },
            getExtCfg: _resolveExtCfg,
            getConfig: _getConfig,
            hasNext: function () {
                return !!_nextProxy;
            },
            getNext: function () {
                return _nextProxy;
            },
            setNext: function (nextPlugin) {
                _nextProxy = nextPlugin;
            },
            iterate: _iterateChain,
            onComplete: _addOnComplete
        }
    };
    function _addOnComplete(onComplete, that) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        if (onComplete) {
            _onComplete[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PUSH /* @min:%2epush */]({
                func: onComplete,
                self: !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isUndefined)(that) ? that : context.ctx,
                args: args
            });
        }
    }
    function _moveNext() {
        var nextProxy = _nextProxy;
        // Automatically move to the next plugin
        _nextProxy = nextProxy ? nextProxy[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_NEXT /* @min:%2egetNext */]() : null;
        if (!nextProxy) {
            var onComplete = _onComplete;
            if (onComplete && onComplete[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 0) {
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.arrForEach)(onComplete, function (completeDetails) {
                    try {
                        completeDetails.func.call(completeDetails.self, completeDetails.args);
                    }
                    catch (e) {
                        (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_2__._throwInternal)(core[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOGGER /* @min:%2elogger */], 2 /* eLoggingSeverity.WARNING */, 73 /* _eInternalMessageId.PluginException */, "Unexpected Exception during onComplete - " + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.dumpObj)(e));
                    }
                });
                _onComplete = [];
            }
        }
        return nextProxy;
    }
    function _getExtCfg(identifier, createIfMissing) {
        var idCfg = null;
        var cfg = dynamicHandler.cfg;
        if (cfg && identifier) {
            var extCfg = cfg[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_EXTENSION_CONFIG /* @min:%2eextensionConfig */];
            if (!extCfg && createIfMissing) {
                extCfg = {};
            }
            // Always set the value so that the property always exists
            cfg[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_EXTENSION_CONFIG] = extCfg; // Note: it is valid for the "value" to be undefined
            // Calling `ref()` has a side effect of causing the referenced property to become dynamic  (if not already)
            extCfg = dynamicHandler.ref(cfg, _InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_EXTENSION_CONFIG);
            if (extCfg) {
                idCfg = extCfg[identifier];
                if (!idCfg && createIfMissing) {
                    idCfg = {};
                }
                // Always set the value so that the property always exists
                extCfg[identifier] = idCfg; // Note: it is valid for the "value" to be undefined
                // Calling `ref()` has a side effect of causing the referenced property to become dynamic  (if not already)
                idCfg = dynamicHandler.ref(extCfg, identifier);
            }
        }
        return idCfg;
    }
    function _resolveExtCfg(identifier, defaultValues) {
        var newConfig = _getExtCfg(identifier, true);
        if (defaultValues) {
            // Enumerate over the defaultValues and if not already populated attempt to
            // find a value from the root config or use the default value
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.objForEachKey)(defaultValues, function (field, defaultValue) {
                // for each unspecified field, set the default value
                if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(newConfig[field])) {
                    var cfgValue = dynamicHandler.cfg[field];
                    if (cfgValue || !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(cfgValue)) {
                        newConfig[field] = cfgValue;
                    }
                }
                (0,_Config_ConfigDefaults__WEBPACK_IMPORTED_MODULE_8__._applyDefaultValue)(dynamicHandler, newConfig, field, defaultValue);
            });
        }
        return dynamicHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SET_DF /* @min:%2esetDf */](newConfig, defaultValues);
    }
    function _getConfig(identifier, field, defaultValue) {
        if (defaultValue === void 0) { defaultValue = false; }
        var theValue;
        var extConfig = _getExtCfg(identifier, false);
        var rootConfig = dynamicHandler.cfg;
        if (extConfig && (extConfig[field] || !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(extConfig[field]))) {
            theValue = extConfig[field];
        }
        else if (rootConfig[field] || !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(rootConfig[field])) {
            theValue = rootConfig[field];
        }
        return (theValue || !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(theValue)) ? theValue : defaultValue;
    }
    function _iterateChain(cb) {
        // Keep processing until we reach the end of the chain
        var nextPlugin;
        while (!!(nextPlugin = context._next())) {
            var plugin = nextPlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_PLUGIN /* @min:%2egetPlugin */]();
            if (plugin) {
                // callback with the current on
                cb(plugin);
            }
        }
    }
    return context;
}
/**
 * Creates a new Telemetry Item context with the current config, core and plugin execution chain
 * @param plugins - The plugin instances that will be executed
 * @param config - The current config
 * @param core - The current core instance
 * @param startAt - Identifies the next plugin to execute, if null there is no "next" plugin and if undefined it should assume the start of the chain
 */
function createProcessTelemetryContext(telemetryChain, cfg, core, startAt) {
    var config = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_1__.createDynamicConfig)(cfg);
    var internalContext = _createInternalContext(telemetryChain, config, core, startAt);
    var context = internalContext.ctx;
    function _processNext(env) {
        var nextPlugin = internalContext._next();
        if (nextPlugin) {
            // Run the next plugin which will call "processNext()"
            nextPlugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */](env, context);
        }
        return !nextPlugin;
    }
    function _createNew(plugins, startAt) {
        if (plugins === void 0) { plugins = null; }
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isArray)(plugins)) {
            plugins = createTelemetryProxyChain(plugins, config.cfg, core, startAt);
        }
        return createProcessTelemetryContext(plugins || context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_NEXT /* @min:%2egetNext */](), config.cfg, core, startAt);
    }
    context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */] = _processNext;
    context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CREATE_NEW /* @min:%2ecreateNew */] = _createNew;
    return context;
}
/**
 * Creates a new Telemetry Item context with the current config, core and plugin execution chain for handling the unloading of the chain
 * @param plugins - The plugin instances that will be executed
 * @param config - The current config
 * @param core - The current core instance
 * @param startAt - Identifies the next plugin to execute, if null there is no "next" plugin and if undefined it should assume the start of the chain
 */
function createProcessTelemetryUnloadContext(telemetryChain, core, startAt) {
    var config = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_1__.createDynamicConfig)(core.config);
    var internalContext = _createInternalContext(telemetryChain, config, core, startAt);
    var context = internalContext.ctx;
    function _processNext(unloadState) {
        var nextPlugin = internalContext._next();
        nextPlugin && nextPlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UNLOAD /* @min:%2eunload */](context, unloadState);
        return !nextPlugin;
    }
    function _createNew(plugins, startAt) {
        if (plugins === void 0) { plugins = null; }
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isArray)(plugins)) {
            plugins = createTelemetryProxyChain(plugins, config.cfg, core, startAt);
        }
        return createProcessTelemetryUnloadContext(plugins || context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_NEXT /* @min:%2egetNext */](), core, startAt);
    }
    context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */] = _processNext;
    context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CREATE_NEW /* @min:%2ecreateNew */] = _createNew;
    return context;
}
/**
 * Creates a new Telemetry Item context with the current config, core and plugin execution chain for updating the configuration
 * @param plugins - The plugin instances that will be executed
 * @param config - The current config
 * @param core - The current core instance
 * @param startAt - Identifies the next plugin to execute, if null there is no "next" plugin and if undefined it should assume the start of the chain
 */
function createProcessTelemetryUpdateContext(telemetryChain, core, startAt) {
    var config = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_1__.createDynamicConfig)(core.config);
    var internalContext = _createInternalContext(telemetryChain, config, core, startAt);
    var context = internalContext.ctx;
    function _processNext(updateState) {
        return context.iterate(function (plugin) {
            if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isFunction)(plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UPDATE /* @min:%2eupdate */])) {
                plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UPDATE /* @min:%2eupdate */](context, updateState);
            }
        });
    }
    function _createNew(plugins, startAt) {
        if (plugins === void 0) { plugins = null; }
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isArray)(plugins)) {
            plugins = createTelemetryProxyChain(plugins, config.cfg, core, startAt);
        }
        return createProcessTelemetryUpdateContext(plugins || context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_NEXT /* @min:%2egetNext */](), core, startAt);
    }
    context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */] = _processNext;
    context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CREATE_NEW /* @min:%2ecreateNew */] = _createNew;
    return context;
}
/**
 * Creates an execution chain from the array of plugins
 * @param plugins - The array of plugins that will be executed in this order
 * @param defItemCtx - The default execution context to use when no telemetry context is passed to processTelemetry(), this
 * should be for legacy plugins only. Currently, only used for passing the current core instance and to provide better error
 * reporting (hasRun) when errors occur.
 */
function createTelemetryProxyChain(plugins, config, core, startAt) {
    var firstProxy = null;
    var add = startAt ? false : true;
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isArray)(plugins) && plugins[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 0) {
        // Create the proxies and wire up the next plugin chain
        var lastProxy_1 = null;
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.arrForEach)(plugins, function (thePlugin) {
            if (!add && startAt === thePlugin) {
                add = true;
            }
            if (add && thePlugin && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isFunction)(thePlugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */])) {
                // Only add plugins that are processors
                var newProxy = createTelemetryPluginProxy(thePlugin, config, core);
                if (!firstProxy) {
                    firstProxy = newProxy;
                }
                if (lastProxy_1) {
                    // Set this new proxy as the next for the previous one
                    lastProxy_1._setNext(newProxy);
                }
                lastProxy_1 = newProxy;
            }
        });
    }
    if (startAt && !firstProxy) {
        // Special case where the "startAt" was not in the original list of plugins
        return createTelemetryProxyChain([startAt], config, core);
    }
    return firstProxy;
}
/**
 * Create the processing telemetry proxy instance, the proxy is used to abstract the current plugin to allow monitoring and
 * execution plugins while passing around the dynamic execution state (IProcessTelemetryContext), the proxy instance no longer
 * contains any execution state and can be reused between requests (this was not the case for 2.7.2 and earlier with the
 * TelemetryPluginChain class).
 * @param plugin - The plugin instance to proxy
 * @param config - The default execution context to use when no telemetry context is passed to processTelemetry(), this
 * should be for legacy plugins only. Currently, only used for passing the current core instance and to provide better error
 * reporting (hasRun) when errors occur.
 * @returns
 */
function createTelemetryPluginProxy(plugin, config, core) {
    var nextProxy = null;
    var hasProcessTelemetry = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isFunction)(plugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */]);
    var hasSetNext = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isFunction)(plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SET_NEXT_PLUGIN /* @min:%2esetNextPlugin */]);
    var chainId;
    if (plugin) {
        chainId = plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_IDENTIFIER /* @min:%2eidentifier */] + "-" + plugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_PRIORITY /* @min:%2epriority */] + "-" + _chainId++;
    }
    else {
        chainId = "Unknown-0-" + _chainId++;
    }
    var proxyChain = {
        getPlugin: function () {
            return plugin;
        },
        getNext: function () {
            return nextProxy;
        },
        processTelemetry: _processTelemetry,
        unload: _unloadPlugin,
        update: _updatePlugin,
        _id: chainId,
        _setNext: function (nextPlugin) {
            nextProxy = nextPlugin;
        }
    };
    function _getTelCtx() {
        var itemCtx;
        // Looks like a plugin didn't pass the (optional) context, so create a new one
        if (plugin && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isFunction)(plugin[strGetTelCtx])) {
            // This plugin extends from the BaseTelemetryPlugin so lets use it
            itemCtx = plugin[strGetTelCtx]();
        }
        if (!itemCtx) {
            // Create a temporary one
            itemCtx = createProcessTelemetryContext(proxyChain, config, core);
        }
        return itemCtx;
    }
    function _processChain(itemCtx, processPluginFn, name, details, isAsync) {
        var hasRun = false;
        var identifier = plugin ? plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_IDENTIFIER /* @min:%2eidentifier */] : strTelemetryPluginChain;
        var hasRunContext = itemCtx[strHasRunFlags];
        if (!hasRunContext) {
            // Assign and populate
            hasRunContext = itemCtx[strHasRunFlags] = {};
        }
        // Ensure that we keep the context in sync
        itemCtx.setNext(nextProxy);
        if (plugin) {
            (0,_PerfManager__WEBPACK_IMPORTED_MODULE_9__.doPerf)(itemCtx[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_CORE /* @min:%2ecore */](), function () { return identifier + ":" + name; }, function () {
                // Mark this component as having run
                hasRunContext[chainId] = true;
                try {
                    // Set a flag on the next plugin so we know if it was attempted to be executed
                    var nextId = nextProxy ? nextProxy._id : _InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_EMPTY;
                    if (nextId) {
                        hasRunContext[nextId] = false;
                    }
                    hasRun = processPluginFn(itemCtx);
                }
                catch (error) {
                    var hasNextRun = nextProxy ? hasRunContext[nextProxy._id] : true;
                    if (hasNextRun) {
                        // The next plugin after us has already run so set this one as complete
                        hasRun = true;
                    }
                    if (!nextProxy || !hasNextRun) {
                        // Either we have no next plugin or the current one did not attempt to call the next plugin
                        // Which means the current one is the root of the failure so log/report this failure
                        (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_2__._throwInternal)(itemCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 1 /* eLoggingSeverity.CRITICAL */, 73 /* _eInternalMessageId.PluginException */, "Plugin [" + identifier + "] failed during " + name + " - " + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.dumpObj)(error) + ", run flags: " + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.dumpObj)(hasRunContext));
                    }
                }
            }, details, isAsync);
        }
        return hasRun;
    }
    function _processTelemetry(env, itemCtx) {
        itemCtx = itemCtx || _getTelCtx();
        function _callProcessTelemetry(itemCtx) {
            if (!plugin || !hasProcessTelemetry) {
                return false;
            }
            var pluginState = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_10__._getPluginState)(plugin);
            if (pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TEARDOWN /* @min:%2eteardown */] || pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_DISABLED]) {
                return false;
            }
            // Ensure that we keep the context in sync (for processNext()), just in case a plugin
            // doesn't calls processTelemetry() instead of itemContext.processNext() or some
            // other form of error occurred
            if (hasSetNext) {
                // Backward compatibility setting the next plugin on the instance
                plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SET_NEXT_PLUGIN /* @min:%2esetNextPlugin */](nextProxy);
            }
            plugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */](env, itemCtx);
            // Process Telemetry is expected to call itemCtx.processNext() or nextPlugin.processTelemetry()
            return true;
        }
        if (!_processChain(itemCtx, _callProcessTelemetry, "processTelemetry", function () { return ({ item: env }); }, !(env.sync))) {
            // The underlying plugin is either not defined, not enabled or does not have a processTelemetry implementation
            // so we still want the next plugin to be executed.
            itemCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](env);
        }
    }
    function _unloadPlugin(unloadCtx, unloadState) {
        function _callTeardown() {
            // Setting default of hasRun as false so the proxyProcessFn() is called as teardown() doesn't have to exist or call unloadNext().
            var hasRun = false;
            if (plugin) {
                var pluginState = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_10__._getPluginState)(plugin);
                var pluginCore = plugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_CORE] || pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_CORE /* @min:%2ecore */];
                // Only teardown the plugin if it was initialized by the current core (i.e. It's not a shared plugin)
                if (plugin && (!pluginCore || pluginCore === unloadCtx.core()) && !pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TEARDOWN /* @min:%2eteardown */]) {
                    // Handle plugins that don't extend from the BaseTelemetryPlugin
                    pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_CORE /* @min:%2ecore */] = null;
                    pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TEARDOWN /* @min:%2eteardown */] = true;
                    pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */] = false;
                    if (plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TEARDOWN /* @min:%2eteardown */] && plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TEARDOWN /* @min:%2eteardown */](unloadCtx, unloadState) === true) {
                        // plugin told us that it was going to (or has) call unloadCtx.processNext()
                        hasRun = true;
                    }
                }
            }
            return hasRun;
        }
        if (!_processChain(unloadCtx, _callTeardown, "unload", function () { }, unloadState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_IS_ASYNC /* @min:%2eisAsync */])) {
            // Only called if we hasRun was not true
            unloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](unloadState);
        }
    }
    function _updatePlugin(updateCtx, updateState) {
        function _callUpdate() {
            // Setting default of hasRun as false so the proxyProcessFn() is called as teardown() doesn't have to exist or call unloadNext().
            var hasRun = false;
            if (plugin) {
                var pluginState = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_10__._getPluginState)(plugin);
                var pluginCore = plugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_CORE] || pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_CORE /* @min:%2ecore */];
                // Only update the plugin if it was initialized by the current core (i.e. It's not a shared plugin)
                if (plugin && (!pluginCore || pluginCore === updateCtx.core()) && !pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TEARDOWN /* @min:%2eteardown */]) {
                    if (plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UPDATE /* @min:%2eupdate */] && plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UPDATE /* @min:%2eupdate */](updateCtx, updateState) === true) {
                        // plugin told us that it was going to (or has) call unloadCtx.processNext()
                        hasRun = true;
                    }
                }
            }
            return hasRun;
        }
        if (!_processChain(updateCtx, _callUpdate, "update", function () { }, false)) {
            // Only called if we hasRun was not true
            updateCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](updateState);
        }
    }
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__.objFreeze)(proxyChain);
}
/**
 * This class will be removed!
 * @deprecated use createProcessTelemetryContext() instead
 */
var ProcessTelemetryContext = /** @class */ (function () {
    /**
     * Creates a new Telemetry Item context with the current config, core and plugin execution chain
     * @param plugins - The plugin instances that will be executed
     * @param config - The current config
     * @param core - The current core instance
     */
    function ProcessTelemetryContext(pluginChain, config, core, startAt) {
        var _self = this;
        var context = createProcessTelemetryContext(pluginChain, config, core, startAt);
        // Proxy all functions of the context to this object
        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_12__.proxyFunctions)(_self, context, (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__.objKeys)(context));
    }
    return ProcessTelemetryContext;
}());

//# sourceMappingURL=ProcessTelemetryContext.js.map

/***/ }),
/* 120 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_getPluginState": () => (/* binding */ _getPluginState),
/* harmony export */   "createDistributedTraceContext": () => (/* binding */ createDistributedTraceContext),
/* harmony export */   "initializePlugins": () => (/* binding */ initializePlugins),
/* harmony export */   "sortPlugins": () => (/* binding */ sortPlugins),
/* harmony export */   "unloadComponents": () => (/* binding */ unloadComponents)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(28);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(14);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42);
/* harmony import */ var _DataCacheHelper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(58);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(43);
/* harmony import */ var _W3cTraceParent__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(72);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */








var pluginStateData = (0,_DataCacheHelper__WEBPACK_IMPORTED_MODULE_0__.createElmNodeData)("plugin");
function _getPluginState(plugin) {
    return pluginStateData.get(plugin, "state", {}, true);
}
/**
 * Initialize the queue of plugins
 * @param plugins - The array of plugins to initialize and setting of the next plugin
 * @param config - The current config for the instance
 * @param core - THe current core instance
 * @param extensions - The extensions
 */
function initializePlugins(processContext, extensions) {
    // Set the next plugin and identified the uninitialized plugins
    var initPlugins = [];
    var lastPlugin = null;
    var proxy = processContext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_NEXT /* @min:%2egetNext */]();
    var pluginState;
    while (proxy) {
        var thePlugin = proxy[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_PLUGIN /* @min:%2egetPlugin */]();
        if (thePlugin) {
            if (lastPlugin && lastPlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_NEXT_PLUGIN /* @min:%2esetNextPlugin */] && thePlugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */]) {
                // Set this plugin as the next for the previous one
                lastPlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_NEXT_PLUGIN /* @min:%2esetNextPlugin */](thePlugin);
            }
            pluginState = _getPluginState(thePlugin);
            var isInitialized = !!pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */];
            if (thePlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */]) {
                isInitialized = thePlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */]();
            }
            if (!isInitialized) {
                initPlugins[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](thePlugin);
            }
            lastPlugin = thePlugin;
            proxy = proxy[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_NEXT /* @min:%2egetNext */]();
        }
    }
    // Now initialize the plugins
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(initPlugins, function (thePlugin) {
        var core = processContext[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_CORE /* @min:%2ecore */]();
        thePlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_INITIALIZE /* @min:%2einitialize */](processContext.getCfg(), core, extensions, processContext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_NEXT /* @min:%2egetNext */]());
        pluginState = _getPluginState(thePlugin);
        // Only add the core to the state if the plugin didn't set it (doesn't extend from BaseTelemetryPlugin)
        if (!thePlugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_CORE] && !pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_CORE]) {
            pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_CORE] = core;
        }
        pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */] = true;
        delete pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TEARDOWN /* @min:%2eteardown */];
    });
}
function sortPlugins(plugins) {
    // Sort by priority
    return plugins.sort(function (extA, extB) {
        var result = 0;
        if (extB) {
            var bHasProcess = extB[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_PROCESS_TELEMETRY];
            if (extA[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_PROCESS_TELEMETRY]) {
                result = bHasProcess ? extA[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_PRIORITY] - extB[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_PRIORITY] : 1;
            }
            else if (bHasProcess) {
                result = -1;
            }
        }
        else {
            result = extA ? 1 : -1;
        }
        return result;
    });
    // sort complete
}
/**
 * Teardown / Unload helper to perform teardown/unloading operations for the provided components synchronously or asynchronously, this will call any
 * _doTeardown() or _doUnload() functions on the provided components to allow them to finish removal.
 * @param components - The components you want to unload
 * @param unloadCtx - This is the context that should be used during unloading.
 * @param unloadState - The details / state of the unload process, it holds details like whether it should be unloaded synchronously or asynchronously and the reason for the unload.
 * @param asyncCallback - An optional callback that the plugin must call if it returns true to inform the caller that it has completed any async unload/teardown operations.
 * @returns boolean - true if the plugin has or will call asyncCallback, this allows the plugin to perform any asynchronous operations.
 */
function unloadComponents(components, unloadCtx, unloadState, asyncCallback) {
    var idx = 0;
    function _doUnload() {
        while (idx < components[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]) {
            var component = components[idx++];
            if (component) {
                var func = component._doUnload || component[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__DO_TEARDOWN /* @min:%2e_doTeardown */];
                if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isFunction)(func)) {
                    if (func.call(component, unloadCtx, unloadState, _doUnload) === true) {
                        return true;
                    }
                }
            }
        }
    }
    return _doUnload();
}
/**
 * Creates a IDistributedTraceContext which optionally also "sets" the value on a parent
 * @param parentCtx - An optional parent distributed trace instance
 * @returns A new IDistributedTraceContext instance that uses an internal temporary object
 */
function createDistributedTraceContext(parentCtx) {
    var trace = {};
    return {
        getName: function () {
            return trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:%2ename */];
        },
        setName: function (newValue) {
            parentCtx && parentCtx.setName(newValue);
            trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:%2ename */] = newValue;
        },
        getTraceId: function () {
            return trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TRACE_ID /* @min:%2etraceId */];
        },
        setTraceId: function (newValue) {
            parentCtx && parentCtx.setTraceId(newValue);
            if ((0,_W3cTraceParent__WEBPACK_IMPORTED_MODULE_5__.isValidTraceId)(newValue)) {
                trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TRACE_ID /* @min:%2etraceId */] = newValue;
            }
        },
        getSpanId: function () {
            return trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPAN_ID /* @min:%2espanId */];
        },
        setSpanId: function (newValue) {
            parentCtx && parentCtx.setSpanId(newValue);
            if ((0,_W3cTraceParent__WEBPACK_IMPORTED_MODULE_5__.isValidSpanId)(newValue)) {
                trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPAN_ID /* @min:%2espanId */] = newValue;
            }
        },
        getTraceFlags: function () {
            return trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TRACE_FLAGS /* @min:%2etraceFlags */];
        },
        setTraceFlags: function (newTraceFlags) {
            parentCtx && parentCtx.setTraceFlags(newTraceFlags);
            trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TRACE_FLAGS /* @min:%2etraceFlags */] = newTraceFlags;
        }
    };
}
//# sourceMappingURL=TelemetryHelpers.js.map

/***/ }),
/* 121 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "deepExtend": () => (/* binding */ deepExtend),
/* harmony export */   "objExtend": () => (/* binding */ objExtend)
/* harmony export */ });
/* harmony import */ var _array_forEach__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28);
/* harmony import */ var _array_slice__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(68);
/* harmony import */ var _object_copy__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(122);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */



/**
 * @internal
 * @ignore
 */
function _doExtend(target, theArgs) {
    (0,_array_forEach__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(theArgs, function (theArg) {
        (0,_object_copy__WEBPACK_IMPORTED_MODULE_1__.objCopyProps)(target, theArg);
    });
    return target;
}
function deepExtend(target, obj1, obj2, obj3, obj4, obj5, obj6) {
    return _doExtend((0,_object_copy__WEBPACK_IMPORTED_MODULE_1__.objDeepCopy)(target) || {}, (0,_array_slice__WEBPACK_IMPORTED_MODULE_2__.arrSlice)(arguments));
}
function objExtend(target, obj1, obj2, obj3, obj4, obj5, obj6) {
    return _doExtend(target || {}, (0,_array_slice__WEBPACK_IMPORTED_MODULE_2__.arrSlice)(arguments));
}
//# sourceMappingURL=extend.js.map

/***/ }),
/* 122 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "arrayDeepCopyHandler": () => (/* binding */ arrayDeepCopyHandler),
/* harmony export */   "dateDeepCopyHandler": () => (/* binding */ dateDeepCopyHandler),
/* harmony export */   "functionDeepCopyHandler": () => (/* binding */ functionDeepCopyHandler),
/* harmony export */   "objCopyProps": () => (/* binding */ objCopyProps),
/* harmony export */   "objDeepCopy": () => (/* binding */ objDeepCopy),
/* harmony export */   "plainObjDeepCopyHandler": () => (/* binding */ plainObjDeepCopyHandler)
/* harmony export */ });
/* harmony import */ var _array_forEach__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28);
/* harmony import */ var _funcs_fnCall__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(48);
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _define__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(22);
/* harmony import */ var _is_plain_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(47);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */






/**
 * @internal
 * @ignore
 * Generic Object deep copy handler which creates a new plain object and copies enumerable properties from
 * the source to the new target plain object. The source object does not have to be a plain object.
 * @param details - The details object for the current property being copied
 * @returns true if the handler processed the field.
 */
var _defaultDeepCopyHandler = function (details) {
    // Make sure we at least copy plain objects
    details.value && plainObjDeepCopyHandler(details);
    // Always return true so that the iteration completes
    return true;
};
/**
 * @internal
 * @ignore
 * The ordered default deep copy handlers
 */
var defaultDeepCopyHandlers = [
    arrayDeepCopyHandler,
    plainObjDeepCopyHandler,
    functionDeepCopyHandler,
    dateDeepCopyHandler
];
/**
 * @internal
 * @ignore
 * Helper function used for detecting and handling recursive properties
 * @param visitMap - The current map of objects that have been visited
 * @param source - The value (object) to be copied
 * @param newPath - The new access path from the origin to the current property
 * @param cb - The callback function to call if the current object has not already been processed.
 * @returns The new deep copied property, may be incomplete as the object is recursive and is still in the process of being copied
 */
function _getSetVisited(visitMap, source, newPath, cb) {
    var theEntry;
    (0,_array_forEach__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(visitMap, function (entry) {
        if (entry.k === source) {
            theEntry = entry;
            return -1;
        }
    });
    if (!theEntry) {
        // Add the target to the visit map so that deep nested objects refer to the single instance
        // Even if we have not finished processing it yet.
        theEntry = { k: source, v: source };
        visitMap.push(theEntry);
        // Now call the copy callback so that it populates the target
        cb(theEntry);
    }
    return theEntry.v;
}
/**
 * @internal
 * @ignore
 * Internal helper which performs the recursive deep copy
 * @param visitMap - The current map of objects that have been visited
 * @param value - The value being copied
 * @param ctx - The current copy context
 * @param key - [Optional] the current `key` for the value from the source object
 * @returns The new deep copied instance of the value.
 */
function _deepCopy(visitMap, value, ctx, key) {
    var userHandler = ctx.handler;
    var newPath = ctx.path ? (key ? ctx.path.concat(key) : ctx.path) : [];
    var newCtx = {
        handler: ctx.handler,
        src: ctx.src,
        path: newPath
    };
    var theType = typeof value;
    var isPlain = false;
    var isPrim = false;
    if (value && theType === _internal_constants__WEBPACK_IMPORTED_MODULE_1__.OBJECT) {
        isPlain = (0,_is_plain_object__WEBPACK_IMPORTED_MODULE_2__.isPlainObject)(value);
    }
    else {
        isPrim = value === _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE || (0,_helpers_base__WEBPACK_IMPORTED_MODULE_3__.isPrimitiveType)(theType);
    }
    var details = {
        type: theType,
        isPrim: isPrim,
        isPlain: isPlain,
        value: value,
        result: value,
        path: newPath,
        origin: ctx.src,
        copy: function (source, newKey) {
            return _deepCopy(visitMap, source, newKey ? newCtx : ctx, newKey);
        },
        copyTo: function (target, source) {
            return _copyProps(visitMap, target, source, newCtx);
        }
    };
    if (!details.isPrim) {
        return _getSetVisited(visitMap, value, newPath, function (newEntry) {
            // Use an accessor to set the new value onto the new entry
            (0,_define__WEBPACK_IMPORTED_MODULE_4__.objDefine)(details, "result", {
                g: function () {
                    return newEntry.v;
                },
                s: function (newValue) {
                    newEntry.v = newValue;
                }
            });
            var idx = 0;
            var handler = userHandler;
            while (!(0,_funcs_fnCall__WEBPACK_IMPORTED_MODULE_5__.fnCall)(handler || (idx < defaultDeepCopyHandlers.length ? defaultDeepCopyHandlers[idx++] : _defaultDeepCopyHandler), ctx, details)) {
                handler = _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE;
            }
        });
    }
    // Allow the user handler to override the provided value
    if (userHandler && (0,_funcs_fnCall__WEBPACK_IMPORTED_MODULE_5__.fnCall)(userHandler, ctx, details)) {
        return details.result;
    }
    return value;
}
/**
 * @internal
 * @ignore
 * Internal helper to copy all of the enumerable properties from the source object to the new target object
 * @param visitMap - The current map of objects that have been visited
 * @param target - The target object to copy the properties to.
 * @param source - The source object to copy the properties from.
 * @param ctx - The current deep copy context
 * @returns The populated target object
 */
function _copyProps(visitMap, target, source, ctx) {
    if (!(0,_helpers_base__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(source)) {
        // Copy all properties (not just own properties)
        for (var key in source) {
            // Perform a deep copy of the object
            target[key] = _deepCopy(visitMap, source[key], ctx, key);
        }
    }
    return target;
}
/**
 * Object helper to copy all of the enumerable properties from the source object to the target, the
 * properties are copied via {@link objDeepCopy}. Automatic handling of recursive properties was added in v0.4.4
 * @group Object
 * @param target - The target object to populated
 * @param source - The source object to copy the properties from
 * @param handler - An optional callback that lets you provide / overide the deep cloning (Since 0.4.4)
 * @returns The target object
 * @example
 * ```ts
 * let a: any = { a: 1 };
 * let b: any = { b: 2, d: new Date(), e: new TestClass("Hello Darkness") };
 * a.b = b;        // { a: 1, b: { b: 2} }
 * b.a = a;        // { a: 1, b: { b: 2, a: { a: 1, { b: 2, a: ... }}}}
 *
 * function copyHandler(details: IObjDeepCopyHandlerDetails) {
 *     // details.origin === a
 *     // details.path[] is the path to the current value
 *     if (details.value && isDate(details.value)) {
 *         // So for the date path === [ "b", "d" ] which represents
 *         // details.origin["b"]["d"] === The Date
 *
 *         // Create a clone the Date object and set as the "newValue"
 *         details.value = new Date(details.value.getTime());
 *
 *         // Return true to indicate that we have "handled" the conversion
 *         // See objDeepCopy example for just reusing the original value (just don't replace details.value)
 *         return true;
 *     }
 *
 *     return false;
 * }
 *
 * let c: any = objCopyProps({}, a, copyHandler);
 *
 * assert.notEqual(a, c, "check a and c are not the same");
 * assert.ok(c !== c.b.a, "The root object won't be the same for the target reference as are are copying properties to our target");
 * assert.ok(c.b === c.b.a.b, "Check that the 2 'b' references are the same object");
 * assert.ok(c.b.a === c.b.a.b.a, "Check that the 2 'a' references are the same object");
 * assert.ok(c.b.d === c.b.a.b.d, "Check that the 2 'd' references are the same object");
 * assert.ok(isDate(c.b.d), "The copied date is still real 'Date' instance");
 * assert.notEqual(c.b.d, a.b.d, "And the copied date is not the same as the original");
 * assert.equal(c.b.d.getTime(), a.b.d.getTime(), "But the dates are the same");
 *
 * assert.ok(isObject(c.b.d), "The copied date is now an object");
 * ```
 */
function objCopyProps(target, source, handler) {
    var ctx = {
        handler: handler,
        src: source,
        path: []
    };
    return _copyProps([], target, source, ctx);
}
/**
 * Performs a deep copy of the source object, this is designed to work with base (plain) objects, arrays and primitives
 * if the source object contains class objects they will either be not cloned or may be considered non-operational after
 * performing a deep copy. ie. This is performing a deep copy of the objects properties so that altering the copy will
 * not mutate the source object hierarchy.
 * Automatic handling of recursive properties was added in v0.4.4.
 * @group Object
 * @group Object - Deep Copy
 * @param source - The source object to be copied
 * @param handler - An optional callback that lets you provide / overide the deep cloning (Since 0.4.4)
 * @return A new object which contains a deep copy of the source properties
 * @example
 * ```ts
 * let a: any = { a: 1 };
 * let b: any = { b: 2, d: new Date(), e: new TestClass("Hello Darkness") };
 * a.b = b;        // { a: 1, b: { b: 2} }
 * b.a = a;        // { a: 1, b: { b: 2, a: { a: 1, { b: 2, a: ... }}}}
 *
 * function copyHandler(details: IObjDeepCopyHandlerDetails) {
 *     // details.origin === a
 *     // details.path[] is the path to the current value
 *     if (details.value && isDate(details.value)) {
 *         // So for the date path === [ "b", "d" ] which represents
 *         // details.origin["b"]["d"] === The Date
 *
 *         // Return true to indicate that we have "handled" the conversion
 *         // Which in this case will reuse the existing instance (as we didn't replace details.value)
 *         // See objCopyProps example for replacing the Date instance
 *         return true;
 *     }
 *
 *     return false;
 * }
 *
 * let c: any = objDeepCopy(a, copyHandler);
 *
 * assert.notEqual(a, c, "check a and c are not the same");
 * assert.ok(c === c.b.a, "The root object won't be the same for the target reference");
 * assert.ok(c.b === c.b.a.b, "Check that the 2 'b' references are the same object");
 * assert.ok(c.b.a === c.b.a.b.a, "Check that the 2 'a' references are the same object");
 * assert.ok(c.b.d === c.b.a.b.d, "Check that the 2 'd' references are the same object");
 * assert.ok(isDate(c.b.d), "The copied date is still real 'Date' instance");
 * assert.equal(c.b.d, a.b.d, "And the copied date is the original date");
 * assert.equal(c.b.d.getTime(), a.b.d.getTime(), "But the dates are the same");
 * assert.ok(isObject(c.b.d), "The copied date is now an object");
 * assert.ok(!isError(c.b.e), "The copied error is no longer a real 'Error' instance");
 * assert.ok(isObject(c.b.e), "The copied error is now an object");
 * assert.equal(42, c.b.e.value, "Expect that the local property was copied");
 * ```
 */
function objDeepCopy(source, handler) {
    var ctx = {
        handler: handler,
        src: source
    };
    return _deepCopy([], source, ctx);
}
/**
 * Deep copy handler to identify and copy arrays.
 * @since 0.4.4
 * @group Object - Deep Copy
 * @param details - The details object for the current property being copied
 * @returns `true` if the current value is a function otherwise `false`
 */
function arrayDeepCopyHandler(details) {
    var value = details.value;
    if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_3__.isArray)(value)) {
        // Assign the "result" value before performing any additional deep Copying, so any recursive object get a reference to this instance
        var target = details.result = [];
        target.length = value.length;
        // Copying all properties as arrays can contain non-indexed based properties
        details.copyTo(target, value);
        return true;
    }
    return false;
}
/**
 * Deep copy handler to identify and copy Date instances.
 * @since 0.4.4
 * @group Object - Deep Copy
 * @param details - The details object for the current property being copied
 * @returns `true` if the current value is a function otherwise `false`
 */
function dateDeepCopyHandler(details) {
    var value = details.value;
    if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_3__.isDate)(value)) {
        details.result = new Date(value.getTime());
        return true;
    }
    return false;
}
/**
 * Deep copy handler to identify and copy functions. This handler just returns the original
 * function so the original function will be assigned to any new deep copied instance.
 * @since 0.4.4
 * @group Object - Deep Copy
 * @param details - The details object for the current property being copied
 * @returns `true` if the current value is a function otherwise `false`
 */
function functionDeepCopyHandler(details) {
    if (details.type === _internal_constants__WEBPACK_IMPORTED_MODULE_1__.FUNCTION) {
        return true;
    }
    return false;
}
/**
 * Deep copy handler to identify and copy plain objects.
 * @since 0.4.4
 * @group Object - Deep Copy
 * @param details - The details object for the current property being copied
 * @returns `true` if the current value is a function otherwise `false`
 */
function plainObjDeepCopyHandler(details) {
    var value = details.value;
    if (value && details.isPlain) {
        // Assign the "result" value before performing any additional deep Copying, so any recursive object get a reference to this instance
        var target = details.result = {};
        details.copyTo(target, value);
        return true;
    }
    return false;
}
//# sourceMappingURL=copy.js.map

/***/ }),
/* 123 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "arrAppend": () => (/* binding */ arrAppend)
/* harmony export */ });
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14);
/* harmony import */ var _iterator_iterator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(124);
/* harmony import */ var _iterator_forOf__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(125);
/* harmony import */ var _funcs_fnApply__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */




/**
 * Appends the `elms` to the `target` where the elms may be an array, a single object
 * or an iterator object
 * @group Array
 * @group Iterator
 * @example
 * ```ts
 * let theArray = arrAppend([], 1);
 * arrAppend(theArray, [ 2, 3, 4 ]);
 * arrAppend(theArray, [ "a", "b", "c" ]);
 * // theArray is now [ 1, 2, 3, 4, "a", "b", "c" ]
 * ```
 * @param target - The target array
 * @param elms - The item, array of items an iterable or iterator object of items to add to the target
 * @returns The passed in target array
 * @example
 * ```ts
 * // Adding a single value
 * arrAppend([], undefined);            // []
 * arrAppend([], 0);                    // [ 0 ]
 * arrAppend([1], undefined);           // [ 1 ]
 * arrAppend([1], 2);                   // [ 1, 2 ]
 *
 * // Adding an array
 * arrAppend([], [] as number[]);       // []
 * arrAppend([], [0]);                  // [ 0 ]
 * arrAppend([1], []);                  // [ 1 ]
 * arrAppend([1], [2]);                 // [ 1, 2 ]
 *
 * // Adding with an iterator
 * arrAppend([], ([] as number[]).values());    // []
 * arrAppend([], [0].values());         // [ 0 ]
 * arrAppend([1], [].keys());           // [ 1 ]
 * arrAppend([1], [2].values());        // [ 1, 2 ]
 * arrAppend([1], [2].keys());          // [ 1, 0 ] - 0 is from the index from the first element
 * ```
 */
function arrAppend(target, elms) {
    if (!(0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isUndefined)(elms) && target) {
        if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isArray)(elms)) {
            // This is not just "target.push(elms)" but becomes effectively "target.push(elms[0], elms[1], ...)"
            (0,_funcs_fnApply__WEBPACK_IMPORTED_MODULE_1__.fnApply)(target.push, target, elms);
        }
        else if ((0,_iterator_iterator__WEBPACK_IMPORTED_MODULE_2__.isIterator)(elms) || (0,_iterator_iterator__WEBPACK_IMPORTED_MODULE_2__.isIterable)(elms)) {
            (0,_iterator_forOf__WEBPACK_IMPORTED_MODULE_3__.iterForOf)(elms, function (elm) {
                target.push(elm);
            });
        }
        else {
            target.push(elms);
        }
    }
    return target;
}
//# sourceMappingURL=append.js.map

/***/ }),
/* 124 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isIterable": () => (/* binding */ isIterable),
/* harmony export */   "isIterator": () => (/* binding */ isIterator)
/* harmony export */ });
/* harmony import */ var _symbol_symbol__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(54);
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * Checks if the type of value looks like an iterator instance (contains a next function).
 *
 * @since 0.4.0
 * @group Type Identity
 * @group Iterator
 * @typeParam T - Identifies the return type of the iterator defaults to any
 * @param value - The value to be checked
 * @returns {boolean} True if the value is an Iterator, otherwise false
 * @example
 * ```ts
 * isIterator(null);        // false
 * isIterator(undefined);   // false
 * isIterator("null");      // false (Strings are iterable but not iterators)
 * isIterator([]);          // false (Arrays are iterable but not iterators)
 * isIterator({
 *     next: function() { return true }
 * });                      // true, iterators must contain a "next" function
 * ```
 */
function isIterator(value) {
    return !!value && (0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isFunction)(value.next);
}
/**
 * Checks if the value looks like it is iterable, contains a [symbol.iterator].
 *
 * @since 0.4.0
 * @group Type Identity
 * @group Iterator
 * @typeParam T - Identifies the return type of the iterator
 * @param value - The value to be checked
 * @returns {boolean} True if the value is an Iterable, otherwise false
 * @example
 * ```ts
 * isIterable(null);        // false
 * isIterable(undefined);   // false
 * isIterable("null");      // true (Strings are iterable)
 * isIterable([]);          // true (Arrays are iterable)
 * ```
 */
function isIterable(value) {
    return !(0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isStrictNullOrUndefined)(value) && (0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isFunction)(value[(0,_symbol_symbol__WEBPACK_IMPORTED_MODULE_1__.getKnownSymbol)(3 /* WellKnownSymbols.iterator */)]);
}
//# sourceMappingURL=iterator.js.map

/***/ }),
/* 125 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "iterForOf": () => (/* binding */ iterForOf)
/* harmony export */ });
/* harmony import */ var _helpers_lazy__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(10);
/* harmony import */ var _symbol_symbol__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(54);
/* harmony import */ var _iterator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(124);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */




var _iterSymbol;
/**
 * Calls the provided `callbackFn` function once for each element in the iterator or iterator returned by
 * the iterable and processed in the same order as returned by the iterator. As with the {@link arrForEach}
 * you CAN stop / break the iteration by returning -1 from the`callbackFn` function.
 *
 * The order of processing is not reset if you add or remove elements to the iterator, the actual behavior
 * will depend on the iterator imeplementation.
 *
 * If the passed `iter` is both an Iterable<T> and Iterator<T> the Iterator<T> interface takes preceedence.
 * @remarks
 * If Symbols are NOT supported then the iterable MUST be using the same polyFill for the well know symbols,
 * if you are targetting a mixed environment you SHOULD either
 * - only use the polyfill Symbol's provided by this library
 * - ensure that you add any symbol polyfills BEFORE these utilities
 * iterForOf expects a `synchronous` function.
 * iterForOf does not wait for promises. Make sure you are aware of the implications while using
 * promises (or async functions) as forEach callback.
 *
 * @since 0.4.2
 * @group Iterator
 * @typeParam T - Identifies the element type of the iterator
 * @param callbackfn A `synchronous` function that accepts up to three arguments. iterForOf calls the
 * callbackfn function one time for each element returned by the iterator.
 * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is
 * omitted, null or undefined the iterator will be used as the this value.
 * @throws Any exception thrown while processing the iterator
 * @example
 * ```ts
 * const items = {
 *     'item1': 'value1',
 *     'item2': 'value2',
 *     'item3': 'value3
 * };
 * const copyItems = [];
 *
 * iterForOf(items, (item) => {
 *   copyItems.push(item);
 *   // May return -1 to abort the iteration
 * });
 * ```
 */
function iterForOf(iter, callbackfn, thisArg) {
    if (iter) {
        if (!(0,_iterator__WEBPACK_IMPORTED_MODULE_0__.isIterator)(iter)) {
            !_iterSymbol && (_iterSymbol = (0,_helpers_lazy__WEBPACK_IMPORTED_MODULE_1__.getLazy)(function () { return (0,_symbol_symbol__WEBPACK_IMPORTED_MODULE_2__.getKnownSymbol)(3 /* WellKnownSymbols.iterator */); }));
            iter = iter[_iterSymbol.v] ? iter[_iterSymbol.v]() : null;
        }
        if ((0,_iterator__WEBPACK_IMPORTED_MODULE_0__.isIterator)(iter)) {
            var err = void 0;
            var iterResult = void 0;
            try {
                var count = 0;
                while (!(iterResult = iter.next())[_internal_constants__WEBPACK_IMPORTED_MODULE_3__.DONE]) {
                    if (callbackfn.call(thisArg || iter, iterResult[_internal_constants__WEBPACK_IMPORTED_MODULE_3__.VALUE], count, iter) === -1) {
                        break;
                    }
                    count++;
                }
            }
            catch (failed) {
                err = { e: failed };
                if (iter.throw) {
                    iterResult = null;
                    iter.throw(err);
                }
            }
            finally {
                try {
                    if (iterResult && !iterResult[_internal_constants__WEBPACK_IMPORTED_MODULE_3__.DONE]) {
                        iter.return && iter.return(iterResult);
                    }
                }
                finally {
                    if (err) {
                        // eslint-disable-next-line no-unsafe-finally
                        throw err.e;
                    }
                }
            }
        }
    }
}
//# sourceMappingURL=forOf.js.map

/***/ }),
/* 126 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TelemetryInitializerPlugin": () => (/* binding */ TelemetryInitializerPlugin)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(84);
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(51);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(123);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(13);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(42);
/* harmony import */ var _BaseTelemetryPlugin__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(127);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(41);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(46);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(43);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */
// 
// 








function _addInitializer(_initializers, id, telemetryInitializer) {
    var theInitializer = {
        id: id,
        fn: telemetryInitializer
    };
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.arrAppend)(_initializers, theInitializer);
    var handler = {
        remove: function () {
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(_initializers, function (initializer, idx) {
                if (initializer.id === theInitializer.id) {
                    _initializers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_SPLICE /* @min:%2esplice */](idx, 1);
                    return -1;
                }
            });
        }
    };
    return handler;
}
function _runInitializers(_initializers, item, logger) {
    var doNotSendItem = false;
    var telemetryInitializersCount = _initializers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */];
    for (var i = 0; i < telemetryInitializersCount; ++i) {
        var telemetryInitializer = _initializers[i];
        if (telemetryInitializer) {
            try {
                if (telemetryInitializer.fn[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_APPLY /* @min:%2eapply */](null, [item]) === false) {
                    doNotSendItem = true;
                    break;
                }
            }
            catch (e) {
                // log error but dont stop executing rest of the telemetry initializers
                // doNotSendItem = true;
                (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_3__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 64 /* _eInternalMessageId.TelemetryInitializerFailed */, "Telemetry initializer failed: " + (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_4__.getExceptionName)(e), { exception: (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.dumpObj)(e) }, true);
            }
        }
    }
    return !doNotSendItem;
}
var TelemetryInitializerPlugin = /** @class */ (function (_super) {
    (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_6__.__extendsFn)(TelemetryInitializerPlugin, _super);
    function TelemetryInitializerPlugin() {
        var _this = _super.call(this) || this;
        _this.identifier = "TelemetryInitializerPlugin";
        _this.priority = 199;
        // NOTE!: DON'T set default values here, instead set them in the _initDefaults() function as it is also called during teardown()
        var _id;
        var _initializers;
        _initDefaults();
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_7__["default"])(TelemetryInitializerPlugin, _this, function (_self, _base) {
            _self.addTelemetryInitializer = function (telemetryInitializer) {
                return _addInitializer(_initializers, _id++, telemetryInitializer);
            };
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_8__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */] = function (item, itemCtx) {
                if (_runInitializers(_initializers, item, itemCtx ? itemCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DIAG_LOG /* @min:%2ediagLog */]() : _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DIAG_LOG /* @min:%2ediagLog */]())) {
                    _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](item, itemCtx);
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN__DO_TEARDOWN /* @min:%2e_doTeardown */] = function () {
                _initDefaults();
            };
        });
        function _initDefaults() {
            _id = 0;
            _initializers = [];
        }
        return _this;
    }
// Removed Stub for TelemetryInitializerPlugin.prototype.addTelemetryInitializer.
// Removed Stub for TelemetryInitializerPlugin.prototype.processTelemetry.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    TelemetryInitializerPlugin.__ieDyn=1;

    return TelemetryInitializerPlugin;
}(_BaseTelemetryPlugin__WEBPACK_IMPORTED_MODULE_9__.BaseTelemetryPlugin));

//# sourceMappingURL=TelemetryInitializerPlugin.js.map

/***/ }),
/* 127 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BaseTelemetryPlugin": () => (/* binding */ BaseTelemetryPlugin)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(51);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(22);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(14);
/* harmony import */ var _Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(52);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(42);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(41);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(46);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(119);
/* harmony import */ var _UnloadHandlerContainer__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(129);
/* harmony import */ var _UnloadHookContainer__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(128);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */



var _a;










var strGetPlugin = "getPlugin";
var defaultValues = (_a = {},
    _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EXTENSION_CONFIG] = { isVal: _HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.isNotNullOrUndefined, v: {} },
    _a);
/**
 * BaseTelemetryPlugin provides a basic implementation of the ITelemetryPlugin interface so that plugins
 * can avoid implementation the same set of boiler plate code as well as provide a base
 * implementation so that new default implementations can be added without breaking all plugins.
 */
var BaseTelemetryPlugin = /** @class */ (function () {
    function BaseTelemetryPlugin() {
        var _self = this; // Setting _self here as it's used outside of the dynamicProto as well
        // NOTE!: DON'T set default values here, instead set them in the _initDefaults() function as it is also called during teardown()
        var _isinitialized;
        var _rootCtx; // Used as the root context, holding the current config and initialized core
        var _nextPlugin; // Used for backward compatibility where plugins don't call the main pipeline
        var _unloadHandlerContainer;
        var _hookContainer;
        _initDefaults();
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_2__["default"])(BaseTelemetryPlugin, _self, function (_self) {
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_INITIALIZE /* @min:%2einitialize */] = function (config, core, extensions, pluginChain) {
                _setDefaults(config, core, pluginChain);
                _isinitialized = true;
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_TEARDOWN /* @min:%2eteardown */] = function (unloadCtx, unloadState) {
                var _a;
                // If this plugin has already been torn down (not operational) or is not initialized (core is not set)
                // or the core being used for unload was not the same core used for initialization.
                var core = _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CORE /* @min:%2ecore */];
                if (!core || (unloadCtx && core !== unloadCtx[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CORE /* @min:%2ecore */]())) {
                    // Do Nothing as either the plugin is not initialized or was not initialized by the current core
                    return;
                }
                var result;
                var unloadDone = false;
                var theUnloadCtx = unloadCtx || (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_4__.createProcessTelemetryUnloadContext)(null, core, _nextPlugin && _nextPlugin[strGetPlugin] ? _nextPlugin[strGetPlugin]() : _nextPlugin);
                var theUnloadState = unloadState || (_a = {
                        reason: 0 /* TelemetryUnloadReason.ManualTeardown */
                    },
                    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_IS_ASYNC /* @min:isAsync */] = false,
                    _a);
                function _unloadCallback() {
                    if (!unloadDone) {
                        unloadDone = true;
                        _unloadHandlerContainer.run(theUnloadCtx, unloadState);
                        _hookContainer.run(theUnloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_DIAG_LOG /* @min:%2ediagLog */]());
                        if (result === true) {
                            theUnloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](theUnloadState);
                        }
                        _initDefaults();
                    }
                }
                if (!_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN__DO_TEARDOWN /* @min:%2e_doTeardown */] || _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN__DO_TEARDOWN /* @min:%2e_doTeardown */](theUnloadCtx, theUnloadState, _unloadCallback) !== true) {
                    _unloadCallback();
                }
                else {
                    // Tell the caller that we will be calling processNext()
                    result = true;
                }
                return result;
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_UPDATE /* @min:%2eupdate */] = function (updateCtx, updateState) {
                // If this plugin has already been torn down (not operational) or is not initialized (core is not set)
                // or the core being used for unload was not the same core used for initialization.
                var core = _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CORE /* @min:%2ecore */];
                if (!core || (updateCtx && core !== updateCtx[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CORE /* @min:%2ecore */]())) {
                    // Do Nothing
                    return;
                }
                var result;
                var updateDone = false;
                var theUpdateCtx = updateCtx || (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_4__.createProcessTelemetryUpdateContext)(null, core, _nextPlugin && _nextPlugin[strGetPlugin] ? _nextPlugin[strGetPlugin]() : _nextPlugin);
                var theUpdateState = updateState || {
                    reason: 0 /* TelemetryUpdateReason.Unknown */
                };
                function _updateCallback() {
                    if (!updateDone) {
                        updateDone = true;
                        _setDefaults(theUpdateCtx.getCfg(), theUpdateCtx.core(), theUpdateCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_GET_NEXT /* @min:%2egetNext */]());
                    }
                }
                if (!_self._doUpdate || _self._doUpdate(theUpdateCtx, theUpdateState, _updateCallback) !== true) {
                    _updateCallback();
                }
                else {
                    result = true;
                }
                return result;
            };
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.proxyFunctionAs)(_self, "_addUnloadCb", function () { return _unloadHandlerContainer; }, "add");
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.proxyFunctionAs)(_self, "_addHook", function () { return _hookContainer; }, "add");
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objDefine)(_self, "_unloadHooks", { g: function () { return _hookContainer; } });
        });
        // These are added after the dynamicProto so that are not moved to the prototype
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_DIAG_LOG /* @min:%2ediagLog */] = function (itemCtx) {
            return _getTelCtx(itemCtx)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_DIAG_LOG /* @min:%2ediagLog */]();
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */] = function () {
            return _isinitialized;
        };
        _self.setInitialized = function (isInitialized) {
            _isinitialized = isInitialized;
        };
        // _self.getNextPlugin = () => DO NOT IMPLEMENT
        // Sub-classes of this base class *should* not be relying on this value and instead
        // should use processNext() function. If you require access to the plugin use the
        // IProcessTelemetryContext.getNext().getPlugin() while in the pipeline, Note getNext() may return null.
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SET_NEXT_PLUGIN /* @min:%2esetNextPlugin */] = function (next) {
            _nextPlugin = next;
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */] = function (env, itemCtx) {
            if (itemCtx) {
                // Normal core execution sequence
                itemCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](env);
            }
            else if (_nextPlugin && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.isFunction)(_nextPlugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */])) {
                // Looks like backward compatibility or out of band processing. And as it looks
                // like a ITelemetryPlugin or ITelemetryPluginChain, just call processTelemetry
                _nextPlugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */](env, null);
            }
        };
        _self._getTelCtx = _getTelCtx;
        function _getTelCtx(currentCtx) {
            if (currentCtx === void 0) { currentCtx = null; }
            var itemCtx = currentCtx;
            if (!itemCtx) {
                var rootCtx = _rootCtx || (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_4__.createProcessTelemetryContext)(null, {}, _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CORE /* @min:%2ecore */]);
                // tslint:disable-next-line: prefer-conditional-expression
                if (_nextPlugin && _nextPlugin[strGetPlugin]) {
                    // Looks like a chain object
                    itemCtx = rootCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_CREATE_NEW /* @min:%2ecreateNew */](null, _nextPlugin[strGetPlugin]);
                }
                else {
                    itemCtx = rootCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_CREATE_NEW /* @min:%2ecreateNew */](null, _nextPlugin);
                }
            }
            return itemCtx;
        }
        function _setDefaults(config, core, pluginChain) {
            // Make sure the extensionConfig exists and the config is dynamic
            (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_7__.createDynamicConfig)(config, defaultValues, (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_8__.safeGetLogger)(core));
            if (!pluginChain && core) {
                // Get the first plugin from the core
                pluginChain = core[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_GET_PROCESS_TEL_CONT0 /* @min:%2egetProcessTelContext */]()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_GET_NEXT /* @min:%2egetNext */]();
            }
            var nextPlugin = _nextPlugin;
            if (_nextPlugin && _nextPlugin[strGetPlugin]) {
                // If it looks like a proxy/chain then get the plugin
                nextPlugin = _nextPlugin[strGetPlugin]();
            }
            // Support legacy plugins where core was defined as a property
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CORE /* @min:%2ecore */] = core;
            _rootCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_4__.createProcessTelemetryContext)(pluginChain, config, core, nextPlugin);
        }
        function _initDefaults() {
            _isinitialized = false;
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CORE /* @min:%2ecore */] = null;
            _rootCtx = null;
            _nextPlugin = null;
            _hookContainer = (0,_UnloadHookContainer__WEBPACK_IMPORTED_MODULE_9__.createUnloadHookContainer)();
            _unloadHandlerContainer = (0,_UnloadHandlerContainer__WEBPACK_IMPORTED_MODULE_10__.createUnloadHandlerContainer)();
        }
    }
// Removed Stub for BaseTelemetryPlugin.prototype.initialize.
// Removed Stub for BaseTelemetryPlugin.prototype.teardown.
// Removed Stub for BaseTelemetryPlugin.prototype.update.
// Removed Stub for BaseTelemetryPlugin.prototype._addUnloadCb.
// Removed Stub for BaseTelemetryPlugin.prototype._addHook.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    BaseTelemetryPlugin.__ieDyn=1;

    return BaseTelemetryPlugin;
}());

//# sourceMappingURL=BaseTelemetryPlugin.js.map

/***/ }),
/* 128 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createUnloadHookContainer": () => (/* binding */ createUnloadHookContainer)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(123);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(41);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */




/**
 * Create a IUnloadHookContainer which can be used to remember unload hook functions to be executed during the component unloading
 * process.
 * @returns A new IUnloadHookContainer instance
 */
function createUnloadHookContainer() {
    var _hooks = [];
    function _doUnload(logger) {
        var oldHooks = _hooks;
        _hooks = [];
        // Remove all registered unload hooks
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(oldHooks, function (fn) {
            // allow either rm or remove callback function
            try {
                (fn.rm || fn.remove).call(fn);
            }
            catch (e) {
                (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_1__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 73 /* _eInternalMessageId.PluginException */, "Unloading:" + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.dumpObj)(e));
            }
        });
    }
    function _addHook(hooks) {
        if (hooks) {
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrAppend)(_hooks, hooks);
        }
    }
    return {
        run: _doUnload,
        add: _addHook
    };
}
//# sourceMappingURL=UnloadHookContainer.js.map

/***/ }),
/* 129 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createUnloadHandlerContainer": () => (/* binding */ createUnloadHandlerContainer)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(42);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(41);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





function createUnloadHandlerContainer() {
    var handlers = [];
    function _addHandler(handler) {
        if (handler) {
            handlers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PUSH /* @min:%2epush */](handler);
        }
    }
    function _runHandlers(unloadCtx, unloadState) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(handlers, function (handler) {
            try {
                handler(unloadCtx, unloadState);
            }
            catch (e) {
                (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_2__._throwInternal)(unloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 2 /* eLoggingSeverity.WARNING */, 73 /* _eInternalMessageId.PluginException */, "Unexpected error calling unload handler - " + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.dumpObj)(e));
            }
        });
        handlers = [];
    }
    return {
        add: _addHandler,
        run: _runHandlers
    };
}
//# sourceMappingURL=UnloadHandlerContainer.js.map

/***/ }),
/* 130 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ChannelControllerPriority": () => (/* binding */ ChannelControllerPriority)
/* harmony export */ });
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


var ChannelControllerPriority = 500;
//# sourceMappingURL=Constants.js.map

/***/ }),
/* 131 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_DYN_CONNECTION_STRING": () => (/* binding */ _DYN_CONNECTION_STRING),
/* harmony export */   "_DYN_INSTRUMENTATION_KEY": () => (/* binding */ _DYN_INSTRUMENTATION_KEY)
/* harmony export */ });
/*
 * Application Insights JavaScript Web SDK - Basic, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


// @skip-file-minify
// ##############################################################
// AUTO GENERATED FILE: This file is Auto Generated during build.
// ##############################################################
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Note: DON'T Export these const from the package as we are still targeting ES3 this will export a mutable variables that someone could change!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
var _DYN_INSTRUMENTATION_KEY = "instrumentationKey"; // Count: 3
var _DYN_CONNECTION_STRING = "connectionString"; // Count: 3
//# sourceMappingURL=__DynamicConstants.js.map

/***/ }),
/* 132 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Sender": () => (/* binding */ Sender)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(84);
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(51);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(7);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(81);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(90);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(87);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(91);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(82);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(85);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(89);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(5);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(75);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(6);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(29);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(101);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(41);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(46);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(13);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(137);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(58);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(52);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(119);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(28);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(44);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(117);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(18);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(50);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(127);
/* harmony import */ var _nevware21_ts_async__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(105);
/* harmony import */ var _nevware21_ts_async__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(113);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(22);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(69);
/* harmony import */ var _EnvelopeCreator__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(134);
/* harmony import */ var _Offline__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(138);
/* harmony import */ var _SendBuffer__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(139);
/* harmony import */ var _Serializer__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(136);
/* harmony import */ var _TelemetryProcessors_Sample__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(140);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(133);
/*
 * Application Insights JavaScript SDK - Channel, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */
var _a, _b;












var UNDEFINED_VALUE = undefined;
var FetchSyncRequestSizeLimitBytes = 65000; // approx 64kb (the current Edge, Firefox and Chrome max limit)
function _getResponseText(xhr) {
    try {
        return xhr.responseText;
    }
    catch (e) {
        // Best effort, as XHR may throw while XDR wont so just ignore
    }
    return null;
}
function isOverrideFn(httpXHROverride) {
    return httpXHROverride && httpXHROverride[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SEND_POST /* @min:%2esendPOST */];
}
var defaultAppInsightsChannelConfig = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objDeepFreeze)((_a = {
        // Use the default value (handles empty string in the configuration)
        endpointUrl: (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.cfgDfValidate)(_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isTruthy, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_BREEZE_ENDPOINT + _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_BREEZE_PATH)
    },
    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_EMIT_LINE_DELIMITED_0 /* @min:emitLineDelimitedJson */] = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.cfgDfBoolean)(),
    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MAX_BATCH_INTERVAL /* @min:maxBatchInterval */] = 15000,
    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MAX_BATCH_SIZE_IN_BY1 /* @min:maxBatchSizeInBytes */] = 102400,
    _a.disableTelemetry = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.cfgDfBoolean)(),
    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ENABLE_SESSION_STORA5 /* @min:enableSessionStorageBuffer */] = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.cfgDfBoolean)(true),
    _a.isRetryDisabled = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.cfgDfBoolean)(),
    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_IS_BEACON_API_DISABL3 /* @min:isBeaconApiDisabled */] = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.cfgDfBoolean)(true),
    _a.disableXhr = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.cfgDfBoolean)(),
    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ONUNLOAD_DISABLE_FET6 /* @min:onunloadDisableFetch */] = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.cfgDfBoolean)(),
    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ONUNLOAD_DISABLE_BEA2 /* @min:onunloadDisableBeacon */] = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.cfgDfBoolean)(),
    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_INSTRUMENTATION_KEY /* @min:instrumentationKey */] = UNDEFINED_VALUE,
    _a.namePrefix = UNDEFINED_VALUE,
    _a.samplingPercentage = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.cfgDfValidate)(_chkSampling, 100),
    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CUSTOM_HEADERS /* @min:customHeaders */] = UNDEFINED_VALUE,
    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CONVERT_UNDEFINED /* @min:convertUndefined */] = UNDEFINED_VALUE,
    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_EVENTS_LIMIT_IN_MEM /* @min:eventsLimitInMem */] = 10000,
    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_BUFFER_OVERRIDE /* @min:bufferOverride */] = false,
    _a.httpXHROverride = { isVal: isOverrideFn, v: UNDEFINED_VALUE },
    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ALWAYS_USE_XHR_OVERR4 /* @min:alwaysUseXhrOverride */] = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.cfgDfBoolean)(),
    _a));
function _chkSampling(value) {
    return !isNaN(value) && value > 0 && value <= 100;
}
var EnvelopeTypeCreator = (_b = {},
    _b[_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_5__.Event.dataType] = _EnvelopeCreator__WEBPACK_IMPORTED_MODULE_6__.EventEnvelopeCreator,
    _b[_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_7__.Trace.dataType] = _EnvelopeCreator__WEBPACK_IMPORTED_MODULE_6__.TraceEnvelopeCreator,
    _b[_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_8__.PageView.dataType] = _EnvelopeCreator__WEBPACK_IMPORTED_MODULE_6__.PageViewEnvelopeCreator,
    _b[_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_9__.PageViewPerformance.dataType] = _EnvelopeCreator__WEBPACK_IMPORTED_MODULE_6__.PageViewPerformanceEnvelopeCreator,
    _b[_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_10__.Exception.dataType] = _EnvelopeCreator__WEBPACK_IMPORTED_MODULE_6__.ExceptionEnvelopeCreator,
    _b[_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_11__.Metric.dataType] = _EnvelopeCreator__WEBPACK_IMPORTED_MODULE_6__.MetricEnvelopeCreator,
    _b[_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_12__.RemoteDependencyData.dataType] = _EnvelopeCreator__WEBPACK_IMPORTED_MODULE_6__.DependencyEnvelopeCreator,
    _b);
var Sender = /** @class */ (function (_super) {
    (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_13__.__extendsFn)(Sender, _super);
    function Sender() {
        var _this = _super.call(this) || this;
        _this.priority = 1001;
        _this.identifier = _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_14__.BreezeChannelIdentifier;
        // Don't set the defaults here, set them in the _initDefaults() as this is also called during unload
        var _consecutiveErrors; // How many times in a row a retryable error condition has occurred.
        var _retryAt; // The time to retry at in milliseconds from 1970/01/01 (this makes the timer calculation easy).
        var _lastSend; // The time of the last send operation.
        var _paused; // Flag indicating that the sending should be paused
        var _timeoutHandle; // Handle to the timer for delayed sending of batches of data.
        var _serializer;
        var _stamp_specific_redirects;
        var _headers;
        var _syncFetchPayload = 0; // Keep track of the outstanding sync fetch payload total (as sync fetch has limits)
        var _syncUnloadSender; // The identified sender to use for the synchronous unload stage
        var _offlineListener;
        var _evtNamespace;
        var _endpointUrl;
        var _orgEndpointUrl;
        var _maxBatchSizeInBytes;
        var _beaconSupported;
        var _customHeaders;
        var _disableTelemetry;
        var _instrumentationKey;
        var _convertUndefined;
        var _isRetryDisabled;
        var _maxBatchInterval;
        var _sessionStorageUsed;
        var _bufferOverrideUsed;
        var _namePrefix;
        var _enableSendPromise;
        var _alwaysUseCustomSend;
        var _disableXhr;
        var _fetchKeepAlive;
        var _xhrSend;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_15__["default"])(Sender, _this, function (_self, _base) {
            _initDefaults();
            _self.pause = function () {
                _clearScheduledTimer();
                _paused = true;
            };
            _self.resume = function () {
                if (_paused) {
                    _paused = false;
                    _retryAt = null;
                    // flush if we have exceeded the max-size already
                    _checkMaxSize();
                    _setupTimer();
                }
            };
            _self.flush = function (isAsync, callBack, sendReason) {
                if (isAsync === void 0) { isAsync = true; }
                if (!_paused) {
                    // Clear the normal schedule timer as we are going to try and flush ASAP
                    _clearScheduledTimer();
                    try {
                        return _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRIGGER_SEND /* @min:%2etriggerSend */](isAsync, null, sendReason || 1 /* SendRequestReason.ManualFlush */);
                    }
                    catch (e) {
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 1 /* eLoggingSeverity.CRITICAL */, 22 /* _eInternalMessageId.FlushFailed */, "flush failed, telemetry will not be collected: " + (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_17__.getExceptionName)(e), { exception: (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.dumpObj)(e) });
                    }
                }
            };
            _self.onunloadFlush = function () {
                if (!_paused) {
                    if (_beaconSupported || _alwaysUseCustomSend) {
                        try {
                            return _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRIGGER_SEND /* @min:%2etriggerSend */](true, _doUnloadSend, 2 /* SendRequestReason.Unload */);
                        }
                        catch (e) {
                            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 1 /* eLoggingSeverity.CRITICAL */, 20 /* _eInternalMessageId.FailedToSendQueuedTelemetry */, "failed to flush with beacon sender on page unload, telemetry will not be collected: " + (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_17__.getExceptionName)(e), { exception: (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.dumpObj)(e) });
                        }
                    }
                    else {
                        _self.flush(false);
                    }
                }
            };
            _self.addHeader = function (name, value) {
                _headers[name] = value;
            };
            _self.initialize = function (config, core, extensions, pluginChain) {
                if (_self.isInitialized()) {
                    (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 1 /* eLoggingSeverity.CRITICAL */, 28 /* _eInternalMessageId.SenderNotInitialized */, "Sender is already initialized");
                }
                _base.initialize(config, core, extensions, pluginChain);
                var identifier = _self.identifier;
                _serializer = new _Serializer__WEBPACK_IMPORTED_MODULE_19__.Serializer(core.logger);
                _consecutiveErrors = 0;
                _retryAt = null;
                _lastSend = 0;
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__SENDER /* @min:%2e_sender */] = null;
                _stamp_specific_redirects = 0;
                var diagLog = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */]();
                _evtNamespace = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_20__.mergeEvtNamespace)((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_21__.createUniqueNamespace)("Sender"), core.evtNamespace && core.evtNamespace());
                _offlineListener = (0,_Offline__WEBPACK_IMPORTED_MODULE_22__.createOfflineListener)(_evtNamespace);
                // This function will be re-called whenever any referenced configuration is changed
                _self._addHook((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__.onConfigChange)(config, function (details) {
                    var config = details.cfg;
                    if (config.storagePrefix) {
                        (0,_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_24__.utlSetStoragePrefix)(config.storagePrefix);
                    }
                    var ctx = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_25__.createProcessTelemetryContext)(null, config, core);
                    var senderConfig = ctx.getExtCfg(identifier, defaultAppInsightsChannelConfig);
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_26__.objDefine)(_self, "_senderConfig", {
                        g: function () {
                            return senderConfig;
                        }
                    });
                    // Only update the endpoint if the original config !== the current config
                    // This is so any redirect endpointUrl is not overwritten
                    if (_orgEndpointUrl !== senderConfig.endpointUrl) {
                        if (_orgEndpointUrl) {
                            // TODO: add doc to remind users to flush before changing endpoint, otherwise all unsent payload will be sent to new endpoint
                        }
                        _endpointUrl = _orgEndpointUrl = senderConfig.endpointUrl;
                    }
                    if (_customHeaders && _customHeaders !== senderConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CUSTOM_HEADERS /* @min:%2ecustomHeaders */]) {
                        // Removing any previously defined custom headers as they have changed
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_27__.arrForEach)(_customHeaders, function (customHeader) {
                            delete _headers[customHeader.header];
                        });
                    }
                    _maxBatchSizeInBytes = senderConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MAX_BATCH_SIZE_IN_BY1 /* @min:%2emaxBatchSizeInBytes */];
                    _beaconSupported = (senderConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ONUNLOAD_DISABLE_BEA2 /* @min:%2eonunloadDisableBeacon */] === false || senderConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_IS_BEACON_API_DISABL3 /* @min:%2eisBeaconApiDisabled */] === false) && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_28__.isBeaconsSupported)();
                    _alwaysUseCustomSend = senderConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ALWAYS_USE_XHR_OVERR4 /* @min:%2ealwaysUseXhrOverride */];
                    _disableXhr = !!senderConfig.disableXhr;
                    var bufferOverride = senderConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_BUFFER_OVERRIDE /* @min:%2ebufferOverride */];
                    var canUseSessionStorage = !!senderConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ENABLE_SESSION_STORA5 /* @min:%2eenableSessionStorageBuffer */] &&
                        (!!bufferOverride || (0,_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_24__.utlCanUseSessionStorage)());
                    var namePrefix = senderConfig.namePrefix;
                    //Note: emitLineDelimitedJson and eventsLimitInMem is directly accessed via config in senderBuffer
                    //Therefore, if canUseSessionStorage is not changed, we do not need to re initialize a new one
                    var shouldUpdate = (canUseSessionStorage !== _sessionStorageUsed)
                        || (canUseSessionStorage && (_namePrefix !== namePrefix)) // prefixName is only used in session storage
                        || (canUseSessionStorage && (_bufferOverrideUsed !== bufferOverride));
                    if (_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__BUFFER /* @min:%2e_buffer */]) {
                        // case1 (Pre and Now enableSessionStorageBuffer settings are same)
                        // if namePrefix changes, transfer current buffer to new buffer
                        // else no action needed
                        //case2 (Pre and Now enableSessionStorageBuffer settings are changed)
                        // transfer current buffer to new buffer
                        if (shouldUpdate) {
                            try {
                                _self._buffer = _self._buffer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CREATE_NEW /* @min:%2ecreateNew */](diagLog, senderConfig, canUseSessionStorage);
                            }
                            catch (e) {
                                (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 1 /* eLoggingSeverity.CRITICAL */, 12 /* _eInternalMessageId.FailedAddingTelemetryToBuffer */, "failed to transfer telemetry to different buffer storage, telemetry will be lost: " + (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_17__.getExceptionName)(e), { exception: (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.dumpObj)(e) });
                            }
                        }
                        _checkMaxSize();
                    }
                    else {
                        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__BUFFER /* @min:%2e_buffer */] = canUseSessionStorage
                            ? new _SendBuffer__WEBPACK_IMPORTED_MODULE_29__.SessionStorageSendBuffer(diagLog, senderConfig) : new _SendBuffer__WEBPACK_IMPORTED_MODULE_29__.ArraySendBuffer(diagLog, senderConfig);
                    }
                    _namePrefix = namePrefix;
                    _sessionStorageUsed = canUseSessionStorage;
                    _bufferOverrideUsed = bufferOverride;
                    _fetchKeepAlive = !senderConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ONUNLOAD_DISABLE_FET6 /* @min:%2eonunloadDisableFetch */] && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_28__.isFetchSupported)(true);
                    _self._sample = new _TelemetryProcessors_Sample__WEBPACK_IMPORTED_MODULE_30__.Sample(senderConfig.samplingPercentage, diagLog);
                    _instrumentationKey = senderConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_INSTRUMENTATION_KEY /* @min:%2einstrumentationKey */];
                    if (!_validateInstrumentationKey(_instrumentationKey, config)) {
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(diagLog, 1 /* eLoggingSeverity.CRITICAL */, 100 /* _eInternalMessageId.InvalidInstrumentationKey */, "Invalid Instrumentation key " + _instrumentationKey);
                    }
                    _customHeaders = senderConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CUSTOM_HEADERS /* @min:%2ecustomHeaders */];
                    if (!(0,_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_31__.isInternalApplicationInsightsEndpoint)(_endpointUrl) && _customHeaders && _customHeaders[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 0) {
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_27__.arrForEach)(_customHeaders, function (customHeader) {
                            _this.addHeader(customHeader.header, customHeader.value);
                        });
                    }
                    else {
                        _customHeaders = null;
                    }
                    _enableSendPromise = senderConfig.enableSendPromise;
                    var customInterface = senderConfig.httpXHROverride;
                    var httpInterface = null;
                    var syncInterface = null;
                    httpInterface = _getSenderInterface([1 /* TransportType.Xhr */, 2 /* TransportType.Fetch */], false);
                    var xhrInterface = { sendPOST: _xhrSender };
                    _xhrSend = function (payload, isAsync) {
                        return _doSend(xhrInterface, payload, isAsync);
                    };
                    if (!senderConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_IS_BEACON_API_DISABL3 /* @min:%2eisBeaconApiDisabled */] && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_28__.isBeaconsSupported)()) {
                        // Config is set to always used beacon sending
                        httpInterface = _getSenderInterface([3 /* TransportType.Beacon */], false);
                    }
                    httpInterface = _alwaysUseCustomSend ? customInterface : (httpInterface || customInterface || xhrInterface);
                    _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__SENDER /* @min:%2e_sender */] = function (payload, isAsync) {
                        return _doSend(httpInterface, payload, isAsync);
                    };
                    if (_fetchKeepAlive) {
                        // Try and use the fetch with keepalive
                        _syncUnloadSender = _fetchKeepAliveSender;
                    }
                    syncInterface = _alwaysUseCustomSend ? customInterface : (_getSenderInterface([3 /* TransportType.Beacon */, 1 /* TransportType.Xhr */], true) || customInterface);
                    if ((_alwaysUseCustomSend || !_syncUnloadSender) && syncInterface) {
                        _syncUnloadSender = function (payload, isAsync) {
                            return _doSend(syncInterface, payload, isAsync);
                        };
                    }
                    if (!_syncUnloadSender) {
                        _syncUnloadSender = _xhrSend;
                    }
                    _disableTelemetry = senderConfig.disableTelemetry;
                    _convertUndefined = senderConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CONVERT_UNDEFINED /* @min:%2econvertUndefined */] || UNDEFINED_VALUE;
                    _isRetryDisabled = senderConfig.isRetryDisabled;
                    _maxBatchInterval = senderConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MAX_BATCH_INTERVAL /* @min:%2emaxBatchInterval */];
                }));
            };
            _self.processTelemetry = function (telemetryItem, itemCtx) {
                itemCtx = _self._getTelCtx(itemCtx);
                var diagLogger = itemCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */]();
                try {
                    // if master off switch is set, don't send any data
                    if (_disableTelemetry) {
                        // Do not send/save data
                        return;
                    }
                    // validate input
                    if (!telemetryItem) {
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(diagLogger, 1 /* eLoggingSeverity.CRITICAL */, 7 /* _eInternalMessageId.CannotSendEmptyTelemetry */, "Cannot send empty telemetry");
                        return;
                    }
                    // validate event
                    if (telemetryItem.baseData && !telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_BASE_TYPE /* @min:%2ebaseType */]) {
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(diagLogger, 1 /* eLoggingSeverity.CRITICAL */, 70 /* _eInternalMessageId.InvalidEvent */, "Cannot send telemetry without baseData and baseType");
                        return;
                    }
                    if (!telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_BASE_TYPE /* @min:%2ebaseType */]) {
                        // Default
                        telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_BASE_TYPE /* @min:%2ebaseType */] = "EventData";
                    }
                    // ensure a sender was constructed
                    if (!_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__SENDER /* @min:%2e_sender */]) {
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(diagLogger, 1 /* eLoggingSeverity.CRITICAL */, 28 /* _eInternalMessageId.SenderNotInitialized */, "Sender was not initialized");
                        return;
                    }
                    // check if this item should be sampled in, else add sampleRate tag
                    if (!_isSampledIn(telemetryItem)) {
                        // Item is sampled out, do not send it
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(diagLogger, 2 /* eLoggingSeverity.WARNING */, 33 /* _eInternalMessageId.TelemetrySampledAndNotSent */, "Telemetry item was sampled out and not sent", { SampleRate: _self._sample[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SAMPLE_RATE /* @min:%2esampleRate */] });
                        return;
                    }
                    else {
                        telemetryItem[_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_4__.SampleRate] = _self._sample[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SAMPLE_RATE /* @min:%2esampleRate */];
                    }
                    // construct an envelope that Application Insights endpoint can understand
                    // if ikey of telemetry is provided and not empty, envelope will use this iKey instead of senderConfig iKey
                    var defaultEnvelopeIkey = telemetryItem.iKey || _instrumentationKey;
                    var aiEnvelope_1 = Sender.constructEnvelope(telemetryItem, defaultEnvelopeIkey, diagLogger, _convertUndefined);
                    if (!aiEnvelope_1) {
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(diagLogger, 1 /* eLoggingSeverity.CRITICAL */, 47 /* _eInternalMessageId.CreateEnvelopeError */, "Unable to create an AppInsights envelope");
                        return;
                    }
                    var doNotSendItem_1 = false;
                    // this is for running in legacy mode, where customer may already have a custom initializer present
                    if (telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TAGS /* @min:%2etags */] && telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TAGS /* @min:%2etags */][_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_4__.ProcessLegacy]) {
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_27__.arrForEach)(telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TAGS /* @min:%2etags */][_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_4__.ProcessLegacy], function (callBack) {
                            try {
                                if (callBack && callBack(aiEnvelope_1) === false) {
                                    doNotSendItem_1 = true;
                                    (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._warnToConsole)(diagLogger, "Telemetry processor check returns false");
                                }
                            }
                            catch (e) {
                                // log error but dont stop executing rest of the telemetry initializers
                                // doNotSendItem = true;
                                (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(diagLogger, 1 /* eLoggingSeverity.CRITICAL */, 64 /* _eInternalMessageId.TelemetryInitializerFailed */, "One of telemetry initializers failed, telemetry item will not be sent: " + (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_17__.getExceptionName)(e), { exception: (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.dumpObj)(e) }, true);
                            }
                        });
                        delete telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TAGS /* @min:%2etags */][_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_4__.ProcessLegacy];
                    }
                    if (doNotSendItem_1) {
                        return; // do not send, no need to execute next plugin
                    }
                    // check if the incoming payload is too large, truncate if necessary
                    var payload = _serializer.serialize(aiEnvelope_1);
                    // flush if we would exceed the max-size limit by adding this item
                    var buffer = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__BUFFER /* @min:%2e_buffer */];
                    _checkMaxSize(payload);
                    // enqueue the payload
                    buffer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ENQUEUE /* @min:%2eenqueue */](payload);
                    // ensure an invocation timeout is set
                    _setupTimer();
                }
                catch (e) {
                    (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(diagLogger, 2 /* eLoggingSeverity.WARNING */, 12 /* _eInternalMessageId.FailedAddingTelemetryToBuffer */, "Failed adding telemetry to the sender's buffer, some telemetry will be lost: " + (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_17__.getExceptionName)(e), { exception: (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.dumpObj)(e) });
                }
                // hand off the telemetry item to the next plugin
                _self.processNext(telemetryItem, itemCtx);
            };
            /**
             * xhr state changes
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__XHR_READY_STATE_CHA7 /* @min:%2e_xhrReadyStateChange */] = function (xhr, payload, countOfItemsInPayload) {
                if (xhr.readyState === 4) {
                    _checkResponsStatus(xhr.status, payload, xhr.responseURL, countOfItemsInPayload, _formatErrorMessageXhr(xhr), _getResponseText(xhr) || xhr.response);
                }
            };
            /**
             * Immediately send buffered data
             * @param async - {boolean} - Indicates if the events should be sent asynchronously
             * @param forcedSender - {SenderFunction} - Indicates the forcedSender, undefined if not passed
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRIGGER_SEND /* @min:%2etriggerSend */] = function (async, forcedSender, sendReason) {
                if (async === void 0) { async = true; }
                var result;
                if (!_paused) {
                    try {
                        var buffer = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__BUFFER /* @min:%2e_buffer */];
                        // Send data only if disableTelemetry is false
                        if (!_disableTelemetry) {
                            if (buffer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_COUNT /* @min:%2ecount */]() > 0) {
                                var payload = buffer.getItems();
                                _notifySendRequest(sendReason || 0 /* SendRequestReason.Undefined */, async);
                                // invoke send
                                if (forcedSender) {
                                    result = forcedSender.call(_self, payload, async);
                                }
                                else {
                                    result = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__SENDER /* @min:%2e_sender */](payload, async);
                                }
                            }
                            // update lastSend time to enable throttling
                            _lastSend = +new Date;
                        }
                        else {
                            buffer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CLEAR /* @min:%2eclear */]();
                        }
                        _clearScheduledTimer();
                    }
                    catch (e) {
                        /* Ignore this error for IE under v10 */
                        var ieVer = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_28__.getIEVersion)();
                        if (!ieVer || ieVer > 9) {
                            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 1 /* eLoggingSeverity.CRITICAL */, 40 /* _eInternalMessageId.TransmissionFailed */, "Telemetry transmission failed, some telemetry will be lost: " + (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_17__.getExceptionName)(e), { exception: (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.dumpObj)(e) });
                        }
                    }
                }
                return result;
            };
            _self._doTeardown = function (unloadCtx, unloadState) {
                _self.onunloadFlush();
                (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_32__.runTargetUnload)(_offlineListener, false);
                _initDefaults();
            };
            /**
             * error handler
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__ON_ERROR /* @min:%2e_onError */] = function (payload, message, event) {
                (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 2 /* eLoggingSeverity.WARNING */, 26 /* _eInternalMessageId.OnError */, "Failed to send telemetry.", { message: message });
                _self._buffer && _self._buffer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CLEAR_SENT /* @min:%2eclearSent */](payload);
            };
            /**
             * partial success handler
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__ON_PARTIAL_SUCCESS /* @min:%2e_onPartialSuccess */] = function (payload, results) {
                var failed = [];
                var retry = [];
                // Iterate through the reversed array of errors so that splicing doesn't have invalid indexes after the first item.
                var errors = results.errors.reverse();
                for (var _i = 0, errors_1 = errors; _i < errors_1.length; _i++) {
                    var error = errors_1[_i];
                    var extracted = payload.splice(error.index, 1)[0];
                    if (_isRetriable(error.statusCode)) {
                        retry[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PUSH /* @min:%2epush */](extracted);
                    }
                    else {
                        // All other errors, including: 402 (Monthly quota exceeded) and 439 (Too many requests and refresh cache).
                        failed[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PUSH /* @min:%2epush */](extracted);
                    }
                }
                if (payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__ON_SUCCESS /* @min:%2e_onSuccess */](payload, results[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ITEMS_ACCEPTED /* @min:%2eitemsAccepted */]);
                }
                if (failed[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__ON_ERROR /* @min:%2e_onError */](failed, _formatErrorMessageXhr(null, ["partial success", results[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ITEMS_ACCEPTED /* @min:%2eitemsAccepted */], "of", results.itemsReceived].join(" ")));
                }
                if (retry[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    _resendPayload(retry);
                    (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 2 /* eLoggingSeverity.WARNING */, 40 /* _eInternalMessageId.TransmissionFailed */, "Partial success. " +
                        "Delivered: " + payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] + ", Failed: " + failed[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] +
                        ". Will retry to send " + retry[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] + " our of " + results[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ITEMS_RECEIVED /* @min:%2eitemsReceived */] + " items");
                }
            };
            /**
             * success handler
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__ON_SUCCESS /* @min:%2e_onSuccess */] = function (payload, countOfItemsInPayload) {
                _self._buffer && _self._buffer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CLEAR_SENT /* @min:%2eclearSent */](payload);
            };
            /**
             * xdr state changes
             */
            _self._xdrOnLoad = function (xdr, payload) {
                var responseText = _getResponseText(xdr);
                if (xdr && (responseText + "" === "200" || responseText === "")) {
                    _consecutiveErrors = 0;
                    _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__ON_SUCCESS /* @min:%2e_onSuccess */](payload, 0);
                }
                else {
                    var results = _parseResponse(responseText);
                    if (results && results.itemsReceived && results.itemsReceived > results[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ITEMS_ACCEPTED /* @min:%2eitemsAccepted */]
                        && !_isRetryDisabled) {
                        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__ON_PARTIAL_SUCCESS /* @min:%2e_onPartialSuccess */](payload, results);
                    }
                    else {
                        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__ON_ERROR /* @min:%2e_onError */](payload, _formatErrorMessageXdr(xdr));
                    }
                }
            };
            function _isSampledIn(envelope) {
                return _self._sample.isSampledIn(envelope);
            }
            function _getSenderInterface(transports, syncSupport) {
                var _a;
                var transportType = null;
                var sendPostFunc = null;
                var lp = 0;
                while (sendPostFunc == null && lp < transports[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */]) {
                    transportType = transports[lp];
                    if (!_disableXhr && transportType === 1 /* TransportType.Xhr */) {
                        if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_28__.useXDomainRequest)()) {
                            // IE 8 and 9
                            sendPostFunc = _xdrSender;
                        }
                        else if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_28__.isXhrSupported)()) {
                            sendPostFunc = _xhrSender;
                        }
                    }
                    else if (transportType === 2 /* TransportType.Fetch */ && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_28__.isFetchSupported)(syncSupport)) {
                        sendPostFunc = _fetchSender;
                    }
                    else if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_28__.isBeaconsSupported)() && transportType === 3 /* TransportType.Beacon */) {
                        sendPostFunc = _beaconSender;
                    }
                    lp++;
                }
                if (sendPostFunc) {
                    return _a = {},
                        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SEND_POST /* @min:sendPOST */] = sendPostFunc,
                        _a;
                }
                return null;
            }
            function _getOnComplete(payload, status, headers, response) {
                // ***********************************************************************************************
                //TODO: handle other status codes
                if (status === 200 && payload) {
                    _self._onSuccess(payload, payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */]);
                }
                response && _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__ON_ERROR /* @min:%2e_onError */](payload, response);
            }
            function _doSend(sendInterface, payload, isAsync) {
                var onComplete = function (status, headers, response) {
                    return _getOnComplete(payload, status, headers, response);
                };
                var payloadData = _getPayload(payload);
                var sendPostFunc = sendInterface && sendInterface[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SEND_POST /* @min:%2esendPOST */];
                if (sendPostFunc && payloadData) {
                    // ***********************************************************************************************
                    // mark payload as sent at the beginning of calling each send function
                    _self._buffer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MARK_AS_SENT /* @min:%2emarkAsSent */](payload);
                    return sendPostFunc(payloadData, onComplete, !isAsync);
                }
                return null;
            }
            function _getPayload(payload) {
                var _a;
                if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isArray)(payload) && payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    var batch = _self._buffer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_BATCH_PAYLOADS /* @min:%2ebatchPayloads */](payload);
                    var payloadData = (_a = {},
                        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DATA /* @min:data */] = batch,
                        _a.urlString = _endpointUrl,
                        _a.headers = _headers,
                        _a.disableXhrSync = _disableXhr,
                        _a.disableFetchKeepAlive = !_fetchKeepAlive,
                        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ORI_PAYLOAD /* @min:oriPayload */] = payload,
                        _a);
                    return payloadData;
                }
                return null;
            }
            /**
             * Send fetch API request
             * @param payload - {string} - The data payload to be sent.
             * @param oncomplete - {function} on complete function
             * @param sync - {boolean} - not used
             */
            function _fetchSender(payload, oncomplete, sync) {
                return _doFetchSender(payload, oncomplete, false);
            }
            function _checkMaxSize(incomingPayload) {
                var incomingSize = incomingPayload ? incomingPayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] : 0;
                if ((_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__BUFFER /* @min:%2e_buffer */].size() + incomingSize) > _maxBatchSizeInBytes) {
                    if (!_offlineListener || _offlineListener[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_IS_ONLINE /* @min:%2eisOnline */]()) { // only trigger send when currently online
                        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRIGGER_SEND /* @min:%2etriggerSend */](true, null, 10 /* SendRequestReason.MaxBatchSize */);
                    }
                    return true;
                }
                return false;
            }
            function _checkResponsStatus(status, payload, responseUrl, countOfItemsInPayload, errorMessage, res) {
                var response = null;
                if (!_self._appId) {
                    response = _parseResponse(res);
                    if (response && response.appId) {
                        _self._appId = response.appId;
                    }
                }
                if ((status < 200 || status >= 300) && status !== 0) {
                    // Update End Point url if permanent redirect or moved permanently
                    // Updates the end point url before retry
                    if (status === 301 || status === 307 || status === 308) {
                        if (!_checkAndUpdateEndPointUrl(responseUrl)) {
                            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__ON_ERROR /* @min:%2e_onError */](payload, errorMessage);
                            return;
                        }
                    }
                    if (!_isRetryDisabled && _isRetriable(status)) {
                        _resendPayload(payload);
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 2 /* eLoggingSeverity.WARNING */, 40 /* _eInternalMessageId.TransmissionFailed */, ". " +
                            "Response code " + status + ". Will retry to send " + payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] + " items.");
                    }
                    else {
                        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__ON_ERROR /* @min:%2e_onError */](payload, errorMessage);
                    }
                }
                else if (_offlineListener && !_offlineListener[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_IS_ONLINE /* @min:%2eisOnline */]()) { // offline
                    // Note: Don't check for status == 0, since adblock gives this code
                    if (!_isRetryDisabled) {
                        var offlineBackOffMultiplier = 10; // arbritrary number
                        _resendPayload(payload, offlineBackOffMultiplier);
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 2 /* eLoggingSeverity.WARNING */, 40 /* _eInternalMessageId.TransmissionFailed */, ". Offline - Response Code: ".concat(status, ". Offline status: ").concat(!_offlineListener.isOnline(), ". Will retry to send ").concat(payload.length, " items."));
                    }
                }
                else {
                    // check if the xhr's responseURL or fetch's response.url is same as endpoint url
                    // TODO after 10 redirects force send telemetry with 'redirect=false' as query parameter.
                    _checkAndUpdateEndPointUrl(responseUrl);
                    if (status === 206) {
                        if (!response) {
                            response = _parseResponse(res);
                        }
                        if (response && !_isRetryDisabled) {
                            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__ON_PARTIAL_SUCCESS /* @min:%2e_onPartialSuccess */](payload, response);
                        }
                        else {
                            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__ON_ERROR /* @min:%2e_onError */](payload, errorMessage);
                        }
                    }
                    else {
                        _consecutiveErrors = 0;
                        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__ON_SUCCESS /* @min:%2e_onSuccess */](payload, countOfItemsInPayload);
                    }
                }
            }
            function _checkAndUpdateEndPointUrl(responseUrl) {
                // Maximum stamp specific redirects allowed(uncomment this when breeze is ready with not allowing redirects feature)
                if (_stamp_specific_redirects >= 10) {
                    //  _self._senderConfig.endpointUrl = () => Sender._getDefaultAppInsightsChannelConfig().endpointUrl()+"/?redirect=false";
                    //  _stamp_specific_redirects = 0;
                    return false;
                }
                if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(responseUrl) && responseUrl !== "") {
                    if (responseUrl !== _endpointUrl) {
                        _endpointUrl = responseUrl;
                        ++_stamp_specific_redirects;
                        return true;
                    }
                }
                return false;
            }
            function _doOnComplete(oncomplete, status, headers, response) {
                try {
                    oncomplete(status, headers, response);
                }
                catch (e) {
                    // eslint-disable-next-line no-empty
                }
            }
            function _doUnloadSend(payload, isAsync) {
                var onComplete = function (status, headers, response) {
                    return _getOnComplete(payload, status, headers, response);
                };
                if (_syncUnloadSender) {
                    // We are unloading so always call the sender with sync set to false
                    _syncUnloadSender(payload, false);
                }
                else {
                    // Fallback to the previous beacon Sender (which causes a CORB warning on chrome now)
                    var payloadData = _getPayload(payload);
                    _beaconSender(payloadData, onComplete, !isAsync);
                }
            }
            function _doBeaconSend(payload, oncomplete) {
                var nav = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_33__.getNavigator)();
                var url = _endpointUrl;
                // Chrome only allows CORS-safelisted values for the sendBeacon data argument
                // see: https://bugs.chromium.org/p/chromium/issues/detail?id=720283
                var plainTextBatch = new Blob([payload], { type: "text/plain;charset=UTF-8" });
                // The sendBeacon method returns true if the user agent is able to successfully queue the data for transfer. Otherwise it returns false.
                var queued = nav.sendBeacon(url, plainTextBatch);
                if (queued) {
                    oncomplete(200, {}, payload);
                }
                return queued;
            }
            /**
             * Send Beacon API request
             * @param payload - {string} - The data payload to be sent.
             * @param sync - {boolean} - not used
             * Note: Beacon API does not support custom headers and we are not able to get
             * appId from the backend for the correct correlation.
             */
            function _beaconSender(payload, oncomplete, sync) {
                var internalPayload = payload;
                var data = internalPayload && internalPayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DATA /* @min:%2edata */];
                if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isString)(data) && data[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    // The sendBeacon method returns true if the user agent is able to successfully queue the data for transfer. Otherwise it returns false.
                    if (!_doBeaconSend(data, oncomplete)) {
                        // Failed to send entire payload so try and split data and try to send as much events as possible
                        var droppedPayload = [];
                        var oriPayload = internalPayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ORI_PAYLOAD /* @min:%2eoriPayload */];
                        if (oriPayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 0) {
                            for (var lp = 0; lp < data[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */]; lp++) {
                                var thePayload = payload[lp];
                                var batch = _self._buffer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_BATCH_PAYLOADS /* @min:%2ebatchPayloads */](thePayload);
                                if (!_doBeaconSend(batch, oncomplete)) {
                                    // Can't send anymore, so split the batch and drop the rest
                                    droppedPayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PUSH /* @min:%2epush */](thePayload);
                                }
                            }
                        }
                        if (droppedPayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 0) {
                            _xhrSend && _xhrSend(droppedPayload, true);
                            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 2 /* eLoggingSeverity.WARNING */, 40 /* _eInternalMessageId.TransmissionFailed */, ". " + "Failed to send telemetry with Beacon API, retried with normal sender.");
                        }
                    }
                }
            }
            /**
             * Send XMLHttpRequest
             * @param payload - {string} - The data payload to be sent.
             * @param sync - {boolean} - Indicates if the request should be sent synchronously
             */
            function _xhrSender(payload, oncomplete, sync) {
                var internalPayload = payload;
                var thePromise;
                var resolveFunc;
                var rejectFunc;
                var xhr = new XMLHttpRequest();
                var endPointUrl = _endpointUrl;
                try {
                    xhr[_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_4__.DisabledPropertyName] = true;
                }
                catch (e) {
                    // If the environment has locked down the XMLHttpRequest (preventExtensions and/or freeze), this would
                    // cause the request to fail and we no telemetry would be sent
                }
                xhr.open("POST", endPointUrl, !sync);
                xhr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SET_REQUEST_HEADER /* @min:%2esetRequestHeader */]("Content-type", "application/json");
                // append Sdk-Context request header only in case of breeze endpoint
                if ((0,_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_31__.isInternalApplicationInsightsEndpoint)(endPointUrl)) {
                    xhr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SET_REQUEST_HEADER /* @min:%2esetRequestHeader */](_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_34__.RequestHeaders[6], _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_34__.RequestHeaders[7]);
                }
                (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_27__.arrForEach)((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objKeys)(_headers), function (headerName) {
                    xhr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SET_REQUEST_HEADER /* @min:%2esetRequestHeader */](headerName, _headers[headerName]);
                });
                xhr.onreadystatechange = function () {
                    var oriPayload = internalPayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ORI_PAYLOAD /* @min:%2eoriPayload */];
                    _self._xhrReadyStateChange(xhr, oriPayload, oriPayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */]);
                    if (xhr.readyState === 4) {
                        resolveFunc && resolveFunc(true);
                    }
                };
                xhr.onerror = function (event) {
                    _doOnComplete(oncomplete, 400, {}, _formatErrorMessageXhr(xhr));
                    rejectFunc && rejectFunc(event);
                };
                if (!sync && _enableSendPromise) {
                    thePromise = (0,_nevware21_ts_async__WEBPACK_IMPORTED_MODULE_35__.createPromise)(function (resolve, reject) {
                        resolveFunc = resolve;
                        rejectFunc = reject;
                    });
                }
                xhr.send(payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DATA /* @min:%2edata */]);
                return thePromise;
            }
            function _fetchKeepAliveSender(payload, isAsync) {
                var onComplete = function (status, headers, response) {
                    return _getOnComplete(payload, status, headers, response);
                };
                if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isArray)(payload)) {
                    var payloadSize = payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */];
                    for (var lp = 0; lp < payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */]; lp++) {
                        payloadSize += payload[lp][_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */];
                    }
                    var payloadData = _getPayload(payload);
                    if ((_syncFetchPayload + payloadSize) <= FetchSyncRequestSizeLimitBytes) {
                        _doFetchSender(payloadData, onComplete, true);
                    }
                    else if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_28__.isBeaconsSupported)()) {
                        // Fallback to beacon sender as we at least get told which events can't be scheduled
                        _beaconSender(payloadData, onComplete, !isAsync);
                    }
                    else {
                        // Payload is going to be too big so just try and send via XHR
                        _xhrSend && _xhrSend(payload, true);
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 2 /* eLoggingSeverity.WARNING */, 40 /* _eInternalMessageId.TransmissionFailed */, ". " + "Failed to send telemetry with Beacon API, retried with xhrSender.");
                    }
                }
            }
            /**
             * Send fetch API request
             * @param payload - {string} - The data payload to be sent.
             * @param sync - {boolean} - For fetch this identifies whether we are "unloading" (false) or a normal request
             */
            function _doFetchSender(payload, oncomplete, sync) {
                var _a;
                var endPointUrl = _endpointUrl;
                var internalPayload = payload;
                var batch = internalPayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DATA /* @min:%2edata */];
                var plainTextBatch = new Blob([batch], { type: "application/json" });
                var thePromise;
                var resolveFunc;
                var rejectFunc;
                var requestHeaders = new Headers();
                var batchLength = batch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */];
                var ignoreResponse = false;
                var responseHandled = false;
                // append Sdk-Context request header only in case of breeze endpoint
                if ((0,_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_31__.isInternalApplicationInsightsEndpoint)(endPointUrl)) {
                    requestHeaders.append(_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_34__.RequestHeaders[6], _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_34__.RequestHeaders[7]);
                }
                (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_27__.arrForEach)((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objKeys)(_headers), function (headerName) {
                    requestHeaders.append(headerName, _headers[headerName]);
                });
                var init = (_a = {
                        method: "POST",
                        headers: requestHeaders,
                        body: plainTextBatch
                    },
                    _a[_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_4__.DisabledPropertyName] = true // Mark so we don't attempt to track this request
                ,
                    _a);
                if (sync) {
                    init.keepalive = true;
                    // As a sync request (during unload), it is unlikely that we will get a chance to process the response so
                    // just like beacon send assume that the events have been accepted and processed
                    ignoreResponse = true;
                    _syncFetchPayload += batchLength;
                }
                var request = new Request(endPointUrl, init);
                try {
                    // Also try and tag the request (just in case the value in init is not copied over)
                    request[_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_4__.DisabledPropertyName] = true;
                }
                catch (e) {
                    // If the environment has locked down the XMLHttpRequest (preventExtensions and/or freeze), this would
                    // cause the request to fail and we no telemetry would be sent
                }
                if (!sync && _enableSendPromise) {
                    thePromise = (0,_nevware21_ts_async__WEBPACK_IMPORTED_MODULE_35__.createPromise)(function (resolve, reject) {
                        resolveFunc = resolve;
                        rejectFunc = reject;
                    });
                }
                try {
                    (0,_nevware21_ts_async__WEBPACK_IMPORTED_MODULE_36__.doAwaitResponse)(fetch(request), function (result) {
                        if (sync) {
                            _syncFetchPayload -= batchLength;
                            batchLength = 0;
                        }
                        if (!responseHandled) {
                            responseHandled = true;
                            if (!result.rejected) {
                                var response_1 = result.value;
                                /**
                                 * The Promise returned from fetch() won’t reject on HTTP error status even if the response is an HTTP 404 or 500.
                                 * Instead, it will resolve normally (with ok status set to false), and it will only reject on network failure
                                 * or if anything prevented the request from completing.
                                 */
                                if (!response_1.ok) {
                                    _doOnComplete(oncomplete, 400, {}, response_1.statusText);
                                    resolveFunc && resolveFunc(false);
                                }
                                else {
                                    (0,_nevware21_ts_async__WEBPACK_IMPORTED_MODULE_36__.doAwaitResponse)(response_1.text(), function (resp) {
                                        var oriPayload = internalPayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ORI_PAYLOAD /* @min:%2eoriPayload */];
                                        _checkResponsStatus(response_1.status, oriPayload, response_1.url, oriPayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */], response_1.statusText, resp.value || "");
                                        resolveFunc && resolveFunc(true);
                                    });
                                }
                            }
                            else {
                                _doOnComplete(oncomplete, 400, {}, result.reason && result.reason.message);
                                rejectFunc && rejectFunc(result.reason);
                            }
                        }
                    });
                }
                catch (e) {
                    if (!responseHandled) {
                        _doOnComplete(oncomplete, 400, {}, (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.dumpObj)(e));
                        rejectFunc && rejectFunc(e);
                    }
                }
                if (ignoreResponse && !responseHandled) {
                    // Assume success during unload processing as we most likely won't get the response
                    responseHandled = true;
                    _doOnComplete(oncomplete, 200, {});
                    resolveFunc && resolveFunc(true);
                }
                return thePromise;
            }
            /**
             * Parses the response from the backend.
             * @param response - XMLHttpRequest or XDomainRequest response
             */
            function _parseResponse(response) {
                try {
                    if (response && response !== "") {
                        var result = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_28__.getJSON)().parse(response);
                        if (result && result.itemsReceived && result.itemsReceived >= result[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ITEMS_ACCEPTED /* @min:%2eitemsAccepted */] &&
                            result.itemsReceived - result.itemsAccepted === result.errors[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */]) {
                            return result;
                        }
                    }
                }
                catch (e) {
                    (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 1 /* eLoggingSeverity.CRITICAL */, 43 /* _eInternalMessageId.InvalidBackendResponse */, "Cannot parse the response. " + (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_17__.getExceptionName)(e), {
                        response: response
                    });
                }
                return null;
            }
            /**
             * Resend payload. Adds payload back to the send buffer and setup a send timer (with exponential backoff).
             * @param payload
             */
            function _resendPayload(payload, linearFactor) {
                if (linearFactor === void 0) { linearFactor = 1; }
                if (!payload || payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] === 0) {
                    return;
                }
                var buffer = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__BUFFER /* @min:%2e_buffer */];
                buffer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CLEAR_SENT /* @min:%2eclearSent */](payload);
                _consecutiveErrors++;
                for (var _i = 0, payload_1 = payload; _i < payload_1.length; _i++) {
                    var item = payload_1[_i];
                    buffer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ENQUEUE /* @min:%2eenqueue */](item);
                }
                // setup timer
                _setRetryTime(linearFactor);
                _setupTimer();
            }
            /**
             * Calculates the time to wait before retrying in case of an error based on
             * http://en.wikipedia.org/wiki/Exponential_backoff
             */
            function _setRetryTime(linearFactor) {
                var SlotDelayInSeconds = 10;
                var delayInSeconds;
                if (_consecutiveErrors <= 1) {
                    delayInSeconds = SlotDelayInSeconds;
                }
                else {
                    var backOffSlot = (Math.pow(2, _consecutiveErrors) - 1) / 2;
                    // tslint:disable-next-line:insecure-random
                    var backOffDelay = Math.floor(Math.random() * backOffSlot * SlotDelayInSeconds) + 1;
                    backOffDelay = linearFactor * backOffDelay;
                    delayInSeconds = Math.max(Math.min(backOffDelay, 3600), SlotDelayInSeconds);
                }
                // TODO: Log the backoff time like the C# version does.
                var retryAfterTimeSpan = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_37__.utcNow)() + (delayInSeconds * 1000);
                // TODO: Log the retry at time like the C# version does.
                _retryAt = retryAfterTimeSpan;
            }
            /**
             * Sets up the timer which triggers actually sending the data.
             */
            function _setupTimer() {
                if (!_timeoutHandle && !_paused) {
                    var retryInterval = _retryAt ? Math.max(0, _retryAt - (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_37__.utcNow)()) : 0;
                    var timerValue = Math.max(_maxBatchInterval, retryInterval);
                    _timeoutHandle = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_38__.scheduleTimeout)(function () {
                        _timeoutHandle = null;
                        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRIGGER_SEND /* @min:%2etriggerSend */](true, null, 1 /* SendRequestReason.NormalSchedule */);
                    }, timerValue);
                }
            }
            function _clearScheduledTimer() {
                _timeoutHandle && _timeoutHandle.cancel();
                _timeoutHandle = null;
                _retryAt = null;
            }
            /**
             * Checks if the SDK should resend the payload after receiving this status code from the backend.
             * @param statusCode
             */
            function _isRetriable(statusCode) {
                return statusCode === 401 // Unauthorized
                    || statusCode === 403 // Forbidden
                    || statusCode === 408 // Timeout
                    || statusCode === 429 // Too many requests.
                    || statusCode === 500 // Internal server error.
                    || statusCode === 502 // Bad Gateway.
                    || statusCode === 503 // Service unavailable.
                    || statusCode === 504; // Gateway timeout.
            }
            function _formatErrorMessageXhr(xhr, message) {
                if (xhr) {
                    return "XMLHttpRequest,Status:" + xhr.status + ",Response:" + _getResponseText(xhr) || 0 || 0;
                }
                return message;
            }
            /**
             * Send XDomainRequest
             * @param payload - {string} - The data payload to be sent.
             * @param sync - {boolean} - Indicates if the request should be sent synchronously
             *
             * Note: XDomainRequest does not support sync requests. This 'isAsync' parameter is added
             * to maintain consistency with the xhrSender's contract
             * Note: XDomainRequest does not support custom headers and we are not able to get
             * appId from the backend for the correct correlation.
             */
            function _xdrSender(payload, oncomplete, sync) {
                var internalPayload = payload;
                var _window = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_33__.getWindow)();
                var xdr = new XDomainRequest();
                var data = internalPayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DATA /* @min:%2edata */];
                // NOTE: xdr may send previous retry payload to new endpoint since we are not able to check response URL
                xdr.onload = function () {
                    var oriPayload = internalPayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ORI_PAYLOAD /* @min:%2eoriPayload */];
                    // we will assume onload means the request succeeded.
                    _self._xdrOnLoad(xdr, oriPayload);
                };
                xdr.onerror = function () {
                    _doOnComplete(oncomplete, 400, {}, _formatErrorMessageXdr(xdr));
                };
                // XDomainRequest requires the same protocol as the hosting page.
                // If the protocol doesn't match, we can't send the telemetry :(.
                var hostingProtocol = _window && _window.location && _window.location.protocol || "";
                if (_endpointUrl.lastIndexOf(hostingProtocol, 0) !== 0) {
                    (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 2 /* eLoggingSeverity.WARNING */, 40 /* _eInternalMessageId.TransmissionFailed */, ". " +
                        "Cannot send XDomain request. The endpoint URL protocol doesn't match the hosting page protocol.");
                    _self._buffer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CLEAR /* @min:%2eclear */]();
                    return;
                }
                var endpointUrl = _endpointUrl.replace(/^(https?:)/, "");
                xdr.open("POST", endpointUrl);
                xdr.send(data);
            }
            function _formatErrorMessageXdr(xdr, message) {
                if (xdr) {
                    return "XDomainRequest,Response:" + _getResponseText(xdr) || 0;
                }
                return message;
            }
            // Using function lookups for backward compatibility as the getNotifyMgr() did not exist until after v2.5.6
            function _getNotifyMgr() {
                var func = "getNotifyMgr";
                if (_self.core[func]) {
                    return _self.core[func]();
                }
                // using _self.core['_notificationManager'] for backward compatibility
                return _self.core["_notificationManager"];
            }
            function _notifySendRequest(sendRequest, isAsync) {
                var manager = _getNotifyMgr();
                if (manager && manager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_EVENTS_SEND_REQUEST /* @min:%2eeventsSendRequest */]) {
                    try {
                        manager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_EVENTS_SEND_REQUEST /* @min:%2eeventsSendRequest */](sendRequest, isAsync);
                    }
                    catch (e) {
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__._throwInternal)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 1 /* eLoggingSeverity.CRITICAL */, 74 /* _eInternalMessageId.NotificationException */, "send request notification failed: " + (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_17__.getExceptionName)(e), { exception: (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.dumpObj)(e) });
                    }
                }
            }
            /**
             * Validate UUID Format
             * Specs taken from https://tools.ietf.org/html/rfc4122 and breeze repo
             */
            function _validateInstrumentationKey(instrumentationKey, config) {
                var disableValidation = config.disableInstrumentationKeyValidation;
                var disableIKeyValidationFlag = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(disableValidation) ? false : disableValidation;
                if (disableIKeyValidationFlag) {
                    return true;
                }
                var UUID_Regex = "^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$";
                var regexp = new RegExp(UUID_Regex);
                return regexp.test(instrumentationKey);
            }
            function _initDefaults() {
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__SENDER /* @min:%2e_sender */] = null;
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN__BUFFER /* @min:%2e_buffer */] = null;
                _self._appId = null;
                _self._sample = null;
                _headers = {};
                _offlineListener = null;
                _consecutiveErrors = 0;
                _retryAt = null;
                _lastSend = null;
                _paused = false;
                _timeoutHandle = null;
                _serializer = null;
                _stamp_specific_redirects = 0;
                _syncFetchPayload = 0;
                _syncUnloadSender = null;
                _evtNamespace = null;
                _endpointUrl = null;
                _orgEndpointUrl = null;
                _maxBatchSizeInBytes = 0;
                _beaconSupported = false;
                _customHeaders = null;
                _disableTelemetry = false;
                _instrumentationKey = null;
                _convertUndefined = UNDEFINED_VALUE;
                _isRetryDisabled = false;
                _sessionStorageUsed = null;
                _namePrefix = UNDEFINED_VALUE;
                _disableXhr = false;
                _fetchKeepAlive = false;
                _xhrSend = null;
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_26__.objDefine)(_self, "_senderConfig", {
                    g: function () {
                        return (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_17__.objExtend)({}, defaultAppInsightsChannelConfig);
                    }
                });
            }
        });
        return _this;
    }
    Sender.constructEnvelope = function (orig, iKey, logger, convertUndefined) {
        var envelope;
        if (iKey !== orig.iKey && !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(iKey)) {
            envelope = (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_13__.__assignFn)((0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_13__.__assignFn)({}, orig), { iKey: iKey });
        }
        else {
            envelope = orig;
        }
        var creator = EnvelopeTypeCreator[envelope.baseType] || _EnvelopeCreator__WEBPACK_IMPORTED_MODULE_6__.EventEnvelopeCreator;
        return creator(logger, envelope, convertUndefined);
    };
// Removed Stub for Sender.prototype.pause.
// Removed Stub for Sender.prototype.resume.
// Removed Stub for Sender.prototype.flush.
// Removed Stub for Sender.prototype.onunloadFlush.
// Removed Stub for Sender.prototype.initialize.
// Removed Stub for Sender.prototype.processTelemetry.
// Removed Stub for Sender.prototype._xhrReadyStateChange.
// Removed Stub for Sender.prototype.triggerSend.
// Removed Stub for Sender.prototype._onError.
// Removed Stub for Sender.prototype._onPartialSuccess.
// Removed Stub for Sender.prototype._onSuccess.
// Removed Stub for Sender.prototype._xdrOnLoad.
// Removed Stub for Sender.prototype.addHeader.
    return Sender;
}(_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_39__.BaseTelemetryPlugin));

//# sourceMappingURL=Sender.js.map

/***/ }),
/* 133 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_DYN_ALWAYS_USE_XHR_OVERR4": () => (/* binding */ _DYN_ALWAYS_USE_XHR_OVERR4),
/* harmony export */   "_DYN_BASE_TYPE": () => (/* binding */ _DYN_BASE_TYPE),
/* harmony export */   "_DYN_BATCH_PAYLOADS": () => (/* binding */ _DYN_BATCH_PAYLOADS),
/* harmony export */   "_DYN_BUFFER_OVERRIDE": () => (/* binding */ _DYN_BUFFER_OVERRIDE),
/* harmony export */   "_DYN_CLEAR": () => (/* binding */ _DYN_CLEAR),
/* harmony export */   "_DYN_CLEAR_SENT": () => (/* binding */ _DYN_CLEAR_SENT),
/* harmony export */   "_DYN_CONVERT_UNDEFINED": () => (/* binding */ _DYN_CONVERT_UNDEFINED),
/* harmony export */   "_DYN_COUNT": () => (/* binding */ _DYN_COUNT),
/* harmony export */   "_DYN_CREATE_NEW": () => (/* binding */ _DYN_CREATE_NEW),
/* harmony export */   "_DYN_CUSTOM_HEADERS": () => (/* binding */ _DYN_CUSTOM_HEADERS),
/* harmony export */   "_DYN_DATA": () => (/* binding */ _DYN_DATA),
/* harmony export */   "_DYN_DATA_TYPE": () => (/* binding */ _DYN_DATA_TYPE),
/* harmony export */   "_DYN_DEVICE_TYPE": () => (/* binding */ _DYN_DEVICE_TYPE),
/* harmony export */   "_DYN_DIAG_LOG": () => (/* binding */ _DYN_DIAG_LOG),
/* harmony export */   "_DYN_EMIT_LINE_DELIMITED_0": () => (/* binding */ _DYN_EMIT_LINE_DELIMITED_0),
/* harmony export */   "_DYN_ENABLE_SESSION_STORA5": () => (/* binding */ _DYN_ENABLE_SESSION_STORA5),
/* harmony export */   "_DYN_ENQUEUE": () => (/* binding */ _DYN_ENQUEUE),
/* harmony export */   "_DYN_ENVELOPE_TYPE": () => (/* binding */ _DYN_ENVELOPE_TYPE),
/* harmony export */   "_DYN_EVENTS_LIMIT_IN_MEM": () => (/* binding */ _DYN_EVENTS_LIMIT_IN_MEM),
/* harmony export */   "_DYN_EVENTS_SEND_REQUEST": () => (/* binding */ _DYN_EVENTS_SEND_REQUEST),
/* harmony export */   "_DYN_GET_HASH_CODE_SCORE": () => (/* binding */ _DYN_GET_HASH_CODE_SCORE),
/* harmony export */   "_DYN_GET_SAMPLING_SCORE": () => (/* binding */ _DYN_GET_SAMPLING_SCORE),
/* harmony export */   "_DYN_INSTRUMENTATION_KEY": () => (/* binding */ _DYN_INSTRUMENTATION_KEY),
/* harmony export */   "_DYN_IS_BEACON_API_DISABL3": () => (/* binding */ _DYN_IS_BEACON_API_DISABL3),
/* harmony export */   "_DYN_IS_ONLINE": () => (/* binding */ _DYN_IS_ONLINE),
/* harmony export */   "_DYN_ITEMS_ACCEPTED": () => (/* binding */ _DYN_ITEMS_ACCEPTED),
/* harmony export */   "_DYN_ITEMS_RECEIVED": () => (/* binding */ _DYN_ITEMS_RECEIVED),
/* harmony export */   "_DYN_LENGTH": () => (/* binding */ _DYN_LENGTH),
/* harmony export */   "_DYN_MARK_AS_SENT": () => (/* binding */ _DYN_MARK_AS_SENT),
/* harmony export */   "_DYN_MAX_BATCH_INTERVAL": () => (/* binding */ _DYN_MAX_BATCH_INTERVAL),
/* harmony export */   "_DYN_MAX_BATCH_SIZE_IN_BY1": () => (/* binding */ _DYN_MAX_BATCH_SIZE_IN_BY1),
/* harmony export */   "_DYN_MEASUREMENTS": () => (/* binding */ _DYN_MEASUREMENTS),
/* harmony export */   "_DYN_NAME": () => (/* binding */ _DYN_NAME),
/* harmony export */   "_DYN_ONUNLOAD_DISABLE_BEA2": () => (/* binding */ _DYN_ONUNLOAD_DISABLE_BEA2),
/* harmony export */   "_DYN_ONUNLOAD_DISABLE_FET6": () => (/* binding */ _DYN_ONUNLOAD_DISABLE_FET6),
/* harmony export */   "_DYN_ON_LINE": () => (/* binding */ _DYN_ON_LINE),
/* harmony export */   "_DYN_ORI_PAYLOAD": () => (/* binding */ _DYN_ORI_PAYLOAD),
/* harmony export */   "_DYN_PUSH": () => (/* binding */ _DYN_PUSH),
/* harmony export */   "_DYN_SAMPLE_RATE": () => (/* binding */ _DYN_SAMPLE_RATE),
/* harmony export */   "_DYN_SEND_POST": () => (/* binding */ _DYN_SEND_POST),
/* harmony export */   "_DYN_SET_REQUEST_HEADER": () => (/* binding */ _DYN_SET_REQUEST_HEADER),
/* harmony export */   "_DYN_STRINGIFY": () => (/* binding */ _DYN_STRINGIFY),
/* harmony export */   "_DYN_TAGS": () => (/* binding */ _DYN_TAGS),
/* harmony export */   "_DYN_TO_STRING": () => (/* binding */ _DYN_TO_STRING),
/* harmony export */   "_DYN_TRACE_ID": () => (/* binding */ _DYN_TRACE_ID),
/* harmony export */   "_DYN_TRIGGER_SEND": () => (/* binding */ _DYN_TRIGGER_SEND),
/* harmony export */   "_DYN__BUFFER": () => (/* binding */ _DYN__BUFFER),
/* harmony export */   "_DYN__BUFFER__KEY": () => (/* binding */ _DYN__BUFFER__KEY),
/* harmony export */   "_DYN__GET": () => (/* binding */ _DYN__GET),
/* harmony export */   "_DYN__MAX__BUFFER__SIZE": () => (/* binding */ _DYN__MAX__BUFFER__SIZE),
/* harmony export */   "_DYN__ON_ERROR": () => (/* binding */ _DYN__ON_ERROR),
/* harmony export */   "_DYN__ON_PARTIAL_SUCCESS": () => (/* binding */ _DYN__ON_PARTIAL_SUCCESS),
/* harmony export */   "_DYN__ON_SUCCESS": () => (/* binding */ _DYN__ON_SUCCESS),
/* harmony export */   "_DYN__SENDER": () => (/* binding */ _DYN__SENDER),
/* harmony export */   "_DYN__SENT__BUFFER__KEY": () => (/* binding */ _DYN__SENT__BUFFER__KEY),
/* harmony export */   "_DYN__XHR_READY_STATE_CHA7": () => (/* binding */ _DYN__XHR_READY_STATE_CHA7)
/* harmony export */ });
/*
 * Application Insights JavaScript SDK - Channel, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


// @skip-file-minify
// ##############################################################
// AUTO GENERATED FILE: This file is Auto Generated during build.
// ##############################################################
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Note: DON'T Export these const from the package as we are still targeting ES3 this will export a mutable variables that someone could change!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
var _DYN_TAGS = "tags"; // Count: 17
var _DYN_DEVICE_TYPE = "deviceType"; // Count: 3
var _DYN_DATA = "data"; // Count: 18
var _DYN_NAME = "name"; // Count: 8
var _DYN_TRACE_ID = "traceID"; // Count: 5
var _DYN_LENGTH = "length"; // Count: 38
var _DYN_STRINGIFY = "stringify"; // Count: 5
var _DYN_MEASUREMENTS = "measurements"; // Count: 7
var _DYN_DATA_TYPE = "dataType"; // Count: 10
var _DYN_ENVELOPE_TYPE = "envelopeType"; // Count: 7
var _DYN_TO_STRING = "toString"; // Count: 7
var _DYN_ON_LINE = "onLine"; // Count: 4
var _DYN_IS_ONLINE = "isOnline"; // Count: 3
var _DYN__GET = "_get"; // Count: 5
var _DYN_ENQUEUE = "enqueue"; // Count: 7
var _DYN_COUNT = "count"; // Count: 6
var _DYN_EVENTS_LIMIT_IN_MEM = "eventsLimitInMem"; // Count: 2
var _DYN_PUSH = "push"; // Count: 6
var _DYN_EMIT_LINE_DELIMITED_0 = "emitLineDelimitedJson"; // Count: 3
var _DYN_CLEAR = "clear"; // Count: 7
var _DYN_BATCH_PAYLOADS = "batchPayloads"; // Count: 3
var _DYN_CREATE_NEW = "createNew"; // Count: 3
var _DYN_MARK_AS_SENT = "markAsSent"; // Count: 4
var _DYN_CLEAR_SENT = "clearSent"; // Count: 5
var _DYN_BUFFER_OVERRIDE = "bufferOverride"; // Count: 3
var _DYN__BUFFER__KEY = "BUFFER_KEY"; // Count: 5
var _DYN__SENT__BUFFER__KEY = "SENT_BUFFER_KEY"; // Count: 8
var _DYN__MAX__BUFFER__SIZE = "MAX_BUFFER_SIZE"; // Count: 5
var _DYN_SEND_POST = "sendPOST"; // Count: 3
var _DYN_TRIGGER_SEND = "triggerSend"; // Count: 5
var _DYN_DIAG_LOG = "diagLog"; // Count: 16
var _DYN__SENDER = "_sender"; // Count: 5
var _DYN_CUSTOM_HEADERS = "customHeaders"; // Count: 3
var _DYN_MAX_BATCH_SIZE_IN_BY1 = "maxBatchSizeInBytes"; // Count: 2
var _DYN_ONUNLOAD_DISABLE_BEA2 = "onunloadDisableBeacon"; // Count: 2
var _DYN_IS_BEACON_API_DISABL3 = "isBeaconApiDisabled"; // Count: 3
var _DYN_ALWAYS_USE_XHR_OVERR4 = "alwaysUseXhrOverride"; // Count: 2
var _DYN_ENABLE_SESSION_STORA5 = "enableSessionStorageBuffer"; // Count: 2
var _DYN__BUFFER = "_buffer"; // Count: 9
var _DYN_ONUNLOAD_DISABLE_FET6 = "onunloadDisableFetch"; // Count: 2
var _DYN_INSTRUMENTATION_KEY = "instrumentationKey"; // Count: 2
var _DYN_CONVERT_UNDEFINED = "convertUndefined"; // Count: 2
var _DYN_MAX_BATCH_INTERVAL = "maxBatchInterval"; // Count: 2
var _DYN_BASE_TYPE = "baseType"; // Count: 4
var _DYN_SAMPLE_RATE = "sampleRate"; // Count: 4
var _DYN__XHR_READY_STATE_CHA7 = "_xhrReadyStateChange"; // Count: 2
var _DYN__ON_ERROR = "_onError"; // Count: 7
var _DYN__ON_PARTIAL_SUCCESS = "_onPartialSuccess"; // Count: 3
var _DYN__ON_SUCCESS = "_onSuccess"; // Count: 5
var _DYN_ITEMS_ACCEPTED = "itemsAccepted"; // Count: 5
var _DYN_ITEMS_RECEIVED = "itemsReceived"; // Count: 6
var _DYN_ORI_PAYLOAD = "oriPayload"; // Count: 5
var _DYN_SET_REQUEST_HEADER = "setRequestHeader"; // Count: 3
var _DYN_EVENTS_SEND_REQUEST = "eventsSendRequest"; // Count: 2
var _DYN_GET_SAMPLING_SCORE = "getSamplingScore"; // Count: 2
var _DYN_GET_HASH_CODE_SCORE = "getHashCodeScore"; // Count: 4
//# sourceMappingURL=__DynamicConstants.js.map

/***/ }),
/* 134 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DependencyEnvelopeCreator": () => (/* binding */ DependencyEnvelopeCreator),
/* harmony export */   "EnvelopeCreator": () => (/* binding */ EnvelopeCreator),
/* harmony export */   "EventEnvelopeCreator": () => (/* binding */ EventEnvelopeCreator),
/* harmony export */   "ExceptionEnvelopeCreator": () => (/* binding */ ExceptionEnvelopeCreator),
/* harmony export */   "MetricEnvelopeCreator": () => (/* binding */ MetricEnvelopeCreator),
/* harmony export */   "PageViewEnvelopeCreator": () => (/* binding */ PageViewEnvelopeCreator),
/* harmony export */   "PageViewPerformanceEnvelopeCreator": () => (/* binding */ PageViewPerformanceEnvelopeCreator),
/* harmony export */   "TraceEnvelopeCreator": () => (/* binding */ TraceEnvelopeCreator)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(84);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(35);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(80);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(7);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(89);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(92);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(81);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(82);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(85);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(87);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(91);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(90);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(24);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(44);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(41);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(135);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(133);
/*
 * Application Insights JavaScript SDK - Channel, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





// these two constants are used to filter out properties not needed when trying to extract custom properties and measurements from the incoming payload
var strBaseType = "baseType";
var strBaseData = "baseData";
var strProperties = "properties";
var strTrue = "true";
function _setValueIf(target, field, value) {
    return (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.setValue)(target, field, value, _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isTruthy);
}
/*
 * Maps Part A data from CS 4.0
 */
function _extractPartAExtensions(logger, item, env) {
    // todo: switch to keys from common in this method
    var envTags = env[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TAGS /* @min:%2etags */] = env[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TAGS /* @min:%2etags */] || {};
    var itmExt = item.ext = item.ext || {};
    var itmTags = item[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TAGS /* @min:%2etags */] = item[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TAGS /* @min:%2etags */] || [];
    var extUser = itmExt.user;
    if (extUser) {
        _setValueIf(envTags, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_3__.CtxTagKeys.userAuthUserId, extUser.authId);
        _setValueIf(envTags, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_3__.CtxTagKeys.userId, extUser.id || extUser.localId);
    }
    var extApp = itmExt.app;
    if (extApp) {
        _setValueIf(envTags, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_3__.CtxTagKeys.sessionId, extApp.sesId);
    }
    var extDevice = itmExt.device;
    if (extDevice) {
        _setValueIf(envTags, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_3__.CtxTagKeys.deviceId, extDevice.id || extDevice.localId);
        _setValueIf(envTags, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_3__.CtxTagKeys[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DEVICE_TYPE /* @min:%2edeviceType */], extDevice.deviceClass);
        _setValueIf(envTags, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_3__.CtxTagKeys.deviceIp, extDevice.ip);
        _setValueIf(envTags, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_3__.CtxTagKeys.deviceModel, extDevice.model);
        _setValueIf(envTags, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_3__.CtxTagKeys[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DEVICE_TYPE /* @min:%2edeviceType */], extDevice[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DEVICE_TYPE /* @min:%2edeviceType */]);
    }
    var web = item.ext.web;
    if (web) {
        _setValueIf(envTags, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_3__.CtxTagKeys.deviceLanguage, web.browserLang);
        _setValueIf(envTags, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_3__.CtxTagKeys.deviceBrowserVersion, web.browserVer);
        _setValueIf(envTags, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_3__.CtxTagKeys.deviceBrowser, web.browser);
        var envData = env[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA /* @min:%2edata */] = env[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA /* @min:%2edata */] || {};
        var envBaseData = envData[strBaseData] = envData[strBaseData] || {};
        var envProps = envBaseData[strProperties] = envBaseData[strProperties] || {};
        _setValueIf(envProps, "domain", web.domain);
        _setValueIf(envProps, "isManual", web.isManual ? strTrue : null);
        _setValueIf(envProps, "screenRes", web.screenRes);
        _setValueIf(envProps, "userConsent", web.userConsent ? strTrue : null);
    }
    var extOs = itmExt.os;
    if (extOs) {
        _setValueIf(envTags, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_3__.CtxTagKeys.deviceOS, extOs[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NAME /* @min:%2ename */]);
    }
    // No support for mapping Trace.traceState to 2.0 as it is currently empty
    var extTrace = itmExt.trace;
    if (extTrace) {
        _setValueIf(envTags, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_3__.CtxTagKeys.operationParentId, extTrace.parentID);
        _setValueIf(envTags, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_3__.CtxTagKeys.operationName, (0,_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_4__.dataSanitizeString)(logger, extTrace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NAME /* @min:%2ename */]));
        _setValueIf(envTags, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_3__.CtxTagKeys.operationId, extTrace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TRACE_ID /* @min:%2etraceID */]);
    }
    // Sample 4.0 schema
    //  {
    //     "time" : "2018-09-05T22:51:22.4936Z",
    //     "name" : "MetricWithNamespace",
    //     "iKey" : "ABC-5a4cbd20-e601-4ef5-a3c6-5d6577e4398e",
    //     "ext": {  "cloud": {
    //          "role": "WATSON3",
    //          "roleInstance": "CO4AEAP00000260"
    //      },
    //      "device": {}, "correlation": {} },
    //      "tags": [
    //        { "amazon.region" : "east2" },
    //        { "os.expid" : "wp:02df239" }
    //     ]
    //   }
    var tgs = {};
    // deals with tags.push({object})
    for (var i = itmTags[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] - 1; i >= 0; i--) {
        var tg = itmTags[i];
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(tg, function (key, value) {
            tgs[key] = value;
        });
        itmTags.splice(i, 1);
    }
    // deals with tags[key]=value (and handles hasOwnProperty)
    (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(itmTags, function (tg, value) {
        tgs[tg] = value;
    });
    var theTags = (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_6__.__assignFn)((0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_6__.__assignFn)({}, envTags), tgs);
    if (!theTags[_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_3__.CtxTagKeys.internalSdkVersion]) {
        // Append a version in case it is not already set
        theTags[_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_3__.CtxTagKeys.internalSdkVersion] = (0,_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_4__.dataSanitizeString)(logger, "javascript:".concat(EnvelopeCreator.Version), 64);
    }
    env[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TAGS /* @min:%2etags */] = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.optimizeObject)(theTags);
}
function _extractPropsAndMeasurements(data, properties, measurements) {
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(data)) {
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(data, function (key, value) {
            if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNumber)(value)) {
                measurements[key] = value;
            }
            else if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isString)(value)) {
                properties[key] = value;
            }
            else if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__.hasJSON)()) {
                properties[key] = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__.getJSON)()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_STRINGIFY /* @min:%2estringify */](value);
            }
        });
    }
}
function _convertPropsUndefinedToCustomDefinedValue(properties, customUndefinedValue) {
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(properties)) {
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(properties, function (key, value) {
            properties[key] = value || customUndefinedValue;
        });
    }
}
// TODO: Do we want this to take logger as arg or use this._logger as nonstatic?
function _createEnvelope(logger, envelopeType, telemetryItem, data) {
    var envelope = new _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_8__.Envelope(logger, data, envelopeType);
    _setValueIf(envelope, "sampleRate", telemetryItem[_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_9__.SampleRate]);
    if ((telemetryItem[strBaseData] || {}).startTime) {
        // Starting from Version 3.0.3, the time property will be assigned by the startTime value,
        // which records the loadEvent time for the pageView event.
        envelope.time = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.toISOString)(telemetryItem[strBaseData].startTime);
    }
    envelope.iKey = telemetryItem.iKey;
    var iKeyNoDashes = telemetryItem.iKey.replace(/-/g, "");
    envelope[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NAME /* @min:%2ename */] = envelope[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NAME /* @min:%2ename */].replace("{0}", iKeyNoDashes);
    // extract all extensions from ctx
    _extractPartAExtensions(logger, telemetryItem, envelope);
    // loop through the envelope tags (extension of Part A) and pick out the ones that should go in outgoing envelope tags
    telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TAGS /* @min:%2etags */] = telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TAGS /* @min:%2etags */] || [];
    return (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.optimizeObject)(envelope);
}
function EnvelopeCreatorInit(logger, telemetryItem) {
    if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(telemetryItem[strBaseData])) {
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_10__._throwInternal)(logger, 1 /* eLoggingSeverity.CRITICAL */, 46 /* _eInternalMessageId.TelemetryEnvelopeInvalid */, "telemetryItem.baseData cannot be null.");
    }
}
var EnvelopeCreator = {
    Version: '3.0.4'
};
function DependencyEnvelopeCreator(logger, telemetryItem, customUndefinedValue) {
    EnvelopeCreatorInit(logger, telemetryItem);
    var customMeasurements = telemetryItem[strBaseData][_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_MEASUREMENTS /* @min:%2emeasurements */] || {};
    var customProperties = telemetryItem[strBaseData][strProperties] || {};
    _extractPropsAndMeasurements(telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA /* @min:%2edata */], customProperties, customMeasurements);
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(customUndefinedValue)) {
        _convertPropsUndefinedToCustomDefinedValue(customProperties, customUndefinedValue);
    }
    var bd = telemetryItem[strBaseData];
    if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(bd)) {
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_10__._warnToConsole)(logger, "Invalid input for dependency data");
        return null;
    }
    var method = bd[strProperties] && bd[strProperties][_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_9__.HttpMethod] ? bd[strProperties][_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_9__.HttpMethod] : "GET";
    var remoteDepData = new _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_11__.RemoteDependencyData(logger, bd.id, bd.target, bd[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NAME /* @min:%2ename */], bd[_InternalConstants__WEBPACK_IMPORTED_MODULE_12__.STR_DURATION /* @min:%2eduration */], bd.success, bd.responseCode, method, bd.type, bd.correlationContext, customProperties, customMeasurements);
    var data = new _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_13__.Data(_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_11__.RemoteDependencyData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA_TYPE /* @min:%2edataType */], remoteDepData);
    return _createEnvelope(logger, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_11__.RemoteDependencyData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_ENVELOPE_TYPE /* @min:%2eenvelopeType */], telemetryItem, data);
}
function EventEnvelopeCreator(logger, telemetryItem, customUndefinedValue) {
    EnvelopeCreatorInit(logger, telemetryItem);
    var customProperties = {};
    var customMeasurements = {};
    if (telemetryItem[strBaseType] !== _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_14__.Event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA_TYPE /* @min:%2edataType */]) {
        customProperties["baseTypeSource"] = telemetryItem[strBaseType]; // save the passed in base type as a property
    }
    if (telemetryItem[strBaseType] === _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_14__.Event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA_TYPE /* @min:%2edataType */]) { // take collection
        customProperties = telemetryItem[strBaseData][strProperties] || {};
        customMeasurements = telemetryItem[strBaseData][_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_MEASUREMENTS /* @min:%2emeasurements */] || {};
    }
    else { // if its not a known type, convert to custom event
        if (telemetryItem[strBaseData]) {
            _extractPropsAndMeasurements(telemetryItem[strBaseData], customProperties, customMeasurements);
        }
    }
    // Extract root level properties from part C telemetryItem.data
    _extractPropsAndMeasurements(telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA /* @min:%2edata */], customProperties, customMeasurements);
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(customUndefinedValue)) {
        _convertPropsUndefinedToCustomDefinedValue(customProperties, customUndefinedValue);
    }
    var eventName = telemetryItem[strBaseData][_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NAME /* @min:%2ename */];
    var eventData = new _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_14__.Event(logger, eventName, customProperties, customMeasurements);
    var data = new _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_13__.Data(_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_14__.Event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA_TYPE /* @min:%2edataType */], eventData);
    return _createEnvelope(logger, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_14__.Event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_ENVELOPE_TYPE /* @min:%2eenvelopeType */], telemetryItem, data);
}
function ExceptionEnvelopeCreator(logger, telemetryItem, customUndefinedValue) {
    EnvelopeCreatorInit(logger, telemetryItem);
    // Extract root level properties from part C telemetryItem.data
    var customMeasurements = telemetryItem[strBaseData][_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_MEASUREMENTS /* @min:%2emeasurements */] || {};
    var customProperties = telemetryItem[strBaseData][strProperties] || {};
    _extractPropsAndMeasurements(telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA /* @min:%2edata */], customProperties, customMeasurements);
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(customUndefinedValue)) {
        _convertPropsUndefinedToCustomDefinedValue(customProperties, customUndefinedValue);
    }
    var bd = telemetryItem[strBaseData];
    var exData = _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_15__.Exception.CreateFromInterface(logger, bd, customProperties, customMeasurements);
    var data = new _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_13__.Data(_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_15__.Exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA_TYPE /* @min:%2edataType */], exData);
    return _createEnvelope(logger, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_15__.Exception[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_ENVELOPE_TYPE /* @min:%2eenvelopeType */], telemetryItem, data);
}
function MetricEnvelopeCreator(logger, telemetryItem, customUndefinedValue) {
    EnvelopeCreatorInit(logger, telemetryItem);
    var baseData = telemetryItem[strBaseData];
    var props = baseData[strProperties] || {};
    var measurements = baseData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_MEASUREMENTS /* @min:%2emeasurements */] || {};
    _extractPropsAndMeasurements(telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA /* @min:%2edata */], props, measurements);
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(customUndefinedValue)) {
        _convertPropsUndefinedToCustomDefinedValue(props, customUndefinedValue);
    }
    var baseMetricData = new _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_16__.Metric(logger, baseData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NAME /* @min:%2ename */], baseData.average, baseData.sampleCount, baseData.min, baseData.max, baseData.stdDev, props, measurements);
    var data = new _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_13__.Data(_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_16__.Metric[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA_TYPE /* @min:%2edataType */], baseMetricData);
    return _createEnvelope(logger, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_16__.Metric[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_ENVELOPE_TYPE /* @min:%2eenvelopeType */], telemetryItem, data);
}
function PageViewEnvelopeCreator(logger, telemetryItem, customUndefinedValue) {
    EnvelopeCreatorInit(logger, telemetryItem);
    // Since duration is not part of the domain properties in Common Schema, extract it from part C
    var duration;
    var baseData = telemetryItem[strBaseData];
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(baseData) &&
        !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(baseData[strProperties]) &&
        !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(baseData[strProperties][_InternalConstants__WEBPACK_IMPORTED_MODULE_12__.STR_DURATION])) { // from part B properties
        duration = baseData[strProperties][_InternalConstants__WEBPACK_IMPORTED_MODULE_12__.STR_DURATION];
        delete baseData[strProperties][_InternalConstants__WEBPACK_IMPORTED_MODULE_12__.STR_DURATION];
    }
    else if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA /* @min:%2edata */]) &&
        !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA /* @min:%2edata */][_InternalConstants__WEBPACK_IMPORTED_MODULE_12__.STR_DURATION])) { // from custom properties
        duration = telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA /* @min:%2edata */][_InternalConstants__WEBPACK_IMPORTED_MODULE_12__.STR_DURATION];
        delete telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA /* @min:%2edata */][_InternalConstants__WEBPACK_IMPORTED_MODULE_12__.STR_DURATION];
    }
    var bd = telemetryItem[strBaseData];
    // special case: pageview.id is grabbed from current operation id. Analytics plugin is decoupled from properties plugin, so this is done here instead. This can be made a default telemetry intializer instead if needed to be decoupled from channel
    var currentContextId;
    if (((telemetryItem.ext || {}).trace || {})[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TRACE_ID /* @min:%2etraceID */]) {
        currentContextId = telemetryItem.ext.trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TRACE_ID /* @min:%2etraceID */];
    }
    var id = bd.id || currentContextId;
    var name = bd[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NAME /* @min:%2ename */];
    var url = bd.uri;
    var properties = bd[strProperties] || {};
    var measurements = bd[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_MEASUREMENTS /* @min:%2emeasurements */] || {};
    // refUri is a field that Breeze still does not recognize as part of Part B. For now, put it in Part C until it supports it as a domain property
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(bd.refUri)) {
        properties["refUri"] = bd.refUri;
    }
    // pageType is a field that Breeze still does not recognize as part of Part B. For now, put it in Part C until it supports it as a domain property
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(bd.pageType)) {
        properties["pageType"] = bd.pageType;
    }
    // isLoggedIn is a field that Breeze still does not recognize as part of Part B. For now, put it in Part C until it supports it as a domain property
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(bd.isLoggedIn)) {
        properties["isLoggedIn"] = bd.isLoggedIn[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TO_STRING /* @min:%2etoString */]();
    }
    // pageTags is a field that Breeze still does not recognize as part of Part B. For now, put it in Part C until it supports it as a domain property
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(bd[strProperties])) {
        var pageTags = bd[strProperties];
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(pageTags, function (key, value) {
            properties[key] = value;
        });
    }
    _extractPropsAndMeasurements(telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA /* @min:%2edata */], properties, measurements);
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(customUndefinedValue)) {
        _convertPropsUndefinedToCustomDefinedValue(properties, customUndefinedValue);
    }
    var pageViewData = new _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_17__.PageView(logger, name, url, duration, properties, measurements, id);
    var data = new _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_13__.Data(_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_17__.PageView[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA_TYPE /* @min:%2edataType */], pageViewData);
    return _createEnvelope(logger, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_17__.PageView[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_ENVELOPE_TYPE /* @min:%2eenvelopeType */], telemetryItem, data);
}
function PageViewPerformanceEnvelopeCreator(logger, telemetryItem, customUndefinedValue) {
    EnvelopeCreatorInit(logger, telemetryItem);
    var bd = telemetryItem[strBaseData];
    var name = bd[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NAME /* @min:%2ename */];
    var url = bd.uri || bd.url;
    var properties = bd[strProperties] || {};
    var measurements = bd[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_MEASUREMENTS /* @min:%2emeasurements */] || {};
    _extractPropsAndMeasurements(telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA /* @min:%2edata */], properties, measurements);
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(customUndefinedValue)) {
        _convertPropsUndefinedToCustomDefinedValue(properties, customUndefinedValue);
    }
    var baseData = new _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_18__.PageViewPerformance(logger, name, url, undefined, properties, measurements, bd);
    var data = new _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_13__.Data(_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_18__.PageViewPerformance[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA_TYPE /* @min:%2edataType */], baseData);
    return _createEnvelope(logger, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_18__.PageViewPerformance[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_ENVELOPE_TYPE /* @min:%2eenvelopeType */], telemetryItem, data);
}
function TraceEnvelopeCreator(logger, telemetryItem, customUndefinedValue) {
    EnvelopeCreatorInit(logger, telemetryItem);
    var message = telemetryItem[strBaseData].message;
    var severityLevel = telemetryItem[strBaseData].severityLevel;
    var props = telemetryItem[strBaseData][strProperties] || {};
    var measurements = telemetryItem[strBaseData][_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_MEASUREMENTS /* @min:%2emeasurements */] || {};
    _extractPropsAndMeasurements(telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA /* @min:%2edata */], props, measurements);
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(customUndefinedValue)) {
        _convertPropsUndefinedToCustomDefinedValue(props, customUndefinedValue);
    }
    var baseData = new _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_19__.Trace(logger, message, severityLevel, props, measurements);
    var data = new _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_13__.Data(_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_19__.Trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DATA_TYPE /* @min:%2edataType */], baseData);
    return _createEnvelope(logger, _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_19__.Trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_ENVELOPE_TYPE /* @min:%2eenvelopeType */], telemetryItem, data);
}
//# sourceMappingURL=EnvelopeCreator.js.map

/***/ }),
/* 135 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "STR_DURATION": () => (/* binding */ STR_DURATION)
/* harmony export */ });
/*
 * Application Insights JavaScript SDK - Channel, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


// ###################################################################################################################################################
// Note: DON'T Export these const from the package as we are still targeting IE/ES5 this will export a mutable variables that someone could change ###
// ###################################################################################################################################################
// Generally you should only put values that are used more than 2 times and then only if not already exposed as a constant (such as SdkCoreNames)
// as when using "short" named values from here they will be will be minified smaller than the SdkCoreNames[eSdkCoreNames.xxxx] value.
var STR_DURATION = "duration";
//# sourceMappingURL=InternalConstants.js.map

/***/ }),
/* 136 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Serializer": () => (/* binding */ Serializer)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(51);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(41);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(14);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(24);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(133);
/*
 * Application Insights JavaScript SDK - Channel, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */



var Serializer = /** @class */ (function () {
    function Serializer(logger) {
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_0__["default"])(Serializer, this, function (_self) {
            /**
             * Serializes the current object to a JSON string.
             */
            _self.serialize = function (input) {
                var output = _serializeObject(input, "root");
                try {
                    return (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.getJSON)()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_STRINGIFY /* @min:%2estringify */](output);
                }
                catch (e) {
                    // if serialization fails return an empty string
                    (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__._throwInternal)(logger, 1 /* eLoggingSeverity.CRITICAL */, 48 /* _eInternalMessageId.CannotSerializeObject */, (e && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.isFunction)(e[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TO_STRING /* @min:%2etoString */])) ? e[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TO_STRING /* @min:%2etoString */]() : "Error serializing object", null, true);
                }
            };
            function _serializeObject(source, name) {
                var circularReferenceCheck = "__aiCircularRefCheck";
                var output = {};
                if (!source) {
                    (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__._throwInternal)(logger, 1 /* eLoggingSeverity.CRITICAL */, 48 /* _eInternalMessageId.CannotSerializeObject */, "cannot serialize object because it is null or undefined", { name: name }, true);
                    return output;
                }
                if (source[circularReferenceCheck]) {
                    (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 50 /* _eInternalMessageId.CircularReferenceDetected */, "Circular reference detected while serializing object", { name: name }, true);
                    return output;
                }
                if (!source.aiDataContract) {
                    // special case for measurements/properties/tags
                    if (name === "measurements") {
                        output = _serializeStringMap(source, "number", name);
                    }
                    else if (name === "properties") {
                        output = _serializeStringMap(source, "string", name);
                    }
                    else if (name === "tags") {
                        output = _serializeStringMap(source, "string", name);
                    }
                    else if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.isArray)(source)) {
                        output = _serializeArray(source, name);
                    }
                    else {
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 49 /* _eInternalMessageId.CannotSerializeObjectNonSerializable */, "Attempting to serialize an object which does not implement ISerializable", { name: name }, true);
                        try {
                            // verify that the object can be stringified
                            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.getJSON)()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_STRINGIFY /* @min:%2estringify */](source);
                            output = source;
                        }
                        catch (e) {
                            // if serialization fails return an empty string
                            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__._throwInternal)(logger, 1 /* eLoggingSeverity.CRITICAL */, 48 /* _eInternalMessageId.CannotSerializeObject */, (e && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.isFunction)(e[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TO_STRING /* @min:%2etoString */])) ? e[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TO_STRING /* @min:%2etoString */]() : "Error serializing object", null, true);
                        }
                    }
                    return output;
                }
                source[circularReferenceCheck] = true;
                (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(source.aiDataContract, function (field, contract) {
                    var isRequired = ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.isFunction)(contract)) ? (contract() & 1 /* FieldType.Required */) : (contract & 1 /* FieldType.Required */);
                    var isHidden = ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.isFunction)(contract)) ? (contract() & 4 /* FieldType.Hidden */) : (contract & 4 /* FieldType.Hidden */);
                    var isArray = contract & 2 /* FieldType.Array */;
                    var isPresent = source[field] !== undefined;
                    var isObj = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.isObject)(source[field]) && source[field] !== null;
                    if (isRequired && !isPresent && !isArray) {
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__._throwInternal)(logger, 1 /* eLoggingSeverity.CRITICAL */, 24 /* _eInternalMessageId.MissingRequiredFieldSpecification */, "Missing required field specification. The field is required but not present on source", { field: field, name: name });
                        // If not in debug mode, continue and hope the error is permissible
                    }
                    else if (!isHidden) { // Don't serialize hidden fields
                        var value = void 0;
                        if (isObj) {
                            if (isArray) {
                                // special case; recurse on each object in the source array
                                value = _serializeArray(source[field], field);
                            }
                            else {
                                // recurse on the source object in this field
                                value = _serializeObject(source[field], field);
                            }
                        }
                        else {
                            // assign the source field to the output even if undefined or required
                            value = source[field];
                        }
                        // only emit this field if the value is defined
                        if (value !== undefined) {
                            output[field] = value;
                        }
                    }
                });
                delete source[circularReferenceCheck];
                return output;
            }
            function _serializeArray(sources, name) {
                var output;
                if (!!sources) {
                    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.isArray)(sources)) {
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__._throwInternal)(logger, 1 /* eLoggingSeverity.CRITICAL */, 54 /* _eInternalMessageId.ItemNotInArray */, "This field was specified as an array in the contract but the item is not an array.\r\n", { name: name }, true);
                    }
                    else {
                        output = [];
                        for (var i = 0; i < sources[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */]; i++) {
                            var source = sources[i];
                            var item = _serializeObject(source, name + "[" + i + "]");
                            output[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](item);
                        }
                    }
                }
                return output;
            }
            function _serializeStringMap(map, expectedType, name) {
                var output;
                if (map) {
                    output = {};
                    (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(map, function (field, value) {
                        if (expectedType === "string") {
                            if (value === undefined) {
                                output[field] = "undefined";
                            }
                            else if (value === null) {
                                output[field] = "null";
                            }
                            else if (!value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TO_STRING /* @min:%2etoString */]) {
                                output[field] = "invalid field: toString() is not defined.";
                            }
                            else {
                                output[field] = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TO_STRING /* @min:%2etoString */]();
                            }
                        }
                        else if (expectedType === "number") {
                            if (value === undefined) {
                                output[field] = "undefined";
                            }
                            else if (value === null) {
                                output[field] = "null";
                            }
                            else {
                                var num = parseFloat(value);
                                if (isNaN(num)) {
                                    output[field] = "NaN";
                                }
                                else {
                                    output[field] = num;
                                }
                            }
                        }
                        else {
                            output[field] = "invalid field: " + name + " is of unknown type.";
                            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__._throwInternal)(logger, 1 /* eLoggingSeverity.CRITICAL */, output[field], null, true);
                        }
                    });
                }
                return output;
            }
        });
    }
// Removed Stub for Serializer.prototype.serialize.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    Serializer.__ieDyn=1;

    return Serializer;
}());

//# sourceMappingURL=Serializer.js.map

/***/ }),
/* 137 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "__getRegisteredEvents": () => (/* binding */ __getRegisteredEvents),
/* harmony export */   "addEventHandler": () => (/* binding */ addEventHandler),
/* harmony export */   "addEventListeners": () => (/* binding */ addEventListeners),
/* harmony export */   "addPageHideEventListener": () => (/* binding */ addPageHideEventListener),
/* harmony export */   "addPageShowEventListener": () => (/* binding */ addPageShowEventListener),
/* harmony export */   "addPageUnloadEventListener": () => (/* binding */ addPageUnloadEventListener),
/* harmony export */   "attachEvent": () => (/* binding */ attachEvent),
/* harmony export */   "detachEvent": () => (/* binding */ detachEvent),
/* harmony export */   "eventOff": () => (/* binding */ eventOff),
/* harmony export */   "eventOn": () => (/* binding */ eventOn),
/* harmony export */   "mergeEvtNamespace": () => (/* binding */ mergeEvtNamespace),
/* harmony export */   "removeEventHandler": () => (/* binding */ removeEventHandler),
/* harmony export */   "removeEventListeners": () => (/* binding */ removeEventListeners),
/* harmony export */   "removePageHideEventListener": () => (/* binding */ removePageHideEventListener),
/* harmony export */   "removePageShowEventListener": () => (/* binding */ removePageShowEventListener),
/* harmony export */   "removePageUnloadEventListener": () => (/* binding */ removePageUnloadEventListener)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(24);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(33);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(18);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(8);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42);
/* harmony import */ var _DataCacheHelper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(58);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(43);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






// Added to help with minfication
var strOnPrefix = "on";
var strAttachEvent = "attachEvent";
var strAddEventHelper = "addEventListener";
var strDetachEvent = "detachEvent";
var strRemoveEventListener = "removeEventListener";
var strEvents = "events";
var strVisibilityChangeEvt = "visibilitychange";
var strPageHide = "pagehide";
var strPageShow = "pageshow";
var strUnload = "unload";
var strBeforeUnload = "beforeunload";
var strPageHideNamespace = (0,_DataCacheHelper__WEBPACK_IMPORTED_MODULE_0__.createUniqueNamespace)("aiEvtPageHide");
var strPageShowNamespace = (0,_DataCacheHelper__WEBPACK_IMPORTED_MODULE_0__.createUniqueNamespace)("aiEvtPageShow");
var rRemoveEmptyNs = /\.[\.]+/g;
var rRemoveTrailingEmptyNs = /[\.]+$/;
var _guid = 1;
var elmNodeData = (0,_DataCacheHelper__WEBPACK_IMPORTED_MODULE_0__.createElmNodeData)("events");
var eventNamespace = /^([^.]*)(?:\.(.+)|)/;
function _normalizeNamespace(name) {
    if (name && name[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_REPLACE /* @min:%2ereplace */]) {
        return name[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_REPLACE /* @min:%2ereplace */](/^[\s\.]+|(?=[\s\.])[\.\s]+$/g, _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY);
    }
    return name;
}
function _getEvtNamespace(eventName, evtNamespace) {
    var _a;
    if (evtNamespace) {
        var theNamespace_1 = _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY;
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isArray)(evtNamespace)) {
            theNamespace_1 = _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY;
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.arrForEach)(evtNamespace, function (name) {
                name = _normalizeNamespace(name);
                if (name) {
                    if (name[0] !== ".") {
                        name = "." + name;
                    }
                    theNamespace_1 += name;
                }
            });
        }
        else {
            theNamespace_1 = _normalizeNamespace(evtNamespace);
        }
        if (theNamespace_1) {
            if (theNamespace_1[0] !== ".") {
                theNamespace_1 = "." + theNamespace_1;
            }
            // We may only have the namespace and not an eventName
            eventName = (eventName || _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY) + theNamespace_1;
        }
    }
    var parsedEvent = (eventNamespace.exec(eventName || _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY) || []);
    return _a = {},
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:type */] = parsedEvent[1],
        _a.ns = ((parsedEvent[2] || _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY).replace(rRemoveEmptyNs, ".").replace(rRemoveTrailingEmptyNs, _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLIT /* @min:%2esplit */](".").sort()).join("."),
        _a;
}
/**
 * Get all of the registered events on the target object, this is primarily used for testing cleanup but may also be used by
 * applications to remove their own events
 * @param target - The EventTarget that has registered events
 * @param eventName - [Optional] The name of the event to return the registered handlers and full name (with namespaces)
 * @param evtNamespace - [Optional] Additional namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace,
 * if the eventName also includes a namespace the namespace(s) are merged into a single namespace
 */
function __getRegisteredEvents(target, eventName, evtNamespace) {
    var theEvents = [];
    var eventCache = elmNodeData.get(target, strEvents, {}, false);
    var evtName = _getEvtNamespace(eventName, evtNamespace);
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(eventCache, function (evtType, registeredEvents) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.arrForEach)(registeredEvents, function (value) {
            var _a;
            if (!evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */] || evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */] === value.evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */]) {
                if (!evtName.ns || evtName.ns === evtName.ns) {
                    theEvents[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */]((_a = {},
                        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:name */] = value.evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */] + (value.evtName.ns ? "." + value.evtName.ns : _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY),
                        _a.handler = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HANDLER /* @min:%2ehandler */],
                        _a));
                }
            }
        });
    });
    return theEvents;
}
// Exported for internal unit testing only
function _getRegisteredEvents(target, evtName, addDefault) {
    if (addDefault === void 0) { addDefault = true; }
    var aiEvts = elmNodeData.get(target, strEvents, {}, addDefault);
    var registeredEvents = aiEvts[evtName];
    if (!registeredEvents) {
        registeredEvents = aiEvts[evtName] = [];
    }
    return registeredEvents;
}
function _doDetach(obj, evtName, handlerRef, useCapture) {
    if (obj && evtName && evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */]) {
        if (obj[strRemoveEventListener]) {
            obj[strRemoveEventListener](evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */], handlerRef, useCapture);
        }
        else if (obj[strDetachEvent]) {
            obj[strDetachEvent](strOnPrefix + evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */], handlerRef);
        }
    }
}
function _doAttach(obj, evtName, handlerRef, useCapture) {
    var result = false;
    if (obj && evtName && evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */] && handlerRef) {
        if (obj[strAddEventHelper]) {
            // all browsers except IE before version 9
            obj[strAddEventHelper](evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */], handlerRef, useCapture);
            result = true;
        }
        else if (obj[strAttachEvent]) {
            // IE before version 9
            obj[strAttachEvent](strOnPrefix + evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */], handlerRef);
            result = true;
        }
    }
    return result;
}
function _doUnregister(target, events, evtName, unRegFn) {
    var idx = events[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */];
    while (idx--) {
        var theEvent = events[idx];
        if (theEvent) {
            if (!evtName.ns || evtName.ns === theEvent.evtName.ns) {
                if (!unRegFn || unRegFn(theEvent)) {
                    _doDetach(target, theEvent.evtName, theEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HANDLER /* @min:%2ehandler */], theEvent.capture);
                    // Remove the registered event
                    events[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLICE /* @min:%2esplice */](idx, 1);
                }
            }
        }
    }
}
function _unregisterEvents(target, evtName, unRegFn) {
    if (evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */]) {
        _doUnregister(target, _getRegisteredEvents(target, evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */]), evtName, unRegFn);
    }
    else {
        var eventCache = elmNodeData.get(target, strEvents, {});
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(eventCache, function (evtType, events) {
            _doUnregister(target, events, evtName, unRegFn);
        });
        // Cleanup
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objKeys)(eventCache)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] === 0) {
            elmNodeData.kill(target, strEvents);
        }
    }
}
function mergeEvtNamespace(theNamespace, namespaces) {
    var newNamespaces;
    if (namespaces) {
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isArray)(namespaces)) {
            newNamespaces = [theNamespace].concat(namespaces);
        }
        else {
            newNamespaces = [theNamespace, namespaces];
        }
        // resort the namespaces so they are always in order
        newNamespaces = (_getEvtNamespace("xx", newNamespaces).ns)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLIT /* @min:%2esplit */](".");
    }
    else {
        newNamespaces = theNamespace;
    }
    return newNamespaces;
}
/**
 * Binds the specified function to an event, so that the function gets called whenever the event fires on the object
 * @param obj - Object to add the event too.
 * @param eventName - String that specifies any of the standard DHTML Events without "on" prefix, if may also include an optional (dot "." prefixed)
 * namespaces "click" "click.mynamespace" in addition to specific namespaces.
 * @param handlerRef - Pointer that specifies the function to call when event fires
 * @param evtNamespace - [Optional] Additional namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace,
 * if the eventName also includes a namespace the namespace(s) are merged into a single namespace
 * @param useCapture - [Optional] Defaults to false
 * @returns True if the function was bound successfully to the event, otherwise false
 */
function eventOn(target, eventName, handlerRef, evtNamespace, useCapture) {
    var _a;
    if (useCapture === void 0) { useCapture = false; }
    var result = false;
    if (target) {
        try {
            var evtName = _getEvtNamespace(eventName, evtNamespace);
            result = _doAttach(target, evtName, handlerRef, useCapture);
            if (result && elmNodeData.accept(target)) {
                var registeredEvent = (_a = {
                        guid: _guid++,
                        evtName: evtName
                    },
                    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HANDLER /* @min:handler */] = handlerRef,
                    _a.capture = useCapture,
                    _a);
                _getRegisteredEvents(target, evtName.type)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](registeredEvent);
            }
        }
        catch (e) {
            // Just Ignore any error so that we don't break any execution path
        }
    }
    return result;
}
/**
 * Removes an event handler for the specified event
 * @param Object - to remove the event from
 * @param eventName - {string} - The name of the event, with optional namespaces or just the namespaces,
 * such as "click", "click.mynamespace" or ".mynamespace"
 * @param handlerRef - {any} - The callback function that needs to be removed from the given event, when using a
 * namespace (with or without a qualifying event) this may be null to remove all previously attached event handlers
 * otherwise this will only remove events with this specific handler.
 * @param evtNamespace - [Optional] Additional namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace,
 * if the eventName also includes a namespace the namespace(s) are merged into a single namespace
 * @param useCapture - [Optional] Defaults to false
 */
function eventOff(target, eventName, handlerRef, evtNamespace, useCapture) {
    if (useCapture === void 0) { useCapture = false; }
    if (target) {
        try {
            var evtName_1 = _getEvtNamespace(eventName, evtNamespace);
            var found_1 = false;
            _unregisterEvents(target, evtName_1, function (regEvent) {
                if ((evtName_1.ns && !handlerRef) || regEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HANDLER /* @min:%2ehandler */] === handlerRef) {
                    found_1 = true;
                    return true;
                }
                return false;
            });
            if (!found_1) {
                // fallback to try and remove as requested
                _doDetach(target, evtName_1, handlerRef, useCapture);
            }
        }
        catch (e) {
            // Just Ignore any error so that we don't break any execution path
        }
    }
}
/**
 * Binds the specified function to an event, so that the function gets called whenever the event fires on the object
 * @param obj - Object to add the event too.
 * @param eventNameWithoutOn - String that specifies any of the standard DHTML Events without "on" prefix and optional (dot "." prefixed) namespaces "click" "click.mynamespace".
 * @param handlerRef - Pointer that specifies the function to call when event fires
 * @param useCapture - [Optional] Defaults to false
 * @returns True if the function was bound successfully to the event, otherwise false
 */
function attachEvent(obj, eventNameWithoutOn, handlerRef, useCapture) {
    if (useCapture === void 0) { useCapture = false; }
    return eventOn(obj, eventNameWithoutOn, handlerRef, null, useCapture);
}
/**
 * Removes an event handler for the specified event
 * @param Object - to remove the event from
 * @param eventNameWithoutOn - {string} - The name of the event, with optional namespaces or just the namespaces,
 * such as "click", "click.mynamespace" or ".mynamespace"
 * @param handlerRef - {any} - The callback function that needs to be removed from the given event, when using a
 * namespace (with or without a qualifying event) this may be null to remove all previously attached event handlers
 * otherwise this will only remove events with this specific handler.
 * @param useCapture - [Optional] Defaults to false
 */
function detachEvent(obj, eventNameWithoutOn, handlerRef, useCapture) {
    if (useCapture === void 0) { useCapture = false; }
    eventOff(obj, eventNameWithoutOn, handlerRef, null, useCapture);
}
/**
 * Trys to add an event handler for the specified event to the window, body and document
 * @param eventName - {string} - The name of the event
 * @param callback - {any} - The callback function that needs to be executed for the given event
 * @param evtNamespace - [Optional] Namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace.
 * @return {boolean} - true if the handler was successfully added
 */
function addEventHandler(eventName, callback, evtNamespace) {
    var result = false;
    var w = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.getWindow)();
    if (w) {
        result = eventOn(w, eventName, callback, evtNamespace);
        result = eventOn(w["body"], eventName, callback, evtNamespace) || result;
    }
    var doc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.getDocument)();
    if (doc) {
        result = eventOn(doc, eventName, callback, evtNamespace) || result;
    }
    return result;
}
/**
 * Trys to remove event handler(s) for the specified event/namespace to the window, body and document
 * @param eventName - {string} - The name of the event, with optional namespaces or just the namespaces,
 * such as "click", "click.mynamespace" or ".mynamespace"
 * @param callback - {any} - - The callback function that needs to be removed from the given event, when using a
 * namespace (with or without a qualifying event) this may be null to remove all previously attached event handlers
 * otherwise this will only remove events with this specific handler.
 * @param evtNamespace - [Optional] Namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace.
 */
function removeEventHandler(eventName, callback, evtNamespace) {
    var w = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.getWindow)();
    if (w) {
        eventOff(w, eventName, callback, evtNamespace);
        eventOff(w["body"], eventName, callback, evtNamespace);
    }
    var doc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.getDocument)();
    if (doc) {
        eventOff(doc, eventName, callback, evtNamespace);
    }
}
/**
 * Bind the listener to the array of events
 * @param events - An string array of event names to bind the listener to
 * @param listener - The event callback to call when the event is triggered
 * @param excludeEvents - [Optional] An array of events that should not be hooked (if possible), unless no other events can be.
 * @param evtNamespace - [Optional] Namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace.
 * @returns true - when at least one of the events was registered otherwise false
 */
function _addEventListeners(events, listener, excludeEvents, evtNamespace) {
    var added = false;
    if (listener && events && events[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] >