/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.javac.JavacClassFile;
import org.eclipse.jdt.internal.javac.JavacCompilationResult;
import org.eclipse.jdt.internal.javac.JavacConfig;
import org.eclipse.jdt.internal.javac.UnusedProblemFactory;
import org.eclipse.jdt.internal.javac.UnusedTreeScanner;

public class JavacTaskListener
implements TaskListener {
    private Map<ICompilationUnit, IContainer> sourceOutputMapping = new HashMap<ICompilationUnit, IContainer>();
    private Map<ICompilationUnit, JavacCompilationResult> results = new HashMap<ICompilationUnit, JavacCompilationResult>();
    private UnusedProblemFactory problemFactory;
    private JavacConfig config;
    private IContainer outputDir;
    private final Map<JavaFileObject, ICompilationUnit> fileObjectToCUMap;
    private static final Set<String> PRIMITIVE_TYPES = new HashSet<String>(Arrays.asList("byte", "short", "int", "long", "float", "double", "char", "boolean"));
    private static final char[] MODULE_INFO_NAME = "module-info".toCharArray();

    public JavacTaskListener(JavacConfig config, Map<IContainer, List<ICompilationUnit>> outputSourceMapping, IProblemFactory problemFactory, Map<JavaFileObject, ICompilationUnit> fileObjectToCUMap) {
        this.config = config;
        this.problemFactory = new UnusedProblemFactory(problemFactory, config.compilerOptions());
        this.fileObjectToCUMap = fileObjectToCUMap;
        for (Map.Entry<IContainer, List<ICompilationUnit>> entry : outputSourceMapping.entrySet()) {
            IContainer currentOutput = entry.getKey();
            entry.getValue().forEach(cu -> this.sourceOutputMapping.put((ICompilationUnit)cu, currentOutput));
        }
    }

    @Override
    public void finished(TaskEvent e) {
        if (e.getKind() == TaskEvent.Kind.GENERATE) {
            TypeElement typeElement;
            JavaFileObject file = e.getSourceFile();
            ICompilationUnit cu = this.fileObjectToCUMap.get(file);
            if (cu == null && (typeElement = e.getTypeElement()) instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)typeElement;
                if (this.isGeneratedSource(file)) {
                    try {
                        this.writeClassFile(clazz);
                    }
                    catch (CoreException coreException) {}
                }
            }
        } else if (e.getKind() == TaskEvent.Kind.ANALYZE) {
            JavaFileObject file = e.getSourceFile();
            final ICompilationUnit cu = this.fileObjectToCUMap.get(file);
            if (cu == null) {
                return;
            }
            final JavacCompilationResult result = this.results.computeIfAbsent(cu, cu1 -> new JavacCompilationResult((ICompilationUnit)cu1));
            final HashMap visitedClasses = new HashMap();
            final HashSet hierarchyRecorded = new HashSet();
            final TypeElement currentTopLevelType = e.getTypeElement();
            UnusedTreeScanner<Void, Void> scanner = new UnusedTreeScanner<Void, Void>(this){
                final /* synthetic */ JavacTaskListener this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Void visitModule(ModuleTree node, Void p) {
                    if (node instanceof JCTree.JCModuleDecl) {
                        JCTree.JCModuleDecl moduleDecl = (JCTree.JCModuleDecl)node;
                        IContainer expectedOutputDir = this.this$0.sourceOutputMapping.get(cu);
                        JavacClassFile currentClass = new JavacClassFile(moduleDecl, expectedOutputDir);
                        result.record(MODULE_INFO_NAME, currentClass);
                    }
                    return (Void)super.visitModule(node, p);
                }

                @Override
                public Void visitClass(ClassTree node, Void p) {
                    if (node instanceof JCTree.JCClassDecl) {
                        JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)node;
                        if (Objects.equals(currentTopLevelType, classDecl.sym) || !(classDecl.sym.owner instanceof Symbol.PackageSymbol)) {
                            String fullName = classDecl.sym.flatName().toString();
                            String compoundName = fullName.replace('.', '/');
                            Symbol enclosingClassSymbol = this.getEnclosingClass(classDecl.sym);
                            ClassFile enclosingClassFile = enclosingClassSymbol == null ? null : (ClassFile)visitedClasses.get(enclosingClassSymbol);
                            IContainer expectedOutputDir = this.this$0.sourceOutputMapping.get(cu);
                            JavacClassFile currentClass = new JavacClassFile(fullName, enclosingClassFile, expectedOutputDir);
                            visitedClasses.put(classDecl.sym, currentClass);
                            result.record(compoundName.toCharArray(), currentClass);
                            this.recordTypeHierarchy(classDecl.sym);
                        } else {
                            return null;
                        }
                    }
                    return (Void)super.visitClass(node, p);
                }

                @Override
                public Void visitIdentifier(IdentifierTree node, Void p) {
                    if (node instanceof JCTree.JCIdent) {
                        JCTree.JCIdent id = (JCTree.JCIdent)node;
                        Symbol symbol = id.sym;
                        if (symbol instanceof Symbol.TypeSymbol) {
                            Symbol.TypeSymbol typeSymbol = (Symbol.TypeSymbol)symbol;
                            String qualifiedName = typeSymbol.getQualifiedName().toString();
                            this.recordQualifiedReference(qualifiedName, false);
                        }
                    }
                    return (Void)super.visitIdentifier(node, p);
                }

                @Override
                public Void visitMemberSelect(MemberSelectTree node, Void p) {
                    if (node instanceof JCTree.JCFieldAccess) {
                        JCTree.JCFieldAccess field = (JCTree.JCFieldAccess)node;
                        if (field.sym != null && !(field.type instanceof Type.MethodType) && !(field.type instanceof Type.UnknownType)) {
                            this.recordQualifiedReference(node.toString(), false);
                            if (field.sym instanceof Symbol.VarSymbol) {
                                Symbol.TypeSymbol elementSymbol = field.type.tsym;
                                Type type = field.type;
                                if (type instanceof Type.ArrayType) {
                                    Type.ArrayType arrayType = (Type.ArrayType)type;
                                    elementSymbol = this.getElementType(arrayType);
                                }
                                if (elementSymbol instanceof Symbol.ClassSymbol) {
                                    Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)elementSymbol;
                                    this.recordQualifiedReference(classSymbol.className(), true);
                                }
                            }
                        }
                    }
                    return (Void)super.visitMemberSelect(node, p);
                }

                private Symbol getEnclosingClass(Symbol symbol) {
                    while (symbol != null) {
                        if (symbol.owner instanceof Symbol.ClassSymbol) {
                            return symbol.owner;
                        }
                        if (symbol.owner instanceof Symbol.PackageSymbol) {
                            return null;
                        }
                        symbol = symbol.owner;
                    }
                    return null;
                }

                private Symbol.TypeSymbol getElementType(Type.ArrayType arrayType) {
                    Type type = arrayType.elemtype;
                    if (type instanceof Type.ArrayType) {
                        Type.ArrayType subArrayType = (Type.ArrayType)type;
                        return this.getElementType(subArrayType);
                    }
                    return arrayType.elemtype.tsym;
                }

                private void recordQualifiedReference(String qualifiedName, boolean recursive) {
                    if (PRIMITIVE_TYPES.contains(qualifiedName)) {
                        return;
                    }
                    String[] nameParts = qualifiedName.split("\\.");
                    int length = nameParts.length;
                    if (length == 1) {
                        result.addRootReference(nameParts[0]);
                        result.addSimpleNameReference(nameParts[0]);
                        return;
                    }
                    if (!recursive) {
                        result.addRootReference(nameParts[0]);
                        result.addSimpleNameReference(nameParts[length - 1]);
                        result.addQualifiedReference(nameParts);
                    } else {
                        result.addRootReference(nameParts[0]);
                        while (result.addQualifiedReference(Arrays.copyOfRange(nameParts, 0, length))) {
                            if (length == 2) {
                                result.addSimpleNameReference(nameParts[0]);
                                result.addSimpleNameReference(nameParts[1]);
                                return;
                            }
                            result.addSimpleNameReference(nameParts[--length]);
                        }
                    }
                }

                private void recordTypeHierarchy(Symbol.ClassSymbol classSymbol) {
                    if (hierarchyRecorded.contains(classSymbol)) {
                        return;
                    }
                    hierarchyRecorded.add(classSymbol);
                    Type superClass = classSymbol.getSuperclass();
                    Symbol.TypeSymbol typeSymbol = superClass.tsym;
                    if (typeSymbol instanceof Symbol.ClassSymbol) {
                        Symbol.ClassSymbol superClassType = (Symbol.ClassSymbol)typeSymbol;
                        this.recordQualifiedReference(superClassType.className(), true);
                        this.recordTypeHierarchy(superClassType);
                    }
                    for (Type superInterface : classSymbol.getInterfaces()) {
                        Symbol.TypeSymbol typeSymbol2 = superInterface.tsym;
                        if (!(typeSymbol2 instanceof Symbol.ClassSymbol)) continue;
                        Symbol.ClassSymbol superInterfaceType = (Symbol.ClassSymbol)typeSymbol2;
                        this.recordQualifiedReference(superInterfaceType.className(), true);
                        this.recordTypeHierarchy(superInterfaceType);
                    }
                }
            };
            CompilationUnitTree unit = e.getCompilationUnit();
            try {
                scanner.scan(unit, null);
            }
            catch (Exception ex) {
                ILog.get().error("Internal error when visiting the AST Tree. " + ex.getMessage(), (Throwable)ex);
            }
            result.addUnusedMembers(scanner.getUnusedPrivateMembers(this.problemFactory));
            result.setUnusedImports(scanner.getUnusedImports(this.problemFactory));
        }
    }

    private boolean isGeneratedSource(JavaFileObject file) {
        List generatedSourcePaths = this.config.originalConfig().generatedSourcePaths();
        if (generatedSourcePaths == null || generatedSourcePaths.isEmpty()) {
            return false;
        }
        URI uri = file.toUri();
        if (uri != null && uri.getPath() != null) {
            File ioFile = new File(uri.getPath());
            java.nio.file.Path fileIOPath = ioFile.toPath();
            return generatedSourcePaths.stream().anyMatch(container -> {
                IPath location = container.getRawLocation();
                if (location != null) {
                    java.nio.file.Path locationIOPath = location.toPath();
                    return fileIOPath.startsWith(locationIOPath);
                }
                return false;
            });
        }
        return false;
    }

    private void writeClassFile(Symbol.ClassSymbol clazz) throws CoreException {
        if (this.outputDir == null) {
            return;
        }
        String qualifiedName = clazz.flatName().toString().replace('.', '/');
        Path filePath = new Path(qualifiedName);
        IContainer fileFolder = this.outputDir;
        if (filePath.segmentCount() > 1) {
            fileFolder = this.createFolder(filePath.removeLastSegments(1), this.outputDir);
            filePath = new Path(filePath.lastSegment());
        }
        IFile classFile = fileFolder.getFile(filePath.addFileExtension("class"));
        File tmpJavacClassFile = JavacClassFile.computeMappedTempClassFile(this.outputDir, qualifiedName);
        if (tmpJavacClassFile == null || !tmpJavacClassFile.exists()) {
            return;
        }
        try {
            byte[] bytes = Files.readAllBytes(tmpJavacClassFile.toPath());
            classFile.write(bytes, true, true, false, null);
            tmpJavacClassFile.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private IContainer createFolder(IPath packagePath, IContainer outputFolder) throws CoreException {
        if (packagePath.isEmpty()) {
            return outputFolder;
        }
        IFolder folder = outputFolder.getFolder(packagePath);
        if (!folder.exists()) {
            this.createFolder(packagePath.removeLastSegments(1), outputFolder);
            folder.create(1025, true, null);
        }
        return folder;
    }

    public void setOutputDir(IContainer outputDir) {
        this.outputDir = outputDir;
    }

    public Map<ICompilationUnit, JavacCompilationResult> getResults() {
        return this.results;
    }
}

