/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.extended.SnippetTextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class SnippetUtils {
    private static final String MARKDOWN_LANGUAGE = "java";
    private static final String TM_SELECTED_TEXT = "\\$TM_SELECTED_TEXT";
    private static final String TM_FILENAME_BASE = "\\$TM_FILENAME_BASE";
    public static final String SNIPPET_PREFIX = "${";
    public static final char SNIPPET_CHOICE_INDICATOR = '|';
    public static final String SNIPPET_CHOICE_POSTFIX = "|}";
    public static final String SNIPPET_CHOICE_SEPARATOR = ",";

    private SnippetUtils() {
    }

    public static String templateToSnippet(String pattern) {
        String evaluated = pattern.replaceAll("\\$\\$\\{(\\d):\\$\\{(.*?)\\}(.*?)\\}", "\\${$1:$2$3}");
        String escaped = evaluated.replaceAll("\\$\\$", "\\$");
        return escaped;
    }

    public static Either<String, MarkupContent> beautifyDocument(String raw) {
        String escapedString = raw.replaceAll("\\$\\{\\d\\|(.*?),.*?\\}", "$1");
        escapedString = escapedString.replaceAll("\\$\\{\\d:?(.*?)\\}", "$1");
        escapedString = escapedString.replaceAll(TM_SELECTED_TEXT, "");
        escapedString = escapedString.replaceAll(TM_FILENAME_BASE, "");
        if (JavaLanguageServerPlugin.getPreferencesManager() != null && JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences() != null && JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isSupportsCompletionDocumentationMarkdown()) {
            MarkupContent markupContent = new MarkupContent();
            markupContent.setKind("markdown");
            markupContent.setValue(String.format("```%s\n%s\n```", MARKDOWN_LANGUAGE, escapedString));
            return Either.forRight((Object)markupContent);
        }
        return Either.forLeft((Object)escapedString);
    }

    public static final void addSnippetsIfApplicable(LinkedCorrectionProposalCore proposal, WorkspaceEdit edit) throws CoreException {
        ICompilationUnit compilationUnit = proposal.getCompilationUnit();
        String proposalUri = JDTUtils.toURI(compilationUnit);
        IBuffer buffer = compilationUnit.getBuffer();
        LinkedProposalModelCore linkedProposals = proposal.getLinkedProposalModel();
        ArrayList<Triple> snippets = new ArrayList<Triple>();
        Iterator it = linkedProposals.getPositionGroupCoreIterator();
        while (it.hasNext()) {
            LinkedProposalPositionGroupCore group = (LinkedProposalPositionGroupCore)it.next();
            LinkedProposalPositionGroupCore.ProposalCore[] proposalList = group.getProposals();
            LinkedProposalPositionGroupCore.PositionInformation[] positionList = group.getPositions();
            Arrays.sort(positionList, (p1, p2) -> p1.getOffset() - p2.getOffset());
            StringBuilder snippet = new StringBuilder();
            snippet.append('|');
            int i = 0;
            while (i < positionList.length) {
                int offset = positionList[i].getOffset();
                int length = positionList[i].getLength();
                if (i == 0) {
                    LinkedPosition linkedPosition = new LinkedPosition(JsonRpcHelpers.toDocument(buffer), positionList[i].getOffset(), positionList[i].getLength(), positionList[i].getSequenceRank());
                    int j = 0;
                    while (j < proposalList.length) {
                        TextEdit editWithText = SnippetUtils.findReplaceEdit(proposalList[j].computeEdits(0, linkedPosition, '\u0000', 0, new LinkedModeModel()));
                        if (editWithText != null) {
                            snippet.append(((ReplaceEdit)editWithText).getText());
                            snippet.append(SNIPPET_CHOICE_SEPARATOR);
                        }
                        ++j;
                    }
                    if (String.valueOf(snippet.charAt(snippet.length() - 1)).equals(SNIPPET_CHOICE_SEPARATOR)) {
                        snippet.deleteCharAt(snippet.length() - 1);
                    }
                    snippet.append(SNIPPET_CHOICE_POSTFIX);
                    if (snippet.indexOf(SNIPPET_CHOICE_SEPARATOR) == -1) {
                        snippet.setCharAt(0, ':');
                        snippet.deleteCharAt(snippet.length() - 2);
                    }
                    snippets.add(new Triple(snippet.toString(), offset, length));
                } else {
                    Triple currentSnippet = (Triple)snippets.get(snippets.size() - 1);
                    currentSnippet.offset.add(offset);
                    currentSnippet.length.add(length);
                }
                ++i;
            }
        }
        if (!snippets.isEmpty()) {
            snippets.sort(null);
            int snippetNumber = 1;
            int i = snippets.size() - 1;
            while (i >= 0) {
                Triple element = (Triple)snippets.get(i);
                element.snippet = SNIPPET_PREFIX + snippetNumber + element.snippet;
                ++snippetNumber;
                int j = 1;
                while (j < element.offset.size()) {
                    snippets.add(new Triple(element.snippet.toString(), element.offset.get(j), element.length.get(j)));
                    element.offset.remove(j);
                    element.length.remove(j);
                    ++j;
                }
                --i;
            }
            snippets.sort(null);
            i = 0;
            while (i < edit.getDocumentChanges().size()) {
                if (((Either)edit.getDocumentChanges().get(i)).isLeft()) {
                    List edits = ((TextDocumentEdit)((Either)edit.getDocumentChanges().get(i)).getLeft()).getEdits();
                    String editUri = ((TextDocumentEdit)((Either)edit.getDocumentChanges().get(i)).getLeft()).getTextDocument().getUri();
                    int j = 0;
                    while (j < edits.size()) {
                        Range editRange = ((org.eclipse.lsp4j.TextEdit)edits.get(j)).getRange();
                        StringBuilder replacementText = new StringBuilder(((org.eclipse.lsp4j.TextEdit)edits.get(j)).getNewText());
                        int rangeStart = JsonRpcHelpers.toOffset(buffer, editRange.getStart().getLine(), editRange.getStart().getCharacter());
                        int rangeEnd = rangeStart + replacementText.length();
                        int k = 0;
                        while (k < snippets.size()) {
                            Triple currentSnippet = (Triple)snippets.get(k);
                            if (proposalUri.equals(editUri) && currentSnippet.offset.get(0) >= rangeStart && currentSnippet.offset.get(0) <= rangeEnd) {
                                int replaceStart = currentSnippet.offset.get(0) - rangeStart;
                                int replaceEnd = replaceStart + currentSnippet.length.get(0);
                                if (currentSnippet.snippet.endsWith(":}")) {
                                    currentSnippet.snippet = currentSnippet.snippet.replaceFirst(":", ":" + replacementText.substring(replaceStart, replaceEnd));
                                }
                                replacementText.replace(replaceStart, replaceEnd, currentSnippet.snippet);
                            }
                            ++k;
                        }
                        SnippetTextEdit newEdit = new SnippetTextEdit(editRange, replacementText.toString());
                        edits.set(j, newEdit);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private static final TextEdit findReplaceEdit(TextEdit edit) {
        if (edit instanceof ReplaceEdit && !((ReplaceEdit)edit).getText().isBlank()) {
            return edit;
        }
        if (edit instanceof MultiTextEdit) {
            TextEdit[] textEditArray = edit.getChildren();
            int n = textEditArray.length;
            int n2 = 0;
            while (n2 < n) {
                TextEdit child = textEditArray[n2];
                TextEdit replaceEdit = SnippetUtils.findReplaceEdit(child);
                if (replaceEdit != null) {
                    return replaceEdit;
                }
                ++n2;
            }
        }
        return null;
    }

    private static final class Triple
    implements Comparable<Triple> {
        public String snippet;
        public List<Integer> offset = new ArrayList<Integer>();
        public List<Integer> length = new ArrayList<Integer>();

        Triple(String snippet, int offset, int length) {
            this.snippet = snippet;
            this.offset.add(offset);
            this.length.add(length);
        }

        @Override
        public int compareTo(Triple other) {
            return other.offset.get(0) - this.offset.get(0);
        }
    }
}

