/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.ProvidesDirective;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.core.manipulation.BindingLabelProviderCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.changes.ClasspathChange;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.NameMatcher;
import org.eclipse.jdt.internal.ui.text.correction.ReorgCorrectionsBaseSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.SimilarElement;
import org.eclipse.jdt.internal.ui.text.correction.SimilarElementsRequestor;
import org.eclipse.jdt.internal.ui.text.correction.TypeMismatchBaseSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AddArgumentCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AddImportCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AddModuleRequiresCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AddTypeParameterProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.CastCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ChangeMethodSignatureProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.NewAbstractMethodCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.NewAnnotationMemberProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.NewMethodCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.NewVariableCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.QualifyTypeProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.RenameNodeCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ReplaceCorrectionProposalCore;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposalCore;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.osgi.framework.Bundle;

public abstract class UnresolvedElementsBaseSubProcessor<T> {
    protected static final int CompositeChangeProposal = 1;
    protected static final int NewVariableProposal1 = 100;
    protected static final int NewVariableProposal2 = 101;
    protected static final int NewVariableProposal3 = 102;
    protected static final int NewFieldForTypeProposal1 = 200;
    protected static final int NewFieldForTypeProposal2 = 210;
    protected static final int NewFieldForTypeProposal3 = 211;
    protected static final int NewFieldForTypeProposal4 = 220;
    protected static final int NewFieldForTypeProposal5 = 221;
    protected static final int SimilarVariableProposal1 = 300;
    protected static final int SimilarVariableProposal2 = 310;
    protected static final int SimilarVariableProposal3 = 320;
    protected static final int EnhancedForWithoutTypeProposal1 = 400;
    protected static final int CopyAnnotationsJarProposal1 = 500;
    protected static final int TypeRefChangeProposal1 = 820;
    protected static final int TypeRefChangeProposal2 = 830;
    protected static final int TypeRefChangeFullProposal1 = 910;
    protected static final int NewTypeProposalsParams1 = 1080;
    protected static final int RequiresModuleProposal1 = 1180;
    protected static final int MethodProposal1 = 1210;
    protected static final int MethodProposal2 = 1280;
    protected static final int StaticImportFavoriteProposal1 = 1310;
    protected static final int NewMethodProposal1 = 1410;
    protected static final int NewMethodProposal2 = 1420;
    protected static final int NewMethodProposal3 = 1430;
    protected static final int NewMethodProposal4 = 1450;
    protected static final int NewMethodProposal5 = 1475;
    protected static final int NewMethodProposal6 = 1480;
    protected static final int NewMethodProposal7 = 1490;
    protected static final int MissingCastParentsProposal1 = 1550;
    protected static final int ExistingParentCastProposal1 = 1650;
    protected static final int MoreParametersProposal1 = 1700;
    protected static final int MoreParametersProposal2 = 1750;
    protected static final int MoreArgumentsProposal1 = 1810;
    protected static final int MoreArgumentsProposal2 = 1850;
    protected static final int EqualNumberOfParameters1 = 1950;
    protected static final int EqualNumberOfParameters2 = 1970;
    protected static final int EqualNumberOfParameters3 = 1980;
    protected static final int AddQualifierToOuterProposal1 = 2000;
    protected static final int ConstructorProposal1 = 2100;
    protected static final int AmbiguosTypeReferenceProposal1 = 2200;
    protected static final int ArrayAccessProposal1 = 2300;
    protected static final int ArrayAccessProposal2 = 2301;
    protected static final int AnnotationMemberProposal1 = 2400;
    protected static final int AnnotationMemberProposal2 = 2401;
    private final String ADD_IMPORT_ID = "org.eclipse.jdt.ui.correction.addImport";

    protected UnresolvedElementsBaseSubProcessor() {
    }

    public void collectVariableProposals(IInvocationContext context, IProblemLocation problem, IVariableBinding resolvedField, Collection<T> proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveredNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        ITypeBinding binding = null;
        ITypeBinding declaringTypeBinding = Bindings.getBindingOfParentTypeContext(selectedNode);
        if (declaringTypeBinding == null) {
            return;
        }
        boolean suggestVariableProposals = true;
        int typeKind = 0;
        selectedNode = ASTNodes.getUnparenthesedExpression(selectedNode);
        SimpleName node = null;
        switch (selectedNode.getNodeType()) {
            case 42: {
                node = (SimpleName)selectedNode;
                ASTNode parent = node.getParent();
                StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
                if (locationInParent == ExpressionMethodReference.EXPRESSION_PROPERTY) {
                    typeKind = 30;
                    break;
                }
                if (locationInParent == MethodInvocation.EXPRESSION_PROPERTY) {
                    if (JavaModelUtil.is1d8OrHigher(cu.getJavaProject())) {
                        typeKind = 22;
                        break;
                    }
                    typeKind = 2;
                    break;
                }
                if (locationInParent == FieldAccess.NAME_PROPERTY) {
                    Expression expression = ((FieldAccess)parent).getExpression();
                    if (expression == null || (binding = expression.resolveTypeBinding()) != null) break;
                    node = null;
                    break;
                }
                if (parent instanceof SimpleType || parent instanceof NameQualifiedType) {
                    suggestVariableProposals = false;
                    typeKind = 62;
                    break;
                }
                if (parent instanceof QualifiedName) {
                    QualifiedName qualifiedParent = (QualifiedName)parent;
                    Name qualifier = qualifiedParent.getQualifier();
                    if (qualifier != node) {
                        binding = qualifier.resolveTypeBinding();
                    } else {
                        typeKind = 30;
                    }
                    ASTNode outerParent = parent.getParent();
                    while (outerParent instanceof QualifiedName) {
                        outerParent = outerParent.getParent();
                    }
                    if (!(outerParent instanceof SimpleType) && !(outerParent instanceof NameQualifiedType)) break;
                    typeKind = 30;
                    suggestVariableProposals = false;
                    break;
                }
                if (locationInParent == SwitchCase.EXPRESSION_PROPERTY || locationInParent == SwitchCase.EXPRESSIONS2_PROPERTY) {
                    ASTNode caseParent = node.getParent().getParent();
                    ITypeBinding switchExp = null;
                    if (caseParent instanceof SwitchStatement) {
                        SwitchStatement stmt = (SwitchStatement)caseParent;
                        switchExp = stmt.getExpression().resolveTypeBinding();
                    } else if (caseParent instanceof SwitchExpression) {
                        SwitchExpression stmt = (SwitchExpression)caseParent;
                        switchExp = stmt.getExpression().resolveTypeBinding();
                    }
                    if (switchExp == null || !switchExp.isEnum()) break;
                    binding = switchExp;
                    break;
                }
                if (locationInParent != SuperFieldAccess.NAME_PROPERTY) break;
                binding = declaringTypeBinding.getSuperclass();
                break;
            }
            case 40: {
                QualifiedName qualifierName = (QualifiedName)selectedNode;
                ITypeBinding qualifierBinding = qualifierName.getQualifier().resolveTypeBinding();
                if (qualifierBinding != null) {
                    node = qualifierName.getName();
                    binding = qualifierBinding;
                } else {
                    node = qualifierName.getQualifier();
                    typeKind = 30;
                    suggestVariableProposals = node.isSimpleName();
                }
                if (!(selectedNode.getParent() instanceof SimpleType) && !(selectedNode.getParent() instanceof NameQualifiedType)) break;
                typeKind = 30;
                suggestVariableProposals = false;
                break;
            }
            case 22: {
                FieldAccess access = (FieldAccess)selectedNode;
                Expression expression = access.getExpression();
                if (expression == null || (binding = expression.resolveTypeBinding()) == null) break;
                node = access.getName();
                break;
            }
            case 47: {
                binding = declaringTypeBinding.getSuperclass();
                node = ((SuperFieldAccess)selectedNode).getName();
            }
        }
        if (node == null) {
            return;
        }
        if (typeKind != 0) {
            if (!JavaModelUtil.is50OrHigher(cu.getJavaProject())) {
                typeKind &= 0xFFFFFFC7;
            }
            int relevance = Character.isUpperCase(ASTNodes.getSimpleNameIdentifier((Name)node).charAt(0)) ? 5 : -2;
            this.addSimilarTypeProposals(typeKind, cu, (Name)node, relevance + 1, proposals);
            this.collectNewTypeProposals(cu, (Name)node, typeKind &= 0xFFFFFFF7, relevance, proposals);
            this.getReorgSubProcessor().addProjectSetupFixProposals(context, problem, node.getFullyQualifiedName(), proposals);
        }
        if (!suggestVariableProposals) {
            return;
        }
        SimpleName simpleName = node.isSimpleName() ? node : ((QualifiedName)node).getName();
        boolean isWriteAccess = ASTResolving.isWriteAccess((Name)node);
        this.addSimilarVariableProposals(cu, astRoot, binding, resolvedField, simpleName, isWriteAccess, proposals);
        if (binding == null) {
            this.addStaticImportFavoriteProposals(context, simpleName, false, proposals);
        }
        if (resolvedField == null || binding == null || resolvedField.getDeclaringClass() != binding.getTypeDeclaration() && Modifier.isPrivate((int)resolvedField.getModifiers())) {
            this.addNewFieldProposals(cu, astRoot, binding, declaringTypeBinding, simpleName, isWriteAccess, proposals);
            if (binding == null && !this.isParentSwitchCase(simpleName)) {
                this.addNewVariableProposals(cu, (Name)node, simpleName, proposals);
            }
        }
    }

    private void addNewVariableProposals(ICompilationUnit cu, Name node, SimpleName simpleName, Collection<T> proposals) {
        Assignment assignment;
        T p;
        NewVariableCorrectionProposalCore core;
        String label;
        int relevance;
        String name = simpleName.getIdentifier();
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)node, true);
        int type = bodyDeclaration.getNodeType();
        if (type == 31) {
            relevance = StubUtility.hasParameterName(cu.getJavaProject(), name) ? 8 : 5;
            label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createparameter_description, BasicElementLabels.getJavaElementName(name));
            core = new NewVariableCorrectionProposalCore(label, cu, 3, simpleName, null, relevance, false);
            p = this.newVariableCorrectionProposalToT(core, 100);
            if (p != null) {
                proposals.add(p);
            }
        }
        if (type == 28 || type == 31 && !ASTResolving.isInsideConstructorInvocation((MethodDeclaration)bodyDeclaration, (ASTNode)node)) {
            relevance = StubUtility.hasLocalVariableName(cu.getJavaProject(), name) ? 10 : 7;
            label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createlocal_description, BasicElementLabels.getJavaElementName(name));
            core = new NewVariableCorrectionProposalCore(label, cu, 1, simpleName, null, relevance, false);
            p = this.newVariableCorrectionProposalToT(core, 101);
            if (p != null) {
                proposals.add(p);
            }
        }
        if (node.getParent().getNodeType() == 7 && (assignment = (Assignment)node.getParent()).getLeftHandSide() == node && assignment.getParent().getNodeType() == 21) {
            ASTNode statement = assignment.getParent();
            ASTRewrite rewrite = ASTRewrite.create((AST)statement.getAST());
            if (ASTNodes.isControlStatementBody(assignment.getParent().getLocationInParent())) {
                rewrite.replace(statement, (ASTNode)rewrite.getAST().newBlock(), null);
            } else {
                rewrite.remove(statement, null);
            }
            String label2 = CorrectionMessages.UnresolvedElementsSubProcessor_removestatement_description;
            ASTRewriteCorrectionProposalCore core2 = new ASTRewriteCorrectionProposalCore(label2, cu, rewrite, 4);
            T proposal = this.rewriteProposalToT(core2, 102);
            if (proposal != null) {
                proposals.add(proposal);
            }
        }
    }

    private void addNewFieldProposals(ICompilationUnit cu, CompilationUnit astRoot, ITypeBinding binding, ITypeBinding declaringTypeBinding, SimpleName simpleName, boolean isWriteAccess, Collection<T> proposals) throws JavaModelException {
        ITypeBinding bind;
        ASTNode anonymDecl;
        ICompilationUnit targetCU;
        ITypeBinding senderDeclBinding;
        if (binding != null) {
            senderDeclBinding = binding.getTypeDeclaration();
            targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, senderDeclBinding);
        } else {
            senderDeclBinding = declaringTypeBinding;
            targetCU = cu;
        }
        if (!senderDeclBinding.isFromSource() || targetCU == null) {
            return;
        }
        boolean mustBeConst = ASTResolving.isInsideModifiers((ASTNode)simpleName) || this.isParentSwitchCase(simpleName);
        this.addNewFieldForType(targetCU, binding, senderDeclBinding, simpleName, isWriteAccess, mustBeConst, proposals);
        if (binding == null && senderDeclBinding.isNested() && (anonymDecl = astRoot.findDeclaringNode((IBinding)senderDeclBinding)) != null && !(bind = Bindings.getBindingOfParentType(anonymDecl.getParent())).isAnonymous()) {
            this.addNewFieldForType(targetCU, bind, bind, simpleName, isWriteAccess, mustBeConst, proposals);
        }
    }

    private boolean isParentSwitchCase(SimpleName simpleName) {
        if (simpleName != null) {
            return simpleName.getParent() instanceof SwitchCase;
        }
        return false;
    }

    private void addNewFieldForType(ICompilationUnit targetCU, ITypeBinding binding, ITypeBinding senderDeclBinding, SimpleName simpleName, boolean isWriteAccess, boolean mustBeConst, Collection<T> proposals) {
        String name = simpleName.getIdentifier();
        String nameLabel = BasicElementLabels.getJavaElementName(name);
        if (senderDeclBinding.isEnum() && !isWriteAccess) {
            String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createenum_description, new Object[]{nameLabel, ASTResolving.getTypeSignature(senderDeclBinding)});
            NewVariableCorrectionProposalCore core = new NewVariableCorrectionProposalCore(label, targetCU, 5, simpleName, senderDeclBinding, 10, false);
            T p1 = this.newVariableCorrectionProposalToT(core, 200);
            if (p1 != null) {
                proposals.add(p1);
            }
        } else {
            T prop;
            NewVariableCorrectionProposalCore core;
            String label;
            if (!mustBeConst) {
                int uid;
                int fieldRelevance;
                int n = fieldRelevance = StubUtility.hasFieldName(targetCU.getJavaProject(), name) ? 9 : 6;
                if (binding == null) {
                    label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createfield_description, nameLabel);
                    uid = 210;
                } else {
                    label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createfield_other_description, new Object[]{nameLabel, ASTResolving.getTypeSignature(senderDeclBinding)});
                    uid = 211;
                }
                core = new NewVariableCorrectionProposalCore(label, targetCU, 2, simpleName, senderDeclBinding, fieldRelevance, false);
                prop = this.newVariableCorrectionProposalToT(core, uid);
                if (prop != null) {
                    proposals.add(prop);
                }
            }
            if (!isWriteAccess && !senderDeclBinding.isAnonymous()) {
                int uid;
                if (binding == null) {
                    label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createconst_description, nameLabel);
                    uid = 220;
                } else {
                    label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createconst_other_description, new Object[]{nameLabel, ASTResolving.getTypeSignature(senderDeclBinding)});
                    uid = 221;
                }
                int constRelevance = StubUtility.hasConstantName(targetCU.getJavaProject(), name) ? 9 : 4;
                core = new NewVariableCorrectionProposalCore(label, targetCU, 4, simpleName, senderDeclBinding, constRelevance, false);
                prop = this.newVariableCorrectionProposalToT(core, uid);
                if (prop != null) {
                    proposals.add(prop);
                }
            }
        }
    }

    private void addSimilarVariableProposals(ICompilationUnit cu, CompilationUnit astRoot, ITypeBinding binding, IVariableBinding resolvedField, SimpleName node, boolean isWriteAccess, Collection<T> proposals) {
        String idLength;
        String label;
        RenameNodeCorrectionProposalCore core;
        T prop;
        IBinding[] varsAndMethodsInScope;
        int kind = 18;
        if (!isWriteAccess) {
            kind |= 1;
        }
        if ((varsAndMethodsInScope = new ScopeAnalyzer(astRoot).getDeclarationsInScope(node, kind)).length > 0) {
            String otherNameInAssign = null;
            String methodSenderName = null;
            String fieldSenderName = null;
            ASTNode parent = node.getParent();
            switch (parent.getNodeType()) {
                case 59: {
                    otherNameInAssign = ((VariableDeclarationFragment)parent).getName().getIdentifier();
                    break;
                }
                case 7: {
                    Expression expression;
                    Expression expression2;
                    Assignment assignment = (Assignment)parent;
                    if (isWriteAccess && (expression2 = assignment.getRightHandSide()) instanceof SimpleName) {
                        SimpleName rightSide = (SimpleName)expression2;
                        otherNameInAssign = rightSide.getIdentifier();
                        break;
                    }
                    if (isWriteAccess || !((expression = assignment.getLeftHandSide()) instanceof SimpleName)) break;
                    SimpleName leftSide = (SimpleName)expression;
                    otherNameInAssign = leftSide.getIdentifier();
                    break;
                }
                case 32: {
                    MethodInvocation inv = (MethodInvocation)parent;
                    if (inv.getExpression() != node) break;
                    methodSenderName = inv.getName().getIdentifier();
                    break;
                }
                case 40: {
                    QualifiedName qualName = (QualifiedName)parent;
                    if (qualName.getQualifier() != node) break;
                    fieldSenderName = qualName.getName().getIdentifier();
                }
            }
            ITypeBinding guessedType = ASTResolving.guessBindingForReference((ASTNode)node);
            ITypeBinding objectBinding = astRoot.getAST().resolveWellKnownType("java.lang.Object");
            String identifier = node.getIdentifier();
            boolean isInStaticContext = ASTResolving.isInStaticContext((ASTNode)node);
            ArrayList<T> newProposals = new ArrayList<T>(51);
            int i = 0;
            while (i < varsAndMethodsInScope.length && newProposals.size() <= 50) {
                IMethodBinding curr;
                IBinding varOrMeth = varsAndMethodsInScope[i];
                if (varOrMeth instanceof IVariableBinding) {
                    boolean isFinal;
                    IVariableBinding curr2 = (IVariableBinding)varOrMeth;
                    String currName = curr2.getName();
                    if (!(currName.equals(otherNameInAssign) || resolvedField != null && Bindings.equals((IBinding)resolvedField, (IBinding)curr2) || (isFinal = Modifier.isFinal((int)curr2.getModifiers())) && curr2.isField() && isWriteAccess || isInStaticContext && !Modifier.isStatic((int)curr2.getModifiers()) && curr2.isField())) {
                        String label2;
                        RenameNodeCorrectionProposalCore core2;
                        T prop2;
                        ITypeBinding varType;
                        int relevance = 0;
                        if (NameMatcher.isSimilarName(currName, identifier)) {
                            relevance += 3;
                        }
                        if (currName.equalsIgnoreCase(identifier)) {
                            relevance += 5;
                        }
                        if ((varType = curr2.getType()) != null) {
                            if (guessedType != null && guessedType != objectBinding && (!isWriteAccess && this.canAssign(varType, guessedType) || isWriteAccess && this.canAssign(guessedType, varType))) {
                                relevance += 2;
                            }
                            if (methodSenderName != null && this.hasMethodWithName(varType, methodSenderName)) {
                                relevance += 2;
                            }
                            if (fieldSenderName != null && this.hasFieldWithName(varType, fieldSenderName)) {
                                relevance += 2;
                            }
                        }
                        if (relevance > 0 && (prop2 = this.renameNodeCorrectionProposalToT(core2 = new RenameNodeCorrectionProposalCore(label2 = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changevariable_description, BasicElementLabels.getJavaElementName(currName)), cu, node.getStartPosition(), node.getLength(), currName, relevance), 300)) != null) {
                            newProposals.add(prop2);
                        }
                    }
                } else if (varOrMeth instanceof IMethodBinding && !(curr = (IMethodBinding)varOrMeth).isConstructor() && guessedType != null && this.canAssign(curr.getReturnType(), guessedType) && NameMatcher.isSimilarName(curr.getName(), identifier)) {
                    AST ast = astRoot.getAST();
                    ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                    String label3 = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changetomethod_description, ASTResolving.getMethodSignature(curr));
                    LinkedCorrectionProposalCore proposal = new LinkedCorrectionProposalCore(label3, cu, rewrite, 8);
                    MethodInvocation newInv = ast.newMethodInvocation();
                    newInv.setName(ast.newSimpleName(curr.getName()));
                    ITypeBinding[] iTypeBindingArray = curr.getParameterTypes();
                    int n = iTypeBindingArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITypeBinding parameterType = iTypeBindingArray[n2];
                        Expression arg = ASTNodeFactory.newDefaultExpression(ast, parameterType);
                        newInv.arguments().add(arg);
                        proposal.addLinkedPosition(rewrite.track((ASTNode)arg), false, null);
                        ++n2;
                    }
                    rewrite.replace((ASTNode)node, (ASTNode)newInv, null);
                    T proposalT = this.linkedProposalToT(proposal, 310);
                    if (proposalT != null) {
                        newProposals.add(proposalT);
                    }
                }
                ++i;
            }
            if (newProposals.size() <= 50) {
                proposals.addAll(newProposals);
            }
        }
        if (binding != null && binding.isArray() && (prop = this.renameNodeProposalToT(core = new RenameNodeCorrectionProposalCore(label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changevariable_description, idLength = "length"), cu, node.getStartPosition(), node.getLength(), idLength, 8), 320)) != null) {
            proposals.add(prop);
        }
    }

    private boolean canAssign(ITypeBinding returnType, ITypeBinding guessedType) {
        return returnType.isAssignmentCompatible(guessedType);
    }

    private boolean hasMethodWithName(ITypeBinding typeBinding, String name) {
        IVariableBinding[] iVariableBindingArray = typeBinding.getDeclaredFields();
        int n = iVariableBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableBinding field = iVariableBindingArray[n2];
            if (field.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        ITypeBinding superclass = typeBinding.getSuperclass();
        if (superclass != null) {
            return this.hasMethodWithName(superclass, name);
        }
        return false;
    }

    private boolean hasFieldWithName(ITypeBinding typeBinding, String name) {
        IMethodBinding[] iMethodBindingArray = typeBinding.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            if (method.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        ITypeBinding superclass = typeBinding.getSuperclass();
        if (superclass != null) {
            return this.hasMethodWithName(superclass, name);
        }
        return false;
    }

    private int evauateTypeKind(ASTNode node, IJavaProject project) {
        int kind = ASTResolving.getPossibleTypeKinds(node, JavaModelUtil.is50OrHigher(project));
        return kind;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void collectTypeProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) throws CoreException {
        ICompilationUnit moduleCompilationUnit;
        SimpleName s;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        while (selectedNode instanceof ParenthesizedExpression) {
            ParenthesizedExpression parenthesizedExp = (ParenthesizedExpression)selectedNode;
            selectedNode = parenthesizedExp.getExpression();
        }
        IJavaProject javaProject = cu.getJavaProject();
        int kind = this.evauateTypeKind(selectedNode, javaProject);
        if (kind == 30 && (s = this.addEnhancedForWithoutTypeProposals(cu, selectedNode, proposals)) != null && Character.isLowerCase(s.getFullyQualifiedName().charAt(0))) {
            return;
        }
        if (selectedNode instanceof CastExpression) {
            CastExpression castExp = (CastExpression)selectedNode;
            selectedNode = castExp.getType();
        }
        if (selectedNode instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)selectedNode;
            selectedNode = parameterizedType.getType();
        }
        while (selectedNode.getLocationInParent() == QualifiedName.NAME_PROPERTY) {
            selectedNode = selectedNode.getParent();
        }
        Name node = null;
        if (selectedNode instanceof SimpleType) {
            SimpleType selectedType = (SimpleType)selectedNode;
            node = selectedType.getName();
        } else if (selectedNode instanceof NameQualifiedType) {
            NameQualifiedType nameQualified = (NameQualifiedType)selectedNode;
            node = nameQualified.getName();
        } else if (selectedNode instanceof ArrayType) {
            ArrayType arr = (ArrayType)selectedNode;
            Type elementType = arr.getElementType();
            if (elementType.isSimpleType()) {
                node = ((SimpleType)elementType).getName();
            } else {
                if (!elementType.isNameQualifiedType()) return;
                node = ((NameQualifiedType)elementType).getName();
            }
        } else {
            if (!(selectedNode instanceof Name)) return;
            node = (Name)selectedNode;
        }
        if (node instanceof SimpleName && !JavaModelUtil.is11OrHigher(javaProject)) {
            boolean isVarTypeProblem = false;
            if (problem.getProblemId() == 1073743335) {
                isVarTypeProblem = true;
            } else {
                String name;
                String[] args = problem.getProblemArguments();
                if (args != null && args.length > 0 && "var".equals(name = args[0])) {
                    isVarTypeProblem = true;
                }
            }
            if (isVarTypeProblem) {
                ReorgCorrectionsBaseSubProcessor<T> reorg;
                boolean isVarInLambdaParamType = false;
                ASTNode parent = node.getParent();
                if (parent instanceof SimpleType && parent.getLocationInParent() == SingleVariableDeclaration.TYPE_PROPERTY && (parent = parent.getParent()).getLocationInParent() == LambdaExpression.PARAMETERS_PROPERTY) {
                    isVarInLambdaParamType = true;
                }
                if ((reorg = this.getReorgSubProcessor()) != null) {
                    if (isVarInLambdaParamType) {
                        this.getReorgSubProcessor().addNeedHigherComplianceProposals(context, problem, proposals, "11");
                    } else {
                        this.getReorgSubProcessor().addNeedHigherComplianceProposals(context, problem, proposals, "10");
                    }
                }
            }
        }
        this.addSimilarTypeProposals(kind, cu, node, 3, proposals);
        while (node.getParent() instanceof QualifiedName) {
            node = (Name)node.getParent();
        }
        IModuleDescription moduleDescription = cu.getModule();
        if (moduleDescription != null && moduleDescription.exists() && javaProject != null && JavaModelUtil.is9OrHigher(javaProject) && cu.equals(moduleCompilationUnit = moduleDescription.getCompilationUnit())) {
            ProvidesDirective providesDir;
            Name serviceName;
            IBinding binding;
            this.collectRequiresModuleProposals(cu, node, kind, proposals, false);
            ASTNode parentNode = node.getParent();
            if (parentNode instanceof ProvidesDirective && (binding = (serviceName = (providesDir = (ProvidesDirective)parentNode).getName()).resolveBinding()) instanceof ITypeBinding) {
                ITypeBinding typeBinding = (ITypeBinding)binding;
                if (typeBinding.isClass()) {
                    kind = 2;
                } else if (typeBinding.isInterface()) {
                    kind = 6;
                }
            }
        }
        if (selectedNode != node) {
            kind = this.evauateTypeKind((ASTNode)node, javaProject);
        }
        if ((kind & 6) != 0) {
            kind &= 0xFFFFFFF7;
        }
        this.collectNewTypeProposals(cu, node, kind, 0, proposals);
        this.getReorgSubProcessor().addProjectSetupFixProposals(context, problem, node.getFullyQualifiedName(), proposals);
    }

    private SimpleName addEnhancedForWithoutTypeProposals(ICompilationUnit cu, ASTNode selectedNode, Collection<T> proposals) {
        if (selectedNode instanceof SimpleName) {
            SingleVariableDeclaration svd;
            ASTNode type;
            SimpleName simpleName = (SimpleName)selectedNode;
            if ((selectedNode.getLocationInParent() == SimpleType.NAME_PROPERTY || selectedNode.getLocationInParent() == NameQualifiedType.NAME_PROPERTY) && (type = selectedNode.getParent()).getLocationInParent() == SingleVariableDeclaration.TYPE_PROPERTY && (svd = (SingleVariableDeclaration)type.getParent()).getLocationInParent() == EnhancedForStatement.PARAMETER_PROPERTY && svd.getName().getLength() == 0) {
                String name = simpleName.getIdentifier();
                int relevance = StubUtility.hasLocalVariableName(cu.getJavaProject(), name) ? 10 : 7;
                String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_create_loop_variable_description, BasicElementLabels.getJavaElementName(name));
                NewVariableCorrectionProposalCore core = new NewVariableCorrectionProposalCore(label, cu, 1, simpleName, null, relevance, false);
                T prop = this.newVariableCorrectionProposalToT(core, 400);
                if (prop != null) {
                    proposals.add(prop);
                }
                return simpleName;
            }
        }
        return null;
    }

    protected void addNullityAnnotationTypesProposals(ICompilationUnit cu, Name node, Collection<T> proposals) throws CoreException {
        boolean isAnnotationName;
        ASTNode parent = node.getParent();
        boolean bl = isAnnotationName = parent instanceof Annotation && ((Annotation)parent).getTypeNameProperty() == node.getLocationInParent();
        if (!isAnnotationName) {
            boolean isImportName;
            boolean bl2 = isImportName = parent instanceof ImportDeclaration && ImportDeclaration.NAME_PROPERTY == node.getLocationInParent();
            if (!isImportName) {
                return;
            }
        }
        IJavaProject javaProject = cu.getJavaProject();
        String name = node.getFullyQualifiedName();
        String nullityAnnotation = null;
        String[] annotationNameOptions = new String[]{"org.eclipse.jdt.core.compiler.annotation.nullable", "org.eclipse.jdt.core.compiler.annotation.nonnull", "org.eclipse.jdt.core.compiler.annotation.nonnullbydefault"};
        Hashtable defaultOptions = JavaCore.getDefaultOptions();
        String[] stringArray = annotationNameOptions;
        int n = annotationNameOptions.length;
        int n2 = 0;
        while (n2 < n) {
            String annotationNameOption = stringArray[n2];
            String annotationName = javaProject.getOption(annotationNameOption, true);
            if (!annotationName.equals(defaultOptions.get(annotationNameOption))) {
                return;
            }
            if (JavaModelUtil.isMatchingName(name, annotationName)) {
                nullityAnnotation = annotationName;
            }
            ++n2;
        }
        if (nullityAnnotation == null) {
            return;
        }
        if (javaProject.findType((String)defaultOptions.get(annotationNameOptions[0])) != null) {
            return;
        }
        String version = JavaModelUtil.is1d8OrHigher(javaProject) ? "2" : "[1.1.0,2.0.0)";
        Bundle[] annotationsBundles = JavaManipulationPlugin.getDefault().getBundles("org.eclipse.jdt.annotation", version);
        if (annotationsBundles == null) {
            return;
        }
        if (!cu.getJavaProject().getProject().hasNature("org.eclipse.pde.PluginNature")) {
            this.addCopyAnnotationsJarProposal(cu, node, nullityAnnotation, annotationsBundles[0], proposals);
        }
    }

    private void addCopyAnnotationsJarProposal(final ICompilationUnit cu, final Name name, final String fullyQualifiedName, Bundle annotationsBundle, Collection<T> proposals) {
        final IJavaProject javaProject = cu.getJavaProject();
        Optional bundleFileLocation = FileLocator.getBundleFileLocation((Bundle)annotationsBundle);
        if (bundleFileLocation.isEmpty()) {
            return;
        }
        final File bundleFile = (File)bundleFileLocation.get();
        if (!bundleFile.isFile() || !bundleFile.canRead()) {
            return;
        }
        final String changeName = CorrectionMessages.UnresolvedElementsSubProcessor_copy_annotation_jar_description;
        ChangeCorrectionProposalCore proposal = new ChangeCorrectionProposalCore(changeName, null, 0){

            @Override
            protected Change createChange() throws CoreException {
                final IFile file = javaProject.getProject().getFile(bundleFile.getName());
                ResourceChange copyFileChange = new ResourceChange(){

                    public Change perform(IProgressMonitor pm) throws CoreException {
                        try {
                            if (file.exists()) {
                                file.delete(false, pm);
                            }
                            file.create((InputStream)new ByteArrayInputStream(Files.readAllBytes(bundleFile.toPath())), false, pm);
                            return new DeleteResourceChange(file.getFullPath(), false);
                        }
                        catch (IOException e) {
                            throw new CoreException((IStatus)new Status(4, JavaManipulationPlugin.getPluginId(), e.getMessage()));
                        }
                    }

                    public String getName() {
                        return changeName;
                    }

                    protected IResource getModifiedResource() {
                        return javaProject.getProject();
                    }
                };
                ClasspathChange addEntryChange = ClasspathChange.addEntryChange(javaProject, JavaCore.newLibraryEntry((IPath)file.getFullPath(), null, null));
                CompilationUnitChange addImportChange = UnresolvedElementsBaseSubProcessor.createAddImportChange(cu, name, fullyQualifiedName);
                return new CompositeChange(changeName, new Change[]{copyFileChange, addEntryChange, addImportChange});
            }

            @Override
            public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
                return CorrectionMessages.UnresolvedElementsSubProcessor_copy_annotation_jar_info;
            }
        };
        T prop = this.changeCorrectionProposalToT(proposal, 500);
        if (prop != null) {
            proposals.add(prop);
        }
    }

    static CompilationUnitChange createAddImportChange(ICompilationUnit cu, Name name, String fullyQualifiedName) throws CoreException {
        Object[] args = new String[]{BasicElementLabels.getJavaElementName(Signature.getSimpleName((String)fullyQualifiedName)), BasicElementLabels.getJavaElementName(Signature.getQualifier((String)fullyQualifiedName))};
        String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_importtype_description, args);
        CompilationUnitChange cuChange = new CompilationUnitChange(label, cu);
        ImportRewrite importRewrite = StubUtility.createImportRewrite((CompilationUnit)name.getRoot(), true);
        importRewrite.addImport(fullyQualifiedName);
        cuChange.setEdit(importRewrite.rewriteImports(null));
        return cuChange;
    }

    private void addSimilarTypeProposals(int kind, ICompilationUnit cu, Name node, int relevance, Collection<T> proposals) throws CoreException {
        SimilarElement[] elements = SimilarElementsRequestor.findSimilarElement(cu, node, kind);
        String resolvedTypeName = null;
        ITypeBinding binding = ASTResolving.guessBindingForTypeReference((ASTNode)node);
        ITypeBinding simpleBinding = null;
        if (binding != null) {
            simpleBinding = binding;
            if (simpleBinding.isArray()) {
                simpleBinding = simpleBinding.getElementType();
            }
            if (!(simpleBinding = simpleBinding.getTypeDeclaration()).isRecovered()) {
                T toAdd;
                resolvedTypeName = simpleBinding.getQualifiedName();
                T proposal = this.createTypeRefChangeProposal(cu, resolvedTypeName, node, relevance + 2, elements.length);
                ChangeCorrectionProposalCore original = this.getOriginalProposalFromT(proposal);
                T compositeProposal = this.getCompositeChangeProposal(proposal);
                ChangeCorrectionProposalCore compositeOriginal = this.getOriginalProposalFromT(compositeProposal);
                if (compositeProposal != null) {
                    proposals.add(compositeProposal);
                } else if (proposal != null) {
                    proposals.add(proposal);
                }
                if (original instanceof AddImportCorrectionProposalCore) {
                    int rel = relevance + elements.length + 2;
                    original.setRelevance(rel);
                    if (compositeProposal != null) {
                        compositeOriginal.setRelevance(rel);
                    }
                }
                if (binding.isParameterizedType() && (node.getParent() instanceof SimpleType || node.getParent() instanceof NameQualifiedType) && !(node.getParent().getParent() instanceof Type) && (toAdd = this.createTypeRefChangeFullProposal(cu, binding, (ASTNode)node, relevance + 5, ImportRewrite.TypeLocation.UNKNOWN)) != null) {
                    proposals.add(toAdd);
                }
            }
        } else {
            T toAdd;
            ITypeBinding normBinding;
            ASTNode normalizedNode = ASTNodes.getNormalizedNode((ASTNode)node);
            if (!(normalizedNode.getParent() instanceof Type) && node.getParent() != normalizedNode && (normBinding = ASTResolving.guessBindingForTypeReference(normalizedNode)) != null && !normBinding.isRecovered() && (toAdd = this.createTypeRefChangeFullProposal(cu, normBinding, normalizedNode, relevance + 5, ImportRewrite.TypeLocation.UNKNOWN)) != null) {
                proposals.add(toAdd);
            }
        }
        SimilarElement[] similarElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block23: {
                T cuProposal;
                T compositeProposal;
                String fullName;
                block24: {
                    SimilarElement elem = similarElementArray[n2];
                    if ((elem.getKind() & 0x7E) == 0 || (fullName = elem.getName()).equals(resolvedTypeName)) break block23;
                    if (simpleBinding == null || simpleBinding.isPrimitive()) break block24;
                    ITypeBinding qualifiedTypeBinding = null;
                    try {
                        IJavaProject focus = simpleBinding.getJavaElement().getJavaProject();
                        IType javaElementType = focus.findType(fullName);
                        if (javaElementType != null) {
                            ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
                            parser.setProject(focus);
                            IBinding[] bindings = parser.createBindings(new IJavaElement[]{javaElementType}, null);
                            qualifiedTypeBinding = (ITypeBinding)bindings[0];
                        }
                    }
                    catch (JavaModelException focus) {
                        // empty catch block
                    }
                    if (qualifiedTypeBinding != null && !qualifiedTypeBinding.getName().equals(simpleBinding.getName()) && !qualifiedTypeBinding.isGenericType() && !qualifiedTypeBinding.isParameterizedType() && !qualifiedTypeBinding.isWildcardType() && !qualifiedTypeBinding.isRawType() && !qualifiedTypeBinding.isRecord() && !qualifiedTypeBinding.isRecovered() && !this.isInherited(qualifiedTypeBinding, simpleBinding)) break block23;
                }
                if ((compositeProposal = this.getCompositeChangeProposal(cuProposal = this.createTypeRefChangeProposal(cu, fullName, node, relevance, elements.length))) != null) {
                    proposals.add(compositeProposal);
                } else if (cuProposal != null) {
                    proposals.add(cuProposal);
                }
            }
            ++n2;
        }
        if (elements.length == 0) {
            this.collectRequiresModuleProposals(cu, node, 5, proposals, true);
        }
    }

    private boolean isInherited(ITypeBinding binding, ITypeBinding ancestorBinding) {
        if (binding == null) {
            return false;
        }
        if (binding.isEqualTo((IBinding)ancestorBinding)) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = binding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding interfaceBinding = iTypeBindingArray[n2];
            if (this.isInherited(interfaceBinding, ancestorBinding)) {
                return true;
            }
            ++n2;
        }
        return this.isInherited(binding.getSuperclass(), ancestorBinding);
    }

    private T getCompositeChangeProposal(T proposal) throws CoreException {
        ChangeCorrectionProposalCore original = this.getOriginalProposalFromT(proposal);
        return this.getCompositeChangeProposal(original);
    }

    private T getCompositeChangeProposal(ChangeCorrectionProposalCore proposal) throws CoreException {
        ChangeCorrectionProposalCore compositeProposal = null;
        if (proposal instanceof AddImportCorrectionProposalCore) {
            Change change;
            AddImportCorrectionProposalCore aicpc = (AddImportCorrectionProposalCore)proposal;
            AddModuleRequiresCorrectionProposalCore cp = aicpc.getAdditionalProposal();
            final Change importChange = proposal.getChange();
            Change change2 = change = cp == null ? null : cp.getChange();
            if (change != null) {
                String[] imports;
                ImportRewrite importRewrite = aicpc.getImportRewrite();
                boolean importNeedsToBeAdded = false;
                if (importRewrite != null && (imports = importRewrite.getAddedImports()) != null && imports.length > 0) {
                    importNeedsToBeAdded = true;
                }
                if (importNeedsToBeAdded) {
                    change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                    String importChangeName = importChange.getName();
                    Object moduleRequiresChangeName = change.getName();
                    moduleRequiresChangeName = ((String)moduleRequiresChangeName).substring(0, 1).toLowerCase() + ((String)moduleRequiresChangeName).substring(1);
                    final String changeName = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_combine_two_proposals_info, new String[]{importChangeName, moduleRequiresChangeName});
                    compositeProposal = new ChangeCorrectionProposalCore(changeName, null, 5){

                        @Override
                        protected Change createChange() throws CoreException {
                            return new CompositeChange(changeName, new Change[]{change, importChange});
                        }

                        @Override
                        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
                            return changeName;
                        }
                    };
                } else {
                    compositeProposal = new ChangeCorrectionProposalCore(change.getName(), null, 5){

                        @Override
                        protected Change createChange() throws CoreException {
                            return change;
                        }

                        @Override
                        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
                            return change.getName();
                        }
                    };
                }
            }
        }
        return compositeProposal == null ? null : (T)this.compositeProposalToT(compositeProposal, -1);
    }

    private T createTypeRefChangeProposal(ICompilationUnit cu, String fullName, Name node, int relevance, int maxProposals) {
        ASTRewriteCorrectionProposalCore proposal;
        ImportRewrite importRewrite = null;
        String simpleName = fullName;
        String packName = Signature.getQualifier((String)fullName);
        if (packName.length() > 0) {
            importRewrite = StubUtility.createImportRewrite((CompilationUnit)node.getRoot(), true);
            BodyDeclaration scope = ASTResolving.findParentBodyDeclaration((ASTNode)node);
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)(scope != null ? scope : node), importRewrite);
            simpleName = importRewrite.addImport(fullName, (ImportRewrite.ImportRewriteContext)context);
        }
        if (!this.isLikelyTypeName(simpleName)) {
            relevance -= 2;
        }
        int uid = -1;
        if (importRewrite != null && node.isSimpleName() && simpleName.equals(((SimpleName)node).getIdentifier())) {
            try {
                IType[] types;
                IType[] iTypeArray = types = cu.getAllTypes();
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    if (type.getFullyQualifiedName('.').equals(fullName)) {
                        String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_change_to_qualified_description, fullName);
                        proposal = new QualifyTypeProposalCore(label, cu, relevance + 100, (SimpleName)node, fullName);
                        return this.qualifyTypeProposalToT((QualifyTypeProposalCore)proposal, 810);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                return null;
            }
            Object[] arg = new String[]{BasicElementLabels.getJavaElementName(simpleName), BasicElementLabels.getJavaElementName(packName)};
            String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_importtype_description, arg);
            int boost = this.getQualifiedTypeNameHistoryBoost(fullName, 0, maxProposals);
            proposal = new AddImportCorrectionProposalCore(label, cu, relevance + 100 + boost, packName, simpleName, (SimpleName)node);
            proposal.setCommandId("org.eclipse.jdt.ui.correction.addImport");
            uid = 820;
        } else {
            String label;
            if (packName.length() == 0) {
                label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changetype_nopack_description, BasicElementLabels.getJavaElementName(simpleName));
            } else {
                Object[] arg = new String[]{BasicElementLabels.getJavaElementName(simpleName), BasicElementLabels.getJavaElementName(packName)};
                label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changetype_description, arg);
            }
            ASTRewrite rewrite = ASTRewrite.create((AST)node.getAST());
            rewrite.replace((ASTNode)node, rewrite.createStringPlaceholder(simpleName, 43), null);
            proposal = new ASTRewriteCorrectionProposalCore(label, cu, rewrite, relevance);
            uid = 830;
        }
        if (importRewrite != null) {
            proposal.setImportRewrite(importRewrite);
        }
        return this.rewriteProposalToT(proposal, uid);
    }

    protected T createTypeRefChangeFullProposal(ICompilationUnit cu, ITypeBinding binding, ASTNode node, int relevance, ImportRewrite.TypeLocation typeLocation) {
        ASTRewrite rewrite = ASTRewrite.create((AST)node.getAST());
        String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_change_full_type_description, BindingLabelProviderCore.getBindingLabel((IBinding)binding, 0x200009L));
        ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, cu, rewrite, relevance);
        ImportRewrite imports = proposal.createImportRewrite((CompilationUnit)node.getRoot());
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(node, imports);
        Type type = imports.addImport(binding, node.getAST(), (ImportRewrite.ImportRewriteContext)context, typeLocation);
        rewrite.replace(node, (ASTNode)type, null);
        return this.rewriteProposalToT(proposal, 910);
    }

    protected boolean isLikelyTypeName(String name) {
        return name.length() > 0 && Character.isUpperCase(name.charAt(0));
    }

    protected boolean isLikelyPackageName(String name) {
        if (name.length() != 0) {
            int i = 0;
            do {
                if (!Character.isUpperCase(name.charAt(i))) continue;
                return false;
            } while ((i = name.indexOf(46, i) + 1) != 0 && i < name.length());
        }
        return true;
    }

    private boolean isLikelyTypeParameterName(String name) {
        return name.length() == 1 && Character.isUpperCase(name.charAt(0));
    }

    private boolean isLikelyMethodTypeParameterName(String name) {
        if (name.length() == 1) {
            switch (name.charAt(0)) {
                case 'S': 
                case 'T': 
                case 'U': {
                    return true;
                }
            }
        }
        return false;
    }

    public void collectNewTypeProposals(ICompilationUnit cu, Name refNode, int kind, int relevance, Collection<T> proposals) throws CoreException {
        this.addNewTypeProposalsInteractive(cu, refNode, kind, relevance, proposals);
        this.addNewTypeProposalsParams(cu, refNode, kind, relevance, proposals);
    }

    protected void addNewTypeProposalsInteractive(ICompilationUnit cu, Name refNode, int kind, int relevance, Collection<T> proposals) throws CoreException {
        Name qualifier;
        Name node = refNode;
        do {
            boolean isPossibleName;
            String typeName = ASTNodes.getSimpleNameIdentifier(node);
            qualifier = null;
            boolean bl = isPossibleName = this.isLikelyTypeName(typeName) || node == refNode;
            if (!isPossibleName) continue;
            IPackageFragment enclosingPackage = null;
            IType enclosingType = null;
            if (node.isSimpleName()) {
                enclosingPackage = (IPackageFragment)cu.getParent();
            } else {
                Name qualifierName = ((QualifiedName)node).getQualifier();
                IBinding binding = qualifierName.resolveBinding();
                if (binding != null && binding.isRecovered()) {
                    binding = null;
                }
                if (binding instanceof ITypeBinding) {
                    enclosingType = (IType)binding.getJavaElement();
                } else if (binding instanceof IPackageBinding) {
                    qualifier = qualifierName;
                    enclosingPackage = (IPackageFragment)binding.getJavaElement();
                } else {
                    IJavaElement iJavaElement;
                    IJavaElement[] res = cu.codeSelect(qualifierName.getStartPosition(), qualifierName.getLength());
                    if (res != null && res.length > 0 && (iJavaElement = res[0]) instanceof IType) {
                        IType res0;
                        enclosingType = res0 = (IType)iJavaElement;
                    } else {
                        qualifier = qualifierName;
                        enclosingPackage = JavaModelUtil.getPackageFragmentRoot((IJavaElement)cu).getPackageFragment(ASTResolving.getFullName(qualifierName));
                    }
                }
            }
            int rel = relevance;
            if (enclosingPackage != null && this.isLikelyPackageName(enclosingPackage.getElementName())) {
                rel += 3;
            }
            if ((enclosingPackage == null || enclosingPackage.getCompilationUnit(typeName + ".java").exists()) && (enclosingType == null || enclosingType.isReadOnly() || enclosingType.getType(typeName).exists())) continue;
            IPackageFragment enclosing = enclosingPackage != null ? enclosingPackage : enclosingType;
            this.addNewTypeProposalsInteractiveInnerLoop(cu, node, (IJavaElement)enclosing, rel, kind, refNode, proposals);
        } while ((node = qualifier) != null);
    }

    protected abstract void addNewTypeProposalsInteractiveInnerLoop(ICompilationUnit var1, Name var2, IJavaElement var3, int var4, int var5, Name var6, Collection<T> var7) throws CoreException;

    protected void addNewTypeProposalsParams(ICompilationUnit cu, Name refNode, int kind, int relevance, Collection<T> proposals) {
        if (refNode.isSimpleName() && (kind & 0x20) != 0) {
            CompilationUnit root = (CompilationUnit)refNode.getRoot();
            String name = ((SimpleName)refNode).getIdentifier();
            Object declaration = ASTResolving.findParentBodyDeclaration((ASTNode)refNode);
            int baseRel = relevance;
            if (this.isLikelyTypeParameterName(name)) {
                baseRel += 8;
            }
            while (declaration != null) {
                AddTypeParameterProposalCore proposal;
                T t;
                IMethodBinding binding = null;
                int rel = baseRel;
                if (declaration instanceof MethodDeclaration) {
                    MethodDeclaration methodDecl = (MethodDeclaration)declaration;
                    binding = methodDecl.resolveBinding();
                    if (this.isLikelyMethodTypeParameterName(name)) {
                        rel += 2;
                    }
                } else if (declaration instanceof TypeDeclaration) {
                    TypeDeclaration typeDecl = (TypeDeclaration)declaration;
                    binding = typeDecl.resolveBinding();
                    ++rel;
                }
                if (binding != null && (t = this.addTypeParametersToT(proposal = new AddTypeParameterProposalCore(cu, (IBinding)binding, root, name, null, rel), 1080)) != null) {
                    proposals.add(t);
                }
                declaration = !Modifier.isStatic((int)declaration.getModifiers()) ? ASTResolving.findParentBodyDeclaration(declaration.getParent()) : null;
            }
        }
    }

    protected boolean canUseRecord(IJavaProject project, Name refNode) {
        boolean canUseRecord = false;
        if (project != null && JavaModelUtil.is16OrHigher(project) && refNode != null) {
            canUseRecord = true;
            Type type = ASTNodes.getParent((ASTNode)refNode, Type.class);
            TypeDeclaration typeDecl = ASTNodes.getParent((ASTNode)refNode, TypeDeclaration.class);
            if (type != null && typeDecl != null) {
                StructuralPropertyDescriptor locationInParent = type.getLocationInParent();
                if (locationInParent == TypeDeclaration.SUPERCLASS_TYPE_PROPERTY) {
                    canUseRecord = false;
                } else if (locationInParent == TypeDeclaration.PERMITS_TYPES_PROPERTY && !typeDecl.isInterface()) {
                    canUseRecord = false;
                }
            }
        }
        return canUseRecord;
    }

    public void collectRequiresModuleProposals(ICompilationUnit cu, Name node, int relevance, Collection<T> proposals, boolean isOnDemand) throws CoreException {
        if (cu == null) {
            return;
        }
        IJavaProject currentJavaProject = cu.getJavaProject();
        if (currentJavaProject == null || !JavaModelUtil.is9OrHigher(currentJavaProject)) {
            return;
        }
        IModuleDescription currentModuleDescription = currentJavaProject.getModuleDescription();
        if (currentModuleDescription == null) {
            return;
        }
        ICompilationUnit currentModuleCompilationUnit = currentModuleDescription.getCompilationUnit();
        if (currentModuleCompilationUnit == null || !currentModuleCompilationUnit.exists()) {
            return;
        }
        int typeRule = 0;
        if (isOnDemand) {
            typeRule = 2;
        }
        ArrayList<IPackageFragment> matchingPackageFragments = new ArrayList<IPackageFragment>();
        if (node.isSimpleName() && !isOnDemand) {
            matchingPackageFragments.add((IPackageFragment)cu.getParent());
        } else {
            String qualifiedName = node.getFullyQualifiedName();
            List<IPackageFragment> packageFragments = AddModuleRequiresCorrectionProposalCore.getPackageFragmentsOfMatchingTypesImpl(qualifiedName, typeRule, (IJavaElement)currentJavaProject);
            if (packageFragments.size() > 0) {
                matchingPackageFragments.addAll(packageFragments);
            } else if (isOnDemand && (packageFragments = AddModuleRequiresCorrectionProposalCore.getPackageFragmentsOfMatchingTypesImpl(qualifiedName, 0, (IJavaElement)currentJavaProject)).size() > 0) {
                matchingPackageFragments.addAll(packageFragments);
            }
        }
        IModuleDescription projectModule = null;
        if (matchingPackageFragments.size() > 0) {
            HashSet<String> modules = new HashSet<String>();
            for (IPackageFragment enclosingPackage : matchingPackageFragments) {
                String changeDescription;
                Object[] args;
                String changeName;
                AddModuleRequiresCorrectionProposalCore proposal;
                Change change;
                String moduleName;
                if (enclosingPackage.isReadOnly()) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)enclosingPackage.getAncestor(3);
                    projectModule = AddModuleRequiresCorrectionProposalCore.getModuleDescription((IJavaElement)root);
                } else {
                    IJavaProject project = enclosingPackage.getJavaProject();
                    projectModule = AddModuleRequiresCorrectionProposalCore.getModuleDescription((IJavaElement)project);
                }
                if (projectModule == null || (!projectModule.exists() || projectModule.equals(currentModuleDescription)) && !projectModule.isAutoModule() || modules.contains(moduleName = projectModule.getElementName()) || (change = (proposal = new AddModuleRequiresCorrectionProposalCore(moduleName, changeName = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_add_requires_module_info, args = new String[]{moduleName}), changeDescription = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_add_requires_module_description, args), currentModuleCompilationUnit, relevance)).getChange()) == null) continue;
                T t = this.addModuleRequiresProposalToT(proposal, 1180);
                if (t != null) {
                    proposals.add(t);
                }
                modules.add(moduleName);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void collectMethodProposals(IInvocationContext context, IProblemLocation problem, boolean isOnlyParameterMismatch, Collection<T> proposals) throws CoreException {
        IBinding[] binding;
        boolean isSuperInvocation;
        Expression sender;
        List arguments;
        void nameNode;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        SimpleName simpleName = (SimpleName)selectedNode;
        ASTNode invocationNode = nameNode.getParent();
        if (invocationNode instanceof MethodInvocation) {
            MethodInvocation methodImpl = (MethodInvocation)invocationNode;
            arguments = methodImpl.arguments();
            sender = methodImpl.getExpression();
            isSuperInvocation = false;
        } else if (invocationNode instanceof SuperMethodInvocation) {
            SuperMethodInvocation methodImpl = (SuperMethodInvocation)invocationNode;
            arguments = methodImpl.arguments();
            sender = methodImpl.getQualifier();
            isSuperInvocation = true;
        } else {
            return;
        }
        String methodName = nameNode.getIdentifier();
        int nArguments = arguments.size();
        IBinding[] bindings = new ScopeAnalyzer(astRoot).getDeclarationsInScope((SimpleName)nameNode, 1);
        HashSet<String> suggestedRenames = new HashSet<String>();
        IBinding[] iBindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            String label;
            RenameNodeCorrectionProposalCore core;
            T t;
            IBinding b = iBindingArray[n2];
            binding = (IBinding[])b;
            String curr = binding.getName();
            if (!curr.equals(methodName) && binding.getParameterTypes().length == nArguments && NameMatcher.isSimilarName(methodName, curr) && suggestedRenames.add(curr) && (t = this.renameNodeProposalToT(core = new RenameNodeCorrectionProposalCore(label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changemethod_description, BasicElementLabels.getJavaElementName(curr)), context.getCompilationUnit(), problem.getOffset(), problem.getLength(), curr, 6), 1210)) != null) {
                proposals.add(t);
            }
            ++n2;
        }
        suggestedRenames = null;
        if (isOnlyParameterMismatch) {
            ArrayList<IMethodBinding> parameterMismatchs = new ArrayList<IMethodBinding>();
            binding = bindings;
            int n3 = bindings.length;
            n = 0;
            while (n < n3) {
                IBinding binding2 = binding[n];
                if (binding2.getName().equals(methodName)) {
                    parameterMismatchs.add((IMethodBinding)binding2);
                }
                ++n;
            }
            this.addParameterMissmatchProposals(context, problem, parameterMismatchs, invocationNode, arguments, proposals);
        }
        if (sender == null) {
            this.addStaticImportFavoriteProposals(context, (SimpleName)nameNode, true, proposals);
        }
        this.addNewMethodProposals(cu, astRoot, sender, arguments, isSuperInvocation, invocationNode, methodName, proposals);
        if (!isOnlyParameterMismatch && !isSuperInvocation && sender != null) {
            this.addMissingCastParentsProposal(cu, (MethodInvocation)invocationNode, proposals);
        }
        if (!isSuperInvocation && sender == null && invocationNode.getParent() instanceof ThrowStatement) {
            String str = "new ";
            String label = CorrectionMessages.UnresolvedElementsSubProcessor_addnewkeyword_description;
            int relevance = Character.isUpperCase(methodName.charAt(0)) ? 7 : 4;
            ReplaceCorrectionProposalCore proposal = new ReplaceCorrectionProposalCore(label, cu, invocationNode.getStartPosition(), 0, str, relevance);
            T t = this.replaceCorrectionProposalToT(proposal, 1280);
            if (t != null) {
                proposals.add(t);
            }
        }
    }

    private void addStaticImportFavoriteProposals(IInvocationContext context, SimpleName node, boolean isMethod, Collection<T> proposals) throws JavaModelException {
        IJavaProject project = context.getCompilationUnit().getJavaProject();
        if (JavaModelUtil.is50OrHigher(project)) {
            String pref = JavaManipulation.getPreference("content_assist_favorite_static_members", project);
            if (pref == null || pref.isBlank()) {
                return;
            }
            String[] favourites = pref.split(";");
            if (favourites.length == 0) {
                return;
            }
            CompilationUnit root = context.getASTRoot();
            AST ast = root.getAST();
            String name = node.getIdentifier();
            String[] stringArray = JavaModelUtil.getStaticImportFavorites(context.getCompilationUnit(), name, isMethod, favourites);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String label;
                String curr = stringArray[n2];
                ImportRewrite importRewrite = StubUtility.createImportRewrite(root, true);
                ASTRewrite astRewrite = ASTRewrite.create((AST)ast);
                String qualifiedTypeName = Signature.getQualifier((String)Signature.getTypeErasure((String)curr));
                String elementLabel = BasicElementLabels.getJavaElementName(JavaModelUtil.concatenateName(Signature.getSimpleName((String)qualifiedTypeName), name));
                String res = importRewrite.addStaticImport(qualifiedTypeName, name, isMethod, (ImportRewrite.ImportRewriteContext)new ContextSensitiveImportRewriteContext(root, node.getStartPosition(), importRewrite));
                int dot = res.lastIndexOf(46);
                if (dot != -1) {
                    String usedTypeName = importRewrite.addImport(qualifiedTypeName);
                    QualifiedName newName = ast.newQualifiedName(ast.newName(usedTypeName), ast.newSimpleName(name));
                    astRewrite.replace((ASTNode)node, (ASTNode)newName, null);
                    label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_change_to_static_import_description, elementLabel);
                } else {
                    label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_add_static_import_description, elementLabel);
                }
                ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, context.getCompilationUnit(), astRewrite, 5);
                proposal.setImportRewrite(importRewrite);
                T t = this.rewriteProposalToT(proposal, 1310);
                if (t != null) {
                    proposals.add(t);
                }
                ++n2;
            }
        }
    }

    private void addNewMethodProposals(ICompilationUnit cu, CompilationUnit astRoot, Expression sender, List<Expression> arguments, boolean isSuperInvocation, ASTNode invocationNode, String methodName, Collection<T> proposals) throws JavaModelException {
        ITypeBinding[] parameterTypes;
        ITypeBinding senderDeclBinding;
        ICompilationUnit targetCU;
        ITypeBinding nodeParentType = Bindings.getBindingOfParentType(invocationNode);
        ITypeBinding binding = null;
        if (sender != null) {
            binding = sender.resolveTypeBinding();
        } else {
            binding = nodeParentType;
            if (isSuperInvocation && binding != null) {
                binding = binding.getSuperclass();
            }
        }
        if (binding != null && binding.isFromSource() && (targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, senderDeclBinding = binding.getErasure().getTypeDeclaration())) != null && (parameterTypes = this.getParameterTypes(arguments)) != null) {
            ASTNode anonymDecl;
            NewMethodCorrectionProposalCore core;
            T t;
            boolean type1;
            String labelAbstract;
            String label;
            String sig = ASTResolving.getMethodSignature(methodName, parameterTypes, false);
            boolean is18OrHigher = JavaModelUtil.is1d8OrHigher(targetCU.getJavaProject());
            boolean isSenderTypeAbstractClass = (senderDeclBinding.getModifiers() & 0x400) > 0;
            boolean isSenderBindingInterface = senderDeclBinding.isInterface();
            int firstProposalUid = -1;
            if (nodeParentType == senderDeclBinding) {
                label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createmethod_description, sig);
                labelAbstract = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createmethod_abstract_description, sig);
                firstProposalUid = isSenderBindingInterface ? 1410 : 1420;
            } else {
                firstProposalUid = 1430;
                label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createmethod_other_description, new Object[]{sig, BasicElementLabels.getJavaElementName(senderDeclBinding.getName())});
                labelAbstract = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createmethod_abstract_other_description, new Object[]{sig, BasicElementLabels.getJavaElementName(senderDeclBinding.getName())});
            }
            boolean bl = type1 = is18OrHigher || !isSenderBindingInterface || nodeParentType != senderDeclBinding && (!(sender instanceof SimpleName) || !((SimpleName)sender).getIdentifier().equals(senderDeclBinding.getName()));
            if (type1 && (t = this.newMethodProposalToT(core = new NewMethodCorrectionProposalCore(label, targetCU, invocationNode, arguments, senderDeclBinding, 5), firstProposalUid)) != null) {
                proposals.add(t);
            }
            if (type1 && isSenderTypeAbstractClass && (t = this.newMethodProposalToT(core = new NewAbstractMethodCorrectionProposalCore(labelAbstract, targetCU, invocationNode, arguments, senderDeclBinding, 5), 1450)) != null) {
                proposals.add(t);
            }
            if (senderDeclBinding.isNested() && cu.equals(targetCU) && sender == null && Bindings.findMethodInHierarchy(senderDeclBinding, methodName, null) == null && (anonymDecl = astRoot.findDeclaringNode((IBinding)senderDeclBinding)) != null) {
                senderDeclBinding = Bindings.getBindingOfParentType(anonymDecl.getParent());
                isSenderBindingInterface = senderDeclBinding.isInterface();
                boolean bl2 = isSenderTypeAbstractClass = (senderDeclBinding.getModifiers() & 0x400) > 0;
                if (!(senderDeclBinding.isAnonymous() || !is18OrHigher && isSenderBindingInterface)) {
                    NewAbstractMethodCorrectionProposalCore c2;
                    T t2;
                    Object[] args = new String[]{sig, ASTResolving.getTypeSignature(senderDeclBinding)};
                    label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createmethod_other_description, args);
                    labelAbstract = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createmethod_abstract_other_description, args);
                    NewMethodCorrectionProposalCore core2 = new NewMethodCorrectionProposalCore(label, targetCU, invocationNode, arguments, senderDeclBinding, 5);
                    int nextUid = isSenderBindingInterface ? 1475 : 1480;
                    T t3 = this.newMethodProposalToT(core2, nextUid);
                    if (t3 != null) {
                        proposals.add(t3);
                    }
                    if (isSenderTypeAbstractClass && (t2 = this.newMethodProposalToT(c2 = new NewAbstractMethodCorrectionProposalCore(labelAbstract, targetCU, invocationNode, arguments, senderDeclBinding, 5), 1490)) != null) {
                        proposals.add(t2);
                    }
                }
            }
        }
    }

    private void addMissingCastParentsProposal(ICompilationUnit cu, MethodInvocation invocationNode, Collection<T> proposals) {
        Expression sender = invocationNode.getExpression();
        if (sender instanceof ThisExpression) {
            return;
        }
        ITypeBinding senderBinding = sender.resolveTypeBinding();
        if (senderBinding == null || Modifier.isFinal((int)senderBinding.getModifiers())) {
            return;
        }
        if (sender instanceof Name && ((Name)sender).resolveBinding() instanceof ITypeBinding) {
            return;
        }
        ASTNode parent = invocationNode.getParent();
        while (parent instanceof Expression && parent.getNodeType() != 11) {
            parent = parent.getParent();
        }
        boolean hasCastProposal = false;
        if (parent instanceof CastExpression) {
            hasCastProposal = this.useExistingParentCastProposal(cu, (CastExpression)parent, sender, invocationNode.getName(), this.getArgumentTypes(invocationNode.arguments()), proposals);
        }
        if (!hasCastProposal) {
            String label;
            Expression target = ASTNodes.getUnparenthesedExpression(sender);
            if (target.getNodeType() != 11) {
                targetName = null;
                if (target.getLength() <= 18) {
                    targetName = ASTNodes.asString((ASTNode)target);
                }
                label = targetName == null ? CorrectionMessages.UnresolvedElementsSubProcessor_methodtargetcast_description : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_methodtargetcast2_description, BasicElementLabels.getJavaCodeString(targetName));
            } else {
                targetName = null;
                if (target.getLength() <= 18) {
                    targetName = ASTNodes.asString((ASTNode)((CastExpression)target).getExpression());
                }
                label = targetName == null ? CorrectionMessages.UnresolvedElementsSubProcessor_changemethodtargetcast_description : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changemethodtargetcast2_description, BasicElementLabels.getJavaCodeString(targetName));
            }
            CastCorrectionProposalCore c = new CastCorrectionProposalCore(label, cu, target, null, 3);
            T t = this.castCorrectionProposalToT(c, 1550);
            if (t != null) {
                proposals.add(t);
            }
        }
    }

    private boolean useExistingParentCastProposal(ICompilationUnit cu, CastExpression expression, Expression accessExpression, SimpleName accessSelector, ITypeBinding[] paramTypes, Collection<T> proposals) {
        ITypeBinding castType = expression.getType().resolveBinding();
        if (castType == null) {
            return false;
        }
        if (paramTypes != null ? Bindings.findMethodInHierarchy(castType, accessSelector.getIdentifier(), paramTypes) == null : Bindings.findFieldInHierarchy(castType, accessSelector.getIdentifier()) == null) {
            return false;
        }
        ITypeBinding bindingToCast = accessExpression.resolveTypeBinding();
        if (bindingToCast != null && !bindingToCast.isCastCompatible(castType)) {
            return false;
        }
        IMethodBinding res = Bindings.findMethodInHierarchy(castType, accessSelector.getIdentifier(), paramTypes);
        if (res != null) {
            AST ast = expression.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            CastExpression newCast = ast.newCastExpression();
            newCast.setType((Type)ASTNode.copySubtree((AST)ast, (ASTNode)expression.getType()));
            newCast.setExpression((Expression)rewrite.createCopyTarget((ASTNode)accessExpression));
            ParenthesizedExpression parents = ast.newParenthesizedExpression();
            parents.setExpression((Expression)newCast);
            ASTNode node = rewrite.createCopyTarget((ASTNode)expression.getExpression());
            rewrite.replace((ASTNode)expression, node, null);
            rewrite.replace((ASTNode)accessExpression, (ASTNode)parents, null);
            String label = CorrectionMessages.UnresolvedElementsSubProcessor_missingcastbrackets_description;
            ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, cu, rewrite, 8);
            T t = this.rewriteProposalToT(proposal, 1650);
            if (t != null) {
                proposals.add(t);
            }
            return true;
        }
        return false;
    }

    private void addParameterMissmatchProposals(IInvocationContext context, IProblemLocation problem, List<IMethodBinding> similarElements, ASTNode invocationNode, List<Expression> arguments, Collection<T> proposals) throws CoreException {
        int nSimilarElements = similarElements.size();
        ITypeBinding[] argTypes = this.getArgumentTypes(arguments);
        if (argTypes == null || nSimilarElements == 0) {
            return;
        }
        int i = 0;
        while (i < nSimilarElements) {
            IMethodBinding elem = similarElements.get(i);
            int diff = elem.getParameterTypes().length - argTypes.length;
            if (diff == 0) {
                int nProposals = proposals.size();
                this.doEqualNumberOfParameters(context, invocationNode, problem, arguments, argTypes, elem, proposals);
                if (nProposals != proposals.size()) {
                    return;
                }
            } else if (diff > 0) {
                this.doMoreParameters(context, invocationNode, argTypes, elem, proposals);
            } else {
                this.doMoreArguments(context, invocationNode, arguments, argTypes, elem, proposals);
            }
            ++i;
        }
    }

    private void doMoreParameters(IInvocationContext context, ASTNode invocationNode, ITypeBinding[] argTypes, IMethodBinding methodBinding, Collection<T> proposals) throws CoreException {
        ITypeBinding[] paramTypes = methodBinding.getParameterTypes();
        int k = 0;
        int nSkipped = 0;
        int diff = paramTypes.length - argTypes.length;
        int[] indexSkipped = new int[diff];
        int i = 0;
        while (i < paramTypes.length) {
            if (k < argTypes.length && this.canAssign(argTypes[k], paramTypes[i])) {
                ++k;
            } else {
                if (nSkipped >= diff) {
                    return;
                }
                indexSkipped[nSkipped++] = i;
            }
            ++i;
        }
        ITypeBinding declaringType = methodBinding.getDeclaringClass();
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        Object[] arg = new String[]{ASTResolving.getMethodSignature(methodBinding)};
        String label = diff == 1 ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_addargument_description, arg) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_addarguments_description, arg);
        AddArgumentCorrectionProposalCore proposal = new AddArgumentCorrectionProposalCore(label, context.getCompilationUnit(), invocationNode, indexSkipped, paramTypes, 8);
        T proposalAsT = this.addArgumentCorrectionProposalToT(proposal, 1700);
        if (proposalAsT != null) {
            proposals.add(proposalAsT);
        }
        if (!declaringType.isFromSource() || methodBinding.isConstructor() && declaringType.isRecord()) {
            return;
        }
        ICompilationUnit targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, declaringType);
        if (targetCU != null) {
            IMethodBinding methodDecl = methodBinding.getMethodDeclaration();
            ITypeBinding[] declParameterTypes = methodDecl.getParameterTypes();
            ChangeMethodSignatureProposalCore.ChangeDescription[] changeDesc = new ChangeMethodSignatureProposalCore.ChangeDescription[declParameterTypes.length];
            ITypeBinding[] changedTypes = new ITypeBinding[diff];
            int i2 = diff - 1;
            while (i2 >= 0) {
                int idx = indexSkipped[i2];
                changeDesc[idx] = new ChangeMethodSignatureProposalCore.RemoveDescription();
                changedTypes[i2] = declParameterTypes[idx];
                --i2;
            }
            Object[] arg2 = new String[]{ASTResolving.getMethodSignature(methodDecl), this.getTypeNames(changedTypes)};
            String label2 = methodDecl.isConstructor() ? (diff == 1 ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_removeparam_constr_description, arg2) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_removeparams_constr_description, arg2)) : (diff == 1 ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_removeparam_description, arg2) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_removeparams_description, arg2));
            ChangeMethodSignatureProposalCore proposal2 = new ChangeMethodSignatureProposalCore(label2, targetCU, invocationNode, methodDecl, changeDesc, null, 5);
            T t = this.changeMethodSignatureProposalToT(proposal2, 1750);
            if (t != null) {
                proposals.add(t);
            }
        }
    }

    private String getTypeNames(ITypeBinding[] types) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(ASTResolving.getTypeSignature(types[i]));
            ++i;
        }
        return BasicElementLabels.getJavaElementName(buf.toString());
    }

    private String getArgumentName(List<Expression> arguments, int index) {
        String def = String.valueOf(index + 1);
        ASTNode expr = (ASTNode)arguments.get(index);
        if (expr.getLength() > 18) {
            return def;
        }
        ASTMatcher matcher = new ASTMatcher();
        int i = 0;
        while (i < arguments.size()) {
            if (i != index && matcher.safeSubtreeMatch((Object)expr, (Object)arguments.get(i))) {
                return def;
            }
            ++i;
        }
        return "'" + BasicElementLabels.getJavaElementName(ASTNodes.asString(expr)) + "'";
    }

    private void doMoreArguments(IInvocationContext context, ASTNode invocationNode, List<Expression> arguments, ITypeBinding[] argTypes, IMethodBinding methodRef, Collection<T> proposals) throws CoreException {
        IMethodBinding methodDecl;
        ITypeBinding declaringType;
        ITypeBinding[] paramTypes = methodRef.getParameterTypes();
        int k = 0;
        int nSkipped = 0;
        int diff = argTypes.length - paramTypes.length;
        int[] indexSkipped = new int[diff];
        int i = 0;
        while (i < argTypes.length) {
            if (k < paramTypes.length && this.canAssign(argTypes[i], paramTypes[k])) {
                ++k;
            } else {
                if (nSkipped >= diff) {
                    return;
                }
                indexSkipped[nSkipped++] = i;
            }
            ++i;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        int i2 = diff - 1;
        while (i2 >= 0) {
            rewrite.remove((ASTNode)arguments.get(indexSkipped[i2]), null);
            --i2;
        }
        Object[] arg = new String[]{ASTResolving.getMethodSignature(methodRef)};
        String label = diff == 1 ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_removeargument_description, arg) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_removearguments_description, arg);
        ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, cu, rewrite, 8);
        T proposalAsT = this.rewriteProposalToT(proposal, 1810);
        if (proposalAsT != null) {
            proposals.add(proposalAsT);
        }
        if (!(declaringType = (methodDecl = methodRef.getMethodDeclaration()).getDeclaringClass()).isFromSource() || methodDecl.isConstructor() && declaringType.isRecord()) {
            return;
        }
        ICompilationUnit targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, declaringType);
        if (targetCU != null) {
            if (this.isImplicitConstructor(methodDecl)) {
                return;
            }
            ChangeMethodSignatureProposalCore.ChangeDescription[] changeDesc = new ChangeMethodSignatureProposalCore.ChangeDescription[argTypes.length];
            ITypeBinding[] changeTypes = new ITypeBinding[diff];
            int i3 = diff - 1;
            while (i3 >= 0) {
                int idx = indexSkipped[i3];
                Expression arg2 = arguments.get(idx);
                String name = this.getExpressionBaseName(arg2);
                ITypeBinding newType = Bindings.normalizeTypeBinding(argTypes[idx]);
                if (newType == null) {
                    newType = astRoot.getAST().resolveWellKnownType("java.lang.Object");
                }
                if (newType.isWildcardType()) {
                    newType = ASTResolving.normalizeWildcardType(newType, true, astRoot.getAST());
                }
                if (!ASTResolving.isUseableTypeInContext(newType, (IBinding)methodDecl, false)) {
                    return;
                }
                changeDesc[idx] = new ChangeMethodSignatureProposalCore.InsertDescription(newType, name);
                changeTypes[i3] = newType;
                --i3;
            }
            Object[] arg3 = new String[]{ASTResolving.getMethodSignature(methodDecl), this.getTypeNames(changeTypes)};
            String label2 = methodDecl.isConstructor() ? (diff == 1 ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_addparam_constr_description, arg3) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_addparams_constr_description, arg3)) : (diff == 1 ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_addparam_description, arg3) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_addparams_description, arg3));
            ChangeMethodSignatureProposalCore proposal2 = new ChangeMethodSignatureProposalCore(label2, targetCU, invocationNode, methodDecl, changeDesc, null, 5);
            T proposalAsT2 = this.changeMethodSignatureProposalToT(proposal2, 1850);
            if (proposalAsT2 != null) {
                proposals.add(proposalAsT2);
            }
        }
    }

    private boolean isImplicitConstructor(IMethodBinding meth) {
        return meth.isDefaultConstructor();
    }

    private ITypeBinding[] getParameterTypes(List<Expression> args) {
        ITypeBinding[] params = new ITypeBinding[args.size()];
        int i = 0;
        while (i < args.size()) {
            Expression expr = args.get(i);
            ITypeBinding curr = Bindings.normalizeTypeBinding(expr.resolveTypeBinding());
            if (curr != null && curr.isWildcardType()) {
                curr = ASTResolving.normalizeWildcardType(curr, true, expr.getAST());
            }
            if (curr == null) {
                curr = expr.getAST().resolveWellKnownType("java.lang.Object");
            }
            params[i] = curr;
            ++i;
        }
        return params;
    }

    private void doEqualNumberOfParameters(IInvocationContext context, ASTNode invocationNode, IProblemLocation problem, List<Expression> arguments, ITypeBinding[] argTypes, IMethodBinding methodBinding, Collection<T> proposals) throws CoreException {
        ChangeMethodSignatureProposalCore.ChangeDescription[] changeDesc;
        ICompilationUnit targetCU;
        T proposalToT;
        ASTRewriteCorrectionProposalCore proposal;
        String label;
        ITypeBinding[] paramTypes = methodBinding.getParameterTypes();
        int[] indexOfDiff = new int[paramTypes.length];
        int nDiffs = 0;
        int n = 0;
        while (n < argTypes.length) {
            if (!this.canAssign(argTypes[n], paramTypes[n])) {
                indexOfDiff[nDiffs++] = n;
            }
            ++n;
        }
        ITypeBinding declaringTypeDecl = methodBinding.getDeclaringClass().getTypeDeclaration();
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode nameNode = problem.getCoveringNode(astRoot);
        if (nameNode == null || methodBinding.isConstructor() && declaringTypeDecl.isRecord()) {
            return;
        }
        if (nDiffs == 0) {
            MethodInvocation inv;
            ASTNode aSTNode = nameNode.getParent();
            if (aSTNode instanceof MethodInvocation && (inv = (MethodInvocation)aSTNode).getExpression() == null) {
                this.addQualifierToOuterProposal(context, inv, methodBinding, proposals);
            }
            return;
        }
        if (nDiffs == 1) {
            int idx = indexOfDiff[0];
            Expression nodeToCast = arguments.get(idx);
            ITypeBinding castType = paramTypes[idx];
            if ((castType = Bindings.normalizeTypeBinding(castType)).isWildcardType()) {
                castType = ASTResolving.normalizeWildcardType(castType, false, nodeToCast.getAST());
            }
            if (castType != null) {
                ITypeBinding boxUnboxedTypeBinding;
                ITypeBinding binding = nodeToCast.resolveTypeBinding();
                ITypeBinding castFixType = null;
                if (binding == null || castType.isCastCompatible(binding)) {
                    castFixType = castType;
                } else if (JavaModelUtil.is50OrHigher(cu.getJavaProject()) && (boxUnboxedTypeBinding = TypeMismatchBaseSubProcessor.boxOrUnboxPrimitives(castType, binding, nodeToCast.getAST())) != castType && boxUnboxedTypeBinding.isCastCompatible(binding)) {
                    castFixType = boxUnboxedTypeBinding;
                }
                TypeMismatchBaseSubProcessor<T> sub = this.getTypeMismatchSubProcessor();
                if (castFixType != null) {
                    String castTypeName = BindingLabelProviderCore.getBindingLabel((IBinding)castFixType, 0x200009L);
                    Object[] arg = new String[]{this.getArgumentName(arguments, idx), castTypeName};
                    String label2 = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_addargumentcast_description, arg);
                    T proposal2 = sub.collectCastProposals(label2, context, castFixType, nodeToCast, 6);
                    if (proposal2 != null) {
                        proposals.add(proposal2);
                    }
                }
                sub.collectChangeSenderTypeProposals(context, nodeToCast, castType, false, 5, proposals);
            }
        }
        if (nDiffs == 2) {
            boolean canSwap;
            int idx1 = indexOfDiff[0];
            int idx2 = indexOfDiff[1];
            boolean bl = canSwap = this.canAssign(argTypes[idx1], paramTypes[idx2]) && this.canAssign(argTypes[idx2], paramTypes[idx1]);
            if (canSwap) {
                ICompilationUnit targetCU2;
                Expression arg1 = arguments.get(idx1);
                Expression arg2 = arguments.get(idx2);
                ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
                rewrite.replace((ASTNode)arg1, rewrite.createCopyTarget((ASTNode)arg2), null);
                rewrite.replace((ASTNode)arg2, rewrite.createCopyTarget((ASTNode)arg1), null);
                Object[] arg = new String[]{this.getArgumentName(arguments, idx1), this.getArgumentName(arguments, idx2)};
                label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_swaparguments_description, arg);
                proposal = new ASTRewriteCorrectionProposalCore(label, context.getCompilationUnit(), rewrite, 8);
                proposalToT = this.rewriteProposalToT(proposal, 1950);
                if (proposalToT != null) {
                    proposals.add(proposalToT);
                }
                if (declaringTypeDecl.isFromSource() && (targetCU2 = ASTResolving.findCompilationUnitForBinding(cu, astRoot, declaringTypeDecl)) != null) {
                    ChangeMethodSignatureProposalCore.ChangeDescription[] changeDesc2 = new ChangeMethodSignatureProposalCore.ChangeDescription[paramTypes.length];
                    int i = 0;
                    while (i < nDiffs) {
                        changeDesc2[idx1] = new ChangeMethodSignatureProposalCore.SwapDescription(idx2);
                        ++i;
                    }
                    IMethodBinding methodDecl = methodBinding.getMethodDeclaration();
                    ITypeBinding[] declParamTypes = methodDecl.getParameterTypes();
                    ITypeBinding[] swappedTypes = new ITypeBinding[]{declParamTypes[idx1], declParamTypes[idx2]};
                    Object[] args = new String[]{ASTResolving.getMethodSignature(methodDecl), this.getTypeNames(swappedTypes)};
                    String label3 = methodDecl.isConstructor() ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_swapparams_constr_description, args) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_swapparams_description, args);
                    ChangeMethodSignatureProposalCore proposal3 = new ChangeMethodSignatureProposalCore(label3, targetCU2, invocationNode, methodDecl, changeDesc2, null, 5);
                    T proposalToT2 = this.changeMethodSignatureProposalToT(proposal3, 1970);
                    if (proposalToT2 != null) {
                        proposals.add(proposalToT2);
                    }
                }
                return;
            }
        }
        if (declaringTypeDecl.isFromSource() && (targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, declaringTypeDecl)) != null && (changeDesc = this.createSignatureChangeDescription(indexOfDiff, nDiffs, paramTypes, arguments, argTypes)) != null) {
            IMethodBinding methodDecl = methodBinding.getMethodDeclaration();
            ITypeBinding[] declParamTypes = methodDecl.getParameterTypes();
            ITypeBinding[] newParamTypes = new ITypeBinding[changeDesc.length];
            int i = 0;
            while (i < newParamTypes.length) {
                newParamTypes[i] = changeDesc[i] == null ? declParamTypes[i] : ((ChangeMethodSignatureProposalCore.EditDescription)changeDesc[i]).type;
                ++i;
            }
            if (methodDecl.isVarargs() && newParamTypes.length > 0 && !newParamTypes[newParamTypes.length - 1].isArray()) {
                ArrayList<ITypeBinding> newArgs = new ArrayList<ITypeBinding>();
                newArgs.addAll(Arrays.asList(argTypes));
                newArgs.add(paramTypes[paramTypes.length - 1]);
                this.doMoreArguments(context, invocationNode, arguments, newArgs.toArray(new ITypeBinding[0]), methodBinding, proposals);
                return;
            }
            boolean isVarArgs = methodDecl.isVarargs() && newParamTypes.length > 0 && newParamTypes[newParamTypes.length - 1].isArray();
            Object[] args = new String[]{ASTResolving.getMethodSignature(methodDecl), ASTResolving.getMethodSignature(methodDecl.getName(), newParamTypes, isVarArgs)};
            label = methodDecl.isConstructor() ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changeparamsignature_constr_description, args) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changeparamsignature_description, args);
            proposal = new ChangeMethodSignatureProposalCore(label, targetCU, invocationNode, methodDecl, changeDesc, null, 7);
            proposalToT = this.changeMethodSignatureProposalToT((ChangeMethodSignatureProposalCore)proposal, 1980);
            if (proposalToT != null) {
                proposals.add(proposalToT);
            }
        }
    }

    private ChangeMethodSignatureProposalCore.ChangeDescription[] createSignatureChangeDescription(int[] indexOfDiff, int nDiffs, ITypeBinding[] paramTypes, List<Expression> arguments, ITypeBinding[] argTypes) {
        ChangeMethodSignatureProposalCore.ChangeDescription[] changeDesc = new ChangeMethodSignatureProposalCore.ChangeDescription[paramTypes.length];
        int i = 0;
        while (i < nDiffs) {
            int diffIndex = indexOfDiff[i];
            Expression arg = arguments.get(diffIndex);
            String name = this.getExpressionBaseName(arg);
            ITypeBinding argType = argTypes[diffIndex];
            if (argType.isWildcardType() && (argType = ASTResolving.normalizeWildcardType(argType, true, arg.getAST())) == null) {
                return null;
            }
            changeDesc[diffIndex] = new ChangeMethodSignatureProposalCore.EditDescription(argType, name);
            ++i;
        }
        return changeDesc;
    }

    private String getExpressionBaseName(Expression expr) {
        IBinding argBinding = Bindings.resolveExpressionBinding(expr, true);
        if (argBinding instanceof IVariableBinding) {
            ITypeRoot typeRoot;
            IVariableBinding varBinding = (IVariableBinding)argBinding;
            IJavaProject project = null;
            ASTNode root = expr.getRoot();
            if (root instanceof CompilationUnit && (typeRoot = ((CompilationUnit)root).getTypeRoot()) != null) {
                project = typeRoot.getJavaProject();
            }
            return StubUtility.getBaseName(varBinding, project);
        }
        if (expr instanceof SimpleName) {
            SimpleName sn = (SimpleName)expr;
            return sn.getIdentifier();
        }
        return null;
    }

    private ITypeBinding[] getArgumentTypes(List<Expression> arguments) {
        ITypeBinding[] res = new ITypeBinding[arguments.size()];
        int i = 0;
        while (i < res.length) {
            Expression expression = arguments.get(i);
            ITypeBinding curr = expression.resolveTypeBinding();
            if (curr == null) {
                return null;
            }
            if (!curr.isNullType() && (curr = Bindings.normalizeTypeBinding(curr)) == null) {
                curr = expression.getAST().resolveWellKnownType("java.lang.Object");
            }
            res[i] = curr;
            ++i;
        }
        return res;
    }

    private void addQualifierToOuterProposal(IInvocationContext context, MethodInvocation invocationNode, IMethodBinding binding, Collection<T> proposals) {
        Name newExpression;
        ITypeBinding parentType;
        ITypeBinding declaringType = binding.getDeclaringClass();
        ITypeBinding currType = parentType = Bindings.getBindingOfParentType((ASTNode)invocationNode);
        boolean isInstanceMethod = !Modifier.isStatic((int)binding.getModifiers());
        while (currType != null && !Bindings.isSuperType(declaringType, currType)) {
            if (isInstanceMethod && Modifier.isStatic((int)currType.getModifiers())) {
                return;
            }
            currType = currType.getDeclaringClass();
        }
        if (currType == null || currType == parentType) {
            return;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)invocationNode.getAST());
        String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changetoouter_description, ASTResolving.getTypeSignature(currType));
        ASTRewriteCorrectionProposalCore coreProposal = new ASTRewriteCorrectionProposalCore(label, context.getCompilationUnit(), rewrite, 8);
        ImportRewrite imports = coreProposal.createImportRewrite(context.getASTRoot());
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)invocationNode, imports);
        AST ast = invocationNode.getAST();
        String qualifier = imports.addImport(currType, (ImportRewrite.ImportRewriteContext)importRewriteContext);
        Name name = ASTNodeFactory.newName(ast, qualifier);
        if (isInstanceMethod) {
            ThisExpression expr = ast.newThisExpression();
            expr.setQualifier(name);
            newExpression = expr;
        } else {
            newExpression = name;
        }
        rewrite.set((ASTNode)invocationNode, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)newExpression, null);
        T rewriteToT = this.rewriteProposalToT(coreProposal, 2000);
        if (rewriteToT != null) {
            proposals.add(rewriteToT);
        }
    }

    public void collectConstructorProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) throws CoreException {
        Object[] args;
        String label;
        NewMethodCorrectionProposalCore core;
        T coreToT;
        ITypeBinding targetDecl;
        ICompilationUnit targetCU;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        ITypeBinding targetBinding = null;
        List arguments = null;
        IMethodBinding recursiveConstructor = null;
        int type = selectedNode.getNodeType();
        switch (type) {
            case 14: {
                ClassInstanceCreation creation = (ClassInstanceCreation)selectedNode;
                ITypeBinding binding = creation.getType().resolveBinding();
                if (binding == null) break;
                targetBinding = binding;
                arguments = creation.arguments();
                break;
            }
            case 46: {
                ITypeBinding typeBinding = Bindings.getBindingOfParentType(selectedNode);
                if (typeBinding == null || typeBinding.isAnonymous()) break;
                targetBinding = typeBinding.getSuperclass();
                arguments = ((SuperConstructorInvocation)selectedNode).arguments();
                break;
            }
            case 17: {
                ITypeBinding typeBinding = Bindings.getBindingOfParentType(selectedNode);
                if (typeBinding == null || typeBinding.isAnonymous()) break;
                targetBinding = typeBinding;
                arguments = ((ConstructorInvocation)selectedNode).arguments();
                recursiveConstructor = ASTResolving.findParentMethodDeclaration(selectedNode).resolveBinding();
                break;
            }
        }
        ASTNode aSTNode = selectedNode.getParent();
        if (aSTNode instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumNode = (EnumConstantDeclaration)aSTNode;
            ITypeBinding typeBinding = Bindings.getBindingOfParentType(selectedNode);
            if (typeBinding != null && !typeBinding.isAnonymous()) {
                targetBinding = typeBinding;
                arguments = enumNode.arguments();
                selectedNode = enumNode;
            }
        }
        if (targetBinding == null) {
            return;
        }
        ArrayList<IMethodBinding> similarElements = new ArrayList<IMethodBinding>();
        IMethodBinding[] iMethodBindingArray = targetBinding.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding curr = iMethodBindingArray[n2];
            if (curr.isConstructor() && recursiveConstructor != curr) {
                similarElements.add(curr);
            }
            ++n2;
        }
        this.addParameterMissmatchProposals(context, problem, similarElements, selectedNode, arguments, proposals);
        if (targetBinding.isFromSource() && (targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, targetDecl = targetBinding.getTypeDeclaration())) != null && (coreToT = this.newMethodProposalToT(core = new NewMethodCorrectionProposalCore(label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createconstructor_description, args = new String[]{ASTResolving.getMethodSignature(ASTResolving.getTypeSignature(targetDecl), this.getParameterTypes(arguments), false)}), targetCU, selectedNode, arguments, targetDecl, 5), 2100)) != null) {
            proposals.add(coreToT);
        }
    }

    public void collectAmbiguosTypeReferenceProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        int offset = problem.getOffset();
        int len = problem.getLength();
        IJavaElement[] iJavaElementArray = cu.codeSelect(offset, len);
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement curr = iJavaElementArray[n2];
            if (curr instanceof IType) {
                IType currType = (IType)curr;
                if (!TypeFilter.isFiltered((IType)curr)) {
                    String qualifiedTypeName = currType.getFullyQualifiedName('.');
                    CompilationUnit root = context.getASTRoot();
                    String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_importexplicit_description, BasicElementLabels.getJavaElementName(qualifiedTypeName));
                    ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, cu, ASTRewrite.create((AST)root.getAST()), 5);
                    ImportRewrite imports = proposal.createImportRewrite(root);
                    imports.addImport(qualifiedTypeName);
                    T rewriteT = this.rewriteProposalToT(proposal, 2200);
                    if (rewriteT != null) {
                        proposals.add(rewriteT);
                    }
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void collectArrayAccessProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        void decl;
        CompilationUnit root = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(root);
        if (!(selectedNode instanceof MethodInvocation)) {
            return;
        }
        MethodInvocation methodInvocation = (MethodInvocation)selectedNode;
        SimpleName nameNode = decl.getName();
        String methodName = nameNode.getIdentifier();
        IBinding[] iBindingArray = new ScopeAnalyzer(root).getDeclarationsInScope(nameNode, 1);
        int n = iBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            String label;
            RenameNodeCorrectionProposalCore rename1;
            T rename1t;
            IBinding binding = iBindingArray[n2];
            String currName = binding.getName();
            if (NameMatcher.isSimilarName(methodName, currName) && (rename1t = this.renameNodeProposalToT(rename1 = new RenameNodeCorrectionProposalCore(label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_arraychangetomethod_description, BasicElementLabels.getJavaElementName(currName)), context.getCompilationUnit(), nameNode.getStartPosition(), nameNode.getLength(), currName, 6), 2300)) != null) {
                proposals.add(rename1t);
            }
            ++n2;
        }
        String lengthId = "length";
        String label = CorrectionMessages.UnresolvedElementsSubProcessor_arraychangetolength_description;
        int offset = nameNode.getStartPosition();
        int length = decl.getStartPosition() + decl.getLength() - offset;
        RenameNodeCorrectionProposalCore rename2 = new RenameNodeCorrectionProposalCore(label, context.getCompilationUnit(), offset, length, lengthId, 7);
        T rename2t = this.renameNodeProposalToT(rename2, 2301);
        if (rename2t != null) {
            proposals.add(rename2t);
        }
    }

    public void collectAnnotationMemberProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) throws CoreException {
        String label;
        NewAnnotationMemberProposalCore core;
        T prop;
        ICompilationUnit targetCU;
        String memberName;
        Annotation annotation;
        CompilationUnit astRoot = context.getASTRoot();
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode.getLocationInParent() == MemberValuePair.NAME_PROPERTY) {
            if (selectedNode.getParent().getLocationInParent() != NormalAnnotation.VALUES_PROPERTY) {
                return;
            }
            annotation = (Annotation)selectedNode.getParent().getParent();
            memberName = ((SimpleName)selectedNode).getIdentifier();
        } else if (selectedNode.getLocationInParent() == SingleMemberAnnotation.VALUE_PROPERTY) {
            annotation = (Annotation)selectedNode.getParent();
            memberName = "value";
        } else {
            return;
        }
        ITypeBinding annotBinding = annotation.resolveTypeBinding();
        if (annotBinding == null) {
            return;
        }
        if (annotation instanceof NormalAnnotation) {
            IMethodBinding[] iMethodBindingArray = annotBinding.getDeclaredMethods();
            int n = iMethodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding binding = iMethodBindingArray[n2];
                String curr = binding.getName();
                int relevance = NameMatcher.isSimilarName(memberName, curr) ? 6 : 3;
                String label2 = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_UnresolvedElementsSubProcessor_changetoattribute_description, BasicElementLabels.getJavaElementName(curr));
                RenameNodeCorrectionProposalCore core2 = new RenameNodeCorrectionProposalCore(label2, cu, problem.getOffset(), problem.getLength(), curr, relevance);
                T renameNodeCorrectionProposal = this.renameNodeProposalToT(core2, 2400);
                if (renameNodeCorrectionProposal != null) {
                    proposals.add(renameNodeCorrectionProposal);
                }
                ++n2;
            }
        }
        if (annotBinding.isFromSource() && (targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, annotBinding)) != null && (prop = this.newAnnotationProposalToT(core = new NewAnnotationMemberProposalCore(label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_UnresolvedElementsSubProcessor_createattribute_description, BasicElementLabels.getJavaElementName(memberName)), targetCU, selectedNode, annotBinding, 5), 2401)) != null) {
            proposals.add(prop);
        }
    }

    protected abstract ReorgCorrectionsBaseSubProcessor<T> getReorgSubProcessor();

    protected abstract TypeMismatchBaseSubProcessor<T> getTypeMismatchSubProcessor();

    protected abstract ChangeCorrectionProposalCore getOriginalProposalFromT(T var1);

    protected abstract T newVariableCorrectionProposalToT(NewVariableCorrectionProposalCore var1, int var2);

    protected abstract T renameNodeCorrectionProposalToT(RenameNodeCorrectionProposalCore var1, int var2);

    protected abstract T compositeProposalToT(ChangeCorrectionProposalCore var1, int var2);

    protected abstract int getQualifiedTypeNameHistoryBoost(String var1, int var2, int var3);

    protected abstract T linkedProposalToT(LinkedCorrectionProposalCore var1, int var2);

    protected abstract T changeCorrectionProposalToT(ChangeCorrectionProposalCore var1, int var2);

    protected abstract T qualifyTypeProposalToT(QualifyTypeProposalCore var1, int var2);

    protected abstract T addTypeParametersToT(AddTypeParameterProposalCore var1, int var2);

    protected abstract T addModuleRequiresProposalToT(AddModuleRequiresCorrectionProposalCore var1, int var2);

    protected abstract T replaceCorrectionProposalToT(ReplaceCorrectionProposalCore var1, int var2);

    protected abstract T castCorrectionProposalToT(CastCorrectionProposalCore var1, int var2);

    protected abstract T addArgumentCorrectionProposalToT(AddArgumentCorrectionProposalCore var1, int var2);

    protected abstract T changeMethodSignatureProposalToT(ChangeMethodSignatureProposalCore var1, int var2);

    protected abstract T newMethodProposalToT(NewMethodCorrectionProposalCore var1, int var2);

    protected abstract T rewriteProposalToT(ASTRewriteCorrectionProposalCore var1, int var2);

    protected abstract T newAnnotationProposalToT(NewAnnotationMemberProposalCore var1, int var2);

    protected abstract T renameNodeProposalToT(RenameNodeCorrectionProposalCore var1, int var2);
}

