/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdtls.ext.core.model;

import com.microsoft.jdtls.ext.core.ExtUtils;
import com.microsoft.jdtls.ext.core.JdtlsExtActivator;
import com.microsoft.jdtls.ext.core.model.ContainerNode;
import com.microsoft.jdtls.ext.core.model.NodeKind;
import com.microsoft.jdtls.ext.core.model.PackageRootNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;

public class PackageNode {
    public static final String K_TYPE_KIND = "TypeKind";
    public static final int K_CLASS = 1;
    public static final int K_INTERFACE = 2;
    public static final int K_ENUM = 3;
    public static final String REFERENCED_LIBRARIES_PATH = "REFERENCED_LIBRARIES_PATH";
    private static final String REFERENCED_LIBRARIES_CONTAINER_NAME = "Referenced Libraries";
    private static final String IMMUTABLE_REFERENCED_LIBRARIES_CONTAINER_NAME = "Referenced Libraries (Read-only)";
    public static final ContainerNode REFERENCED_LIBRARIES_CONTAINER = new ContainerNode("Referenced Libraries", "REFERENCED_LIBRARIES_PATH", NodeKind.CONTAINER, 5);
    public static final ContainerNode IMMUTABLE_REFERENCED_LIBRARIES_CONTAINER = new ContainerNode("Referenced Libraries (Read-only)", "REFERENCED_LIBRARIES_PATH", NodeKind.CONTAINER, 5);
    private static final String NATURE_ID = "NatureId";
    private static final String UNMANAGED_FOLDER_INNER_PATH = "UnmanagedFolderInnerPath";
    private static final String UNMANAGED_FOLDER_NATURE_ID = "org.eclipse.jdt.ls.core.unmanagedFolder";
    private String name;
    private String displayName;
    private String moduleName;
    private String path;
    private String handlerIdentifier;
    private String uri;
    private NodeKind kind;
    private Map<String, Object> metaData;
    private List<PackageNode> children;

    public PackageNode() {
    }

    public PackageNode(String name, String path, NodeKind kind) {
        this.name = name;
        this.path = path;
        this.kind = kind;
    }

    public String getHandlerIdentifier() {
        return this.handlerIdentifier;
    }

    public void setHandlerIdentifier(String handlerIdentifier) {
        this.handlerIdentifier = handlerIdentifier;
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public void setMetaDataValue(String key, Object value) {
        if (this.metaData == null) {
            this.metaData = new HashMap<String, Object>();
        }
        this.metaData.put(key, value);
    }

    public static PackageNode createNodeForProject(IJavaElement javaElement) {
        if (javaElement == null || javaElement.getJavaProject() == null) {
            return null;
        }
        IProject proj = javaElement.getJavaProject().getProject();
        PackageNode projectNode = new PackageNode(proj.getName(), proj.getFullPath().toPortableString(), NodeKind.PROJECT);
        projectNode.setUri(ProjectUtils.getProjectRealFolder((IProject)proj).toFile().toURI().toString());
        try {
            ArrayList<String> natureIds = new ArrayList<String>(Arrays.asList(proj.getDescription().getNatureIds()));
            if (!ProjectUtils.isVisibleProject((IProject)proj)) {
                natureIds.add(UNMANAGED_FOLDER_NATURE_ID);
                projectNode.setMetaDataValue(UNMANAGED_FOLDER_INNER_PATH, proj.getLocationURI().toString());
            }
            projectNode.setMetaDataValue(NATURE_ID, natureIds);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return projectNode;
    }

    public static PackageNode createNodeForResource(IResource resource) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            PackageNode entry = new PackageNode(file.getName(), file.getFullPath().toPortableString(), NodeKind.FILE);
            entry.setUri(JDTUtils.getFileURI((IResource)file));
            return entry;
        }
        if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            PackageNode entry = new PackageNode(folder.getName(), folder.getFullPath().toPortableString(), NodeKind.FOLDER);
            entry.setUri(JDTUtils.getFileURI((IResource)folder));
            return entry;
        }
        return null;
    }

    public static PackageNode createNodeForPackageFragment(IPackageFragment packageFragment) {
        PackageNode fragmentNode = new PackageNode(packageFragment.getElementName(), packageFragment.getPath().toPortableString(), NodeKind.PACKAGE);
        fragmentNode.setHandlerIdentifier(packageFragment.getHandleIdentifier());
        return fragmentNode;
    }

    public static PackageNode createNodeForVirtualContainer(IPackageFragmentRoot pkgRoot) throws JavaModelException {
        IClasspathEntry entry = pkgRoot.getRawClasspathEntry();
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)pkgRoot.getJavaProject());
        ContainerNode containerNode = null;
        containerNode = entry.getEntryKind() == 1 || entry.getEntryKind() == 4 ? REFERENCED_LIBRARIES_CONTAINER : new ContainerNode(container.getDescription(), container.getPath().toPortableString(), NodeKind.CONTAINER, entry.getEntryKind());
        return containerNode;
    }

    public static PackageRootNode createNodeForPackageFragmentRoot(IPackageFragmentRoot pkgRoot) throws JavaModelException {
        boolean isSourcePath;
        String displayName = pkgRoot.getElementName();
        boolean bl = isSourcePath = pkgRoot.getKind() == 1;
        if (!isSourcePath) {
            IClasspathEntry entry = pkgRoot.getRawClasspathEntry();
            if (entry.getEntryKind() == 4) {
                return PackageNode.createNodeForClasspathVariable(entry);
            }
            return new PackageRootNode(pkgRoot, displayName, NodeKind.PACKAGEROOT);
        }
        IJavaProject javaProject = pkgRoot.getJavaProject();
        IPath relativePath = pkgRoot.getPath();
        if (pkgRoot.getJavaProject().getPath().isPrefixOf(relativePath)) {
            relativePath = relativePath.makeRelativeTo(javaProject.getPath());
        }
        if (Objects.equals("_", relativePath.segment(0))) {
            relativePath = relativePath.removeFirstSegments(1);
        }
        displayName = relativePath.toPortableString();
        return new PackageRootNode(pkgRoot, displayName, NodeKind.PACKAGEROOT);
    }

    public static PackageNode createNodeForClasspathEntry(IClasspathEntry classpathEntry, IJavaProject javaProject, NodeKind nodeKind) {
        try {
            IClasspathEntry entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)classpathEntry);
            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProject);
            if (container == null) {
                container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProject);
            }
            if (container != null) {
                PackageNode node = null;
                if (nodeKind == NodeKind.CONTAINER) {
                    node = new ContainerNode(container.getDescription(), container.getPath().toPortableString(), nodeKind, entry.getEntryKind());
                    URI containerURI = ExtUtils.getContainerURI(javaProject, container);
                    node.setUri(containerURI != null ? containerURI.toString() : null);
                } else if (nodeKind == NodeKind.PACKAGEROOT) {
                    String[] pathSegments = container.getPath().segments();
                    node = new PackageRootNode(pathSegments[pathSegments.length - 1], container.getPath().toPortableString(), container.getPath().toFile().toURI().toString(), nodeKind, 2);
                }
                return node;
            }
        }
        catch (CoreException e) {
            JdtlsExtActivator.logException("Problems when convert classpath entry to package node ", e);
        }
        return null;
    }

    public static PackageNode createNodeForPrimaryType(IType type) {
        PackageNode primaryTypeNode = new PackageNode(type.getElementName(), type.getPath().toPortableString(), NodeKind.PRIMARYTYPE);
        try {
            if (type.isEnum()) {
                primaryTypeNode.setMetaDataValue(K_TYPE_KIND, 3);
            } else if (type.isInterface()) {
                primaryTypeNode.setMetaDataValue(K_TYPE_KIND, 2);
            } else {
                primaryTypeNode.setMetaDataValue(K_TYPE_KIND, 1);
            }
        }
        catch (JavaModelException e) {
            primaryTypeNode.setMetaDataValue(K_TYPE_KIND, 1);
        }
        primaryTypeNode.setUri(JDTUtils.toUri((ITypeRoot)type.getTypeRoot()));
        return primaryTypeNode;
    }

    public static PackageRootNode createNodeForClasspathVariable(IClasspathEntry classpathEntry) {
        IClasspathEntry entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)classpathEntry);
        String name = classpathEntry.getPath().toPortableString();
        String path = entry.getPath().toPortableString();
        String uri = entry.getPath().toFile().toURI().toString();
        return new PackageRootNode(name, path, uri, NodeKind.PACKAGEROOT, 2);
    }

    public String getName() {
        return this.name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getPath() {
        return this.path;
    }

    public NodeKind getKind() {
        return this.kind;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public List<PackageNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<PackageNode> children) {
        this.children = children;
    }
}

