/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.nebula.nattable.finder.waits;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuAction;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.nebula.nattable.finder.finders.NatTableContextMenuFinder;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.WidgetResult;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.waits.WaitForPopupMenu;

public class WaitForNatTablePopupMenu
extends WaitForPopupMenu {
    private final Control control;
    private final int x;
    private final int y;

    public WaitForNatTablePopupMenu(Control control, int x, int y) {
        super(control);
        this.control = control;
        this.x = x;
        this.y = y;
    }

    protected List<Menu> findMatches() {
        Menu popupMenu = (Menu)UIThreadRunnable.syncExec((Result)new WidgetResult<Menu>(){

            public Menu run() {
                Menu menu = WaitForNatTablePopupMenu.this.control.getMenu();
                if (menu == null && WaitForNatTablePopupMenu.this.control instanceof NatTable) {
                    menu = WaitForNatTablePopupMenu.this.getNatTableMenu();
                }
                if (menu != null) {
                    menu.notifyListeners(22, SWTUtils.createEvent((Widget)menu));
                }
                return menu;
            }
        });
        if (popupMenu != null) {
            return Collections.singletonList(popupMenu);
        }
        return Collections.emptyList();
    }

    private Menu getNatTableMenu() {
        Event event = NatTableContextMenuFinder.createMouseEvent(this.control, this.x, this.y, 3, 0, 1);
        MouseEvent mouseevent = new MouseEvent(event);
        IMouseAction action = ((NatTable)this.control).getUiBindingRegistry().getMouseDownAction(mouseevent);
        if (action instanceof PopupMenuAction) {
            PopupMenuAction popupMenuAction = (PopupMenuAction)action;
            Field privateMenu = null;
            try {
                privateMenu = PopupMenuAction.class.getDeclaredField("menu");
            }
            catch (NoSuchFieldException e) {
                return null;
            }
            catch (SecurityException e) {
                return null;
            }
            privateMenu.setAccessible(true);
            try {
                return (Menu)privateMenu.get(popupMenuAction);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return null;
    }
}

