/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.launch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.debug.core.launch.CoreBuildLaunchConfigDelegate;
import org.eclipse.cdt.debug.internal.core.InternalDebugCoreMessages;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.launch.ITargetedLaunch;

public class CoreBuildLocalRunLaunchDelegate
extends CoreBuildLaunchConfigDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ILaunchTarget target = ((ITargetedLaunch)launch).getLaunchTarget();
        ICBuildConfiguration buildConfig = this.getBuildConfiguration(configuration, mode, target, monitor);
        String programPath = this.getProgramPath(configuration, buildConfig);
        try {
            String args = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "");
            if (args.length() != 0) {
                args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(args);
            }
            String[] arguments = CommandLineUtil.argumentsToArray((String)args);
            ArrayList<String> command = new ArrayList<String>(1 + arguments.length);
            command.add(programPath);
            command.addAll(Arrays.asList(arguments));
            ProcessBuilder builder = new ProcessBuilder(command);
            String workingDirectory = configuration.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", "");
            if (!workingDirectory.isBlank()) {
                workingDirectory = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(workingDirectory);
                builder.directory(new File(workingDirectory));
            }
            Map<String, String> environment = builder.environment();
            Map launchEnvironment = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, new HashMap());
            if (!configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true)) {
                environment.clear();
            }
            environment.putAll(launchEnvironment);
            buildConfig.setBuildEnvironment(environment);
            Process process = builder.start();
            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)IPath.fromOSString((String)programPath).lastSegment());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.core", InternalDebugCoreMessages.CoreBuildLocalRunLaunchDelegate_ErrorLaunching, (Throwable)e));
        }
    }
}

