/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class FunctionCompletionProposal
extends CCompletionProposal {
    private boolean fHasParametersComputed;
    private boolean fHasParameters;
    protected IParameter[] fFunctionParameters;
    protected int fInvocationOffset;
    protected int fParseOffset;
    protected ITranslationUnit fTranslationUnit;
    protected IDocument fDocument;

    public FunctionCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, String idString, int relevance, ITextViewer viewer, IFunction function, int invocationOffset, int parseOffset, ITranslationUnit translationUnit, IDocument document) {
        super(replacementString, replacementOffset, replacementLength, image, displayString, idString, relevance, viewer);
        this.fFunctionParameters = function.getParameters();
        this.fInvocationOffset = invocationOffset;
        this.fParseOffset = parseOffset;
        this.fTranslationUnit = translationUnit;
        this.fDocument = document;
    }

    @Override
    public void apply(IDocument document, char trigger, int offset) {
        if (trigger == ' ' || trigger == '(') {
            trigger = '\u0000';
        }
        super.apply(document, trigger, offset);
        if (this.hasParameters()) {
            this.setUpLinkedMode(document, ')');
        } else if (this.getReplacementString().endsWith(";")) {
            this.setUpLinkedMode(document, ';');
        }
    }

    protected final boolean hasParameters() {
        if (!this.fHasParametersComputed) {
            this.fHasParametersComputed = true;
            this.fHasParameters = this.computeHasParameters();
        }
        return this.fHasParameters;
    }

    private boolean computeHasParameters() {
        return this.fFunctionParameters != null && this.fFunctionParameters.length != 0;
    }

    protected void setUpLinkedMode(IDocument document, char closingCharacter) {
        if (this.fTextViewer != null) {
            int exit = this.getReplacementOffset() + this.getReplacementString().length();
            try {
                LinkedPositionGroup group = new LinkedPositionGroup();
                group.addPosition(new LinkedPosition(document, this.fInvocationOffset, 0, -1));
                LinkedModeModel model = new LinkedModeModel();
                model.addGroup(group);
                model.forceInstall();
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.fTextViewer);
                ui.setSimpleMode(true);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(closingCharacter));
                ui.setExitPosition(this.fTextViewer, exit, 0, Integer.MAX_VALUE);
                ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                ui.enter();
            }
            catch (BadLocationException x) {
                CUIPlugin.log(x);
            }
        }
    }

    protected static class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;

        public ExitPolicy(char exitCharacter) {
            this.fExitCharacter = exitCharacter;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel environment, VerifyEvent event, int offset, int length) {
            if (event.character == this.fExitCharacter) {
                if (environment.anyPositionContains(offset)) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
                return new LinkedModeUI.ExitFlags(2, true);
            }
            switch (event.character) {
                case ';': {
                    return new LinkedModeUI.ExitFlags(0, true);
                }
            }
            return null;
        }
    }
}

