/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import java.util.List;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.utils.StringUtils;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;

public abstract class DOMCharacterData
extends DOMNode
implements CharacterData {
    private String data;
    private String normalizedData;
    private boolean isWhitespace;
    private String delimiter;

    public DOMCharacterData(int start, int end) {
        super(start, end);
    }

    public boolean hasMultiLine() {
        return this.getData().contains(this.getDelimiter());
    }

    public String getDelimiter() {
        if (this.delimiter != null) {
            return this.delimiter;
        }
        try {
            this.delimiter = this.getOwnerDocument().getTextDocument().lineDelimiter(0);
            return this.delimiter;
        }
        catch (BadLocationException e) {
            this.delimiter = System.lineSeparator();
            return this.delimiter;
        }
    }

    public boolean endsWithNewLine() {
        if (this.hasData()) {
            for (int i = this.data.length() - 1; i >= 0; --i) {
                char c = this.data.charAt(i);
                if (!Character.isWhitespace(c)) {
                    return false;
                }
                if (c != '\n') continue;
                return true;
            }
        }
        return false;
    }

    public boolean startsWithNewLine() {
        if (this.hasData()) {
            for (int i = 0; i < this.data.length(); ++i) {
                char c = this.data.charAt(i);
                if (!Character.isWhitespace(c)) {
                    return false;
                }
                if (c != '\n' && c != '\r') continue;
                return true;
            }
        }
        return false;
    }

    public String getNormalizedData() {
        if (this.normalizedData == null) {
            this.normalizedData = StringUtils.normalizeSpace(this.getData());
        }
        return this.normalizedData;
    }

    public boolean hasData() {
        return !this.getData().isEmpty();
    }

    public boolean hasSiblings() {
        List<DOMNode> childrenOfParent = this.parent.getChildren();
        return childrenOfParent.size() > 1;
    }

    public int getStartContent() {
        return this.start;
    }

    public int getEndContent() {
        return this.end;
    }

    @Override
    public String getData() {
        if (this.data == null) {
            this.data = this.getOwnerDocument().getText().substring(this.getStartContent(), this.getEndContent());
        }
        return this.data;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getData();
    }

    public boolean isWhitespace() {
        return this.isWhitespace;
    }

    public void setWhitespace(boolean isWhitespace) {
        this.isWhitespace = isWhitespace;
    }

    @Override
    public void appendData(String data) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteData(int offset, int count) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLength() {
        return this.getData().length();
    }

    @Override
    public void insertData(int offset, String data) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceData(int offset, int count, String data) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setData(String value) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String substringData(int offset, int count) throws DOMException {
        throw new UnsupportedOperationException();
    }
}

