/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterator;

import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class TransformationIterator<E1, E2>
implements Iterator<E2> {
    private final Iterator<? extends E1> iterator;
    private final Transformer<? super E1, ? extends E2> transformer;

    public TransformationIterator(Iterator<? extends E1> iterator, Transformer<? super E1, ? extends E2> transformer) {
        if (iterator == null || transformer == null) {
            throw new NullPointerException();
        }
        this.iterator = iterator;
        this.transformer = transformer;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E2 next() {
        return this.transformer.transform(this.iterator.next());
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.iterator);
    }
}

