/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IManagedConnectionListener;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.enablement.ibm.IBMPluginActivator;
import org.eclipse.datatools.enablement.ibm.catalog.util.CatalogLoadUtil;
import org.eclipse.datatools.enablement.ibm.catalog.util.CatalogObjectEvent;
import org.eclipse.datatools.enablement.ibm.catalog.util.ICatalogObjectEventListener;
import org.eclipse.datatools.enablement.ibm.catalog.util.ICatalogQuery;
import org.eclipse.datatools.enablement.ibm.util.PRSDebug;
import org.eclipse.datatools.enablement.ibm.util.PRSPersistenceUtility;
import org.eclipse.datatools.enablement.ibm.util.PRSQueryInfo;
import org.eclipse.datatools.enablement.ibm.util.PRSSliceInfo;
import org.eclipse.datatools.enablement.ibm.util.RefreshEventManager;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.ecore.EObject;

public class PersistentQueryCache {
    private static final String METADATA_VERSION = "MD01";
    private static final String LOCALHOST = "localhost";
    private static List<PersistentQueryCache> activeCaches = null;
    private static int[] cacheLock = new int[0];
    private final Database database;
    private File cacheFolder;
    private final List<PRSQueryInfo> queries = new ArrayList<PRSQueryInfo>();
    private final boolean[] queriesLocked = new boolean[1];
    private ConnectionCloseListener connectionCloseListener = null;
    private ICatalogObjectEventListener refreshListener = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersistentQueryCache getQueryCache(Database db) {
        int[] nArray = cacheLock;
        synchronized (cacheLock) {
            if (activeCaches == null) {
                activeCaches = new ArrayList<PersistentQueryCache>();
                PersistentQueryCache.initializeDiskCache();
            }
            for (PersistentQueryCache qcache : activeCaches) {
                if (qcache == null || qcache.database == null || db == null || !qcache.database.equals(db)) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return qcache;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new PersistentQueryCache(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistentQueryCache(Database db) {
        this.database = db;
        int[] nArray = cacheLock;
        synchronized (cacheLock) {
            activeCaches.add(this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.refreshListener = new ICatalogObjectEventListener(){

                @Override
                public void notifyChanged(CatalogObjectEvent event) {
                    if (event.type == CatalogObjectEvent.EVENT_TYPE.ELEMENT_REFRESH) {
                        PersistentQueryCache.this.respondToRefresh(event.element);
                    }
                }
            };
            RefreshEventManager.getInstance().addCatalogObjectEventListener(null, this.refreshListener);
            this.connectionCloseListener = new ConnectionCloseListener();
            this.initCacheFolder();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseResources() {
        this.purge();
        int[] nArray = cacheLock;
        synchronized (cacheLock) {
            activeCaches.remove(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.connectionCloseListener = null;
            RefreshEventManager.getInstance().removeCatalogObjectEventListener(null, this.refreshListener);
            this.refreshListener = null;
            return;
        }
    }

    private void initCacheFolder() {
        if (PRSDebug.noFileCache || this.cacheFolder != null) {
            return;
        }
        File cachedir = this.generateUniqueCacheFolder();
        if (cachedir != null) {
            if (!cachedir.exists()) {
                if (!cachedir.mkdirs()) {
                    cachedir = null;
                }
            } else {
                this.cacheFolder = cachedir;
                this.load();
            }
        }
        this.cacheFolder = cachedir;
    }

    private File generateUniqueCacheFolder() {
        if (this.database == null) {
            return null;
        }
        File cacheRoot = PersistentQueryCache.getQueryRootFolder();
        if (cacheRoot == null || !cacheRoot.isDirectory()) {
            return null;
        }
        String name = "";
        IConnectionProfile profile = null;
        ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.database);
        if (connectionInfo != null) {
            profile = connectionInfo.getConnectionProfile();
            name = profile.getName();
        } else {
            name = this.database.getName();
        }
        String dirname = String.valueOf(PersistentQueryCache.getHostName(profile)) + "_" + name;
        File cachedir = new File(cacheRoot, dirname);
        return cachedir;
    }

    private static String getHostName(IConnectionProfile cp) {
        if (cp == null) {
            return LOCALHOST;
        }
        Properties properties = cp.getProperties(cp.getProviderId());
        String URL2 = properties.getProperty("org.eclipse.datatools.connectivity.db.URL");
        int hostStr = URL2.indexOf("://");
        if (hostStr < 0) {
            return LOCALHOST;
        }
        int hostEnd = URL2.indexOf(":", hostStr += 3);
        return hostEnd > hostStr ? URL2.substring(hostStr, hostEnd) : URL2.substring(hostStr);
    }

    public Database getDatabase() {
        return this.database;
    }

    public File getCacheFolder() {
        return this.cacheFolder;
    }

    private static File getQueryRootFolder() {
        return null;
    }

    private static void initializeDiskCache() {
        File cacheRoot = PersistentQueryCache.getQueryRootFolder();
        if (cacheRoot == null) {
            return;
        }
        if (!cacheRoot.exists()) {
            if (!cacheRoot.mkdirs()) {
                return;
            }
        } else if (cacheRoot.isDirectory()) {
            PersistentQueryCache.purgeAll();
        }
    }

    public static void resetQuery(Database db, ICatalogQuery query) {
        PersistentQueryCache cache = PersistentQueryCache.getQueryCache(db);
        PRSQueryInfo qinfo = cache.getQueryInfo(query);
        if (qinfo != null && qinfo.isComplete()) {
            qinfo.reset(query);
        }
    }

    private static void purgeAll() {
        File cacheRoot = PersistentQueryCache.getQueryRootFolder();
        if (cacheRoot == null || !cacheRoot.isDirectory()) {
            return;
        }
        File[] fileArray = cacheRoot.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File cachedir = fileArray[n2];
            if (cachedir.isDirectory()) {
                File[] fileArray2 = cachedir.listFiles();
                int n3 = fileArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file = fileArray2[n4];
                    file.delete();
                    ++n4;
                }
                cachedir.delete();
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        List<PRSQueryInfo> list = this.queries;
        synchronized (list) {
            this.queries.clear();
        }
        if (this.cacheFolder == null) {
            return;
        }
        File[] fileArray = this.cacheFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PRSQueryInfo getQueryInfo(ICatalogQuery query) {
        String upfrontQueryText = query.generateUpFrontQuery(this.database);
        if (upfrontQueryText == null) {
            return null;
        }
        List<PRSQueryInfo> list = this.queries;
        synchronized (list) {
            int ii = this.queries.size() - 1;
            while (ii >= 0) {
                PRSQueryInfo qinfo = this.queries.get(ii);
                if (upfrontQueryText.equals(qinfo.getUpfrontQueryText())) {
                    return qinfo;
                }
                --ii;
            }
        }
        return null;
    }

    private PRSQueryInfo findOrCreateQueryInfo(ICatalogQuery query) {
        PRSQueryInfo qinfo = this.getQueryInfo(query);
        if (qinfo == null) {
            qinfo = this.createQueryInfo(query);
        }
        return qinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PRSQueryInfo createQueryInfo(ICatalogQuery query) {
        List<PRSQueryInfo> list = this.queries;
        synchronized (list) {
            int id = this.queries.size();
            PRSQueryInfo qinfo = new PRSQueryInfo(this, id, query);
            this.registerQueryInfo(qinfo);
            return qinfo;
        }
    }

    public PRSSliceInfo getSlice(ICatalogQuery query, Connection conn) {
        PRSQueryInfo qinfo = this.findOrCreateQueryInfo(query);
        return qinfo.getSlice(query, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerQueryInfo(PRSQueryInfo qinfo) {
        List<PRSQueryInfo> list = this.queries;
        synchronized (list) {
            this.queries.add(qinfo);
            this.saveQueries();
        }
    }

    public void save() {
        this.saveQueries();
    }

    public void load() {
        this.loadQueries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveQueries() {
        if (PRSDebug.noFileCache || this.getCacheFolder() == null) {
            return;
        }
        if (this.queriesLocked[0]) {
            return;
        }
        this.queriesLocked[0] = true;
        PrintWriter pw = null;
        try {
            pw = PRSPersistenceUtility.openFileForCreate(this.getQueriesFile());
            if (pw == null) {
                return;
            }
            List<PRSQueryInfo> list = this.queries;
            synchronized (list) {
                pw.println(METADATA_VERSION);
                for (PRSQueryInfo qinfo : this.queries) {
                    pw.println(qinfo.toPrintString());
                }
            }
        }
        finally {
            if (pw != null) {
                CatalogLoadUtil.safeClose(pw);
            }
            this.queriesLocked[0] = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadQueries() {
        if (PRSDebug.noFileCache) {
            return;
        }
        if (this.queriesLocked[0]) {
            return;
        }
        File qfile = this.getQueriesFile();
        if (qfile == null || !qfile.isFile() || !qfile.canRead()) {
            return;
        }
        this.queriesLocked[0] = true;
        LineNumberReader lnr = null;
        try {
            lnr = PRSPersistenceUtility.openFileForRead(qfile);
            if (lnr == null) {
                return;
            }
            List<PRSQueryInfo> list = this.queries;
            synchronized (list) {
                String line;
                block16: {
                    line = lnr.readLine();
                    if (METADATA_VERSION.equals(line)) break block16;
                    CatalogLoadUtil.safeClose(lnr);
                    lnr = null;
                    this.purge();
                    return;
                }
                try {
                    while ((line = lnr.readLine()) != null) {
                        PRSQueryInfo.loadSavedQuery(this, line);
                    }
                }
                catch (IOException e) {
                    IBMPluginActivator.log(e);
                }
            }
        }
        finally {
            CatalogLoadUtil.safeClose(lnr);
            this.queriesLocked[0] = false;
        }
        {
            return;
        }
    }

    public File getQueriesFile() {
        String name = "queries.txt";
        return new File(this.getCacheFolder(), name);
    }

    private void respondToRefresh(ICatalogObject catalogObject) {
        ContainmentService cs = IBMPluginActivator.getInstance().getContainmentService();
        if (!(catalogObject instanceof EObject) || this.getDatabase() != cs.getRootElement((EObject)catalogObject)) {
            return;
        }
        this.purge();
    }

    private class ConnectionCloseListener
    implements IManagedConnectionListener {
        private IConnectionProfile profile;
        private WeakReference<IManagedConnection> conn;

        public ConnectionCloseListener() {
            ConnectionInfo connInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(PersistentQueryCache.this.database);
            if (connInfo == null) {
                return;
            }
            this.profile = connInfo.getConnectionProfile();
            if (this.profile == null) {
                return;
            }
            IManagedConnection mc = this.profile.getManagedConnection("org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo");
            if (mc == null) {
                return;
            }
            this.conn = new WeakReference<IManagedConnection>(mc);
            mc.addConnectionListener((IManagedConnectionListener)this);
        }

        public boolean okToClose(ConnectEvent event) {
            return true;
        }

        public void closed(ConnectEvent event) {
            IConnectionProfile eventProfile = event.getConnectionProfile();
            if (eventProfile == null || this.profile == null || !eventProfile.getName().equals(this.profile.getName())) {
                return;
            }
            IManagedConnection c = (IManagedConnection)this.conn.get();
            if (c != null) {
                c.removeConnectionListener((IManagedConnectionListener)this);
            }
            this.profile = null;
            PersistentQueryCache.this.releaseResources();
        }

        public void aboutToClose(ConnectEvent event) {
        }

        public void modified(ConnectEvent event) {
        }

        public void opened(ConnectEvent event) {
        }
    }
}

