/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.misc.IntArray;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.CommonTree;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.CommonTreeAdaptor;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.TreeAdaptor;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.TreeNodeStream;

public class BufferedTreeNodeStream
implements TreeNodeStream {
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 100;
    public static final int INITIAL_CALL_STACK_SIZE = 10;
    protected Object down;
    protected Object up;
    protected Object eof;
    protected List<Object> nodes;
    protected Object root;
    protected TokenStream tokens;
    TreeAdaptor adaptor;
    protected boolean uniqueNavigationNodes = false;
    protected int p = -1;
    protected int lastMarker;
    protected IntArray calls;

    public BufferedTreeNodeStream(Object object) {
        this(new CommonTreeAdaptor(), object);
    }

    public BufferedTreeNodeStream(TreeAdaptor treeAdaptor, Object object) {
        this(treeAdaptor, object, 100);
    }

    public BufferedTreeNodeStream(TreeAdaptor treeAdaptor, Object object, int n) {
        this.root = object;
        this.adaptor = treeAdaptor;
        this.nodes = new ArrayList<Object>(n);
        this.down = treeAdaptor.create(2, "DOWN");
        this.up = treeAdaptor.create(3, "UP");
        this.eof = treeAdaptor.create(-1, "EOF");
    }

    protected void fillBuffer() {
        this.fillBuffer(this.root);
        this.p = 0;
    }

    public void fillBuffer(Object object) {
        boolean bl = this.adaptor.isNil(object);
        if (!bl) {
            this.nodes.add(object);
        }
        int n = this.adaptor.getChildCount(object);
        if (!bl && n > 0) {
            this.addNavigationNode(2);
        }
        for (int i = 0; i < n; ++i) {
            Object object2 = this.adaptor.getChild(object, i);
            this.fillBuffer(object2);
        }
        if (!bl && n > 0) {
            this.addNavigationNode(3);
        }
    }

    protected int getNodeIndex(Object object) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            Object object2 = this.nodes.get(i);
            if (object2 != object) continue;
            return i;
        }
        return -1;
    }

    protected void addNavigationNode(int n) {
        Object object = n == 2 ? (this.hasUniqueNavigationNodes() ? this.adaptor.create(2, "DOWN") : this.down) : (this.hasUniqueNavigationNodes() ? this.adaptor.create(3, "UP") : this.up);
        this.nodes.add(object);
    }

    @Override
    public Object get(int n) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return this.nodes.get(n);
    }

    @Override
    public Object LT(int n) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        if (n == 0) {
            return null;
        }
        if (n < 0) {
            return this.LB(-n);
        }
        if (this.p + n - 1 >= this.nodes.size()) {
            return this.eof;
        }
        return this.nodes.get(this.p + n - 1);
    }

    public Object getCurrentSymbol() {
        return this.LT(1);
    }

    protected Object LB(int n) {
        if (n == 0) {
            return null;
        }
        if (this.p - n < 0) {
            return null;
        }
        return this.nodes.get(this.p - n);
    }

    @Override
    public Object getTreeSource() {
        return this.root;
    }

    @Override
    public String getSourceName() {
        return this.getTokenStream().getSourceName();
    }

    @Override
    public TokenStream getTokenStream() {
        return this.tokens;
    }

    public void setTokenStream(TokenStream tokenStream) {
        this.tokens = tokenStream;
    }

    @Override
    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }

    public void setTreeAdaptor(TreeAdaptor treeAdaptor) {
        this.adaptor = treeAdaptor;
    }

    public boolean hasUniqueNavigationNodes() {
        return this.uniqueNavigationNodes;
    }

    @Override
    public void setUniqueNavigationNodes(boolean bl) {
        this.uniqueNavigationNodes = bl;
    }

    @Override
    public void consume() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        ++this.p;
    }

    @Override
    public int LA(int n) {
        return this.adaptor.getType(this.LT(n));
    }

    @Override
    public int mark() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        this.lastMarker = this.index();
        return this.lastMarker;
    }

    @Override
    public void release(int n) {
    }

    @Override
    public int index() {
        return this.p;
    }

    @Override
    public void rewind(int n) {
        this.seek(n);
    }

    @Override
    public void rewind() {
        this.seek(this.lastMarker);
    }

    @Override
    public void seek(int n) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        this.p = n;
    }

    public void push(int n) {
        if (this.calls == null) {
            this.calls = new IntArray();
        }
        this.calls.push(this.p);
        this.seek(n);
    }

    public int pop() {
        int n = this.calls.pop();
        this.seek(n);
        return n;
    }

    @Override
    public void reset() {
        this.p = 0;
        this.lastMarker = 0;
        if (this.calls != null) {
            this.calls.clear();
        }
    }

    @Override
    public int size() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return this.nodes.size();
    }

    public Iterator<Object> iterator() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return new StreamIterator();
    }

    @Override
    public void replaceChildren(Object object, int n, int n2, Object object2) {
        if (object != null) {
            this.adaptor.replaceChildren(object, n, n2, object2);
        }
    }

    public String toTokenTypeString() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.nodes.size(); ++i) {
            Object object = this.nodes.get(i);
            stringBuilder.append(" ");
            stringBuilder.append(this.adaptor.getType(object));
        }
        return stringBuilder.toString();
    }

    public String toTokenString(int n, int n2) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < this.nodes.size() && i <= n2; ++i) {
            Object object = this.nodes.get(i);
            stringBuilder.append(" ");
            stringBuilder.append(this.adaptor.getToken(object));
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString(Object object, Object object2) {
        String string;
        Object object3;
        int n;
        System.out.println("toString");
        if (object == null || object2 == null) {
            return null;
        }
        if (this.p == -1) {
            this.fillBuffer();
        }
        if (object instanceof CommonTree) {
            System.out.print("toString: " + ((CommonTree)object).getToken() + ", ");
        } else {
            System.out.println(object);
        }
        if (object2 instanceof CommonTree) {
            System.out.println(((CommonTree)object2).getToken());
        } else {
            System.out.println(object2);
        }
        if (this.tokens != null) {
            int n2 = this.adaptor.getTokenStartIndex(object);
            int n3 = this.adaptor.getTokenStopIndex(object2);
            if (this.adaptor.getType(object2) == 3) {
                n3 = this.adaptor.getTokenStopIndex(object);
            } else if (this.adaptor.getType(object2) == -1) {
                n3 = this.size() - 2;
            }
            return this.tokens.toString(n2, n3);
        }
        for (n = 0; n < this.nodes.size() && (object3 = this.nodes.get(n)) != object; ++n) {
        }
        StringBuilder stringBuilder = new StringBuilder();
        object3 = this.nodes.get(n);
        while (object3 != object2) {
            string = this.adaptor.getText(object3);
            if (string == null) {
                string = " " + String.valueOf(this.adaptor.getType(object3));
            }
            stringBuilder.append(string);
            object3 = this.nodes.get(++n);
        }
        string = this.adaptor.getText(object2);
        if (string == null) {
            string = " " + String.valueOf(this.adaptor.getType(object2));
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    protected class StreamIterator
    implements Iterator<Object> {
        int i = 0;

        protected StreamIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < BufferedTreeNodeStream.this.nodes.size();
        }

        @Override
        public Object next() {
            int n;
            if ((n = this.i++) < BufferedTreeNodeStream.this.nodes.size()) {
                return BufferedTreeNodeStream.this.nodes.get(n);
            }
            return BufferedTreeNodeStream.this.eof;
        }

        @Override
        public void remove() {
            throw new RuntimeException("cannot remove nodes from stream");
        }
    }
}

