/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ConfigureLabelsModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ConfigureLabelsPage;
import org.eclipse.linuxtools.internal.docker.ui.wizards.LabelVariableModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;

public class ConfigureLabels
extends Wizard {
    private final ConfigureLabelsPage configureLabelsPage;
    private ConfigureLabelsModel model;
    private Map<String, String> labelMap = new LinkedHashMap<String, String>();

    public ConfigureLabels() {
        this.setWindowTitle(WizardMessages.getString("ConfigureLabels.title"));
        this.configureLabelsPage = new ConfigureLabelsPage();
        this.model = this.configureLabelsPage.getModel();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.configureLabelsPage);
    }

    public boolean canFinish() {
        return this.configureLabelsPage.isPageComplete();
    }

    public boolean performFinish() {
        this.labelMap = this.calculateConfigureLabels();
        return true;
    }

    public Map<String, String> getConfigureLabels() {
        return this.labelMap;
    }

    private Map<String, String> calculateConfigureLabels() {
        LinkedHashMap<String, String> labelMap = new LinkedHashMap<String, String>();
        WritableList<LabelVariableModel> vars = this.model.getLabelVariables();
        for (int i = 0; i < vars.size(); ++i) {
            String key = ((LabelVariableModel)vars.get(i)).getName();
            String value = ((LabelVariableModel)vars.get(i)).getValue();
            labelMap.put(key, value);
        }
        return labelMap;
    }
}

