/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncherManager;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.language.settings.providers.ICBuildOutputParser;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.language.settings.providers.IWorkingDirectoryTracker;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.language.settings.providers.ScannerDiscoveryLegacySupport;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.BuildRunnerHelper;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.MakeBuilderUtil;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerInfoConsoleParserFactory;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class MakeBuilder
extends ACBuilder {
    public static final String BUILDER_ID = MakeCorePlugin.getUniqueIdentifier() + ".makeBuilder";
    private static final int PROGRESS_MONITOR_SCALE = 100;
    private static final int TICKS_STREAM_PROGRESS_MONITOR = 100;
    private static final int TICKS_DELETE_MARKERS = 100;
    private static final int TICKS_EXECUTE_COMMAND = 100;
    private BuildRunnerHelper buildRunnerHelper = null;

    protected IProject[] build(int kind, Map args0, IProgressMonitor monitor) throws CoreException {
        boolean isClean;
        Map args = args0;
        boolean bPerformBuild = true;
        IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(args, BUILDER_ID);
        if (!this.shouldBuild(kind, info)) {
            return new IProject[0];
        }
        if (kind == 9) {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta != null) {
                IResource res = delta.getResource();
                if (res != null) {
                    bPerformBuild = res.getProject().equals((Object)this.getProject());
                }
            } else {
                bPerformBuild = false;
            }
        }
        if (bPerformBuild && (isClean = this.invokeMake(kind, info, monitor))) {
            this.forgetLastBuiltState();
        }
        this.checkCancel(monitor);
        return this.getProject().getReferencedProjects();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        final IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(this.getProject(), BUILDER_ID);
        if (this.shouldBuild(15, info)) {
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            final ISchedulingRule rule = ruleFactory.modifyRule((IResource)this.getProject());
            Job backgroundJob = new Job("Standard Make Builder"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) {
                                MakeBuilder.this.invokeMake(15, info, monitor);
                            }
                        }, rule, 1, monitor);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    IStatus returnStatus = Status.OK_STATUS;
                    return returnStatus;
                }
            };
            backgroundJob.setRule(rule);
            backgroundJob.schedule();
        }
    }

    protected boolean invokeMake(int kind, IMakeBuilderInfo info, IProgressMonitor monitor) {
        boolean isClean;
        block18: {
            isClean = false;
            IProject project = this.getProject();
            this.buildRunnerHelper = new BuildRunnerHelper(project);
            try {
                try {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask(MakeMessages.getString("MakeBuilder.Invoking_Make_Builder") + project.getName(), 300);
                    IPath buildCommand = info.getBuildCommand();
                    if (buildCommand != null) {
                        IConsole console = CCorePlugin.getDefault().getConsole();
                        console.start(project);
                        ICommandLauncher launcher = CommandLauncherManager.getInstance().getCommandLauncher();
                        String[] targets = this.getTargets(kind, info);
                        if (targets.length != 0 && targets[targets.length - 1].equals(info.getCleanBuildTarget())) {
                            isClean = true;
                        }
                        boolean isOnlyClean = isClean && targets.length == 1;
                        String[] args = this.getCommandArguments(info, targets);
                        URI workingDirectoryURI = MakeBuilderUtil.getBuildDirectoryURI(project, info);
                        HashMap<String, String> envMap = this.getEnvironment(launcher, info);
                        String[] envp = BuildRunnerHelper.envMapToEnvp(envMap);
                        String[] errorParsers = info.getErrorParsers();
                        ErrorParserManager epm = new ErrorParserManager(this.getProject(), workingDirectoryURI, (IMarkerGenerator)this, errorParsers);
                        ArrayList<IConsoleParser> parsers = new ArrayList<IConsoleParser>();
                        if (!isOnlyClean) {
                            ICProjectDescription prjDescription = CoreModel.getDefault().getProjectDescription(project);
                            if (prjDescription != null) {
                                ICConfigurationDescription cfgDescription = prjDescription.getActiveConfiguration();
                                MakeBuilder.collectLanguageSettingsConsoleParsers(cfgDescription, (IWorkingDirectoryTracker)epm, parsers);
                            }
                            if (ScannerDiscoveryLegacySupport.isLegacyScannerDiscoveryOn((IProject)project)) {
                                IScannerInfoConsoleParser parserSD = ScannerInfoConsoleParserFactory.getScannerInfoConsoleParser(project, workingDirectoryURI, (IMarkerGenerator)this);
                                parsers.add(parserSD);
                            }
                        }
                        this.buildRunnerHelper.setLaunchParameters(launcher, buildCommand, args, workingDirectoryURI, envp);
                        this.buildRunnerHelper.prepareStreams(epm, parsers, console, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 4));
                        this.buildRunnerHelper.removeOldMarkers((IResource)project, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 4));
                        this.buildRunnerHelper.greeting(kind);
                        int state = this.buildRunnerHelper.build((IProgressMonitor)new SubProgressMonitor(monitor, 100, 4));
                        this.buildRunnerHelper.close();
                        this.buildRunnerHelper.goodbye();
                        if (state != -1) {
                            this.refreshProject(project);
                        }
                        break block18;
                    }
                    String msg = MakeMessages.getFormattedString("MakeBuilder.message.undefined.build.command", project.getName());
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.make.core", msg, (Throwable)new Exception()));
                }
                catch (Exception e) {
                    MakeCorePlugin.log(e);
                    try {
                        this.buildRunnerHelper.close();
                    }
                    catch (IOException e2) {
                        MakeCorePlugin.log(e2);
                    }
                    monitor.done();
                }
            }
            finally {
                try {
                    this.buildRunnerHelper.close();
                }
                catch (IOException e) {
                    MakeCorePlugin.log(e);
                }
                monitor.done();
            }
        }
        return isClean;
    }

    private HashMap<String, String> getEnvironment(ICommandLauncher launcher, IMakeBuilderInfo info) throws CoreException {
        Properties env;
        HashMap<String, String> envMap = new HashMap<String, String>();
        if (info.appendEnvironment() && (env = launcher.getEnvironment()) != null) {
            envMap.putAll(env);
        }
        envMap.putAll(info.getExpandedEnvironment());
        return envMap;
    }

    private String[] getCommandArguments(IMakeBuilderInfo info, String[] targets) {
        String[] args = targets;
        if (info.isDefaultBuildCmd()) {
            if (!info.isStopOnError()) {
                args = new String[targets.length + 1];
                args[0] = "-k";
                System.arraycopy(targets, 0, args, 1, targets.length);
            }
        } else {
            String argsStr = info.getBuildArguments();
            if (argsStr != null && !argsStr.isEmpty()) {
                String[] newArgs = this.makeArray(argsStr);
                args = new String[targets.length + newArgs.length];
                System.arraycopy(newArgs, 0, args, 0, newArgs.length);
                System.arraycopy(targets, 0, args, newArgs.length, targets.length);
            }
        }
        return args;
    }

    protected void refreshProject(IProject project) {
        if (this.buildRunnerHelper != null) {
            this.buildRunnerHelper.refreshProject(null, null);
        }
    }

    public void checkCancel(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected boolean shouldBuild(int kind, IMakeBuilderInfo info) {
        switch (kind) {
            case 9: {
                return info.isAutoBuildEnable();
            }
            case 6: 
            case 10: {
                return info.isFullBuildEnabled() | info.isIncrementalBuildEnabled();
            }
            case 15: {
                return info.isCleanBuildEnabled();
            }
        }
        return true;
    }

    protected String[] getTargets(int kind, IMakeBuilderInfo info) {
        String targets = "";
        switch (kind) {
            case 9: {
                targets = info.getAutoBuildTarget();
                break;
            }
            case 6: 
            case 10: {
                targets = info.getIncrementalBuildTarget();
                break;
            }
            case 15: {
                targets = info.getCleanBuildTarget();
            }
        }
        return this.makeArray(targets);
    }

    private String[] makeArray(String string) {
        return CommandLineUtil.argumentsToArray((String)string);
    }

    private static void collectLanguageSettingsConsoleParsers(ICConfigurationDescription cfgDescription, IWorkingDirectoryTracker cwdTracker, List<IConsoleParser> parsers) {
        if (cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
            List lsProviders = ((ILanguageSettingsProvidersKeeper)cfgDescription).getLanguageSettingProviders();
            for (ILanguageSettingsProvider lsProvider : lsProviders) {
                ILanguageSettingsProvider rawProvider = LanguageSettingsManager.getRawProvider((ILanguageSettingsProvider)lsProvider);
                if (!(rawProvider instanceof ICBuildOutputParser)) continue;
                ICBuildOutputParser consoleParser = (ICBuildOutputParser)rawProvider;
                try {
                    consoleParser.startup(cfgDescription, cwdTracker);
                    parsers.add((IConsoleParser)consoleParser);
                }
                catch (CoreException e) {
                    MakeCorePlugin.log((IStatus)new Status(4, "org.eclipse.cdt.make.core", "Language Settings Provider failed to start up", (Throwable)e));
                }
            }
        }
    }
}

