/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.ILocationService;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;
import org.eclipse.mylyn.internal.commons.repositories.core.InMemoryCredentialsStore;
import org.eclipse.mylyn.internal.commons.repositories.core.LocationService;
import org.eclipse.mylyn.internal.tasks.core.RepositoryPerson;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;

public final class TaskRepository
extends PlatformObject {
    public static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    private static final String USERNAME = ".username";
    private static final String PASSWORD = ".password";
    private static final String SAVE_PASSWORD = ".savePassword";
    private static final String ENABLED = ".enabled";
    private static final String AUTH_REPOSITORY = "org.eclipse.mylyn.tasklist.repositories";
    private IStatus errorStatus = null;
    @Deprecated
    public static final String AUTH_PASSWORD = "org.eclipse.mylyn.tasklist.repositories.password";
    @Deprecated
    public static final String AUTH_USERNAME = "org.eclipse.mylyn.tasklist.repositories.username";
    @Deprecated
    public static final String ANONYMOUS_LOGIN = "org.eclipse.mylyn.tasklist.repositories.anonymous";
    private static final String AUTH_HTTP = "org.eclipse.mylyn.tasklist.repositories.httpauth";
    private static final String AUTH_CERT = "org.eclipse.mylyn.tasklist.repositories.certauth";
    @Deprecated
    public static final String AUTH_HTTP_PASSWORD = "org.eclipse.mylyn.tasklist.repositories.httpauth.password";
    @Deprecated
    public static final String AUTH_HTTP_USERNAME = "org.eclipse.mylyn.tasklist.repositories.httpauth.username";
    public static final String NO_VERSION_SPECIFIED = "unknown";
    private static final String PROPERTY_CONFIG_TIMESTAMP = "org.eclipse.mylyn.tasklist.repositories.configuration.timestamp";
    public static final String PROXY_USEDEFAULT = "org.eclipse.mylyn.tasklist.repositories.proxy.usedefault";
    public static final String PROXY_HOSTNAME = "org.eclipse.mylyn.tasklist.repositories.proxy.hostname";
    public static final String PROXY_PORT = "org.eclipse.mylyn.tasklist.repositories.proxy.port";
    private static final String AUTH_PROXY = "org.eclipse.mylyn.tasklist.repositories.proxy";
    @Deprecated
    public static final String PROXY_USERNAME = "org.eclipse.mylyn.tasklist.repositories.proxy.username";
    @Deprecated
    public static final String PROXY_PASSWORD = "org.eclipse.mylyn.tasklist.repositories.proxy.password";
    public static final String OFFLINE = "org.eclipse.mylyn.tasklist.repositories.offline";
    public static final String CATEGORY_TASKS = "org.eclipse.mylyn.category.tasks";
    public static final String CATEGORY_BUGS = "org.eclipse.mylyn.category.bugs";
    public static final String CATEGORY_BUILD = "org.eclipse.mylyn.category.build";
    public static final String CATEGORY_REVIEW = "org.eclipse.mylyn.category.review";
    private final Set<PropertyChangeListener> propertyChangeListeners = new HashSet<PropertyChangeListener>();
    private static String CREATED_FROM_TEMPLATE = "org.eclipse.mylyn.tasklist.repositories.template";
    private boolean isCachedUserName;
    private String cachedUserName;
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private final Map<String, String> transientProperties = new ConcurrentHashMap<String, String>();
    private boolean isBugRepository = false;
    private volatile transient boolean updating;
    private boolean shouldPersistCredentials = true;
    private final ILocationService service = LocationService.getDefault();

    private static String getKeyPrefix(AuthenticationType type) {
        return switch (type) {
            case AuthenticationType.HTTP -> AUTH_HTTP;
            case AuthenticationType.CERTIFICATE -> AUTH_CERT;
            case AuthenticationType.PROXY -> AUTH_PROXY;
            case AuthenticationType.REPOSITORY -> AUTH_REPOSITORY;
            default -> throw new IllegalArgumentException("Unknown authentication type: " + String.valueOf(type));
        };
    }

    public TaskRepository(String connectorKind, String repositoryUrl) {
        this(connectorKind, repositoryUrl, NO_VERSION_SPECIFIED);
    }

    @Deprecated
    public TaskRepository(String kind, String serverUrl, Map<String, String> properties) {
        this.setProperty("kind", kind);
        this.setProperty("url", serverUrl);
        this.properties.putAll(properties);
        this.setProperty(PROXY_USEDEFAULT, Boolean.toString(true));
    }

    @Deprecated
    public TaskRepository(String kind, String serverUrl, String version) {
        this(kind, serverUrl, version, DEFAULT_CHARACTER_ENCODING, TimeZone.getDefault().getID());
    }

    @Deprecated
    public TaskRepository(String connectorKind, String repositoryUrl, String version, String encoding, String timeZoneId) {
        Assert.isNotNull((Object)connectorKind);
        Assert.isNotNull((Object)repositoryUrl);
        this.setProperty("kind", connectorKind);
        this.setProperty("url", repositoryUrl);
        this.setProperty("version", version);
        this.setProperty("encoding", encoding);
        this.setProperty("timezone", timeZoneId);
        this.setBooleanProperty(PROXY_USEDEFAULT, true);
        this.setBooleanProperty("org.eclipse.mylyn.tasklist.repositories.savePassword", true);
        this.setBooleanProperty("org.eclipse.mylyn.tasklist.repositories.httpauth.savePassword", true);
        this.setBooleanProperty("org.eclipse.mylyn.tasklist.repositories.proxy.savePassword", true);
    }

    private ICredentialsStore getCredentialsStore() {
        if (!this.shouldPersistCredentials()) {
            return InMemoryCredentialsStore.getStore((String)("headless::" + this.getRepositoryUrl()));
        }
        return this.getService().getCredentialsStore(this.getRepositoryUrl());
    }

    private void addAuthInfo(String username, String password, String userProperty, String passwordProperty) {
        ICredentialsStore credentialsStore = this.getCredentialsStore();
        if (userProperty.equals(TaskRepository.getKeyPrefix(AuthenticationType.REPOSITORY) + USERNAME)) {
            this.setProperty(userProperty, username);
        } else {
            String oldUserValue = credentialsStore.get(userProperty, "");
            credentialsStore.put(userProperty, username, false);
            if (!Objects.equals(oldUserValue, username)) {
                this.notifyChangeListeners(userProperty, oldUserValue, username);
            }
        }
        String oldPasswordValue = credentialsStore.get(passwordProperty, "");
        credentialsStore.put(passwordProperty, password, true);
        if (!Objects.equals(oldPasswordValue, password)) {
            this.notifyChangeListeners(passwordProperty, "", "");
        }
    }

    @Deprecated
    public void clearCredentials() {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TaskRepository) {
            TaskRepository repository = (TaskRepository)((Object)object);
            return this.getConnectorKind().equals(repository.getConnectorKind()) && this.getRepositoryUrl().equals(repository.getRepositoryUrl());
        }
        return false;
    }

    public void flushAuthenticationCredentials() {
        this.setProperty(TaskRepository.getKeyPrefix(AuthenticationType.HTTP) + ENABLED, null);
        this.setProperty(TaskRepository.getKeyPrefix(AuthenticationType.PROXY) + ENABLED, null);
        this.setProperty(TaskRepository.getKeyPrefix(AuthenticationType.REPOSITORY) + ENABLED, null);
        this.transientProperties.clear();
        this.isCachedUserName = false;
        this.getCredentialsStore().clear();
        this.setProperty(String.valueOf(AuthenticationType.REPOSITORY) + USERNAME, "");
    }

    private String getAuthInfo(String property) {
        if (property.equals(TaskRepository.getKeyPrefix(AuthenticationType.REPOSITORY) + USERNAME)) {
            return this.getProperty(property);
        }
        return this.getCredentialsStore().get(property, null);
    }

    public boolean shouldPersistCredentials() {
        return this.shouldPersistCredentials;
    }

    public void setShouldPersistCredentials(boolean shouldPersistCredentials) {
        this.shouldPersistCredentials = shouldPersistCredentials;
    }

    public String getCharacterEncoding() {
        String encoding = this.properties.get("encoding");
        return encoding == null || "".equals(encoding) ? DEFAULT_CHARACTER_ENCODING : encoding;
    }

    public Date getConfigurationDate() {
        Date configDate = null;
        String value = this.getProperty(PROPERTY_CONFIG_TIMESTAMP);
        try {
            configDate = new Date(Long.parseLong(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configDate;
    }

    public String getConnectorKind() {
        String kind = this.properties.get("kind");
        if (kind != null) {
            return kind;
        }
        return "<unknown>";
    }

    public AuthenticationCredentials getCredentials(AuthenticationType authType) {
        String key = TaskRepository.getKeyPrefix(authType);
        if (this.getBooleanProperty(key + ENABLED)) {
            String userName = this.getAuthInfo(key + USERNAME);
            String password = this.getBooleanProperty(key + SAVE_PASSWORD) ? this.getAuthInfo(key + PASSWORD) : this.transientProperties.get(key + PASSWORD);
            if (userName == null) {
                userName = "";
            }
            if (password == null) {
                password = "";
            }
            return new AuthenticationCredentials(userName, password);
        }
        return null;
    }

    @Deprecated
    public String getHttpPassword() {
        return this.getPassword(AuthenticationType.HTTP);
    }

    @Deprecated
    public String getHttpUser() {
        return this.getUserName(AuthenticationType.HTTP);
    }

    @Deprecated
    public String getPassword() {
        return this.getPassword(AuthenticationType.REPOSITORY);
    }

    private String getPassword(AuthenticationType authType) {
        AuthenticationCredentials credentials = this.getCredentials(authType);
        return credentials != null ? credentials.getPassword() : null;
    }

    public Map<String, String> getProperties() {
        return new LinkedHashMap<String, String>(this.properties);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    private boolean getBooleanProperty(String name) {
        return Boolean.parseBoolean(this.getProperty(name));
    }

    @Deprecated
    public String getProxyPassword() {
        return this.getPassword(AuthenticationType.PROXY);
    }

    @Deprecated
    public String getProxyUsername() {
        return this.getUserName(AuthenticationType.PROXY);
    }

    public String getRepositoryLabel() {
        String label = this.properties.get("label");
        if (label != null && label.length() > 0) {
            return label;
        }
        return this.getRepositoryUrl();
    }

    public boolean getSavePassword(AuthenticationType authType) {
        String value = this.getProperty(TaskRepository.getKeyPrefix(authType) + SAVE_PASSWORD);
        return value != null && "true".equals(value);
    }

    public String getSynchronizationTimeStamp() {
        return this.properties.get("lastsynctimestamp");
    }

    public String getTimeZoneId() {
        String timeZoneId = this.properties.get("timezone");
        return timeZoneId == null || "".equals(timeZoneId) ? TimeZone.getDefault().getID() : timeZoneId;
    }

    public String getUrl() {
        return this.getRepositoryUrl();
    }

    public String getRepositoryUrl() {
        return this.properties.get("url");
    }

    public String getUserName() {
        if (!this.isCachedUserName) {
            this.cachedUserName = this.getProperty(TaskRepository.getKeyPrefix(AuthenticationType.REPOSITORY) + USERNAME);
            this.isCachedUserName = true;
        }
        return this.cachedUserName;
    }

    private String getUserName(AuthenticationType authType) {
        AuthenticationCredentials credentials = this.getCredentials(authType);
        return credentials != null ? credentials.getUserName() : null;
    }

    public String getVersion() {
        String version = this.properties.get("version");
        return version == null || "".equals(version) ? NO_VERSION_SPECIFIED : version;
    }

    @Deprecated
    public boolean hasCredentials() {
        String username = this.getUserName();
        String password = this.getPassword();
        return username != null && username.length() > 0 && password != null && password.length() > 0;
    }

    public int hashCode() {
        return this.getConnectorKind().hashCode();
    }

    public boolean hasProperty(String name) {
        String value = this.getProperty(name);
        return value != null && value.trim().length() > 0;
    }

    @Deprecated
    public boolean isAnonymous() {
        return this.getProperty(ANONYMOUS_LOGIN) == null || "true".equals(this.getProperty(ANONYMOUS_LOGIN));
    }

    public boolean isBugRepository() {
        return this.isBugRepository;
    }

    public boolean isDefaultProxyEnabled() {
        return "true".equals(this.getProperty(PROXY_USEDEFAULT));
    }

    public boolean isOffline() {
        return this.getProperty(OFFLINE) != null && "true".equals(this.getProperty(OFFLINE));
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    @Deprecated
    public void setAuthenticationCredentials(String username, String password) {
        this.setCredentials(AuthenticationType.REPOSITORY, username, password);
    }

    public void setBugRepository(boolean isBugRepository) {
        this.isBugRepository = isBugRepository;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.properties.put("encoding", characterEncoding == null ? DEFAULT_CHARACTER_ENCODING : characterEncoding);
    }

    public void setConfigurationDate(Date date) {
        this.setProperty(PROPERTY_CONFIG_TIMESTAMP, String.valueOf(date.getTime()));
    }

    public void setCredentials(AuthenticationType authType, AuthenticationCredentials credentials, boolean savePassword) {
        String key = TaskRepository.getKeyPrefix(authType);
        this.setBooleanProperty(key + SAVE_PASSWORD, savePassword);
        if (credentials == null) {
            this.setBooleanProperty(key + ENABLED, false);
            this.transientProperties.remove(key + PASSWORD);
            this.addAuthInfo(null, null, key + USERNAME, key + PASSWORD);
        } else {
            this.setBooleanProperty(key + ENABLED, true);
            if (savePassword) {
                this.addAuthInfo(credentials.getUserName(), credentials.getPassword(), key + USERNAME, key + PASSWORD);
                this.transientProperties.remove(key + PASSWORD);
            } else {
                this.addAuthInfo(credentials.getUserName(), null, key + USERNAME, key + PASSWORD);
                this.transientProperties.put(key + PASSWORD, credentials.getPassword());
            }
        }
        if (authType == AuthenticationType.REPOSITORY) {
            if (credentials == null) {
                this.cachedUserName = null;
                this.isCachedUserName = false;
            } else {
                this.cachedUserName = credentials.getUserName();
                this.isCachedUserName = true;
            }
        }
    }

    private void setCredentials(AuthenticationType type, String username, String password) {
        if (username == null) {
            this.setCredentials(type, null, true);
        } else {
            this.setCredentials(type, new AuthenticationCredentials(username, password), true);
        }
    }

    @Deprecated
    public void setHttpAuthenticationCredentials(String username, String password) {
        this.setCredentials(AuthenticationType.HTTP, username, password);
    }

    public void setOffline(boolean offline) {
        this.setBooleanProperty(OFFLINE, offline);
    }

    @Deprecated
    public void setProxyAuthenticationCredentials(String username, String password) {
        this.setCredentials(AuthenticationType.PROXY, username, password);
    }

    public void setRepositoryLabel(String repositoryLabel) {
        this.setProperty("label", repositoryLabel);
    }

    public void setSynchronizationTimeStamp(String syncTime) {
        this.setProperty("lastsynctimestamp", syncTime);
    }

    public void setProperty(String key, String newValue) {
        Assert.isLegal((!key.matches(".*\\s.*") ? 1 : 0) != 0);
        String oldValue = this.properties.get(key);
        if (oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null) {
            this.properties.put(key.intern(), newValue != null ? newValue.intern() : null);
            this.notifyChangeListeners(key, oldValue, newValue);
        }
    }

    private void setBooleanProperty(String key, boolean newValue) {
        this.setProperty(key, Boolean.toString(newValue));
    }

    private void notifyChangeListeners(String key, String old, String value) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, key, old, value);
        for (PropertyChangeListener listener : this.propertyChangeListeners) {
            listener.propertyChange(event);
        }
    }

    public void setTimeZoneId(String timeZoneId) {
        this.setProperty("timezone", timeZoneId == null ? TimeZone.getDefault().getID() : timeZoneId);
    }

    @Deprecated
    public void setUrl(String newUrl) {
        this.setRepositoryUrl(newUrl);
    }

    public void setRepositoryUrl(String repositoryUrl) {
        Assert.isNotNull((Object)repositoryUrl);
        this.properties.put("url", repositoryUrl.intern());
    }

    public void setVersion(String ver) {
        this.properties.put("version", ver == null ? NO_VERSION_SPECIFIED : ver);
    }

    public String toString() {
        return this.getRepositoryUrl();
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public void setUpdating(boolean updating) {
        this.updating = updating;
    }

    public IRepositoryPerson createPerson(String personId) {
        return new RepositoryPerson(this, personId);
    }

    public IStatus getStatus() {
        return this.errorStatus;
    }

    public void setStatus(IStatus errorStatus) {
        this.errorStatus = errorStatus;
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public void removeChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    public void setDefaultProxyEnabled(boolean useDefaultProxy) {
        this.setBooleanProperty(PROXY_USEDEFAULT, useDefaultProxy);
    }

    public void setCreatedFromTemplate(boolean value) {
        this.setBooleanProperty(CREATED_FROM_TEMPLATE, value);
    }

    public boolean isCreatedFromTemplate() {
        return "true".equals(this.getProperty(CREATED_FROM_TEMPLATE));
    }

    public String getCategory() {
        return this.getProperty("category");
    }

    public void setCategory(String category) {
        this.setProperty("category", category);
    }

    private ILocationService getService() {
        return this.service;
    }
}

