/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.callhierarchy.CHMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.extensions.ICallHierarchyProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class CHProviderManager {
    private final String CALL_HIERARCHY_PROVIDERS = "org.eclipse.cdt.ui.callHierarchyProviders";
    private final Object ELEMENT_PROVIDER = "provider";
    private final String ATTRIBUTE_CLASS = "class";
    private List<ICallHierarchyProvider> callHierarchyProviders;
    public static CHProviderManager INSTANCE = new CHProviderManager();

    private CHProviderManager() {
    }

    public List<ICallHierarchyProvider> getCallHierarchyProviders() {
        if (this.callHierarchyProviders == null) {
            this.callHierarchyProviders = new ArrayList<ICallHierarchyProvider>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint indexProviderPoint = registry.getExtensionPoint("org.eclipse.cdt.ui.callHierarchyProviders");
            IExtension[] iExtensionArray = indexProviderPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                try {
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if (this.ELEMENT_PROVIDER.equals(element.getName())) {
                            Object provider = element.createExecutableExtension("class");
                            if (provider instanceof ICallHierarchyProvider) {
                                this.callHierarchyProviders.add((ICallHierarchyProvider)provider);
                            } else {
                                CUIPlugin.logError(NLS.bind((String)CHMessages.CHProviderManager_InvalidCallHierarchyProvider, (Object)extension.getContributor().getName()));
                            }
                        }
                        ++n4;
                    }
                }
                catch (CoreException e) {
                    CUIPlugin.log(e);
                }
                ++n2;
            }
        }
        return this.callHierarchyProviders;
    }
}

