/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.FunctionInfo;
import org.eclipse.cdt.internal.core.model.SourceManipulation;
import org.eclipse.cdt.internal.core.model.Util;

public class FunctionDeclaration
extends SourceManipulation
implements IFunctionDeclaration {
    protected String[] fParameterTypes = fgEmptyStrings;
    protected String returnType;

    public FunctionDeclaration(ICElement parent, String name) {
        this(parent, name, 73);
    }

    public FunctionDeclaration(ICElement parent, String name, int type) {
        super(parent, name, type);
    }

    @Override
    public String getReturnType() {
        if (this.returnType != null) {
            return this.returnType;
        }
        return "";
    }

    public void setReturnType(String type) {
        this.returnType = type;
    }

    @Override
    public int getNumberOfParameters() {
        return this.fParameterTypes == null ? 0 : this.fParameterTypes.length;
    }

    @Override
    public String[] getParameterTypes() {
        return this.fParameterTypes;
    }

    public void setParameterTypes(String[] parameterTypes) {
        this.fParameterTypes = parameterTypes;
    }

    @Override
    public String getSignature() throws CModelException {
        return FunctionDeclaration.getSignature(this);
    }

    public static String getSignature(IFunctionDeclaration func) {
        StringBuilder sig = new StringBuilder(func.getElementName());
        sig.append(FunctionDeclaration.getParameterClause(func.getParameterTypes()));
        try {
            if (func.isConst()) {
                sig.append(" const");
            }
            if (func.isVolatile()) {
                sig.append(" volatile");
            }
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
        return sig.toString();
    }

    public String getParameterClause() {
        return FunctionDeclaration.getParameterClause(this.getParameterTypes());
    }

    public static String getParameterClause(String[] paramTypes) {
        StringBuilder sig = new StringBuilder();
        if (paramTypes.length > 0) {
            sig.append("(");
            int i = 0;
            sig.append(paramTypes[i++]);
            while (i < paramTypes.length) {
                sig.append(", ");
                sig.append(paramTypes[i++]);
            }
            sig.append(")");
        } else {
            sig.append("()");
        }
        return sig.toString();
    }

    @Override
    public String getParameterInitializer(int pos) {
        return "";
    }

    @Override
    public String[] getExceptions() {
        return new String[0];
    }

    @Override
    protected CElementInfo createElementInfo() {
        return new FunctionInfo(this);
    }

    protected FunctionInfo getFunctionInfo() throws CModelException {
        return (FunctionInfo)this.getElementInfo();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof IFunctionDeclaration) {
            return FunctionDeclaration.equals(this, (IFunctionDeclaration)other);
        }
        return false;
    }

    public static boolean equals(IFunctionDeclaration lhs, IFunctionDeclaration rhs) {
        return CElement.equals(lhs, rhs) && Util.equalArraysOrNull(lhs.getParameterTypes(), rhs.getParameterTypes()) && lhs.getReturnType().equals(rhs.getReturnType());
    }

    @Override
    public boolean isConst() throws CModelException {
        return this.getFunctionInfo().isConst();
    }

    public void setConst(boolean isConst) throws CModelException {
        this.getFunctionInfo().setConst(isConst);
    }

    @Override
    public boolean isStatic() throws CModelException {
        return this.getFunctionInfo().isStatic();
    }

    @Override
    public boolean isVolatile() throws CModelException {
        return this.getFunctionInfo().isVolatile();
    }

    public void setStatic(boolean isStatic) throws CModelException {
        this.getFunctionInfo().setStatic(isStatic);
    }

    public void setVolatile(boolean isVolatile) throws CModelException {
        this.getFunctionInfo().setVolatile(isVolatile);
    }

    @Override
    public void getHandleMemento(StringBuilder buff) {
        super.getHandleMemento(buff);
        int i = 0;
        while (i < this.fParameterTypes.length) {
            buff.append('(');
            FunctionDeclaration.escapeMementoName(buff, this.fParameterTypes[i]);
            ++i;
        }
    }
}

