/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.dom;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.e4.ui.css.core.dom.ArrayNodeList;
import org.eclipse.e4.ui.css.core.dom.ChildVisibilityAwareElement;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.CompositeElement;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTColorHelper;
import org.eclipse.e4.ui.internal.css.swt.ICTabRendering;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CTabFolderElement
extends CompositeElement
implements ChildVisibilityAwareElement {
    private static final String BACKGROUND_SET_BY_TAB_RENDERER = "bgSetByTabRenderer";
    private final SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            CTabFolderElement.applyStyles(CTabFolderElement.this.getWidget(), true);
        }
    };

    public CTabFolderElement(CTabFolder tabFolder, CSSEngine engine) {
        super((Composite)tabFolder, engine);
    }

    @Override
    public void initialize() {
        super.initialize();
        ((CTabFolder)this.getControl()).addSelectionListener(this.selectionListener);
    }

    @Override
    public void dispose() {
        CTabFolder ctf = (CTabFolder)this.getControl();
        if (ctf != null && !ctf.isDisposed()) {
            ctf.removeSelectionListener(this.selectionListener);
        }
        super.dispose();
    }

    @Override
    protected void computeStaticPseudoInstances() {
        super.computeStaticPseudoInstances();
        super.addStaticPseudoInstance("selected");
    }

    @Override
    public Node item(int index) {
        Widget widget = this.getWidget();
        CTabFolder folder = (CTabFolder)widget;
        int length = folder.getChildren().length;
        if (index >= length) {
            CTabItem w = folder.getItem(index - length);
            return this.getElement(w);
        }
        Control w = folder.getChildren()[index];
        return this.getElement(w);
    }

    @Override
    public int getLength() {
        Widget widget = this.getWidget();
        int childCount = 0;
        if (widget instanceof Composite) {
            childCount = ((Composite)widget).getChildren().length;
            if (widget instanceof CTabFolder) {
                childCount += ((CTabFolder)widget).getItemCount();
            }
        }
        return childCount;
    }

    @Override
    public void reset() {
        CTabFolder folder = (CTabFolder)this.getWidget();
        folder.setSelectionBackground(null);
        folder.setSelectionForeground(null);
        folder.setSelectionBackground(null);
        folder.setBackground(null, null);
        this.resetChildrenBackground((Composite)folder);
        if (folder.getRenderer() instanceof ICTabRendering) {
            ICTabRendering renderer = (ICTabRendering)folder.getRenderer();
            folder.setRenderer(null);
            renderer.setSelectedTabFill(null);
            renderer.setTabOutline(null);
            renderer.setInnerKeyline(null);
            renderer.setOuterKeyline(null);
        }
        super.reset();
    }

    public NodeList getVisibleChildNodes() {
        CTabItem item;
        CTabFolder folder = (CTabFolder)this.getWidget();
        ArrayList<Control> visible = new ArrayList<Control>();
        if (folder.getTopRight() != null) {
            visible.add(folder.getTopRight());
        }
        Collections.addAll(visible, folder.getItems());
        int selected = folder.getSelectionIndex();
        if (selected >= 0 && !(item = folder.getItem(selected)).isDisposed() && item.getControl() != null) {
            visible.add(item.getControl());
        }
        return new ArrayNodeList(visible, this.engine);
    }

    private void resetChildrenBackground(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            this.resetChildBackground(control);
            if (control instanceof Composite) {
                this.resetChildrenBackground((Composite)control);
            }
            ++n2;
        }
    }

    private void resetChildBackground(Control control) {
        Color backgroundSetByRenderer = (Color)control.getData(BACKGROUND_SET_BY_TAB_RENDERER);
        if (backgroundSetByRenderer != null) {
            if (control.getBackground() == backgroundSetByRenderer) {
                control.setBackground(null);
            }
            control.setData(BACKGROUND_SET_BY_TAB_RENDERER, null);
        }
    }

    public static void setBackgroundOverriddenDuringRenderering(Composite composite, Color background) {
        CSSSWTColorHelper.setBackground((Control)composite, background);
        composite.setData(BACKGROUND_SET_BY_TAB_RENDERER, (Object)background);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!CompositeElement.hasBackgroundOverriddenByCSS(control)) {
                CSSSWTColorHelper.setBackground(control, background);
                control.setData(BACKGROUND_SET_BY_TAB_RENDERER, (Object)background);
            }
            ++n2;
        }
    }
}

