/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.nekohtml.sax;

public class XMLChar {
    public static boolean isValid(int c) {
        return c == 9 || c == 10 || c == 13 || c >= 32 && c <= 55295 || c >= 57344 && c <= 65533 || c >= 65536 && c <= 0x10FFFF;
    }

    public static boolean isInvalid(int c) {
        return !XMLChar.isValid(c);
    }

    public static boolean isNameStart(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 58 || c == 95 || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 767 || c >= 880 && c <= 893 || c >= 895 && c <= 8191 || c >= 8204 && c <= 8205 || c >= 8304 && c <= 8591 || c >= 11264 && c <= 12271 || c >= 12289 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65533 || c >= 65536 && c <= 983039;
    }

    public static boolean isName(int c) {
        return XMLChar.isNameStart(c) || c >= 48 && c <= 57 || c == 45 || c == 46 || c == 183 || c >= 768 && c <= 879 || c >= 8255 && c <= 8256;
    }

    public static boolean isValidName(String name) {
        int c;
        if (name == null || name.length() == 0) {
            return false;
        }
        int first = name.codePointAt(0);
        if (!XMLChar.isNameStart(first)) {
            return false;
        }
        for (int i = Character.charCount(first); i < name.length(); i += Character.charCount(c)) {
            c = name.codePointAt(i);
            if (XMLChar.isName(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSpace(int c) {
        return c == 32 || c == 10 || c == 9 || c == 13;
    }
}

