/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.nekohtml.sax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.codelibs.nekohtml.sax.HTMLSAXScanner;
import org.codelibs.nekohtml.sax.HTMLTagBalancerFilter;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class HTMLSAXConfiguration
implements XMLReader {
    public static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    public static final String AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    public static final String REPORT_ERRORS = "http://cyberneko.org/html/features/report-errors";
    public static final String SIMPLE_ERROR_FORMAT = "http://cyberneko.org/html/features/report-errors/simple-format";
    public static final String BALANCE_TAGS = "http://cyberneko.org/html/features/balance-tags";
    public static final String NAMES_ELEMS = "http://cyberneko.org/html/features/scanner/normalize-elements";
    public static final String NAMES_ATTRS = "http://cyberneko.org/html/features/scanner/normalize-attrs";
    public static final String HTML5_MODE = "http://cyberneko.org/html/features/html5-mode";
    public static final String FILTERS = "http://cyberneko.org/html/properties/filters";
    public static final String ERROR_REPORTER = "http://cyberneko.org/html/properties/error-reporter";
    protected final Map<String, Boolean> fFeatures = new HashMap<String, Boolean>();
    protected final Map<String, Object> fProperties = new HashMap<String, Object>();
    protected ContentHandler fContentHandler;
    protected DTDHandler fDTDHandler;
    protected EntityResolver fEntityResolver;
    protected ErrorHandler fErrorHandler;
    protected LexicalHandler fLexicalHandler;
    protected Locale fLocale;
    protected final List<XMLReader> fPipeline = new ArrayList<XMLReader>();
    protected HTMLSAXScanner fScanner;
    protected HTMLTagBalancerFilter fTagBalancer;
    protected XMLReader fNamespaceBinder;

    public HTMLSAXConfiguration() {
        this.fFeatures.put(NAMESPACES, false);
        this.fFeatures.put(AUGMENTATIONS, false);
        this.fFeatures.put(REPORT_ERRORS, false);
        this.fFeatures.put(SIMPLE_ERROR_FORMAT, false);
        this.fFeatures.put(BALANCE_TAGS, true);
        this.fFeatures.put(HTML5_MODE, false);
        this.fProperties.put(NAMES_ELEMS, "upper");
        this.fProperties.put(NAMES_ATTRS, "lower");
        this.buildPipeline();
    }

    protected void buildPipeline() {
        XMLReader lastFilter;
        this.fPipeline.clear();
        if (this.fScanner == null) {
            this.fScanner = this.createScanner();
        }
        this.fPipeline.add(this.fScanner);
        if (Boolean.TRUE.equals(this.fFeatures.get(BALANCE_TAGS))) {
            if (this.fTagBalancer == null) {
                this.fTagBalancer = new HTMLTagBalancerFilter();
            }
            this.fPipeline.add(this.fTagBalancer);
            this.fScanner.setContentHandler(this.fTagBalancer);
        }
        if (this.fContentHandler != null && (lastFilter = this.getLastFilter()) != null) {
            lastFilter.setContentHandler(this.fContentHandler);
        }
    }

    protected HTMLSAXScanner createScanner() {
        return new HTMLSAXScanner();
    }

    protected XMLReader getLastFilter() {
        return this.fPipeline.isEmpty() ? null : this.fPipeline.get(this.fPipeline.size() - 1);
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.fContentHandler = handler;
        XMLReader lastFilter = this.getLastFilter();
        if (lastFilter != null) {
            lastFilter.setContentHandler(handler);
        }
        if (this.fScanner != null && this.fTagBalancer != null && Boolean.TRUE.equals(this.fFeatures.get(BALANCE_TAGS))) {
            this.fScanner.setContentHandler(this.fTagBalancer);
            this.fTagBalancer.setContentHandler(handler);
        } else if (this.fScanner != null) {
            this.fScanner.setContentHandler(handler);
        }
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.fContentHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.fDTDHandler = handler;
        XMLReader lastFilter = this.getLastFilter();
        if (lastFilter != null) {
            lastFilter.setDTDHandler(handler);
        }
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.fEntityResolver = resolver;
        for (XMLReader filter : this.fPipeline) {
            filter.setEntityResolver(resolver);
        }
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.fErrorHandler = handler;
        for (XMLReader filter : this.fPipeline) {
            filter.setErrorHandler(handler);
        }
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.fLexicalHandler = handler;
        for (XMLReader filter : this.fPipeline) {
            if (filter instanceof HTMLTagBalancerFilter) {
                ((HTMLTagBalancerFilter)filter).setLexicalHandler(handler);
                continue;
            }
            if (!(filter instanceof HTMLSAXScanner)) continue;
            ((HTMLSAXScanner)filter).setLexicalHandler(handler);
        }
    }

    public LexicalHandler getLexicalHandler() {
        return this.fLexicalHandler;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        if (this.fScanner == null) {
            throw new SAXException("Parser not configured");
        }
        if (this.fContentHandler == null) {
            this.setContentHandler(new DefaultHandler());
        }
        this.fScanner.parse(input);
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        Boolean value;
        if (this.fFeatures.containsKey(name) && (value = this.fFeatures.get(name)) instanceof Boolean) {
            return value;
        }
        throw new SAXNotRecognizedException("Feature not recognized: " + name);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fFeatures.put(name, value);
        if (BALANCE_TAGS.equals(name)) {
            this.buildPipeline();
            if (this.fContentHandler != null) {
                this.setContentHandler(this.fContentHandler);
            }
        }
        for (XMLReader filter : this.fPipeline) {
            try {
                filter.setFeature(name, value);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {}
        }
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            return this.fLexicalHandler;
        }
        if (this.fProperties.containsKey(name)) {
            return this.fProperties.get(name);
        }
        throw new SAXNotRecognizedException("Property not recognized: " + name);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            this.setLexicalHandler((LexicalHandler)value);
            return;
        }
        this.fProperties.put(name, value);
        if (FILTERS.equals(name)) {
            this.buildPipeline();
            if (this.fContentHandler != null) {
                this.setContentHandler(this.fContentHandler);
            }
        }
        for (XMLReader filter : this.fPipeline) {
            try {
                filter.setProperty(name, value);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {}
        }
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }
}

