/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.dialogs;

import org.eclipse.datatools.connectivity.internal.ui.dialogs.AbstractInvertableTableSorter;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.InvertableSorter;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TreeColumn;

public class TreeSortSelectionListener
implements SelectionListener {
    private final TreeViewer viewer;
    private final TreeColumn column;
    private final InvertableSorter sorter;
    private final boolean keepDirection;
    private InvertableSorter currentSorter;

    public TreeSortSelectionListener(TreeViewer viewer, TreeColumn column, AbstractInvertableTableSorter sorter, int defaultDirection, boolean keepDirection) {
        this.viewer = viewer;
        this.column = column;
        this.keepDirection = keepDirection;
        this.currentSorter = this.sorter = defaultDirection == 128 ? sorter : sorter.getInverseSorter();
        this.column.addSelectionListener((SelectionListener)this);
    }

    public void chooseColumnForSorting() {
        this.viewer.getTree().setSortColumn(this.column);
        this.viewer.getTree().setSortDirection(this.currentSorter.getSortDirection());
        this.viewer.setSorter((ViewerSorter)this.currentSorter);
    }

    public void widgetSelected(SelectionEvent e) {
        InvertableSorter newSorter = this.viewer.getTree().getSortColumn() == this.column ? ((InvertableSorter)this.viewer.getSorter()).getInverseSorter() : (this.keepDirection ? this.currentSorter : this.sorter);
        this.currentSorter = newSorter;
        this.chooseColumnForSorting();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public TreeColumn getColumn() {
        return this.column;
    }
}

