/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.msft.internal.sqlserver.connection;

import java.sql.Connection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.IDatabaseRecognizer;

public class SQLServerDatabaseRecognizer
implements IDatabaseRecognizer {
    public static final String PRODUCT = "SQL Server";
    public static final String VERSION2000 = "2000";
    public static final String VERSION2005 = "2005";
    public static final String VERSION2008 = "2008";
    public static final String VERSION2012 = "2012";
    public static final String VERSION2014 = "2014";
    public static final String VERSION2016 = "2016";

    public DatabaseDefinition recognize(Connection connection) {
        String version;
        block11: {
            block10: {
                try {
                    String product = connection.getMetaData().getDatabaseProductName();
                    if (product.indexOf(PRODUCT) >= 0) break block10;
                    return null;
                }
                catch (Exception exception) {}
            }
            version = connection.getMetaData().getDatabaseProductVersion();
            if (version != null) break block11;
            return null;
        }
        Pattern p = Pattern.compile("[\\d]+[.][\\d]+[.][\\d]+");
        Matcher m = p.matcher(version);
        m.find();
        version = m.group();
        if (version.startsWith("8.")) {
            return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, VERSION2000);
        }
        if (version.startsWith("9.")) {
            return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, VERSION2005);
        }
        if (version.startsWith("10.")) {
            return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, VERSION2008);
        }
        if (version.startsWith("11.")) {
            return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, VERSION2012);
        }
        if (version.startsWith("12.")) {
            return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, VERSION2014);
        }
        if (version.startsWith("13.")) {
            return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, VERSION2016);
        }
        return null;
    }
}

