/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp;

import java.net.URI;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;

public final class ExistingResource
implements Function<URI, Optional<IResource>> {
    private final IWorkspace workspace;

    public ExistingResource(IWorkspace workspace) {
        this.workspace = Objects.requireNonNull(workspace);
    }

    @Override
    public Optional<IResource> apply(URI uri) {
        return this.forContainer(uri).or(() -> this.forFile(uri));
    }

    private Optional<IResource> forContainer(URI uri) {
        return Arrays.stream(this.workspace.getRoot().findContainersForLocationURI(uri)).map(IResource.class::cast).filter(c -> c.exists()).findFirst();
    }

    private Optional<IResource> forFile(URI uri) {
        return Arrays.stream(this.workspace.getRoot().findFilesForLocationURI(uri)).map(IResource.class::cast).filter(c -> c.exists()).findFirst();
    }
}

