/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.manipulation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.internal.core.refactoring.Resources;

public class RefactoringChecks {
    public static RefactoringStatus validateModifiesFiles(IFile[] filesToModify, Object context) {
        RefactoringStatus result = new RefactoringStatus();
        IStatus status = Resources.checkInSync((IResource[])filesToModify);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
        }
        if (!(status = Resources.makeCommittable((IResource[])filesToModify, (Object)context)).isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
            if (!result.hasFatalError()) {
                result.addFatalError(RefactoringCoreMessages.Checks_validateEdit);
            }
        }
        return result;
    }

    public static RefactoringStatus checkIfCuBroken(IMember member) throws ModelException {
        ISourceModule cu = (ISourceModule)DLTKCore.create((IResource)member.getSourceModule().getResource());
        if (cu == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_cu_not_created);
        }
        if (!cu.isStructureKnown()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_cu_not_parsed);
        }
        return new RefactoringStatus();
    }

    public static void addModifiedFilesToChecker(IFile[] filesToModify, CheckConditionsContext context) {
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        int i = 0;
        while (i < filesToModify.length) {
            deltaFactory.change(filesToModify[i]);
            ++i;
        }
    }
}

