/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.utils.IntList;

public class ArrayInitializer
extends Expression {
    private final List<Expression> items;
    private final IntList commas;
    private int LB = -1;
    private int RB = -1;

    public ArrayInitializer(JSNode parent, int itemCount) {
        super(parent);
        this.items = new ArrayList<Expression>(itemCount);
        this.commas = new IntList(itemCount > 0 ? itemCount - 1 : 0);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.items != null) {
                for (ASTNode aSTNode : this.items) {
                    aSTNode.traverse(visitor);
                }
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public List<Expression> getItems() {
        return this.items;
    }

    public IntList getCommas() {
        return this.commas;
    }

    public int getLB() {
        return this.LB;
    }

    public void setLB(int pos) {
        this.LB = pos;
    }

    public int getRB() {
        return this.RB;
    }

    public void setRB(int pos) {
        this.RB = pos;
    }

    @Override
    public String toSourceString(String indentionString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.LB >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.RB > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.items.size() == 0 || this.commas.size() == this.items.size() - 1 ? 1 : 0) != 0);
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        int i = 0;
        while (i < this.items.size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(ArrayInitializer.toSourceString(this.items.get(i), indentionString));
            ++i;
        }
        buffer.append(']');
        return buffer.toString();
    }
}

