/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.breakpoints.IDbgpBreakpoint;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.IDbgpTerminationListener;
import org.eclipse.dltk.debug.core.DLTKDebugLaunchConstants;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.IHotCodeReplaceListener;
import org.eclipse.dltk.debug.core.ISmartStepEvaluator;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationEngine;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.internal.debug.core.eval.ScriptEvaluationEngine;
import org.eclipse.dltk.internal.debug.core.model.DebugEventHelper;
import org.eclipse.dltk.internal.debug.core.model.HotCodeReplaceManager;
import org.eclipse.dltk.internal.debug.core.model.IScriptStreamProxy;
import org.eclipse.dltk.internal.debug.core.model.IScriptThreadManager;
import org.eclipse.dltk.internal.debug.core.model.IThreadManagement;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugElement;
import org.eclipse.dltk.internal.debug.core.model.ScriptStack;
import org.eclipse.dltk.internal.debug.core.model.ScriptThreadStateManager;
import org.eclipse.dltk.internal.debug.core.model.SmartStepEvaluatorManager;
import org.eclipse.dltk.internal.debug.core.model.operations.DbgpDebugger;

public class ScriptThread
extends ScriptDebugElement
implements IScriptThread,
IThreadManagement,
IDbgpTerminationListener,
ScriptThreadStateManager.IStateChangeHandler,
IHotCodeReplaceListener {
    private ScriptThreadStateManager stateManager;
    private final IScriptThreadManager manager;
    private final ScriptStack stack;
    private final IDbgpSession session;
    private final IScriptDebugTarget target;
    private IScriptEvaluationEngine evalEngine;
    private int currentStackLevel;
    private boolean terminated = false;
    private int propertyPageSize = 32;

    public void handleSuspend(int detail) {
        DebugEventHelper.fireExtendedEvent(this, 3);
        this.stack.update(true);
        if (this.handleSmartStepInto()) {
            return;
        }
        DebugEventHelper.fireChangeEvent(this);
        DebugEventHelper.fireSuspendEvent(this, detail);
    }

    private boolean handleSmartStepInto() {
        block4: {
            if (this.stateManager.isStepInto() && this.getScriptDebugTarget().isUseStepFilters() && this.stack.getFrames().length > this.currentStackLevel) {
                ISmartStepEvaluator evaluator;
                this.stateManager.setStepInto(false);
                IScriptDebugTarget target = this.getScriptDebugTarget();
                String[] filters = target.getFilters();
                IDLTKLanguageToolkit toolkit = this.getScriptDebugTarget().getLanguageToolkit();
                if (toolkit != null && (evaluator = SmartStepEvaluatorManager.getEvaluator(toolkit.getNatureId())) != null && evaluator.isFiltered(filters, this)) {
                    try {
                        this.stepReturn();
                        return true;
                    }
                    catch (DebugException e) {
                        if (!DLTKCore.DEBUG) break block4;
                        e.printStackTrace();
                    }
                }
            }
        }
        return false;
    }

    public void handleResume(int detail) {
        DebugEventHelper.fireExtendedEvent(this, 4);
        DebugEventHelper.fireResumeEvent(this, detail);
        DebugEventHelper.fireChangeEvent(this);
    }

    public void handleTermination(DbgpException e) {
        block7: {
            if (e != null) {
                DLTKDebugPlugin.log(e);
                IScriptStreamProxy proxy = this.getScriptDebugTarget().getStreamProxy();
                if (proxy != null) {
                    proxy.writeStderr("\n" + e.getMessage() + "\n");
                    this.stack.update(false);
                    IScriptStackFrame[] frames = this.stack.getFrames();
                    proxy.writeStderr("\nStack trace:\n");
                    try {
                        int i = 0;
                        while (i < frames.length) {
                            IScriptStackFrame frame = frames[i];
                            String line = "\t#" + frame.getLevel() + " file:" + frame.getSourceURI().getPath() + " [" + frame.getLineNumber() + "]\n";
                            proxy.writeStderr(line);
                            ++i;
                        }
                    }
                    catch (DebugException debugException) {
                        if (!DLTKCore.DEBUG) break block7;
                        e.printStackTrace();
                    }
                }
            }
        }
        this.session.requestTermination();
        try {
            this.session.waitTerminated();
        }
        catch (InterruptedException ee) {
            ee.printStackTrace();
        }
        this.manager.terminateThread(this);
    }

    public ScriptThread(IScriptDebugTarget target, IDbgpSession session, IScriptThreadManager manager) throws DbgpException, CoreException {
        this.target = target;
        this.manager = manager;
        this.session = session;
        this.session.addTerminationListener(this);
        this.stateManager = new ScriptThreadStateManager(this);
        this.stack = new ScriptStack(this);
    }

    public void initialize(IProgressMonitor monitor) throws DbgpException {
        monitor.beginTask("", 10);
        try {
            DbgpDebugger engine = this.stateManager.getEngine();
            if (DLTKCore.DEBUG) {
                DbgpDebugger.printEngineInfo(engine);
            }
            engine.setMaxChildren(this.propertyPageSize);
            engine.setMaxDepth(2);
            engine.setMaxData(8192);
            monitor.worked(2);
            this.manager.configureThread(engine, this);
            monitor.worked(6);
            boolean isDebugConsole = DLTKDebugLaunchConstants.isDebugConsole(this.target.getLaunch());
            if (isDebugConsole && engine.isFeatureSupported("stdin")) {
                engine.redirectStdin();
            }
            engine.setNotifyOk(true);
            if (isDebugConsole) {
                engine.redirectStdout();
                engine.redirectStderr();
            }
            monitor.worked(2);
            HotCodeReplaceManager.getDefault().addHotCodeReplaceListener(this);
        }
        finally {
            monitor.done();
        }
    }

    public boolean hasStackFrames() {
        return this.isSuspended() && !this.isTerminated() && this.stack.hasFrames();
    }

    boolean isStackInitialized() {
        return this.stack.isInitialized();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (!this.isSuspended()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
            if (!this.isSuspended()) {
                return ScriptStack.NO_STACK_FRAMES;
            }
        }
        return this.session.getDebugOptions().filterStackLevels(this.stack.getFrames());
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() {
        return this.stack.getTopFrame();
    }

    public String getName() {
        return this.session.getInfo().getThreadId();
    }

    public IBreakpoint[] getBreakpoints() {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelIdentifier());
    }

    public int getModificationsCount() {
        return this.stateManager.getModificationsCount();
    }

    public boolean isSuspended() {
        return this.stateManager.isSuspended();
    }

    public boolean canSuspend() {
        return this.stateManager.canSuspend();
    }

    public void suspend() throws DebugException {
        this.stateManager.suspend();
    }

    public boolean canResume() {
        return this.stateManager.canResume();
    }

    public void resume() throws DebugException {
        this.stateManager.resume();
    }

    public void initialStepInto() {
        this.stateManager.setSuspended(false, 32);
        this.stateManager.getEngine().stepInto();
    }

    public boolean isStepping() {
        return this.stateManager.isStepping();
    }

    boolean isStepInto() {
        return this.stateManager.isStepInto();
    }

    public boolean canStepInto() {
        return this.stateManager.canStepInto();
    }

    public void stepInto() throws DebugException {
        this.currentStackLevel = this.stack.getFrames().length;
        this.stateManager.stepInto();
    }

    public boolean canStepOver() {
        return this.stateManager.canStepOver();
    }

    public void stepOver() throws DebugException {
        this.stateManager.stepOver();
    }

    public boolean canStepReturn() {
        return this.stateManager.canStepReturn();
    }

    public void stepReturn() throws DebugException {
        this.stateManager.stepReturn();
    }

    public boolean isTerminated() {
        return this.terminated || this.stateManager.isTerminated();
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public void terminate() throws DebugException {
        this.target.terminate();
    }

    public void sendTerminationRequest() throws DebugException {
        this.stateManager.terminate();
    }

    public IDbgpSession getDbgpSession() {
        return this.session;
    }

    public IDbgpBreakpoint getDbgpBreakpoint(String id) {
        try {
            return this.session.getCoreCommands().getBreakpoint(id);
        }
        catch (DbgpException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public IScriptStreamProxy getStreamProxy() {
        return this.target.getStreamProxy();
    }

    public IDebugTarget getDebugTarget() {
        return this.target.getDebugTarget();
    }

    public IScriptEvaluationEngine getEvaluationEngine() {
        if (this.evalEngine == null) {
            this.evalEngine = new ScriptEvaluationEngine(this);
        }
        return this.evalEngine;
    }

    public void objectTerminated(Object object, Exception e) {
        this.terminated = true;
        Assert.isTrue((object == this.session ? 1 : 0) != 0);
        HotCodeReplaceManager.getDefault().removeHotCodeReplaceListener(this);
        this.manager.terminateThread(this);
    }

    public String toString() {
        return "Thread (" + this.session.getInfo().getThreadId() + ")";
    }

    public void notifyModified() {
        this.stateManager.notifyModified();
    }

    public void hotCodeReplaceFailed(IScriptDebugTarget target, DebugException exception) {
        if (this.isSuspended()) {
            this.stack.updateFrames();
            DebugEventHelper.fireChangeEvent(this);
        }
    }

    public void hotCodeReplaceSucceeded(IScriptDebugTarget target) {
        if (this.isSuspended()) {
            this.stack.updateFrames();
            DebugEventHelper.fireChangeEvent(this);
        }
    }

    public int getPropertyPageSize() {
        return this.propertyPageSize;
    }

    public boolean retrieveGlobalVariables() {
        return this.target.retrieveGlobalVariables();
    }

    public boolean retrieveClassVariables() {
        return this.target.retrieveClassVariables();
    }

    public boolean retrieveLocalVariables() {
        return this.target.retrieveLocalVariables();
    }

    public void updateStackFrames() {
        this.stack.updateFrames();
        DebugEventHelper.fireChangeEvent((IDebugElement)this.getDebugTarget());
    }

    void updateStack() {
        this.stack.update(true);
    }

    boolean isValidStack() {
        return this.session.getDebugOptions().isValidStack(this.stack.getFrames());
    }
}

